local assets =
{
   Asset("ANIM", "anim/yinkong_fx.zip"),
}

local MAX_LIGHT_FRAME = 6

local function kill_fx(inst)
    inst:DoTaskInTime(0, inst.Remove)
end

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()

    inst.Transform:SetScale(0.5,0.5,0.5)

    inst.AnimState:SetBank("yinkong_fx")
    inst.AnimState:SetBuild("yinkong_fx")
    inst.AnimState:PlayAnimation("lunar_3_loop")
    inst.AnimState:PushAnimation("lunar_3_loop", true)
    inst.AnimState:SetBloomEffectHandle("shaders/anim.ksh")
        
    inst.entity:SetPristine()

    inst.kill_fx = kill_fx

    return inst
end

return Prefab("yinkong_fx", fn, assets)
