
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),

        Asset( "ANIM", "anim/zhuikong.zip" ),
        Asset( "ANIM", "anim/zhuikongmad.zip" ),
        Asset( "ANIM", "anim/zhuikong_newyear.zip" ),
        Asset( "ANIM", "anim/ghost_zhuikong_build.zip" ),
        Asset( "IMAGE", "images/saveslot_portraits/zhuikong.tex" ),
        Asset( "ATLAS", "images/saveslot_portraits/zhuikong.xml" ),

        Asset( "IMAGE", "images/selectscreen_portraits/zhuikong.tex" ),
        Asset( "ATLAS", "images/selectscreen_portraits/zhuikong.xml" ),
        
        Asset( "IMAGE", "images/selectscreen_portraits/zhuikong_silho.tex" ),
        Asset( "ATLAS", "images/selectscreen_portraits/zhuikong_silho.xml" ),

        Asset( "IMAGE", "bigportraits/zhuikong.tex" ),
        Asset( "ATLAS", "bigportraits/zhuikong.xml" ),
        
        Asset( "IMAGE", "images/map_icons/zhuikong.tex" ),
        Asset( "ATLAS", "images/map_icons/zhuikong.xml" ),
        
        Asset( "IMAGE", "images/avatars/avatar_zhuikong.tex" ),
        Asset( "ATLAS", "images/avatars/avatar_zhuikong.xml" ),
        
        Asset( "IMAGE", "images/avatars/avatar_ghost_zhuikong.tex" ),
        Asset( "ATLAS", "images/avatars/avatar_ghost_zhuikong.xml" ),
}
local prefabs = {}
local start_inv = {
        "zhuikongsword",
        "memorymetal_z",
}

STRINGS.CHARACTERS.GENERIC.DESCRIBE.ESCTEMPLATE = 
{
        GENERIC = "It's Esc!",
        ATTACKER = "That Esc looks shifty...",
        MURDERER = "Murderer!",
        REVIVER = "Esc, friend of ghosts.",
        GHOST = "Esc could use a heart.",
}

local function onbecamehuman(inst)
    if inst.components and inst.components.exp then
        inst.components.exp:ApplyUpgrades()
    end
end

local function onload(inst, data)
    inst:ListenForEvent("ms_respawnedfromghost", onbecamehuman)
    if inst.components and inst.components.exp then
        inst.components.exp:ApplyUpgrades()
    end
end

local function onkill(inst, data)
    local victim = data.victim
    inst.components.sanity:DoDelta(5)
    if victim:HasTag("epic") then
        inst.components.exp:DoDelta(TUNING.EXP_EPIC)
        if victim:HasTag("dragonfly")  or victim:HasTag("toadstool") or victim:HasTag("bee") then
            inst.components.exp:DoDelta(TUNING.EXP_HUGE)
        end
    end
end

local function onbuilditem(inst, data)
    if inst.components.exp.levelpoint < 1 then
        return
    end
    local item = data.item
    local critical = math.random(1,100)
    local pt = inst:GetPosition()
    print("I build "..item.prefab)
    if item.components.trap then
        item.components.trap.range = item.components.trap.range * 1.5
        if critical >= 40 then
            local addt_prod = SpawnPrefab(item.prefab)
            addt_prod.components.trap.range = 2
            inst.components.inventory:GiveItem(addt_prod, nil, pt)
        end
    end
    if item.components.mine then
        item.components.mine:SetRadius(TUNING.TRAP_TEETH_RADIUS*1.5)
        if critical >= 40 then
            local addt_prod = SpawnPrefab(item.prefab)
            item.components.mine:SetRadius(TUNING.TRAP_TEETH_RADIUS*1.5)
            inst.components.inventory:GiveItem(addt_prod, nil, pt)
        end
    end
end

local function attackother(inst, _leader)
    if _leader.components.exp.levelpoint < 4 then return end
    if _leader:HasTag("zhuikongmad") then
        local target = FindEntity(_leader, 32, function(guy) return guy.components.health end, { "_combat" },{"ruikong", "yinkong"})
        if target ~= nil then
            local damage = 10
            local item = _leader.components.inventory:GetEquippedItem(EQUIPSLOTS.HANDS)
            if item and item.components.weapon then
                damage = item.components.weapon.damage
            end
            damage = damage * _leader.components.combat.damagemultiplier * 2
            target.components.health:DoDelta(-damage)
            target:PushEvent("attacked", { attacker = _leader, damage = 0 })
        end
    end
end

local function Onsanitydelta(inst, data)
    if inst.components.exp.levelpoint < 4 then return end
    if data.newpercent <= 0.15 and not inst:HasTag("zhuikongmad") then
        --print("Mission start")
        inst.AnimState:AddOverrideBuild("zhuikongmad")
        inst:AddTag("zhuikongmad")
    end
    if data.newpercent > 0.15 and inst.attacktask ~= nil then
        --print("Mission Cancel")
        inst.AnimState:ClearOverrideBuild("zhuikongmad")
        inst:RemoveTag("zhuikongmad")
    end
end

local common_postinit = function(inst) 
	inst.MiniMapEntity:SetIcon( "zhuikong.tex" )
    inst:AddTag("zhuikong")
end

local function AuraFn(inst, observer)
    if observer:HasTag("ruikong") then
        return TUNING.SANITYAURA_FAMILY/2
    elseif observer:HasTag("yinkong") then
        return TUNING.SANITYAURA_FAMILY
    end
    return 0
end

local master_postinit = function(inst)
	inst.soundsname = "waxwell"
	inst.components.health:SetMaxHealth(150)
	inst.components.hunger:SetMax(150)
	inst.components.sanity:SetMax(320)
    inst.components.sanity.penalty = 0.25
    inst.components.sanity.rate_modifier = 0.5
	inst.components.combat.damagemultiplier = 0.75

    inst:AddComponent("sanityaura")
    inst.components.sanityaura.aurafn = AuraFn

    inst.modskin = "zhuikong"
    inst.components.eater.ignoresspoilage = true
    inst:ListenForEvent("killed",onkill)
    inst:ListenForEvent("builditem",onbuilditem)
    inst:ListenForEvent("sanitydelta",Onsanitydelta)
    inst.OnLoad = onload
    inst.attacktask = inst:DoPeriodicTask(10, attackother, nil, inst)

end

STRINGS.CHARACTER_TITLES.zhuikong= "赵缀空"
STRINGS.CHARACTER_NAMES.zhuikong= "赵缀空"
STRINGS.CHARACTER_DESCRIPTIONS.zhuikong= "*等级重置找回了理智\n*沉迷装鶸不想升级"
STRINGS.CHARACTER_QUOTES.zhuikong= "感情是负累，器量不够就去死吧。"
STRINGS.CHARACTERS.ZHUIKONG= require "speech_zhuikong"
STRINGS.NAMES.ZHUIKONG = "赵缀空"

return MakePlayerCharacter("zhuikong", prefabs, assets, common_postinit, master_postinit, start_inv)