local skins = {}
for k,v in pairs(ZHUIKONGSKINS.ZHUIKONG) do
	local assets = {}
	for skin,anim in pairs(v.builds) do
		table.insert(assets, anim)
	end
	if SKIN_RARITY_COLORS.ModMade ~= nil then table.insert(skins, AddModCharacterSkin("zhuikong", k, v.builds, assets, {"ZHUIKONG", "CHARACTER"}, v.options)) end
end

return CreatePrefabSkin("zhuikong_none", {
	base_prefab = "zhuikong",
	skins = {
		normal_skin = "zhuikong",
		ghost_skin = "ghost_zhuikong_build",
		--dzhuikong_skin = "dzhuikong"
	},
	assets = {
		Asset( "ANIM", "anim/zhuikong.zip" ),
		Asset( "ANIM", "anim/ghost_zhuikong_build.zip" ),
		--Asset( "ANIM", "anim/dzhuikong.zip" )
	},
	tags = {"ZHUIKONG", "CHARACTER"},
	skip_item_gen = true,
	skip_giftable_gen = true,
}), unpack(skins)