local assets =
{
    Asset("ANIM", "anim/zhuikongsword.zip"),
    Asset("ANIM", "anim/swap_zhuikongsword.zip"),
    Asset("IMAGE", "images/inventoryimages/zhuikongsword.tex"),
    Asset("ATLAS", "images/inventoryimages/zhuikongsword.xml"),
}

local function onattack(inst, attacker, target)
    if inst.components.fueled:IsEmpty() then
        return false
    else
        inst.components.fueled:DoDelta(-TUNING.LARGE_FUEL/50)
    end
    attacker.components.health:DoDelta(TUNING.ZHUIKONG_ATTACKHEALTH)
    local critical = math.random(1,100)
    if critical >= 70 then
        attacker.components.sanity:DoDelta(TUNING.ZHUIKONG_ATTACKSANITY)
    end
end

local function turnon(inst)
    local owner = inst.components.inventoryitem ~= nil and inst.components.inventoryitem.owner or nil
    if inst.components.fueled:IsEmpty() then
        return
    end
    --do something
end

    local function onequip(inst, owner)
        owner.AnimState:OverrideSymbol("swap_object", "swap_zhuikongsword", "zhuikongsword")
        owner.AnimState:Show("ARM_carry")
        owner.AnimState:Hide("ARM_normal")
    end

    local function onunequip(inst, owner)
        owner.AnimState:Hide("ARM_carry")
        owner.AnimState:Show("ARM_normal")
    end

local function nofuel(inst)
    inst.components.weapon:SetDamage(10)
end

local function ontakefuel(inst)
    inst.components.weapon:SetDamage(TUNING.ZHUIKONGSWORD_DAMAGE)
    turnon(inst)
end

    local function simple(name)
        local inst = CreateEntity()

        inst.entity:AddTransform()
        inst.entity:AddAnimState()
        inst.entity:AddNetwork()
        --inst.entity:AddLight()

        MakeInventoryPhysics(inst)

        inst.AnimState:SetBank(name)
        inst.AnimState:SetBuild(name)
        inst.AnimState:PlayAnimation("idle")
        --[[inst.AnimState:SetBloomEffectHandle("shaders/anim.ksh")

        inst.Light:SetFalloff(0.7)
        inst.Light:SetIntensity(.5)
        inst.Light:SetRadius(0.5)
        inst.Light:SetColour(237/255, 237/255, 209/255)
        inst.Light:Enable(true)]]

        inst.entity:SetPristine()

        if not TheWorld.ismastersim then
            return inst
        end

        inst:AddComponent("weapon")

        inst:AddComponent("inspectable")

        inst:AddComponent("fueled")
        inst.components.fueled.fueltype = FUELTYPE.NIGHTMARE
        inst.components.fueled:InitializeFuelLevel(2 * TUNING.LARGE_FUEL)
        inst.components.fueled:SetDepletedFn(nofuel)
        inst.components.fueled:SetTakeFuelFn(ontakefuel)
        inst.components.fueled.accepting = true

        inst:AddComponent("inventoryitem")
        inst.components.inventoryitem.atlasname = "images/inventoryimages/"..name..".xml"
        inst.components.inventoryitem.imagename = name

        inst:AddComponent("equippable")
        inst.components.equippable:SetOnEquip(onequip)
        inst.components.equippable:SetOnUnequip(onunequip)

        MakeHauntableLaunch(inst)

        inst.OnLoad = function(inst,data) 
            if inst.components.fueled:IsEmpty() then
                nofuel(inst)
            end
        end

        return inst
    end
local function fn()
        local inst = simple("zhuikongsword")

        if not TheWorld.ismastersim then
            return inst
        end
    inst.components.weapon:SetDamage(TUNING.ZHUIKONGSWORD_DAMAGE)
    inst.components.weapon:SetOnAttack(onattack)

    return inst
end
STRINGS.NAMES.ZHUIKONGSWORD= "吸血鬼之触"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.ZHUIKONGSWORD= "呃……它好像坏掉了"
return Prefab( "zhuikongsword", fn, assets)