/*
 * Decompiled with CFR 0.152.
 */
package CustomOreGen.Client;

import CustomOreGen.Client.GeometryRenderer;
import CustomOreGen.CustomOreGenBase;
import CustomOreGen.CustomPacketPayload;
import CustomOreGen.GeometryData;
import CustomOreGen.GeometryRequestData;
import CustomOreGen.Util.GeometryStream;
import CustomOreGen.Util.IGeometryBuilder;
import CustomOreGen.Util.Transform;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class ClientState {
    public static WireframeRenderMode dgRenderingMode = WireframeRenderMode.WIREFRAMEOVERLAY;
    public static boolean dgEnabled = true;
    private static World _world = null;
    private static int _dgScanCounter = 0;
    private static int _dgBatchID = 0;
    @SideOnly(value=Side.CLIENT)
    private static Map<Long, Integer> _dgListMap = new HashMap<Long, Integer>();
    @SideOnly(value=Side.CLIENT)
    private static Set _chunkDGRequests = new HashSet();
    @SideOnly(value=Side.CLIENT)
    private static IntBuffer _chunkDGListBuffer = null;

    @SideOnly(value=Side.CLIENT)
    public static void onRenderWorld(Entity cameraPOV, double partialTicks) {
        if (_world != null && dgEnabled && dgRenderingMode != null && dgRenderingMode != WireframeRenderMode.NONE) {
            double posX = cameraPOV.field_70142_S + (cameraPOV.field_70165_t - cameraPOV.field_70142_S) * partialTicks;
            double posY = cameraPOV.field_70137_T + (cameraPOV.field_70163_u - cameraPOV.field_70137_T) * partialTicks;
            double posZ = cameraPOV.field_70136_U + (cameraPOV.field_70161_v - cameraPOV.field_70136_U) * partialTicks;
            if (_dgScanCounter == 0) {
                _dgScanCounter = 60;
                int scanRange = 16;
                int maxRequest = 50 - _chunkDGRequests.size() * 20;
                int chunkX = (int)posX / 16;
                int chunkZ = (int)posZ / 16;
                for (int r = 0; maxRequest > 0 && r <= scanRange; ++r) {
                    int iX = chunkX - r;
                    int iZ = chunkZ - r;
                    for (int i = 0; maxRequest > 0 && i <= r * 8; ++i) {
                        if (i < r * 2) {
                            ++iX;
                        } else if (i < r * 4) {
                            ++iZ;
                        } else if (i < r * 6) {
                            --iX;
                        } else if (i < r * 8) {
                            --iZ;
                        } else if (r != 0) continue;
                        long key = (long)iX << 32 | (long)iZ & 0xFFFFFFFFL;
                        if (_dgListMap.containsKey(key) || !_chunkDGRequests.add(key)) continue;
                        GeometryRequestData request = new GeometryRequestData(_world, iX, iZ, _dgBatchID);
                        new CustomPacketPayload(CustomPacketPayload.PayloadType.DebuggingGeometryRequest, request).sendToServer();
                        --maxRequest;
                    }
                }
            } else {
                --_dgScanCounter;
            }
            if (_chunkDGListBuffer != null) {
                GL11.glPushMatrix();
                GL11.glTranslated((double)(-posX), (double)(-posY), (double)(-posZ));
                GL11.glDisable((int)2884);
                GL11.glDisable((int)3553);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                if (dgRenderingMode == WireframeRenderMode.WIREFRAMEOVERLAY) {
                    GL11.glDisable((int)2929);
                }
                if (dgRenderingMode != WireframeRenderMode.POLYGON) {
                    GL11.glPolygonMode((int)1032, (int)6913);
                }
                _chunkDGListBuffer.rewind();
                GL11.glCallLists((IntBuffer)_chunkDGListBuffer);
                if (dgRenderingMode != WireframeRenderMode.POLYGON) {
                    GL11.glPolygonMode((int)1032, (int)6914);
                }
                if (dgRenderingMode == WireframeRenderMode.WIREFRAMEOVERLAY) {
                    GL11.glEnable((int)2929);
                }
                GL11.glDisable((int)3042);
                GL11.glEnable((int)3553);
                GL11.glEnable((int)2884);
                GL11.glPopMatrix();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean hasWorldChanged(World currentWorld) {
        return _world != currentWorld;
    }

    @SideOnly(value=Side.CLIENT)
    public static void onWorldChanged(World currentWorld) {
        _world = currentWorld;
        CustomOreGenBase.log.debug("Client world changed to " + (_world == null ? null : _world.func_72912_H().func_76065_j()));
        ClientState.clearDebuggingGeometry();
    }

    @SideOnly(value=Side.CLIENT)
    public static void addDebuggingGeometry(GeometryData geometryData) {
        if (_world != null && geometryData.batchID == _dgBatchID && geometryData.dimensionID == ClientState._world.field_73011_w.field_76574_g) {
            GeometryRenderer renderer = new GeometryRenderer();
            try {
                for (GeometryStream key : geometryData.geometry) {
                    key.executeStream(renderer);
                }
            }
            catch (GeometryStream.GeometryStreamException var8) {
                throw new RuntimeException(var8);
            }
            int var9 = GL11.glGenLists((int)1);
            if (var9 != 0) {
                GL11.glNewList((int)var9, (int)4864);
                renderer.setPositionTransform(new Transform().translate(geometryData.chunkX * 16 + 8, -1.0f, geometryData.chunkZ * 16 + 8).scale(7.5f, 1.0f, 7.5f));
                renderer.setColor(new float[]{0.0f, 1.0f, 0.0f, 0.15f});
                renderer.setVertexMode(IGeometryBuilder.PrimitiveType.LINE, 1);
                renderer.addVertex(new float[]{-1.0f, 0.0f, -1.0f});
                renderer.addVertex(new float[]{-1.0f, 0.0f, 1.0f});
                renderer.addVertex(new float[]{1.0f, 0.0f, 1.0f});
                renderer.addVertex(new float[]{1.0f, 0.0f, -1.0f});
                renderer.addVertexRef(4);
                renderer.draw();
                GL11.glEndList();
                long var10 = (long)geometryData.chunkX << 32 | (long)geometryData.chunkZ & 0xFFFFFFFFL;
                Integer curValue = _dgListMap.get(var10);
                if (curValue != null && curValue != 0) {
                    for (int limit = 0; limit < _chunkDGListBuffer.limit(); ++limit) {
                        if (_chunkDGListBuffer.get(limit) != curValue.intValue()) continue;
                        _chunkDGListBuffer.put(limit, var9);
                        break;
                    }
                    GL11.glDeleteLists((int)curValue, (int)1);
                } else if (_chunkDGListBuffer == null) {
                    _chunkDGListBuffer = ByteBuffer.allocateDirect(512).order(ByteOrder.nativeOrder()).asIntBuffer();
                    _chunkDGListBuffer.limit(1);
                    _chunkDGListBuffer.put(0, var9);
                } else {
                    int limit = _chunkDGListBuffer.limit();
                    if (limit == _chunkDGListBuffer.capacity()) {
                        IntBuffer oldBuffer = _chunkDGListBuffer;
                        _chunkDGListBuffer = ByteBuffer.allocateDirect(limit * 8).order(ByteOrder.nativeOrder()).asIntBuffer();
                        oldBuffer.rewind();
                        _chunkDGListBuffer.put(oldBuffer);
                    }
                    _chunkDGListBuffer.limit(limit + 1);
                    _chunkDGListBuffer.put(limit, var9);
                }
                _dgListMap.put(var10, var9);
                _chunkDGRequests.remove(var10);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void clearDebuggingGeometry() {
        for (Integer list : _dgListMap.values()) {
            if (list == null || list == 0) continue;
            GL11.glDeleteLists((int)list, (int)1);
        }
        _dgListMap.clear();
        _chunkDGRequests.clear();
        if (_chunkDGListBuffer != null) {
            _chunkDGListBuffer.limit(0);
        }
        dgEnabled = true;
        _dgScanCounter = new Random().nextInt(40);
        ++_dgBatchID;
    }

    public static enum WireframeRenderMode {
        NONE,
        WIREFRAME,
        POLYGON,
        WIREFRAMEOVERLAY;

    }
}

