/*
 * Decompiled with CFR 0.152.
 */
package CustomOreGen;

import CustomOreGen.FMLInterface;
import CustomOreGen.Server.ServerState;
import CustomOreGen.Server.WorldConfig;
import cpw.mods.fml.common.Loader;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import org.apache.logging.log4j.Logger;

public class CustomOreGenBase {
    public static Logger log;
    public static final String OPTIONS_FILENAME = "CustomOreGen_Options.txt";
    public static final String BASE_CONFIG_FILENAME = "CustomOreGen_Config.xml";
    public static final String DEFAULT_BASE_CONFIG_FILENAME = "CustomOreGen_Config_Default.xml";
    private static int _hasMystcraft;

    public static boolean isClassLoaded(String className) {
        try {
            CustomOreGenBase.class.getClassLoader().loadClass(className);
            return true;
        }
        catch (ClassNotFoundException var2) {
            return false;
        }
    }

    public static void onModPostLoad() {
        CustomOreGenBase.unpackConfigs();
        CustomOreGenBase.hasMystcraft();
    }

    private static void unpackConfigs() {
        File configPath = CustomOreGenBase.getConfigDir();
        File modulesDir = new File(configPath, "modules");
        File defaultModulesDir = new File(modulesDir, "default");
        if (defaultModulesDir.exists()) {
            File[] defaultModules = defaultModulesDir.listFiles();
            for (File defaultModule : defaultModules) {
                defaultModule.delete();
            }
        } else {
            configPath.mkdir();
            modulesDir.mkdir();
            defaultModulesDir.mkdir();
        }
        String[] extraModules = new String[]{"ExtraCaves.xml", "MinecraftOres.xml", "IndustrialCraft2.xml", "Forestry.xml", "ProjectRed.xml", "TinkersConstruct.xml", "Dartcraft.xml", "Metallurgy.xml", "Railcraft.xml", "Thaumcraft4.xml", "BiomesOPlenty.xml", "Factorization.xml", "ThermalExpansion.xml", "SimpleOres2.xml", "Galacticraft.xml", "Chisel.xml"};
        for (String module : extraModules) {
            CustomOreGenBase.unpackConfigFile("modules/" + (String)module, new File(defaultModulesDir, module));
        }
        new File(modulesDir, "custom").mkdir();
        CustomOreGenBase.unpackConfigFile(DEFAULT_BASE_CONFIG_FILENAME, new File(configPath, DEFAULT_BASE_CONFIG_FILENAME));
        CustomOreGenBase.loadWorldConfig();
    }

    private static WorldConfig loadWorldConfig() {
        WorldConfig config = null;
        while (config == null) {
            try {
                config = new WorldConfig();
            }
            catch (Exception e) {
                if (!ServerState.onConfigError(e)) break;
                config = null;
            }
        }
        return config;
    }

    public static boolean unpackConfigFile(String configName, File destination) {
        String resourceName = "config/" + configName;
        try {
            int len1;
            InputStream ex = CustomOreGenBase.class.getClassLoader().getResourceAsStream(resourceName);
            BufferedOutputStream streamOut = new BufferedOutputStream(new FileOutputStream(destination));
            byte[] buffer = new byte[1024];
            boolean len = false;
            while ((len1 = ex.read(buffer)) >= 0) {
                streamOut.write(buffer, 0, len1);
            }
            ex.close();
            streamOut.close();
            return true;
        }
        catch (Exception var6) {
            throw new RuntimeException("Failed to unpack resource '" + resourceName + "'", var6);
        }
    }

    public static File getConfigDir() {
        return new File(Loader.instance().getConfigDir(), "CustomOreGen");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasMystcraft() {
        if (_hasMystcraft == 0) {
            try {
                _hasMystcraft = -1;
                if (!Loader.isModLoaded((String)"Mystcraft")) {
                    // empty if block
                }
            }
            catch (Throwable var1) {
                log.error("COG Mystcraft interface appears to be incompatible with the installed version of Mystcraft.", var1);
            }
        }
        if (_hasMystcraft != 1) return false;
        return true;
    }

    public static String getDisplayString() {
        return FMLInterface.getDisplayString();
    }

    static {
        _hasMystcraft = 0;
    }
}

