Scriptname AmiellaBUEffectScript extends activemagiceffect

Armor Property BURing Auto

Armor Property EquipStage1 Auto
Armor Property EquipStage2 Auto
Armor Property EquipStage3 Auto

Int nowStage = 1

Actor target

Event OnEffectStart(Actor akTarget, Actor akCaster)
	target = akTarget
	
	target.EquipItem(EquipStage1, False, True)
	
	RegisterForSingleUpdate(0)
endEvent

Event OnUpdate()
	If (nowStage != 1 && 0.66 < target.GetActorValuePercentage("health"))
		target.EquipItem(EquipStage1, False, True)
		target.RemoveItem(EquipStage2, target.GetItemCount(EquipStage2), True)
		target.RemoveItem(EquipStage3, target.GetItemCount(EquipStage3), True)
		
		nowStage = 1
	ElseIf (nowStage != 2 && 0.33 < target.GetActorValuePercentage("health") && target.GetActorValuePercentage("health") <= 0.66)
		target.EquipItem(EquipStage2, False, True)
		target.RemoveItem(EquipStage1, target.GetItemCount(EquipStage1), True)
		target.RemoveItem(EquipStage3, target.GetItemCount(EquipStage3), True)
		
		nowStage = 2
	ElseIf (nowStage != 3 && target.GetActorValuePercentage("health") <= 0.33)
		target.EquipItem(EquipStage3, False, True)
		target.RemoveItem(EquipStage1, target.GetItemCount(EquipStage1), True)
		target.RemoveItem(EquipStage2, target.GetItemCount(EquipStage2), True)
		
		nowStage = 3
	EndIf
	
	If (!target.IsEquipped(BURing))
		self.Dispel()
	EndIf
	
	RegisterForSingleUpdate(0)
EndEvent

Event OnEffectFinish(Actor akTarget, Actor akCaster)
	target.UnequipItem(EquipStage1, False, True)
	target.UnequipItem(EquipStage2, False, True)
	target.UnequipItem(EquipStage3, False, True)
	
	target.RemoveItem(EquipStage1, target.GetItemCount(EquipStage1), True)
	target.RemoveItem(EquipStage2, target.GetItemCount(EquipStage2), True)
	target.RemoveItem(EquipStage3, target.GetItemCount(EquipStage3), True)
EndEvent
