-- GLOBAL.CHEATS_ENABLED = true
-- GLOBAL.require( 'debugkeys' )

function modBoomerang(inst)
    
    local uses = GetModConfigData("uses")
    local damage = GetModConfigData("damage")
    local autocatch = GetModConfigData("autocatch")
    local fastcatch = GetModConfigData("fastcatch")
    local bugfix = GetModConfigData("bugfix")
    
    if uses == 0 then    
        inst:RemoveComponent("finiteuses")
    else
        inst.components.finiteuses:SetMaxUses(uses)
        inst.components.finiteuses:SetUses(uses)
    end
    
    if damage == 1 then
        inst.components.weapon:SetDamage(TUNING.SPEAR_DAMAGE)
    elseif damage == 2 then
        inst.components.weapon:SetDamage(TUNING.SPIKE_DAMAGE)
    elseif damage == 3 then
        inst.components.weapon:SetDamage(TUNING.HAMBAT_DAMAGE)
    elseif damage == 4 then
        inst.components.weapon:SetDamage(TUNING.NIGHTSWORD_DAMAGE)
    elseif damage == 5 then
        inst.components.weapon:SetDamage(TUNING.SPEAR_DAMAGE * 1000)
    end
    
    local oldhit = inst.components.projectile.Hit
    local oldmiss = inst.components.projectile.Miss
    local oldupdate = inst.components.projectile.OnUpdate
    local oldcatch = inst.components.projectile.Catch
    
    local drop_timeout = 3
    
    function inst.components.projectile:Hit(target)
        -- print(GLOBAL.APP_VERSION)
        -- fast catch: prevent catching lag when character running
        if fastcatch and target == self.owner and target.components.catcher 
                and target.sg.sg.states["catch"].tags["busy"] then
            -- for k, v in pairs(target.sg.sg.states["catch"].tags) do
            --    print(k, v)
            -- end
            target.sg.sg.states["catch"].tags["busy"] = nil
        end
    
        if autocatch and target == self.owner and target.components.catcher then
            if autocatch == "drop" then
                if self.homing then
                    -- print("Stop homing")
                    self:SetHoming(false)
                end    
            else
                -- the former method will cause the character to stop awhile when catching
                target.components.catcher:PrepareToCatch()
                
                -- old method:
                -- target:PushEvent("catch", {projectile = self.inst}) 
                -- self.inst:PushEvent("caught", {catcher = target})
                -- self:Catch(target)
                -- target.components.catcher:StopWatching(self.inst)
            end
        else
            oldhit(self, target)
            if self.target == self.owner then
                if bugfix then
                    -- remove the defered StopUpdatingComponent to fix Boomerang bug
                    GLOBAL.StopUpdatingComponents[self] = nil
                end
                if not self._returning and autocatch == "drop" then
                    -- print("Returning..")
                    self._returning = true
                    self._original_speed = self.speed
                    self._timeout = drop_timeout
                end
            end  
            
        end
        
    end
    
    function inst.components.projectile:Miss(target)
        oldmiss(self, target)
        if self.target == self.owner then
            if bugfix then
                GLOBAL.StopUpdatingComponents[self] = nil
            end
            if not self._returning and autocatch == "drop" then
                -- print("Returning..")
                self._returning = true
                self._original_speed = self.speed
                self._timeout = drop_timeout
            end
        end
    end
    
    -- there is a bug for non-homing projectiles on caught, walk it around
    function inst.components.projectile:OnUpdate(dt)
        if self.target then
            oldupdate(self, dt)
        else
            -- print("Alert!")    
        end
        
        if self._returning and autocatch == "drop" then
            self._timeout = self._timeout - dt
            if self._original_speed then
                self.speed = self._timeout / drop_timeout * self._original_speed
                self.inst.Physics:SetMotorVel(self.speed, 0, 0)
                -- print("Speed=", self.speed)
            end
            if self._timeout < drop_timeout / 3 then
                -- print("Drop!")
                self:_ResetStatus()
                self:Stop()
                self.inst.Physics:Stop()
                self.inst.AnimState:PlayAnimation("idle")
            end
        end
    end
    
    function inst.components.projectile:Catch(catcher)
        if autocatch == "drop" and self._returning then
            self:_ResetStatus()
        end
        oldcatch(self, catcher)
    end
    
    function inst.components.projectile:_ResetStatus()
        self._returning = false
        self._timeout = nil
        
        if not self.homing then
            self:SetHoming(true)
        end

        if self._original_speed then
            self.speed = self._original_speed
            self.inst.Physics:SetMotorVel(self.speed, 0, 0)
        end
    end
    
end

AddPrefabPostInit("boomerang", modBoomerang)
AddPrefabPostInit("bonerang", modBoomerang)
