require "behaviours/chaseandattack"
require "behaviours/runaway"
require "behaviours/wander"
require "behaviours/doaction"
require "behaviours/avoidlight"
require "behaviours/panic"
require "behaviours/attackwall"
require "behaviours/useshield"

local RUN_AWAY_DIST = 10
local SEE_FOOD_DIST = 10
local SEE_TARGET_DIST = 6

local MIN_FOLLOW_DIST = 2
local TARGET_FOLLOW_DIST = 3
local MAX_FOLLOW_DIST = 6

local TRADE_DIST = 20

local MAX_CHASE_DIST = 20
local MAX_CHASE_TIME = 10
local MAX_WANDER_DIST = 20

local START_RUN_DIST = 8
local STOP_RUN_DIST = 12

local WonkyskeletonBrain = Class(Brain, function(self, inst)
    Brain._ctor(self, inst)
end)

local function GetTraderFn(inst)
    if inst.components.trader then
        return FindEntity(inst, TRADE_DIST, function(target) return inst.components.trader:IsTryingToTradeWithMe(target) end, {"player"})
    end
end

local function KeepTraderFn(inst, target)
    if inst.components.trader then
        return inst.components.trader:IsTryingToTradeWithMe(target)
    end
end

-- local function EatFoodAction(inst)

    -- local target = FindEntity(inst, SEE_FOOD_DIST, function(item) return inst.components.eater:CanEat(item) and item:IsOnValidGround() and item:GetTimeAlive() > TUNING.SPIDER_EAT_DELAY end)
    -- if target then
        -- return BufferedAction(inst, target, ACTIONS.EAT)
    -- end
-- end

local function GoHomeAction(inst)
    if inst.components.combat.target ~= nil then
        return
    end
    local homePos = inst.components.knownlocations:GetLocation("home")
    return homePos ~= nil
        and BufferedAction(inst, nil, ACTIONS.WALKTO, nil, homePos, nil, .2)
        or nil
end

-- local function InvestigateAction(inst)
    -- local investigatePos = inst.components.knownlocations and inst.components.knownlocations:GetLocation("investigate")
    -- if investigatePos then
        -- return BufferedAction(inst, nil, ACTIONS.INVESTIGATE, nil, investigatePos, nil, 1)
    -- end
-- end

local function GetFaceTargetFn(inst)
    return inst.components.follower.leader
end

local function KeepFaceTargetFn(inst, target)
    return inst.components.follower.leader == target
end

local function ShouldGoHome(inst)
    if inst.components.follower ~= nil and inst.components.follower.leader ~= nil then
        return false
    end
    local homePos = inst.components.knownlocations:GetLocation("home")
    return homePos ~= nil and inst:GetDistanceSqToPoint(homePos:Get()) > MAX_WANDER_DIST * MAX_WANDER_DIST
end

local function SwitchAttackMode(inst)
	if inst:IsValid() and inst.components.health and not inst.components.health:IsDead() then
		inst:GetNewWSWeapon()
	end
end

function WonkyskeletonBrain:OnStart()
    local root =
        PriorityNode(
        {
            -- WhileNode( function() return self.inst.components.hauntable and self.inst.components.hauntable.panic end, "PanicHaunted", Panic(self.inst)),
            -- WhileNode( function() return self.inst.components.health.takingfiredamage end, "OnFire", Panic(self.inst)),
			IfNode( function() return self.inst.components.combat and self.inst.components.combat.target ~= nil and 
										self.inst.components.inventory and self.inst.components.inventory:GetEquippedItem(EQUIPSLOTS.HANDS) == nil and GetTime() > self.inst.nextranged end, 
						"SwitchAttackMode",
						DoAction( self.inst, function() return SwitchAttackMode(self.inst) end ) ),
			ChaseAndAttack(self.inst, MAX_CHASE_TIME),	
			Follow(self.inst, function() return self.inst.components.follower.leader end, MIN_FOLLOW_DIST, TARGET_FOLLOW_DIST, MAX_FOLLOW_DIST),
            IfNode(function() return self.inst.components.follower.leader ~= nil end, "HasLeader",
				FaceEntity(self.inst, GetFaceTargetFn, KeepFaceTargetFn )),   			
            -- DoAction(self.inst, function() return InvestigateAction(self.inst) end ),
            WhileNode(function() return ShouldGoHome(self.inst) end, "TooFarFromHome",
						DoAction(self.inst, function() return GoHomeAction(self.inst) end ) ),
            FaceEntity(self.inst, GetTraderFn, KeepTraderFn),
            WhileNode(function() return self.inst.components.follower and self.inst.components.follower.leader == nil and self.inst.leaderID ~= nil end, "WaitingForLeaderWandering",
						Wander(self.inst, function() return self.inst.components.knownlocations:GetLocation("lastleaderloc") end, MAX_WANDER_DIST/6) ),  
            WhileNode(function() return not (TheWorld.state.isnight or TheWorld.state.isdusk) end, "DayWandering",
						Wander(self.inst, function() return self.inst.components.knownlocations:GetLocation("home") end, MAX_WANDER_DIST/4) ),         
            WhileNode(function() return TheWorld.state.isnight or TheWorld.state.isdusk end, "NightWandering",
						Wander(self.inst, function() return self.inst.components.knownlocations:GetLocation("home") end, MAX_WANDER_DIST) ),  						
        },1)
      
    self.bt = BT(self.inst, root)
end

function WonkyskeletonBrain:OnInitializationComplete()
    self.inst.components.knownlocations:RememberLocation("home", Point(self.inst.Transform:GetWorldPosition()))
end

return WonkyskeletonBrain
