PrefabFiles = {
	"kasen", "lightorb", "medicinebox", "stafflight3", "kasen_none",
}

Assets = {
    Asset( "IMAGE", "images/saveslot_portraits/kasen.tex" ),
    Asset( "ATLAS", "images/saveslot_portraits/kasen.xml" ),

    Asset( "IMAGE", "images/selectscreen_portraits/kasen.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/kasen.xml" ),
	
    Asset( "IMAGE", "images/selectscreen_portraits/kasen_silho.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/kasen_silho.xml" ),

    Asset( "IMAGE", "bigportraits/kasen.tex" ),
    Asset( "ATLAS", "bigportraits/kasen.xml" ),
	
	Asset( "IMAGE", "images/map_icons/kasen.tex" ),
	Asset( "ATLAS", "images/map_icons/kasen.xml" ),
	
	Asset( "IMAGE", "images/avatars/avatar_kasen.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_kasen.xml" ),
	
	Asset( "IMAGE", "images/avatars/avatar_ghost_kasen.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_ghost_kasen.xml" ),
	
	Asset( "IMAGE", "bigportraits/kasen_none.tex" ),
    Asset( "ATLAS", "bigportraits/kasen_none.xml" ),
	
	Asset( "IMAGE", "images/names_kasen.tex" ),
    Asset( "ATLAS", "images/names_kasen.xml" ),

}

local require = GLOBAL.require
local STRINGS = GLOBAL.STRINGS

AddComponentPostInit("follower", function(self)
    local old_AddLoyaltyTime = self.AddLoyaltyTime
    function self:AddLoyaltyTime(time) -- overrides AddLoyaltyTime of follower component
        old_AddLoyaltyTime(self, time)
        if self.leader and self.leader.prefab == "kasen" then
            self.task:Cancel() -- if leader is your character, stops task telling follower to leave player after a while
            self.task = nil
        end
    end
     
    -- same as above, but with LongUpdate
    local old_LongUpdate = self.LongUpdate
    function self:LongUpdate(dt)
        old_LonhUpdate(self, dt)
        if self.leader and self.leader.prefab == "kasen" then
            self.task:Cancel()
            self.task = nil
        end
    end

end)

local function RecheckForThreat(inst)
    local busy = inst.sg:HasStateTag("sleeping") or inst.sg:HasStateTag("busy") or inst.sg:HasStateTag("flying")
    if not busy then
        local threat = GLOBAL.FindEntity(inst, 5, nil, nil, {'notarget', 'birdwhisperer'}, {'player', 'monster', 'scarytoprey'})
        return threat ~= nil or GLOBAL.TheWorld.state.isnight
    end
end
 
AddStategraphPostInit("bird", function(sg)
	local old = sg.events.flyaway.fn
	sg.events.flyaway.fn = function(inst)
		if RecheckForThreat(inst) then
			old(inst)
		end
	end
end)

GLOBAL.STRINGS.NAMES.LIGHTORB = "光的天体"
GLOBAL.STRINGS.NAMES.MEDICINEBOX = "茨木华扇的收件箱"
GLOBAL.STRINGS.NAMES.STAFFLIGHT3 = "发光的气球!"

GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.LIGHTORB = "光的天体" 
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.MEDICINEBOX = "茨木华扇的收件箱" 
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.STAFFLIGHT3 = "为什么会发光？" 

-- The character select screen lines
STRINGS.CHARACTER_TITLES.kasen = "茨木华扇"
STRINGS.CHARACTER_NAMES.kasen = "茨木华扇"
STRINGS.CHARACTER_DESCRIPTIONS.kasen = "*能愈合加血\n*能发光\n*更快的回复脑残"
STRINGS.CHARACTER_QUOTES.kasen = "\"我不是一个中二病,不好色!\""

-- Custom speech strings
STRINGS.CHARACTERS.KASEN = require "speech_kasen"

-- The character's name as appears in-game 
STRINGS.NAMES.KASEN = "Kasen"

-- The default responses of examining the character
STRINGS.CHARACTERS.GENERIC.DESCRIBE.KASEN = 
{
	GENERIC = "这是茨木华扇!",
	ATTACKER = "这茨木华扇看起来鬼鬼祟祟的...",
	MURDERER = "凶手!",
	REVIVER = "茨木华扇, 鬼朋友.",
	GHOST = "茨木华扇可以用一颗心.",
}


AddMinimapAtlas("images/map_icons/kasen.xml")

-- Add mod character to mod character list. Also specify a gender. Possible genders are MALE, FEMALE, ROBOT, NEUTRAL, and PLURAL.
AddModCharacter("kasen", "FEMALE")

