local assets=
{
    Asset("ANIM", "anim/lightorb.zip"),
    Asset("ANIM", "anim/swap_lightorb.zip"),
 
    Asset("ATLAS", "images/inventoryimages/lightorb.xml"),
    Asset("IMAGE", "images/inventoryimages/lightorb.tex"),
}
prefabs = {
	"staff",
	"staffcastfx",
    "stafflight3",
}

local function createlight(staff, target, pos)
    local light = SpawnPrefab("stafflight3")
    light.Transform:SetPosition(pos:Get())

    local caster = staff.components.inventoryitem.owner
    if caster ~= nil and caster.components.sanity ~= nil then
        caster.components.sanity:DoDelta(-TUNING.SANITY_SMALL * 0.5)
    end
end

local function yellow_reticuletargetfn()
    return Vector3(ThePlayer.entity:LocalToWorldSpace(5, 0, 0))
end

local function fn()
  
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)

	inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()
	
	inst.AnimState:SetBank("lightorb")
    inst.AnimState:SetBuild("lightorb")
    inst.AnimState:PlayAnimation("idle")

	inst:AddComponent("reticule")
    inst.components.reticule.targetfn = yellow_reticuletargetfn
    inst.components.reticule.ease = true
 
	inst:AddTag("lightorb")
	
    if not TheWorld.ismastersim then
        return inst
    end
	
    local function OnEquip(inst, owner)
        owner.AnimState:OverrideSymbol("swap_object", "swap_lightorb", "swap_lightorb")
        owner.AnimState:Show("ARM_carry")
        owner.AnimState:Hide("ARM_normal")
    end
 
    local function OnUnequip(inst, owner)
        owner.AnimState:Hide("ARM_carry")
        owner.AnimState:Show("ARM_normal")
    end
		
	inst.entity:SetPristine()
     	
	inst.fxcolour = {223/255, 208/255, 69/255}
    inst.castsound = "dontstarve/common/staffteleport"
	 
    inst:AddComponent("inspectable")
     
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "lightorb"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/lightorb.xml"
	     
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( OnEquip )
    inst.components.equippable:SetOnUnequip( OnUnequip )
	inst.components.inventoryitem.keepondeath = true
	
	inst:AddComponent("spellcaster")
    inst.components.spellcaster:SetSpellFn(createlight)
    inst.components.spellcaster.canuseonpoint = true
			
	inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(45)
	
    return inst
end
return  Prefab("common/inventory/lightorb", fn, assets, prefabs)