{ entities [
	;;;;;;;;;;;;;;;;;;; backdrops

	{
		ident { template "backdrop-base" transient #true }
	  	sprite {
	  		atlas backdrop
	  		centerx #true
	  		animations {
	  			default [ { img "bg-ground.png" layer backdropfar } ]
	  		}
	  	}
	}
	{
		ident { template "backdrop-sidewalk" parent "backdrop-base" }
		sprite {
	  		animations {
	  			default [ { img "bg-sidewalk.png" layer emptyfloor } ]
	  		}
		}
	}
	{
		ident { template "backdrop-ground-rock" parent "backdrop-base" }
		sprite {
	  		animations {
	  			default [ 
	  				{ img "ground-rock-1.png" layer backdroprocks }
	  				{ img "ground-rock-2.png" layer backdroprocks }
	  				{ img "ground-rock-3.png" layer backdroprocks }
	  				{ img "ground-rock-1.png" layer backdroprocks hflip #true }
	  				{ img "ground-rock-2.png" layer backdroprocks hflip #true }
	  				{ img "ground-rock-3.png" layer backdroprocks hflip #true }
	  			]
	  		}
		}
	}
	{
		ident { template "backdrop-ground-bedrock" parent "backdrop-base" }
		sprite {
	  		animations {
	  			default [ 
	  				{ img "ground-bedrock-1.png" layer backdroprocks }
	  				{ img "ground-bedrock-2.png" layer backdroprocks }
	  				{ img "ground-bedrock-3.png" layer backdroprocks }
	  				{ img "ground-bedrock-4.png" layer backdroprocks }
	  				{ img "ground-bedrock-1.png" layer backdroprocks hflip #true }
	  				{ img "ground-bedrock-2.png" layer backdroprocks hflip #true }
	  				{ img "ground-bedrock-3.png" layer backdroprocks hflip #true }
	  				{ img "ground-bedrock-4.png" layer backdroprocks hflip #true }
	  			]
	  		}
		}
	}
	{
		ident { template "backdrop-ground-bedrock-small" parent "backdrop-base" }
		sprite {
	  		animations {
	  			default [ 
	  				{ img "ground-bedrock-5.png" layer backdroprocks }
	  				{ img "ground-bedrock-6.png" layer backdroprocks }
	  				{ img "ground-bedrock-5.png" layer backdroprocks hflip #true }
	  				{ img "ground-bedrock-6.png" layer backdroprocks hflip #true }
	  			]
	  		}
		}
	}

	{
		ident { template "backdrop-cloud-base" transient #true }
	  	sprite {
	  		atlas sky
	  		centerx #false
	  	}
	}
	{
		ident { template "backdrop-cloud-large" parent "backdrop-cloud-base" }
		sprite {
	  		animations {
	  			default [ 
	  				{ img "clouds-large-1.png" layer backdropclouds }
	  				{ img "clouds-large-2.png" layer backdropclouds }
	  			]
	  		}
	  	}
	}
	{
		ident { template "backdrop-cloud-medium" parent "backdrop-cloud-base" }
		sprite {
	  		animations {
	  			default [ 
	  				{ img "clouds-medium-1.png" layer backdropclouds }
	  				{ img "clouds-medium-2.png" layer backdropclouds }
	  			]
	  		}
	  	}
	}
	{
		ident { template "backdrop-cloud-small" parent "backdrop-cloud-base" }
		sprite {
	  		animations {
	  			default [ 
	  				{ img "clouds-small-1.png" layer backdropclouds }
	  				{ img "clouds-small-2.png" layer backdropclouds }
	  			]
	  		}
	  	}
	}

	{
		ident { template "backdrop-monster" transient #true }
	  	sprite {
	  		atlas sky
	  		centerx #false
	  		layouts [ "backdrop-monster" ]
	  	}
	}

	{
		ident { template "backdrop-building-base" transient #true }
	}
	{
		ident { template "backdrop-building-one-ground-floor" parent "backdrop-building-base" }
		sprite { atlas backdropbuildings layouts [ "backdrop-building-one-ground-floor" ] }
	}
	{
		ident { template "backdrop-building-one-second-floor" parent "backdrop-building-base" }
		sprite { atlas backdropbuildings layouts [ "backdrop-building-one-second-floor" ] }
	}
	{
		ident { template "backdrop-building-one-repeat-floor" parent "backdrop-building-base" }
		sprite { atlas backdropbuildings layouts [ "backdrop-building-one-repeat-floor" ] }
	}
	{
		ident { template "backdrop-building-one-roof" parent "backdrop-building-base" }
		sprite { atlas backdropbuildings layouts [ "backdrop-building-one-roof" ] }
	}
	{
		ident { template "backdrop-building-one-roof-rear-layers" parent "backdrop-building-base" }
		sprite { atlas backdropbuildings layouts [ "backdrop-building-one-roof-rear-layers" ] }
	}
	{
		ident { template "backdrop-building-two-ground-floor" parent "backdrop-building-base" }
		sprite { atlas backdropbuildings layouts [ "backdrop-building-two-ground-floor" ] }
	}
	{
		ident { template "backdrop-building-two-second-floor" parent "backdrop-building-base" }
		sprite { atlas backdropbuildings layouts [ "backdrop-building-two-second-floor" ] }
	}
	{
		ident { template "backdrop-building-two-repeat-floor" parent "backdrop-building-base" }
		sprite { atlas backdropbuildings layouts [ "backdrop-building-two-repeat-floor" ] }
	}
	{
		ident { template "backdrop-building-two-roof" parent "backdrop-building-base" }
		sprite { atlas backdropbuildings layouts [ "backdrop-building-two-roof" ] }
	}
	{
		ident { template "backdrop-building-two-roof-rear-layers" parent "backdrop-building-base" }
		sprite { atlas backdropbuildings layouts [ "backdrop-building-two-roof-rear-layers" ] }
	}
	{
		ident { template "backdrop-building-three-ground-floor" parent "backdrop-building-base" }
		sprite { atlas backdropbuildings layouts [ "backdrop-building-three-ground-floor" ] }
	}
	{
		ident { template "backdrop-building-three-second-floor" parent "backdrop-building-base" }
		sprite { atlas backdropbuildings layouts [ "backdrop-building-three-second-floor" ] }
	}
	{
		ident { template "backdrop-building-three-repeat-floor" parent "backdrop-building-base" }
		sprite { atlas backdropbuildings layouts [ "backdrop-building-three-repeat-floor" ] }
	}
	{
		ident { template "backdrop-building-three-roof" parent "backdrop-building-base" }
		sprite { atlas backdropbuildings layouts [ "backdrop-building-three-roof" ] }
	}
	{
		ident { template "backdrop-building-three-roof-rear-layers" parent "backdrop-building-base" }
		sprite { atlas backdropbuildings layouts [ "backdrop-building-three-roof-rear-layers" ] }
	}
	{
		ident { template "backdrop-building-four-ground-floor" parent "backdrop-building-base" }
		sprite { atlas backdropbuildings layouts [ "backdrop-building-four-ground-floor" ] }
	}
	{
		ident { template "backdrop-building-four-second-floor" parent "backdrop-building-base" }
		sprite { atlas backdropbuildings layouts [ "backdrop-building-four-second-floor" ] }
	}
	{
		ident { template "backdrop-building-four-repeat-floor" parent "backdrop-building-base" }
		sprite { atlas backdropbuildings layouts [ "backdrop-building-four-repeat-floor" ] }
	}
	{
		ident { template "backdrop-building-four-roof" parent "backdrop-building-base" }
		sprite { atlas backdropbuildings layouts [ "backdrop-building-four-roof" ] }
	}
	{
		ident { template "backdrop-building-four-roof-rear-layers" parent "backdrop-building-base" }
		sprite { atlas backdropbuildings layouts [ "backdrop-building-four-roof-rear-layers" ] }
	}
	{
		ident { template "backdrop-building-five-ground-floor" parent "backdrop-building-base" }
		sprite { atlas backdropbuildings layouts [ "backdrop-building-five-ground-floor" ] }
	}
	{
		ident { template "backdrop-building-five-second-floor" parent "backdrop-building-base" }
		sprite { atlas backdropbuildings layouts [ "backdrop-building-five-second-floor" ] }
	}
	{
		ident { template "backdrop-building-five-repeat-floor" parent "backdrop-building-base" }
		sprite { atlas backdropbuildings layouts [ "backdrop-building-five-repeat-floor" ] }
	}
	{
		ident { template "backdrop-building-five-roof" parent "backdrop-building-base" }
		sprite { atlas backdropbuildings layouts [ "backdrop-building-five-roof" ] }
	}
	{
		ident { template "backdrop-building-five-roof-rear-layers" parent "backdrop-building-base" }
		sprite { atlas backdropbuildings layouts [ "backdrop-building-five-roof-rear-layers" ] }
	}
	{
		ident { template "backdrop-building-six-ground-floor" parent "backdrop-building-base" }
		sprite { atlas backdropbuildings layouts [ "backdrop-building-six-ground-floor" ] }
	}
	{
		ident { template "backdrop-building-six-second-floor" parent "backdrop-building-base" }
		sprite { atlas backdropbuildings layouts [ "backdrop-building-six-second-floor" ] }
	}
	{
		ident { template "backdrop-building-six-repeat-floor" parent "backdrop-building-base" }
		sprite { atlas backdropbuildings layouts [ "backdrop-building-six-repeat-floor" ] }
	}
	{
		ident { template "backdrop-building-six-roof" parent "backdrop-building-base" }
		sprite { atlas backdropbuildings layouts [ "backdrop-building-six-roof" ] }
	}
	{
		ident { template "backdrop-building-six-roof-rear-layers" parent "backdrop-building-base" }
		sprite { atlas backdropbuildings layouts [ "backdrop-building-six-roof-rear-layers" ] }
	}

	;;;;;;;;;;;;;;;;;;;;;;;;; NPCs

	{
		ident { template "npc" }
		navigation {
			speed 80
			maxpathcost 400
		}
		peep {
			favs {
				favvotes 10 	;; when scoring, votes for the current favorite
				newvotes 10		;; votes for a new restaurant
				defaultvotes 1  ;; votes for an old restaurant, not favorite
				newageindays 3  ;; how long a restaurant counts as "new" in game days
			}
		}
		placement {
			size { x 1 y 1 }
			snap #false
			usepeepmap #true
		}
		script { }
		selection {
			mode npc
		}
		sprite {
			atlas hdpeeps
			animations {
				default [ { img "missing.png" layer deco framecount 1 fps 0 } ] ;; fallback in case of a missing anim
			}
			centerx #true
			colors {
				b { from 128 to 192 }
			}
		}
		vfx { }
	}
	{
		ident { template "npc-worker" parent "npc" }
		peep {
			
		}

	}
	;;;;;;;;;;;;;;;;;;;;;;;;;;;; office npcs
	{
		ident { template "npc-office" parent "npc" }  ;;;;; put things in common to all office workers here. A, B and V below are visual variants - sprite changes only. k thanx bai
		peep {
			
		}
	}
	{
		ident { template "npc-officeworker-office.a" parent "npc-office" }  ;;; type a is the more formal office worker
		sprite {
			animations {
				default-m [ { img "office_male_001_stand_front.png" mask "office_male_001_stand_front_mask.png" atlas hdpeeps  layer walker framecount 1 fps 0 dy 8 } ]
				stand-r-m [ { img "office_male_001_stand_side.png" mask "office_male_001_stand_side_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 hflip #true } ]
				stand-l-m [ { img "office_male_001_stand_side.png" mask "office_male_001_stand_side_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 } ]
				escalator-r-m [ { img "office_male_001_stand_side.png" mask "office_male_001_stand_side_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 hflip #true } ]
				escalator-l-m [ { img "office_male_001_stand_side.png" mask "office_male_001_stand_side_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 } ]
				walk-r-m [ { img "office_male_001.png" mask "office_male_001_mask.png" atlas hdpeeps layer walker framecount 13 fps 13 dy 8 hflip #true } ]
				walk-l-m [ { img "office_male_001.png" mask "office_male_001_mask.png" atlas hdpeeps layer walker framecount 13 fps 13 dy 8 } ]
				stairs-r-m [ { img "office_male_001.png" mask "office_male_001_mask.png" atlas hdpeeps layer worker framecount 13 fps 13 dy 8 hflip #true } ]
				stairs-l-m [ { img "office_male_001.png" mask "office_male_001_mask.png" atlas hdpeeps layer worker framecount 13 fps 13 dy 8 } ]
				deliver-r-m [ { img "office_male_001.png" mask "office_male_001_mask.png" atlas hdpeeps layer walker framecount 13 fps 13 dy 8 hflip #true } ]
				deliver-l-m [ { img "office_male_001.png" mask "office_male_001_mask.png" atlas hdpeeps layer walker framecount 13 fps 13 dy 8 } ]
				deliver-stairs-r-m [ { img "office_male_001.png" mask "office_male_001_mask.png" atlas hdpeeps layer worker framecount 13 fps 13 dy 8 hflip #true } ]
				deliver-stairs-l-m [ { img "office_male_001.png" mask "office_male_001_mask.png" atlas hdpeeps layer worker framecount 13 fps 13 dy 8 } ]
				eat-m [ { img "office_male_001_stand_back.png" mask "office_male_001_stand_back_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 } ]
				eat-sit-l-m [ { img "office_male_001_sit.png" mask "office_male_001_sit_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 } ]
				eat-sit-r-m [ { img "office_male_001_sit.png" mask "office_male_001_sit_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 hflip #true } ]
				eat-sit-f-m [ { img "office_male_001_sit_front.png" mask "office_male_001_sit_front_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 } ]
				eat-sit-b-m [ { img "office_male_001_sit_back.png" mask "office_male_001_sit_back_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 } ]
				shop-m [ { img "office_male_001_stand_back.png" mask "office_male_001_stand_back_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 } ]
				work-r-m [ { img "office_male_001_sit.png" mask "office_male_001_sit_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 hflip #true } 
							{ img "office_male_001_sit_side_paperwork.png" mask "office_male_001_sit_side_paperwork_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.5 hflip #true }
							{ img "office_male_001_sit_side_phone.png" mask "office_male_001_sit_side_phone_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.5 hflip #true }
							{ img "office_male_001_sit_side_newspaper.png" mask "office_male_001_sit_side_newspaper_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.5 hflip #true }
							{ img "office_male_001_sit_side_computer.png" mask "office_male_001_sit_side_computer_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.5 hflip #true } 
				]
				work-l-m [ { img "office_male_001_sit.png" mask "office_male_001_sit_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 } 
							{ img "office_male_001_sit_side_paperwork.png" mask "office_male_001_sit_side_paperwork_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.5 }
							{ img "office_male_001_sit_side_phone.png" mask "office_male_001_sit_side_phone_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.5 }
							{ img "office_male_001_sit_side_newspaper.png" mask "office_male_001_sit_side_newspaper_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.5 }
							{ img "office_male_001_sit_side_computer.png" mask "office_male_001_sit_side_computer_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.5 }
				]
				work-f-m [ { img "office_male_001_sit_front.png" mask "office_male_001_sit_front_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.5 }
							{ img "office_male_001_sit_quarter_paperwork.png" mask "office_male_001_sit_quarter_paperwork_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.5 }
							{ img "office_male_001_sit_quarter_phone.png" mask "office_male_001_sit_quarter_phone_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.5 }
							{ img "office_male_001_sit_quarter_newspaper.png" mask "office_male_001_sit_quarter_newspaper_mask.png" atlas hdpeeps layer worker framecount 1 fps 1 dy 8 playhours 0.5 } ]
				work-b-m [ { img "office_male_001_sit_back.png" mask "office_male_001_sit_back_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 } ]
				dotask-m [ { img "office_male_001_stand_front.png" mask "office_male_001_stand_front_mask.png" atlas hdpeeps layer walker framecount 1 fps 1 dy 8 } ]
				unhappy-m [ { img "office_male_001_stand_front_upset.png" mask "office_male_001_stand_front_upset_mask.png" atlas hdpeeps  layer walker framecount 1 fps 0 dy 8 } ]
				warning-m [ { img "office_male_001_stand_front.png" mask "office_male_001_stand_front_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 } ]

				default-f [ { img "office_female_01_stand_front.png" mask "office_female_01_stand_front_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 } ]
				stand-r-f [ { img "office_female_01_stand_side.png" mask "office_female_01_stand_side_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 hflip #true } ]
				stand-l-f [ { img "office_female_01_stand_side.png" mask "office_female_01_stand_side_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 } ]
				escalator-r-f [ { img "office_female_01_stand_side.png" mask "office_female_01_stand_side_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 hflip #true } ]
				escalator-l-f [ { img "office_female_01_stand_side.png" mask "office_female_01_stand_side_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 } ]
				walk-r-f [ { img "office_female_001.png" mask "office_female_001_mask.png" atlas hdpeeps layer walker framecount 13 fps 13 dy 8 hflip #true } ]
				walk-l-f [ { img "office_female_001.png" mask "office_female_001_mask.png" atlas hdpeeps layer walker framecount 13 fps 13 dy 8 } ]
				stairs-r-f [ { img "office_female_001.png" mask "office_female_001_mask.png" atlas hdpeeps layer worker framecount 13 fps 13 dy 8 hflip #true } ]
				stairs-l-f [ { img "office_female_001.png" mask "office_female_001_mask.png" atlas hdpeeps layer worker framecount 13 fps 13 dy 8 } ]
				deliver-r-f [ { img "office_female_001.png" mask "office_female_001_mask.png" atlas hdpeeps layer walker framecount 13 fps 13 dy 8 hflip #true } ]
				deliver-l-f [ { img "office_female_001.png" mask "office_female_001_mask.png" atlas hdpeeps layer walker framecount 13 fps 13 dy 8 } ]
				deliver-stairs-r-f [ { img "office_female_001.png" mask "office_female_001_mask.png" atlas hdpeeps layer worker framecount 13 fps 13 dy 8 hflip #true } ]
				deliver-stairs-l-f [ { img "office_female_001.png" mask "office_female_001_mask.png" atlas hdpeeps layer worker framecount 13 fps 13 dy 8 } ]
				eat-f [ { img "office_female_01_stand_back.png" mask "office_female_01_stand_back_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 } ]
				eat-sit-l-f [ { img "office_female_01_sit.png" mask "office_female_01_sit_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 } ]
				eat-sit-r-f [ { img "office_female_01_sit.png" mask "office_female_01_sit_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 hflip #true } ]
				eat-sit-f-f [ { img "office_female_01_sit_front.png" mask "office_female_01_sit_front_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 } ]
				eat-sit-b-f [ { img "office_female_01_sit_back.png" mask "office_female_01_sit_back_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 } ]
				shop-f [ { img "office_female_01_stand_back.png" mask "office_female_01_stand_back_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 } ]
				work-r-f [ { img "office_female_01_sit.png" mask "office_female_01_sit_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.5 hflip #true }
							{ img "office_female_01_sit_side_computer.png" mask "office_female_01_sit_side_computer_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.5 hflip #true }
							{ img "office_female_01_sit_side_newspaper.png" mask "office_female_01_sit_side_newspaper_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.5 hflip #true }
							{ img "office_female_01_sit_side_paperwork.png" mask "office_female_01_sit_side_paperwork_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.5hflip #true }
							{ img "office_female_01_sit_side_phone.png" mask "office_female_01_sit_side_phone_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.5 hflip #true } ]
				work-l-f [ { img "office_female_01_sit.png" mask "office_female_01_sit_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.5 }
							{ img "office_female_01_sit_side_computer.png" mask "office_female_01_sit_side_computer_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.5 }
							{ img "office_female_01_sit_side_newspaper.png" mask "office_female_01_sit_side_newspaper_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.5 }
							{ img "office_female_01_sit_side_paperwork.png" mask "office_female_01_sit_side_paperwork_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.5 }
							{ img "office_female_01_sit_side_phone.png" mask "office_female_01_sit_side_phone_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.5 }
				 ]
				work-f-f [ { img "office_female_01_sit_front.png" mask "office_female_01_sit_front_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.5 }
							{ img "office_female_01_sit_quarter_paperwork.png" mask "office_female_01_sit_quarter_paperwork_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.5 }
							{ img "office_female_01_sit_quarter_phone.png" mask "office_female_01_sit_quarter_phone_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.5 }
							{ img "office_female_01_sit_quarter_newspaper.png" mask "office_female_01_sit_quarter_newspaper_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.5 }
				]
				work-b-f [ { img "office_female_01_sit_back.png" mask "office_female_01_sit_back_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 } ]
				dotask-f [ { img "office_female_01_stand_front.png" mask "office_female_01_stand_front_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 } ]
				unhappy-f [ { img "office_female_01_stand_front_upset.png" mask "office_female_01_stand_front_upset_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 } ]
				warning-f [ { img "office_female_01_stand_front.png" mask "office_female_01_stand_front_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 } ]

				res-sit-relax-front-m [ { img "office_male_001_sit_quarter_book.png" mask "office_male_001_sit_quarter_book_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 }
									{ img "office_male_001_sit_quarter_tv.png" mask "office_male_001_sit_quarter_tv_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 }
									{ img "office_male_001_sit_quarter_newspaper.png" mask "office_male_001_sit_quarter_newspaper_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 }
				]
				res-sit-relax-l-m [ { img "office_male_001_sit_side_newspaper.png" mask "office_male_001_sit_side_newspaper_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 }
									{ img "office_male_001_sit.png" mask "office_male_001_sit_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 }
				]
				res-sit-relax-r-m [ { img "office_male_001_sit_side_newspaper.png" mask "office_male_001_sit_side_newspaper_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 hflip #true }
									{ img "office_male_001_sit.png" mask "office_male_001_sit_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 hflip #true }
				]
				res-work-m [ { img "office_male_001_sit_back.png" mask "office_male_001_sit_back_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 } ]
				res-stand-back-m [ { img "office_male_001_stand_back.png" mask "office_male_001_stand_back_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 } ]

				res-sit-relax-front-f [ { img "office_female_01_sit_quarter_tv.png" mask "office_female_01_sit_quarter_tv_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 }
									{ img "office_female_01_sit_quarter_newspaper.png" mask "office_female_01_sit_quarter_newspaper_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 }
									{ img "office_female_01_sit_quarter_book.png" mask "office_female_01_sit_quarter_book_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 }
				]
				res-sit-relax-l-f [ { img "office_female_01_sit_side_newspaper.png" mask "office_female_01_sit_side_newspaper_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 }
									{ img "office_female_01_sit.png" mask "office_female_01_sit_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 }
				]
				res-sit-relax-r-f [ { img "office_female_01_sit_side_newspaper.png" mask "office_female_01_sit_side_newspaper_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 hflip #true }
									{ img "office_female_01_sit.png" mask "office_female_01_sit_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 hflip #true }
				]
				res-work-f [ { img "office_female_01_sit_back.png" mask "office_female_01_sit_back_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 } ]
				res-stand-back-f [ { img "office_female_01_stand_back.png" mask "office_female_01_stand_back_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 } ]

				sleep-a-m [ { img "resident_male_01_sleep_01.png" mask "resident_male_01_sleep_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 39.5 } ]
				sleep-b-m [ { img "resident_male_01_sleep_02.png" mask "resident_male_01_sleep_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 39.5 } ]
				sleep-c-m [ { img "resident_male_01_sleep_03.png" mask "resident_male_01_sleep_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 39.5 } ]

				sleep-a-f [ { img "resident_female_01_sleep_single_01.png" mask "resident_female_01_sleep_single_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 39.5 } ]
				sleep-b-f [ { img "resident_female_01_sleep_single_02.png" mask "resident_female_01_sleep_single_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 39.5 } ]
				sleep-c-f [ { img "resident_female_01_sleep_single_03.png" mask "resident_female_01_sleep_single_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 39.5 } ]
			}
		}
	}
	{
		ident { template "npc-officeworker-office.b" parent "npc-office" } ;; type b is the more casual office worker
		sprite {
			animations {
				default-m [ { img "office_male_02_stand_front.png" mask "office_male_02_stand_front_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 } ]
				stand-r-m [ { img "office_male_02_stand_side.png" mask "office_male_02_stand_side_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 hflip #true } ]
				stand-l-m [ { img "office_male_02_stand_side.png" mask "office_male_02_stand_side_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 } ]
				escalator-r-m [ { img "office_male_02_stand_side.png" mask "office_male_02_stand_side_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 hflip #true } ]
				escalator-l-m [ { img "office_male_02_stand_side.png" mask "office_male_02_stand_side_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 } ]
				walk-r-m [ { img "office_male_02_001.png" mask "office_male_02_001_mask.png" atlas hdpeeps layer walker framecount 13 fps 13 dy 8 hflip #true } ]
				walk-l-m [ { img "office_male_02_001.png" mask "office_male_02_001_mask.png" atlas hdpeeps layer walker framecount 13 fps 13 dy 8 } ]
				stairs-r-m [ { img "office_male_02_001.png" mask "office_male_02_001_mask.png" atlas hdpeeps layer worker framecount 13 fps 13 dy 8 hflip #true } ]
				stairs-l-m [ { img "office_male_02_001.png" mask "office_male_02_001_mask.png" atlas hdpeeps layer worker framecount 13 fps 13 dy 8 } ]
				deliver-r-m [ { img "office_male_02_001.png" mask "office_male_02_001_mask.png" atlas hdpeeps layer walker framecount 13 fps 13 dy 8 hflip #true } ]
				deliver-l-m [ { img "office_male_02_001.png" mask "office_male_02_001_mask.png" atlas hdpeeps layer walker framecount 13 fps 13 dy 8 } ]
				deliver-stairs-r-m [ { img "office_male_02_001.png" mask "office_male_02_001_mask.png" atlas hdpeeps layer worker framecount 13 fps 13 dy 8 hflip #true } ]
				deliver-stairs-l-m [ { img "office_male_02_001.png" mask "office_male_02_001_mask.png" atlas hdpeeps layer worker framecount 13 fps 13 dy 8 } ]
				eat-m [ { img "office_male_02_stand_back.png" mask "office_male_02_stand_back_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 } ]
				eat-sit-l-m [ { img "office_male_02_sit.png" mask "office_male_02_sit_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 } ]
				eat-sit-r-m [ { img "office_male_02_sit.png" mask "office_male_02_sit_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 hflip #true } ]
				eat-sit-f-m [ { img "office_male_02_sit_front.png" mask "office_male_02_sit_front_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 } ]
				eat-sit-b-m [ { img "office_male_02_sit_back.png" mask "office_male_02_sit_back_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 } ]
				shop-m [ { img "office_male_02_stand_back.png" mask "office_male_02_stand_back_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 } ]
				work-r-m [ { img "office_male_02_sit.png" mask "office_male_02_sit_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 hflip #true } 
							{ img "office_male_02_sit_side_paperwork.png" mask "office_male_02_sit_side_paperwork_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.5 hflip #true }
							{ img "office_male_02_sit_side_newspaper.png" mask "office_male_02_sit_side_newspaper_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.5 hflip #true }
							{ img "office_male_02_sit_side_computer.png" mask "office_male_02_sit_side_computer_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.5 hflip #true }
							{ img "office_male_02_sit_side_phone.png" mask "office_male_02_sit_side_phone_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.5 hflip #true }
				 ]
				work-l-m [ { img "office_male_02_sit.png" mask "office_male_02_sit_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 } 
							{ img "office_male_02_sit_side_paperwork.png" mask "office_male_02_sit_side_paperwork_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.5 }
							{ img "office_male_02_sit_side_newspaper.png" mask "office_male_02_sit_side_newspaper_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.5 }
							{ img "office_male_02_sit_side_computer.png" mask "office_male_02_sit_side_computer_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.5 }
							{ img "office_male_02_sit_side_phone.png" mask "office_male_02_sit_side_phone_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.5 }
				]
				work-f-m [ { img "office_male_02_sit_front.png" mask "office_male_02_sit_front_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.5 } 
							{ img "office_male_02_sit_quarter_paperwork.png" mask "office_male_02_sit_quarter_paperwork_mask.png" layer worker atlas hdpeeps framecount 1 fps 0 dy 8 playhours 0.5 }
							{ img "office_male_02_sit_quarter_phone.png" mask "office_male_02_sit_quarter_phone_mask.png" layer worker atlas hdpeeps framecount 1 fps 0 dy 8 playhours 0.5 }
							{ img "office_male_02_sit_quarter_newspaper.png" mask "office_male_02_sit_quarter_newspaper_mask.png" layer worker atlas hdpeeps framecount 1 fps 0 dy 8 playhours 0.5 }
				]
				work-b-m [ { img "office_male_02_sit_back.png" mask "office_male_02_sit_back_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 } ]
				dotask-m [ { img "office_male_02_stand_front.png" mask "office_male_02_stand_front_mask.png" atlas hdpeeps layer walker framecount 1 fps 1 dy 8 } ]
				unhappy-m [ { img "office_male_02_stand_front_upset.png" mask "office_male_02_stand_front_upset_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 } ]
				warning-m [ { img "office_male_02_stand_front.png" mask "office_male_02_stand_front_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 } ]

				default-f [ { img "office_female_02_stand_front.png" mask "office_female_02_stand_front_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 } ]
				stand-r-f [ { img "office_female_02_stand_side.png" mask "office_female_02_stand_side_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 hflip #true } ]
				stand-l-f [ { img "office_female_02_stand_side.png" mask "office_female_02_stand_side_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 } ]
				escalator-r-f [ { img "office_female_02_stand_side.png" mask "office_female_02_stand_side_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 hflip #true } ]
				escalator-l-f [ { img "office_female_02_stand_side.png" mask "office_female_02_stand_side_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 } ]
				walk-r-f [ { img "office_female_02_001.png" mask "office_female_02_001_mask.png" atlas hdpeeps layer walker framecount 13 fps 13 dy 8 hflip #true } ]
				walk-l-f [ { img "office_female_02_001.png" mask "office_female_02_001_mask.png" atlas hdpeeps layer walker framecount 13 fps 13 dy 8 } ]
				stairs-r-f [ { img "office_female_02_001.png" mask "office_female_02_001_mask.png" atlas hdpeeps layer worker framecount 13 fps 13 dy 8 hflip #true } ]
				stairs-l-f [ { img "office_female_02_001.png" mask "office_female_02_001_mask.png" atlas hdpeeps layer worker framecount 13 fps 13 dy 8 } ]
				deliver-r-f [ { img "office_female_02_001.png" mask "office_female_02_001_mask.png" atlas hdpeeps layer walker framecount 13 fps 13 dy 8 hflip #true } ]
				deliver-l-f [ { img "office_female_02_001.png" mask "office_female_02_001_mask.png" atlas hdpeeps layer walker framecount 13 fps 13 dy 8 } ]
				deliver-stairs-r-f [ { img "office_female_02_001.png" mask "office_female_02_001_mask.png" atlas hdpeeps layer worker framecount 13 fps 13 dy 8 hflip #true } ]
				deliver-stairs-l-f [ { img "office_female_02_001.png" mask "office_female_02_001_mask.png" atlas hdpeeps layer worker framecount 13 fps 13 dy 8 } ]
				eat-f [ { img "office_female_02_stand_back.png" mask "office_female_02_stand_back_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 } ]
				eat-sit-l-f [ { img "office_female_02_sit.png" mask "office_female_02_sit_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 } ]
				eat-sit-r-f [ { img "office_female_02_sit.png" mask "office_female_02_sit_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 hflip #true } ]
				eat-sit-f-f [ { img "office_female_02_sit_front.png" mask "office_female_02_sit_front_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 } ]
				eat-sit-b-f [ { img "office_female_02_sit_back.png" mask "office_female_02_sit_back_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 } ]
				shop-f [ { img "office_female_02_stand_back.png" mask "office_female_02_stand_back_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 } ]
				work-r-f [ { img "office_female_02_sit.png" mask "office_female_02_sit_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.5 hflip #true }
							{ img "office_female_02_sit_side_computer.png" mask "office_female_02_sit_side_computer_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.5 hflip #true }
							{ img "office_female_02_sit_side_newspaper.png" mask "office_female_02_sit_side_newspaper_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.5 hflip #true }
							{ img "office_female_02_sit_side_paperwork.png" mask "office_female_02_sit_side_paperwork_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.5 hflip #true }
							{ img "office_female_02_sit_side_phone.png" mask "office_female_02_sit_side_phone_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.5 hflip #true } ]
				work-l-f [ { img "office_female_02_sit.png" mask "office_female_02_sit_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.5 }
							{ img "office_female_02_sit_side_computer.png" mask "office_female_02_sit_side_computer_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.5 }
							{ img "office_female_02_sit_side_newspaper.png" mask "office_female_02_sit_side_newspaper_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.5 }
							{ img "office_female_02_sit_side_paperwork.png" mask "office_female_02_sit_side_paperwork_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.5 }
							{ img "office_female_02_sit_side_phone.png" mask "office_female_02_sit_side_phone_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.5 }
				]
				work-f-f [ { img "office_female_02_sit_front.png" mask "office_female_02_sit_front_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.5 }
							{ img "office_female_02_sit_quarter_paperwork.png" mask "office_female_02_sit_quarter_paperwork_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.5 }
							{ img "office_female_02_sit_quarter_newspaper.png" mask "office_female_02_sit_quarter_newspaper_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.5 }
							{ img "office_female_02_sit_quarter_phone.png" mask "office_female_02_sit_quarter_phone_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.5 }
				]
				work-b-f [ { img "office_female_02_sit_back.png" mask "office_female_02_sit_back_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 } ]
				dotask-f [ { img "office_female_02_stand_front.png" mask "office_female_02_stand_front_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 } ]
				unhappy-f [ { img "office_female_02_stand_front_upset.png" mask "office_female_02_stand_front_upset_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 } ]
				warning-f [ { img "office_female_02_stand_front.png" mask "office_female_02_stand_front_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 } ]

				res-sit-relax-front-m [ { img "office_male_02_sit_quarter_book.png" mask "office_male_02_sit_quarter_book_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 }
									{ img "office_male_02_sit_quarter_tv.png" mask "office_male_02_sit_quarter_tv_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 }
									{ img "office_male_02_sit_quarter_newspaper.png" mask "office_male_02_sit_quarter_newspaper_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 }
				]
				res-sit-relax-l-m [ { img "office_male_02_sit_side_newspaper.png" mask "office_male_02_sit_side_newspaper_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 }
									{ img "office_male_02_sit.png" mask "office_male_02_sit_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 }
				]
				res-sit-relax-r-m [ { img "office_male_02_sit_side_newspaper.png" mask "office_male_02_sit_side_newspaper_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 hflip #true }
									{ img "office_male_02_sit.png" mask "office_male_02_sit_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 hflip #true }
				]
				res-work-m [ { img "office_male_02_sit_back.png" mask "office_male_02_sit_back_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 } ]
				res-stand-back-m [ { img "office_male_02_stand_back.png" mask "office_male_02_stand_back_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 } ]

				res-sit-relax-front-f [ { img "office_female_02_sit_quarter_tv.png" mask "office_female_02_sit_quarter_tv_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 }
									{ img "office_female_02_sit_quarter_newspaper.png" mask "office_female_02_sit_quarter_newspaper_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 }
									{ img "office_female_02_sit_quarter_book.png" mask "office_female_02_sit_quarter_book_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 }
				]
				res-sit-relax-l-f [ { img "office_female_02_sit_side_newspaper.png" mask "office_female_02_sit_side_newspaper_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 }
									{ img "office_female_02_sit.png" mask "office_female_02_sit_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 }
				]
				res-sit-relax-r-f [ { img "office_female_02_sit_side_newspaper.png" mask "office_female_02_sit_side_newspaper_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 hflip #true }
									{ img "office_female_02_sit.png" mask "office_female_02_sit_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 hflip #true }
				]
				res-work-f [ { img "office_female_02_sit_back.png" mask "office_female_02_sit_back_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 } ]
				res-stand-back-f [ { img "office_female_02_stand_back.png" mask "office_female_02_stand_back_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 } ]

				sleep-a-m [ { img "resident_male_02_sleep_01.png" mask "resident_male_02_sleep_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 39.5 } ]
				sleep-b-m [ { img "resident_male_02_sleep_02.png" mask "resident_male_02_sleep_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 39.5 } ]
				sleep-c-m [ { img "resident_male_02_sleep_03.png" mask "resident_male_02_sleep_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 39.5 } ]

				sleep-a-f [ { img "resident_female_02_sleep_single_01.png" mask "resident_female_02_sleep_single_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 39.5 } ]
				sleep-b-f [ { img "resident_female_02_sleep_single_02.png" mask "resident_female_02_sleep_single_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 39.5 } ]
				sleep-c-f [ { img "resident_female_02_sleep_single_03.png" mask "resident_female_02_sleep_single_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 39.5 } ]
			}
		}
	}
	{
		ident { template "npc-officeworker-office.v" parent "npc-office" } ;; VIP office workers
		sprite {
			animations {
				default-m [ { img "office_male_vip_stand_front.png" mask "office_male_vip_stand_front_mask.png" atlas hdpeepsres layer walker framecount 1 fps 0 dy 8 } ]
				stand-r-m [ { img "office_male_vip_stand_side.png" mask "office_male_vip_stand_side_mask.png" atlas hdpeepsres layer walker framecount 1 fps 0 dy 8 hflip #true } ]
				stand-l-m [ { img "office_male_vip_stand_side.png" mask "office_male_vip_stand_side_mask.png" atlas hdpeepsres layer walker framecount 1 fps 0 dy 8 } ]
				escalator-r-m [ { img "office_male_vip_stand_side.png" mask "office_male_vip_stand_side_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 hflip #true } ]
				escalator-l-m [ { img "office_male_vip_stand_side.png" mask "office_male_vip_stand_side_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 } ]
				walk-r-m [ { img "office_male_vip_001.png" mask "office_male_vip_001_mask.png" atlas hdpeepsres layer walker framecount 13 fps 13 dy 8 hflip #true } ]
				walk-l-m [ { img "office_male_vip_001.png" mask "office_male_vip_001_mask.png" atlas hdpeepsres layer walker framecount 13 fps 13 dy 8 } ]
				stairs-r-m [ { img "office_male_vip_001.png" mask "office_male_vip_001_mask.png" atlas hdpeepsres layer worker framecount 13 fps 13 dy 8 hflip #true } ]
				stairs-l-m [ { img "office_male_vip_001.png" mask "office_male_vip_001_mask.png" atlas hdpeepsres layer worker framecount 13 fps 13 dy 8 } ]
				deliver-r-m [ { img "office_male_vip_001.png" mask "office_male_vip_001_mask.png" atlas hdpeepsres layer walker framecount 13 fps 13 dy 8 hflip #true } ]
				deliver-l-m [ { img "office_male_vip_001.png" mask "office_male_vip_001_mask.png" atlas hdpeepsres layer walker framecount 13 fps 13 dy 8 } ]
				deliver-stairs-r-m [ { img "office_male_vip_001.png" mask "office_male_vip_001_mask.png" atlas hdpeepsres layer worker framecount 13 fps 13 dy 8 hflip #true } ]
				deliver-stairs-l-m [ { img "office_male_vip_001.png" mask "office_male_vip_001_mask.png" atlas hdpeepsres layer worker framecount 13 fps 13 dy 8 } ]
				eat-m [ { img "office_male_vip_stand_back.png" mask "office_male_vip_stand_back_mask.png" atlas hdpeepsres layer walker framecount 1 fps 0 dy 8 } ]
				eat-sit-l-m [ { img "office_male_vip_sit.png" mask "office_male_vip_sit_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 } ]
				eat-sit-r-m [ { img "office_male_vip_sit.png" mask "office_male_vip_sit_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 hflip #true } ]
				eat-sit-f-m [ { img "office_male_vip_sit_front.png" mask "office_male_vip_sit_front_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 } ]
				eat-sit-b-m [ { img "office_male_vip_sit_back.png" mask "office_male_vip_sit_back_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 } ]
				shop-m [ { img "office_male_vip_stand_back.png" mask "office_male_vip_stand_back_mask.png" atlas hdpeepsres layer walker framecount 1 fps 0 dy 8 } ]
				work-r-m [ { img "office_male_vip_sit.png" mask "office_male_vip_sit_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 playhours 0.5 }
							{ img "office_male_vip_sit_side_computer.png" mask "office_male_vip_sit_side_computer_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 playhours 0.5 hflip #true }
							{ img "office_male_vip_sit_side_newspaper.png" mask "office_male_vip_sit_side_newspaper_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 playhours 0.5 hflip #true }
							{ img "office_male_vip_sit_side_phone.png" mask "office_male_vip_sit_side_phone_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 playhours 0.5 hflip #true }
							{ img "office_male_vip_sit_side_paperwork.png" mask "office_male_vip_sit_side_paperwork_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 playhours 0.5 hflip #true }
				]
				work-l-m [ { img "office_male_vip_sit.png" mask "office_male_vip_sit_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 playhours 0.5 }
							{ img "office_male_vip_sit_side_computer.png" mask "office_male_vip_sit_side_computer_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 playhours 0.5 }
							{ img "office_male_vip_sit_side_newspaper.png" mask "office_male_vip_sit_side_newspaper_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 playhours 0.5 }
							{ img "office_male_vip_sit_side_phone.png" mask "office_male_vip_sit_side_phone_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 playhours 0.5 }
							{ img "office_male_vip_sit_side_paperwork.png" mask "office_male_vip_sit_side_paperwork_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 playhours 0.5 }
				]
				work-f-m [ { img "office_male_vip_sit_front.png" mask "office_male_vip_sit_front_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 playhours 0.5 }
							{ img "office_male_vip_sit_quarter_phone.png" mask "office_male_vip_sit_quarter_phone_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 playhours 0.5 }
							{ img "office_male_vip_sit_quarter_paperwork.png" mask "office_male_vip_sit_quarter_paperwork_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 playhours 0.5 }
							{ img "office_male_vip_sit_quarter_newspaper.png" mask "office_male_vip_sit_quarter_newspaper_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 playhours 0.5 }
				 ]
				work-b-m [ { img "office_male_vip_sit_back.png" mask "office_male_vip_sit_back_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 } ]
				dotask-m [ { img "office_male_vip_stand_front.png" mask "office_male_vip_stand_front_mask.png" atlas hdpeepsres layer walker framecount 1 fps 1 dy 8 } ]
				unhappy-m [ { img "office_male_vip_stand_front_upset.png" mask "office_male_vip_stand_front_upset_mask.png" atlas hdpeepsres layer walker framecount 1 fps 0 dy 8 } ]
				warning-m [ { img "office_male_vip_stand_front.png" mask "office_male_vip_stand_front_mask.png" atlas hdpeepsres layer walker framecount 1 fps 0 dy 8 } ]

				default-f [ { img "office_female_vip_stand_front.png" mask "office_female_vip_stand_front_mask.png" atlas hdpeepsres layer walker framecount 1 fps 0 dy 8 } ]
				stand-r-f [ { img "office_female_vip_stand_side.png" mask "office_female_vip_stand_side_mask.png" atlas hdpeepsres layer walker framecount 1 fps 0 dy 8 hflip #true } ]
				stand-l-f [ { img "office_female_vip_stand_side.png" mask "office_female_vip_stand_side_mask.png" atlas hdpeepsres layer walker framecount 1 fps 0 dy 8 } ]
				escalator-r-f [ { img "office_female_vip_stand_side.png" mask "office_female_vip_stand_side_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 hflip #true } ]
				escalator-l-f [ { img "office_female_vip_stand_side.png" mask "office_female_vip_stand_side_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 } ]
				walk-r-f [ { img "office_female_vip_001.png" mask "office_female_vip_001_mask.png" atlas hdpeepsres layer walker framecount 13 fps 13 dy 8 hflip #true } ]
				walk-l-f [ { img "office_female_vip_001.png" mask "office_female_vip_001_mask.png" atlas hdpeepsres layer walker framecount 13 fps 13 dy 8 } ]
				stairs-r-f [ { img "office_female_vip_001.png" mask "office_female_vip_001_mask.png" atlas hdpeepsres layer worker framecount 13 fps 13 dy 8 hflip #true } ]
				stairs-l-f [ { img "office_female_vip_001.png" mask "office_female_vip_001_mask.png" atlas hdpeepsres layer worker framecount 13 fps 13 dy 8 } ]
				deliver-r-f [ { img "office_female_vip_001.png" mask "office_female_vip_001_mask.png" atlas hdpeepsres layer walker framecount 13 fps 13 dy 8 hflip #true } ]
				deliver-l-f [ { img "office_female_vip_001.png" mask "office_female_vip_001_mask.png" atlas hdpeepsres layer walker framecount 13 fps 13 dy 8 } ]
				deliver-stairs-r-f [ { img "office_female_vip_001.png" mask "office_female_vip_001_mask.png" atlas hdpeepsres layer worker framecount 13 fps 13 dy 8 hflip #true } ]
				deliver-stairs-l-f [ { img "office_female_vip_001.png" mask "office_female_vip_001_mask.png" atlas hdpeepsres layer worker framecount 13 fps 13 dy 8 } ]
				eat-f [ { img "office_female_vip_stand_back.png" mask "office_female_vip_stand_back_mask.png" atlas hdpeepsres layer walker framecount 1 fps 0 dy 8 } ]
				eat-sit-l-f [ { img "office_female_vip_sit.png" mask "office_female_vip_sit_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 } ]
				eat-sit-r-f [ { img "office_female_vip_sit.png" mask "office_female_vip_sit_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 hflip #true } ]
				eat-sit-f-f [ { img "office_female_vip_sit_front.png" mask "office_female_vip_sit_front_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 } ]
				eat-sit-b-f [ { img "office_female_vip_sit_back.png" mask "office_female_vip_stand_back_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 } ]
				shop-f [ { img "office_female_vip_stand_back.png" mask "office_female_vip_stand_back_mask.png" atlas hdpeepsres layer walker framecount 1 fps 0 dy 8 } ]
				work-r-f [ { img "office_female_vip_sit.png" mask "office_female_vip_sit_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 playhours 0.5 hflip #true }
							{ img "office_female_vip_sit_side_computer.png" mask "office_female_vip_sit_side_computer.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 playhours 0.5 hflip #true }
							{ img "office_female_vip_sit_side_newspaper.png" mask "office_female_vip_sit_side_newspaper_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 playhours 0.5 hflip #true }
							{ img "office_female_vip_sit_side_paperwork.png" mask "office_female_vip_sit_side_paperwork_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 playhours 0.5 hflip #true }
							{ img "office_female_vip_sit_side_phone.png" mask "office_female_vip_sit_side_phone_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 playhours 0.5 hflip #true } ]
				work-l-f [ { img "office_female_vip_sit.png" mask "office_female_vip_sit_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 playhours 0.5 }
							{ img "office_female_vip_sit_side_computer.png" mask "office_female_vip_sit_side_computer.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 playhours 0.5 }
							{ img "office_female_vip_sit_side_newspaper.png" mask "office_female_vip_sit_side_newspaper_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 playhours 0.5 }
							{ img "office_female_vip_sit_side_paperwork.png" mask "office_female_vip_sit_side_paperwork_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 playhours 0.5 }
							{ img "office_female_vip_sit_side_phone.png" mask "office_female_vip_sit_side_phone_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 playhours 0.5 }
				 ]
				work-f-f [ { img "office_female_vip_sit_front.png" mask "office_female_vip_sit_front_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 playhours 0.5 }
							{ img "office_female_vip_sit_quarter_phone.png" mask "office_female_vip_sit_quarter_phone_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 playhours 0.5 }
							{ img "office_female_vip_sit_quarter_paperwork.png" mask "office_female_vip_sit_quarter_paperwork_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 playhours 0.5 }
							{ img "office_female_vip_sit_quarter_newspaper.png" mask "office_female_vip_sit_quarter_newspaper_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 playhours 0.5 }
				 ]
				work-b-f [ { img "office_female_vip_sit_back.png" mask "office_female_vip_sit_back_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 } ]
				dotask-f [ { img "office_female_vip_stand_front.png" mask "office_female_vip_stand_front_mask.png" atlas hdpeepsres layer walker framecount 1 fps 0 dy 8 } ]
				unhappy-f [ { img "office_female_vip_stand_front_upset.png" mask "office_female_vip_stand_front_upset_mask.png" atlas hdpeepsres layer walker framecount 1 fps 0 dy 8 } ]
				warning-f [ { img "office_female_vip_stand_front.png" mask "office_female_vip_stand_front_mask.png" atlas hdpeepsres layer walker framecount 1 fps 0 dy 8 } ]

				res-sit-relax-front-m [ { img "office_male_vip_sit_quarter_book.png" mask "office_male_vip_sit_quarter_book_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 }
									{ img "office_male_vip_sit_quarter_tv.png" mask "office_male_vip_sit_quarter_tv_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 }
									{ img "office_male_vip_sit_quarter_newspaper.png" mask "office_male_vip_sit_quarter_newspaper_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 }
				]
				res-sit-relax-l-m [ { img "office_male_vip_sit_side_newspaper.png" mask "office_male_vip_sit_side_newspaper_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 }
									{ img "office_male_vip_sit.png" mask "office_male_vip_sit_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 }
				]
				res-sit-relax-r-m [ { img "office_male_vip_sit_side_newspaper.png" mask "office_male_vip_sit_side_newspaper_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 hflip #true }
									{ img "office_male_vip_sit.png" mask "office_male_vip_sit_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 hflip #true }
				]
				res-work-m [ { img "office_male_vip_sit_back.png" mask "office_male_vip_sit_back_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 } ]
				res-stand-back-m [ { img "office_male_vip_stand_back.png" mask "office_male_vip_stand_back_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 } ]

				res-sit-relax-front-f [ { img "office_female_vip_sit_quarter_tv.png" mask "office_female_vip_sit_quarter_tv_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 }
									{ img "office_female_vip_sit_quarter_newspaper.png" mask "office_female_vip_sit_quarter_newspaper_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 }
									{ img "office_female_vip_sit_quarter_book.png" mask "office_female_vip_sit_quarter_book_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 }
				]
				res-sit-relax-l-f [ { img "office_female_vip_sit_side_newspaper.png" mask "office_female_vip_sit_side_newspaper_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 }
									{ img "office_female_vip_sit.png" mask "office_female_vip_sit_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 }
				]
				res-sit-relax-r-f [ { img "office_female_vip_sit_side_newspaper.png" mask "office_female_vip_sit_side_newspaper_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 hflip #true }
									{ img "office_female_vip_sit.png" mask "office_female_vip_sit_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 hflip #true }
				]
				res-work-f [ { img "office_female_vip_sit_back.png" mask "office_female_vip_sit_back_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 } ]
				res-stand-back-f [ { img "office_female_vip_stand_back.png" mask "office_female_vip_stand_back_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 } ]

				sleep-a-m [ { img "resident_male_01_sleep_01.png" mask "resident_male_01_sleep_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 39.5 } ]
				sleep-b-m [ { img "resident_male_01_sleep_02.png" mask "resident_male_01_sleep_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 39.5 } ]
				sleep-c-m [ { img "resident_male_01_sleep_03.png" mask "resident_male_01_sleep_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 39.5 } ]

				sleep-a-f [ { img "resident_female_01_sleep_single_01.png" mask "resident_female_01_sleep_single_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 39.5 } ]
				sleep-b-f [ { img "resident_female_01_sleep_single_02.png" mask "resident_female_01_sleep_single_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 39.5 } ]
				sleep-c-f [ { img "resident_female_01_sleep_single_03.png" mask "resident_female_01_sleep_single_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 39.5 } ]
			}
		}
	}
	{
		ident { template "npc-office-office.a-office.1" parent "npc-officeworker-office.a" }
		peep {
			schedule "schedule-office.1"
		}
		sprite {
			colors {
				b { from 128 to 180 }
			}
		}
	}
	{
		ident {  template "npc-office-office.b-office.2" parent "npc-officeworker-office.b" }
		peep {
			schedule "schedule-office.2"
		}
		sprite {
			colors {
				b { from 128 to 252 }
			}
		}
	}
	{
		ident {  template "npc-office-office.b-office.3" parent "npc-officeworker-office.b" }
		peep {
			schedule "schedule-office.3"
		}
		sprite {
			colors {
				b { from 173 to 174 }
			}
		}
	}
	{
		ident {  template "npc-office-office.a-office.3" parent "npc-officeworker-office.a" }
		peep {
			schedule "schedule-office.3"
		}
		sprite {
			colors {
				b { from 173 to 174 }
			}
		}
	}
	{
		ident { template "npc-office-office.a-office.4" parent "npc-officeworker-office.a" }
		peep {
			schedule "schedule-office.4"
		}
		sprite {
			colors {
				b { from 140 to 151 }
			}
		}
	}
	{
		ident { template "npc-office-office.a-office.4-standing" parent "npc-officeworker-office.a" }
		peep {
			schedule "schedule-office.4"
		}

		sprite {
			animations {
			work-f-m [ { img "office_male_001_stand_front.png" mask "office_male_001_stand_front_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 1 }
						{ img "office_male_001_stand_back.png" mask "office_male_001_stand_back_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.1 } ]
			work-f-f [ { img "office_female_01_stand_front.png" mask "office_female_01_stand_front_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 1 }
						{ img "office_female_01_stand_back.png" mask "office_female_01_stand_back_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.1 } ]
			}
			colors {
				b { from 140 to 151 }
			}
		}
	}
	{
		ident { template "npc-office-office.b-office.5" parent "npc-officeworker-office.b" }
		peep {
			schedule "schedule-office.5"
		}
		sprite {
			colors {
				b { from 151 to 190 }
			}
		}
	}
	{
		ident { template "npc-office-office.a-office.5" parent "npc-officeworker-office.a" }
		peep {
			schedule "schedule-office.5"
		}
		sprite {
			colors {
				b { from 130 to 180 }
			}
		}
	}
	{
		ident { template "npc-office-office.a-office.6" parent "npc-officeworker-office.a" }
		peep {
			schedule "schedule-office.6"
		}
		sprite {
			colors {
				b { from 140 to 151 }
			}
		}
	}
	{
		ident { template "npc-office-office.a-office.7" parent "npc-officeworker-office.a" }
		peep {
			schedule "schedule-office.7"
		}
		sprite {
			colors {
				b { from 131 to 133 }
			}
		}
	}
	{
		ident { template "npc-office-office.a-office.8" parent "npc-officeworker-office.a" }
		peep {
			schedule "schedule-office.8"
		}
		sprite {
			colors {
				b { from 131 to 133 }
			}
		}
	}
	{
		ident { template "npc-office-office.v-office.8" parent "npc-officeworker-office.v" }
		peep {
			schedule "schedule-office.8"
		}
		sprite {
			colors {
				b { from 150 to 153 }
			}
		}
	}
	{
		ident { template "npc-office-office.b-office.9" parent "npc-officeworker-office.b" }
		peep {
			schedule "schedule-office.9"
		}
		sprite {
			colors {
				b { from 220 to 225 }
			}
		}
	}
	{
		ident { template "npc-office-office.b-office.doctor.1" parent "npc-officeworker-office.b" }
		peep {
			schedule "schedule-office.doctor.1"
		}
		sprite {
			animations {
				work-r-m [ { img "office_male_02_sit.png" mask "office_male_02_sit_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 16 hflip #true } ]
				work-l-m [ { img "office_male_02_sit.png" mask "office_male_02_sit_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 16 } ]

				work-r-f [ { img "office_female_02_sit.png" mask "office_female_02_sit_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 16 hflip #true } ]
				work-l-f [ { img "office_female_02_sit.png" mask "office_female_02_sit_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 16 } ]

			}
			colors {
				b { from 0 to 1 }
			}
		}
	}
	{
		ident { template "npc-office-office.b-office.doctor.2" parent "npc-officeworker-office.b" }
		peep {
			schedule "schedule-office.doctor.2"
		}
		sprite {
			animations {
				work-r-m [ { img "office_male_02_sit.png" mask "office_male_02_sit_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 16 hflip #true } ]
				work-l-m [ { img "office_male_02_sit.png" mask "office_male_02_sit_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 16 } ]

				work-r-f [ { img "office_female_02_sit.png" mask "office_female_02_sit_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 16 hflip #true } ]
				work-l-f [ { img "office_female_02_sit.png" mask "office_female_02_sit_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 16 } ]

			}
			colors {
				b { from 0 to 1 }
			}
		}
	}
	{
		ident {  template "npc-office-office.b-office.admin.1" parent "npc-officeworker-office.b" }
		peep {
			schedule "schedule-office.admin.1"
		}
		sprite {
			colors {
				b { from 171 to 191 }
			}
		}
	}
	{
		ident {  template "npc-office-office.a-office.admin.1" parent "npc-officeworker-office.a" }
		peep {
			schedule "schedule-office.admin.1"
		}
		sprite {
			colors {
				b { from 130 to 150 }
			}
		}
	}
	{
		ident {  template "npc-office-office.b-office.admin.2" parent "npc-officeworker-office.b" }
		peep {
			schedule "schedule-office.admin.2"
		}
		sprite {
			colors {
				b { from 130 to 250 }
			}
		}
	}
	{
		ident {  template "npc-office-office.a-office.admin.2" parent "npc-officeworker-office.b" }
		peep {
			schedule "schedule-office.admin.2"
		}
		sprite {
			colors {
				b { from 130 to 250 }
			}
		}
	}
	{
		ident { template "npc-office-office.a-meeting.1" parent "npc-officeworker-office.a" }
		peep {
			schedule "schedule-office.meeting.1"
		}
		sprite {
			colors {
				b { from 132 to 133 }
			}
		}
	}
	{
		ident { template "npc-office-office.b-meeting.2" parent "npc-officeworker-office.b" }
		peep {
			schedule "schedule-office.meeting.2"
		}
		sprite {
			colors {
				b { from 188 to 189 }
			}
		}
	}
	{
		ident { template "npc-office-office.a-office.10" parent "npc-officeworker-office.a" }
		peep {
			schedule "schedule-office.10"
		}
		sprite {
			colors {
				b { from 188 to 189 }
			}
		}
	}






	;;;;;; support NPCs

	{
		ident { template "npc-support" parent "npc" }
		navigation {
			speed 100
		}
		peep {
			
		}
		sprite {
			animations {
				default-m [ { img "worker_male_01_stand_front.png" mask "worker_male_01_stand_front_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 } ]
				stand-r-m [ { img "worker_male_01_stand_side.png" mask "worker_male_01_stand_side_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 hflip #true } ]
				stand-l-m [ { img "worker_male_01_stand_side.png" mask "worker_male_01_stand_side_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 } ]
				escalator-r-m [ { img "worker_male_01_stand_side.png" mask "worker_male_01_stand_side_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 hflip #true } ]
				escalator-l-m [ { img "worker_male_01_stand_side.png" mask "worker_male_01_stand_side_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 } ]
				walk-r-m [ { img "worker_male_001.png" mask "worker_male_001_mask.png" atlas hdpeeps layer walker framecount 13 fps 13 dy 8 hflip #true } ]
				walk-l-m [ { img "worker_male_001.png" mask "worker_male_001_mask.png" atlas hdpeeps layer walker framecount 13 fps 13 dy 8 } ]
				stairs-r-m [ { img "worker_male_001.png" mask "worker_male_001_mask.png" atlas hdpeeps layer worker framecount 13 fps 13 dy 8 hflip #true } ]
				stairs-l-m [ { img "worker_male_001.png" mask "worker_male_001_mask.png" atlas hdpeeps layer worker framecount 13 fps 13 dy 8 } ]
				deliver-r-m [ { img "worker_male_001.png" mask "worker_male_001_mask.png" atlas hdpeeps layer walker framecount 13 fps 13 dy 8 hflip #true } ]
				deliver-l-m [ { img "worker_male_001.png" mask "worker_male_001_mask.png" atlas hdpeeps layer walker framecount 13 fps 13 dy 8 } ]
				deliver-stairs-r-m [ { img "worker_male_001.png" mask "worker_male_001_mask.png" atlas hdpeeps layer worker framecount 13 fps 13 dy 8 hflip #true } ]
				deliver-stairs-l-m [ { img "worker_male_001.png" mask "worker_male_001_mask.png" atlas hdpeeps layer worker framecount 13 fps 13 dy 8 } ]
				eat-m [ { img "worker_male_01_stand_back.png" mask "worker_male_01_stand_back_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 } ]
				eat-sit-l-m [ { img "worker_male_01_sit.png" mask "worker_male_01_sit_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 } ]
				eat-sit-r-m [ { img "worker_male_01_sit.png" mask "worker_male_01_sit_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 hflip #true } ]
				eat-sit-f-m [ { img "worker_male_01_sit_front.png" mask "worker_male_01_sit_front_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 } ]
				eat-sit-b-m [ { img "worker_male_01_sit_back.png" mask "worker_male_01_sit_back_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 } ]
				shop-m [ { img "worker_male_01_stand_back.png" mask "worker_male_01_stand_back_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 } ]
				work-r-m [ { img "worker_male_01_sit_side_newspaper.png" mask "worker_male_01_sit_side_newspaper_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 hflip #true playhours 0.5 } 
							{ img "worker_male_01_sit.png" mask "worker_male_01_sit_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 hflip #true playhours 0.5 }
				]
				work-l-m [ { img "worker_male_01_sit_side_newspaper.png" mask "worker_male_01_sit_side_newspaper_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.5 } 
							{ img "worker_male_01_sit.png" mask "worker_male_01_sit_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.5 }
				]
				work-f-m [ { img "worker_male_01_sit_front.png" mask "worker_male_01_sit_front_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.5 }
							{ img "worker_male_01_sit_quarter_newspaper.png" mask "worker_male_01_sit_quarter_newspaper_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.5 } ]
				work-b-m [ { img "worker_male_01_stand_back.png" mask "worker_male_01_stand_back_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 } ]
				dotask-m [ { img "worker_male_01_hammer_stand_back.png" mask "worker_male_01_hammer_stand_back_mask.png" atlas hdpeeps layer worker framecount 2 fps 4 dy 8 dx -12 } ]
				unhappy-m [ { img "worker_male_01_stand_front_upset.png" mask "worker_male_01_stand_front_upset_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 } ]
				warning-m [ { img "worker_male_01_stand_front.png" mask "worker_male_01_stand_front_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 } ]

				default-f [ { img "worker_female_01_stand_front.png" mask "worker_female_01_stand_front_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 } ]
				stand-r-f [ { img "worker_female_01_stand_side.png" mask "worker_female_01_stand_side_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 hflip #true } ]
				stand-l-f [ { img "worker_female_01_stand_side.png" mask "worker_female_01_stand_side_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 } ]
				escalator-r-f [ { img "worker_female_01_stand_side.png" mask "worker_female_01_stand_side_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 hflip #true } ]
				escalator-l-f [ { img "worker_female_01_stand_side.png" mask "worker_female_01_stand_side_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 } ]
				walk-r-f [ { img "worker_female_001.png" mask "worker_female_001_mask.png" atlas hdpeeps layer walker framecount 13 fps 13 dy 8 hflip #true } ]
				walk-l-f [ { img "worker_female_001.png" mask "worker_female_001_mask.png" atlas hdpeeps layer walker framecount 13 fps 13 dy 8 } ]
				stairs-r-f [ { img "worker_female_001.png" mask "worker_female_001_mask.png" atlas hdpeeps layer worker framecount 13 fps 13 dy 8 hflip #true } ]
				stairs-l-f [ { img "worker_female_001.png" mask "worker_female_001_mask.png" atlas hdpeeps layer worker framecount 13 fps 13 dy 8 } ]
				deliver-r-f [ { img "worker_female_001.png" mask "worker_female_001_mask.png" atlas hdpeeps layer walker framecount 13 fps 13 dy 8 hflip #true } ]
				deliver-l-f [ { img "worker_female_001.png" mask "worker_female_001_mask.png" atlas hdpeeps layer walker framecount 13 fps 13 dy 8 } ]
				deliver-stairs-r-f [ { img "worker_female_001.png" mask "worker_female_001_mask.png" atlas hdpeeps layer worker framecount 13 fps 13 dy 8 hflip #true } ]
				deliver-stairs-l-f [ { img "worker_female_001.png" mask "worker_female_001_mask.png" atlas hdpeeps layer worker framecount 13 fps 13 dy 8 } ]
				eat-f [ { img "worker_female_01_stand_back.png" mask "worker_female_01_stand_back_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 } ]
				eat-sit-l-f [ { img "worker_female_01_sit.png" mask "worker_female_01_sit_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 } ]
				eat-sit-r-f [ { img "worker_female_01_sit.png" mask "worker_female_01_sit_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 hflip #true } ]
				eat-sit-f-f [ { img "worker_female_01_sit_front.png" mask "worker_female_01_sit_front_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 } ]
				eat-sit-b-f [ { img "worker_female_01_sit_back.png" mask "worker_female_01_sit_back_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 } ]
				shop-f [ { img "worker_female_01_stand_back.png" mask "worker_female_01_stand_back_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 } ]
				work-r-f [ { img "worker_female_01_sit_side_newspaper.png" mask "worker_female_01_sit_side_newspaper_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 hflip #true playhours 0.5 } 
							{ img "worker_female_01_sit.png" mask "worker_female_01_sit_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 hflip #true playhours 0.5 }
				]
				work-l-f [ { img "worker_female_01_sit_side_newspaper.png" mask "worker_female_01_sit_side_newspaper_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.5 }
							{ img "worker_female_01_sit.png" mask "worker_female_01_sit_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.5 }
				]
				work-f-f [ { img "worker_female_01_sit_front.png" mask "worker_female_01_sit_front_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.5 }
							{ img "worker_female_01_sit_quarter_newspaper.png" mask "worker_female_01_sit_quarter_newspaper_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.5 } ]
				work-b-f [ { img "worker_female_01_stand_back.png" mask "worker_female_01_stand_back_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 } ]
				dotask-f [ { img "worker_female_01_drill_stand_back.png" mask "worker_female_01_drill_stand_back_mask.png" atlas hdpeeps layer worker framecount 4 fps 4 dy 8 dx -8 } ]
				unhappy-f [ { img "worker_female_02_stand_front_upset.png" mask "worker_female_02_stand_front_upset_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 } ]
				warning-f [ { img "worker_female_01_stand_front.png" mask "worker_female_01_stand_front_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 } ]
			}
		}
	}

	{
		ident { template "npc-support-maintenance-1" parent "npc-support" }
		navigation {
			speed 100
			maxpathcost 1000000
		}
		peep {
			tasktypes [ taskrepair taskrenovate ]
			schedule "schedule-maintenance-1"
		}
		sprite {
			colors {
				b { from 85 to 86 }
			}
		}
	}
	{
		ident { template "npc-support-maintenance-2" parent "npc-support-maintenance-1" }
		peep {
			schedule "schedule-maintenance-2"
		}
	}
	{
		ident { template "npc-support-construction-1" parent "npc-support" }
		navigation {
			speed 100
			maxpathcost 1000000
		}
		peep {
			tasktypes [ taskremove taskbuild taskbuildwall ]
			schedule "schedule-construction-1"
		}
		sprite {
			colors {
				b { from 15 to 16 }
			}
		}
	}
	{
		ident { template "npc-support-garbage" parent "npc-support-maintenance-1" }
		peep {
			tasktypes [ TaskTrashCollect tasktrashdestroy ]
			schedule "schedule-garbage"
		}
		sprite {
			colors {
				b { from 25 to 26 }
			}
		}
	}
	{
		ident { template "npc-support-construction-2" parent "npc-support-construction-1" }
		peep {
			schedule "schedule-construction-2"
		}
	}
	{
		ident { template "npc-service-handyman" parent "npc-support" }
		peep {
			tasktypes [ servicehandyman ]
			schedule "schedule-service-repair"
		}
		sprite {
			colors {
				b { from 152 to 153 }
			}
		}

	}
	{
		ident { template "npc-service-plumber" parent "npc-support" }
		peep {
			tasktypes [ serviceplumber ]
			schedule "schedule-service-repair"
		}
		sprite {
			colors {
				b { from 190 to 191 }
			}
		}
	}
	{
		ident { template "npc-support-metro-1" parent "npc-support" }
		peep {
			schedule "schedule-metro-1"
		}
		sprite {
			colors {
				b { from 37 to 38 }
			}
			animations {
				work-f-m [ { img "worker_male_01_stand_front.png" mask "worker_male_01_stand_front_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 } ]
				work-f-f [ { img "worker_female_01_stand_front.png" mask "worker_female_01_stand_front_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 } ]
			}
		}
	}
	{
		ident { template "npc-support-metro-2" parent "npc-support-metro-1" }
		peep {
			schedule "schedule-metro-2"
		}
	}
	{
		ident { template "npc-support-metro-3" parent "npc-support-metro-1" }
		peep {
			schedule "schedule-metro-3"
		}
	}
	{
		ident { template "npc-support-metro-4" parent "npc-support-metro-1" }
		peep {
			schedule "schedule-metro-4"
		}
	}

	;;;;;; service NPCs

	{
		ident { template "npc-service" parent "npc" }
		navigation {
			speed 80
		}
		peep {
		}
		sprite {
			animations {
				default-m [ { img "worker_male_02_stand_front.png" mask "worker_male_02_stand_front_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 } ]
				stand-r-m [ { img "worker_male_02_stand_side.png" mask "worker_male_02_stand_side_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 hflip #true } ]
				stand-l-m [ { img "worker_male_02_stand_side.png" mask "worker_male_02_stand_side_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 } ]
				escalator-r-m [ { img "worker_male_02_stand_side.png" mask "worker_male_02_stand_side_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 hflip #true } ]
				escalator-l-m [ { img "worker_male_02_stand_side.png" mask "worker_male_02_stand_side_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 } ]
				walk-r-m [ { img "worker_male_02_001.png" mask "worker_male_02_001_mask.png" atlas hdpeeps layer walker framecount 13 fps 13 dy 8 hflip #true } ]
				walk-l-m [ { img "worker_male_02_001.png" mask "worker_male_02_001_mask.png" atlas hdpeeps layer walker framecount 13 fps 13 dy 8 } ]
				stairs-r-m [ { img "worker_male_02_001.png" mask "worker_male_02_001_mask.png" atlas hdpeeps layer worker framecount 13 fps 13 dy 8 hflip #true } ]
				stairs-l-m [ { img "worker_male_02_001.png" mask "worker_male_02_001_mask.png" atlas hdpeeps layer worker framecount 13 fps 13 dy 8 } ]
				deliver-r-m [ { img "worker_male_02_001.png" mask "worker_male_02_001_mask.png" atlas hdpeeps layer walker framecount 13 fps 13 dy 8 hflip #true } ]
				deliver-l-m [ { img "worker_male_02_001.png" mask "worker_male_02_001_mask.png" atlas hdpeeps layer walker framecount 13 fps 13 dy 8 } ]
				deliver-stairs-r-m [ { img "worker_male_02_001.png" mask "worker_male_02_001_mask.png" atlas hdpeeps layer worker framecount 13 fps 13 dy 8 hflip #true } ]
				deliver-stairs-l-m [ { img "worker_male_02_001.png" mask "worker_male_02_001_mask.png" atlas hdpeeps layer worker framecount 13 fps 13 dy 8 } ]
				eat-m [ { img "worker_male_02_stand_back.png" mask "worker_male_02_stand_back_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 } ]
				eat-sit-l-m [ { img "worker_male_02_sit.png" mask "worker_male_02_sit_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 } ]
				eat-sit-r-m [ { img "worker_male_02_sit.png" mask "worker_male_02_sit_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 hflip #true } ]
				eat-sit-f-m [ { img "worker_male_02_sit_front.png" mask "worker_male_02_sit_front_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 } ]
				eat-sit-b-m [ { img "worker_male_02_sit_back.png" mask "worker_male_02_sit_back_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 } ]
				shop-m [ { img "worker_male_02_stand_back.png" mask "worker_male_02_stand_back_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 } ]
				work-r-m [ { img "worker_male_02_001.png" mask "worker_male_02_001_mask.png" atlas hdpeeps layer worker framecount 13 fps 0 dy 8 hflip #true playhours 0.5 } 
							{ img "worker_male_02_stand_side_machine.png" mask "worker_male_02_stand_side_machine_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.5 hflip #true }
				]
				work-l-m [ { img "worker_male_02_001.png" mask "worker_male_02_001_mask.png" atlas hdpeeps layer worker framecount 13 fps 0 dy 8 playhours 0.5 } 
							{ img "worker_male_02_stand_side_machine.png" mask "worker_male_02_stand_side_machine_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.5 }
				]
				work-f-m [ { img "worker_male_02_stand_front.png" mask "worker_male_02_stand_front_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.5 } 
							{ img "worker_male_02_stand_front_phone.png" mask "worker_male_02_stand_front_phone_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.5 }
							{ img "worker_male_01_stand_front_machine.png" mask "worker_male_01_stand_front_machine_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.5 }
				]
				work-b-m [ { img "worker_male_02_stand_back.png" mask "worker_male_02_stand_back_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 } ]
				dotask-m [ { img "worker_male_02_stand_back.png" mask "worker_male_02_stand_back_mask.png" atlas hdpeeps layer walker framecount 1 fps 1 dy 8 } ]
				unhappy-m [ { img "worker_male_01_stand_front_upset.png" mask "worker_male_01_stand_front_upset_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 } ]
				warning-m [ { img "worker_male_02_stand_front.png" mask "worker_male_02_stand_front_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 } ]

				default-f [ { img "worker_female_02_stand_front.png" mask "worker_female_02_stand_front_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 } ]
				stand-r-f [ { img "worker_female_02_stand_side.png" mask "worker_female_02_stand_side_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 hflip #true } ]
				stand-l-f [ { img "worker_female_02_stand_side.png" mask "worker_female_02_stand_side_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 } ]
				escalator-r-f [ { img "worker_female_02_stand_side.png" mask "worker_female_02_stand_side_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 hflip #true } ]
				escalator-l-f [ { img "worker_female_02_stand_side.png" mask "worker_female_02_stand_side_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 } ]
				walk-r-f [ { img "worker_female_02_001.png" mask "worker_female_02_001_mask.png" atlas hdpeeps layer walker framecount 13 fps 13 dy 8 hflip #true } ]
				walk-l-f [ { img "worker_female_02_001.png" mask "worker_female_02_001_mask.png" atlas hdpeeps layer walker framecount 13 fps 13 dy 8 } ]
				stairs-r-f [ { img "worker_female_02_001.png" mask "worker_female_02_001_mask.png" atlas hdpeeps layer worker framecount 13 fps 13 dy 8 hflip #true } ]
				stairs-l-f [ { img "worker_female_02_001.png" mask "worker_female_02_001_mask.png" atlas hdpeeps layer worker framecount 13 fps 13 dy 8 } ]
				deliver-r-f [ { img "worker_female_02_001.png" mask "worker_female_02_001_mask.png" atlas hdpeeps layer walker framecount 13 fps 13 dy 8 hflip #true } ]
				deliver-l-f [ { img "worker_female_02_001.png" mask "worker_female_02_001_mask.png" atlas hdpeeps layer walker framecount 13 fps 13 dy 8 } ]
				deliver-stairs-r-f [ { img "worker_female_02_001.png" mask "worker_female_02_001_mask.png" atlas hdpeeps layer worker framecount 13 fps 13 dy 8 hflip #true } ]
				deliver-stairs-l-f [ { img "worker_female_02_001.png" mask "worker_female_02_001_mask.png" atlas hdpeeps layer worker framecount 13 fps 13 dy 8 } ]
				eat-f [ { img "worker_female_02_stand_back.png" mask "worker_female_02_stand_back_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 } ]
				eat-sit-l-f [ { img "worker_female_02_sit.png" mask "worker_female_02_sit_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 } ]
				eat-sit-r-f [ { img "worker_female_02_sit.png" mask "worker_female_02_sit_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 hflip #true } ]
				eat-sit-f-f [ { img "worker_female_02_sit_front.png" mask "worker_female_02_sit_front_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 } ]
				eat-sit-b-f [ { img "worker_female_02_sit_back.png" mask "worker_female_02_sit_back_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 } ]
				shop-f [ { img "worker_female_02_stand_back.png" mask "worker_female_02_stand_back_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 } ]
				work-r-f [ { img "worker_female_02_001.png" mask "worker_female_02_001_mask.png" atlas hdpeeps layer worker framecount 13 fps 0 dy 8 playhours 0.5 hflip #true } 
							{ img "worker_female_02_stand_side_machine.png" mask "worker_female_02_stand_side_machine_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.5 hflip #true }
				]
				work-l-f [ { img "worker_female_02_sit.png" mask "worker_female_02_sit_mask.png" atlas hdpeeps layer worker framecount 13 fps 0 dy 8 playhours 0.5 } 
							{ img "worker_female_02_stand_side_machine.png" mask "worker_female_02_stand_side_machine_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.5 }
				]
				work-f-f [ { img "worker_female_02_stand_front.png" mask "worker_female_02_stand_front_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.5 } 
							{ img "worker_female_02_stand_front_phone.png" mask "worker_female_02_stand_front_phone_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.5 }
							{ img "worker_female_02_stand_front_machine.png" mask "worker_female_02_stand_front_machine_mask.png" atlas hdpeeps layer worker framecount 1 fps 1 dy 8 playhours 0.5 }
				]
				work-b-f [ { img "worker_female_02_stand_back.png" mask "worker_female_02_stand_back_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 } ]
				dotask-f [ { img "worker_female_02_stand_back.png" mask "worker_female_02_stand_back_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 } ]
				unhappy-f [ { img "worker_female_01_stand_front_upset.png" mask "worker_female_01_stand_front_upset_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 } ]
				warning-f [ { img "worker_female_02_stand_front.png" mask "worker_female_02_stand_front_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 } ]
			}
		}
	}

	{
		ident { template "npc-service-courier" parent "npc-service" }
		peep {
			tasktypes [ servicecourier ]
			schedule "schedule-service-delivery"
		}
		sprite {
			colors {
				b { from 166 to 168 }
			}
		}
	}
	{
		ident { template "npc-service-supplies" parent "npc-service"}
		peep {
			tasktypes [ servicesupplies ]
			schedule "schedule-service-items"
		}
		sprite {
			colors {
				b { from 150 to 151 }
			}
		}
	}
	{
		ident { template "npc-service-water" parent "npc-service" }
		peep {
			tasktypes [ servicewater ]
			schedule "schedule-service-delivery"
		}
		sprite {
			colors {
				b { from 92 to 93 }
			}
		}
	}
	{
		ident { template "npc-service-cleaning" parent "npc-service" }
		peep {
			tasktypes [ servicejanitor ]
			schedule "schedule-service-cleaning-night"
		}
		sprite {
			colors {
				b { from 75 to 76 }
			}
		}
	}
	{
		ident { template "npc-service-copy" parent "npc-service" }
		peep {
			tasktypes [ servicecopy ]
			schedule "schedule-service-items"
		}
		sprite {
			colors {
				b { from 150 to 151 }
			}
		}
	}
	{
		ident { template "npc-service-printer" parent "npc-service" }
		peep {
			tasktypes [ serviceprinter ]
			schedule "schedule-service-items"
		}
		sprite {
			colors {
				b { from 150 to 151 }
			}
		}
	}
	{
		ident { template "npc-service-computer" parent "npc-service" }
		peep {
			tasktypes [ servicecomputer ]
			schedule "schedule-service-equipment"
		}
		sprite {
			colors {
				b { from 150 to 151 }
			}
		}
	}
	{
		ident { template "npc-service-storage" parent "npc-service" }
		peep {
			tasktypes [ servicestorage ]
			schedule "schedule-service-equipment"
		}
		sprite {
			colors {
				b { from 150 to 151 }
			}
		}
	}
	{
		ident { template "npc-service-catering" parent "npc-service" }
		navigation {
			speed 100
		}
		peep {
			tasktypes [ servicecatering ]
			schedule "schedule-service-catering"
		}
		sprite {
			colors {
				b { from 95 to 96 }
			}
		}
	}
	{
		ident { template "npc-service-laundry" parent "npc-service" }
		peep {
			tasktypes [ servicelaundry ]
			schedule "schedule-service-laundry"
		}
		sprite {
			colors {
				b { from 75 to 76 }
			}
		}
	}
	{
		ident { template "npc-service-dogwalker" parent "npc-service" }
		peep {
			tasktypes [ servicedogs ]
			schedule "schedule-service-residences-day"
		}
		sprite {
			colors {
				b { from 243 to 244 }
			}
		}
	}
	{
		ident { template "npc-service-housekeeping" parent "npc-service" }
		peep {
			tasktypes [ servicecleaning ]
			schedule "schedule-service-residences-day"
		}
		sprite {
			colors {
				b { from 75 to 76 }
			}
		}
	}
	{
		ident { template "npc-service-auditor" parent "npc-officeworker-office.a" }
		peep {
			tasktypes [ serviceauditors ]
			schedule "schedule-service-whitecollar"
		}
		sprite {
			colors {
				b { from 130 to 131 }
			}
		}
	}
	{
		ident { template "npc-service-temps" parent "npc-officeworker-office.a" }
		peep {
			tasktypes [ servicetemps ]
			schedule "schedule-service-whitecollar"
		}
		sprite {
			colors {
				b { from 130 to 131 }
			}
		}
	}
	{
		ident { template "npc-service-fitness" parent "npc-resident.a" }
		peep {
			tasktypes [ servicefitness ]
			schedule "schedule-service-whitecollar"
		}
		sprite {
			colors {
				b { from 75 to 76 }
			}
		}
	}
	{
		ident { template "npc-service-security" parent "npc-support" }
		peep {
			tasktypes [ servicesecurity ]
			schedule "schedule-service-whitecollar"
		}
		sprite {
			colors {
				b { from 148 to 149 }
			}
		}
	}
	{
		ident { template "npc-service-design" parent "npc-officeworker-office.b" }
		peep {
			tasktypes [ servicedesign ]
			schedule "schedule-service-whitecollar"
		}
		sprite {
			colors {
				b { from 235 to 236 }
			}
		}
	}
	{
		ident { template "npc-service-loadingdock" parent "npc-service"}
		peep {
			schedule "schedule-loading-dock"
		}
		sprite {
			colors {
				b { from 150 to 151 }
			}
		}
	}
	{
		ident { template "npc-service-drycleaner" parent "npc-retail" }
		peep {
			schedule "schedule-service-residences-day"
			tasktypes [ servicedrycleaning ]
		}
		sprite {
			colors {
				b { from 228 to 229 }
			}
		}
	}
	{
		ident { template "npc-service-flowers" parent "npc-retail" }
		peep {
			schedule "schedule-service-residences-day"
			tasktypes [ serviceflowers ]
		}
		sprite {
			colors {
				b { from 228 to 229 }
			}
		}
	}
	{
		ident { template "npc-serivce-tailor" parent "npc-retail" }
		peep {
			schedule "schedule-service-residences-day"
			tasktypes [ servicetailor ]
		}
		sprite {
			colors {
				b { from 151 to 152 }
			}
		}
	}
	{
		ident { template "npc-service-daycare" parent "npc-resident.a" }
		peep {
			schedule "schedule-service-residences-day"
			tasktypes [ servicedaycare ]
		}
		sprite {
			colors {
				b { from 102 to 113 }
			}
		}
	}
	{
		ident { template "npc-service-dogsitter" parent "npc-service" }
		peep {
			schedule "schedule-service-residences-day"
			tasktypes [ servicedogdaycare ]
		}
		sprite {
			colors {
				b { from 243 to 244 }
			}
		}
	}
	{
		ident { template "npc-service-gym" parent "npc-resident.a" }
		peep {
			schedule "schedule-service-residences-day"
			tasktypes [ servicegym ]
		}
		sprite {
			colors {
				b { from 75 to 76 }
			}
		}
	}
	{
		ident { template "npc-service-club" parent "npc-restaurant.b" }
		peep {
			schedule "schedule-service-club"
		}
		sprite {
			colors {
				b { from 133 to 134 }
			}
		}
	}
	{
		ident { template "npc-service-helicopter" parent "npc-service" }
		peep {
			tasktypes [ servicehelicopter ]
			schedule "schedule-service-equipment"
		}
		sprite {
			colors {
				b { from 229 to 230 }
			}
		}
	}
	{
		ident { template "npc-service-limo" parent "npc-restaurant.b" }
		peep {
			tasktypes [ servicelimo ]
			schedule "schedule-service-equipment"
		}
		sprite {
			colors {
				b { from 133 to 134 }
			}
		}
	}
	{
		ident { template "npc-service-yoga" parent "npc-resident.a" }
		peep {
			tasktypes [ serviceyoga ]
			schedule "schedule-service-highend-res"
		}
		sprite {
			colors {
				b { from 99 to 100 }
			}
		}
	}
	{
		ident { template "npc-service-decorator" parent "npc-officeworker-office.b" }
		peep {
			tasktypes [ servicedecorator ]
			schedule "schedule-service-highend-res"
		}
		sprite {
			colors {
				b { from 137 to 138 }
			}
		}
	}
	{
		ident { template "npc-service-finance" parent "npc-service-decorator" }
		peep {
			tasktypes [ servicefinance ]
			schedule "schedule-service-highend-res"
		}
	}



	;;;;;;;;;;;;;;;;;;;; restaurant NPCs

	{
		ident { template "npc-restaurant" parent "npc" }
		navigation {
			speed 100
		}
		peep {
		}
	}
	{
		ident { template "npc-restaurant.a" parent "npc-restaurant" }  ;;; visualz and sprytz onli pleez
		sprite {
			animations {
				default-m [ { img "rest_male_01_stand_front.png" mask "rest_male_01_stand_front_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 } ]
				stand-r-m [ { img "rest_male_01_stand_side.png" mask "rest_male_01_stand_side_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 hflip #true } ]
				stand-l-m [ { img "rest_male_01_stand_side.png" mask "rest_male_01_stand_side_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 } ]
				escalator-r-m [ { img "rest_male_01_stand_side.png" mask "rest_male_01_stand_side_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 hflip #true } ]
				escalator-l-m [ { img "rest_male_01_stand_side.png" mask "rest_male_01_stand_side_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 } ]
				walk-r-m [ { img "rest_male_01_base.png" mask "rest_male_01_base_mask.png" atlas hdpeeps layer walker framecount 13 fps 12 dy 8 hflip #true } ]
				walk-l-m [ { img "rest_male_01_base.png" mask "rest_male_01_base_mask.png" atlas hdpeeps layer walker framecount 13 fps 12 dy 8 } ]
				stairs-r-m [ { img "rest_male_01_base.png" mask "rest_male_01_base_mask.png" atlas hdpeeps layer worker framecount 13 fps 12 dy 8 hflip #true } ]
				stairs-l-m [ { img "rest_male_01_base.png" mask "rest_male_01_base_mask.png" atlas hdpeeps layer worker framecount 13 fps 12 dy 8 } ]
				deliver-r-m [ { img "rest_male_01_base.png" mask "rest_male_01_base_mask.png" atlas hdpeeps layer walker framecount 13 fps 12 dy 8 hflip #true } ]
				deliver-l-m [ { img "rest_male_01_base.png" mask "rest_male_01_base_mask.png" atlas hdpeeps layer walker framecount 13 fps 12 dy 8 } ]
				deliver-stairs-r-m [ { img "rest_male_01_base.png" mask "rest_male_01_base_mask.png" atlas hdpeeps layer worker framecount 13 fps 12 dy 8 hflip #true } ]
				deliver-stairs-l-m [ { img "rest_male_01_base.png" mask "rest_male_01_base_mask.png" atlas hdpeeps layer worker framecount 13 fps 12 dy 8 } ]
				eat-m [ { img "rest_male_01_stand_back.png" mask "rest_male_01_stand_back_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 } ]
				eat-sit-l-m [ { img "rest_male_01_sit_side.png" mask "rest_male_01_sit_side_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 } ]
				eat-sit-r-m [ { img "rest_male_01_sit_side.png" mask "rest_male_01_sit_side_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 hflip #true } ]
				eat-sit-f-m [ { img "rest_male_01_sit_front.png" mask "rest_male_01_sit_front_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 } ]
				eat-sit-b-m [ { img "rest_male_01_stand_front.png" mask "rest_male_01_stand_front_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 } ]
				shop-m [ { img "rest_male_01_stand_back.png" mask "rest_male_01_stand_back_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 } ]
				work-r-m [ { img "rest_male_01_stand_side.png" mask "rest_male_01_stand_side_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 hflip #true } 
							{ img "rest_male_01_stand_side_order.png" mask "rest_male_01_stand_side_order_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 hflip #true }
				]
				work-l-m [ { img "rest_male_01_stand_side.png" mask "rest_male_01_stand_side_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 } 
							{ img "rest_male_01_stand_side_order.png" mask "rest_male_01_stand_side_order_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 }
				]
				work-f-m [ { img "rest_male_01_stand_front.png" mask "rest_male_01_stand_front_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.5 }
							{ img "rest_male_01_stand_front_phone.png" mask "rest_male_01_stand_front_phone_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.5 }
							{ img "rest_male_01_stand_front_machine.png" mask "rest_male_01_stand_front_machine_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.5 }
							{ img "rest_male_01_stand_front_order.png" mask "rest_male_01_stand_front_order_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.5 }
				]
				work-b-m [ { img "rest_male_01_stand_back.png" mask "rest_male_01_stand_back_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 } ]
				dotask-m [ { img "rest_male_01_stand_front.png" mask "rest_male_01_stand_front_mask.png" atlas hdpeeps layer walker framecount 1 fps 1 dy 8 } ]
				unhappy-m [ { img "rest_male_01_stand_front_upset.png" mask "rest_male_01_stand_front_upset_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 } ]
				warning-m [ { img "rest_male_01_stand_front.png" mask "rest_male_01_stand_front_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 } ]

				default-f [ { img "rest_female_01_stand_front.png" mask "rest_female_01_stand_front_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 } ]
				stand-r-f [ { img "rest_female_01_stand_side.png" mask "rest_female_01_stand_side_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 hflip #true } ]
				stand-l-f [ { img "rest_female_01_stand_side.png" mask "rest_female_01_stand_side_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 } ]
				escalator-r-f [ { img "rest_female_01_stand_side.png" mask "rest_female_01_stand_side_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 hflip #true } ]
				escalator-l-f [ { img "rest_female_01_stand_side.png" mask "rest_female_01_stand_side_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 } ]
				walk-r-f [ { img "rest_female_01.png" mask "rest_female_01_mask.png" atlas hdpeeps layer walker framecount 13 fps 12 dy 8 hflip #true } ]
				walk-l-f [ { img "rest_female_01.png" mask "rest_female_01_mask.png" atlas hdpeeps layer walker framecount 13 fps 12 dy 8 } ]
				stairs-r-f [ { img "rest_female_01.png" mask "rest_female_01_mask.png" atlas hdpeeps layer worker framecount 13 fps 12 dy 8 hflip #true } ]
				stairs-l-f [ { img "rest_female_01.png" mask "rest_female_01_mask.png" atlas hdpeeps layer worker framecount 13 fps 12 dy 8 } ]
				deliver-r-f [ { img "rest_female_01.png" mask "rest_female_01_mask.png" atlas hdpeeps layer walker framecount 13 fps 12 dy 8 hflip #true } ]
				deliver-l-f [ { img "rest_female_01.png" mask "rest_female_01_mask.png" atlas hdpeeps layer walker framecount 13 fps 12 dy 8 } ]
				deliver-stairs-r-f [ { img "rest_female_01.png" mask "rest_female_01_mask.png" atlas hdpeeps layer worker framecount 13 fps 12 dy 8 hflip #true } ]
				deliver-stairs-l-f [ { img "rest_female_01.png" mask "rest_female_01_mask.png" atlas hdpeeps layer worker framecount 13 fps 12 dy 8 } ]
				eat-f [ { img "rest_female_01_stand_back.png" mask "rest_female_01_stand_back_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 } ]
				eat-sit-l-f [ { img "rest_female_01_sit_side.png" mask "rest_female_01_sit_side_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 } ]
				eat-sit-r-f [ { img "rest_female_01_sit_side.png" mask "rest_female_01_sit_side_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 hflip #true } ]
				eat-sit-f-f [ { img "rest_female_01_sit_front.png" mask "rest_female_01_sit_front_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 } ]
				eat-sit-b-f [ { img "rest_female_01_sit_back.png" mask "rest_female_01_sit_back_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 } ]
				shop-f [ { img "rest_female_01_stand_back.png" mask "rest_female_01_stand_back_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 } ]
				work-r-f [ { img "rest_female_01_stand_side.png" mask "rest_female_01_stand_side_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 hflip #true } 
							{ img "rest_female_01_stand_side_order.png" mask "rest_female_01_stand_side_order_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 hflip #true }
				]
				work-l-f [ { img "rest_female_01_stand_side.png" mask "rest_female_01_stand_side_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 } 
							{ img "rest_female_01_stand_side_order.png" mask "rest_female_01_stand_side_order_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 }
				]
				work-f-f [ { img "rest_female_01_stand_front.png" mask "rest_female_01_stand_front_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.5 }
							{ img "rest_female_01_stand_front_phone.png" mask "rest_female_01_stand_front_phone_mask.png" layer worker atlas hdpeeps framecount 1 fps 0 dy 8 playhours 0.5 }
							{ img "rest_female_01_stand_front_machine.png" mask "rest_female_01_stand_front_machine_mask.png" layer worker atlas hdpeeps framecount 1 fps 0 dy 8 playhours 0.5 }
							{ img "rest_female_01_stand_front_order.png" mask "rest_female_01_stand_front_order_mask.png" layer worker atlas hdpeeps framecount 1 fps 0 dy 8 playhours 0.5 }
				]
				work-b-f [ { img "rest_female_01_stand_back.png" mask "rest_female_01_stand_back_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 } ]
				dotask-f [ { img "rest_female_01_stand_front.png" mask "rest_female_01_stand_front_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 } ]
				unhappy-f [ { img "rest_female_01_stand_front_upset.png" mask "rest_female_01_stand_front_upset_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 } ]
				warning-f [ { img "rest_female_01_stand_front.png" mask "rest_female_01_stand_front_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 } ]
			}
			colors {
				b { from 1 to 2 }
			}
		}
	}
	{
		ident { template "npc-restaurant.b" parent "npc-restaurant" }  ;;; visualz and sprytz onli pleez
		sprite {
			animations {
				default-m [ { img "fancy_male_01_stand_front.png" mask "fancy_male_01_stand_front_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 } ]
				stand-r-m [ { img "fancy_male_01_stand_side.png" mask "fancy_male_01_stand_side_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 hflip #true } ]
				stand-l-m [ { img "fancy_male_01_stand_side.png" mask "fancy_male_01_stand_side_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 } ]
				escalator-r-m [ { img "fancy_male_01_stand_side.png" mask "fancy_male_01_stand_side_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 hflip #true } ]
				escalator-l-m [ { img "fancy_male_01_stand_side.png" mask "fancy_male_01_stand_side_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 } ]
				walk-r-m [ { img "fancy_male_01.png" mask "fancy_male_01_mask.png" atlas hdpeeps layer walker framecount 13 fps 12 dy 8 hflip #true } ]
				walk-l-m [ { img "fancy_male_01.png" mask "fancy_male_01_mask.png" atlas hdpeeps layer walker framecount 13 fps 12 dy 8 } ]
				stairs-r-m [ { img "fancy_male_01.png" mask "fancy_male_01_mask.png" atlas hdpeeps layer worker framecount 13 fps 12 dy 8 hflip #true } ]
				stairs-l-m [ { img "fancy_male_01.png" mask "fancy_male_01_mask.png" atlas hdpeeps layer worker framecount 13 fps 12 dy 8 } ]
				deliver-r-m [ { img "fancy_male_01.png" mask "fancy_male_01_mask.png" atlas hdpeeps layer walker framecount 13 fps 12 dy 8 hflip #true } ]
				deliver-l-m [ { img "fancy_male_01.png" mask "fancy_male_01_mask.png" atlas hdpeeps layer walker framecount 13 fps 12 dy 8 } ]
				deliver-stairs-r-m [ { img "fancy_male_01.png" mask "fancy_male_01_mask.png" atlas hdpeeps layer worker framecount 13 fps 12 dy 8 hflip #true } ]
				deliver-stairs-l-m [ { img "fancy_male_01.png" mask "fancy_male_01_mask.png" atlas hdpeeps layer worker framecount 13 fps 12 dy 8 } ]
				eat-m [ { img "fancy_male_01_stand_back.png" mask "fancy_male_01_stand_back_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 } ]
				eat-sit-l-m [ { img "fancy_male_01_sit_side.png" mask "fancy_male_01_sit_side_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 } ]
				eat-sit-r-m [ { img "fancy_male_01_sit_side.png" mask "fancy_male_01_sit_side_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 hflip #true } ]
				eat-sit-f-m [ { img "fancy_male_01_sit_front.png" mask "fancy_male_01_sit_front_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 } ]
				eat-sit-b-m [ { img "fancy_male_01_stand_front.png" mask "fancy_male_01_stand_front_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 } ]
				shop-m [ { img "fancy_male_01_stand_back.png" mask "fancy_male_01_stand_back_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 } ]
				work-r-m [ { img "fancy_male_01.png" mask "fancy_male_01_mask.png" atlas hdpeeps layer worker framecount 13 fps 0 dy 8 hflip #true } ]
				work-l-m [ { img "fancy_male_01.png" mask "fancy_male_01_mask.png" atlas hdpeeps layer worker framecount 13 fps 0 dy 8 } ]
				work-f-m [ { img "fancy_male_01_stand_front.png" mask "fancy_male_01_stand_front_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.5 } 
							{ img "fancy_male_01_stand_front_phone.png" mask "fancy_male_01_stand_front_phone_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.5 }
				]
				work-b-m [ { img "fancy_male_01_stand_back.png" mask "fancy_male_01_stand_back_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 } ]
				dotask-m [ { img "fancy_male_01_stand_front.png" mask "fancy_male_01_stand_front_mask.png" atlas hdpeeps layer walker framecount 1 fps 1 dy 8 } ]
				unhappy-m [ { img "fancy_male_01_stand_front_upset.png" mask "fancy_male_01_stand_front_upset_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 } ]
				warning-m [ { img "fancy_male_01_stand_front.png" mask "fancy_male_01_stand_front_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 } ]

				default-f [ { img "fancy_female_01_stand_front.png" mask "fancy_female_01_stand_front_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 } ]
				stand-r-f [ { img "fancy_female_01_stand_side.png" mask "fancy_female_01_stand_side_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 hflip #true } ]
				stand-l-f [ { img "fancy_female_01_stand_side.png" mask "fancy_female_01_stand_side_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 } ]
				escalator-r-f [ { img "fancy_female_01_stand_side.png" mask "fancy_female_01_stand_side_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 hflip #true } ]
				escalator-l-f [ { img "fancy_female_01_stand_side.png" mask "fancy_female_01_stand_side_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 } ]
				walk-r-f [ { img "fancy_female_01.png" mask "fancy_female_01_mask.png" atlas hdpeeps layer walker framecount 11 fps 12 dy 8 hflip #true } ]
				walk-l-f [ { img "fancy_female_01.png" mask "fancy_female_01_mask.png" atlas hdpeeps layer walker framecount 11 fps 12 dy 8 } ]
				stairs-r-f [ { img "fancy_female_01.png" mask "fancy_female_01_mask.png" atlas hdpeeps layer worker framecount 11 fps 12 dy 8 hflip #true } ]
				stairs-l-f [ { img "fancy_female_01.png" mask "fancy_female_01_mask.png" atlas hdpeeps layer worker framecount 11 fps 12 dy 8 } ]
				deliver-r-f [ { img "fancy_female_01.png" mask "fancy_female_01_mask.png" atlas hdpeeps layer walker framecount 11 fps 12 dy 8 hflip #true } ]
				deliver-l-f [ { img "fancy_female_01.png" mask "fancy_female_01_mask.png" atlas hdpeeps layer walker framecount 11 fps 12 dy 8 } ]
				deliver-stairs-r-f [ { img "fancy_female_01.png" mask "fancy_female_01_mask.png" atlas hdpeeps layer worker framecount 11 fps 12 dy 8 hflip #true } ]
				deliver-stairs-l-f [ { img "fancy_female_01.png" mask "fancy_female_01_mask.png" atlas hdpeeps layer worker framecount 11 fps 12 dy 8 } ]
				eat-f [ { img "fancy_female_01_stand_back.png" mask "fancy_female_01_stand_back_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 } ]
				eat-sit-l-f [ { img "fancy_female_01_sit_side.png" mask "fancy_female_01_sit_side_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 } ]
				eat-sit-r-f [ { img "fancy_female_01_sit_side.png" mask "fancy_female_01_sit_side_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 hflip #true } ]
				eat-sit-f-f [ { img "fancy_female_01_sit_front.png" mask "fancy_female_01_sit_front_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 } ]
				eat-sit-b-f [ { img "fancy_female_01_sit_back.png" mask "fancy_female_01_sit_back_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 } ]
				shop-f [ { img "fancy_female_01_stand_back.png" mask "fancy_female_01_stand_back_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 } ]
				work-r-f [ { img "fancy_female_01.png" mask "fancy_female_01_mask.png" atlas hdpeeps layer worker framecount 13 fps 0 dy 8 hflip #true } ]
				work-l-f [ { img "fancy_female_01.png" mask "fancy_female_01_mask.png" atlas hdpeeps layer worker framecount 13 fps 0 dy 8 } ]
				work-f-f [ { img "fancy_female_01_stand_front.png" mask "fancy_female_01_stand_front_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.5 } 
							{ img "fancy_female_01_stand_front_phone.png" mask "fancy_female_01_stand_front_phone_mask.png" atlas hdpeeps layer worker framecount 1 dy 8 fps 0 playhours 0.5 }
				]
				work-b-f [ { img "fancy_female_01_stand_back.png" mask "fancy_female_01_stand_back_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 } ]
				dotask-f [ { img "fancy_female_01_stand_front.png" mask "fancy_female_01_stand_front_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 } ]
				unhappy-f [ { img "fancy_female_01_stand_front_upset.png" mask "fancy_female_01_stand_front_upset_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 } ]
				warning-f [ { img "fancy_female_01_stand_front.png" mask "fancy_female_01_stand_front_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 } ]
			}
			colors {
				b { from 167 to 168 }
			}
		}
	}
	{
		ident { template "npc-restaurant.a-rest.morning" parent "npc-restaurant.a" }
		peep {
			schedule "schedule-rest.morning"
		}
	}
	{
		ident { template "npc-restaurant.a-rest.brunch" parent "npc-restaurant.a" }
		peep {
			schedule "schedule-rest.brunch"
		}
	}
	{
		ident { template "npc-restaurant.a-rest.day" parent "npc-restaurant.a" }
		peep {
			schedule "schedule-rest.day"
		}
	}
	{
		ident { template "npc-restaurant.a-rest.evening" parent "npc-restaurant.a" }
		peep {
			schedule "schedule-rest.evening"
		}
	}
	{
		ident { template "npc-restaurant.a-rest.night" parent "npc-restaurant.a" }
		peep {
			schedule "schedule-rest.night"
		}
	}
	{
		ident { template "npc-restaurant.b-rest.host" parent "npc-restaurant.b" }
		peep {
			schedule "schedule-rest.host"
		}
	}
	{
		ident { template "npc-restaurant.b-rest.host-evening" parent "npc-restaurant.b" }
		peep {
			schedule "schedule-rest.evening"
		}
	}
	{
		ident { template "npc-restaurant.chef.morning" parent "npc-service" }
		peep {
			schedule "schedule-rest.brunch"
		}
		sprite {
			colors {
				b { from 1 to 2 }
			}
		}
	}
	{
		ident { template "npc-restaurant.chef.day" parent "npc-service" }
		peep {
			schedule "schedule-rest.day"
		}
		sprite {
			colors {
				b { from 1 to 2 }
			}
		}
	}
	{
		ident { template "npc-restaurant.chef.evening" parent "npc-service" }
		peep {
			schedule "schedule-rest.evening"
		}
		sprite {
			colors {
				b { from 1 to 2 }
			}
		}
	}
	{
		ident { template "npc-restaurant.chef.celebrity" parent "npc-service" }
		peep {
			schedule "schedule-rest.evening"
		}
		sprite {
			colors {
				b { from 93 to 94 }
			}
		}
	}



	;;;;;;;;;;;;;;;;;;;; retail NPCs

	{
		ident { template "npc-retail" parent "npc" }
		navigation {
			speed 100
		}
		peep {
		}
		sprite {
			animations {
				default-m [ { img "retail_male_01_stand_front.png" mask "retail_male_01_stand_front_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 } ]
				stand-r-m [ { img "retail_male_01_stand_side.png" mask "retail_male_01_stand_side_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 hflip #true } ]
				stand-l-m [ { img "retail_male_01_stand_side.png" mask "retail_male_01_stand_side_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 } ]
				escalator-r-m [ { img "retail_male_01_stand_side.png" mask "retail_male_01_stand_side_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 hflip #true } ]
				escalator-l-m [ { img "retail_male_01_stand_side.png" mask "retail_male_01_stand_side_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 } ]
				walk-r-m [ { img "retail_male_01.png" mask "retail_male_01_mask.png" atlas hdpeeps layer walker framecount 13 fps 12 dy 8 hflip #true } ]
				walk-l-m [ { img "retail_male_01.png" mask "retail_male_01_mask.png" atlas hdpeeps layer walker framecount 13 fps 12 dy 8 } ]
				stairs-r-m [ { img "retail_male_01.png" mask "retail_male_01_mask.png" atlas hdpeeps layer worker framecount 13 fps 12 dy 8 hflip #true } ]
				stairs-l-m [ { img "retail_male_01.png" mask "retail_male_01_mask.png" atlas hdpeeps layer worker framecount 13 fps 12 dy 8 } ]
				deliver-r-m [ { img "retail_male_01.png" mask "retail_male_01_mask.png" atlas hdpeeps layer walker framecount 13 fps 12 dy 8 hflip #true } ]
				deliver-l-m [ { img "retail_male_01.png" mask "retail_male_01_mask.png" atlas hdpeeps layer walker framecount 13 fps 12 dy 8 } ]
				deliver-stairs-r-m [ { img "retail_male_01.png" mask "retail_male_01_mask.png" atlas hdpeeps layer worker framecount 13 fps 12 dy 8 hflip #true } ]
				deliver-stairs-l-m [ { img "retail_male_01.png" mask "retail_male_01_mask.png" atlas hdpeeps layer worker framecount 13 fps 12 dy 8 } ]
				eat-m [ { img "retail_male_01_stand_back.png" mask "retail_male_01_stand_back_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 } ]
				eat-sit-l-m [ { img "retail_male_01_sit_side.png" mask "retail_male_01_sit_side_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 } ]
				eat-sit-r-m [ { img "retail_male_01_sit_side.png" mask "retail_male_01_sit_side_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 hflip #true } ]
				eat-sit-f-m [ { img "retail_male_01_sit_front.png" mask "retail_male_01_sit_front_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 } ]
				eat-sit-b-m [ { img "retail_male_01_stand_front.png" mask "retail_male_01_stand_front_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 } ]
				shop-m [ { img "retail_male_01_stand_back.png" mask "retail_male_01_stand_back_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 } ]
				work-r-m [ { img "retail_male_01_stand_side.png" mask "retail_male_01_stand_side_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.5 hflip #true } 
							{ img "retail_male_01_stand_side_machine.png" mask "retail_male_01_stand_side_machine_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.5 hflip #true }
				]
				work-l-m [ { img "retail_male_01_stand_side.png" mask "retail_male_01_stand_side_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.5 } 
							{ img "retail_male_01_stand_side_machine.png" mask "retail_male_01_stand_side_machine_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.5 }
				]
				work-f-m [ { img "retail_male_01_stand_front.png" mask "retail_male_01_stand_front_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.5 } 
							{ img "retail_male_01_stand_front_phone.png" mask "retail_male_01_stand_front_phone_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.5 }
							{ img "retail_male_01_stand_front_machine.png" mask "retail_male_01_stand_front_machine_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.5 }
				]
				work-b-m [ { img "retail_male_01_stand_back.png" mask "retail_male_01_stand_back_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 } ]
				dotask-m [ { img "retail_male_01_stand_front.png" mask "retail_male_01_stand_front_mask.png" atlas hdpeeps layer walker framecount 1 fps 1 dy 8 } ]
				unhappy-m [ { img "retail_male_01_stand_front_upset.png" mask "retail_male_01_stand_front_upset_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 } ]
				warning-m [ { img "retail_male_01_stand_front.png" mask "retail_male_01_stand_front_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 } ]

				default-f [ { img "retail_female_01_stand_front.png" mask "retail_female_01_stand_front_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 } ]
				stand-r-f [ { img "retail_female_01_stand_side.png" mask "retail_female_01_stand_side_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 hflip #true } ]
				stand-l-f [ { img "retail_female_01_stand_side.png" mask "retail_female_01_stand_side_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 } ]
				escalator-r-f [ { img "retail_female_01_stand_side.png" mask "retail_female_01_stand_side_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 hflip #true } ]
				escalator-l-f [ { img "retail_female_01_stand_side.png" mask "retail_female_01_stand_side_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 } ]
				walk-r-f [ { img "retail_female_01.png" mask "retail_female_01_mask.png" atlas hdpeeps layer walker framecount 13 fps 12 dy 8 hflip #true } ]
				walk-l-f [ { img "retail_female_01.png" mask "retail_female_01_mask.png" atlas hdpeeps layer walker framecount 13 fps 12 dy 8 } ]
				stairs-r-f [ { img "retail_female_01.png" mask "retail_female_01_mask.png" atlas hdpeeps layer worker framecount 13 fps 12 dy 8 hflip #true } ]
				stairs-l-f [ { img "retail_female_01.png" mask "retail_female_01_mask.png" atlas hdpeeps layer worker framecount 13 fps 12 dy 8 } ]
				deliver-r-f [ { img "retail_female_01.png" mask "retail_female_01_mask.png" atlas hdpeeps layer walker framecount 13 fps 12 dy 8 hflip #true } ]
				deliver-l-f [ { img "retail_female_01.png" mask "retail_female_01_mask.png" atlas hdpeeps layer walker framecount 13 fps 12 dy 8 } ]
				deliver-stairs-r-f [ { img "retail_female_01.png" mask "retail_female_01_mask.png" atlas hdpeeps layer worker framecount 13 fps 12 dy 8 hflip #true } ]
				deliver-stairs-l-f [ { img "retail_female_01.png" mask "retail_female_01_mask.png" atlas hdpeeps layer worker framecount 13 fps 12 dy 8 } ]
				eat-f [ { img "retail_female_01_stand_back.png" mask "retail_female_01_stand_back_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 } ]
				eat-sit-l-f [ { img "retail_female_01_sit_side.png" mask "retail_female_01_sit_side_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 } ]
				eat-sit-r-f [ { img "retail_female_01_sit_side.png" mask "retail_female_01_sit_side_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 hflip #true } ]
				eat-sit-f-f [ { img "retail_female_01_sit_front.png" mask "retail_female_01_sit_front.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 } ]
				eat-sit-b-f [ { img "retail_female_01_sit_back.png" mask "retail_female_01_sit_back_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 } ]
				shop-f [ { img "retail_female_01_stand_back.png" mask "retail_female_01_stand_back_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 } ]
				work-r-f [ { img "retail_female_01_stand_side.png" mask "retail_female_01_stand_side_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.5 hflip #true } 
							{ img "retail_female_01_stand_side_machine.png" mask "retail_female_01_stand_side_machine_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.5 hflip #true }
				]
				work-l-f [ { img "retail_female_01_stand_side.png" mask "retail_female_01_stand_side_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.5 } 
							{ img "retail_female_01_stand_side_machine.png" mask "retail_female_01_stand_side_machine_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.5 }
				]
				work-f-f [ { img "retail_female_01_stand_front.png" mask "retail_female_01_stand_front_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.5 } 
							{ img "retail_female_01_stand_front_phone.png" mask "retail_female_01_stand_front_phone_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.5 }
							{ img "retail_female_01_stand_front_machine.png" mask "retail_female_01_stand_front_machine_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.5 }
				]
				work-b-f [ { img "retail_female_01_stand_back.png" mask "retail_female_01_stand_back_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 } ]
				dotask-f [ { img "retail_female_01_stand_front.png" mask "retail_female_01_stand_front_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 } ]
				unhappy-f [ { img "retail_female_01_stand_front_upset.png" mask "retail_female_01_stand_front_upset_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 } ]
				warning-f [ { img "retail_female_01_stand_front.png" mask "retail_female_01_stand_front_mask.png" atlas hdpeeps layer walker framecount 1 fps 0 dy 8 } ]
			}
			colors {
				b { from 1 to 2 }
			}
		}
	}
	{
		ident { template "npc-retail-retail.a-retail.day" parent "npc-retail" }
		peep {
			schedule "schedule-retail.day"
		}
	}
	{
		ident { template "npc-retail-retail.a-retail.day2" parent "npc-retail" }
		peep {
			schedule "schedule-retail.day2"
		}
	}
	{
		ident { template "npc-retail-retail.b-retail.day2" parent "npc-retail" }
		peep {
			schedule "schedule-retail.day2"
		}
		sprite {
			colors {
				b { from 1 to 2 }
			}
		}
	}
	{
		ident { template "npc-retail-retail.a-retail.day.3" parent "npc-officeworker-office.a" }
		peep {
			schedule "schedule-retail.day3"
		}
		sprite {
			animations {
				work-f-m [ { img "office_male_001_stand_front.png" mask "office_male_001_stand_front_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 1 }
							{ img "office_male_001_stand_back.png" mask "office_male_001_stand_back_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.1 }
				 ]
				 work-f-f [ { img "office_female_01_stand_front.png" mask "office_female_01_stand_front_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 1 }
				 			{ img "office_female_01_stand_back.png" mask "office_female_01_stand_back_mask.png" atlas hdpeeps layer worker framecount 1 fps 0 dy 8 playhours 0.1 }

				 ]
			}
			colors {
				b { from 133 to 183 }
			}
		}
	}

	;;;;;;;;;;;;;;;;;;;;;;;;; resident NPCs

	{
		ident { template "npc-resident" parent "npc" }
		peep {
		}
	}
	{
		ident { template "npc-resident.a" parent "npc-resident" }
		sprite {
			animations {
				default-m [ { img "resident_male_01_stand_front.png" mask "resident_male_01_stand_front_mask.png" atlas hdpeepsres layer walker framecount 1 fps 0 dy 8 } ]
				stand-r-m [ { img "resident_male_01_stand_side.png" mask "resident_male_01_stand_side_mask.png" atlas hdpeepsres layer walker framecount 1 fps 0 dy 8 hflip #true } ]
				stand-l-m [ { img "resident_male_01_stand_side.png" mask "resident_male_01_stand_side_mask.png" atlas hdpeepsres layer walker framecount 1 fps 0 dy 8 } ]
				escalator-r-m [ { img "resident_male_01_stand_side.png" mask "resident_male_01_stand_side_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 hflip #true } ]
				escalator-l-m [ { img "resident_male_01_stand_side.png" mask "resident_male_01_stand_side_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 } ]
				walk-r-m [ { img "resident_male_01.png" mask "resident_male_01_mask.png" atlas hdpeepsres layer walker framecount 13 fps 12 dy 8 hflip #true } ]
				walk-l-m [ { img "resident_male_01.png" mask "resident_male_01_mask.png" atlas hdpeepsres layer walker framecount 13 fps 12 dy 8 } ]
				stairs-r-m [ { img "resident_male_01.png" mask "resident_male_01_mask.png" atlas hdpeepsres layer worker framecount 13 fps 12 dy 8 hflip #true } ]
				stairs-l-m [ { img "resident_male_01.png" mask "resident_male_01_mask.png" atlas hdpeepsres layer worker framecount 13 fps 12 dy 8 } ]
				deliver-r-m [ { img "resident_male_01.png" mask "resident_male_01_mask.png" atlas hdpeepsres layer walker framecount 13 fps 12 dy 8 hflip #true } ]
				deliver-l-m [ { img "resident_male_01.png" mask "resident_male_01_mask.png" atlas hdpeepsres layer walker framecount 13 fps 12 dy 8 } ]
				deliver-stairs-r-m [ { img "resident_male_01.png" mask "resident_male_01_mask.png" atlas hdpeepsres layer worker framecount 13 fps 12 dy 8 hflip #true } ]
				deliver-stairs-l-m [ { img "resident_male_01.png" mask "resident_male_01_mask.png" atlas hdpeepsres layer worker framecount 13 fps 12 dy 8 } ]
				eat-m [ { img "resident_male_01_stand_back.png" mask "resident_male_01_stand_back_mask.png" atlas hdpeepsres layer walker framecount 1 fps 0 dy 8 } ]
				eat-sit-l-m [ { img "resident_male_01_sit_side.png" mask "resident_male_01_sit_side_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 } ]
				eat-sit-r-m [ { img "resident_male_01_sit_side.png" mask "resident_male_01_sit_side_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 hflip #true } ]
				eat-sit-f-m [ { img "resident_male_01_sit_front.png" mask "resident_male_01_sit_front_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 } ]
				eat-sit-b-m [ { img "resident_male_01_sit_back.png" mask "resident_male_01_sit_back_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 } ]
				shop-m [ { img "resident_male_01_stand_back.png" mask "resident_male_01_stand_back_mask.png" atlas hdpeepsres layer walker framecount 1 fps 0 dy 8 } ]
				work-r-m [ { img "resident_male_01.png" mask "resident_male_01_mask.png" atlas hdpeepsres layer worker framecount 13 fps 0 dy 8 hflip #true } ]
				work-l-m [ { img "resident_male_01.png" mask "resident_male_01_mask.png" atlas hdpeepsres layer worker framecount 13 fps 0 dy 8 } ]
				work-f-m [ { img "resident_male_01_stand_front.png" mask "resident_male_01_stand_front_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 } ]
				work-b-m [ { img "resident_male_01_stand_back.png" mask "resident_male_01_stand_back_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 } ]
				dotask-m [ { img "resident_male_01_stand_front.png" mask "resident_male_01_stand_front_mask.png" atlas hdpeepsres layer walker framecount 1 fps 1 dy 8 } ]
				unhappy-m [ { img "resident_male_01_stand_front_upset.png" mask "resident_male_01_stand_front_upset_mask.png" atlas hdpeepsres layer walker framecount 1 fps 0 dy 8 } ]
				warning-m [ { img "resident_male_01_stand_front.png" mask "resident_male_01_stand_front_mask.png" atlas hdpeepsres layer walker framecount 1 fps 0 dy 8 } ]

				default-f [ { img "resident_female_01_stand_front.png" mask "resident_female_01_stand_front_mask.png" atlas hdpeepsres layer walker framecount 1 fps 0 dy 8 } ]
				stand-r-f [ { img "resident_female_01_stand_side.png" mask "resident_female_01_stand_side_mask.png" atlas hdpeepsres layer walker framecount 1 fps 0 dy 8 hflip #true } ]
				stand-l-f [ { img "resident_female_01_stand_side.png" mask "resident_female_01_stand_side_mask.png" atlas hdpeepsres layer walker framecount 1 fps 0 dy 8 } ]
				escalator-r-f [ { img "resident_female_01_stand_side.png" mask "resident_female_01_stand_side_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 hflip #true } ]
				escalator-l-f [ { img "resident_female_01_stand_side.png" mask "resident_female_01_stand_side_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 } ]
				walk-r-f [ { img "resident_female_01.png" mask "resident_female_01_mask.png" atlas hdpeepsres layer walker framecount 13 fps 12 dy 8 hflip #true } ]
				walk-l-f [ { img "resident_female_01.png" mask "resident_female_01_mask.png" atlas hdpeepsres layer walker framecount 13 fps 12 dy 8 } ]
				stairs-r-f [ { img "resident_female_01.png" mask "resident_female_01_mask.png" atlas hdpeepsres layer worker framecount 13 fps 12 dy 8 hflip #true } ]
				stairs-l-f [ { img "resident_female_01.png" mask "resident_female_01_mask.png" atlas hdpeepsres layer worker framecount 13 fps 12 dy 8 } ]
				deliver-r-f [ { img "resident_female_01.png" mask "resident_female_01_mask.png" atlas hdpeepsres layer walker framecount 13 fps 12 dy 8 hflip #true } ]
				deliver-l-f [ { img "resident_female_01.png" mask "resident_female_01_mask.png" atlas hdpeepsres layer walker framecount 13 fps 12 dy 8 } ]
				deliver-stairs-r-f [ { img "resident_female_01.png" mask "resident_female_01_mask.png" atlas hdpeepsres layer worker framecount 13 fps 12 dy 8 hflip #true } ]
				deliver-stairs-l-f [ { img "resident_female_01.png" mask "resident_female_01_mask.png" atlas hdpeepsres layer worker framecount 13 fps 12 dy 8 } ]
				eat-f [ { img "resident_female_01_stand_back.png" mask "resident_female_01_stand_back_mask.png" atlas hdpeepsres layer walker framecount 1 fps 0 dy 8 } ]
				eat-sit-l-f [ { img "resident_female_01_sit_side.png" mask "resident_female_01_sit_side_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 } ]
				eat-sit-r-f [ { img "resident_female_01_sit_side.png" mask "resident_female_01_sit_side_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 hflip #true } ]
				eat-sit-f-f [ { img "resident_female_01_sit_front.png" mask "resident_female_01_sit_front_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 } ]
				eat-sit-b-f [ { img "resident_female_01_sit_back.png" mask "resident_female_01_sit_back_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 } ]
				shop-f [ { img "resident_female_01_stand_back.png" mask "resident_female_01_stand_back_mask.png" atlas hdpeepsres layer walker framecount 1 fps 0 dy 8 } ]
				work-r-f [ { img "resident_female_01.png" mask "resident_female_01_mask.png" atlas hdpeepsres layer worker framecount 13 fps 0 dy 8 hflip #true } ]
				work-l-f [ { img "resident_female_01.png" mask "resident_female_01_mask.png" atlas hdpeepsres layer worker framecount 13 fps 0 dy 8 } ]
				work-f-f [ { img "resident_female_01_stand_front.png" mask "resident_female_01_stand_front_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 } ]
				work-b-f [ { img "resident_female_01_stand_back.png" mask "resident_female_01_stand_back_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 } ]
				dotask-f [ { img "resident_female_01_stand_front.png" mask "resident_female_01_stand_front_mask.png" atlas hdpeepsres layer walker framecount 1 fps 0 dy 8 } ]
				unhappy-f [ { img "resident_female_01_stand_front_upset.png" mask "resident_female_01_stand_front_upset_mask.png" atlas hdpeepsres layer walker framecount 1 fps 0 dy 8 } ]
				warning-f [ { img "resident_female_01_stand_front.png" mask "resident_female_01_stand_front_mask.png" atlas hdpeepsres layer walker framecount 1 fps 0 dy 8 } ]

				res-sit-relax-front-m [ { img "resident_male_01_sit_quarter_book.png" mask "resident_male_01_sit_quarter_book_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 }
										{ img "resident_male_01_sit_quarter_newspaper.png" mask "resident_male_01_sit_quarter_newspaper_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 }
										{ img "resident_male_01_sit_quarter_tv.png" mask "resident_male_01_sit_quarter_tv_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 }
				]
				res-sit-relax-l-m [ { img "resident_male_01_sit_side.png" mask "resident_male_01_sit_side_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 }
									{ img "resident_male_01_sit_side_newspaper.png" mask "resident_male_01_sit_side_newspaper_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 } 
				]
				res-sit-relax-r-m [ { img "resident_male_01_sit_side.png" mask "resident_male_01_sit_side_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 hflip #true }
									{ img "resident_male_01_sit_side_newspaper.png" mask "resident_male_01_sit_side_newspaper_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 hflip #true }
				]
				res-stand-back-m [ { img "resident_male_01_stand_back.png" mask "resident_male_01_stand_back_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 } ]
				res-work-m [ { img "resident_male_01_sit_back.png" mask "resident_male_01_sit_back_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 } ]

				res-sit-relax-front-f [ { img "resident_female_01_sit_quarter_tv.png" mask "resident_female_01_sit_quarter_tv_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 }
										{ img "resident_female_01_sit_quarter_newspaper.png" mask "resident_female_01_sit_quarter_newspaper_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 } 
										{ img "resident_female_01_sit_quarter_book.png" mask "resident_female_01_sit_quarter_book_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 }
				]
				res-sit-relax-l-f [ { img "resident_female_01_sit_side.png" mask "resident_female_01_sit_side_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 } 
									{ img "resident_female_01_sit_side_newspaper.png" mask "resident_female_01_sit_side_newspaper_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 }
				]
				res-sit-relax-r-f [ { img "resident_female_01_sit_side.png" mask "resident_female_01_sit_side_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 hflip #true } 
									{ img "resident_female_01_sit_side_newspaper.png" mask "resident_female_01_sit_side_newspaper_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 hflip #true }
				]
				res-stand-back-f [ { img "resident_female_01_stand_back.png" mask "resident_female_01_stand_back_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 } ]
				res-work-f [ { img "resident_female_01_sit_back.png" mask "resident_female_01_sit_back_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 } ]

				sleep-a-m [ { img "resident_male_01_sleep_01.png" mask "resident_male_01_sleep_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 39.5 } ]
				sleep-b-m [ { img "resident_male_01_sleep_02.png" mask "resident_male_01_sleep_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 39.5 } ]
				sleep-c-m [ { img "resident_male_01_sleep_03.png" mask "resident_male_01_sleep_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 39.5 } ]

				sleep-a-f [ { img "resident_female_01_sleep_single_01.png" mask "resident_female_01_sleep_single_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 39.5 } ]
				sleep-b-f [ { img "resident_female_01_sleep_single_02.png" mask "resident_female_01_sleep_single_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 39.5 } ]
				sleep-c-f [ { img "resident_female_01_sleep_single_03.png" mask "resident_female_01_sleep_single_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 39.5 } ]
			}
			colors {
				b { from 150 to 250 }
			}
		}
	}
	{
		ident { template "npc-resident.b" parent "npc-resident" }
		sprite {
			animations {
				default-m [ { img "resident_male_02_stand_front.png" mask "resident_male_02_stand_front_mask.png" atlas hdpeepsres layer walker framecount 1 fps 0 dy 8 } ]
				stand-r-m [ { img "resident_male_02_stand_side.png" mask "resident_male_02_stand_side_mask.png" atlas hdpeepsres layer walker framecount 1 fps 0 dy 8 hflip #true } ]
				stand-l-m [ { img "resident_male_02_stand_side.png" mask "resident_male_02_stand_side_mask.png" atlas hdpeepsres layer walker framecount 1 fps 0 dy 8 } ]
				escalator-r-m [ { img "resident_male_02_stand_side.png" mask "resident_male_02_stand_side_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 hflip #true } ]
				escalator-l-m [ { img "resident_male_02_stand_side.png" mask "resident_male_02_stand_side_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 } ]
				walk-r-m [ { img "resident_male_02.png" mask "resident_male_02_mask.png" atlas hdpeepsres layer walker framecount 13 fps 12 dy 8 hflip #true } ]
				walk-l-m [ { img "resident_male_02.png" mask "resident_male_02_mask.png" atlas hdpeepsres layer walker framecount 13 fps 12 dy 8 } ]
				stairs-r-m [ { img "resident_male_02.png" mask "resident_male_02_mask.png" atlas hdpeepsres layer worker framecount 13 fps 12 dy 8 hflip #true } ]
				stairs-l-m [ { img "resident_male_02.png" mask "resident_male_02_mask.png" atlas hdpeepsres layer worker framecount 13 fps 12 dy 8 } ]
				deliver-r-m [ { img "resident_male_02.png" mask "resident_male_02_mask.png" atlas hdpeepsres layer walker framecount 13 fps 12 dy 8 hflip #true } ]
				deliver-l-m [ { img "resident_male_02.png" mask "resident_male_02_mask.png" atlas hdpeepsres layer walker framecount 13 fps 12 dy 8 } ]
				deliver-stairs-r-m [ { img "resident_male_02.png" mask "resident_male_02_mask.png" atlas hdpeepsres layer worker framecount 13 fps 12 dy 8 hflip #true } ]
				deliver-stairs-l-m [ { img "resident_male_02.png" mask "resident_male_02_mask.png" atlas hdpeepsres layer worker framecount 13 fps 12 dy 8 } ]
				eat-m [ { img "resident_male_02_stand_back.png" mask "resident_male_02_stand_back_mask.png" atlas hdpeepsres layer walker framecount 1 fps 0 dy 8 } ]
				eat-sit-l-m [ { img "resident_male_02_sit_side.png" mask "resident_male_02_sit_side_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 } ]
				eat-sit-r-m [ { img "resident_male_02_sit_side.png" mask "resident_male_02_sit_side_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 hflip #true } ]
				eat-sit-f-m [ { img "resident_male_02_sit_front.png" mask "resident_male_02_sit_front_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 } ]
				eat-sit-b-m [ { img "resident_male_02_sit_back.png" mask "resident_male_02_sit_back_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 } ]
				shop-m [ { img "resident_male_02_stand_back.png" mask "resident_male_02_stand_back_mask.png" atlas hdpeepsres layer walker framecount 1 fps 0 dy 8 } ]
				work-r-m [ { img "resident_male_02.png" mask "resident_male_02_mask.png" atlas hdpeepsres layer worker framecount 13 fps 0 dy 8 hflip #true } ]
				work-l-m [ { img "resident_male_02.png" mask "resident_male_02_mask.png" atlas hdpeepsres layer worker framecount 13 fps 0 dy 8 } ]
				work-f-m [ { img "resident_male_02_stand_front.png" mask "resident_male_02_stand_front_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 } ]
				work-b-m [ { img "resident_male_02_stand_back.png" mask "resident_male_02_stand_back_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 } ]
				dotask-m [ { img "resident_male_02_stand_front.png" mask "resident_male_02_stand_front_mask.png" atlas hdpeepsres layer walker framecount 1 fps 1 dy 8 } ]
				unhappy-m [ { img "resident_male_02_stand_front_upset.png" mask "resident_male_02_stand_front_upset_mask.png" atlas hdpeepsres layer walker framecount 1 fps 0 dy 8 } ]
				warning-m [ { img "resident_male_02_stand_front.png" mask "resident_male_02_stand_front_mask.png" atlas hdpeepsres layer walker framecount 1 fps 0 dy 8 } ]

				default-f [ { img "resident_female_02_stand_front.png" mask "resident_female_02_stand_front_mask.png" atlas hdpeepsres layer walker framecount 1 fps 0 dy 8 } ]
				stand-r-f [ { img "resident_female_02_stand_side.png" mask "resident_female_02_stand_side_mask.png" atlas hdpeepsres layer walker framecount 1 fps 0 dy 8 hflip #true } ]
				stand-l-f [ { img "resident_female_02_stand_side.png" mask "resident_female_02_stand_side_mask.png" atlas hdpeepsres layer walker framecount 1 fps 0 dy 8 } ]
				escalator-r-f [ { img "resident_female_02_stand_side.png" mask "resident_female_02_stand_side_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 hflip #true } ]
				escalator-l-f [ { img "resident_female_02_stand_side.png" mask "resident_female_02_stand_side_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 } ]
				walk-r-f [ { img "resident_female_02.png" mask "resident_female_02_mask.png" atlas hdpeepsres layer walker framecount 13 fps 12 dy 8 hflip #true } ]
				walk-l-f [ { img "resident_female_02.png" mask "resident_female_02_mask.png" atlas hdpeepsres layer walker framecount 13 fps 12 dy 8 } ]
				stairs-r-f [ { img "resident_female_02.png" mask "resident_female_02_mask.png" atlas hdpeepsres layer worker framecount 13 fps 12 dy 8 hflip #true } ]
				stairs-l-f [ { img "resident_female_02.png" mask "resident_female_02_mask.png" atlas hdpeepsres layer worker framecount 13 fps 12 dy 8 } ]
				deliver-r-f [ { img "resident_female_02.png" mask "resident_female_02_mask.png" atlas hdpeepsres layer walker framecount 13 fps 12 dy 8 hflip #true } ]
				deliver-l-f [ { img "resident_female_02.png" mask "resident_female_02_mask.png" atlas hdpeepsres layer walker framecount 13 fps 12 dy 8 } ]
				deliver-stairs-r-f [ { img "resident_female_02.png" mask "resident_female_02_mask.png" atlas hdpeepsres layer worker framecount 13 fps 12 dy 8 hflip #true } ]
				deliver-stairs-l-f [ { img "resident_female_02.png" mask "resident_female_02_mask.png" atlas hdpeepsres layer worker framecount 13 fps 12 dy 8 } ]
				eat-f [ { img "resident_female_02_stand_back.png" mask "resident_female_02_stand_back_mask.png" atlas hdpeepsres layer walker framecount 1 fps 0 dy 8 } ]
				eat-sit-l-f [ { img "resident_female_02_sit_side.png" mask "resident_female_02_sit_side_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 } ]
				eat-sit-r-f [ { img "resident_female_02_sit_side.png" mask "resident_female_02_sit_side_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 hflip #true } ]
				eat-sit-f-f [ { img "resident_female_02_sit_front.png" mask "resident_female_02_sit_front_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 } ]
				eat-sit-b-f [ { img "resident_female_02_sit_back.png" mask "resident_female_02_sit_back_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 } ]
				shop-f [ { img "resident_female_02_stand_back.png" mask "resident_female_02_stand_back_mask.png" atlas hdpeepsres layer walker framecount 1 fps 0 dy 8 } ]
				work-r-f [ { img "resident_female_02.png" mask "resident_female_02_mask.png" atlas hdpeepsres layer worker framecount 13 fps 0 dy 8 hflip #true } ]
				work-l-f [ { img "resident_female_02.png" mask "resident_female_02_mask.png" atlas hdpeepsres layer worker framecount 13 fps 0 dy 8 } ]
				work-f-f [ { img "resident_female_02_stand_front.png" mask "resident_female_02_stand_front_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 } ]
				work-b-f [ { img "resident_female_02_stand_back.png" mask "resident_female_02_stand_back_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 } ]
				dotask-f [ { img "resident_female_02_stand_front.png" mask "resident_female_02_stand_front_mask.png" atlas hdpeepsres layer walker framecount 1 fps 0 dy 8 } ]
				unhappy-f [ { img "resident_female_02_stand_front_upset.png" mask "resident_female_02_stand_front_upset_mask.png" atlas hdpeepsres layer walker framecount 1 fps 0 dy 8 } ]
				warning-f [ { img "resident_female_02_stand_front.png" mask "resident_female_02_stand_front_mask.png" atlas hdpeepsres layer walker framecount 1 fps 0 dy 8 } ]

				res-sit-relax-front-m [ { img "resident_male_02_sit_quarter_tv.png" mask "resident_male_02_sit_quarter_tv_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 playhours 1 } 
										{ img "resident_male_02_sit_quarter_book.png" mask "resident_male_02_sit_quarter_book_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 playhours 1 }
										{ img "resident_male_02_sit_quarter_newspaper.png" mask "resident_male_02_sit_quarter_newspaper_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 playhours 1 }
				]
				res-sit-relax-l-m [ { img "resident_male_02_sit_side.png" mask "resident_male_02_sit_side_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 10 playhours 1 } 
									{ img "resident_male_02_sit_side_newspaper.png" mask "resident_male_02_sit_side_newspaper_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 playhours 1 }
				]
				res-sit-relax-r-m [ { img "resident_male_02_sit_side.png" mask "resident_male_02_sit_side_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 10 hflip #true playhours 1 }
									{ img "resident_male_02_sit_side_newspaper.png" mask "resident_male_02_sit_side_newspaper_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 hflip #true playhours 1 }
				]
				res-stand-back-m [ { img "resident_male_02_stand_back.png" mask "resident_male_02_stand_back_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 } ]
				res-work-m [ { img "resident_male_02_sit_back.png" mask "resident_male_02_sit_back_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 } ]

				res-sit-relax-front-f [ { img "resident_female_02_sit_quarter_tv.png" mask "resident_female_02_sit_quarter_tv_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 playhours 1 } 
										{ img "resident_female_02_sit_quarter_book.png" mask "resident_female_02_sit_quarter_book_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 playhours 1 }
										{ img "resident_female_02_sit_quarter_newspaper.png" mask "resident_female_02_sit_quarter_newspaper.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 playhours 1}
				]
				res-sit-relax-l-f [ { img "resident_female_02_sit_side.png" mask "resident_female_02_sit_side_mask.png" atlas hdpeepsres layer worker framecount 1 fps 1 dy 8 playhours 1 } 
									{ img "resident_female_02_sit_side_newspaper.png" mask "resident_female_02_sit_side_newspaper_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 playhours 1 }
				]
				res-sit-relax-r-f [ { img "resident_female_02_sit_side.png" mask "resident_female_02_sit_side_mask.png" atlas hdpeepsres layer worker framecount 1 fps 1 dy 8 hflip #true playhours 1 } 
									{ img "resident_female_02_sit_side_newspaper.png" mask "resident_female_02_sit_side_newspaper_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 hflip #true playhours 1 }
				]
				res-stand-back-f [ { img "resident_female_02_stand_back.png" mask "resident_female_02_stand_back_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 } ]
				res-work-f [ { img "resident_female_02_sit_back.png" mask "resident_female_02_sit_back_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 } ]

				sleep-a-m [ { img "resident_male_02_sleep_01.png" mask "resident_male_02_sleep_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 39.5 } ]
				sleep-b-m [ { img "resident_male_02_sleep_02.png" mask "resident_male_02_sleep_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 39.5 } ]
				sleep-c-m [ { img "resident_male_02_sleep_03.png" mask "resident_male_02_sleep_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 39.5 } ]

				sleep-a-f [ { img "resident_female_02_sleep_single_01.png" mask "resident_female_02_sleep_single_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 39.5 } ]
				sleep-b-f [ { img "resident_female_02_sleep_single_02.png" mask "resident_female_02_sleep_single_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 39.5 } ]
				sleep-c-f [ { img "resident_female_02_sleep_single_03.png" mask "resident_female_02_sleep_single_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 39.5 } ]
			}
			colors {
				b { from 150 to 250 }
			}
		}
	}
	;;;;; Child NPCs
	{	
		ident { template "npc-resident.k" parent "npc-resident" }
		sprite {
			animations {
				default-m [ { img "resident_male_child_stand_front.png" mask "resident_male_child_stand_front_mask.png" atlas hdpeepsres layer walker framecount 1 fps 0 dy 8 } ]
				stand-r-m [ { img "resident_male_child_stand_side.png" mask "resident_male_child_stand_side_mask.png" atlas hdpeepsres layer walker framecount 1 fps 0 dy 8 hflip #true } ]
				stand-l-m [ { img "resident_male_child_stand_side.png" mask "resident_male_child_stand_side_mask.png" atlas hdpeepsres layer walker framecount 1 fps 0 dy 8 } ]
				escalator-r-m [ { img "resident_male_child_stand_side.png" mask "resident_male_child_stand_side_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 hflip #true } ]
				escalator-l-m [ { img "resident_male_child_stand_side.png" mask "resident_male_child_stand_side_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 } ]
				walk-r-m [ { img "resident_male_child.png" mask "resident_male_child_mask.png" atlas hdpeepsres layer walker framecount 13 fps 12 dy 8 hflip #true } ]
				walk-l-m [ { img "resident_male_child.png" mask "resident_male_child_mask.png" atlas hdpeepsres layer walker framecount 13 fps 12 dy 8 } ]
				stairs-r-m [ { img "resident_male_child.png" mask "resident_male_child_mask.png" atlas hdpeepsres layer worker framecount 13 fps 12 dy 8 hflip #true } ]
				stairs-l-m [ { img "resident_male_child.png" mask "resident_male_child_mask.png" atlas hdpeepsres layer worker framecount 13 fps 12 dy 8 } ]
				deliver-r-m [ { img "resident_male_child.png" mask "resident_male_child_mask.png" atlas hdpeepsres layer walker framecount 13 fps 12 dy 8 hflip #true } ]
				deliver-l-m [ { img "resident_male_child.png" mask "resident_male_child_mask.png" atlas hdpeepsres layer walker framecount 13 fps 12 dy 8 } ]
				deliver-stairs-r-m [ { img "resident_male_child.png" mask "resident_male_child_mask.png" atlas hdpeepsres layer worker framecount 13 fps 12 dy 8 hflip #true } ]
				deliver-stairs-l-m [ { img "resident_male_child.png" mask "resident_male_child_mask.png" atlas hdpeepsres layer worker framecount 13 fps 12 dy 8 } ]
				eat-m [ { img "resident_male_child_stand_back.png" mask "resident_male_child_stand_back_mask.png" atlas hdpeepsres layer walker framecount 1 fps 0 dy 8 } ]
				shop-m [ { img "resident_male_child.png" mask "resident_male_child_mask.png" atlas hdpeepsres layer walker framecount 13 fps 0 dy 8 } ]
				work-r-m [ { img "resident_male_child.png" mask "resident_male_child_mask.png" atlas hdpeepsres layer worker framecount 13 fps 0 dy 8 hflip #true } ]
				work-l-m [ { img "resident_male_child.png" mask "resident_male_child_mask.png" atlas hdpeepsres layer worker framecount 13 fps 0 dy 8 } ]
				work-f-m [ { img "resident_male_child_stand_front.png" mask "resident_male_child_stand_front_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 } ]
				work-b-m [ { img "resident_male_child_stand_back.png" mask "resident_male_child_stand_back_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 } ]
				dotask-m [ { img "resident_male_child_stand_front.png" mask "resident_male_child_stand_front_mask.png" atlas hdpeepsres layer walker framecount 1 fps 1 dy 8 } ]
				unhappy-m [ { img "resident_male_child_stand_front_upset.png" mask "resident_male_child_stand_front_upset_mask.png" atlas hdpeepsres layer walker framecount 1 fps 0 dy 8 } ]
				warning-m [ { img "resident_male_child_stand_front.png" mask "resident_male_child_stand_front_mask.png" atlas hdpeepsres layer walker framecount 1 fps 0 dy 8 } ]

				default-f [ { img "resident_female_child_stand_front.png" mask "resident_female_child_stand_front_mask.png" atlas hdpeepsres layer walker framecount 1 fps 0 dy 8 } ]
				stand-r-f [ { img "resident_female_child_stand_side.png" mask "resident_female_child_stand_side_mask.png" atlas hdpeepsres layer walker framecount 1 fps 0 dy 8 hflip #true } ]
				stand-l-f [ { img "resident_female_child_stand_side.png" mask "resident_female_child_stand_side_mask.png" atlas hdpeepsres layer walker framecount 1 fps 0 dy 8 } ]
				escalator-r-f [ { img "resident_female_child_stand_side.png" mask "resident_female_child_stand_side_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 hflip #true } ]
				escalator-l-f [ { img "resident_female_child_stand_side.png" mask "resident_female_child_stand_side_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 } ]
				walk-r-f [ { img "resident_female_child.png" mask "resident_female_child_mask.png" atlas hdpeepsres layer walker framecount 13 fps 12 dy 8 hflip #true } ]
				walk-l-f [ { img "resident_female_child.png" mask "resident_female_child_mask.png" atlas hdpeepsres layer walker framecount 13 fps 12 dy 8 } ]
				stairs-r-f [ { img "resident_female_child.png" mask "resident_female_child_mask.png" atlas hdpeepsres layer worker framecount 13 fps 12 dy 8 hflip #true } ]
				stairs-l-f [ { img "resident_female_child.png" mask "resident_female_child_mask.png" atlas hdpeepsres layer worker framecount 13 fps 12 dy 8 } ]
				deliver-r-f [ { img "resident_female_child.png" mask "resident_female_child_mask.png" atlas hdpeepsres layer walker framecount 13 fps 12 dy 8 hflip #true } ]
				deliver-l-f [ { img "resident_female_child.png" mask "resident_female_child_mask.png" atlas hdpeepsres layer walker framecount 13 fps 12 dy 8 } ]
				deliver-stairs-r-f [ { img "resident_female_child.png" mask "resident_female_child_mask.png" atlas hdpeepsres layer worker framecount 13 fps 12 dy 8 hflip #true } ]
				deliver-stairs-l-f [ { img "resident_female_child.png" mask "resident_female_child_mask.png" atlas hdpeepsres layer worker framecount 13 fps 12 dy 8 } ]
				eat-f [ { img "resident_female_child_stand_back.png" mask "resident_female_child_stand_back_mask.png" atlas hdpeepsres layer walker framecount 1 fps 0 dy 8 } ]
				shop-f [ { img "resident_female_child.png" mask "resident_female_child_mask.png" atlas hdpeepsres layer walker framecount 13 fps 0 dy 8 } ]
				work-r-f [ { img "resident_female_child.png" mask "resident_female_child_mask.png" atlas hdpeepsres layer worker framecount 13 fps 0 dy 8 hflip #true } ]
				work-l-f [ { img "resident_female_child.png" mask "resident_female_child_mask.png" atlas hdpeepsres layer worker framecount 13 fps 0 dy 8 } ]
				work-f-f [ { img "resident_female_child_stand_front.png" mask "resident_female_child_stand_front_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 } ]
				work-b-f [ { img "resident_female_child_stand_back.png" mask "resident_female_child_stand_back_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 } ]
				dotask-f [ { img "resident_female_child_stand_front.png" mask "resident_female_child_stand_front_mask.png" atlas hdpeepsres layer walker framecount 1 fps 0 dy 8 } ]
				unhappy-f [ { img "resident_female_child_stand_front_upset.png" mask "resident_female_child_stand_front_upset_mask.png" atlas hdpeepsres layer walker framecount 1 fps 0 dy 8 } ]
				warning-f [ { img "resident_female_child_stand_front.png" mask "resident_female_child_stand_front_mask.png" atlas hdpeepsres layer walker framecount 1 fps 0 dy 8 } ]

				play-m [ { img "resident_male_child_sit_front_play.png" mask "resident_male_child_sit_front_play_mask.png" atlas hdpeepsres layer walker framecount 1 fps 0 dy 8 playhours 1 }
						{ img "resident_male_child_sit_side_play.png" mask "resident_male_child_sit_side_play_mask.png" atlas hdpeepsres layer walker framecount 1 fps 0 dy 8 playhours 1 } ]
				res-sit-relax-front-m [ { img "resident_male_child_sit_quarter_tv.png" mask "resident_male_child_sit_quarter_tv_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 playhours 1 } 
										{ img "resident_male_child_sit_quarter_tv.png" mask "resident_male_child_sit_quarter_tv_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 playhours 1 }
										{ img "resident_male_child_sit_quarter_book.png" mask "resident_male_child_sit_quarter_book_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 playhours 1 } 
										{ img "resident_male_child_sit_front.png" mask "resident_male_child_sit_front_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 playhours 1 } ]
				res-sit-relax-l-m [ { img "resident_male_child_sit_side.png" mask "resident_male_child_sit_side_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 } ]
				res-sit-relax-r-m [ { img "resident_male_child_sit_side.png" mask "resident_male_child_sit_side_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 hflip #true } ]
				res-stand-back-m [ { img "resident_male_child_stand_back.png" mask "resident_male_child_stand_back_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 } ]

				

				play-f [ { img "resident_female_child_play_front.png" mask "resident_female_child_play_front_mask.png" atlas hdpeepsres layer walker framecount 1 fps 0 dy 8 playhours 1 }
						{ img "resident_female_child_play_side.png" mask "resident_female_child_play_side_mask.png" atlas hdpeepsres layer walker framecount 1 fps 0 dy 8 playhours 1 } ]
				res-sit-relax-front-f [ { img "resident_female_child_sit_quarter_tv.png" mask "resident_female_child_sit_quarter_tv_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 playhours 1 } 
										{ img "resident_female_child_sit_quarter_tv.png" mask "resident_female_child_sit_quarter_tv_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 playhours 1 }
										{ img "resident_female_child_sit_quarter_book.png" mask "resident_female_child_sit_quarter_book_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 playhours 1 } 
										{ img "resident_female_child_sit_front.png" mask "resident_female_child_sit_front_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 playhours 1 } ]
				res-sit-relax-l-f [ { img "resident_female_child_sit_side.png" mask "resident_female_child_sit_side_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 } ]
				res-sit-relax-r-f [ { img "resident_female_child_sit_side.png" mask "resident_female_child_sit_side_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 hflip #true } ]
				res-stand-back-f [ { img "resident_female_child_stand_back.png" mask "resident_female_child_stand_back_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 8 } ]

				sleep-a-m [ { img "resident_male_child_sleep_01.png" mask "resident_male_child_sleep_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 39.5 } ]
				sleep-b-m [ { img "resident_male_child_sleep_02.png" mask "resident_male_child_sleep_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 39.5 } ]
				sleep-c-m [ { img "resident_male_child_sleep_03.png" mask "resident_male_child_sleep_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 39.5 } ]

				sleep-a-f [ { img "resident_female_child_sleep_01.png" mask "resident_female_child_sleep_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 39.5 } ]
				sleep-b-f [ { img "resident_female_child_sleep_02.png" mask "resident_female_child_sleep_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 39.5 } ]
				sleep-c-f [ { img "resident_female_child_sleep_03.png" mask "resident_female_child_sleep_mask.png" atlas hdpeepsres layer worker framecount 1 fps 0 dy 39.5 } ]
			}
			colors {
				b { from 150 to 250 }
			}
		}
	}

	;; stay at home NPCs
	{
		ident { template "npc-resident-stayathomeparent-low" parent "npc-resident.a" }
		peep {
			schedule "schedule-resident-stayathomeparent"
		}
		sprite {
			colors {
				b { from 131 to 252 }
			}
		}
	}
	{
		ident { template "npc-resident-stayathomeparent-med" parent "npc-resident.b" }
		peep {
			schedule "schedule-resident-stayathomeparent"
		}
		sprite {
			colors {
				b { from 131 to 175 }
			}
		}
	}
	{
		ident { template "npc-resident-stayathomeparent-high" parent "npc-officeworker-office.v" }
		peep {
			schedule "schedule-resident-stayathomeparent"
		}
		sprite {
			colors {
				b { from 131 to 132 }
			}
		}
	}
	{
		ident { template "npc-resident-stayathomespouse-low" parent "npc-resident.a" }
		peep {
			schedule "schedule-resident-stayathomespouse"
		}
		sprite {
			colors {
				b { from 131 to 252 }
			}
		}
	}
	{
		ident { template "npc-resident-stayathomespouse-med" parent "npc-resident.b" }
		peep {
			schedule "schedule-resident-stayathomespouse"
		}
		sprite {
			colors {
				b { from 131 to 175 }
			}
		}
	}
	{
		ident { template "npc-resident-stayathomespouse-high" parent "npc-officeworker-office.v" }
		peep {
			schedule "schedule-resident-stayathomespouse"
		}
		sprite {
			colors {
				b { from 131 to 132 }
			}
		}
	}
	{
		ident { template "npc-resident-retiree" parent "npc-resident.a" }
		peep {
			schedule "schedule-resident-retiree"
		}
	}
	{
		ident { template "npc-resident-retiree-low" parent "npc-resident.a" }
		peep {
			schedule "schedule-resident-retiree-low"
		}
	}
	{
		ident { template "npc-resident-student" parent "npc-resident.a" }
		peep {
			schedule "schedule-resident-student"
		}
	}
	{
		ident { template "npc-resident-worksathome-low" parent "npc-resident.a" }
		peep {
			schedule "schedule-resident-worksathome"
		}
		sprite {
			colors {
				b { from 131 to 252 }
			}
		}
	}
	{
		ident { template "npc-resident-worksathome-med" parent "npc-resident.b" }
		peep {
			schedule "schedule-resident-worksathome"
		}
		sprite {
			colors {
				b { from 131 to 175 }
			}
		}
	}
	{
		ident { template "npc-resident-worksathome-high" parent "npc-officeworker-office.v" }
		peep {
			schedule "schedule-resident-worksathome"
		}
		sprite {
			colors {
				b { from 131 to 132 }
			}
		}
	}
	{
		ident { template "npc-kids" parent "npc-resident.k" }
		peep {
			schedule "schedule-kids"
			child #true
		}
		sprite {
			colors {
				b { from 76 to 77 }
			}
		}
	}

	;; resident NPCs that work outside of the building

	;; low
	{
		ident { template "npc-resident-worker-low-1" parent "npc-officeworker-office.b" }
		peep {
			schedule "schedule-resident-worker-10am-low"
		}
		sprite {
			colors {
				b { from 131 to 252 }
			}
		}
	}
	{
		ident { template "npc-resident-worker-low-2" parent "npc-officeworker-office.b" }
		peep {
			schedule "schedule-resident-worker-9am-low"
		}
		sprite {
			colors {
				b { from 131 to 252 }
			}
		}
	}
	{
		ident { template "npc-resident-worker-low-3" parent "npc-officeworker-office.b" }
		peep {
			schedule "schedule-resident-worker-830am-low"
		}
		sprite {
			colors {
				b { from 131 to 252 }
			}
		}
	}
	{
		ident { template "npc-resident-worker-low-4" parent "npc-officeworker-office.b" }
		peep {
			schedule "schedule-resident-worker-8am-low"
		}
		sprite {
			colors {
				b { from 131 to 252 }
			}
		}
	}
	{
		ident { template "npc-resident-worker-low-5" parent "npc-officeworker-office.b" }
		peep {
			schedule "scheudle-resident-worker-11am-low"
		}
		sprite {
			colors {
				b { from 131 to 252 }
			}
		}
	}

	;; medium

	{
		ident { template "npc-resident-worker-med-1" parent "npc-officeworker-office.a" }
		peep {
			schedule "schedule-resident-worker-10am"
		}
		sprite {
			colors {
				b { from 131 to 175 }
			}
		}
	}
	{
		ident { template "npc-resident-worker-med-2" parent "npc-officeworker-office.a" }
		peep {
			schedule "schedule-resident-worker-9am"
		}
		sprite {
			colors {
				b { from 131 to 175 }
			}
		}
	}
	{
		ident { template "npc-resident-worker-med-3" parent "npc-officeworker-office.a" }
		peep {
			schedule "schedule-resident-worker-830am"
		}
		sprite {
			colors {
				b { from 131 to 175 }
			}
		}
	}
	{
		ident { template "npc-resident-worker-med-4" parent "npc-officeworker-office.a" }
		peep {
			schedule "schedule-resident-worker-8am"
		}
		sprite {
			colors {
				b { from 131 to 175 }
			}
		}
	}
	{
		ident { template "npc-resident-worker-med-5" parent "npc-officeworker-office.a" }
		peep {
			schedule "scheudle-resident-worker-11am"
		}
		sprite {
			colors {
				b { from 131 to 175 }
			}
		}
	}

	;high

	{
		ident { template "npc-resident-worker-high-1" parent "npc-officeworker-office.v" }
		peep {
			schedule "schedule-resident-worker-10am"
		}
		sprite {
			colors {
				b { from 131 to 132 }
			}
		}
	}
	{
		ident { template "npc-resident-worker-high-2" parent "npc-officeworker-office.v" }
		peep {
			schedule "schedule-resident-worker-9am"
		}
		sprite {
			colors {
				b { from 131 to 132 }
			}
		}
	}
	{
		ident { template "npc-resident-worker-high-3" parent "npc-officeworker-office.v" }
		peep {
			schedule "schedule-resident-worker-830am"
		}
		sprite {
			colors {
				b { from 131 to 132 }
			}
		}
	}
	{
		ident { template "npc-resident-worker-high-4" parent "npc-officeworker-office.v" }
		peep {
			schedule "schedule-resident-worker-8am"
		}
		sprite {
			colors {
				b { from 131 to 132 }
			}
		}
	}
	{
		ident { template "npc-resident-worker-high-5" parent "npc-officeworker-office.v" }
		peep {
			schedule "scheudle-resident-worker-11am"
		}
		sprite {
			colors {
				b { from 131 to 132 }
			}
		}
	}

	;;;;;;;; office visitor npcs

	{
		ident { template "npc-visitor-one" parent "npc-resident.a" }
		peep  {
			schedule "schedule-visitor-one"
		}
		sprite {
			colors {
				b { from 90 to 100 }
			}
		}
	}
	{
		ident { template "npc-visitor-two" parent "npc-officeworker-office.a" }
		peep {
			schedule "schedule-visitor-two"
		}
		sprite {
			colors {
				b { from 129 to 131 }
			}
		}
	}
	{
		ident { template "npc-visitor-three" parent "npc-resident.a" }
		peep  {
			schedule "schedule-visitor-three"
		}
		sprite {
			colors {
				b { from 90 to 100 }
			}
		}
	}
	{
		ident { template "npc-visitor-four" parent "npc-officeworker-office.v" }
		peep {
			schedule "schedule-visitor-four"
		}
		sprite {
			colors {
				b { from 131 to 150 }
			}
		}
	}

	;;;; restaurant visitor NPCs

	{
		ident { template "npc-visitor-restaurant-one" parent "npc-resident.a" }
		peep {
			schedule "schedule-visitor-restaurant-one"
		}
		sprite {
			colors {
				b { from 132 to 232 }
			}
		}
	}
	{
		ident { template "npc-visitor-restaurant-two" parent "npc-resident.b" }
		peep {
			schedule "schedule-visitor-restaurant-two"
		}
		sprite {
			colors {
				b { from 132 to 232 }
			}
		}
	}

	;;;;; retail vistor NPCs
	{
		ident { template "npc-visitor-retail-1" parent "npc-resident.a" }
		peep {
			schedule "schedule-visitor-retail-and-maybe-lunch"
		}
		sprite {
			colors {
				b { from 132 to 232 }
			}
		}
	}
	{
		ident { template "npc-visitor-retail-2" parent "npc-officeworker-office.b" }
		peep {
			schedule "schedule-visitor-retail-and-maybe-coffee"
		}
		sprite {
			colors {
				b { from 132 to 232 }
			}
		}
	}
	{
		ident { template "npc-visitor-retail-3" parent "npc-resident.b" }
		peep {
			schedule "schedule-visitor-retail-lunch-more-shopping"
		}
		sprite {
			colors {
				b { from 132 to 232 }
			}
		}
	}
	{
		ident { template "npc-visitor-retail-4" parent "npc-resident.b" }
		peep {
			schedule "schedule-visitor-retail-and-maybe-dinner"
		}
		sprite {
			colors {
				b { from 132 to 232 }
			}
		}
	}
	{
		ident { template "npc-visitor-retail-5" parent "npc-resident.a" }
		peep {
			schedule "schedule-visitor-retail-and-maybe-coffee-more-shopping"
		}
		sprite {
			colors {
				b { from 132 to 232 }
			}
		}
	}

	;;;;;; misc visitors
	{
		ident { template "npc-visitor-artpatron" parent "npc-officeworker-office.v" }
		sprite {
			colors {
				b { from 230 to 231 }
			}
		}
		peep {
			schedule "schedule-visitor-artpatron"
		}
	}

			;;;;;;;;;;;;;;;;; tests below - delete later....
	{
		ident { template "npc-visitor-test" parent "npc-officeworker-office.a" } ;; todo: needs a different parent?
		peep {
			schedule "schedule-visitor-office-and-maybe-lunch"
		}
		sprite {
			colors {
				b { from 85 to 86 }
			}
		}
	}
	{
		ident { template "npc-visitor-retail" parent "npc-visitor-test" } ;; todo: this is oh so temp
		peep {
			schedule "schedule-visitor-retail-and-maybe-lunch"
		}
	}
	{
		ident { template "npc-visitor-civic" parent "npc-officeworker-office.a" } ;; todo: needs a different parent?
		peep {
			schedule "schedule-visitor-civic"
		}
		sprite {
			colors {
				b { from 130 to 180 } ;; office suit colors
			}
		}
	}


	;;;;;;;;;;;;;;;;;;;;;;;;;; floors

	{
		ident { template "floor-cursor" }
		placement {
			paint #true
		}
		sprite {
			atlas hdwalls
			animations {
				default [ { img "cursor-floor-valid.png" layer cursor } ]
				delete [ { img "cursor-bulldoze.png" layer cursor } ]
				error [ { img "cursor-floor-invalid.png" layer cursor } ]
			}
		}
	}
	{
		ident { template "pipe-cursor" parent "floor-cursor" }
		sprite {
			atlas hdwalls
			animations {
				default [ { img "cursor-utility-valid.png" layer cursor } ]
				delete [ { img "cursor-utility-remove.png" layer cursor } ]
				error [ { img "cursor-utility-invalid.png" layer cursor } ]
			}
		}
	}
	{
		ident { template "floor-base" }
		placement {
			reqs [
				{ #type floor-base-requirement }
				{ #type lot-boundaries-requirement }
				{ #type floor-space-cap-requirement }
			]
			buildsite #true
			buildhours 0.4
		}
		selection {
			mode floor
		}
		floor {
            piecesabove [ "floor-1" "floor-2" "floor-3" ]
            ucabove [ "floor-1-uc" "floor-2-uc" "floor-3-uc" "floor-4-uc" "floor-5-uc" "floor-6-uc" "floor-7-uc" "floor-8-uc" ]
            piecesbelow [ "floor-basement-1" "floor-basement-2" "floor-basement-3" ]
            ucbelow [ "floor-basement-1-uc" "floor-basement-2-uc" "floor-basement-3-uc" "floor-basement-4-uc" "floor-basement-5-uc" "floor-basement-6-uc" "floor-basement-7-uc" "floor-basement-8-uc" ]

			floorbuildcost { value 0 mods [
				{ #type floor-height-modifier x [ -10 0 50 ] y [ -20 -10 -60 ] }
				{ #type golden-age-modifier id goldenage-infrastucture-freefloor multiplier 0.5 }
				{ #type scenario-modifier tags [ "scenario-3" "scenario-7" "scenario-9" ] when pass multiplier 0.5 }
				{ #type scenario-modifier tags [ "scenario-4" ] when pass multiplier 1.25 }
				{ #type game-difficulty-modifier harddelta -5 }
			] }

            wallpapers [
            	{   id #null
            		animfront #null
            		animside #null
            	;	cost  -5
            	  	lockey "wallpaper.remove" } ;; special entry for "removing a wallpaper"
            	{   id plain
            		animfront wallpaper-one
            		animside wallpaper-one-side
             	;	cost -10
             		lockey "wallpaper.two" }
             	{   id chairrail
            		animfront wallpaper-two
            		animside wallpaper-two-side
             	;	cost -15
             		lockey "wallpaper.two" }
             	{   id fancy-one
            		animfront wallpaper-three
            		animside wallpaper-three-side
             	;	cost -20
             		lockey "wallpaper.three" }
             	{   id fancy-two
            		animfront wallpaper-four
            		animside wallpaper-four-side
             	;	cost -25
             		lockey "wallpaper.four" }
            	{   id glass
            		animfront wallpaper-glass
            		animside wallpaper-glass-side
            	;	cost -50
            		lockey "wallpaper.glass"
            		solid #false }
            	{   id glass-double
            		animfront wallpaper-glass-double
            		animside wallpaper-glass-side-double
            	;	cost -50
            		lockey "wallpaper.glass"
            		solid #false }
            	{	id marble
            		animfront wallpaper-marble
            		animside wallpaper-marble-side
            		lockey "wallpaper.marble" }
            ]
		}
        sprite {
            atlas hdwalls
            animations {
                default [ { img "floor-1.png" layer emptyfloor atlas hdwalls } ]

                pylon [ 
                	{ img "pylon-stub.png" layer rightendcap } 
                	{ img "pylon.png" layer rightendcap dy -150 } 
                	{ img "pylon-stub.png" layer rightendcap } 
                	]

                endcap-left-overlay-above [ { img "left-edge-above-overlay.png" dy -7 dx 7 layer rightendcap } ]
                endcap-left-overlay-basement [ { img "left-edge-basement-overlay.png" dx 34.5 layer rightendcap } ]
                endcap-left-overlay-below [ { img "left-edge-below-overlay.png" dx 46.5 layer rightendcap } ]

                roof-left [ { img "roof-left.png" layer rightendcap } ]
                roof-middle [ 
                	{ img "roof-middle.png" layer rightendcap } 
                	{ img "roof-middle.png" layer rightendcap } 
					{ img "roof-middle-1.png" dx -18 layer rightendcap } 
					{ img "roof-middle.png" layer rightendcap } 
					{ img "roof-middle.png" layer rightendcap } 
                	]
                roof-right [ { img "roof-right.png" layer rightendcap } ]
                roof-both [ { img "roof-both.png" layer rightendcap } ]

                roof-el-left [ { img "roof-el-left.png" layer rightendcap } ]
                roof-el-both [ { img "roof-el-both.png" layer rightendcap } ]
                roof-el-right [ { img "roof-el-right.png" layer rightendcap } ]

                endcap-left-above [ { img "left-edge-above.png" dy -7 dx 7 layer rightendcap } ]
                endcap-right-above [ { img "right-edge-above.png" layer rightendcap } ]
                endcap-both-above [ { img "floor-gap.png" layer rightendcap } ]

                endcap-left-parterre [ { img "left-edge-parterre.png" dx 27 layer rightendcap } ]
                endcap-right-parterre [ { img "right-edge-parterre.png" layer rightendcap } ]
                endcap-both-parterre [ { img "floor-gap.png" layer rightendcap } ]

                endcap-left-basement [ { img "left-edge-basement.png" dx 34.5 layer rightendcap } ]
                endcap-right-basement [ { img "right-edge-basement.png" layer rightendcap } ]
                endcap-both-basement [ { img "floor-gap.png" layer rightendcap } ]

                endcap-left-below [ { img "left-edge-below.png" dx 46.5 layer rightendcap } ]
                endcap-right-below [ { img "right-edge-below.png" layer rightendcap } ]
                endcap-both-below [ { img "floor-gap.png" layer rightendcap } ]

                floor-1 [ { img "floor-1.png" layer emptyfloor } ]
                floor-2 [ { img "floor-2.png" layer emptyfloor } ]
                floor-3 [ { img "floor-3.png" layer emptyfloor } ]
                floor-1-uc [ { img "floor-1-uc.png" layer emptyfloor } ]
                floor-2-uc [ { img "floor-2-uc.png" layer emptyfloor } ]
                floor-3-uc [ { img "floor-3-uc.png" layer emptyfloor } ]
                floor-4-uc [ { img "floor-4-uc.png" layer emptyfloor } ]
                floor-5-uc [ { img "floor-5-uc.png" layer emptyfloor } ]
                floor-6-uc [ { img "floor-6-uc.png" layer emptyfloor } ]
                floor-7-uc [ { img "floor-7-uc.png" layer emptyfloor } ]
                floor-8-uc [ { img "floor-8-uc.png" layer emptyfloor } ]

                floor-basement-1 [ { img "floor-basement-1.png" layer emptyfloor } ]
                floor-basement-2 [ { img "floor-basement-2.png" layer emptyfloor } ]
                floor-basement-3 [ { img "floor-basement-3.png" layer emptyfloor } ]
                floor-basement-1-uc [ { img "floor-basement-1-uc.png" layer emptyfloor } ]
                floor-basement-2-uc [ { img "floor-basement-2-uc.png" layer emptyfloor } ]
                floor-basement-3-uc [ { img "floor-basement-3-uc.png" layer emptyfloor } ]
                floor-basement-4-uc [ { img "floor-basement-4-uc.png" layer emptyfloor } ]
                floor-basement-5-uc [ { img "floor-basement-5-uc.png" layer emptyfloor } ]
                floor-basement-6-uc [ { img "floor-basement-6-uc.png" layer emptyfloor } ]
                floor-basement-7-uc [ { img "floor-basement-7-uc.png" layer emptyfloor } ]
                floor-basement-8-uc [ { img "floor-basement-8-uc.png" layer emptyfloor } ]

                wallpaper-one [ { img "wallpaper-one.png" atlas hdwalls layer emptyfloor } ]
                wallpaper-one-side [ { img "wallpaper-one-side.png" atlas hdwalls layer emptyfloor } ]
                wallpaper-two [ { img "wallpaper-two.png" atlas hdwalls layer emptyfloor }  ]
                wallpaper-two-side [ { img "wallpaper-two-side.png" atlas hdwalls layer emptyfloor } ]
                wallpaper-three [ { img "wallpaper-three.png" atlas hdwalls layer emptyfloor } ]
                wallpaper-three-side [ { img "wallpaper-three-side.png" atlas hdwalls layer emptyfloor } ]
                wallpaper-four [ { img "wallpaper-four.png" atlas hdwalls layer emptyfloor } ]
                wallpaper-four-side [ { img "wallpaper-four-side.png" atlas hdwalls layer emptyfloor } ]
                wallpaper-glass [ { img "wallpaper-glass.png" atlas hdwalls layer emptyfloor } ]
                wallpaper-glass-side [ { img "wallpaper-glass-side.png" atlas hdwalls layer emptyfloor } ]
                wallpaper-glass-double [ { img "wallpaper-glass-double.png" atlas hdwalls layer emptyfloor } ]
                wallpaper-glass-side-double [ { img "wallpaper-glass-double-side.png" atlas hdwalls layer emptyfloor } ]
                wallpaper-marble [ 
                	{ img "wall-marble-one.png" atlas preorder layer emptyfloor }
                	{ img "wall-marble-two.png" atlas preorder layer emptyfloor }
                	{ img "wall-marble-three.png" atlas preorder layer emptyfloor }   
                ]
                wallpaper-marble-side [ { img "wall-marble-side.png" atlas preorder layer emptyfloor } ]
            }
        }
	}


	;;;;;;;;;;;;;;;;;;;;;; spawners

	{
		ident { template "spawner-base" }
		placement {
			insertinmap #true
			insertvfx #true
			multiplace #false
			reqs [
				{ #type floor-requirement parterre #true aboveground #false belowground #false }
			]
			buildsite #false
			reqfloor #false
			reqfinishedfloor #false
			onremove rubble
		}
		selection {
			mode spawner
		}
		spawner {
			capacity { value 25 mods [ { #type golden-age-modifier id goldenage-commercial-visitors multiplier 1.5 }
										{ #type scenario-modifier tags [ "scenario-1"] when pass multiplier 2 } ] }
			spawnprob { value 1 }  ;; base spawn probability
			raindelta {       ;; added to base probability based on rain
				value -0.5      ;; when it's raining, 1 + -1 => 0 probability
				mods [ { #type golden-age-modifier id goldenage-commercial-visitors multiplier 0.0 } ]  ;; except during any golden age
			}
		}
		sprite {
			atlas hddecos
            animations {
                default [ { img "prop-bus-stop.png" atlas hddecos layer deco } ]
            }
		}
		unit {
			buildcost { value 0 }
		}
	}
	{
		ident { template "spawner-busstop" parent "spawner-base" }
		placement {
			blockremove always
			blockremoveloc "unitname.support.busstop.remove"
		}
		unit {
			locname "unitname.spawner.bus"
			locdesc "unitname.spawner.bus.desc"
		}
		spawner {
			freebie #true
		}
	}
	{
		ident { template "spawner-busstop-test" parent "spawner-base" }
		sprite {
			atlas hddecos
            animations {
                default [ { img "prop-bus-stop-test.png" atlas hddecos layer deco } ]
            }
		}
		unit {
			locname "unitname.spawner.bus"
		}
	}
	{
		ident { template "spawner-metro" parent "spawner-base" }
		spawner {
			capacity { value 200 mods [ { #type golden-age-modifier id goldenage-commercial-visitors multiplier 0.0 } 
										{ #type scenario-modifier tags [ "scenario-1"] when pass multiplier 2 } ] }
			period   1.5
			offsetx  505
			raindelta {       ;; added to base probability based on rain
				value 0      ;; when it's raining, 1 + -1 => 0 probability
				mods [ { #type golden-age-modifier id goldenage-commercial-visitors multiplier 0.0 } ]  ;; except during any golden age
			}
		}
		sprite {
			animations #null
			layouts [ spawner-metro ]
			borders around
		}
		placement {
			buildhours 8
			size { x 12 y 1 }
			reqfloor #true
			reqfinishedfloor #true
			reqs [
				{ #type floor-requirement parterre #false aboveground #false belowground #true }
				{ #type consultant-upgrade-requirement id "cons-b-1" }
				{ #type entity-count-requirement type exactly count 0 template spawner-metro onlyenabled #true }
				{ #type peep-count-requirement total #true count 100 }
			]
			blockremove always
			blockremoveloc "unitname.support.busstop.remove"
		}
		workplace {
			workers 4
			workertemplates [ "npc-support-metro-1" "npc-support-metro-2" "npc-support-metro-3" "npc-support-metro-4" ]
		}
		unit {
			locname "unitname.spawner.metro"
			locdesc "unitname.spawner.metro.mo"
			buildcost { value -5000 }
			tags [ metro ]
		}
	}

	;;;;;;;;;;;;;;;;;;;;;; empties

	{
		ident { template "emptyspace-base" }
		emptyspace { }
		notif { }
		placement {
			insertinmap #true
			insertvfx #true
			multiplace #true
			reqs [ ]
			buildsite #false
			reqfinishedfloor #true
			onremove delete
		}
		selection {
			mode emptyspace
		}
		sprite {
			borders around
			atlas hdwalls
			layouts [ layout-missing ]
		}
		unit {
			buildcost { value 0 }
		}
	}
	{
		ident { template "emptyspace-office" parent "emptyspace-base" }
		emptyspace {
			type office
		}
		placement {
			reqs [
				{ #type floor-requirement parterre #true aboveground #true belowground #false }
			]
		}
		unit {
			locname "prototype.emptyspace.office"
			locdesc "prototype.emptyspace.office.desc"
		}
	}
	{
		ident { template "emptyspace-office-4w" parent "emptyspace-office" }
		placement {
			size { x 4 y 1 }
		}
		sprite {
			layouts [ emptyoffice-four-wide ]
		}
	}
	{
		ident { template "emptyspace-office-10w" parent "emptyspace-office" }
		placement {
			size { x 10 y 1 }
		}
		sprite {
			layouts [ emptyoffice-ten-wide ]
		}
	}
	{
		ident { template "emptyspace-office-15w" parent "emptyspace-office" }
		placement {
			size { x 15 y 1 }
		}
		sprite {
			layouts [ emptyoffice-fifteen-wide ]
		}
	}
	{
		ident { template "emptyspace-office-10w2t" parent "emptyspace-office" }
		placement {
			size { x 10 y 2 }
		}
		sprite {
			layouts [ emptyoffice-ten-wide-two-tall ]
		}
	}

	{
		ident { template "emptyspace-restaurant" parent "emptyspace-base" }
		emptyspace {
			type restaurant
		}
		unit {
			locname "prototype.emptyspace.restaurant"
			locdesc "prototype.emptyspace.restaurant.desc"
		}
	}
	{
		ident { template "emptyspace-restaurant-4w" parent "emptyspace-restaurant" }
		placement {
			size { x 4 y 1 }
		}
		sprite {
			layouts [ emptyrestaurant-four-wide ]
		}
	}
	{
		ident { template "emptyspace-restaurant-8w" parent "emptyspace-restaurant" }
		placement {
			size { x 8 y 1 }
		}
		sprite {
			layouts [ emptyrestaurant-eight-wide ]
		}
	}
	{
		ident { template "emptyspace-restaurant-16w" parent "emptyspace-restaurant" }
		placement {
			size { x 16 y 1 }
		}
		sprite {
			layouts [ emptyrestaurant-sixteen-wide ]
		}
	}

	{
		ident { template "emptyspace-restaurant-14w" parent "emptyspace-restaurant" }
		placement {
			size { x 14 y 1 }
		}
		sprite {
			layouts [ emptyrestaurant-fourteen-wide ]
		}
	}

	{
		ident { template "emptyspace-retail" parent "emptyspace-base" }
		emptyspace {
			type retail
		}
		unit {
			locname "prototype.emptyspace.retail"
			locdesc "prototype.emptyspace.retail.desc"
		}
	}
	{
		ident { template "emptyspace-retail-7w" parent "emptyspace-retail" }
		placement {
			size { x 7 y 1 }
		}
		sprite {
			layouts [ emptyretail-seven-wide ]
		}
	}
	{
		ident { template "emptyspace-retail-12w" parent "emptyspace-retail" }
		placement {
			size { x 12 y 1 }
		}
		sprite {
			layouts [ emptyretail-twelve-wide ]
		}
	}
	{
		ident { template "emptyspace-retail-12w-2t" parent "emptyspace-retail" }
		placement {
			size { x 12 y 2 }
		}
		sprite {
			layouts [ emptyretail-twelve-wide-two-tall ]
		}
	}
	{
		ident { template "emptyspace-retail-8w" parent "emptyspace-retail" }
		placement {
			size { x 8 y 1 }
		}
		sprite { 
			layouts [ emptyretail-eight-wide ]
		}
	}

	{
		ident { template "emptyspace-residential" parent "emptyspace-base" }
		emptyspace {
			type residential
		}
		placement {
			reqs [
				{ #type floor-requirement parterre #false aboveground #true belowground #false }
			]
		}
		unit {
			locname "prototype.emptyspace.residential"
			locdesc "prototype.emptyspace.residential.desc"
		}
	}
	{
		ident { template "emptyspace-residential-6w" parent "emptyspace-residential" }
		placement {
			size { x 6 y 1 }
		}
		sprite {
			layouts [ emptyapartment-six-wide ]
		}
	}
	{
		ident { template "emptyspace-residential-8w" parent "emptyspace-residential" }
		placement {
			size { x 8 y 1 }
		}
		sprite {
			layouts [ emptyapartment-eight-wide ]
		}
	}
	{
		ident { template "emptyspace-residential-10w" parent "emptyspace-residential" }
		placement {
			size { x 10 y 1 }
		}
		sprite {
			layouts [ emptyapartment-ten-wide ]
		}
	}
	{
		ident { template "emptyspace-residential-16w" parent "emptyspace-residential" }
		placement {
			size { x 16 y 1 }
		}
		sprite {
			layouts [ emptyapartment-sixteen-wide ]
		}
	}
	{
		ident { template "emptyspace-residential-10w-2t" parent "emptyspace-residential" }
		placement {
			size { x 10 y 2 }
		}
		sprite {
			layouts [ emptyapartment-ten-wide-two-tall ]
		}
	}
	{
		ident { template "emptyspace-residential-15w-2t" parent "emptyspace-residential" }
		placement {
			size { x 15 y 2 }
		}
		sprite {
			layouts [ emptyapartment-fifteen-wide-two-tall ]
		}
	}


	;;;;;;;;;;;;;;;;;;;;;; elevators

	{
		ident { template "path-base" }
		path { }
		placement {
			insertinmap #true
			insertvfx #true
			reqs [ ]
			buildsite #true
			buildhours 1
			reqfinishedfloor #false
			onremove delete
			multiplace #true
		}
		selection {
			mode infrastructure
		}
		sprite {
			borders around
			atlas hdwalls
			layouts [ layout-missing ]
		}
		unit {
			buildcost { value 0 }
			tags [ elevators ]
		}
		vfx { }
	}
	{
		ident { template "path-elevator" parent "path-base" }
		path {
			type elevator
			origin { x 1 y 0 }
			vcost 3
			vspeed 5
			breakage { value 0.01 mods [{ #type heatmap-modifier map trafficHeatmap value 0.05 }] }
			stacking elevatorfromgroundfloor
		}
		heatmap {
			produces [
				{ type elevatorHeatmap value 1 }
			]
		}
		placement {
			size { x 3 y 1 }
			blockremove elevator
			blockremoveloc "storename.elevator.remove"
			reqs [
				
			]
		}
		sfx {
			emitter "AMB_Elevator"
		}
		sprite {
			layouts [ layout-elevator ]
		}
		unit {
			locname "storename.elevator"
			locdesc "storename.elevator.desc"
			buildcost { value -300 mods [
				{ #type heatmap-modifier map floorHeatmap value -100 }
				{ #type golden-age-modifier id goldenage-infrastucture-freefloor multiplier 0.5 }
				{ #type scenario-modifier tags [ "scenario-9" ] when pass multiplier 0.5 }
			 ] }
			opx { value -50 mods [ 
				{ #type game-difficulty-modifier easymultiplier 0.5 hardmultiplier 1.5 }
				{ #type heatmap-modifier map floorHeatmap value -100 }
				{ #type golden-age-modifier id goldenage-infrastucture-noopx multiplier 0 }
				{ #type scenario-modifier tags [ "scenario-4" ] when pass multiplier 0.25 } 
				{ #type scenario-modifier tags [ "scenario-3"] when pass multiplier 2 }
				] }
		}
		vfx { dx 75 dy 50 }
	}
	{
		ident { template "path-elevator-fancy" parent "path-elevator" }
		path {
			stacking elevatorfromanyfloor
		}
		placement {
			reqs [
				{ #type scenario-meta-requirement tags [ "scenario-4" ]
	  			reqs [ { #type consultant-upgrade-requirement id "cons-b-2" } ] 
	  			otherwise pass }
			]
		}
		sprite {
			layouts [ layout-elevator-fancy ]
		}
		unit {
			locname "storename.elevator.fancy"
			locdesc "storename.elevator.fancy.desc"
			buildcost { value -500 mods [
				{ #type game-difficulty-modifier easymultiplier 0.5 hardmultiplier 1.5 }
				{ #type heatmap-modifier map floorHeatmap value -100 }
				{ #type golden-age-modifier id goldenage-infrastucture-freefloor multiplier 0.5 }
				{ #type scenario-modifier tags [ "scenario-9" ] when pass multiplier 0.5 }
			 ] }
			opx { value -75 mods [ 
				{ #type game-difficulty-modifier easymultiplier 0.5 hardmultiplier 1.5 }
				{ #type heatmap-modifier map floorHeatmap value -100 }
				{ #type golden-age-modifier id goldenage-infrastucture-noopx multiplier 0 }
				{ #type scenario-modifier tags [ "scenario-4" ] when pass multiplier 0.25 } 
				{ #type scenario-modifier tags [ "scenario-3"] when pass multiplier 2 }
			] }

		}
	}
	{
		ident { template "path-stairs" parent "path-base" }
		path {
			type stairs
			origin { x 3 y 0 }
			vcost 10
			vspeed 0.5
		}
		placement {
			size { x 4 y 1 }
		}
		sprite {
			layouts [ layout-stairs ]
		}
		unit {
			locname "storename.stairs"
			locdesc "storename.stairs.desc"
			buildcost { value -100 mods [
				{ #type game-difficulty-modifier easymultiplier 0.5 }
				{ #type heatmap-modifier map floorHeatmap value -25 }
				{ #type golden-age-modifier id goldenage-infrastucture-freefloor multiplier 0.5 }
				{ #type scenario-modifier tags [ "scenario-9" ] when pass multiplier 0.5 }
				] }
			opx { value -10 mods [ 
				{ #type game-difficulty-modifier easymultiplier 0.5 hardmultiplier 1.5 }
				{ #type heatmap-modifier map floorHeatmap value -100 }		
				{ #type golden-age-modifier id goldenage-infrastucture-noopx multiplier 0 }
				{ #type scenario-modifier tags [ "scenario-3"] when pass multiplier 2 } ] }
		}
		vfx { dx 100 dy 50 }
	}
	{
		ident { template "path-escalator" parent "path-stairs" }
		path {
			type escalator
			origin { x 3 y 0 }
			vcost 7
			vspeed 1
			breakage { value 0.1 mods [{ #type heatmap-modifier map trafficHeatmap value 0.2 }] }
		}
		sprite {
			layouts [ layout-escalator ]
		}
		unit {
			locname "storename.escalator"
			locdesc "storename.escalator.desc"
			buildcost { value -200 mods [
				{ #type heatmap-modifier map floorHeatmap value 100 }
				{ #type scenario-modifier tags [ "scenario-9" ] when pass multiplier 0.5 }
				] }
			opx { value -25 }
		}
		vfx { dx 100 dy 50 }
	}



	;;;;;;;;;;;;;;;;;;;;;;;;;;; closets

	{
		ident { template "closet-base" }
		closet { }
		placement {
			insertinmap #true
			insertvfx #true
			reqs [ ]
			;buildsite #true
			;buildhours 0.8
			;reqfinishedfloor #true
			;onremove rubble
			buildsite #false
			buildhours 0
			reqfinishedfloor #false
			onremove delete
		}
		selection {
			mode closet
		}
		sfx {
			emitter "AMB_Utility_Closet"
		}
		sprite {
			atlas hdwalls
			layouts [ layout-missing ]
			borders around
		}
		unit {
			locname ""
			buildcost { value 0 }
		}
	}
	{
		ident { template "closet-electrical" parent "closet-base" }
		closet {
			type closet
			provides [ { type utilcable provides { value 0 } } { type utilphone provides { value 0 } } { type utilpower provides { value 0 } } ]
			opx { value -10 mods [ { #type scenario-modifier tags [ "scenario-4"] when pass multiplier 0.5 } 
						{ #type heatmap-modifier map floorHeatmap value -10 }
					] }
		}
		placement {
			size { x 1 y 1 }
			buildsite #false
			buildhours 0
			multiplace #true
		}
		sfx {
			emitter #null
		}
		sprite {
			layouts [ closet-electrical-layout ]
		}
		unit {
			locname "unitname.closet.electrical"
			locdesc "unitname.closet.electrical.desc"
			buildcost { value -50 mods [ 
				{ #type golden-age-modifier id goldenage-infrastucture-freefloor multiplier 0.5 } ] }
			tags [ closet-wiring ]
		}
	}
	{
		ident { template "closet-plumbing" parent "closet-base" }
		closet {
			type closet
			provides [ { type utilgas provides { value 0 } } { type utilwater provides { value 0 } } ]
			opx { value -10 mods [ 
				{ #type heatmap-modifier map floorHeatmap value -10 }
				{ #type golden-age-modifier id goldenage-infrastucture-utilities multiplier 0.5 }
				{ #type scenario-modifier tags [ "scenario-4"] when pass multiplier 0.5 } ]}
		}
		placement {
			size { x 1 y 1 }
			buildsite #false
			buildhours 0
			multiplace #true
		}
		sfx {
			emitter #null
		}
		sprite {
			layouts [ closet-plumbing-layout ]
		}
		unit {
			locname "unitname.closet.plumbing"
			locdesc "unitname.closet.plumbing.desc"
			buildcost { value -50 mods [ { #type golden-age-modifier id goldenage-infrastucture-freefloor multiplier 0.5 } ] }
			tags [ closet-plumbing ]
		}
	}

	{
		ident { template "closet-powermeter-l1" parent "closet-base" }
		closet {
			type meter
			provides [ { type utilpower provides { value 50 mods [ ] } } ]
			opx { value -250 mods [ 
				{ #type game-difficulty-modifier easymultiplier 0.75 }
				{ #type golden-age-modifier id goldenage-infrastucture-utilities multiplier 0.5 }
				{ #type scenario-modifier tags [ "scenario-7"] when pass multiplier 0.5 } 
			] }
		}
		placement {
			size { x 2 y 1 }
			reqs [
				{ #type floor-requirement parterre #false aboveground #false belowground #true }
			]
		}
		sprite {
			layouts [ closet-powermeter-l1 ]
		}
		unit {
			locname "unitname.closet.powermeter-l1"
			locdesc "unitname.closet.powermeter.desc"
			buildcost { value -250 mods [ 
				{ #type game-difficulty-modifier easymultiplier 0.75 }
				{ #type scenario-modifier tags [ "scenario-6"] when pass multiplier 1.5 } 
				{ #type golden-age-modifier id goldenage-infrastucture-utilities multiplier 0.5 }
				] }
		}
	}
	{
		ident { template "closet-powermeter-l2" parent "closet-powermeter-l1" }
		closet {
			provides [ { type utilpower provides { value 250 mods [  ] } } ]
			opx { value -750 mods [ 
				{ #type game-difficulty-modifier harddelta -500 easymultiplier 0.75 }
				{ #type golden-age-modifier id goldenage-infrastucture-utilities multiplier 0.5 }
				{ #type scenario-modifier tags [ "scenario-7"] when pass multiplier 0.5 } ] }
		}
		placement {
			size { x 3 y 1 }
		}
		sprite {
			layouts [ closet-powermeter-l2 ]
		}
		unit {
			locname "unitname.closet.powermeter-l2"
			locdesc "unitname.closet.powermeter.desc"
			buildcost { value -2000 mods [ 
				{ #type game-difficulty-modifier harddelta 900 easymultiplier 0.75 }
				{ #type scenario-modifier tags [ "scenario-6"] when pass multiplier 1.5 } 
				{ #type golden-age-modifier id goldenage-infrastucture-utilities multiplier 0.5 }
				] }
		}
	}
	{
		ident { template "closet-powermeter-l3" parent "closet-powermeter-l1" }
		closet {
			provides [ { type utilpower provides { value 1000 mods [  ] } } ]
			opx { value -1500 mods [ 
				{ #type game-difficulty-modifier harddelta -3500 easymultiplier 0.75 }
				{ #type golden-age-modifier id goldenage-infrastucture-utilities multiplier 0.5 }
				{ #type scenario-modifier tags [ "scenario-7"] when pass multiplier 0.5 } ] }
		}
		placement {
			size { x 4 y 1 }
		}
		sprite {
			layouts [ closet-powermeter-l3 ]
		}
		unit {
			locname "unitname.closet.powermeter-l3"
			locdesc "unitname.closet.powermeter.desc"
			buildcost { value -5500 mods [ 
				{ #type game-difficulty-modifier harddelta 1500 easymultiplier 0.75 }
				{ #type scenario-modifier tags [ "scenario-6"] when pass multiplier 1.5 }
				{ #type scenario-modifier tags [ "scenario-7"] when pass multiplier 0.5 } 
				{ #type golden-age-modifier id goldenage-infrastucture-utilities multiplier 0.5 }
				] }
		}
	}
	{
		ident { template "closet-phonemeter-l1" parent "closet-base" }
		closet {
			type meter
			provides [ { type utilphone provides { value 50 mods [ ] } } ]
			opx { value -350 mods [ 
				{ #type game-difficulty-modifier easymultiplier 0.75 }
				{ #type golden-age-modifier id goldenage-offices-utilities multiplier 0.5 }
				{ #type scenario-modifier tags [ "scenario-7"] when pass multiplier 0.5 } ] }
		}
		placement {
			size { x 2 y 1 }
			reqs [
				{ #type floor-requirement parterre #false aboveground #false belowground #true }
			]
		}
		sprite {
			layouts [ closet-phonemeter-l1 ]
		}
		unit {
			locname "unitname.closet.phonemeter-l1"
			locdesc "unitname.closet.phonemeter.desc"
			buildcost { value -350 mods [ 
				{ #type game-difficulty-modifier easymultiplier 0.75 }
				{ #type golden-age-modifier id goldenage-offices-utilities multiplier 0.5 }
				{ #type scenario-modifier tags [ "scenario-6"] when pass multiplier 1.5 } ] }
			tags [ phonemeter ]
		}
	}
	{
		ident { template "closet-phonemeter-l2" parent "closet-phonemeter-l1" }
		closet {
			provides [ { type utilphone provides { value 250 mods [  ] } } ]
			opx { value -800 mods [ 
				{ #type game-difficulty-modifier harddelta -950 easymultiplier 0.75 }
				{ #type golden-age-modifier id goldenage-offices-utilities multiplier 0.5 }
				{ #type scenario-modifier tags [ "scenario-7"] when pass multiplier 0.5 } ] }
		}
		placement {
			size { x 3 y 1 }
		}
		sprite {
			layouts [ closet-phonemeter-l2 ]
		}
		unit {
			locname "unitname.closet.phonemeter-l2"
			locdesc "unitname.closet.phonemeter.desc"
			buildcost { value -1750 mods [ 
				{ #type game-difficulty-modifier harddelta 1000 easymultiplier 0.75 }
				{ #type golden-age-modifier id goldenage-offices-utilities multiplier 0.5 }
				{ #type scenario-modifier tags [ "scenario-6"] when pass multiplier 1.5 } ] }
		}
	}
	{
		ident { template "closet-phonemeter-l3" parent "closet-phonemeter-l1" }
		closet {
			provides [ { type utilphone provides { value 1000 mods [  ] } } ]
			opx { value -1600 mods [ 
				{ #type game-difficulty-modifier harddelta -5400 easymultiplier 0.75 }
				{ #type golden-age-modifier id goldenage-offices-utilities multiplier 0.5 }
				{ #type scenario-modifier tags [ "scenario-7"] when pass multiplier 0.5 } ] }
		}
		placement {
			size { x 4 y 1 }
		}
		sprite {
			layouts [ closet-phonemeter-l3 ]
		}
		unit {
			locname "unitname.closet.phonemeter-l3"
			locdesc "unitname.closet.phonemeter.desc"
			buildcost { value -11500 mods [ 
				{ #type game-difficulty-modifier harddelta 6000 easymultiplier 0.75 }
				{ #type golden-age-modifier id goldenage-offices-utilities multiplier 0.5 }
				{ #type scenario-modifier tags [ "scenario-6"] when pass multiplier 1.5 } ] }
		}
	}
	{
		ident { template "closet-cablemeter-l1" parent "closet-base" }
		closet {
			type meter
			provides [ { type utilcable provides { value 50 mods [ ] } } ]
			opx { value -500 mods [ 
				{ #type game-difficulty-modifier easymultiplier 0.75 }
				{ #type golden-age-modifier id goldenage-apartments-utilities multiplier 0.5 }
				{ #type scenario-modifier tags [ "scenario-7"] when pass multiplier 0.5 } ] }
		}
		placement {
			size { x 2 y 1 }
			reqs [
				{ #type floor-requirement parterre #false aboveground #false belowground #true }
			]
		}
		sprite {
			layouts [ closet-cablemeter-l1 ]
		}
		unit {
			locname "unitname.closet.cablemeter-l1"
			locdesc "unitname.closet.cablemeter.desc"
			buildcost { value -1000 mods [ 
				{ #type game-difficulty-modifier harddelta 500 easymultiplier 0.75 }
				{ #type golden-age-modifier id goldenage-apartments-utilities multiplier 0.5 } 
				{ #type scenario-modifier tags [ "scenario-6"] when pass multiplier 1.5 } ] }
		}
	}
	{
		ident { template "closet-cablemeter-l2" parent "closet-cablemeter-l1" }
		closet {
			provides [  { type utilcable provides { value 250 mods [  ] } } ]
			opx { value -850 mods [ 
				{ #type game-difficulty-modifier harddelta -1650 easymultiplier 0.75 }
				{ #type golden-age-modifier id goldenage-apartments-utilities multiplier 0.5 }
				{ #type scenario-modifier tags [ "scenario-7"] when pass multiplier 0.5 } ] }
		}
		placement {
			size { x 3 y 1 }
		}
		sprite {
			layouts [ closet-cablemeter-l2 ]
		}
		unit {
			locname "unitname.closet.cablemeter-l2"
			locdesc "unitname.closet.cablemeter.desc"
			buildcost { value -1500 mods [ 
				{ #type game-difficulty-modifier harddelta -750 easymultiplier 0.75 }
				{ #type golden-age-modifier id goldenage-apartments-utilities multiplier 0.5 } 
				{ #type scenario-modifier tags [ "scenario-6"] when pass multiplier 1.5 }] }
		}
	}
	{
		ident { template "closet-cablemeter-l3" parent "closet-cablemeter-l1" }
		closet {
			provides [  { type utilcable provides { value 1000 mods [  ] } } ]
			opx { value -1750 mods [ 
				{ #type game-difficulty-modifier harddelta -8250 easymultiplier 0.75 }
				{ #type scenario-modifier tags [ "scenario-7"] when pass multiplier 0.5 } ] }
		}
		placement {
			size { x 4 y 1 }
		}
		sprite {
			layouts [ closet-cablemeter-l3 ]
		}
		unit {
			locname "unitname.closet.cablemeter-l3"
			locdesc "unitname.closet.cablemeter.desc"
			buildcost { value -17250 mods [ 
				{ #type game-difficulty-modifier harddelta 8750 easymultiplier 0.75 }
				{ #type scenario-modifier tags [ "scenario-6"] when pass multiplier 1.5 } ] }
		}
	}
	{
		ident { template "closet-watermeter-l1" parent "closet-base" }
		closet {
			type meter
			provides [ { type utilwater provides { value 50 } } ]
			opx { value -250 mods [ 
				{ #type game-difficulty-modifier easymultiplier 0.75 }
				{ #type scenario-modifier tags [ "scenario-7"] when pass multiplier 0.5 } ] }
		}
		placement {
			size { x 2 y 1 }
			reqs [
				{ #type floor-requirement parterre #false aboveground #false belowground #true }
			]
		}
		sprite {
			layouts [ closet-watermeter-l1 ]
		}
		unit {
			locname "unitname.closet.watermeter-l1"
			locdesc "unitname.closet.watermeter.desc"
			buildcost { value -500 mods [ 
				{ #type game-difficulty-modifier harddelta 250 easymultiplier 0.75 }
				{ #type scenario-modifier tags [ "scenario-6"] when pass multiplier 1.5 } 
				{ #type golden-age-modifier id goldenage-infrastucture-utilities multiplier 0.5 }
				] }
		}
	}

	{
		ident { template "closet-watermeter-l2" parent "closet-watermeter-l1" }
		closet {
			provides [ { type utilwater provides { value 250 mods [  ] } } ]
			opx { value -750 mods [ 
				{ #type game-difficulty-modifier harddelta -500 easymultiplier 0.75 }
				{ #type scenario-modifier tags [ "scenario-7"] when pass multiplier 0.5 } ] }
		}
		placement {
			size { x 3 y 1 }
		}
		sprite {
			layouts [ closet-watermeter-l2 ]
		}
		unit {
			locname "unitname.closet.watermeter-l2"
			locdesc "unitname.closet.watermeter.desc"
			buildcost { value -2000 mods [ 
				{ #type game-difficulty-modifier harddelta 500 easymultiplier 0.75 }
				{ #type scenario-modifier tags [ "scenario-6"] when pass multiplier 1.5 } 
				{ #type golden-age-modifier id goldenage-infrastucture-utilities multiplier 0.5 }
				] }
		}
	}
	{
		ident { template "closet-watermeter-l3" parent "closet-watermeter-l1" }
		closet {
			provides [ { type utilwater provides { value 1000 mods [ ] } } ]
			opx { value -1500 mods [ 
				{ #type game-difficulty-modifier harddelta -3500 easymultiplier 0.75 }
				{ #type scenario-modifier tags [ "scenario-7"] when pass multiplier 0.5 } ]  }
		}
		placement {
			size { x 4 y 1 }
		}
		sprite {
			layouts [ closet-watermeter-l3 ]
		}
		unit {
			locname "unitname.closet.watermeter-l3"
			locdesc "unitname.closet.watermeter.desc"
			buildcost { value -5500  mods [ 
				{ #type game-difficulty-modifier harddelta 1500 easymultiplier 0.75 }
				{ #type scenario-modifier tags [ "scenario-6"] when pass multiplier 1.5 } 
				{ #type golden-age-modifier id goldenage-infrastucture-utilities multiplier 0.5 }
				]}
		}
	}
	{
		ident { template "closet-gasmeter-l1" parent "closet-base" }
		closet {
			type meter
			provides [ { type utilgas provides { value 50 mods [ ] } } ]
			opx { value -350 mods [ 
				{ #type game-difficulty-modifier easymultiplier 0.75 }
				{ #type golden-age-modifier id goldenage-apartments-utilities multiplier 0.5 }
				{ #type scenario-modifier tags [ "scenario-7"] when pass multiplier 0.5 } ] }
		}
		placement {
			size { x 2 y 1 }
			reqs [
				{ #type floor-requirement parterre #false aboveground #false belowground #true }
			]
		}
		sprite {
			layouts [ closet-gasmeter-l1 ]
		}
		unit {
			locname "unitname.closet.gasmeter-l1"
			locdesc "unitname.closet.gasmeter.desc"
			buildcost { value -350 mods [ 
				{ #type game-difficulty-modifier easymultiplier 0.75 }
				{ #type scenario-modifier tags [ "scenario-6"] when pass multiplier 1.5 } ] }
		}
	}
	{
		ident { template "closet-gasmeter-l2" parent "closet-gasmeter-l1" }
		closet {
			provides [ { type utilgas provides { value 250 mods [ ] } } ]
			opx { value -800 mods [ 
				{ #type game-difficulty-modifier harddelta -950 easymultiplier 0.75 }
				{ #type golden-age-modifier id goldenage-apartments-utilities multiplier 0.5 }
				{ #type scenario-modifier tags [ "scenario-7"] when pass multiplier 0.5 } ] }
		}
		placement {
			size { x 3 y 1 }
		}
		sprite {
			layouts [ closet-gasmeter-l2 ]
		}
		unit {
			locname "unitname.closet.gasmeter-l2"
			locdesc "unitname.closet.gasmeter.desc"
			buildcost { value -1750 mods [ 
				{ #type game-difficulty-modifier harddelta 250 easymultiplier 0.75 }
				{ #type scenario-modifier tags [ "scenario-6"] when pass multiplier 1.5 } ] }
		}
	}
	{
		ident { template "closet-gasmeter-l3" parent "closet-gasmeter-l1" }
		closet {
			provides [ { type utilgas provides { value 1000 mods [ ] } } ]
			opx { value -1600 mods [ 
				{ #type game-difficulty-modifier harddelta -5400 easymultiplier 0.75 }
				{ #type golden-age-modifier id goldenage-apartments-utilities multiplier 0.5 }
				{ #type scenario-modifier tags [ "scenario-7"] when pass multiplier 0.5 } ]  }
		}
		placement {
			size { x 4 y 1 }
		}
		sprite {
			layouts [ closet-gasmeter-l3 ]
		}
		unit {
			locname "unitname.closet.gasmeter-l3"
			locdesc "unitname.closet.gasmeter.desc"
			buildcost { value -11500 mods [ 
				{ #type game-difficulty-modifier harddelta 6000 easymultiplier 0.75 }
				{ #type scenario-modifier tags [ "scenario-6"] when pass multiplier 1.5 } ] }
		}
	}
	
	;;;;;;;;;;;;;;;;;;;;;;;;;;; support items

	{
		ident { template "support-base" }
		placement {
			insertinmap #true
			insertvfx #true
			reqs [ ]
			buildsite #true
			buildhours 0.8
			onremove rubble
		}
		notif { }
		selection {
			mode support
		}
		sprite {
			borders around
			atlas hdwalls
			layouts [ maintenance-office-layout ]
		}
		unit { }
	}
	{
		ident { template "support-maintenance" parent "support-base" }
		placement {
			size { x 4 y 1 }
			onremove delete
			reqs [
				{ #type entity-count-requirement type lessthan count 2 template support-maintenance onlyenabled #true }
			]
		}
		sprite {
			layouts [ maintenance-office-layout ]
		}
		unit {
			locname "unitname.support.maintenance"
			locdesc "unitname.support.maintenance.desc"
			loccat  "unitname.support.maintenance"
			tags [ support-maintenance ]
			favrestaurants [ diner ]
			opx { value -100 mods [ 
				{ #type game-difficulty-modifier hardmultiplier 1.5 easymultiplier 0.5 }	
				{ #type golden-age-modifier id goldenage-infrastucture-noopx multiplier 0 } 
			] }
		}
		workplace {
			workers 2
			workertemplates [ "npc-support-maintenance-1" "npc-support-maintenance-2" ]
		}
	}
	{
		ident { template "support-maintenance-expanded" parent "support-maintenance" }
		placement {
			size { x 6 y 1 }
			onremove delete
			reqs [
				{ #type entity-count-requirement type atleast count 1 template support-maintenance }
				{ #type entity-count-requirement type lessthan count 2 template support-maintenance-expanded onlyenabled #true }
				{ #type consultant-upgrade-requirement id "cons-c-3" }
			]
		}
		sprite {
			layouts [ expanded-maintenance-office-layout ]
		}
		workplace {
			workers 3
			workertemplates [ "npc-support-maintenance-1" "npc-support-maintenance-2" ]
		}
		unit {
			locname "unitname.support.maintenance.expanded"
			locdesc "unitname.support.maintenance.expanded.desc"
			loccat "unitname.support.maintenance.expanded.cat"
			tags [ support-maintenance support-maintenance-expanded ]
			favrestaurants [ diner ]
			opx { value -500 mods [ 
				{ #type golden-age-modifier id goldenage-infrastucture-noopx multiplier 0 }
				{ #type game-difficulty-modifier hardmultiplier 1.5 easymultiplier 0.5 } ] }
		}
	}
	{
		ident { template "support-construction" parent "support-base" }
		placement {
			size { x 4 y 1 }
			buildsite #false
			onremove delete
			reqfinishedfloor #false
			; blockremove always
			; blockremoveloc "unitname.support.construction.remove"
			reqs [
				{ #type entity-count-requirement type exactly count 0 template support-construction onlyenabled #true }
				{ #type floor-requirement parterre #false aboveground #false belowground #true }
			]
		}
		sprite {
			layouts [ builders-office-layout ]
		}
		unit {
			locname "unitname.support.construction"
			loccat  "unitname.support.construction"
			locdesc "unitname.support.construction.desc"
			opx { value 0 }
			tags [ support-construction ]
			favrestaurants [ diner ]
		}
		workplace {
			workers 2
			workertemplates [ "npc-support-construction-1" "npc-support-construction-2" ]
		}
	}
	{
		ident { template "support-construction-expanded" parent "support-base" }
		placement {
			size { x 7 y 1 }
			onremove delete
			reqs [
				{ #type consultant-upgrade-requirement id "cons-c-1" }
				{ #type floor-requirement parterre #false aboveground #false belowground #true }
				{ #type entity-count-requirement type exactly count 0 template support-construction-expanded onlyenabled #true }
			]
		}
		sprite {
			layouts [ builders-office-expanded-layout ]
		}
		unit {
			locname "unitname.support.construction.expanded"
			loccat  "unitname.support.construction.expanded"
			locdesc "unitname.support.construction.expanded.desc"
			opx { value -300  mods [ { #type game-difficulty-modifier hardmultiplier 1.5 easymultiplier 0.5 } ] }
			tags [ support-construction support-construction-expanded ]
			favrestaurants [ diner ]
		}
		workplace {
			autodespawn #false
			workers 2
			extraworkers { value 0 mods [ { #type consultant-upgrade-modifier delta 1 id "cons-c-2" } ] }
			workertemplates [ "npc-support-construction-1" "npc-support-construction-2" ]
		}
	}

	{
		ident { template "support-trash-base" parent "support-base" }
		collector { }
		heatmap {
			special [ trashHeatmap ]
		}
	}

	{
		ident { template "support-trashbin" parent "support-trash-base" }
		collector {
			type bin
			item trash
			capacity 15
		}
		placement {
			size { x 2 y 1 }
			reqs [ { #type floor-requirement parterre #true aboveground #true belowground #true } ]
			multiplace #true
			reqfinishedfloor #false
		}
		sprite {
			layouts [ support-trashbin ]
		}
		heatmap {
			produces [
				{ type smellHeatmap value 0.3 }
			]
		}
		unit {
			buildcost { value -50 mods [ { #type heatmap-modifier map floorHeatmap value -10 } ] }
			locname "unit.support.trashbin"
			loccat  "unit.support.trashbin"
			opx { value -50 mods [ 
				{ #type golden-age-modifier id goldenage-infrastucture-noopx multiplier 0.5 }
				{ #type heatmap-modifier map floorHeatmap value -10 } 
				{ #type game-difficulty-modifier easymultiplier 0.5 }] }
		}
	}
	{
		ident { template "support-trashroom" parent "support-trash-base" }
		collector {
			type destroyer
			item trash
			capacity 60
			destroytime 8
		}
		placement {
			size { x 5 y 1 }
			reqs [ { #type floor-requirement parterre #false aboveground #false belowground #true } ]
		}
		sprite {
			layouts [ support-trashroom ]
		}
		workplace {
			workers 1
			workertemplates [ "npc-support-garbage" ]
		}
		heatmap {
			produces [
				{ type smellHeatmap value 1 }
				{ type noiseHeatmap value 0.5 }
			]
		}
		unit {
			buildcost { value -250 }
			locname "unit.support.trashroom"
			loccat  "unit.support.trashroom"
			locdesc "unit.support.trashroom"
			opx { value -100 mods [ 
				{ #type golden-age-modifier id goldenage-infrastucture-noopx multiplier 0.5 }
				{ #type game-difficulty-modifier hardmultiplier 1.5 easymultiplier 0.5 } ] }
		}
	}
	{
		ident { template "support-recyclebin" parent "support-trash-base" }
		collector {
			type bin
			item recycling
			capacity 12
		}
		placement {
			size { x 1 y 1 }
			reqs [ { #type floor-requirement parterre #true aboveground #true belowground #true } ]
			multiplace #true
			reqfinishedfloor #false
		}
		sprite {
			layouts [ support-recyclebin ]
		}
		heatmap {
			produces [
				{ type smellHeatmap value 0.1 }
			]
		}
		unit {
			buildcost { value -50 mods [ { #type heatmap-modifier map floorHeatmap value -10 } ] }
			locname "unit.support.recyclebin"
			loccat  "unit.support.recyclebin"
			opx { value -50 mods [ 
				{ #type golden-age-modifier id goldenage-infrastucture-noopx multiplier 0.5 }
				{ #type game-difficulty-modifier easymultiplier 0.5 }	
				{ #type heatmap-modifier map floorHeatmap value -10 }
			 ] }
		}
	}
	{
		ident { template "support-recycle" parent "support-trash-base" }
		collector {
			type destroyer
			item recycling
			capacity 48
			destroytime 10
		}
		placement {
			size { x 5 y 1 }
			reqs [ { #type floor-requirement parterre #false aboveground #false belowground #true } ]
		}
		sprite {
			layouts [ support-recycle ]
		}
		workplace {
			workers 1
			workertemplates [ "npc-support-garbage" ]
		}
		heatmap {
			produces [
				{ type smellHeatmap value 0.5 }
				{ type noiseHeatmap value 0.5 }
			]
		}
		unit {
			buildcost { value -250 }
			locname "unit.support.recycle"
			loccat  "unit.support.recycle"
			locdesc "unit.support.recycle"
			opx { value -100 mods [ 
				{ #type game-difficulty-modifier hardmultiplier 1.5 easymultiplier 0.5 }
			 ] }
		}
	}

	{
		ident { template "support-loadingdock" parent "support-base" }
		dock {
			type provides
			amount 4
		}
		heatmap {
			produces [
				{ type noiseHeatmap value 0.5 }
			]
		}
		placement {
			size { x 10 y 1 }
			reqs [ 
				{ #type floor-requirement parterre #false aboveground #false belowground #true }
				{ #type prestige-requirement value 2 } ]
		}
		workplace {
			workertemplates [ "npc-service-loadingdock" ]
			workers 1
		}
		sprite {
			layouts [ support-loadingdock ]
		}
		unit {
			buildcost { value -500 }
			locname "unitname.support.loadingdock"
			locdesc "unitname.support.loadingdock.desc"
			loccat  "unitname.support.loadingdock"
			opx { value -400 mods [ 
				{ #type golden-age-modifier id goldenage-infrastucture-noopx multiplier 0.5 }
				{ #type game-difficulty-modifier easymultiplier 0.5 } ] }
		}
	}
	{
		ident { template "support-loadingdock-expanded" parent "support-loadingdock" }
		;;;;;; this is just a stub for backwards compatibility with previously saved games...
;		dock {
;			type provides
;			amount 6
;		}
;		placement {
;			size { x 14 y 1 }
;			reqs [ 
;				{ #type floor-requirement parterre #false aboveground #false belowground #true }
;				{ #type prestige-requirement value 5 } ]
;		}
;		sprite {
;			layouts [ support-loadingdock-expanded ]
;		}
;		unit {
;			buildcost { value -2500 }
;			locname "unitname.support.loadingdock.expanded"
;			locdesc "unitname.support.loadingdock.expanded.desc"
;			opx { value -600 mods [ 
;				{ #type golden-age-modifier id goldenage-infrastucture-noopx multiplier 0.5 }
;				{ #type game-difficulty-modifier hardmultiplier 1.5 easymultiplier 0.5 }  ] }
;			tags [ bigdock ]
;		}
	}

	;;;;;;;;;;;;;;;;;;;;;;;;;;; trash items

	{
		ident { template "trash-base" }
		heatmap {
			produces [
				{ type uglinessHeatmap value 0.5 }
			]
		}
		placement {
			insertinmap #true
			reqs [ ]
			blockremove always
			blockremoveloc "ui.trash.remove"
		}
		selection {
			mode trash
		}
		sprite {
			atlas hddecos
			animations {
				default [ { img "trash-1.png" layer wallpaper atlas hddecos } ]
			}
		}
		trash { }
		unit { }
	}
	{
		ident { template "trash-moveout" parent "trash-base" }
		sprite {
			animations {
				trash-1 [ { img "trash-1.png" layer wallpaper atlas hddecos } ]
				trash-2 [ { img "trash-2.png" layer wallpaper atlas hddecos } ]
			}
		}
		trash {
			animations [ trash-1 trash-2 ]
		}
		unit {
			locname "unitname.trash.moveout"
		}
	}



	;;;;;;;;;;;;;;;;;;;;;;;;;;; residential units

	{
		ident { template "residence-base" }
		heatmap {
			special [ satisfactionHeatmap profitabilityHeatmap grimeHeatmap ]
		}
		notif { }
		placement {
			insertinmap #true
			insertvfx #true
			reqs [
			 ]
			buildsite #true
			buildhours 4
			onremove evict
		}
		reservations { }
		residence { }
		selection {
			mode residence
		}
		sfx {
			emitter "AMB_Residential_General"
		}
		sprite {
			borders around
			atlas hdwalls
			layouts [ layout-missing ]
		}
		unit {
			evict {
				basefee 50
				rentpercent 200
			}
			moveout {
				threshold { value -0.5 mods [ { #type game-difficulty-modifier easydelta -0.1 harddelta 0.1 } ] }
				dailyprob { value 1 }
			}
			trashhour 8
			grimeenabled #true
			dailyagewear 0.025
		}
	}
	{
		ident { template "residence-level-one-studio-med" parent "residence-base" }
		placement {
			buildhours 1.5
			size { x 6 y 1 }
			reqs [
			]
		}
		residence {
		}
		sprite {
			layouts [ residence-level-one-studio-med ]
		}
		unit {
			locname "res.one.studio.med"
			locdesc "res.one.studio.med.desc"
			tags [ apt-studio-low normal-one ]
			favrestaurants [ foodcourt ]
			buildcost { value -100 mods [
				{ #type game-difficulty-modifier hardmultiplier 1 easymultiplier 1 }
				{ #type heatmap-modifier map floorHeatmap value -50 }
				{ #type golden-age-modifier id goldenage-apartments-waitlist multiplier 0.5 }
				] }
			pays { value 150 mods [
				{ #type game-difficulty-modifier hardmultiplier 0.87 easymultiplier 1.25 }
				{ #type heatmap-modifier map floorHeatmap value 50 }
				{ #type economy-modifier multiplier 20 }
			] }
			satisfaction { value 0 mods [
				{ #type rent-deal-modifier } 
				{ #type utilities-modifier type utilpower value -1 }
				{ #type utilities-modifier type utilwater value -1 }
				{ #type heatmap-modifier map floorHeatmap value 1 }
			;	{ #type heatmap-modifier map noiseHeatmap value -0.4 }
				{ #type trash-delivery-modifier type trash value -0.4 }
				{ #type resident-happiness-modifier multiplier 0.85 }
			;	{ #type trash-delivery-modifier type recycling value -0.4 }
				{ #type golden-age-modifier id goldenage-apartments-satisfaction delta 0.2 }
			] }
			needutilities [ { type utilpower value 1 } { type utilwater value 1 } ]
			needservices  [ 
			;	{ tasktype servicehandyman probability 0.1 businesshoursonly #false workhours 0.2 timeouthours 20 timeouteffect -0.1 } 
			]
			trashproduced [
				{ item trash amount 1 probability 0.5 }
			;	{ item recycling amount 1 probability 0.5 }
			]
		}
		tokens {
			tokengrants [ { type favors value 1 peradult #true hourofday 19 probability 0.5 } ]
		}
	}
	{
		ident { template "residence-level-one-studio-high" parent "residence-base" }
		placement {
			buildhours 1.5
			size { x 6 y 1 }
			reqs [
				{ #type prestige-requirement value 1 sathit -0.2 }
				{ #type score-requirement name score-restaurant-cafe minscore 1 sathit -0.4 }
			]
		}
		residence {
		}
		sprite {
			layouts [ residence-level-one-studio-high ]
		}
		unit {
			locname "res.one.studio.high"
			locdesc "res.one.studio.high.desc"
			tags [ apt-studio-high  ]
			favrestaurants [ cafe ]
			buildcost { value -175 mods [
				{ #type game-difficulty-modifier hardmultiplier 0.86 easymultiplier 1 }
				{ #type heatmap-modifier map floorHeatmap value -50 }
				{ #type golden-age-modifier id goldenage-apartments-waitlist multiplier 0.5 }
				] }
			pays { value 225 mods [
				{ #type game-difficulty-modifier hardmultiplier 0.76 easymultiplier 1.2 }
				{ #type heatmap-modifier map floorHeatmap value 50 }
				{ #type economy-modifier multiplier 60 }
			] }
			satisfaction { value 0 mods [
				{ #type rent-deal-modifier }
				{ #type utilities-modifier type utilpower value -1 }
				{ #type utilities-modifier type utilwater value -1 }
				{ #type utilities-modifier type utilgas value -1 }
				{ #type heatmap-modifier map floorHeatmap value 1 }
				{ #type heatmap-modifier map noiseHeatmap value -0.5 }
				{ #type heatmap-modifier map smellHeatmap value -0.2 }
				{ #type trash-delivery-modifier type trash value -0.4 }
				{ #type resident-happiness-modifier multiplier 0.85 }
			;	{ #type trash-delivery-modifier type recycling value -0.4 }
				{ #type golden-age-modifier id goldenage-apartments-satisfaction delta 0.2 } 
			] }
			needutilities [ { type utilpower value 1 } { type utilwater value 1 } { type utilgas value 1 } ]
			needservices  [ 
				;	{ tasktype servicehandyman probability 0.1 businesshoursonly #false workhours 0.2 timeouthours 20 timeouteffect -0.1 } 
					{ tasktype serviceplumber probability 0.1 businesshoursonly #false workhours 0.2 timeouthours 20 timeouteffect -0.1 }
					]
			trashproduced [
				{ item trash amount 1 probability 0.5 }
			;	{ item recycling amount 1 probability 0.5 }
			]
		}
		tokens {
			tokengrants [ { type favors value 1 peradult #true hourofday 20.5 probability 0.5 } ]
		}
	}
	{
		ident { template "residence-level-one-studio-lux" parent "residence-base" }
		placement {
			buildhours 1.5
			size { x 6 y 1 }
			reqs [
				{ #type prestige-requirement value 3 sathit -0.2 }
				{ #type score-requirement name score-restaurant-cafe minscore 1 sathit -0.4 }
				{ #type score-requirement name score-retail-homegoods minscore 1 sathit -0.2 }
				{ #type score-requirement name score-retail-food minscore 1 sathit -0.2 }
			]
		}
		residence {
		}
		sprite {
			layouts [ residence-level-one-studio-lux ]
		}
		unit {
			locname "res.one.studio.lux"
			locdesc "res.one.studio.lux"
			tags [ apt-studio-high lux-one apt-studio-lux ]
			favrestaurants [ cafe ]
			buildcost { value -275 mods [
				{ #type game-difficulty-modifier hardmultiplier 0.75 easymultiplier 1 }
				{ #type heatmap-modifier map floorHeatmap value -50 }
				{ #type golden-age-modifier id goldenage-apartments-waitlist multiplier 0.5 }
				] }
			pays { value 350 mods [
				{ #type game-difficulty-modifier hardmultiplier 0.83 easymultiplier 1.22 }
				{ #type heatmap-modifier map floorHeatmap value 50 }
				{ #type economy-modifier multiplier 60 }
			] }
			satisfaction { value 0 mods [
				{ #type rent-deal-modifier }
				{ #type utilities-modifier type utilpower value -1 }
				{ #type utilities-modifier type utilcable value -1 }
				{ #type utilities-modifier type utilwater value -1 }
				{ #type utilities-modifier type utilgas value -1 }
				{ #type heatmap-modifier map floorHeatmap value 1 }
				{ #type heatmap-modifier map noiseHeatmap value -0.5 }
				{ #type heatmap-modifier map smellHeatmap value -0.2 }
				{ #type trash-delivery-modifier type trash value -0.4 }
				{ #type trash-delivery-modifier type recycling value -0.4 }
				{ #type resident-happiness-modifier multiplier 0.85 }
				{ #type golden-age-modifier id goldenage-apartments-satisfaction delta 0.2 } 
			] }
			needutilities [ { type utilpower value 1 } { type utilwater value 1 } { type utilgas value 1 } { type utilcable value 1 } ]
			needservices  [ 
					{ tasktype servicehandyman probability 0.1 businesshoursonly #false workhours 0.2 timeouthours 20 timeouteffect -0.1 } 
					{ tasktype serviceplumber probability 0.1 businesshoursonly #false workhours 0.2 timeouthours 20 timeouteffect -0.1 }
					{ tasktype servicelaundry probability 0.1 businesshoursonly #false workhours 0.2 timeouthours 20 timeouteffect -0.1 }
					]
			trashproduced [
				{ item trash amount 1 probability 0.5 }
				{ item recycling amount 1 probability 0.5 }
			]
		}
		tokens {
			tokengrants [ { type favors value 1 peradult #true hourofday 20.5 probability 0.5 } ]
		}
	}
	{
		ident { template "residence-level-one-low" parent "residence-base" }
		placement {
			buildhours 1.2
			size { x 8 y 1 }
			reqs [
				{ #type prestige-requirement value 2 sathit -0.2 }
				{ #type score-requirement name score-retail-small minscore 4 sathit -0.2 }
				{ #type score-requirement name score-retail-food minscore 1 sathit -0.2 }
			]
		}
		residence {
		}
		sprite {
			layouts [ residence-level-one-low ]
		}
		unit {
			locname "res.one.low"
			locdesc "res.one.low.desc"
			tags [ apt-1br-low normal-one ]
			favrestaurants [ foodcourt ]
			buildcost { value -250 mods [
				{ #type game-difficulty-modifier hardmultiplier 0.6 easymultiplier 1 }
				{ #type heatmap-modifier map floorHeatmap value -50 }
				{ #type golden-age-modifier id goldenage-apartments-waitlist multiplier 0.5 }
				 ] }
			pays { value 200 mods [
				{ #type game-difficulty-modifier hardmultiplier 0.7 easymultiplier 1.2 }
				{ #type heatmap-modifier map floorHeatmap value 50 }
				{ #type economy-modifier multiplier 80 }
			] }
			satisfaction { value 0 mods [
				{ #type rent-deal-modifier }
				{ #type utilities-modifier type utilpower value -1 }
				{ #type utilities-modifier type utilwater value -1 }
				{ #type heatmap-modifier map floorHeatmap value 1 }
				{ #type heatmap-modifier map noiseHeatmap value -0.2 }
				{ #type trash-delivery-modifier type trash value -0.4 }
				{ #type resident-happiness-modifier multiplier 0.85 }
			;	{ #type trash-delivery-modifier type recycling value -0.4 }
				{ #type golden-age-modifier id goldenage-apartments-satisfaction delta 0.2 }
			] }
			needutilities [ { type utilpower value 1 } { type utilwater value 1 } ]
			needservices  [ 
				{ tasktype servicehandyman probability 0.2 businesshoursonly #false workhours 0.2 timeouthours 20 timeouteffect -0.1 } 
				{ tasktype serviceplumber probability 0.1 businesshoursonly #false workhours 0.2 timeouthours 20 timeouteffect -0.1 }
				]
			trashproduced [
				{ item trash amount 1 probability 0.75 }
			;	{ item recycling amount 1 probability 0.75 }
			]
		}
		tokens {
			tokengrants [ { type favors value 1 peradult #true hourofday 18.5 probability 0.5 } ]
		}
	}
	{
		ident { template "residence-level-one-med" parent "residence-base" }
		placement {
			buildhours 1.2
			size { x 8 y 1 }
			reqs [
				{ #type prestige-requirement value 3 sathit -0.2 }
				{ #type score-requirement name score-restaurant-dinner minscore 1 sathit -0.2 }
				{ #type score-requirement name score-retail-small minscore 4 sathit -0.2 }
				{ #type score-requirement name score-retail-food minscore 1 sathit -0.2 }
			]
		}
		residence {
		}
		sprite {
			layouts [ residence-level-one-med ]
		}
		unit {
			locname "res.one.med"
			locdesc "res.one.med.desc"
			tags [ apt-1br-low normal-one ]
			favrestaurants [ cafe ]
			buildcost { value -300 mods [
				{ #type game-difficulty-modifier hardmultiplier 0.84 easymultiplier 1 }
				{ #type heatmap-modifier map floorHeatmap value -50 }
				{ #type golden-age-modifier id goldenage-apartments-waitlist multiplier 0.5 }
				 ] }
			pays { value 300 mods [
				{ #type game-difficulty-modifier hardmultiplier 0.82 easymultiplier 1.25 }
				{ #type heatmap-modifier map floorHeatmap value 50 }
				{ #type economy-modifier multiplier 80 }
			] }
			satisfaction { value 0 mods [
				{ #type rent-deal-modifier }
				{ #type utilities-modifier type utilpower value -1 }
				{ #type utilities-modifier type utilcable value -1 } 
				{ #type utilities-modifier type utilwater value -1 }
				{ #type heatmap-modifier map floorHeatmap value 1 }
				{ #type heatmap-modifier map noiseHeatmap value -0.2 }
				{ #type trash-delivery-modifier type trash value -0.4 }
				{ #type trash-delivery-modifier type recycling value -0.4 }
				{ #type resident-happiness-modifier multiplier 0.85 }
				{ #type golden-age-modifier id goldenage-apartments-satisfaction delta 0.2 }
			] }
			needutilities [ { type utilpower value 1 } { type utilwater value 1 } { type utilcable value 1 } ]
			needservices  [ 
				{ tasktype servicehandyman probability 0.2 businesshoursonly #false workhours 0.2 timeouthours 20 timeouteffect -0.1 } 
				{ tasktype serviceplumber probability 0.1 businesshoursonly #false workhours 0.2 timeouthours 20 timeouteffect -0.1 }
				]
			trashproduced [
				{ item trash amount 1 probability 0.75 }
				{ item recycling amount 1 probability 0.75 }
			]
		}
		tokens {
			tokengrants [ { type favors value 1 peradult #true hourofday 18.5 probability 0.5 } ]
		}
	}
	{
		ident { template "residence-level-one-high" parent "residence-base" }
		placement {
			buildhours 2
			size { x 8 y 1 }
			reqs [
				{ #type prestige-requirement value 4 sathit -0.2 }
				{ #type score-requirement name score-restaurant-medium minscore 2 sathit -0.2 }
				{ #type score-requirement name score-restaurant-cafe minscore 1.5 sathit -0.2 }
				{ #type score-requirement name score-retail-small minscore 4 sathit -0.2 }
				{ #type score-requirement name score-retail-homegoods minscore 1 }
				{ #type score-requirement name score-retail-food minscore 1 }
			]
		}
		residence {
		}
		prestige {
			penaltymoveout -2
			penaltyeviction -1
		}
		sprite {
			layouts [ residence-level-one-high ]
		}
		unit {
			locname "res.one.high"
			locdesc "res.one.high.desc"
			tags [ apt-1br-high lux-1br ]
			favrestaurants [ rest-two ]
			buildcost { value -375 mods [
				{ #type game-difficulty-modifier hardmultiplier 1.2 easymultiplier 1 }
				{ #type heatmap-modifier map floorHeatmap value -50 }
				{ #type golden-age-modifier id goldenage-apartments-waitlist multiplier 0.5 }
				 ] }
			pays { value 400 mods [
				{ #type game-difficulty-modifier hardmultiplier 0.84 easymultiplier 1.2 }
				{ #type heatmap-modifier map floorHeatmap value 50 }
				{ #type economy-modifier multiplier 100 }
			] }
			satisfaction { value 0 mods [
				{ #type rent-deal-modifier } 
				{ #type utilities-modifier type utilpower value -1 }
				{ #type utilities-modifier type utilcable value -1 }
				{ #type utilities-modifier type utilwater value -1 }
				{ #type utilities-modifier type utilgas value -1 }
				{ #type heatmap-modifier map floorHeatmap value 1 }
				{ #type heatmap-modifier map noiseHeatmap value -0.5 }
				{ #type heatmap-modifier map smellHeatmap value -0.2 }
				{ #type trash-delivery-modifier type trash value -0.4 }
				{ #type trash-delivery-modifier type recycling value -0.4 }
				{ #type resident-happiness-modifier multiplier 0.85 }
				{ #type golden-age-modifier id goldenage-apartments-satisfaction delta 0.2 }
			] }
			needutilities [ { type utilpower value 1 } { type utilwater value 1 } { type utilcable value 1 } { type utilgas value 1 } ]
			needservices  [ 
				{ tasktype servicehandyman probability 0.1 businesshoursonly #false workhours 0.2 timeouthours 20 timeouteffect -0.1 }
				{ tasktype serviceplumber probability 0.1 businesshoursonly #false workhours 0.2 timeouthours 20 timeouteffect -0.1 }
				{ tasktype servicelaundry probability 0.1 businesshoursonly #false workhours 0.2 timeouthours 20 timeouteffect -0.1 } 
				{ tasktype servicecleaning probability 0.1 businesshoursonly #false workhours 0.5 timeouthours 20 timeouteffect -0.3 }
				]
			trashproduced [
				{ item trash amount 1 probability 0.75 }
				{ item recycling amount 1 probability 0.75 }
			]
		}
		tokens {
			tokengrants [ { type favors value 1 peradult #true hourofday 19.5 probability 0.5 } ]
		}
	}
	{
		ident { template "residence-level-two-low" parent "residence-base" }
		sfx {
			emitter "AMB_Residential_Children"
		}
		placement {
			buildhours 6
			size { x 10 y 1 }
			reqs [
				{ #type prestige-requirement value 4 sathit -0.3 }
				{ #type score-requirement name score-restaurant-small minscore 4 sathit -0.3 }
				{ #type score-requirement name score-retail-small minscore 4 sathit -0.3 }
				{ #type score-requirement name score-retail-food minscore 1 sathit -0.3 }
			]
		}
		residence {
			kidlayouts [ residence-level-two-low-kids ]
		}
		sprite {
			layouts [ residence-level-two-low-office residence-level-two-low residence-level-two-low-kids ] 
		}
		prestige {
			penaltymoveout -1
			penaltyeviction -1
		}
		unit {
			locname "res.two.low"
			locdesc "res.two.low.desc"
			favrestaurants [ cafe ]
			tags [ apt-2br-low apt-2br-low-kids normal-two ]
			buildcost { value -400 mods [
				{ #type game-difficulty-modifier hardmultiplier 0.75 easymultiplier 1 }
				{ #type heatmap-modifier map floorHeatmap value -100 }
				{ #type golden-age-modifier id goldenage-apartments-waitlist multiplier 0.5 }
				] }
			pays { value 425 mods [
				{ #type game-difficulty-modifier hardmultiplier 0.85 easymultiplier 1.2 }
				{ #type heatmap-modifier map floorHeatmap value 100 }
				{ #type economy-modifier multiplier 60 }
			] }
			satisfaction { value 0 mods [
					{ #type rent-deal-modifier } 
					{ #type utilities-modifier type utilpower value -1 }
					{ #type utilities-modifier type utilcable value -1 }
					{ #type utilities-modifier type utilwater value -1 }
					{ #type heatmap-modifier map floorHeatmap value 1 }
					{ #type heatmap-modifier map elevatorHeatmap value 0.2 }
					{ #type heatmap-modifier map noiseHeatmap value -0.3 }
					{ #type trash-delivery-modifier type trash value -0.4 }
					{ #type trash-delivery-modifier type recycling value -0.4 }
					{ #type resident-happiness-modifier multiplier 0.85 }
					{ #type golden-age-modifier id goldenage-apartments-satisfaction delta 0.2 }
				] }
			needservices [
				{ tasktype servicehandyman probability 0.1 businesshoursonly #false workhours 0.2 timeouthours 20 timeouteffect -0.2 }
				{ tasktype serviceplumber probability 0.1 businesshoursonly #false workhours 0.2 timeouthours 20 timeouteffect -0.2 }
				{ tasktype servicelaundry probability 0.1 businesshoursonly #false workhours 0.2 timeouthours 20 timeouteffect -0.1 }
				{ tasktype servicecleaning probability 0.1 businesshoursonly #false workhours 0.5 timeouthours 20 timeouteffect -0.3 }
			]
			needutilities [
				{ type utilpower value 2 } { type utilwater value 2 } { type utilcable value 1 }
			]
			trashproduced [
				{ item trash amount 1 probability 1 }
				{ item recycling amount 1 probability 1  }
			]
		}
		tokens {
			tokengrants [ { type favors value 1 peradult #true hourofday 18 probability 0.5 } ]
		}
	}
	{
		ident { template "residence-level-two-high" parent "residence-base" }
		sfx {
			emitter "AMB_Residential_Children"
		}
		placement {
			buildhours 2
			size { x 10 y 1 }
			reqs [
				{ #type prestige-requirement value 5 sathit -0.3 }
				{ #type score-requirement name score-restaurant-medium minscore 4 }
				{ #type score-requirement name score-retail-medium minscore 2 }
				{ #type score-requirement name score-retail-homegoods minscore 2 }
				{ #type score-requirement name score-retail-fashion minscore 1 }
				{ #type score-requirement name score-residential-luxury minscore 6 sathit -0.3 }
			]
		}
		residence {
			kidlayouts [ residence-level-two-high-kids ]
		}
		sprite {
			layouts [ residence-level-two-high-kids residence-level-two-high-office residence-level-two-high ]
		}
		prestige {
			penaltymoveout -1
			penaltyeviction -2
		}
		unit {
			locname "res.two.high"
			locdesc "res.two.high.desc"
			favrestaurants [ rest-two ]
			tags [ apt-2br-high apt-2br-high-kids lux-two ]
			buildcost { value -450 mods [
				{ #type game-difficulty-modifier hardmultiplier 1 easymultiplier 1 }
				{ #type heatmap-modifier map floorHeatmap value -100 }
				{ #type golden-age-modifier id goldenage-apartments-waitlist multiplier 0.5 }
				] }
			pays { value 525 mods [
				{ #type game-difficulty-modifier hardmultiplier 0.96 easymultiplier 1.2 }
				{ #type heatmap-modifier map floorHeatmap value 100 }
				{ #type heatmap-modifier map aestheticsHeatmap value 100 }
				{ #type economy-modifier multiplier 140 }
				] }
			satisfaction { value 0 mods [
					{ #type rent-deal-modifier }
					{ #type utilities-modifier type utilpower value -1 }
					{ #type utilities-modifier type utilcable value -1 } 
					{ #type utilities-modifier type utilwater value -1 }
					{ #type utilities-modifier type utilgas value -1 }
					{ #type heatmap-modifier map aestheticsHeatmap value 0.2 }
					{ #type heatmap-modifier map floorHeatmap value 1 }
					{ #type heatmap-modifier map elevatorHeatmap value -0.2 }
					{ #type heatmap-modifier map noiseHeatmap value -0.3 }
					{ #type trash-delivery-modifier type trash value -0.4 }
					{ #type trash-delivery-modifier type recycling value -0.4 }
					{ #type resident-happiness-modifier multiplier 0.85 }
					{ #type golden-age-modifier id goldenage-apartments-satisfaction delta 0.2 }
				] }
			needservices [
				{ tasktype servicehandyman probability 0.1 businesshoursonly #false workhours 1 timeouthours 20 timeouteffect -0.3 }
				{ tasktype serviceplumber probability 0.1 businesshoursonly #false workhours 1 timeouthours 20 timeouteffect -0.3 }
				{ tasktype servicelaundry probability 0.1 businesshoursonly #false workhours 0.2 timeouthours 20 timeouteffect -0.1 }
				{ tasktype servicedogs probability 0.2 businesshoursonly #false workhours 0.5 timeouthours 20 timeouteffect -0.3 }
				{ tasktype servicecleaning probability 0.1 businesshoursonly #false workhours 0.5 timeouthours 20 timeouteffect -0.3 }
			]
			needutilities [
				{ type utilpower value 2 } { type utilwater value 1 } { type utilcable value 2 } { type utilgas value 1 }
			]
			trashproduced [
				{ item trash amount 1 probability 1 }
				{ item recycling amount 1 probability 1 }
			]
		}
		tokens {
			tokengrants [ { type favors value 1 peradult #true hourofday 20 probability 0.5 } ]
		}
	}
	{
		ident { template "residence-level-three-low" parent "residence-base" }
		sfx {
			emitter "AMB_Residential_Children"
		}
		placement {
			buildhours 4
			size { x 16 y 1 }
			reqs [
				{ #type prestige-requirement value 5 sathit -0.3 }
				{ #type entity-count-requirement type exactly count 1 template spawner-metro sathit -0.5 }
				{ #type score-requirement name score-restaurant-medium minscore 4 sathit -0.3 }
				{ #type score-requirement name score-retail-medium minscore 2 sathit -0.3 }
				{ #type score-requirement name score-retail-fashion minscore 1 }
				{ #type score-requirement name score-retail-homegoods minscore 2 }
				{ #type score-requirement name score-retail-clothing minscore 1 }
			]
		}
		residence {
			kidlayouts [ residence-level-three-low-kids ]
		}
		sprite {
			layouts [ residence-level-three-low-office residence-level-three-low-kids ]
		}
		unit {
			buildcost { value -500 mods [
				{ #type game-difficulty-modifier hardmultiplier 0.9 easymultiplier 1 }
				{ #type heatmap-modifier map floorHeatmap value -100 }
				{ #type golden-age-modifier id goldenage-apartments-waitlist multiplier 0.5 }
			]}
			pays { value 800 mods [
				{ #type game-difficulty-modifier hardmultiplier 0.54 easymultiplier 1.2 }
				{ #type heatmap-modifier map floorHeatmap value 100 }
				{ #type heatmap-modifier map aestheticsHeatmap value 100 }
				{ #type heatmap-modifier map elevatorHeatmap value 100 }
				{ #type economy-modifier multiplier 160 }
			] }
			satisfaction { value 0 mods [
				{ #type rent-deal-modifier } 
				{ #type utilities-modifier type utilpower value -1 }
				{ #type utilities-modifier type utilwater value -1 }
				{ #type heatmap-modifier map floorHeatmap value 1 }
				{ #type heatmap-modifier map elevatorHeatmap value 0.3 }
				{ #type heatmap-modifier map noiseHeatmap value -0.3 }
				{ #type heatmap-modifier map smellHeatmap value -0.3 }
				{ #type trash-delivery-modifier type trash value -0.4 }
				{ #type trash-delivery-modifier type recycling value -0.4 }
				{ #type resident-happiness-modifier multiplier 0.85 }
				{ #type golden-age-modifier id goldenage-apartments-satisfaction delta 0.2 }
			] }
			needutilities [
				{ type utilpower value 3 } { type utilwater value 2 }
			]
			needservices [
				{ tasktype servicehandyman probability 0.1 businesshoursonly #false workhours 1 timeouthours 20 timeouteffect -0.3 }
				{ tasktype serviceplumber probability 0.1 businesshoursonly #false workhours 1 timeouthours 20 timeouteffect -0.3 }
				{ tasktype servicecleaning probability 0.1 businesshoursonly #false workhours 0.5 timeouthours 20 timeouteffect -0.3 }
				{ tasktype servicedrycleaning probability 0.1 businesshoursonly #false workhours 0.25 timeouthours 20 timeouteffect -0.3 }
				{ tasktype servicedaycare probability 0.05 businesshoursonly #false workhours 0.25 timeouthours 20 timeouteffect -0.3 }
			]
			trashproduced [
				{ item trash amount 1 probability 1 }
				{ item recycling amount 1 probability 1 }
			]
			locname "res.three.low"
			locdesc "res.three.low.desc"
			tags [ apt-large-2br-low normal-three ]
			favrestaurants [ rest-two ]
		}
		tokens {
			tokengrants [ { type favors value 1 peradult #true hourofday 19.5 probability 0.5 } ]
		}
	}
	{
		ident { template "residence-level-three-medium" parent "residence-base" }
		sfx {
			emitter "AMB_Residential_Children"
		}
		placement {
			buildhours 4
			size { x 16 y 1 }
			reqs [
				{ #type prestige-requirement value 8 sathit -0.3 }
				{ #type entity-count-requirement type exactly count 1 template spawner-metro }
				{ #type score-requirement name score-restaurant-medium minscore 2 sathit -0.3 }
				{ #type score-requirement name score-retail-food minscore 1.5 sathit -0.3 }
				{ #type score-requirement name score-retail-fashion minscore 2 sathit -0.3 }
				{ #type score-requirement name score-retail-homegoods minscore 2 sathit -0.3 }
				{ #type score-requirement name score-retail-electronics minscore 2 sathit -0.3 }
				{ #type score-requirement name score-retail-clothing minscore 1 sathit -0.3 }
				{ #type score-requirement name score-residential-luxury minscore 10 sathit -0.3 }
			]
		}
		residence {
			kidlayouts [ residence-level-three-medium-kids ]
		}
		sprite {
			layouts [ residence-level-three-medium-office residence-level-three-medium-kids ]
		}
		unit {
			buildcost { value -600 mods [
				{ #type game-difficulty-modifier hardmultiplier 0.8 easymultiplier 1 }
				{ #type heatmap-modifier map floorHeatmap value -100 }
				{ #type golden-age-modifier id goldenage-apartments-waitlist multiplier 0.5 }
			]}
			pays { value 900 mods [
				{ #type game-difficulty-modifier hardmultiplier 0.82 easymultiplier 1.2 }
				{ #type heatmap-modifier map floorHeatmap value 100 }
				{ #type heatmap-modifier map aestheticsHeatmap value 100 }
				{ #type heatmap-modifier map elevatorHeatmap value 100 }
				{ #type economy-modifier multiplier 100 }
			] }
			satisfaction { value 0 mods [
				{ #type rent-deal-modifier } 
				{ #type utilities-modifier type utilpower value -1 }
				{ #type utilities-modifier type utilcable value -1 }
				{ #type utilities-modifier type utilwater value -1 }
				{ #type utilities-modifier type utilgas value -1 }
				{ #type heatmap-modifier map floorHeatmap value 1 }
				{ #type heatmap-modifier map trafficHeatmap value -0.3 }
				{ #type heatmap-modifier map elevatorHeatmap value -0.3 }
				{ #type heatmap-modifier map noiseHeatmap value -0.3 }
				{ #type heatmap-modifier map smellHeatmap value -0.3 }
				{ #type trash-delivery-modifier type trash value -0.4 }
				{ #type trash-delivery-modifier type recycling value -0.4 }
				{ #type resident-happiness-modifier multiplier 0.85 }
				{ #type golden-age-modifier id goldenage-apartments-satisfaction delta 0.2 }
			] }
			needutilities [
				{ type utilpower value 3 } { type utilwater value 2 } { type utilgas value 1 } { type utilcable value 2 }
			]
			needservices [
				{ tasktype servicehandyman probability 0.1 businesshoursonly #false workhours 1 timeouthours 20 timeouteffect -0.3 }
				{ tasktype serviceplumber probability 0.1 businesshoursonly #false workhours 1 timeouthours 20 timeouteffect -0.3 }
				{ tasktype servicecleaning probability 0.1 businesshoursonly #false workhours 0.5 timeouthours 20 timeouteffect -0.3 }
				{ tasktype servicedrycleaning probability 0.1 businesshoursonly #false workhours 0.25 timeouthours 20 timeouteffect -0.3 }
				{ tasktype servicetailor probability 0.1 businesshoursonly #false workhours 0.25 timeouthours 20 timeouteffect -0.3 }
				{ tasktype servicedaycare probability 0.05 businesshoursonly #false workhours 0.25 timeouthours 20 timeouteffect -0.3 }
				{ tasktype servicegym probability 0.25 businesshoursonly #false workhours 0.5 timeouthours 20 timeouteffect -0.3 }
			]
			trashproduced [
				{ item trash amount 1 probability 1 }
				{ item recycling amount 1 probability 1 }
			]
			locname "res.three.medium"
			locdesc "res.three.medium.desc"
			tags [ apt-large-2br-low normal-three ]
			favrestaurants [ rest-two ]
		}
		tokens {
			tokengrants [ { type favors value 1 peradult #true hourofday 19.5 probability 0.5 } ]
		}
	}
	{
		ident { template "residence-level-three-high" parent "residence-base" }
		sfx {
			emitter "AMB_Residential_Children"
		}
		path {
			type residential
			origin { x 2 y 0 }
			vcost 1
			vspeed 15
			homeonly #true
		}
		placement {
			buildhours 5
			size { x 10 y 2 }
			reqs [
				{ #type prestige-requirement value 10 }
				{ #type entity-count-requirement type exactly count 1 template spawner-metro sathit -0.5 }
				{ #type score-requirement name score-restaurant-large minscore 2 sathit -0.3 }
				{ #type score-requirement name score-retail-large minscore 2 sathit -0.3 }
				{ #type score-requirement name score-retail-food minscore 2 sathit -0.3 }
				{ #type score-requirement name score-retail-fashion minscore 3 sathit -0.3 }
				{ #type score-requirement name score-retail-homegoods minscore 2 sathit -0.3 }
				{ #type score-requirement name score-retail-electronics minscore 2 sathit -0.3 }
				{ #type score-requirement name score-retail-clothing minscore 2 sathit -0.3 }
				{ #type score-requirement name score-residential-luxury minscore 15 sathit -0.3 }
			]
		}
		residence {
			kidlayouts [ residence-level-three-high-kids ]
		}
		sprite {
			layouts [ residence-level-three-high-office residence-level-three-high-kids ]
		}
		prestige {
			penaltyeviction -2
			penaltymoveout -2
		}
		unit {
			buildcost { value -1000 mods [
				{ #type game-difficulty-modifier hardmultiplier 0.58 easymultiplier 1 }
				{ #type heatmap-modifier map floorHeatmap value -100 }
				{ #type golden-age-modifier id goldenage-apartments-waitlist multiplier 0.5 }
			]}
			pays { value 1000 mods [
				{ #type game-difficulty-modifier hardmultiplier 0.82 easymultiplier 1.2 }
				{ #type heatmap-modifier map floorHeatmap value 100 }
				{ #type heatmap-modifier map aestheticsHeatmap value 100 }
				{ #type heatmap-modifier map elevatorHeatmap value 100 }
				{ #type economy-modifier multiplier 200 }
			] }
			satisfaction { value 0 mods [
				{ #type rent-deal-modifier } 
				{ #type utilities-modifier type utilpower value -1 }
				{ #type utilities-modifier type utilcable value -1 }
				{ #type utilities-modifier type utilwater value -1 }
				{ #type utilities-modifier type utilgas value -1 }
				{ #type trash-delivery-modifier type trash value -0.4 }
				{ #type trash-delivery-modifier type recycling value -0.4 }
				{ #type heatmap-modifier map aestheticsHeatmap value 0.2 }
				{ #type heatmap-modifier map floorHeatmap value 1 }
				{ #type heatmap-modifier map trafficHeatmap value -0.3 }
				{ #type heatmap-modifier map elevatorHeatmap value -0.3 }
				{ #type heatmap-modifier map noiseHeatmap value -0.3 }
				{ #type heatmap-modifier map smellHeatmap value -0.3 }
				{ #type resident-happiness-modifier multiplier 0.85 }
				{ #type golden-age-modifier id goldenage-apartments-satisfaction delta 0.2 }
			] }
			needutilities [
				{ type utilpower value 3 } { type utilwater value 2 } { type utilgas value 1 } { type utilcable value 2 }
			]
			needservices [
				
				{ tasktype servicehandyman probability 0.1 businesshoursonly #false workhours 1 timeouthours 20 timeouteffect -0.3 }
				{ tasktype serviceplumber probability 0.1 businesshoursonly #false workhours 1 timeouthours 20 timeouteffect -0.3 }
				{ tasktype servicecleaning probability 0.1 businesshoursonly #false workhours 0.5 timeouthours 20 timeouteffect -0.3 }
				{ tasktype servicedrycleaning probability 0.1 businesshoursonly #false workhours 0.25 timeouthours 20 timeouteffect -0.3 }
				{ tasktype serviceflowers probability 0.1 businesshoursonly #false workhours 0.25 timeouthours 20 timeouteffect -0.3 }
				{ tasktype servicetailor probability 0.1 businesshoursonly #false workhours 0.25 timeouthours 20 timeouteffect -0.3 }
				{ tasktype servicedaycare probability 0.05 businesshoursonly #false workhours 0.25 timeouthours 20 timeouteffect -0.3 }
				{ tasktype servicedogdaycare probability 0.25 businesshoursonly #false workhours 0.5 timeouthours 20 timeouteffect -0.3 }
				{ tasktype servicegym probability 0.25 businesshoursonly #false workhours 1 timeouthours 20 timeouteffect -0.3 }
			]
			trashproduced [
				{ item trash amount 1 probability 1 }
				{ item recycling amount 1 probability 1 }
			]
			locname "res.three.high"
			locdesc "res.three.high.desc"
			tags [ apt-large-2br-high lux-three ]
			favrestaurants [ rest-three ]
		}
		tokens {
			tokengrants [ { type favors value 1 peradult #true hourofday 19.5 probability 0.5 } ]
		}
	}
	{
		ident { template "residence-level-four-a" parent "residence-base" }
		sfx {
			emitter "AMB_Residential_Children"
		}
		path {
			type residential
			origin { x 2 y 0 }
			vcost 1
			vspeed 15
			homeonly #true
		}
		placement {
			size { x 15 y 2 }
			buildhours 8
			reqs [
				{ #type prestige-requirement value 15 sathit -0.4 }
				{ #type score-requirement name score-restaurant-large minscore 3 sathit -0.2 }
				{ #type score-requirement name score-restaurant-cafe minscore 3 sathit -0.2 }
				{ #type score-requirement name score-restaurant-gourmet minscore 2 sathit -0.2 }
				{ #type score-requirement name score-retail-food minscore 2 sathit -0.2 }
				{ #type score-requirement name score-retail-homegoods minscore 2 sathit -0.2 }
				{ #type score-requirement name score-retail-luxury minscore 2 sathit -0.2 }
			]
		}
		residence {
			kidlayouts [ residence-level-four-kids ]
		}
		sprite {
			layouts [ residence-level-four-a residence-level-four-kids ]
		}
		prestige {
			penaltyeviction -4
			penaltymoveout -3
		}
		unit {
			buildcost { value -1500 mods [ 
				{ #type game-difficulty-modifier hardmultiplier 1 easymultiplier 1 }
				{ #type heatmap-modifier map floorHeatmap value -100 }
				{ #type golden-age-modifier id goldenage-apartments-waitlist multiplier 0.5 } ] }
			pays { value 1800 mods [ 
				{ #type game-difficulty-modifier hardmultiplier 0.69 easymultiplier 1 }
				{ #type heatmap-modifier map floorHeatmap value 100 }
				{ #type economy-modifier multiplier 200 }
				 ] }
			satisfaction { value 0 mods [ 
				{ #type rent-deal-modifier } 
				{ #type utilities-modifier type utilpower value -1 }
				{ #type utilities-modifier type utilcable value -1 }
				{ #type utilities-modifier type utilwater value -1 }
				{ #type utilities-modifier type utilgas value -1 }
				{ #type heatmap-modifier map floorHeatmap value 1 }
				{ #type trash-delivery-modifier type trash value -0.4 }
				{ #type trash-delivery-modifier type recycling value -0.4 }
				{ #type resident-happiness-modifier multiplier 0.85 }
				{ #type golden-age-modifier id goldenage-apartments-satisfaction delta 0.2 }
			 ] }
			needutilities [
				{ type utilpower value 4 } { type utilwater value 2 } { type utilgas value 2 } { type utilcable value 2 }
			]
			needservices [
				{ tasktype servicedogs probability 0.2 businesshoursonly #false workhours 1 timeouthours 20 timeouteffect -0.4 }
				{ tasktype servicecleaning probability 0.1 businesshoursonly #false workhours 0.5 timeouthours 20 timeouteffect -0.4 }
				{ tasktype servicedrycleaning probability 0.25 businesshoursonly #false workhours 0.25 timeouthours 20 timeouteffect -0.4 }
				{ tasktype servicetailor probability 0.1 businesshoursonly #false workhours 0.25 timeouthours 20 timeouteffect -0.4 }
				{ tasktype servicedaycare probability 0.05 businesshoursonly #false workhours 0.25 timeouthours 20 timeouteffect -0.4 }
				{ tasktype servicegym probability 1 businesshoursonly #false workhours 0.5 timeouthours 20 timeouteffect -0.4 }
				{ tasktype servicedecorator probability 0.1 businesshoursonly #false workhours 1 timeouthours 20 timeouteffect -0.4 }
			]
			locname "res.four.a"
			locdesc "res.four.a.desc"
			tags [ apt-four-a ]
			favrestaurants [ rest-four ]
			trashproduced [
				{ item trash amount 2 probability 1 }
				{ item recycling amount 2 probability 1 }
			]
		}
		tokens {
			tokengrants [ { type favors value 1 peradult #true hourofday 17 probability 0.5 } ]
		}
	}
	{
		ident { template "residence-level-four-b" parent "residence-base" }
		path {
			type residential
			origin { x 2 y 0 }
			vcost 1
			vspeed 15
			homeonly #true
		}
		placement {
			size { x 15 y 2 }
			buildhours 8
			reqs [
				{ #type prestige-requirement value 15 sathit -0.4 }
				{ #type entity-count-requirement type atleast count 1 template spawner-metro }
				{ #type score-requirement name score-restaurant-large minscore 3 sathit -0.2 }
				{ #type score-requirement name score-restaurant-gourmet minscore 2.5 sathit -0.2 }
				{ #type score-requirement name score-restaurant-dinner minscore 3 sathit -0.2 }
				{ #type score-requirement name score-restaurant-bar minscore 2 sathit -0.2 }
				{ #type score-requirement name score-retail-luxury minscore 2.5 sathit -0.2 }
				{ #type score-requirement name score-retail-food minscore 2 sathit -0.2 }
				{ #type score-requirement name score-retail-homegoods minscore 2 sathit -0.2 }
				
			]
		}
		residence {
			kidlayouts [  ]
		}
		sprite {
			layouts [ residence-level-four-b ]
		}
		prestige {
			penaltyeviction -4
			penaltymoveout -3
		}
		unit {
			buildcost { value -2000 mods [ 
				{ #type game-difficulty-modifier hardmultiplier 0.88 easymultiplier 1 }
				{ #type heatmap-modifier map floorHeatmap value -100 }
				{ #type golden-age-modifier id goldenage-apartments-waitlist multiplier 0.5 }  ] }
			pays { value 2000 mods [ 
				{ #type game-difficulty-modifier hardmultiplier 0.85 easymultiplier 1 }
				{ #type heatmap-modifier map floorHeatmap value 100 }
				{ #type economy-modifier multiplier 200 } ] }
			satisfaction { value 0 mods [ 
				{ #type rent-deal-modifier } 
				{ #type utilities-modifier type utilpower value -1 }
				{ #type utilities-modifier type utilcable value -1 }
				{ #type utilities-modifier type utilwater value -1 }
				{ #type utilities-modifier type utilgas value -1 }
				{ #type heatmap-modifier map floorHeatmap value 1 }
				{ #type trash-delivery-modifier type trash value -0.4 }
				{ #type trash-delivery-modifier type recycling value -0.4 }
				{ #type resident-happiness-modifier multiplier 0.85 }
				{ #type golden-age-modifier id goldenage-apartments-satisfaction delta 0.2 }
				 ] }
			needutilities [
				{ type utilpower value 4 } { type utilwater value 2 } { type utilgas value 2 } { type utilcable value 2 }
			]
			needservices [
				{ tasktype servicecleaning probability 0.1 businesshoursonly #false workhours 0.5 timeouthours 20 timeouteffect -0.4 }
				{ tasktype servicedrycleaning probability 0.25 businesshoursonly #false workhours 0.5 timeouthours 20 timeouteffect -0.4 }
				{ tasktype serviceflowers probability 0.25 businesshoursonly #false workhours 0.75 timeouthours 20 timeouteffect -0.4 }				
				{ tasktype servicetailor probability 0.25 businesshoursonly #false workhours 0.25 timeouthours 20 timeouteffect -0.4 }
				{ tasktype servicedogdaycare probability 0.25 businesshoursonly #false workhours 1 timeouthours 20 timeouteffect -0.4 }
				{ tasktype serviceyoga probability 0.25 businesshoursonly #false workhours 0.25 timeouthours 20 timeouteffect -0.4 }
				{ tasktype servicedecorator probability 0.1 businesshoursonly #false workhours 1 timeouthours 20 timeouteffect -0.4 }
				{ tasktype servicefinance probability 0.25 businesshoursonly #false workhours 0.25 timeouthours 20 timeouteffect -0.4 }
			]
			trashproduced [
				{ item trash amount 2 probability 1 }
				{ item recycling amount 2 probability 1 }
			]
			locname "res.four.b"
			locdesc "res.four.b.desc"
			tags [ apt-four-b ]
			favrestaurants [ rest-four ]
		}
		tokens {
			tokengrants [ { type favors value 1 peradult #true hourofday 17 probability 0.5 } ]
		}
	}



	;;;;;;;;;;;;;;;;;;;;;;;;;;; workplace units

	{
		ident { template "workplace-base" }
		heatmap {
			special [ satisfactionHeatmap profitabilityHeatmap grimeHeatmap ]
		}
		notif { }
		placement {
			insertinmap #true
			insertvfx #true
			reqs [ ]
			buildsite #true
			buildhours 2
			onremove evict
		}
		selection {
			mode unit
		}
		sprite {
			borders around
			atlas hdwalls
			layouts [ layout-missing ]
		}
		unit {
			evict {
				basefee 50
				rentpercent 200
			}
		}
	}


	;;;;;;;;;;;;;;;;;;;;;;;;;;; service items

	{
		ident { template "service-base" parent "workplace-base" }
		placement {
			buildhours 0.6
		}
		selection {
			mode service
		}
		service {
			servicetype service
		}
		tokens { }
		unit {
			;grimeenabled #true
			;dailyagewear 0.005
			;dailytrafficwear 0.05
		}
	}
	{
		ident { template "service-base-level-one" parent "service-base" }
		placement {
			size { x 5 y 1 }
		}
		service {
		}
		sfx {
			emitter "AMB_DeliveryService"
		}
		unit {
			moveout {
				threshold { value -1 }
				dailyprob { value 1 }
			}
			evict {
				basefee 100
			}
			opx { value 0 mods [ { #type game-difficulty-modifier harddelta -100 } ] }
		}
	}
	{
		ident { template "service-level-one-courier" parent "service-base-level-one" }
		service {
			servicecat "service.one.courier.servicecat" ;; 25 chars
		}
		sprite {
			layouts [ service-level-one-courier ]
		}
		workplace {
			workers 4
			workhours { from 7 to 18.5 }
			workertemplates [ "npc-service-courier" ]
		}
		unit {
			buildcost { value -200 mods [ 
				{ #type game-difficulty-modifier harddelta 50 }	
				{ #type heatmap-modifier map floorHeatmap value -100 } ] }
			tags [ service-o courier ]
			satisfaction { value 0 mods [
				{ #type utilities-modifier type utilpower value -1 }
				{ #type service-overloaded-modifier value -0.1 }
			] }
			locname "service.one.courier"
			locdesc "service.one.courier.desc"
			loccat  "service.one.courier.cat"
			favrestaurants [ foodcourt ]
			needutilities [ { type utilpower value 1 }  ]
			opx { value -50 mods [ { #type game-difficulty-modifier harddelta -50 }
				{ #type scenario-modifier tags [ "scenario-3"] when pass multiplier 2 } ] }
		}
	}
	{
		ident { template "service-level-one-supplies" parent "service-base-level-one" }
		service {
			servicecat "service.one.supplies.servicecat"
		}
		placement {
			reqs [
			]
		}
		sprite {
			layouts [ service-level-one-supplies ]
		}
		workplace {
			workers 4
			workhours { from 9 to 19 }
			workertemplates [ "npc-service-supplies" ]
		}
		unit {
			buildcost { value -300 mods [ 
				{ #type game-difficulty-modifier harddelta 75 }
				{ #type heatmap-modifier map floorHeatmap value -100 } ] }
			tags [ supplies ]
			satisfaction { value 0 mods [
				{ #type utilities-modifier type utilpower value -1 }
				{ #type service-overloaded-modifier value -0.1 }
			] }
			locname "service.one.supplies"
			locdesc "service.one.supplies.desc"
			loccat  "service.one.supplies.cat"
			favrestaurants [ foodcourt ]
			needutilities [ { type utilpower value 1 } ]
			opx { value -75 mods [ { #type game-difficulty-modifier harddelta -75 }
				{ #type scenario-modifier tags [ "scenario-3"] when pass multiplier 2 } ] }
		}
	}
	{
		ident { template "service-level-one-water" parent "service-base-level-one" }
		service {
			servicecat "service.one.water.servicecat"
		}
		placement {
			reqs [
			]
		}
		sprite {
			layouts [ service-level-one-water ]
		}
		workplace {
			workers 4
			workhours { from 7 to 18.5 }
			workertemplates [ "npc-service-water" ]
		}
		unit {
			buildcost { value -300 mods [ 
				{ #type game-difficulty-modifier harddelta 75 }
				{ #type heatmap-modifier map floorHeatmap value -100 } ] }
			tags [ water ]
			satisfaction { value 0 mods [
				{ #type utilities-modifier type utilpower value -1 }
				{ #type service-overloaded-modifier value -0.1 }
			] }
			locname "service.one.water"
			locdesc	"service.one.water.desc"
			loccat  "service.one.water.cat"
			favrestaurants [ foodcourt ]
			needutilities [ {type utilpower value 1 } ]
			opx { value -75 mods [ { #type game-difficulty-modifier harddelta -75 } 
				{ #type scenario-modifier tags [ "scenario-3"] when pass multiplier 2 } ] }
		}
	}
	{
		ident { template "service-level-one-cleaning"  parent "service-base-level-one" }
		service {
			servicecat "service.one.cleaning.servicecat"
		}
		placement {
			reqs [

			]
		}
		service {
		}
		sprite {
			layouts [ service-level-one-cleaning ]
		}
		workplace {
			workers 4
			workhours { from 20 to 5.5 }
			workertemplates [ "npc-service-cleaning" ]
		}
		unit {
			buildcost { value -300 mods [ 
				{ #type game-difficulty-modifier harddelta 75 }
				{ #type heatmap-modifier map floorHeatmap value -100 } ] }
			locname "service.one.cleaning"
			locdesc "service.one.cleaning.desc"
			loccat  "service.one.cleaning.cat"
			favrestaurants [ diner ]
			tags [ cleaning ]
			needutilities [ { type utilpower value 2 } { type utilwater value 2 } ]
			satisfaction { value 0 mods [
				{ #type utilities-modifier type utilpower value -1 }
				{ #type utilities-modifier type utilwater value -1 }
				{ #type service-overloaded-modifier value -0.1 }
			] }
			opx { value -75 mods [ { #type game-difficulty-modifier harddelta -75 } 
				{ #type scenario-modifier tags [ "scenario-3"] when pass multiplier 2 } ] }
		}
	}
	{
		ident { template "service-level-one-copies" parent "service-base-level-one" }
		service {
			servicecat "service.one.copies.servicecat"
		}
		sprite {
			layouts [ service-level-one-copies ]
		}
		heatmap {
			produces [
				{ type noiseHeatmap value 0.4 }
			]
		}
		workplace {
			workers 4
			workhours { from 9 to 19 }
			workertemplates [ "npc-service-copy" ]
		}
		unit {
			buildcost { value -300 mods [ 
				{ #type game-difficulty-modifier harddelta 150 }
				{ #type heatmap-modifier map floorHeatmap value -100 } ] }
			locname "service.one.copies"
			locdesc "service.one.copies.desc"
			loccat  "service.one.copies.cat"
			tags [ copies ]
			favrestaurants [ foodcourt ]
			needutilities [ { type utilpower value 1 } ]
			satisfaction { value 0 mods [
				{ #type utilities-modifier type utilpower value -1 }
				{ #type service-overloaded-modifier value -0.1 }
			] }
			opx { value -50 mods [ { #type game-difficulty-modifier harddelta -50 }
				{ #type scenario-modifier tags [ "scenario-3"] when pass multiplier 2 } ] }
		}

	}
	{
		ident { template "service-level-one-copies-tutorial" parent "service-level-one-copies" }
		service {
			servicetype retail
		}
		workplace {
			workers 3
		}
		unit {
			satisfaction { value 0 mods [
			] }
		}
	}
	{
		ident { template "service-level-one-courier-tutorial" parent "service-level-one-courier" }
		service {
			servicetype retail
		}
		workplace {
			workers 3
		}
		unit {
			satisfaction { value 0 mods [
			] }
		}
	}
	{
		ident { template "service-base-level-two" parent "service-base" }
		placement {
			size { x 9 y 1 }
			reqs [

			]
		}
		service {
		}
		sfx {
			emitter "AMB_TypingService"
		}
		unit {
			moveout {
				threshold { value -1 }
				dailyprob { value 1 }
			}
			evict {
				basefee 250
			}
			opx { value -100 mods [ { #type game-difficulty-modifier harddelta -100 }
				{ #type scenario-modifier tags [ "scenario-3"] when pass multiplier 2 } ] }
		}
	}
	{
		ident { template "service-level-two-computers" parent "service-base-level-two" }
		service {
			servicecat "service.two.computers.servicecat"
		}
		sprite {
			layouts [ service-level-two-computers ]
		}
		heatmap {
			produces [
				{ type noiseHeatmap value 0.3 }
			]
		}
		workplace {
			workers 5
			workhours { from 9 to 17 }
			workertemplates [ "npc-service-computer" ]
		}
		unit {
			buildcost { value -400 mods [ { #type heatmap-modifier map floorHeatmap value -100 } ] }
			locname "service.two.it"
			locdesc "service.two.it.desc"
			loccat  "service.two.it.cat"
			satisfaction { value 0 mods [
				{ #type utilities-modifier type utilpower value -1 }
				{ #type utilities-modifier type utilphone value -1 }
				{ #type service-overloaded-modifier value -0.1 }
			] }
			tags [ computers ]
			favrestaurants [ pizza ]
			needutilities [ { type utilpower value 2 } { type utilphone value 4 } ]
			opx { value -150 mods [ { #type game-difficulty-modifier harddelta -150 } 
				{ #type scenario-modifier tags [ "scenario-3"] when pass multiplier 2 } ] }
		}
	}
	{
		ident { template "service-level-two-printer" parent "service-base-level-two" }
		service {
			servicecat "service.two.printer.servicecat"
		}
		placement {
			reqs [  ]
		}
		sprite {
			layouts [ service-level-two-printer ]
		}
		heatmap {
			produces [
				{ type noiseHeatmap value 0.5 }
			]
		}
		workplace {
			workers 5
			workhours { from 9 to 19 }
			workertemplates [ "npc-service-printer" ]
		}
		unit {
			buildcost { value -400 }
			locname "service.two.printer"
			locdesc "service.two.printer.desc"
			loccat  "service.two.printer.cat"
			satisfaction { value 0 mods [
				{ #type utilities-modifier type utilpower value -1 }
				{ #type utilities-modifier type utilphone value -1 }
				{ #type service-overloaded-modifier value -0.1 }
			] }
			tags [ printer ]
			needutilities [ { type utilpower value 4 } { type utilphone value 2 } ]
			favrestaurants [ fastfood ]
			opx { value -150 mods [ { #type game-difficulty-modifier harddelta -150 } 
				{ #type scenario-modifier tags [ "scenario-3"] when pass multiplier 2 } ] }
		}
	}
	{
		ident { template "service-level-two-storage" parent "service-base-level-two" }
		service {
			servicecat "service.two.storage.servicecat"
		}
		placement {
			reqs [
                { #type peep-count-requirement total #true count 30 }
			]
		}
		sprite {
			layouts [ service-level-two-storage ]
		}
		workplace {
			workers 5
			workhours { from 8 to 17 }
			workertemplates [ "npc-service-storage" ]
		}
		unit {
			buildcost { value -400 }
			locname "service.two.storage"
			locdesc "service.two.storage.desc"
			loccat  "service.two.storage.cat"
			tags [ storage ]
			satisfaction { value 0 mods [
				{ #type utilities-modifier type utilpower value -1 }
				{ #type utilities-modifier type utilphone value -1 }
				{ #type service-overloaded-modifier value -0.1 }
			] }
			needutilities [ { type utilpower value 2 } { type utilphone value 2 } ]
			favrestaurants [ pizza ]
			opx { value -150 mods [ { #type game-difficulty-modifier harddelta -150 } 
				{ #type scenario-modifier tags [ "scenario-3"] when pass multiplier 2 } ] }
		}
	}
	{
		ident { template "service-level-two-catering" parent "service-base-level-two" }
		service {
			servicecat "service.two.catering.servicecat"
		}
		placement {
		}
		service {
		}
		sfx {
			emitter "AMB_DeliveryService"
		}
		sprite {
			layouts [ service-level-two-catering ]
		}
		heatmap {
			produces [
				{ type noiseHeatmap value 0.2 }
				{ type smellHeatmap value 0.5 }
			]
		}
		workplace {
			workhours { from 11 to 15 }
			workers 5
			workertemplates [ "npc-service-catering" ]
		}
		unit {
			buildcost { value -400 mods [ { #type heatmap-modifier map floorHeatmap value -100 } ] }
			locname "service.two.catering"
			locdesc "service.two.catering.desc"
			loccat  "service.two.catering.cat"
			favrestaurants [ diner ]
			tags [ catering ]
			satisfaction { value 0 mods [
				{ #type utilities-modifier type utilpower value -1 }
				{ #type utilities-modifier type utilphone value -1 }
				{ #type utilities-modifier type utilwater value -1 }
				{ #type utilities-modifier type utilgas value -1 }
				{ #type trash-delivery-modifier type trash value -0.5 }
				{ #type service-overloaded-modifier value -0.1 }
			] }
			needutilities [ { type utilpower value 2 } { type utilphone value 2 } { type utilwater value 2 } { type utilgas value 2 } ]
			trashhour 14.5
			trashproduced [
				{ item trash amount 1 probability 1 }
			]
			opx { value -150 mods [ { #type game-difficulty-modifier harddelta -150 } 
				{ #type scenario-modifier tags [ "scenario-3"] when pass multiplier 2 } ] }
		}
	}
	{
		ident { template "service-base-level-three" parent "service-base" }
		placement {
			size { x 12 y 1 }
			buildhours 4
			reqs [

			]
		}
		service {
		}
		sfx {
			emitter "AMB_TypingService"
		}
		unit {
			moveout {
				threshold { value -1 }
				dailyprob { value 1 }
			}
			evict {
				basefee 750
			}
		}
	}
	{
		ident { template "service-level-three-auditors" parent "service-base-level-three" }
		service {
			servicecat "service.three.auditors.servicecat"
		}
		placement {
			reqs [

			]
		}
		sprite {
			layouts [ service-level-three-consultants ]
		}
		workplace {
			workers 4
			workertemplates [ "npc-service-auditor" ]
		}
		unit {
			buildcost { value -650 mods [ { #type heatmap-modifier map floorHeatmap value -100 } ] }
			tags [ auditors service-three-typeone ]
			satisfaction { value 0 mods [
				{ #type utilities-modifier type utilpower value -1 }
				{ #type utilities-modifier type utilphone value -1 }
				{ #type service-overloaded-modifier value -0.1 }
			] }
			needutilities [
				{ type utilpower value 2 }
				{ type utilphone value 4 }
			]
			locname "service.three.auditors"
			locdesc "service.three.auditors.desc"
			loccat "service.three.auditors.cat"
			opx { value -375 mods [ { #type game-difficulty-modifier harddelta -375 } 
				{ #type scenario-modifier tags [ "scenario-3"] when pass multiplier 2 } ] }
		}
	}
	{
		ident { template "service-level-three-design" parent "service-base-level-three" }
		service {
			servicecat "service.three.design.servicecat"
		}
		placement {
			reqs [

			]
		}
		sprite {
			layouts [ service-level-three-design ]
		}
		workplace {
			workers 4
			workertemplates [ "npc-service-design" ]
		}
		unit {
			buildcost { value -650 mods [ { #type heatmap-modifier map floorHeatmap value -100 } ] }
			tags [ marketing service-three-typeone ]
			satisfaction { value 0 mods [
				{ #type utilities-modifier type utilpower value -1 }
				{ #type utilities-modifier type utilphone value -1 }
				{ #type service-overloaded-modifier value -0.1 }
			] }
			needutilities [
				{ type utilpower value 2 }
				{ type utilphone value 4 }
			]
			locname "service.three.design"
			locdesc "service.three.design.desc"
			loccat "service.three.design.cat"
			opx { value -375 mods [ { #type game-difficulty-modifier harddelta -375 } 
				{ #type scenario-modifier tags [ "scenario-3"] when pass multiplier 2 } ] }
		}
	}
	{
		ident { template "service-level-three-tempagency" parent "service-base-level-three" }
		service {
			servicecat "service.three.temps.servicecat"
		}
		placement {
			reqs [

			]
		}
		sprite {
			layouts [ service-level-three-tempagency ]
		}
		workplace {
			workers 4
			workertemplates [ "npc-service-temps" ]
		}
		unit {
			buildcost { value -650 mods [ { #type heatmap-modifier map floorHeatmap value -100 } ] }
			tags [ tempagency service-three-typeone ]
			satisfaction { value 0 mods [
				{ #type utilities-modifier type utilpower value -1 }
				{ #type utilities-modifier type utilphone value -1 }
				{ #type service-overloaded-modifier value -0.1 }
			] }
			needutilities [
				{ type utilpower value 2 }
				{ type utilphone value 4 }
			]
			locname "service.three.temps"
			locdesc "service.three.temps.desc"
			loccat "service.three.temps.cat"
			opx { value -375 mods [ { #type game-difficulty-modifier harddelta -375 } 
				{ #type scenario-modifier tags [ "scenario-3"] when pass multiplier 2 } ] }
		}
	}
	{
		ident { template "service-level-three-security" parent "service-base-level-three" }
		service {
			servicecat "service.three.security.servicecat"
		}
		placement {
			reqs [

			]
		}
		sprite {
			layouts [ service-level-three-security ]
		}
		workplace {
			workers 4
			workertemplates [ "npc-service-security" ]
		}
		unit {
			buildcost { value -650 mods [ { #type heatmap-modifier map floorHeatmap value -100 } ] }
			tags [ security service-three-typetwo ]
			satisfaction { value 0 mods [
				{ #type utilities-modifier type utilpower value -1 }
				{ #type utilities-modifier type utilphone value -1 }
				{ #type service-overloaded-modifier value -0.1 }
			] }
			needutilities [
				{ type utilpower value 2 }
				{ type utilphone value 4 }
			]
			locname "service.three.security"
			locdesc "service.three.security.desc"
			loccat "service.three.security.cat"
			opx { value -375 mods [ { #type game-difficulty-modifier harddelta -375 } 
				{ #type scenario-modifier tags [ "scenario-3"] when pass multiplier 2 } ] }
		}
	}
	{
		ident { template "service-level-three-fitness" parent "service-base-level-three" }
		service {
			servicecat "service.three.fitness.servicecat"
		}
		placement {
			reqs [

			]
		}
		sprite {
			layouts [ service-level-three-fitness ]
		}
		workplace {
			workers 3
			workertemplates [ "npc-service-fitness" ]
		}
		unit {
			buildcost { value -650 mods [ { #type heatmap-modifier map floorHeatmap value -100 } ] }
			tags [ security service-three-typetwo ]
			satisfaction { value 0 mods [
				{ #type utilities-modifier type utilpower value -1 }
				{ #type utilities-modifier type utilphone value -1 }
				{ #type utilities-modifier type utilwater value -1 }
				{ #type service-overloaded-modifier value -0.1 }
			] }
			needutilities [
				{ type utilpower value 2 }
				{ type utilphone value 2 }
				{ type utilwater value 2 }
			]
			locname "service.three.fitness"
			locdesc "service.three.fitness.desc"
			loccat "service.three.fitness.cat"
			opx { value -375 mods [ { #type game-difficulty-modifier harddelta -375 }
				{ #type scenario-modifier tags [ "scenario-3"] when pass multiplier 2 } ] }
		}
	}

	{
		ident { template "service-base-level-four" parent "service-base" }
		placement {
			size { x 8 y 1 }
			buildhours 6
			reqs [

			]
		}
		service {
		}
		sfx {
			emitter "AMB_TypingService"
		}
		unit {
			moveout {
				threshold { value -1 }
				dailyprob { value 1 }
			}
			evict {
				basefee 1000
			}
		}
	}
	{
		ident { template "service-level-four-club" parent "service-base-level-four" }
		service {
			servicecat "service.four.club.servicecat"
		}
		placement {
			reqs [
				{ #type floor-requirement parterre #false aboveground #true belowground #false }
			]
		}
		sprite {
			layouts [ service-four-club ]
		}
		workplace {
			workers 1
			workertemplates [ "npc-service-club" ]
		}
		unit {
			buildcost { value -1000 mods [ { #type heatmap-modifier map floorHeatmap value -100 } ] }
			tags [ club service-four ]
			satisfaction { value 0 mods [
					{ #type utilities-modifier type utilpower value -1 }
					{ #type utilities-modifier type utilphone value -1 }
					{ #type utilities-modifier type utilcable value -1 }
				] }
			opx { value -1200 }
			needutilities [
				{ type utilpower value 2 }
				{ type utilcable value 2 }
				{ type utilphone value 2 }
			]
			needservices [
				{ tasktype servicecatering probability 0.25 businesshoursonly #true workhours 0.2 timeouthours 20 timeouteffect -0.5 }
				{ tasktype servicejanitor probability 1 businesshoursonly #false workhours 1 timeouthours 20 timeouteffect -0.5 }
				{ tasktype servicefitness probability 0.1 businesshoursonly #true workhours 1.5 timeouthours 20 timeouteffect -0.5 }
			]
			locname "service.four.club"
			locdesc "service.four.club.desc"
			locdesc "service.four.club.cat"
			moveout {
				threshold { value -0.6 }
				dailyprob { value 1 }
			}
		}
	}
	{
		ident { template "service-level-four-helicopter" parent "service-base-level-four" }
		service {
			servicecat "service.four.helicopter.servicecat"
		}
		placement {
			reqs [
				{ #type floor-requirement parterre #false aboveground #true belowground #false }
			]
		}
		sprite {
			layouts [ service-four-helicopter ]
		}
		workplace {
			workers 2
			workertemplates [ "npc-service-helicopter" ]
		}
		unit {
			buildcost { value -1000 mods [ { #type heatmap-modifier map floorHeatmap value -100 } ] }
			tags [ helicopter service-four ]
			satisfaction { value 0 mods [ 
					{ #type utilities-modifier type utilpower value -1 }
					{ #type utilities-modifier type utilphone value -1 }
					{ #type service-overloaded-modifier value -0.1 }
			 ] }
			needutilities [
				{ type utilpower value 2 }
				{ type utilphone value 4 }
			]
			locname "service.four.helicopter"
			locdesc "service.four.helicopter.desc"
			loccat "service.four.helicopter.cat"
			opx { value -600 mods [ { #type game-difficulty-modifier harddelta -600 } 
				{ #type scenario-modifier tags [ "scenario-3"] when pass multiplier 2 } ] }
		}
	}
	{
		ident { template "service-level-four-limo" parent "service-base-level-four" }
		service {
			servicecat "service.four.limo.servicecat"
		}
		placement {
			reqs [
				{ #type floor-requirement parterre #false aboveground #true belowground #false }
			]
		}
		sprite {
			layouts [ service-four-limo ]
		}
		workplace {
			workers 2
			workertemplates [ "npc-service-limo" ]
		}
		unit {
			buildcost { value -2000 mods [ { #type heatmap-modifier map floorHeatmap value -100 } ] }
			tags [ helicopter service-four ]
			satisfaction { value 0 mods [ 
					{ #type utilities-modifier type utilpower value -1 }
					{ #type utilities-modifier type utilphone value -1 }
					{ #type service-overloaded-modifier value -0.1 }
			 ] }
			needutilities [
				{ type utilpower value 2 }
				{ type utilphone value 4 }
			]
			locname "service.four.limo"
			locdesc "service.four.limo.desc"
			loccat "service.four.limo.cat"
			opx { value -600 mods [ { #type game-difficulty-modifier harddelta -600 } 
				{ #type scenario-modifier tags [ "scenario-3"] when pass multiplier 2 } ] }
		}
	}


	;;;;;;;;;;;;;;;;;;; residential services

	;; level 1

	{
		ident { template "service-base-residential-one" parent "service-base" }
		placement {
			size { x 5 y 1 }
		}
		service {
		}
		sfx {
			emitter "AMB_DeliveryService"
		}
		unit {
			moveout {
				threshold { value -1 }
				dailyprob { value 1 }
			}
			opx { value -50 mods [ { #type game-difficulty-modifier harddelta -50 } ] }
		}
	}
	{
		ident { template "service-residential-one-handyman" parent "service-base-residential-one" }
		service {
			servicecat "service.one.handyman.servicecat"
		}
		placement {
			reqs [
			]
		}
		sprite {
			layouts [ service-residential-one-handyman ]
		}
		workplace {
			workers 4
			workhours { from 7 to 16.5 }
			workertemplates [ "npc-service-handyman" ]
		}
		unit {
			buildcost { value -200 mods [ { #type heatmap-modifier map floorHeatmap value -100 } ] }
			tags [ service-r service-r-1point handyman ]
			satisfaction { value 0 mods [
				{ #type utilities-modifier type utilpower value -1 }
				{ #type service-overloaded-modifier value -0.1 }
			] }
			locname "service.residential.handyman"
			locdesc	"service.residential.handyman.desc"
			needutilities [ {type utilpower value 2 } ]
			evict {
				basefee 100
			}
		}
	}
	{
		ident { template "service-residential-one-plumber" parent "service-base-residential-one" }
		service {
			servicecat "service.one.plumber.servicecat"
		}
		sprite {
			layouts [ service-residential-one-plumber ]
		}
		workplace {
			workers 4
			workhours { from 7 to 16.5 }
			workertemplates [ "npc-service-plumber" ]
		}
		unit {
			buildcost { value -200 mods [ { #type heatmap-modifier map floorHeatmap value -100 } ] }
			tags [ service-r service-r-1point plumber ]
			satisfaction { value 0 mods [
				{ #type utilities-modifier type utilpower value -1 }
				{ #type service-overloaded-modifier value -0.1 }
			] }
			locname "service.residential.plumber"
			locdesc	"service.residential.plumber.desc"
			needutilities [ {type utilpower value 2 } ]
			evict {
				basefee 100
			}
		}
	}
	{
		ident { template "service-residential-one-laundry" parent "service-base-residential-one" }
		service {
			linecapacity 0
			seatcapacity 4
			servicehours 1.5
			servicecat "service.one.laundry.servicecat"
		}
		sprite {
			layouts [ service-residential-one-laundry ]
		}
		heatmap {
			produces [
				{ type noiseHeatmap value 0.7 }
			]
		}
		workplace {
			workers 4
			workhours { from 8 to 17 }
			workertemplates [ "npc-service-laundry" ]
		}
		unit {
			buildcost { value -200 mods [ { #type heatmap-modifier map floorHeatmap value -100 } ] }
			tags [ service-r service-r-1point laundry ]
			satisfaction { value 0 mods [
				{ #type utilities-modifier type utilpower value -1 }
				{ #type utilities-modifier type utilwater value -1 }
				{ #type utilities-modifier type utilgas value -1 }
				{ #type service-overloaded-modifier value -0.1 }
			] }
			locname "service.residential.laundry"
			locdesc	"service.residential.laundry.desc"
			needutilities [ {type utilpower value 2 } { type utilwater value 2 } { type utilgas value 2 } ]
			evict {
				basefee 100
			}
		}
	}

	;;  level 2

	{
		ident { template "service-base-residential-two" parent "service-base" }
		placement {
			size { x 9 y 1 }
		}
		service {
		}
		sfx {
			emitter "AMB_TypingService"
		}
		unit {
			moveout {
				threshold { value -1 }
				dailyprob { value 1 }
			}
			evict {
				basefee 500
			}
			trashhour 18.5
			opx { value -75 mods [ { #type game-difficulty-modifier harddelta -75 } ] }
		}
	}
	{
		ident { template "service-residential-two-dogs" parent "service-base-residential-two" }
		placement {
			reqs [
				{ #type prestige-requirement value 5 }
				; residential peeps requirement once we've got that in
				; retial score requirement once we've got that in
			]
		}
		service {
			linecapacity 2
			seatcapacity 5
			servicecat "service.two.dogwalker.servicecat"
		}
		sprite {
			layouts [ service-residential-two-dogs ]
		}
		heatmap {
			produces [
				{ type smellHeatmap value 0.5 }
				{ type noiseHeatmap value 0.5 }
			]
		}
		workplace {
			workers 4
			workhours { from 8 to 17 }
			workertemplates [ "npc-service-dogwalker" ]
		}
		unit {
			buildcost { value -500 mods [ 
				{ #type game-difficulty-modifier harddelta 200 }	
				{ #type heatmap-modifier map floorHeatmap value -100 } ] }
			tags [ service-r service-r-3points ]
			satisfaction { value 0 mods [
				{ #type utilities-modifier type utilpower value -1 }
				{ #type utilities-modifier type utilphone value -1 }
				{ #type utilities-modifier type utilwater value -1 }
				{ #type trash-delivery-modifier type trash value -0.3 }
				{ #type service-overloaded-modifier value -0.1 }
			] }
			trashproduced [
				{ item trash amount 2 probability 1 }
			]
			needutilities [
				{ type utilpower value 2 }
				{ type utilwater value 4 }
				{ type utilphone value 2 }
			]
			locname "service.residential.dogwalker"
			locdesc "service.residential.dogwalker.desc"
		}
	}
	{
		ident { template "service-residential-two-cleaners" parent "service-base-residential-two" }
		service {
			servicecat "service.two.housekeeping.servicecat"
		}
		sprite {
			layouts [ service-residential-two-cleaners ]
		}
		workplace {
			workers 5
			workhours { from 8 to 17 }
			workertemplates [ "npc-service-housekeeping" ]
		}
		unit {
			buildcost { value -500 mods [ 
				{ #type game-difficulty-modifier harddelta 200 }
				{ #type heatmap-modifier map floorHeatmap value -100 } ] }
			tags [ service-r service-r-3points ]
			satisfaction { value 0 mods [
				{ #type utilities-modifier type utilpower value -1 }
				{ #type utilities-modifier type utilphone value -1 }
				{ #type utilities-modifier type utilwater value -1 }
				{ #type trash-delivery-modifier type trash value -0.3 }
				{ #type trash-delivery-modifier type recycling value -0.3 }
				{ #type service-overloaded-modifier value -0.1 }
			] }
			trashproduced [
				{ item trash amount 2 probability 1 }
				{ item recycling amount 1 probability 1 }
			]
			needutilities [
				{ type utilwater value 2 }
				{ type utilpower value 1 }
				{ type utilphone value 1 }
			]
			locname "service.residential.cleaning"
			locdesc "service.residential.cleaning.desc"
		}
	}

	;; level 3
	{
		ident { template "service-base-residential-three" parent "service-base" }
		placement {
			size { x 12 y 1 }
		}
		service {
		}
		sfx {
			emitter "AMB_TypingService"
		}
		unit {
			moveout {
				threshold { value -1 }
				dailyprob { value 1 }
			}
			evict {
				basefee 1500
			}
			trashhour 19
			opx { value -150 mods [ { #type game-difficulty-modifier harddelta -150 } ] }
		}
	}
	{
		ident { template "service-residential-three-drycleaning" parent "service-base-residential-three" }
		service {
			servicecat "service.three.drycleaning.servicecat"
		}
		sprite {
			layouts [ service-r-three-drycleaning ]
		}
		workplace {
			workers 4
			workhours { from 8 to 17 }
			workertemplates [ "npc-service-drycleaner" ]
		}
		unit {
			buildcost { value -1000 mods [ 
				{ #type game-difficulty-modifier harddelta 550 }
				{ #type heatmap-modifier map floorHeatmap value -100 } ] }
			tags [ service-r service-r-5points ]
			satisfaction { value 0 mods [
					{ #type utilities-modifier type utilpower value -1 }
					{ #type utilities-modifier type utilwater value -1 }
					{ #type utilities-modifier type utilgas value -1 }
					{ #type trash-delivery-modifier type trash value -0.4 }
					{ #type trash-delivery-modifier type recycling value -0.4 }
					{ #type service-overloaded-modifier value -0.1 }
				] }
			trashproduced [
				{ item trash amount 1 probability 1 }
				{ item recycling amount 2 probability 1 }
			]
			needutilities [
				{ type utilpower value 2 }
				{ type utilwater value 5 }
				{ type utilgas value 2 }
			]
			locname "service.residential.drycleaning"
			locdesc "service.residential.drycleaning.desc"
		}
	}
	{
		ident { template "service-residential-three-flowers" parent "service-base-residential-three" }
		service {
			servicecat "service.three.flowers.servicecat"
		}
		sprite {
			layouts [ service-r-three-floral ]
		}
		workplace {
			workers 5
			workhours { from 7.5 to 17 }
			workertemplates [ "npc-service-flowers" ]
		}
		unit {
			buildcost { value -1000 mods [ 
				{ #type game-difficulty-modifier harddelta 550 }
				{ #type heatmap-modifier map floorHeatmap value -100 } ] }
			tags [ service-r service-r-5points ]
			satisfaction { value 0 mods [
					{ #type utilities-modifier type utilpower value -1 }
					{ #type utilities-modifier type utilphone value -1 }
					{ #type utilities-modifier type utilwater value -1 }
					{ #type trash-delivery-modifier type trash value -0.4 }
					{ #type trash-delivery-modifier type recycling value -0.4 }
					{ #type service-overloaded-modifier value -0.1 }
				] }
			trashproduced [
				{ item trash amount 1 probability 1 }
				{ item recycling amount 1 probability 1 }
			]
			needutilities [
				{ type utilpower value 2 }
				{ type utilwater value 4 }
				{ type utilphone value 2 }
			]
			locname "service.residential.flowers"
			locdesc "service.residential.flowers.desc"
		}
	}
	{
		ident { template "service-residential-three-tailor" parent "service-base-residential-three" }
		service {
			servicecat "service.three.tailor.servicecat"
		}
		sprite {
			layouts [ service-residential-three-tailor ]
		}
		workplace {
			workers 2
			workhours { from 8 to 17 }
			workertemplates [ "npc-serivce-tailor" ]
		}
		unit {
			buildcost { value -1000 mods [ 
				{ #type game-difficulty-modifier harddelta 550 }
				{ #type heatmap-modifier map floorHeatmap value -100 } ] }
			tags [ service-r service-r-5points ]
			satisfaction { value 0 mods [
					{ #type utilities-modifier type utilpower value -1 }
					{ #type utilities-modifier type utilphone value -1 }
					{ #type trash-delivery-modifier type trash value -0.4 }
					{ #type trash-delivery-modifier type recycling value -0.4 }
					{ #type service-overloaded-modifier value -0.1 }
				] }
			trashproduced [
				{ item trash amount 1 probability 1 }
				{ item recycling amount 1 probability 1 }
			]
			needutilities [
				{ type utilpower value 2 }
				{ type utilphone value 2 }
			]
			locname "service.residential.tailor"
			locdesc "service.residential.tailor.desc"
		}
	}
	{
		ident { template "service-residential-three-daycare" parent "service-base-residential-three" }
		service {
			servicecat "service.three.daycare.servicecat"
		}
		sprite {
			layouts [ service-r-three-daycare ]
		}
		heatmap {
			produces [
				{ type noiseHeatmap value 0.5 }
			]
		}
		workplace {
			workers 4
			workhours { from 8 to 17 }
			workertemplates [ "npc-service-daycare" ]
		}
		unit {
			buildcost { value -1000 mods [ 
				{ #type game-difficulty-modifier harddelta 550 }
				{ #type heatmap-modifier map floorHeatmap value -100 } ] }
			tags [ service-r service-r-5points ]
			satisfaction { value 0 mods [
					{ #type utilities-modifier type utilpower value -1 }
					{ #type utilities-modifier type utilphone value -1 }
					{ #type utilities-modifier type utilcable value -1 }
					{ #type trash-delivery-modifier type trash value -0.4 }
					{ #type trash-delivery-modifier type recycling value -0.4 }
					{ #type service-overloaded-modifier value -0.1 }
				] }
			trashproduced [
				{ item trash amount 1 probability 1 }
				{ item recycling amount 1 probability 1 }
			]
			needutilities [
				{ type utilpower value 2 }
				{ type utilphone value 2 }
				{ type utilcable value 2 }
			]
			locname "service.residential.daycare"
			locdesc "service.residential.daycare.desc"
		}
	}
	{
		ident { template "service-residential-three-dogdaycare" parent "service-base-residential-three" }
		service {
			servicecat "service.three.dogsitting.servicecat"
		}
		sprite {
			layouts [ service-r-three-dogdaycare ]
		}
		heatmap {
			produces [
				{ type smellHeatmap value 0.5 }
				{ type noiseHeatmap value 0.5 }
			]
		}
		workplace {
			workers 4
			workhours { from 8 to 17 }
			workertemplates [ "npc-service-dogsitter" ]
		}
		unit {
			buildcost { value -1000 mods [ 
				{ #type game-difficulty-modifier harddelta 550 }
				{ #type heatmap-modifier map floorHeatmap value -100 } ] }
			tags [ service-r service-r-5points ]
			satisfaction { value 0 mods [
					{ #type utilities-modifier type utilpower value -1 }
					{ #type utilities-modifier type utilphone value -1 }
					{ #type utilities-modifier type utilwater value -1 }
					{ #type trash-delivery-modifier type trash value -0.4 }
					{ #type trash-delivery-modifier type recycling value -0.4 }
					{ #type service-overloaded-modifier value -0.1 }
				] }
			trashproduced [
				{ item trash amount 2 probability 1 }
				{ item recycling amount 1 probability 1 }
			]
			needutilities [
				{ type utilpower value 2 }
				{ type utilphone value 2 }
				{ type utilwater value 4 }
			]
			locname "service.residential.dogsitting"
			locdesc "service.residential.dogsitting.desc"
		}
	}
	{
		ident { template "service-residential-three-gym" parent "service-base-residential-three" }
		service {
			servicecat "service.three.gym.servicecat"
		}
		sprite {
			layouts [ service-r-three-gym ]
		}
		workplace {
			workers 4
			workhours { from 8 to 17 }
			workertemplates [ "npc-service-gym" ]
		}
		unit {
			buildcost { value -1000 mods [ 
				{ #type game-difficulty-modifier harddelta 550 }
				{ #type heatmap-modifier map floorHeatmap value -100 } ] }
			tags [ service-r service-r-5points ]
			satisfaction { value 0 mods [
					{ #type utilities-modifier type utilpower value -1 }
					{ #type utilities-modifier type utilphone value -1 }
					{ #type utilities-modifier type utilwater value -1 }
					{ #type trash-delivery-modifier type trash value -0.4 }
					{ #type trash-delivery-modifier type recycling value -0.4 }
					{ #type service-overloaded-modifier value -0.1 }
				] }
			trashproduced [
				{ item trash amount 1 probability 1 }
				{ item recycling amount 1 probability 1 }
			]
			needutilities [
				{ type utilpower value 2 }
				{ type utilphone value 2 }
				{ type utilwater value 4 }
			]
			locname "service.residential.gym"
			locdesc "service.residential.gym.desc"
		}
	}
	;; level 4
	{
		ident { template "service-base-residential-four" parent "service-base" }
		placement {
			size { x 10 y 1 }
			reqs [
				{ #type prestige-requirement value 10 sathit -0.5 }
			]
		}
		service {
		}
		sfx {
			emitter "AMB_TypingService"
		}
		unit {
			moveout {
				threshold { value -1 }
				dailyprob { value 1 }
			}
			evict {
				basefee 2500
			}
			trashhour 19
			opx { value -250 mods [ { #type game-difficulty-modifier harddelta -250 } ] }
		}
	}
	{
		ident { template "service-residential-four-yoga" parent "service-base-residential-four" }
		service {
			servicecat "service.four.yoga.servicecat"
		}
		sprite {
			layouts [ service-r-four-yoga ]
		}
		workplace {
			workers 4
			workhours { from 9 to 17.5 }
			workertemplates [ "npc-service-yoga" ]
		}
		unit {
			buildcost { value -2500 mods [ 
				{ #type game-difficulty-modifier harddelta 1600 }
				{ #type heatmap-modifier map floorHeatmap value -100 } ] }
			tags [ service-r service-r-four ]
			satisfaction { value 0 mods [
				{ #type utilities-modifier type utilpower value -1 }
				{ #type utilities-modifier type utilwater value -1 }
				{ #type service-overloaded-modifier value -0.1 }
				] }
			needutilities [
				{ type utilpower value 2 }
				{ type utilwater value 4 }
			]
			locname "service.residential.yoga"
			locdesc "service.residential.yoga.desc"
		}
	}
	{
		ident { template "service-residential-four-decorator" parent "service-base-residential-four" }
		service {
			servicecat "service.four.decorator.servicecat"
		}
		sprite {
			layouts [ service-r-four-decorator ]
		}
		workplace {
			workers 4
			workhours { from 9 to 17.5 }
			workertemplates [ npc-service-decorator ]
		}
		unit {
			buildcost { value -2500 mods [ 
				{ #type game-difficulty-modifier harddelta 1600 }
				{ #type heatmap-modifier map floorHeatmap value -100 } ] }
			tags [ service-r service-r-four ]
			satisfaction { value 0 mods [
					{ #type utilities-modifier type utilpower value -1 }
					{ #type utilities-modifier type utilphone value -1 }
					{ #type service-overloaded-modifier value -0.1 }
				] }
			needutilities [
				{ type utilpower value 3 }
				{ type utilphone value 3 }
			]
			locname "service.residential.decorator"
			locdesc "service.residential.decorator.desc"
		}
	}
	{
		ident { template "service-residential-four-finance" parent "service-residential-four-decorator" }
		service {
			servicecat "service.four.finance.servicecat"
		}
		sprite {
			layouts [ service-r-four-finance ]
		}
		workplace {
			workertemplates [ npc-service-finance ]
		}
		unit {
			tags [  ]
			locname "service.residential.finance"
			locdesc "service.residential.finance.desc"
		}
	}



	;;;;;;;;;;;;;;;;;;;; retail units

	{
		ident { template "retail-base" parent "workplace-base" }
		dock {
			type consumes
			amount 1
		}
		heatmap { }
		placement {
		}
		selection {
			mode retail
		}
		sfx {
			emitter "AMB_Store"
		}
		unit {
			moveout {
				threshold { value -0.5 mods [ { #type game-difficulty-modifier easydelta -0.1 harddelta 0.1 } ] }
				dailyprob { value 1 }
			}
		}
		service {
			servicetype retail
		}
		tokens { }

	}
	{
		ident { template "retail-level-one-base" parent "retail-base" }
		placement {
			size { x 7 y 1 }
		}
		service {
			seatcapacity 15
			servicehours 0.2
			servicerevs { from 8 to 13
					mods [
					{ #type game-difficulty-modifier hardmultiplier 1.01 easymultiplier 1.25 }
					{ #type economy-modifier multiplier 2 rounding 1 }
					{ #type golden-age-modifier id goldenage-commercial-profit multiplier 1.5 }
					{ #type scenario-modifier tags [ "scenario-9" ] when pass multiplier 1.5 } 
				] }
		}
		unit {
			evict {
				basefee 250
			}
			buildcost { value -350 mods [
				{ #type game-difficulty-modifier harddelta 100 }
				{ #type heatmap-modifier map floorHeatmap value -100 }
				{ #type golden-age-modifier id goldenage-commercial-feature multiplier 0.5 }
				] }
			grimeenabled #true
			dailyagewear 0.005
			dailytrafficwear 0.025
			visitors [
				{ template "npc-visitor-retail-1" probability 0.5 time { from 11 to 16 } hourlycount 2 }
				{ template "npc-visitor-retail-2" probability 0.5 time { from 8 to 13 } hourlycount 2 }
				{ template "npc-visitor-retail-5" probability 0.5 time { from 12 to 17 } hourlycount 1 }
		]
		}
		tokens {
			happybuzzprob 0.25
			upsetbuzzprob 0.25
		}
	}
	{
		ident { template "retail-level-two-base" parent "retail-base" }
		sfx {
			emitter "AMB_Store"
		}
		placement {
			size { x 12 y 1 }
		}
		heatmap {
			produces [
				{ type noiseHeatmap value 0.5 }
			]
		}
		service {
			seatcapacity 30
			servicehours 0.75
			servicerevs { from 12 to 17 mods [
				{ #type game-difficulty-modifier hardmultiplier 0.68 easymultiplier 1.25 }
				{ #type economy-modifier multiplier 3 rounding 1 }
				{ #type golden-age-modifier id goldenage-commercial-profit multiplier 1.5 }
				{ #type scenario-modifier tags [ "scenario-9" ] when pass multiplier 1.5 }
				] }
		}
		unit {
			evict {
				basefee 500
			}
			buildcost { value -750 mods [
					{ #type game-difficulty-modifier harddelta 400 }
					{ #type heatmap-modifier map floorHeatmap value -100 }
					{ #type golden-age-modifier id goldenage-commercial-feature multiplier 0.5 }
					; add escalator heatmap mod?
				] }
			visitors [
				{ template "npc-visitor-retail-3" probability 0.75 time { from 10 to 16 } hourlycount 3 }
				{ template "npc-visitor-retail-4" probability 0.75 time { from 16 to 20 } hourlycount 3 }
			]
			grimeenabled #true
			dailyagewear 0.005
			dailytrafficwear 0.025
		}
		tokens {
			happybuzzprob 0.75
			upsetbuzzprob 0.75
		}
	}
	{
		ident { template "retail-level-three-base" parent "retail-base" }
		sfx {
			emitter "AMB_Store"
		}
		placement {
			size { x 12 y 2 }
		}
		heatmap {
			produces [
				{ type noiseHeatmap value 0.75 }
			]
		}
		service {
			seatcapacity 50
			servicehours 1
			servicerevs { from 14 to 19 mods [
				{ #type game-difficulty-modifier hardmultiplier 0.57 easymultiplier 1.35 }
				{ #type economy-modifier multiplier 4 rounding 1 }
				{ #type golden-age-modifier id goldenage-commercial-profit multiplier 1.5 }
				{ #type scenario-modifier tags [ "scenario-9" ] when pass multiplier 1.5 }
				] }
		}
		unit {
			evict {
				basefee 1000
			}
			buildcost { value -1200 mods [
					{ #type game-difficulty-modifier harddelta 300 }
					{ #type heatmap-modifier map floorHeatmap value -100 }
					{ #type golden-age-modifier id goldenage-commercial-feature multiplier 0.5 }
					; add escalator heatmap mod?
				] }
			visitors [
				{ template "npc-visitor-retail-3" probability 1 time { from 11 to 16 } hourlycount 5 }
				{ template "npc-visitor-retail-4" probability 1 time { from 16 to 20 } hourlycount 5 }
				{ template "npc-visitor-retail-5" probability 1 time { from 10 to 14 } hourlycount 5 }
			]
			grimeenabled #true
			dailyagewear 0.005
			dailytrafficwear 0.025
		}
		tokens {
			happybuzzprob 1
			upsetbuzzprob 1
		}
	}
	{
		ident { template "retail-level-four-base" parent "retail-base" }
		sfx {
			emitter "AMB_Store_Posh"
		}
		placement {
			size { x 8 y 1 }
		}
		heatmap {
			produces [
			]
		}
		service {
			seatcapacity 10
			servicehours 1
			servicerevs { from 30 to 35 mods [
				{ #type game-difficulty-modifier hardmultiplier 0.69 easymultiplier 1.25 }
				{ #type economy-modifier multiplier 5 rounding 1 }
				{ #type golden-age-modifier id goldenage-commercial-profit multiplier 1.5 }
				{ #type scenario-modifier tags [ "scenario-9" ] when pass multiplier 1.5 }
				] }
		}
		unit {
			evict {
				basefee 1000
			}
			buildcost { value -1800 mods [
					{ #type game-difficulty-modifier harddelta 300 }
					{ #type heatmap-modifier map floorHeatmap value -100 }
					{ #type golden-age-modifier id goldenage-commercial-feature multiplier 0.5 }
					; add escalator heatmap mod?
				] }
			visitors [
				{ template "npc-visitor-retail-3" probability 1 time { from 11 to 18 } hourlycount 1 }
				{ template "npc-visitor-retail-4" probability 1 time { from 11 to 18 } hourlycount 1 }
				{ template "npc-visitor-retail-5" probability 1 time { from 11 to 18 } hourlycount 1 }
			]
			grimeenabled #true
			dailyagewear 0.005
			dailytrafficwear 0.025
		}
		tokens {
			happybuzzprob 1
			upsetbuzzprob 1
		}
	}
	{
		ident { template "retail-level-one-a" parent "retail-level-one-base" }
		heatmap {
			produces [
				{ type noiseHeatmap value 0.6 }
			]
		}
		placement {
			reqs [
				{ #type prestige-requirement value 1 sathit -0.2 }
				{ #type dock-bay-requirement sathit -1 }
			]
		}
		sprite {
			layouts [ retail-level-one-a ]
		}
		workplace {
			workers 1
			workertemplates [ "npc-retail-retail.a-retail.day" ]
			workhours { from 8 to 18 }
		}
		unit {
			locpattern "#pattern-retail-convenience"
			locdesc "retail.one.a.desc"
			loccat  "retail.one.a.cat"
			pays { value 200 mods [ 
				{ #type game-difficulty-modifier hardmultiplier 1.03 easymultiplier 1.1 }	
				{ #type economy-modifier multiplier 40 } ] }
			satisfaction { value 0 mods [
				{ #type rent-deal-modifier }
				{ #type profit-percent-modifier multiplier 0.51 }
				{ #type utilities-modifier type utilpower value -1 }
				{ #type heatmap-modifier map trafficHeatmap value 0.2 }
				{ #type employee-happiness-modifier multiplier 0.15 onlyunhappy #true }
				{ #type scenario-modifier tags [ "scenario-1"] when pass multiplier 0.2 }
				] }
			tags [ retail food retail-one retail-one-a food-one ]
			needutilities [ { type utilpower value 1 } ]
		}
	}
	{
		ident { template "retail-level-one-b" parent "retail-level-one-base" }
		sfx {
			emitter "AMB_Store_Electronics"
		}
		heatmap {
			produces [
				{ type noiseHeatmap value 0.6 }
			]
		}
		placement {
			reqs [
				{ #type prestige-requirement value 1 sathit -0.2 }
				{ #type dock-bay-requirement sathit -1 }
			]
		}
		sprite {
			layouts [ retail-level-one-b ]
		}
		workplace {
			workers 2
			workertemplates [ "npc-retail-retail.a-retail.day" ]
			workhours { from 8 to 18 }
		}
		unit {
			locpattern "#pattern-retail-cellphone"
			locdesc "retail.one.b.desc"
			loccat  "retail.one.b.cat"
			pays { value 250 mods [ 
				{ #type game-difficulty-modifier hardmultiplier 0.98 easymultiplier 1.2 }
				{ #type economy-modifier multiplier 40 } ] }
			satisfaction { value 0 mods [
				{ #type rent-deal-modifier }
				{ #type profit-percent-modifier multiplier 0.51 }
				{ #type utilities-modifier type utilpower value -1 }
				{ #type utilities-modifier type utilphone value -1 }
				{ #type heatmap-modifier map trafficHeatmap value 0.2 }
				{ #type employee-happiness-modifier multiplier 0.15 onlyunhappy #true }
				{ #type scenario-modifier tags [ "scenario-1"] when pass multiplier 0.2 }
				] }
			tags [ retail electronics retail-one retail-one-b electronics-one ]
			needutilities [ { type utilpower value 1 } { type utilphone value 1 } ]
		}
	}
	{
		ident { template "retail-level-one-c" parent "retail-level-one-base" }
		heatmap {
			produces [
				{ type noiseHeatmap value 0.6 }
			]
		}
		sprite {
			layouts [ retail-level-one-c ]
		}
		placement {
			reqs [
				{ #type prestige-requirement value 1 sathit -0.2 }
				{ #type dock-bay-requirement sathit -1 }
			]
		}
		workplace {
			workers 1
			workertemplates [ "npc-retail-retail.a-retail.day" ]
			workhours { from 8 to 18 }
		}
		unit {
			locpattern "#pattern-retail-books"
			locdesc "retail.one.c.desc"
			loccat  "retail.one.c.cat"
			pays { value 200 mods [ 
				{ #type game-difficulty-modifier hardmultiplier 1.03 easymultiplier 1.1 }
				{ #type economy-modifier multiplier 40 } ] }
			satisfaction { value 0 mods [
				{ #type rent-deal-modifier }
				{ #type profit-percent-modifier multiplier 0.51 }
				{ #type utilities-modifier type utilpower value -1 }
				{ #type heatmap-modifier map trafficHeatmap value 0.2 }
				{ #type employee-happiness-modifier multiplier 0.15 onlyunhappy #true }
				{ #type scenario-modifier tags [ "scenario-1"] when pass multiplier 0.2 }
				] }
			tags [ retail books retail-one retail-one-c ]
			needutilities [ { type utilpower value 1 } ]
		}
	}
	{
		ident { template "retail-level-one-d" parent "retail-level-one-base" }
		heatmap {
			produces [
				{ type noiseHeatmap value 0.6 }
			]
		}
		placement {
			reqs [
				{ #type prestige-requirement value 1 sathit -0.2 }
				{ #type dock-bay-requirement sathit -1 }
			] }
		sprite {
			layouts [ retail-level-one-d ]
		}
		workplace {
			workers 2
			workertemplates [ "npc-retail-retail.a-retail.day" ]
			workhours { from 8 to 18 }
		}
		unit {
			locpattern "#pattern-retail-drugstore"
			locdesc "retail.one.d.desc"
			loccat  "retail.one.d.cat"
			pays { value 250 mods [ 
				{ #type game-difficulty-modifier hardmultiplier 0.98 easymultiplier 1.2 }
				{ #type economy-modifier multiplier 40 } ] }
			satisfaction { value 0 mods [
				{ #type rent-deal-modifier }
				{ #type profit-percent-modifier multiplier 0.51 }
				{ #type utilities-modifier type utilpower value -1 }
				{ #type utilities-modifier type utilphone value -1 }
				{ #type employee-happiness-modifier multiplier 0.15 onlyunhappy #true }
				{ #type heatmap-modifier map trafficHeatmap value 0.2 }
				] }
			tags [ retail health retail-one retail-one-d ]
			needutilities [ { type utilpower value 1 } { type utilphone value 1 } ]
		}
	}
	{
		ident { template "retail-level-one-e-bottle" parent "retail-level-one-base" }
		heatmap {
			produces [
				{ type noiseHeatmap value 0.6 }
			]
		}
		sprite {
			layouts [ retail-level-one-e-bottle ]
		}
		placement {
			reqs [
				{ #type prestige-requirement value 1 sathit -0.2 }
				{ #type dock-bay-requirement sathit -1 }
			]
		}
		workplace {
			workers 1
			workertemplates [ "npc-retail-retail.a-retail.day" ]
			workhours { from 8 to 18 }
		}
		unit {
			locpattern "#pattern-retail-bottles"
			locdesc "retail.one.e-bottle.desc"
			loccat  "retail.one.e-bottle.cat"
			pays { value 200 mods [ 
				{ #type game-difficulty-modifier hardmultiplier 1.03 easymultiplier 1.1 }
				{ #type economy-modifier multiplier 40 } ] }
			satisfaction { value 0 mods [
				{ #type rent-deal-modifier }
				{ #type profit-percent-modifier multiplier 0.2 }
				{ #type utilities-modifier type utilpower value -1 }
				{ #type heatmap-modifier map trafficHeatmap value 0.2 }
				{ #type employee-happiness-modifier multiplier 0.15 onlyunhappy #true }
				{ #type scenario-modifier tags [ "scenario-1"] when pass multiplier 0.2 }
				] }
			tags [ retail drink retail-one retail-one-e-bottle ]
			needutilities [ { type utilpower value 1 } ]
		}
	}
	{
		ident { template "retail-level-one-e-flowers" parent "retail-level-one-base" }
		heatmap {
			produces [
				{ type noiseHeatmap value 0.6 }
			]
		}
		sprite {
			layouts [ retail-level-one-e-flowers ]
		}
		placement {
			reqs [
				{ #type prestige-requirement value 1 sathit -0.2 }
				{ #type dock-bay-requirement sathit -1 }
			]
		}
		workplace {
			workers 1
			workertemplates [ "npc-retail-retail.a-retail.day" ]
			workhours { from 8 to 18 }
		}
		unit {
			locpattern "#pattern-retail-flowers"
			locdesc "retail.one.e-flowers.desc"
			loccat  "retail.one.e-flowers.cat"
			pays { value 200 mods [ 
				{ #type game-difficulty-modifier hardmultiplier 1.03 easymultiplier 1.1 }
				{ #type economy-modifier multiplier 40 } ] }
			satisfaction { value 0 mods [
				{ #type rent-deal-modifier }
				{ #type profit-percent-modifier multiplier 0.51 }
				{ #type utilities-modifier type utilpower value -1 }
				{ #type heatmap-modifier map trafficHeatmap value 0.2 }
				{ #type employee-happiness-modifier multiplier 0.15 onlyunhappy #true }
				{ #type scenario-modifier tags [ "scenario-1"] when pass multiplier 0.2 }
				] }
			tags [ retail decor retail-one retail-one-e-flowers homegoods-one ]
			needutilities [ { type utilpower value 1 } ]
		}
	}
	;; level two
	{
		ident { template "retail-level-two-a" parent "retail-level-two-base" }
		placement {
			reqs [
				{ #type prestige-requirement value 5 sathit -0.2 }
				{ #type dock-bay-requirement sathit -1 }
			]
		}
		sprite {
			layouts [ retail-level-two-a ]
		}
		workplace {
			workers 1
			workertemplates [ "npc-retail-retail.a-retail.day2" ]
			workhours { from 10 to 20 }
		}
		unit {
			locpattern "#pattern-retail-clothes"
			locdesc	"retail.two.a.desc"
			loccat  "retail.two.a.cat"
			tags [ retail clothing retail-two retail-two-a clothing-two ]
			pays { value 300 mods [ 
				{ #type game-difficulty-modifier hardmultiplier 0.68 easymultiplier 1.15 }
				{ #type economy-modifier multiplier 80 } ] }
			satisfaction { value 0 mods [
					{ #type rent-deal-modifier }
					{ #type profit-percent-modifier multiplier 0.51 }
					{ #type utilities-modifier type utilpower value -1 }
					{ #type heatmap-modifier map trafficHeatmap value 0.2 }
					{ #type heatmap-modifier map smellHeatmap value -0.3 }
					{ #type employee-happiness-modifier multiplier 0.15 onlyunhappy #true }
					{ #type scenario-modifier tags [ "scenario-1"] when pass multiplier 0.2 }
					; add escalator heat map mod
				] }
			needutilities [ { type utilpower value 2 } ]
		}
	}
	{
		ident { template "retail-level-two-b" parent "retail-level-two-base" }
		sfx {
			emitter "AMB_Store_Electronics"
		}
		sprite {
			layouts [ retail-level-two-b ]
		}
		placement {
			reqs [
				{ #type dock-bay-requirement sathit -1 }
				{ #type prestige-requirement value 5 sathit -0.2 }
			]
		}
		workplace {
			workers 2
			workertemplates [ "npc-retail-retail.a-retail.day2" ]
			workhours { from 10 to 20 }
		}
		unit {
			locpattern "#pattern-retail-electronics"
			locdesc "retail.two.b.desc"
			loccat  "retail.two.b.cat"
			tags [ retail electronics retail-two retail-two-b electronics-two ]
			pays { value 475 mods [ 
				{ #type game-difficulty-modifier hardmultiplier 0.65 easymultiplier 1.15 }
				{ #type economy-modifier multiplier 80 } ] }
			satisfaction { value 0 mods [
					{ #type rent-deal-modifier }
					{ #type profit-percent-modifier multiplier 0.51 }
					{ #type utilities-modifier type utilpower value -1 }
					{ #type utilities-modifier type utilphone value -1 }
					{ #type heatmap-modifier map trafficHeatmap value 0.2 }
					{ #type heatmap-modifier map smellHeatmap value -0.3 }
					{ #type employee-happiness-modifier multiplier 0.15 onlyunhappy #true }
					{ #type scenario-modifier tags [ "scenario-1"] when pass multiplier 0.2 }
					; add escalator heat map mod
				] }
			needutilities [ { type utilpower value 2 } { type utilphone value 1 } ]
		}
	}
	{
		ident { template "retail-level-two-c-shoes" parent "retail-level-two-base" }
		sprite {
			layouts [ retail-level-two-c-shoes ]
		}
		placement {
			reqs [
				{ #type prestige-requirement value 5 sathit -0.2 }
				{ #type dock-bay-requirement sathit -1 }
			]
		}
		workplace {
			workers 1
			workertemplates [ "npc-retail-retail.a-retail.day2" ]
			workhours { from 10 to 20 }
		}
		unit {
			locpattern "#pattern-retail-shoes"
			locdesc "retail.two.c.shoes.desc"
			loccat  "retail.two.c.shoes.cat"
			tags [ retail shoes retail-two retail-two-c-shoes fashion-two ]
			pays { value 300 mods [ 
				{ #type game-difficulty-modifier hardmultiplier 0.68 easymultiplier 1.15 }
				{ #type economy-modifier multiplier 80 } ] }
			satisfaction { value 0 mods [
					{ #type rent-deal-modifier }
					{ #type profit-percent-modifier multiplier 0.51 }
					{ #type utilities-modifier type utilpower value -1 }
					{ #type heatmap-modifier map trafficHeatmap value 0.2 }
					{ #type heatmap-modifier map smellHeatmap value -0.3 }
					{ #type employee-happiness-modifier multiplier 0.15 onlyunhappy #true }
					{ #type scenario-modifier tags [ "scenario-1"] when pass multiplier 0.2 }
					; add escalator heat map mod
				] }
			needutilities [ { type utilpower value 2 } ]
		}
	}
	{
		ident { template "retail-level-two-c-purses" parent "retail-level-two-base" }
		sprite {
			layouts [ retail-level-two-c-purses ]
		}
		placement {
			reqs [
				{ #type prestige-requirement value 5 sathit -0.2 }
				{ #type dock-bay-requirement sathit -1 }
			]
		}
		workplace {
			workers 1
			workertemplates [ "npc-retail-retail.a-retail.day2" ]
			workhours { from 10 to 20 }
		}
		unit {
			locpattern "#pattern-retail-purses" 
			locdesc "retail.two.c.bags.desc"
			loccat  "retail.two.c.bags.cat"
			tags [ retail handbags retail-two retail-two-c-purses fashion-two ]
			pays { value 350 mods [ 
				{ #type game-difficulty-modifier hardmultiplier 0.7 easymultiplier 1.15 }
				{ #type economy-modifier multiplier 80 } ] }
			satisfaction { value 0 mods [
					{ #type rent-deal-modifier }
					{ #type profit-percent-modifier multiplier 0.51 }
					{ #type utilities-modifier type utilpower value -1 }
					{ #type heatmap-modifier map trafficHeatmap value 0.2 }
					{ #type heatmap-modifier map smellHeatmap value -0.3 }
					{ #type employee-happiness-modifier multiplier 0.15 onlyunhappy #true }
					{ #type scenario-modifier tags [ "scenario-1"] when pass multiplier 0.2 }
					; add escalator heat map mod
				] }
			needutilities [ { type utilpower value 2 } ]
		}
	}
	{
		ident { template "retail-level-two-d" parent "retail-level-two-base" }
		sfx {
			emitter "AMB_Store_Electronics"
		}
		sprite {
			layouts [ retail-level-two-d ]
		}
		placement {
			reqs [
				{ #type prestige-requirement value 5 sathit -0.2 }
				{ #type dock-bay-requirement sathit -1 }
			]
		}
		workplace {
			workers 1
			workertemplates [ "npc-retail-retail.a-retail.day2" ]
			workhours { from 10 to 20 }
		}
		unit {
			locpattern "#pattern-retail-appliances"
			locdesc "retail.two.d.desc"
			loccat  "retail.two.d.cat"
			tags [ retail housewares retail-two retail-two-d homegoods-two ]
			pays { value 300 mods [ 
				{ #type game-difficulty-modifier hardmultiplier 0.68 easymultiplier 1.15 }
				{ #type economy-modifier multiplier 80 } ] }
			satisfaction { value 0 mods [
					{ #type rent-deal-modifier }
					{ #type profit-percent-modifier multiplier 0.51 }
					{ #type utilities-modifier type utilpower value -1 }
					{ #type heatmap-modifier map trafficHeatmap value 0.2 }
					{ #type heatmap-modifier map smellHeatmap value -0.3 }
					{ #type employee-happiness-modifier multiplier 0.15 onlyunhappy #true }
					{ #type scenario-modifier tags [ "scenario-1"] when pass multiplier 0.2 }
					; add escalator heat map mod
				] }
			needutilities [ { type utilpower value 2 } ]
		}
	}

	;;;;;;;;;;;;;;;;;;;;;;;;;; level three
	{
		ident { template "retail-level-three-a" parent "retail-level-three-base" }
		sprite {
			layouts [ retail-level-three-a ]
		}
		placement {
			reqs [
				{ #type prestige-requirement value 10 sathit -0.5 }
				{ #type dock-bay-requirement sathit -1 }
			]
		}
		workplace {
			workers 2
			workertemplates [ "npc-retail-retail.a-retail.day2" ]
			workhours { from 10 to 20 }
		}
		unit {
			locpattern "#pattern-retail-departmentstore"
			locdesc "retail.three.a.desc"
			loccat "retail.three.a.cat"
			tags [ retail departmentstore retail-three fashion-three clothing-three ]
			pays { value 750 mods [ 
				{ #type game-difficulty-modifier hardmultiplier 0.58 easymultiplier 1.15 }
				{ #type economy-modifier multiplier 100 } ] }
			satisfaction { value 0 mods [
					{ #type rent-deal-modifier }
					{ #type profit-percent-modifier multiplier 0.51 }
					{ #type utilities-modifier type utilpower value -1 }
					{ #type utilities-modifier type utilphone value -1 }
					{ #type heatmap-modifier map aestheticsHeatmap value 0.2 }
					{ #type heatmap-modifier map trafficHeatmap value 0.2 }
					{ #type heatmap-modifier map smellHeatmap value -0.2 }
					{ #type employee-happiness-modifier multiplier 0.15 onlyunhappy #true }
					{ #type scenario-modifier tags [ "scenario-1"] when pass multiplier 0.2 }
				] }
			needutilities [ { type utilphone value 1 } { type utilpower value 3 } ]
		}
	}
	{
		ident { template "retail-level-three-b" parent "retail-level-three-base" }
		sfx {
			emitter "AMB_Store_Electronics"
		}
		sprite {
			layouts [ retail-level-three-b ]
		}
		placement {
			reqs [
				{ #type prestige-requirement value 10 sathit -0.25 }
				{ #type dock-bay-requirement sathit 1 }
			]
		}
		workplace {
			workers 2
			workertemplates [ "npc-retail-retail.a-retail.day2" ]
			workhours { from 10 to 20 }
		}
		unit {
			locpattern "#pattern-retail-housewares"
			locdesc "retail.three.b.desc"
			loccat "retail.three.b.cat"
			tags [ retail housewares retail-three homegoods-three ]
			pays { value 750 mods [ 
				{ #type game-difficulty-modifier hardmultiplier 0.55 easymultiplier 1.15 }
				{ #type economy-modifier multiplier 100 } ] }
			satisfaction { value 0 mods [
					{ #type rent-deal-modifier }
					{ #type profit-percent-modifier multiplier 0.51 }
					{ #type utilities-modifier type utilpower value -1 }
					{ #type utilities-modifier type utilphone value -1 }
					{ #type heatmap-modifier map aestheticsHeatmap value 0.2 }
					{ #type heatmap-modifier map trafficHeatmap value 0.2 }
					{ #type heatmap-modifier map smellHeatmap value -0.2 }
					{ #type employee-happiness-modifier multiplier 0.15 onlyunhappy #true }
					{ #type scenario-modifier tags [ "scenario-1"] when pass multiplier 0.2 }
				] }
			needutilities [ { type utilphone value 1 } { type utilpower value 3 } ]
		}
	}
	{
		ident { template "retail-level-three-c" parent "retail-level-three-base" }
		sfx {
			emitter "AMB_Store_Electronics"
		}
		sprite {
			layouts [ retail-level-three-c ]
		}
		placement {
			reqs [
				{ #type prestige-requirement value 10 sathit -0.25 }
				{ #type dock-bay-requirement sathit -1 }
			]
		}
		workplace {
			workers 2
			workertemplates [ "npc-retail-retail.a-retail.day2" ]
			workhours { from 10 to 20 }
		}
		unit {
			locpattern "#pattern-retail-bigbox"
			locdesc "retail.three.c.desc"
			loccat "retail.three.c.cat"
			tags [ retail electronics retail-three electronics-three ]
			pays { value 750 mods [ 
				{ #type game-difficulty-modifier hardmultiplier 0.58 easymultiplier 1.15 }
				{ #type economy-modifier multiplier 100 } ] }
			satisfaction { value 0 mods [
					{ #type rent-deal-modifier }
					{ #type profit-percent-modifier multiplier 0.51 }
					{ #type utilities-modifier type utilpower value -1 }
					{ #type utilities-modifier type utilphone value -1 }
					{ #type heatmap-modifier map aestheticsHeatmap value 0.2 }
					{ #type heatmap-modifier map trafficHeatmap value 0.2 }
					{ #type heatmap-modifier map smellHeatmap value -0.2 }
					{ #type employee-happiness-modifier multiplier 0.15 onlyunhappy #true }
					{ #type scenario-modifier tags [ "scenario-1"] when pass multiplier 0.2 }
					;; visitors map modifier
				] }
			needutilities [ { type utilphone value 1 } { type utilpower value 3 } ]
		}
	}
	{
		ident { template "retail-level-three-d" parent "retail-level-three-base" }
		sprite {
			layouts [ retail-level-three-d ]
		}		
		placement {
			reqs [
				{ #type prestige-requirement value 10 sathit -0.25 }
				{ #type dock-bay-requirement sathit -1 }
			]
		}
		workplace {
			workers 3
			workertemplates [ "npc-retail-retail.a-retail.day2" "npc-retail-retail.b-retail.day2" "npc-retail-retail.b-retail.day2" ]
			workhours { from 10 to 20 }
		}
		unit {
			locpattern "#pattern-retail-grocery"
			locdesc "retail.three.d.desc"
			loccat "retail.three.d.cat"
			tags [ retail food retail-three food-three ]
			pays { value 750 mods [ 
				{ #type game-difficulty-modifier hardmultiplier 0.55 easymultiplier 1.15 }
				{ #type economy-modifier multiplier 100 } ] }
			satisfaction { value 0 mods [
					{ #type rent-deal-modifier }
					{ #type profit-percent-modifier multiplier 0.51 }
					{ #type utilities-modifier type utilpower value -1 }
					{ #type utilities-modifier type utilphone value -1 }
					{ #type heatmap-modifier map aestheticsHeatmap value 0.2 }
					{ #type heatmap-modifier map trafficHeatmap value 0.2 }
					{ #type heatmap-modifier map smellHeatmap value -0.2 }
					{ #type employee-happiness-modifier multiplier 0.15 onlyunhappy #true }
					{ #type scenario-modifier tags [ "scenario-1"] when pass multiplier 0.2 }
				] }
			needutilities [ { type utilphone value 1 } { type utilpower value 3 } ]
		}
	}

	;; level four retail

	{
		ident { template "retail-level-four-a" parent "retail-level-four-base" }
		placement {
			reqs [
				{ #type prestige-requirement value 14 sathit -0.6 }
				{ #type dock-bay-requirement sathit -1 }
			]
		}
		sprite {
			layouts [ retail-level-four-a ]
		}
		workplace {
			workers 2
			workertemplates [ "npc-retail-retail.a-retail.day.3" ]
			workhours { from 11 to 18 }
		}
		unit {
			locpattern "#pattern-retail-china"
			locdesc "retail.four.a.desc"
			loccat "retail.four.a.cat"
			tags [ retail retail-four-a retail-four boutique ]
			pays { value 750 mods [ 
				{ #type game-difficulty-modifier hardmultiplier 0.67 easymultiplier 1.15 }
				{ #type economy-modifier multiplier 100 } ] }
			satisfaction { value 0 mods [
					{ #type rent-deal-modifier }
					{ #type profit-percent-modifier multiplier 0.51 }
					{ #type utilities-modifier type utilpower value -1 }
					{ #type utilities-modifier type utilphone value -1 }
					{ #type heatmap-modifier map trafficHeatmap value 0.2 }
					{ #type heatmap-modifier map aestheticsHeatmap value 0.6 }
					{ #type heatmap-modifier map noiseHeatmap value -0.4 }
					{ #type heatmap-modifier map smellHeatmap value -0.4 }
					{ #type employee-happiness-modifier multiplier 0.15 onlyunhappy #true }
					{ #type scenario-modifier tags [ "scenario-1"] when pass multiplier 0.2 }
				] }
			needutilities [ { type utilphone value 1 } { type utilpower value 3 } ]
		}
	}
	{
		ident { template "retail-level-four-b" parent "retail-level-four-base" }
		placement {
			reqs [
				{ #type prestige-requirement value 14 sathit -0.6 }
				{ #type dock-bay-requirement sathit -1 }
			]
		}
		sprite {
			layouts [ retail-level-four-b ]
		}
		workplace {
			workers 2
			workertemplates [ "npc-retail-retail.a-retail.day.3" ]
			workhours { from 11 to 18 }
		}
		unit {
			locpattern "#pattern-retail-cosmetics"
			locdesc "retail.four.b.desc"
			loccat "retail.four.b.cat"
			tags [ retail retail-four-b retail-four boutique ]
			pays { value 750 mods [ 
				{ #type game-difficulty-modifier hardmultiplier 0.67 easymultiplier 1.15 }
				{ #type economy-modifier multiplier 100 } ] }
			satisfaction { value 0 mods [
					{ #type rent-deal-modifier }
					{ #type profit-percent-modifier multiplier 0.51 }
					{ #type utilities-modifier type utilpower value -1 }
					{ #type utilities-modifier type utilphone value -1 }
					{ #type heatmap-modifier map aestheticsHeatmap value 0.6 }
					{ #type heatmap-modifier map trafficHeatmap value 0.2 }
					{ #type heatmap-modifier map noiseHeatmap value -0.4 }
					{ #type heatmap-modifier map smellHeatmap value -0.4 }
					{ #type employee-happiness-modifier multiplier 0.15 onlyunhappy #true }
					{ #type scenario-modifier tags [ "scenario-1"] when pass multiplier 0.2 }
				] }
			needutilities [ { type utilphone value 1 } { type utilpower value 3 } ]
		}
	}
	{
		ident { template "retail-level-four-c" parent "retail-level-four-base" }
		placement {
			reqs [
				{ #type prestige-requirement value 14 sathit -0.6 }
				{ #type dock-bay-requirement sathit -1 }
			]
		}
		sprite {
			layouts [ retail-level-four-c ]
		}
		workplace {
			workers 2
			workertemplates [ "npc-retail-retail.a-retail.day.3" ]
			workhours { from 11 to 18 }
		}
		unit {
			locpattern "#pattern-retail-jewelry"
			locdesc "retail.four.c.desc"
			loccat "retail.four.c.cat"
			tags [ retail retail-four-c retail-four boutique ]
			pays { value 750 mods [ 
				{ #type game-difficulty-modifier hardmultiplier 0.67 easymultiplier 1.15 }
				{ #type economy-modifier multiplier 100 } ] }
			satisfaction { value 0 mods [
					{ #type rent-deal-modifier }
					{ #type profit-percent-modifier multiplier 0.51 }
					{ #type utilities-modifier type utilpower value -1 }
					{ #type utilities-modifier type utilphone value -1 }
					{ #type heatmap-modifier map aestheticsHeatmap value 0.6 }
					{ #type heatmap-modifier map trafficHeatmap value 0.2 }
					{ #type heatmap-modifier map noiseHeatmap value -0.4 }
					{ #type heatmap-modifier map smellHeatmap value -0.4 }
					{ #type employee-happiness-modifier multiplier 0.15 onlyunhappy #true }
					{ #type scenario-modifier tags [ "scenario-1"] when pass multiplier 0.2 }
				] }
			needutilities [ { type utilphone value 1 } { type utilpower value 3 } ]
		}
	}
	{
		ident { template "retail-level-four-d" parent "retail-level-four-base" }
		placement {
			reqs [
				{ #type prestige-requirement value 15 sathit -0.6 }
				{ #type dock-bay-requirement sathit -1 }
			]
		}
		sprite {
			layouts [ retail-level-four-d ]
		}
		workplace {
			workers 1
			workertemplates [ "npc-retail-retail.a-retail.day.3" ]
			workhours { from 11 to 18 }
		}
		unit {
			locpattern "#pattern-retail-art"
			locdesc "retail.four.d.desc"
			loccat "retail.four.c.cat"
			tags [ retail retail-four-d  retail-four boutique ]
			pays { value 750 mods [ 
				{ #type game-difficulty-modifier hardmultiplier 0.74 easymultiplier 1.15 }
				{ #type economy-modifier multiplier 100 } ] }
			satisfaction { value 0 mods [
					{ #type rent-deal-modifier }
					{ #type profit-percent-modifier multiplier 0.51 }
					{ #type utilities-modifier type utilpower value -1 }
					{ #type utilities-modifier type utilphone value -1 }
					{ #type heatmap-modifier map trafficHeatmap value 0.2 }
					{ #type heatmap-modifier map aestheticsHeatmap value 0.6 }
					{ #type heatmap-modifier map noiseHeatmap value -0.4 }
					{ #type heatmap-modifier map smellHeatmap value -0.4 }
					{ #type employee-happiness-modifier multiplier 0.15 onlyunhappy #true }
					{ #type scenario-modifier tags [ "scenario-1"] when pass multiplier 0.2 }
				] }
			needutilities [ { type utilphone value 1 } { type utilpower value 3 } ]
		}
	}
	{
		ident { template "retail-level-four-e" parent "retail-level-four-base" }
		placement {
			reqs [
				{ #type prestige-requirement value 15 sathit -0.6 }
				{ #type dock-bay-requirement sathit -1 }
			]
		}
		sprite {
			layouts [ retail-level-four-e ]
		}
		workplace {
			workers 1
			workertemplates [ "npc-retail-retail.a-retail.day.3" ]
			workhours { from 11 to 18 }
		}
		unit {
			locpattern "#pattern-retail-rarebooks"
			locdesc "retail.four.e.desc"
			loccat "retail.four.e.cat"
			tags [ retail retail-four-e retail-four boutique ]
			pays { value 750 mods [ 
				{ #type game-difficulty-modifier hardmultiplier 0.74 easymultiplier 1.15 }
				{ #type economy-modifier multiplier 100 } ] }
			satisfaction { value 0 mods [
					{ #type rent-deal-modifier }
					{ #type profit-percent-modifier multiplier 0.51 }
					{ #type utilities-modifier type utilpower value -1 }
					{ #type utilities-modifier type utilphone value -1 }
					{ #type heatmap-modifier map aestheticsHeatmap value 0.6 }
					{ #type heatmap-modifier map trafficHeatmap value 0.2 }
					{ #type heatmap-modifier map noiseHeatmap value -0.4 }
					{ #type heatmap-modifier map smellHeatmap value -0.4 }
					{ #type employee-happiness-modifier multiplier 0.15 onlyunhappy #true }
					{ #type scenario-modifier tags [ "scenario-1"] when pass multiplier 0.2 }
				] }
			needutilities [ { type utilphone value 1 } { type utilpower value 3 } ]
		}
	}
	{
		ident { template "retail-level-four-f" parent "retail-level-four-base" }
		placement {
			reqs [
				{ #type prestige-requirement value 14 sathit -0.6 }
				{ #type dock-bay-requirement sathit -1 }
			]
		}
		sprite {
			layouts [ retail-level-four-f ]
		}
		workplace {			
			workers 1
			workertemplates [ "npc-retail-retail.a-retail.day.3" ]
			workhours { from 11 to 18 }
		}
		unit {
			locpattern "#pattern-retail-wine"
			locdesc "retail.four.f.desc"
			loccat "retail.four.f.cat"
			tags [ retail retail-four-f retail-four boutique ]
			pays { value 750 mods [ 
				{ #type game-difficulty-modifier hardmultiplier 0.67 easymultiplier 1.15 }
				{ #type economy-modifier multiplier 100 } ] }
			satisfaction { value 0 mods [
					{ #type rent-deal-modifier }
					{ #type profit-percent-modifier multiplier 0.51 }
					{ #type utilities-modifier type utilpower value -1 }
					{ #type utilities-modifier type utilphone value -1 }
					{ #type heatmap-modifier map aestheticsHeatmap value 0.6 }
					{ #type heatmap-modifier map trafficHeatmap value 0.2 }
					{ #type heatmap-modifier map noiseHeatmap value -0.4 }
					{ #type heatmap-modifier map smellHeatmap value -0.4 }
					{ #type employee-happiness-modifier multiplier 0.15 onlyunhappy #true }
					{ #type scenario-modifier tags [ "scenario-1"] when pass multiplier 0.2 }
				] }
			needutilities [ { type utilphone value 1 } { type utilpower value 3 } ]
		}
	}

	;;;;;;;;;;;;;;;;;;;; restaurant base info

	{
		ident { template "restaurant-base" parent "workplace-base" }
		heatmap { }
		placement { }
		reservations { }
		selection {
			mode restaurant
		}
		service {
			servicetype restaurant
		}
		sfx {
			emitter "AMB_TexMex"
		}
		unit {
			moveout {
				threshold { value -0.5 }
				dailyprob { value 1 }
			}
		}
		tokens { }
	}

	{
		ident { template "restaurant-level-one-base" parent "restaurant-base" }
		sfx {
			emitter "AMB_Diner"
		}
		placement {
			size { x 4 y 1 }
		}
		service {
			linecapacity 2
			seatcapacity 8
			servicehours 0.2
			servicerevs {
				from 4 to 8
				mods [
					{ #type game-difficulty-modifier hardmultiplier 0.75 easymultiplier 1.25 }
					{ #type golden-age-modifier id goldenage-commercial-profit multiplier 1.5 }
					{ #type economy-modifier multiplier 2 rounding 1 }
					{ #type scenario-modifier tags [ "scenario-9" ] when pass multiplier 1.5 }
				]
			}
		}
		heatmap {
			produces [
				{ type noiseHeatmap value 0.6 }
				{ type smellHeatmap value 0.6 }
			]
		}
		unit {
			evict {
				basefee 50
				rentpercent 200
			}
			grimeenabled #true
			dailyagewear 0.005
			dailytrafficwear 0.025
			buildcost { value -125 mods [
				{ #type heatmap-modifier map floorHeatmap value -50 }
				{ #type golden-age-modifier id goldenage-commercial-feature multiplier 0.5 }
				] }
		}
	}
	{
		ident { template "restaurant-level-one-a" parent "restaurant-level-one-base" }
		sfx {
			emitter "AMB_Rest_General"
		}
		sprite {
			layouts [ restaurant-level-one-a ]
		}
		placement {
			reqs [
				{ #type prestige-requirement value 1 sathit -0.2 }
			]
		}
		workplace {
			workers 1
			workertemplates [ "npc-restaurant.a-rest.day" ]
			workhours { from 10 to 18 }
		}
		unit {
			pays { value 150 mods [ 
				{ #type game-difficulty-modifier hardmultiplier 0.67 easymultiplier 1.2 }
				{ #type economy-modifier multiplier 30 } ] }
			satisfaction { value 0 mods [
				{ #type rent-deal-modifier }
				{ #type profit-percent-modifier multiplier 0.51 }
				{ #type regulars-velocity-modifier multiplier 0.05 }
				{ #type utilities-modifier type utilpower value -1 }
				{ #type utilities-modifier type utilwater value -1 }
				{ #type heatmap-modifier map trafficHeatmap value 0.51 }
				{ #type employee-happiness-modifier multiplier 0.15 onlyunhappy #true }
				{ #type scenario-modifier tags [ "scenario-1"] when pass multiplier 0.2 }
				] }
			locpattern "#pattern-cafe-a"
			locdesc "rest.one.a.desc"
			loccat  "rest.one.a.cat"
			tags [ restaurant rest-type-lunch rest-type-coffee rest-foodcourt cafe restaurant-1a lunch-one ]
			needutilities [ { type utilpower value 1 } { type utilwater value 1 } ]
		}
		tokens {
			happybuzzprob 0.5
			upsetbuzzprob 0.5
		}
	}


	{
		ident { template "restaurant-level-one-b" parent "restaurant-level-one-base" }
		sprite {
			layouts [ restaurant-level-one-b ]
		}
		workplace {
			workers 2
			workhours { from 4.5 to 18 }
			workertemplates [ "npc-restaurant.a-rest.morning" "npc-restaurant.a-rest.day" ]
		}
		unit {
			pays { value 100 mods [ 
				{ #type game-difficulty-modifier hardmultiplier 0.79 easymultiplier 1.1 }
				{ #type economy-modifier multiplier 30 } 
				] }
			satisfaction { value 0 mods [
				{ #type rent-deal-modifier }
				{ #type profit-percent-modifier multiplier 0.4 }
				{ #type regulars-velocity-modifier multiplier 0.05 }
				{ #type utilities-modifier type utilpower value -1 }
				{ #type heatmap-modifier map trafficHeatmap value 0.51 }
				{ #type employee-happiness-modifier multiplier 0.15 onlyunhappy #true }
				{ #type scenario-modifier tags [ "scenario-1"] when pass multiplier 0.2 }
				] }
			locpattern "#pattern-foodcourt-1"
			locdesc "rest.one.b.desc"
			loccat  "rest.one.b.cat"
			tags [ restaurant rest-type-lunch rest-type-breakfast rest-foodcourt foodcourt restaurant-1b lunch-one breakfast-one ]
			needutilities [
				;; { type utilwater value 1 }  ;; tutorial
				{ type utilpower value 1 } ]
		}
	}
	{
		ident { template "restaurant-level-one-c" parent "restaurant-level-one-base" }
		sprite {
			layouts [ restaurant-level-one-c ]
		}
		workplace {
			workers 1
			workhours { from 10 to 18 }
			workertemplates [ "npc-restaurant.a-rest.day" ]
		}
		unit {
			locpattern "#pattern-foodcourt-2"
			locdesc "rest.one.c.desc"
			loccat  "rest.one.c.cat"
			pays { value 100 mods [ 
				{ #type game-difficulty-modifier hardmultiplier 0.75 easymultiplier 1.1 }
				{ #type economy-modifier multiplier 30 } ] }
			satisfaction { value 0 mods [
				{ #type rent-deal-modifier }
				{ #type profit-percent-modifier multiplier 0.51 }
				{ #type regulars-velocity-modifier multiplier 0.05 }
				{ #type utilities-modifier type utilpower value -1 }
				{ #type heatmap-modifier map trafficHeatmap value 0.51 }
				{ #type employee-happiness-modifier multiplier 0.15 onlyunhappy #true }
				{ #type scenario-modifier tags [ "scenario-1"] when pass multiplier 0.2 }
				] }
			tags [ restaurant rest-type-lunch rest-foodcourt foodcourt restaurant-1c lunch-one ]
			needutilities [ { type utilpower value 1 } ]
		}
	}
	{
		ident { template "restaurant-level-one-d" parent "restaurant-level-one-base" }
		sfx {
			emitter "AMB_Food_Italian"
		}
		sprite {
			layouts [ restaurant-level-one-d ]
		}
		workplace {
			workers 2
			workhours { from 4.5 to 18 }
			workertemplates [ "npc-restaurant.a-rest.morning" "npc-restaurant.a-rest.day" ]
		}
		service {
			linecapacity 5  ;; takeaway place
			seatcapacity 1
			servicehours 0.2
		}
		unit {
			locpattern "#pattern-cafe-b"
			locdesc "rest.one.d.desc"
			loccat  "rest.one.d.cat"
			pays { value 100 mods [ 
				{ #type game-difficulty-modifier hardmultiplier 0.75 easymultiplier 1.4 }
				{ #type economy-modifier multiplier 30 } ] }
			satisfaction { value 0 mods [
				{ #type rent-deal-modifier }
				{ #type profit-percent-modifier multiplier 0.51 }
				{ #type regulars-velocity-modifier multiplier 0.05 }
				{ #type utilities-modifier type utilpower value -1 }
				{ #type heatmap-modifier map trafficHeatmap value 0.51 }
				{ #type employee-happiness-modifier multiplier 0.15 onlyunhappy #true }
				{ #type scenario-modifier tags [ "scenario-1"] when pass multiplier 0.2 }
				] }
			tags [ restaurant rest-type-coffee rest-type-breakfast rest-foodcourt cafe restaurant-1d breakfast-one ]
			needutilities [ { type utilpower value 1 } ]

		}
	}
	{
		ident { template "restaurant-level-one-e" parent "restaurant-level-one-base" }
		sprite {
			layouts [ restaurant-level-one-e ]
		}
		workplace {
			workers 1
			workertemplates [ "npc-restaurant.a-rest.day" ]
			workhours { from 10 to 18 }
		}
		unit {
			pays { value 100 mods [ 
				{ #type game-difficulty-modifier hardmultiplier 0.75 easymultiplier 1.1 }
				{ #type economy-modifier multiplier 30 } ] }
			satisfaction { value 0 mods [
				{ #type rent-deal-modifier }
				{ #type profit-percent-modifier multiplier 0.2 }
				{ #type regulars-velocity-modifier multiplier 0.05 }
				{ #type utilities-modifier type utilpower value -1 }
				{ #type heatmap-modifier map trafficHeatmap value 0.51 }
				{ #type employee-happiness-modifier multiplier 0.15 onlyunhappy #true }
				{ #type scenario-modifier tags [ "scenario-1"] when pass multiplier 0.2 }
				] }
			locpattern "#pattern-foodcourt-3"
			locdesc "rest.one.e.desc"
			loccat  "rest.one.e.cat"
			tags [ restaurant rest-type-lunch rest-foodcourt foodcourt restaurant-1e lunch-one ]
			needutilities [ { type utilpower value 1 } ]
		}
	}


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; level two restaurants


	{
		ident { template "restaurant-level-two-base" parent "restaurant-base" }
		heatmap {
			produces [
				{ type noiseHeatmap value 0.8 }
				{ type smellHeatmap value 0.8 }
			]
		}
		service {
			servicerevs { from 5 to 9
					mods [
						{ #type game-difficulty-modifier hardmultiplier 0.8 easymultiplier 1.25 }
						{ #type economy-modifier multiplier 3 rounding 1 }
						{ #type golden-age-modifier id goldenage-commercial-profit multiplier 1.5 }
						{ #type scenario-modifier tags [ "scenario-9" ] when pass multiplier 1.5 }
				] }
			linecapacity 12
			seatcapacity 15
			servicehours 0.3
		}
		prestige {
			penaltymoveout -1
			penaltyeviction -1
		}
		placement {
			size { x 8 y 1 }
			reqs [
			]
		}
		sfx {
			emitter "AMB_Diner"
		}
		unit {
			evict {
				basefee 200
				rentpercent 300
			}
			trashproduced [
				{ item trash amount 1 probability 0.75 }
			]
			trashhour 22
			grimeenabled #true
			dailyagewear 0.005
			dailytrafficwear 0.025
			buildcost { value -400 mods [
				{ #type game-difficulty-modifier harddelta 50 easymultiplier 0.75 }
				{ #type heatmap-modifier map floorHeatmap value -50 }
				{ #type golden-age-modifier id goldenage-commercial-feature multiplier 0.5 }
				] }
		}
		tokens {
			happybuzzprob 0.5
			upsetbuzzprob 0.5
		}
	}
	{
		ident { template "restaurant-level-two-a" parent "restaurant-level-two-base" }
		placement {
			reqs [
				{ #type prestige-requirement value 3 sathit -0.2 }
			]
		}
		sprite {
			layouts [ restaurant-level-two-a ]
		}
		workplace {
			workers 3
			workertemplates [ "npc-restaurant.a-rest.day" "npc-restaurant.a-rest.day" "npc-restaurant.a-rest.evening" ]
			workhours { from 10 to 23 }
		}
		unit {
			pays { value 200 mods [ 
				{ #type game-difficulty-modifier hardmultiplier 0.8 easymultiplier 1.27 }	
				{ #type economy-modifier multiplier 60 } ] }
			satisfaction { value 0 mods [
				{ #type rent-deal-modifier }
				{ #type profit-percent-modifier multiplier 0.2 }
				{ #type regulars-velocity-modifier multiplier 0.05 }
				{ #type utilities-modifier type utilpower value -1 }
				{ #type utilities-modifier type utilwater value -1 }
				{ #type heatmap-modifier map trafficHeatmap value 0.51 }
				{ #type trash-delivery-modifier type trash value -0.5 }
				{ #type employee-happiness-modifier multiplier 0.15 onlyunhappy #true }
				{ #type scenario-modifier tags [ "scenario-1"] when pass multiplier 0.2 }
				] }
			locpattern "#pattern-fastfood"
			locdesc "rest.two.a.desc"
			loccat  "rest.two.a.cat"
			needutilities [ { type utilwater value 1 } { type utilpower value 1 } ]
			tags [ restaurant rest-two restaurant-2a rest-type-lunch rest-type-dinner fastfood lunch-two dinner-two ]
			trashhour 23.5
			visitors [ { template "npc-visitor-restaurant-one" probability 0.25 time { from 11.5 to 14 } hourlycount 2 }
					{ template "npc-visitor-restaurant-two" probability 0.25 time { from 16.5 to 19.5 } hourlycount 2 } ]
		}
	}
	{
		ident { template "restaurant-level-two-b" parent "restaurant-level-two-base" }
		placement {
			reqs [
				{ #type prestige-requirement value 3 sathit -0.2 }
			]
		}
		sprite {
			layouts [ restaurant-level-two-b ]
		}
		workplace {
			workers 2
			workhours { from 4.5 to 18 }
			workertemplates [ "npc-restaurant.a-rest.morning" "npc-restaurant.a-rest.day" ]
		}
		unit {
			pays { value 200 mods [ 
				{ #type game-difficulty-modifier hardmultiplier 0.8 easymultiplier 1.27 }	
				{ #type economy-modifier multiplier 60 } ] }
			satisfaction { value 0 mods [
				{ #type rent-deal-modifier }
				{ #type profit-percent-modifier multiplier 0.2 }
				{ #type regulars-velocity-modifier multiplier 0.05 }
				{ #type utilities-modifier type utilpower value -1 }
				{ #type utilities-modifier type utilwater value -1 }
				{ #type heatmap-modifier map trafficHeatmap value 0.51 }
				{ #type trash-delivery-modifier type trash value -0.5 }
				{ #type employee-happiness-modifier multiplier 0.15 onlyunhappy #true }
				{ #type scenario-modifier tags [ "scenario-1"] when pass multiplier 0.2 }
				] }
			locpattern "#pattern-sandwiches"
			locdesc "rest.two.b.desc"
			loccat  "rest.two.b.cat"
			tags [ restaurant rest-two rest-type-lunch rest-type-breakfast breakfast-two restaurant-2b sandwich lunch-two ]
			needutilities [ { type utilwater value 1 } { type utilpower value 1 } ]
			trashhour 18.5
			visitors [ { template "npc-visitor-restaurant-one" probability 0.25 time { from 7.5 to 9.5 } hourlycount 2 }
					{ template "npc-visitor-restaurant-one" probability 0.25 time { from 11.5 to 14 } hourlycount 2 } ]
		}
	}
	{
		ident { template "restaurant-level-two-c" parent "restaurant-level-two-base" }
		placement {
			reqs [
				{ #type prestige-requirement value 3 sathit -0.2 }
			]
		}
		sprite {
			layouts [ restaurant-level-two-c ]
		}
		workplace {
			workers 3
			workhours { from 10 to 18 }
			workertemplates [ "npc-restaurant.a-rest.day" ]
		}
		unit {
			locpattern "#pattern-hotbar"
			locdesc "rest.two.c.desc"
			loccat  "rest.two.c.cat"
			pays { value 175 mods [ 
				{ #type game-difficulty-modifier hardmultiplier 0.83 easymultiplier 1.28 }	
				{ #type economy-modifier multiplier 60 } ] }
			satisfaction { value 0 mods [
				{ #type rent-deal-modifier }
				{ #type profit-percent-modifier multiplier 0.2 }
				{ #type regulars-velocity-modifier multiplier 0.05 }
				{ #type utilities-modifier type utilpower value -1 }
				{ #type heatmap-modifier map trafficHeatmap value 0.51 }
				{ #type trash-delivery-modifier type trash value -0.5 }
				{ #type employee-happiness-modifier multiplier 0.15 onlyunhappy #true }
				{ #type scenario-modifier tags [ "scenario-1"] when pass multiplier 0.2 }
				] }
			tags [ restaurant rest-two rest-type-lunch restaurant-2c foodcourt lunch-two ]
			needutilities [ { type utilpower value 1 } ]
			trashhour 18.5
			visitors [ { template "npc-visitor-restaurant-one" probability 0.25 time { from 11.5 to 14 } hourlycount 2 } ]
		}
	}
	{
		ident { template "restaurant-level-two-d" parent "restaurant-level-two-base" }
		placement {
			reqs [
				{ #type prestige-requirement value 3 sathit -0.2 }
			]
		}
		sprite {
			layouts [ restaurant-level-two-d ]
		}
		workplace {
			workhours { from 4.5 to 18 }
			workers 2
			workertemplates [ "npc-restaurant.a-rest.morning" "npc-restaurant.a-rest.day" ]
		}
		unit {
			locpattern "#pattern-diner"
			locdesc "rest.two.d.desc"
			loccat  "rest.two.d.cat"
			pays { value 200 mods [ 
				{ #type game-difficulty-modifier hardmultiplier 0.75 easymultiplier 1.27 }
				{ #type economy-modifier multiplier 60 } ] }
			satisfaction { value 0 mods [
				{ #type rent-deal-modifier }
				{ #type profit-percent-modifier multiplier 0.2 }
				{ #type regulars-velocity-modifier multiplier 0.05 }
				{ #type utilities-modifier type utilpower value -1 }
				{ #type utilities-modifier type utilwater value -1 }
				{ #type heatmap-modifier map trafficHeatmap value 0.51 }
				{ #type trash-delivery-modifier type trash value -0.5 }
				{ #type employee-happiness-modifier multiplier 0.15 onlyunhappy #true }
				{ #type scenario-modifier tags [ "scenario-1"] when pass multiplier 0.2 }
				] }
			tags [ restaurant rest-two rest-type-lunch rest-type-breakfast rest-type-coffee restaurant-2d diner breakfast-two lunch-two ]
			needutilities [ { type utilpower value 1 } { type utilwater value 2 } ]
			trashhour 18.5
			visitors [ { template "npc-visitor-restaurant-one" probability 0.5 time { from 7.5 to 9.5 } hourlycount 2 }
					{ template "npc-visitor-restaurant-one" probability 0.5 time { from 11.5 to 14 } hourlycount 2 } ]
		}
	}
	{
		ident { template "restaurant-level-two-e" parent "restaurant-level-two-base" }
		sfx {
			emitter "AMB_Food_Italian"
		}
		placement {
			reqs [
				{ #type prestige-requirement value 3 sathit -0.2 }
			]
		}
		sprite {
			layouts [ restaurant-level-two-e ]
		}
		workplace {
			workhours { from 10 to 23 }
			workers 2
			workertemplates [ "npc-restaurant.a-rest.day" "npc-restaurant.a-rest.evening" ]
		}
		unit {
			locpattern "#pattern-pizza"
			locdesc "rest.two.e.desc"
			loccat  "rest.two.e.cat"
			pays { value 200 mods [ 
				{ #type game-difficulty-modifier hardmultiplier 0.8 easymultiplier 1.27 }
				{ #type economy-modifier multiplier 60 } ] }
			satisfaction { value 0 mods [
				{ #type rent-deal-modifier }
				{ #type profit-percent-modifier multiplier 0.2 }
				{ #type regulars-velocity-modifier multiplier 0.05 }
				{ #type utilities-modifier type utilpower value -1 }
				{ #type utilities-modifier type utilwater value -1 }
				{ #type heatmap-modifier map trafficHeatmap value 0.51 }
				{ #type trash-delivery-modifier type trash value -0.5 }
				{ #type employee-happiness-modifier multiplier 0.15 onlyunhappy #true }
				{ #type scenario-modifier tags [ "scenario-1"] when pass multiplier 0.2 }
				] }
			tags [ restaurant rest-two rest-type-lunch rest-type-dinner restaurant-2e pizza lunch-two dinner-two ]
			needutilities [ { type utilpower value 1 } { type utilwater value 1 } ]
			trashhour 23.5
			visitors [ { template "npc-visitor-restaurant-one" probability 0.5 time { from 11.5 to 14 } hourlycount 2 }
					{ template "npc-visitor-restaurant-two" probability 0.5 time { from 16.5 to 19.5 } hourlycount 2 } ]
		}
	}
;;;;;;;;;;;;;;;; level three restaurants

{
		ident { template "restaurant-level-three-base" parent "restaurant-base" }
		heatmap {
			produces [
				{ type noiseHeatmap value 1 }
				{ type smellHeatmap value 0.8 }
			]
		}
		prestige {
			penaltymoveout -2
			penaltyeviction -2
		}
		placement {
			size { x 16 y 1 }
			reqs [
				
			]
		}
		service {
			servicerevs { from 8 to 14
				mods [
					{ #type game-difficulty-modifier hardmultiplier 0.8 easymultiplier 1.25 }
					{ #type economy-modifier multiplier 4 rounding 1 }
					{ #type golden-age-modifier id goldenage-commercial-profit multiplier 1.5 }
					{ #type scenario-modifier tags [ "scenario-9" ] when pass multiplier 1.5 }
				] }
			linecapacity 10
			seatcapacity 40
			servicehours 1
		}
		unit {
			evict {
				basefee 400
				rentpercent 300

			}
			trashproduced [
				{ item trash amount 1 probability 1 }
			]
			trashhour 22
			grimeenabled #true
			dailyagewear 0.005
			dailytrafficwear 0.025
			buildcost { value -1000 mods [
				{ #type game-difficulty-modifier harddelta 300 }
				{ #type heatmap-modifier map floorHeatmap value -50 }
				{ #type golden-age-modifier id goldenage-commercial-feature multiplier 0.5 }
				] }
		}
		tokens {
			happybuzzprob 0.5
			upsetbuzzprob 0.5
		}
	}
	{
		ident { template "restaurant-level-three-a" parent "restaurant-level-three-base" }
		sfx {
			emitter "AMB_SportsBar"
		}
		placement {
			reqs [
				{ #type prestige-requirement value 7 sathit -0.2 }
			]
		}
		workplace {
			workers 3
			workertemplates [ "npc-restaurant.b-rest.host-evening" "npc-restaurant.a-rest.evening" "npc-restaurant.a-rest.evening" ]
			workhours { from 15 to 23 }
		}
		sprite {
			layouts [ restaurant-level-three-a ]
		}
		unit {
			locpattern "#pattern-sportsbar"
			locdesc "rest.three.a.desc"
			loccat "rest.three.a.cat"
			pays { value 500 mods [ 
				{ #type game-difficulty-modifier hardmultiplier 0.85 easymultiplier 1.2 }
				{ #type economy-modifier multiplier 160 } ] }
			satisfaction { value 0 mods [
					{ #type rent-deal-modifier }
					{ #type profit-percent-modifier multiplier 0.51 }
					{ #type regulars-velocity-modifier multiplier 0.75 }
					{ #type utilities-modifier type utilpower value -1 }
					{ #type utilities-modifier type utilcable value -0.2 }
					{ #type utilities-modifier type utilwater value -1 }
					{ #type utilities-modifier type utilgas value -1 }
					{ #type heatmap-modifier map trafficHeatmap value 0.5 }
					{ #type heatmap-modifier map elevatorHeatmap value 0.25 } ;; maybe becomes an escalator heatmap?
					{ #type trash-delivery-modifier type trash value -0.5 }
					{ #type employee-happiness-modifier multiplier 0.15 onlyunhappy #true }
					{ #type scenario-modifier tags [ "scenario-1"] when pass multiplier 0.2 }
				] }
			tags [ restaurant rest-three rest-type-dinner restaurant-3a sportsbar bar-three rest-type-bar dinner-three ]
			needutilities [ { type utilpower value 1 } { type utilwater value 2 } { type utilgas value 2 } { type utilcable value 1 } ]
			trashhour 23.5
			visitors [ { template "npc-visitor-restaurant-two" probability 0.5 time { from 16.5 to 19.5 } hourlycount 4 }
					{ template "npc-visitor-restaurant-two" probability 0.5 time { from 20 to 23 } hourlycount 4 } ]
		}
	}
	{
		ident { template "restaurant-level-three-b-italian" parent "restaurant-level-three-base" }
		sfx {
			emitter "AMB_Food_Italian"
		}
		placement {
			reqs [
				{ #type prestige-requirement value 7 sathit -0.2 }
			]
		}
		workplace {
			workers 3
			workertemplates [ "npc-restaurant.b-rest.host-evening" "npc-restaurant.a-rest.evening" "npc-restaurant.a-rest.evening" ]
			workhours { from 15 to 23 }
		}
		sprite {
			layouts [ restaurant-level-three-b-italian ]
		}
		unit {
			locpattern "#pattern-rest-italian"
			locdesc "rest.three.b-italian.desc"
			loccat "rest.three.b-italian.cat"
			buildcost { value -1000 mods [
				{ #type game-difficulty-modifier harddelta 200 }
				{ #type heatmap-modifier map floorHeatmap value -50 }
				{ #type golden-age-modifier id goldenage-commercial-feature multiplier 0.5 }
				] }
			pays { value 500 mods [ 
				{ #type game-difficulty-modifier hardmultiplier 0.84 easymultiplier 0.8 }
				{ #type economy-modifier multiplier 160 } ] }
			satisfaction { value 0 mods [
					{ #type rent-deal-modifier }
					{ #type profit-percent-modifier multiplier 0.51 }
					{ #type regulars-velocity-modifier multiplier 0.5 }
					{ #type utilities-modifier type utilpower value -1 }
					{ #type utilities-modifier type utilwater value -1 }
					{ #type utilities-modifier type utilgas value -1 }
					{ #type heatmap-modifier map trafficHeatmap value 0.5 }
					{ #type heatmap-modifier map elevatorHeatmap value 0.25 }
					{ #type trash-delivery-modifier type trash value -0.5 }
					{ #type employee-happiness-modifier multiplier 0.15 onlyunhappy #true }
					{ #type scenario-modifier tags [ "scenario-1"] when pass multiplier 0.2 }
				] }
			tags [ restaurant rest-three rest-type-dinner restaurant-3b italian bar-three dinner-three ]
			needutilities [ { type utilpower value 1 } { type utilwater value 2 } { type utilgas value 2 } ]
			trashhour 23.5
			visitors [ { template "npc-visitor-restaurant-two" probability 0.5 time { from 16.5 to 19.5 } hourlycount 4 }
					{ template "npc-visitor-restaurant-two" probability 0.5 time { from 20 to 23 } hourlycount 4 } ]
		}
	}
	{
		ident { template "restaurant-level-three-b-mexican" parent "restaurant-level-three-b-italian" }
		sfx {
			emitter "AMB_TexMex"
		}
		sprite {
			layouts [ restaurant-level-three-b-mexican ]
		}
		unit {
			locpattern "#pattern-rest-mexican"
			locdesc "rest.three.b-mexican.desc"
			loccat "rest.three.b-mexican.cat"
			tags [ restaurant rest-three rest-type-dinner restaurant-3b mexican bar-three dinner-three ]
		}
	}
	{
		ident { template "restaurant-level-three-c-family" parent "restaurant-level-three-base" }
		sfx {
			emitter "AMB_Rest_General"
		}
		placement {
			reqs [
				{ #type prestige-requirement value 7 sathit -0.2 }
			]
		}
		workplace {
			workers 2
			workhours { from 10 to 18 }
			workertemplates [ "npc-restaurant.a-rest.day" "npc-restaurant.a-rest.day" ]
		}
		sprite {
			layouts [ restaurant-level-three-c-family ]
		}
		unit {
			locpattern "#pattern-rest-family"
			locdesc "rest.three.c-family.desc"
			loccat "rest.three.c-family.cat"
			pays { value 500 mods [ 
				{ #type game-difficulty-modifier hardmultiplier 0.74 easymultiplier 1.25 }
				{ #type economy-modifier multiplier 160 } ] }
			satisfaction { value 0 mods [
					{ #type rent-deal-modifier }
					{ #type profit-percent-modifier multiplier 0.51 }
					{ #type regulars-velocity-modifier multiplier 0.5 }
					{ #type utilities-modifier type utilpower value -1 }
					{ #type utilities-modifier type utilwater value -1 }
					{ #type utilities-modifier type utilgas value -1 }
					{ #type trash-delivery-modifier type trash value -0.5 }
					{ #type employee-happiness-modifier multiplier 0.15 onlyunhappy #true }
					{ #type scenario-modifier tags [ "scenario-1"] when pass multiplier 0.2 }
				] }
			tags [ restaurant rest-three rest-type-dinner rest-type-lunch restaurant-3c family lunch-three dinner-three ]
			needutilities [ { type utilpower value 1 } { type utilwater value 2 } { type utilgas value 2 } ]
			trashhour 18.5
			visitors [ { template "npc-visitor-restaurant-one" probability 0.5 time { from 11.5 to 14 } hourlycount 4 }
					{ template "npc-visitor-restaurant-two" probability 0.5 time { from 16.5 to 19.5 } hourlycount 4 } ]
		}
	}
	{
		ident { template "restaurant-level-three-c-brunch" parent "restaurant-level-three-base" }
		sfx {
			emitter "AMB_Rest_General"
		}
		placement {
			reqs [
				{ #type prestige-requirement value 7 sathit -0.2 }
			]
		}
		workplace {
			workers 3
			workhours { from 6 to 14 }
			workertemplates [ "npc-restaurant.a-rest.brunch" ]
		}
		sprite {
			layouts [ restaurant-level-three-c-brunch ]
		}
		unit {
			locpattern "#pattern-diner"
			locdesc "rest.three.c-brunch.desc"
			loccat "rest.three.c-brunch.cat"
			tags [ restaurant rest-three rest-type-breakfast rest-type-lunch restaurant-3c brunch breakfast-three lunch-three ]
			pays { value 500 mods [ 
				{ #type game-difficulty-modifier hardmultiplier 0.74 easymultiplier 1.25 }
				{ #type economy-modifier multiplier 160 } ] }
			satisfaction { value 0 mods [
					{ #type rent-deal-modifier }
					{ #type profit-percent-modifier multiplier 0.51 }
					{ #type regulars-velocity-modifier multiplier 0.5 }
					{ #type utilities-modifier type utilpower value -1 }
					{ #type utilities-modifier type utilwater value -1 }
					{ #type utilities-modifier type utilgas value -1 }
					{ #type trash-delivery-modifier type trash value -0.5 }
					{ #type employee-happiness-modifier multiplier 0.15 onlyunhappy #true }
					{ #type scenario-modifier tags [ "scenario-1"] when pass multiplier 0.2 }
				] }
			needutilities [ { type utilpower value 1 } { type utilwater value 2 } { type utilgas value 2 } ]
			trashhour 14.5
			visitors [ { template "npc-visitor-restaurant-one" probability 0.5 time { from 7.5 to 9.5 } hourlycount 4 }
					{ template "npc-visitor-restaurant-one" probability 0.5 time { from 11.5 to 14 } hourlycount 4 } ]
		}
	}
	{
		ident { template "restaurant-level-four-base" parent "restaurant-base" }
		heatmap {
			produces [
				{ type noiseHeatmap value 1 }
				{ type smellHeatmap value 0.8 }
			]
		}
		service {
			linecapacity 5
			seatcapacity 25
			servicehours 1.5
			servicerevs { from 22 to 32
				mods [
					{ #type game-difficulty-modifier hardmultiplier 0.47 easymultiplier 1.5 }
					{ #type economy-modifier multiplier 4 rounding 1 }
					{ #type golden-age-modifier id goldenage-commercial-profit multiplier 1.5 }
					{ #type scenario-modifier tags [ "scenario-9" ] when pass multiplier 1.5 }
				] }
		}
		prestige {
			penaltymoveout -2
			penaltyeviction -1
		}
		placement {
			size { x 14 y 1 }
			reqs [
				
			]
		}
		unit {
			evict {
				basefee 400
				rentpercent 300

			}
			trashproduced [
				{ item trash amount 2 probability 1 }
				{ item recycling amount 2 probability 1 }
			]
			trashhour 22
			grimeenabled #true
			dailyagewear 0.005
			dailytrafficwear 0.025
			buildcost { value -2500 mods [
				{ #type game-difficulty-modifier harddelta 1200 }
				{ #type heatmap-modifier map floorHeatmap value -50 }
				{ #type golden-age-modifier id goldenage-commercial-feature multiplier 0.5 }
				] }
		}
		tokens {
			happybuzzprob 1
			upsetbuzzprob 1
		}
	}
	{
		ident { template "restaurant-level-four-a" parent "restaurant-level-four-base" }
		sfx {
			emitter "AMB_Food_Japanese"
		}
		placement {
			reqs [
				{ #type prestige-requirement value 13 sathit -0.2 }
				{ #type score-requirement name score-retail-large minscore 3 sathit -0.3 }
			]
		}
		sprite {
			layouts [ restaurant-level-four-a ]
		}
		workplace {
			workers 6
			workertemplates [ "npc-restaurant.chef.evening" "npc-restaurant.chef.day" "npc-restaurant.chef.evening" "npc-restaurant.a-rest.evening" "npc-restaurant.a-rest.day" "npc-restaurant.b-rest.host-evening" ]
			workhours { from 10 to 23 }
		}
		unit {
			locpattern "#pattern-rest-chinese"
			locdesc "rest.four.a.desc"
			loccat	"rest.four.a.cat"
			tags [ restaurant rest-four rest-type-lunch rest-type-dinner gourmet lunch-four dinner-four chinese ]
			pays { value 750 mods [ 
				{ #type game-difficulty-modifier hardmultiplier 0.44 easymultiplier 1.3 }
				{ #type economy-modifier multiplier 160 }
				{ #type heatmap-modifier map floorHeatmap value -100 }
				{ #type heatmap-modifier map aestheticsHeatmap value 100 }
			 ] }
			satisfaction { value 0 mods [
					{ #type rent-deal-modifier }
					{ #type profit-percent-modifier multiplier 0.51 }
					{ #type regulars-velocity-modifier multiplier 0.5 }
					{ #type utilities-modifier type utilpower value -1 }
					{ #type utilities-modifier type utilwater value -1 }
					{ #type utilities-modifier type utilgas value -1 }
					{ #type trash-delivery-modifier type trash value -0.5 }
					{ #type trash-delivery-modifier type recycling value -0.5 }
					{ #type heatmap-modifier map aestheticsHeatmap value 0.2 }
					{ #type employee-happiness-modifier multiplier 0.15 onlyunhappy #true }
					{ #type scenario-modifier tags [ "scenario-1"] when pass multiplier 0.2 }
				] }
			visitors [ { template "npc-visitor-restaurant-one" probability 1 time { from 11.5 to 14 } hourlycount 6 }
					{ template "npc-visitor-restaurant-two" probability 1 time { from 18.5 to 22 } hourlycount 6 } ]
			needutilities [
				{ type utilpower value 2 } { type utilgas value 4 } { type utilwater value 4 }
			]
			trashhour 23
		}
	}
	{
		ident { template "restaurant-level-four-b" parent "restaurant-level-four-base" }
		sfx {
			emitter "AMB_FineDining"
		}
		placement {
			reqs [
				{ #type prestige-requirement value 13 sathit -0.2 }
				{ #type score-requirement name score-retail-large minscore 3 sathit -0.3 }
			]
		}
		sprite {
			layouts [ restaurant-level-four-b ]
		}
		workplace {
			workers 6
			workertemplates [ "npc-restaurant.chef.evening" "npc-restaurant.chef.evening" "npc-restaurant.chef.evening" "npc-restaurant.b-rest.host-evening" "npc-restaurant.a-rest.evening" "npc-restaurant.a-rest.evening" ]
			workhours { from 15 to 23 }
		}
		unit {
			locpattern	"#pattern-rest-indian"
			locdesc 	"rest.four.b.desc"
			"loccat"	"rest.four.b.cat"
			tags [ restaurant rest-four gourmet indian rest-type-dinner rest-type-bar bar-four dinner-four ]
			pays { value 750 mods [ 
				{ #type game-difficulty-modifier hardmultiplier 0.44 easymultiplier 1.3 }
				{ #type economy-modifier multiplier 160 }
				{ #type heatmap-modifier map floorHeatmap value 100 }
				{ #type heatmap-modifier map aestheticsHeatmap value 100 }
			 ] }
			 satisfaction { value 0 mods [
					{ #type rent-deal-modifier }
					{ #type profit-percent-modifier multiplier 0.51 }
					{ #type regulars-velocity-modifier multiplier 0.5 }
					{ #type utilities-modifier type utilpower value -1 }
					{ #type utilities-modifier type utilwater value -1 }
					{ #type utilities-modifier type utilgas value -1 }
					{ #type trash-delivery-modifier type trash value -0.5 }
					{ #type trash-delivery-modifier type recycling value -0.5 }
					{ #type heatmap-modifier map aestheticsHeatmap value 0.2 }
					{ #type employee-happiness-modifier multiplier 0.15 onlyunhappy #true }
					{ #type scenario-modifier tags [ "scenario-1"] when pass multiplier 0.2 }
				] }
			visitors [ { template "npc-visitor-restaurant-two" probability 1 time { from 16.5 to 19 } hourlycount 6 }
					{ template "npc-visitor-restaurant-two" probability 1 time { from 18.5 to 22 } hourlycount 6 } ]
			needutilities [
				{ type utilpower value 2 } { type utilgas value 4 } { type utilwater value 4 }
			]
			trashhour 23
		}
	}
	{
		ident { template "restaurant-level-four-c" parent "restaurant-level-four-base" }
		sfx {
			emitter "AMB_FineDining"
		}
		placement {
			reqs [
				{ #type prestige-requirement value 13 sathit -0.2 }
				{ #type score-requirement name score-retail-large minscore 3 sathit -0.3 }
			]
		}
		sprite {
			layouts [ restaurant-level-four-c ]
		}
		workplace {
			workers 4
			workertemplates [ "npc-restaurant.a-rest.brunch" "npc-restaurant.chef.day" "npc-restaurant.chef.morning" "npc-restaurant.a-rest.day" ]
			workhours { from 6 to 18 }
		}
		unit {
			locpattern "#pattern-rest-seafood"
			locdesc	"rest.four.c.desc"
			loccat	"rest.four.c.cat"
			tags [ restaurant rest-four gourmet seafood rest-type-lunch rest-type-breakfast breakfast-four lunch-four dinner-four ]
			pays { value 750 mods [ 
				{ #type game-difficulty-modifier hardmultiplier 0.44 easymultiplier 1.3 }
				{ #type economy-modifier multiplier 160 }
				{ #type heatmap-modifier map floorHeatmap value -100 }
				{ #type heatmap-modifier map aestheticsHeatmap value 100 }
			 ] }
			satisfaction { value 0 mods [
					{ #type rent-deal-modifier }
					{ #type profit-percent-modifier multiplier 0.51 }
					{ #type regulars-velocity-modifier multiplier 0.5 }
					{ #type utilities-modifier type utilpower value -1 }
					{ #type utilities-modifier type utilwater value -1 }
					{ #type utilities-modifier type utilgas value -1 }
					{ #type trash-delivery-modifier type trash value -0.5 }
					{ #type trash-delivery-modifier type recycling value -0.5 }
					{ #type heatmap-modifier map aestheticsHeatmap value 0.2 }
					{ #type employee-happiness-modifier multiplier 0.15 onlyunhappy #true }
					{ #type scenario-modifier tags [ "scenario-1"] when pass multiplier 0.2 }
				] }
			visitors [ { template "npc-visitor-restaurant-one" probability 1 time { from 8.5 to 10.5 } hourlycount 6 }
					{ template "npc-visitor-restaurant-one" probability 1 time { from 11.5 to 14 } hourlycount 6 } ]
			needutilities [
				{ type utilpower value 2 } { type utilgas value 4 } { type utilwater value 4 }
			]
			trashhour 18
		}
	}
	{
		ident { template "restaurant-level-four-d" parent "restaurant-level-four-base" }
		sfx {
			emitter "AMB_Food_Japanese"
		}
		placement {
			reqs [
				{ #type prestige-requirement value 13 sathit -0.2 }
				{ #type score-requirement name score-retail-large minscore 3 sathit -0.3 }
			]
		}
		sprite {
			layouts [ restaurant-level-four-d ]
		}
		workplace {
			workers 6
			workertemplates [ "npc-restaurant.b-rest.host-evening" "npc-restaurant.a-rest.evening" "npc-restaurant.b-rest.host-evening" "npc-restaurant.chef.evening" "npc-restaurant.chef.evening" "npc-restaurant.chef.evening" ]
			workhours { from 15 to 23 }
		}
		unit {
			locpattern "#pattern-rest-thai"
			locdesc "rest.four.d.desc"
			loccat "rest.four.d.cat"
			tags [ restaurant rest-four gourmet thai dinner-four bar-four rest-type-dinner rest-type-bar ]
			pays { value 750 mods [ 
				{ #type game-difficulty-modifier hardmultiplier 0.44 easymultiplier 1.3 }
				{ #type economy-modifier multiplier 160 }
				{ #type heatmap-modifier map floorHeatmap value 100 }
				{ #type heatmap-modifier map aestheticsHeatmap value 100 }
			 ] }
			satisfaction { value 0 mods [
					{ #type rent-deal-modifier }
					{ #type profit-percent-modifier multiplier 0.51 }
					{ #type regulars-velocity-modifier multiplier 0.5 }
					{ #type utilities-modifier type utilpower value -1 }
					{ #type utilities-modifier type utilwater value -1 }
					{ #type utilities-modifier type utilgas value -1 }
					{ #type trash-delivery-modifier type trash value -0.5 }
					{ #type trash-delivery-modifier type recycling value -0.5 }
					{ #type heatmap-modifier map aestheticsHeatmap value 0.2 }
					{ #type employee-happiness-modifier multiplier 0.15 onlyunhappy #true }
					{ #type scenario-modifier tags [ "scenario-1"] when pass multiplier 0.2 }
				] }
			visitors [ { template "npc-visitor-restaurant-two" probability 1 time { from 16.5 to 19 } hourlycount 6 }
					{ template "npc-visitor-restaurant-two" probability 1 time { from 18.5 to 22 } hourlycount 6 } ]
			needutilities [
				{ type utilpower value 2 } { type utilgas value 4 } { type utilwater value 4 }
			]
			trashhour 23
		}
	}
	{
		ident { template "restaurant-level-four-e" parent "restaurant-level-four-base" }
		sfx {
			emitter "AMB_Food_Japanese"
		}
		placement {
			reqs [
				{ #type prestige-requirement value 14 sathit -0.2 }
                { #type score-requirement name score-restaurant-gourmet minscore 1 }
			]
		}
		workplace {
			workers 6
			workertemplates [ "npc-restaurant.b-rest.host-evening" "npc-restaurant.chef.evening" "npc-restaurant.chef.celebrity" "npc-restaurant.chef.evening" "npc-restaurant.a-rest.evening" "npc-restaurant.a-rest.evening" ]
			workhours { from 15 to 23 }
		}
		sprite {
			layouts [ restaurant-level-four-e ]
		}
		unit {
			locpattern "#pattern-rest-japanese"
			locdesc "rest.four.e.desc"
			loccat "rest.four.e.cat"
			tags [ restaurant rest-four exclusive rest-type-dinner dinner-four japanese gourmet ]
			pays { value 750 mods [ 
				{ #type game-difficulty-modifier hardmultiplier 0.54 easymultiplier 1.3 }
				{ #type economy-modifier multiplier 160 }
				{ #type heatmap-modifier map floorHeatmap value 100 }
				{ #type heatmap-modifier map aestheticsHeatmap value 100 }
			 ] }
			satisfaction { value 0 mods [
					{ #type rent-deal-modifier }
					{ #type profit-percent-modifier multiplier 0.51 }
					{ #type regulars-velocity-modifier multiplier 0.5 }
					{ #type utilities-modifier type utilpower value -1 }
					{ #type utilities-modifier type utilwater value -1 }
					{ #type utilities-modifier type utilgas value -1 }
					{ #type trash-delivery-modifier type trash value -0.5 }
					{ #type trash-delivery-modifier type recycling value -0.5 }
					{ #type heatmap-modifier map aestheticsHeatmap value 0.2 }
					{ #type employee-happiness-modifier multiplier 0.15 onlyunhappy #true }
					{ #type scenario-modifier tags [ "scenario-1"] when pass multiplier 0.2 }
				] }
			visitors [ { template "npc-visitor-restaurant-two" probability 1 time { from 18.5 to 22 } hourlycount 6 } ]
			needutilities [
				{ type utilpower value 2 } { type utilgas value 4 } { type utilwater value 4 }
			]
			trashhour 15
		}
	}
	{
		ident { template "restaurant-level-four-f" parent "restaurant-level-four-base" }
		sfx {
			emitter "AMB_FineDining"
		}
		placement {
			reqs [
				{ #type prestige-requirement value 14 sathit -0.2 }
                { #type score-requirement name score-restaurant-gourmet minscore 1 }
			]
		}
		sprite {
			layouts [ restaurant-level-four-f ]
		}
		workplace {
			workers 4
			workertemplates [ "npc-restaurant.chef.evening" "npc-restaurant.b-rest.host-evening" "npc-restaurant.chef.celebrity" "npc-restaurant.b-rest.host-evening" ]
			workhours { from 15 to 23 }
		}
		unit {
			locpattern "#pattern-rest-french"
			locdesc "rest.four.f.desc"
			loccat	"rest.four.f.cat"
			tags [ restaurant rest-four exclusive dinner-four rest-type-dinner french gourmet ]
			pays { value 750 mods [ 
				{ #type game-difficulty-modifier hardmultiplier 0.54 easymultiplier 1.3 }
				{ #type economy-modifier multiplier 160 }
				{ #type heatmap-modifier map floorHeatmap value 100 }
				{ #type heatmap-modifier map aestheticsHeatmap value 100 }
			 ] }
			satisfaction { value 0 mods [
					{ #type rent-deal-modifier }
					{ #type profit-percent-modifier multiplier 0.51 }
					{ #type regulars-velocity-modifier multiplier 0.5 }
					{ #type utilities-modifier type utilpower value -1 }
					{ #type utilities-modifier type utilwater value -1 }
					{ #type utilities-modifier type utilgas value -1 }
					{ #type trash-delivery-modifier type trash value -0.5 }
					{ #type trash-delivery-modifier type recycling value -0.5 }
					{ #type heatmap-modifier map aestheticsHeatmap value 0.2 }
					{ #type employee-happiness-modifier multiplier 0.15 onlyunhappy #true }
					{ #type scenario-modifier tags [ "scenario-1"] when pass multiplier 0.2 }
				] }
			visitors [ { template "npc-visitor-restaurant-two" probability 1 time { from 18.5 to 22 } hourlycount 6 } ]
			needutilities [
				{ type utilpower value 2 } { type utilgas value 4 } { type utilwater value 4 }
			]
			trashhour 15
		}
	}



	;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; offices


	{
		ident { template "office-base" parent "workplace-base" }
		heatmap { }
		office { }
		placement {
			onremove evict
		}
		selection {
			mode office
		}
		sfx {
			emitter "AMB_Office"
		}
		unit {
			moveout {
				threshold { value -0.5 mods [ { #type game-difficulty-modifier easydelta -0.1 harddelta 0.1 } ] }
				dailyprob { value 1 }
			}
			evict {
				basefee 50
				rentpercent 200
			}
		}
		tokens { }
	}

	;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; level one offices


	{
		ident { template "office-level-one-base" parent "office-base" }
		placement {
			size { x 4 y 1 }
		}
		unit {
			grimeenabled #true
			dailyagewear 0.005
			dailytrafficwear 0.05
		}
	}

	{
		ident { template "office-level-one-a" parent "office-level-one-base" }
		sfx {
			emitter "AMB_Office"
		}
		sprite {
			layouts [ office-level-one-a ]
		}
		workplace {
			workers 1
			workertemplates [ "npc-office-office.a-office.1" ]
			workhours { from 8 to 16.5 }
		}
		unit {
			locpattern "#pattern-insurance"
			locdesc "office.one.a.desc"
			loccat  "office.one.a.cat"
			buildcost { value -100 mods [
				{ #type heatmap-modifier map floorHeatmap value -50 }
				{ #type golden-age-modifier id goldenage-offices-promoted multiplier 0.5 }
				] }
			pays { value 100 mods [ 
				{ #type game-difficulty-modifier hardmultiplier 0.75 easymultiplier 1.5 }
				{ #type economy-modifier multiplier 20 }
			] }
			satisfaction { value 0 mods [
				{ #type rent-deal-modifier }
				{ #type utilities-modifier type utilpower value -1 }
				{ #type employee-happiness-modifier multiplier 0.75 onlyunhappy #true }
				{ #type golden-age-modifier id goldenage-offices-satisfaction delta 0.2 }
			] }
			tags [ office insurance insurance-one ]
			favrestaurants [ rest-foodcourt ]
			needutilities [ { type utilpower value 1 } ]
			needservices [
				{ tasktype servicecopy probability 0.25 businesshoursonly #true workhours 0.2 timeouthours 20 timeouteffect -0.2 }
			]
		}
	}
	{
		ident { template "office-level-one-b" parent "office-level-one-base" }
		sprite {
			layouts [ office-level-one-b ]
		}
		placement {
			reqs [
			]
		}
		workplace {
			workertemplates [ "npc-office-office.a-office.1" ]
			workers 1
			workhours { from 8 to 16.5 }
		}
		unit {
			locpattern "#pattern-tax"
			locdesc "office.one.b.desc"
			loccat  "office.one.b.cat"
			buildcost { value -100 mods [
				{ #type heatmap-modifier map floorHeatmap value -50 }
				{ #type golden-age-modifier id goldenage-offices-promoted multiplier 0.5 }
				] }
			pays { value 125 mods [ 
				{ #type game-difficulty-modifier hardmultiplier 0.68 easymultiplier 1.52 }
				{ #type economy-modifier multiplier 20 } 
			] }
			satisfaction { value 0 mods [
				{ #type rent-deal-modifier } 
				{ #type utilities-modifier type utilpower value -1 }
				{ #type employee-happiness-modifier multiplier 0.75 onlyunhappy #true }
				{ #type golden-age-modifier id goldenage-offices-satisfaction delta 0.2 }
			] }
			tags [ office accounting accounting-one financial-one ]
			favrestaurants [ rest-foodcourt ]
			needutilities [ { type utilpower value 1 } ]
			needservices [
				{ tasktype servicecourier probability 0.25 businesshoursonly #true workhours 0.2 timeouthours 20 timeouteffect -0.2 }
				{ tasktype servicecopy probability 0.25 businesshoursonly #true workhours 0.2 timeouthours 20 timeouteffect -0.2 }
			]
		}
	}
	{
		ident { template "office-level-one-c" parent "office-level-one-base" }
		sprite {
			layouts [ office-level-one-c ]
		}
		placement {
			reqs [
				{ #type score-requirement name score-restaurant-foodcourt minscore 1.5 sathit -0.3 }
			]
		}
		workplace {
			workertemplates [ "npc-office-office.b-office.3" ]
			workers 1
			workhours { from 9 to 17 }
		}
		unit {
			locpattern "#pattern-cpa"
			locdesc "office.one.c.desc"
			loccat  "office.one.c.cat"
			buildcost { value -125 mods [
				{ #type heatmap-modifier map floorHeatmap value -50 }
				{ #type golden-age-modifier id goldenage-offices-promoted multiplier 0.5 }
				] }
			pays { value 150 mods [ 
				{ #type game-difficulty-modifier hardmultiplier 0.87 easymultiplier 1.27 }
				{ #type economy-modifier multiplier 30 }
			] }
			satisfaction { value 0 mods [
				{ #type rent-deal-modifier } 
				{ #type utilities-modifier type utilpower value -1 }
				{ #type utilities-modifier type utilphone value -1 }
				{ #type employee-happiness-modifier multiplier 0.75 onlyunhappy #true }
				{ #type golden-age-modifier id goldenage-offices-satisfaction delta 0.2 }
			] }
			tags [ office accounting accounting-one financial-one ]
			favrestaurants [ rest-foodcourt ]
			needservices [
				{ tasktype servicecourier probability 0.25 businesshoursonly #true workhours 0.2 timeouthours 20 timeouteffect -0.2 }
				{ tasktype servicecopy probability 0.25 businesshoursonly #true workhours 0.2 timeouthours 20 timeouteffect -0.2 }
			]
			needutilities [ { type utilpower value 1 } { type utilphone value 1 } ]
			visitors [ { template "npc-visitor-one" probability 0.25 time { from 11 to 16 } hourlycount 1 } ]
		}
		tokens {
			tokengrants [ { type favors value 1 hourofday 17 probability 0.5 } ]
		}
	}
	{
		ident { template "office-level-one-d" parent "office-level-one-base" }
		sprite {
			layouts [ office-level-one-e ]
		}
		placement {
			reqs [ { #type score-requirement name score-restaurant-cafe minscore 1 sathit -0.2 }
					{ #type prestige-requirement value 1 sathit -0.2 } ]
		}
		workplace {
			workertemplates [ "npc-office-office.a-office.4" ]
			workers 1
			workhours { from 9 to 17 }
		}
		unit {
			locpattern "#pattern-design"
			locdesc "office.one.d.desc"
			loccat  "office.one.d.cat"
			buildcost { value -150 mods [
				{ #type heatmap-modifier map floorHeatmap value -50 }
				{ #type golden-age-modifier id goldenage-offices-promoted multiplier 0.5 }
				] }
			pays { value 175 mods [ 
				{ #type game-difficulty-modifier hardmultiplier 0.83 easymultiplier 1.32 }
				{ #type economy-modifier multiplier 30 }
			] }
			satisfaction { value 0 mods [
				{ #type rent-deal-modifier } 
				{ #type utilities-modifier type utilpower value -1 }
				{ #type utilities-modifier type utilphone value -1 }
				{ #type employee-happiness-modifier multiplier 0.75 onlyunhappy #true }
				{ #type golden-age-modifier id goldenage-offices-satisfaction delta 0.2 }
			] }
			tags [ office design design-one creative-one ]
			favrestaurants [ rest-foodcourt ]
			needutilities [ { type utilphone value 1 } { type utilpower value 1 } ]
			needservices [
				{ tasktype servicecourier probability 0.25 businesshoursonly #true workhours 0.2 timeouthours 20 timeouteffect -0.2 }
				{ tasktype servicesupplies probability 0.25 businesshoursonly #true workhours 0.2 timeouthours 20 timeouteffect -0.2 }
			]
			visitors [ { template "npc-visitor-one" probability 0.25 time { from 11 to 16 } hourlycount 1 } ]
		}
		tokens {
			tokengrants [ { type buzz value 1 hourofday 16 probability 0.5 } ]
		}
	}
	{
		ident { template "office-level-one-e" parent "office-level-one-base" }
		placement {
			reqs [
				{ #type score-requirement name score-restaurant-small minscore 1 sathit -0.2 }
			]
		}
		sprite {
			layouts [ office-level-one-d ]
		}
		workplace {
			workertemplates [ "npc-office-office.a-office.3" ]
			workers 1
			workhours { from 9 to 17 }
		}
		unit {
			locpattern "#pattern-lawyer-small"
			locdesc "office.one.e.desc"
			loccat  "office.one.e.cat"
			buildcost { value -100 mods [
				{ #type heatmap-modifier map floorHeatmap value -50 }
				{ #type golden-age-modifier id goldenage-offices-promoted multiplier 0.5 }
				] }
			pays { value 125 mods [ 
				{ #type game-difficulty-modifier hardmultiplier 0.64 easymultiplier 1.44 }
				{ #type economy-modifier multiplier 20 }
			] }
			satisfaction { value 0 mods [
				{ #type rent-deal-modifier } 
				{ #type utilities-modifier type utilpower value -1 }
				{ #type employee-happiness-modifier multiplier 0.75 onlyunhappy #true }
				{ #type golden-age-modifier id goldenage-offices-satisfaction delta 0.2 }
			] }
			tags [ office legal legal-one ]
			favrestaurants [ rest-foodcourt ]
			needutilities [ { type utilpower value 1 } ]
			needservices [
				{ tasktype servicecourier probability 0.25 businesshoursonly #true workhours 0.2 timeouthours 20 timeouteffect -0.2 }
				{ tasktype servicecopy probability 0.25 businesshoursonly #true workhours 0.2 timeouthours 20 timeouteffect -0.2 }
			]
		}
	}
	{
		ident { template "office-level-one-f" parent "office-level-one-e" }
		placement {
			reqs [
				{ #type score-requirement name score-restaurant-small minscore 1 sathit -0.2 }				
			]
		}
		sprite {
			layouts [ office-level-one-d-alt ]
		}
		unit {
			locpattern "#pattern-private-eye"
			locdesc "office.one.f.desc"
			loccat "office.one.f.cat"
			buildcost { value -125 mods [
				{ #type heatmap-modifier map floorHeatmap value -50 }
				{ #type golden-age-modifier id goldenage-offices-promoted multiplier 0.5 }
				] }
			pays { value 175 mods [ 
				{ #type game-difficulty-modifier hardmultiplier 0.83 easymultiplier 1.05 }
				{ #type economy-modifier multiplier 20 }
			] }
			satisfaction { value 0 mods [
				{ #type rent-deal-modifier } 
				{ #type utilities-modifier type utilpower value -1 }
				{ #type utilities-modifier type utilphone value -1 }
				{ #type employee-happiness-modifier multiplier 0.75 onlyunhappy #true }
				{ #type golden-age-modifier id goldenage-offices-satisfaction delta 0.2 }
			] }
			needutilities [ { type utilpower value 1 } { type utilphone value 1 } ]
		}
	}
	{
		ident { template "office-level-one-g" parent "office-level-one-d" }
		sprite {
			layouts [ office-level-one-e-alt ]
		}
		unit {
			locpattern "#pattern-agent"
			locdesc 	"office.one.g.desc"
			loccat		"office.one.g.cat"
			pays { value 175 mods [ 
				{ #type game-difficulty-modifier hardmultiplier 0.83 easymultiplier 1.29 }
				{ #type economy-modifier multiplier 30 }
			] }
			needservices [
				{ tasktype servicecourier probability 0.25 businesshoursonly #true workhours 0.2 timeouthours 20 timeouteffect -0.2 }
				{ tasktype servicewater probability 0.25 businesshoursonly #true workhours 0.2 timeouthours 20 timeouteffect -0.2 }
			]
		}
	}

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; level two offices

	{
		ident { template "office-level-two-base" parent "office-base" }
		sfx {
			emitter "AMB_Office"
		}
		placement {
			buildhours 2
			size { x 10 y 1 }
		}
		unit {
			grimeenabled #true
			dailyagewear 0.005
			dailytrafficwear 0.05
		}
	}
	{
		ident { template "office-level-two-a" parent "office-level-two-base" }
		heatmap {  }
		office {  }
		placement {
			reqs [
				{ #type prestige-requirement value 2 sathit -0.2 }
				{ #type score-requirement name score-restaurant-medium minscore 2 sathit -0.2 }
                { #type score-requirement name score-restaurant-cafe minscore 1.5 sathit -0.2 }
                { #type score-requirement name score-retail-small minscore 3 sathit -0.3 }
			]
		}
		sprite {
			layouts [ office-level-two-a ]
		}
		workplace {
			workers 2
			workertemplates [ "npc-office-office.b-office.admin.1" "npc-office-office.a-office.5" ]
			workhours { from 7.5 to 19 }
		}
		unit {
			locpattern "#pattern-lawyer"
			locdesc "office.two.a.desc"
			loccat  "office.two.a.cat"
			buildcost { value -300 mods [
				{ #type heatmap-modifier map floorHeatmap value -50 }
				{ #type golden-age-modifier id goldenage-offices-promoted multiplier 0.5 }
				] }
			pays { value 300 mods [
				{ #type game-difficulty-modifier hardmultiplier 1.17 easymultiplier 1.25 }
				{ #type heatmap-modifier map floorHeatmap value 100 }
				{ #type economy-modifier multiplier 50 }
			] }
			satisfaction { value 0 mods [
				{ #type rent-deal-modifier } 
				{ #type utilities-modifier type utilpower value -1 }
				{ #type utilities-modifier type utilphone value -1 }
				{ #type heatmap-modifier map floorHeatmap value 0.05 }
				{ #type heatmap-modifier map noiseHeatmap value -0.3 }
				{ #type employee-happiness-modifier multiplier 0.75 onlyunhappy #true }
				{ #type golden-age-modifier id goldenage-offices-satisfaction delta 0.2 }
			] }
			tags [ office legal legal-two ]
			favrestaurants [ fastfood ]
			needservices [
				{ tasktype servicejanitor probability 0.5 businesshoursonly #true workhours 1 timeouthours 20 timeouteffect -0.3 }
				{ tasktype servicecopy probability 0.5 businesshoursonly #true workhours 0.2 timeouthours 20 timeouteffect -0.3 }
				{ tasktype servicestorage probability 0.25 businesshoursonly #true workhours 0.2 timeouthours 20 timeouteffect -0.3 }
				{ tasktype servicecatering probability 0.25 businesshoursonly #true workhours 0.2 timeouthours 20 timeouteffect -0.3 }
			]
			needutilities [ { type utilpower value 2 } { type utilphone value 2 } ]
			visitors [ { template "npc-visitor-three" probability 0.25 time { from 16 to 19 } hourlycount 1 } ]
		}
	}
	{
		ident { template "office-level-two-b-dentist" parent "office-level-two-base" }
		sfx {
			emitter "AMB_Dentist"
		}
		placement {
			reqs [
				{ #type prestige-requirement value 2 sathit -0.2 }
				{ #type entity-count-requirement type atleast count 1 template retail-level-one-d sathit -0.2 }
				{ #type score-requirement name score-restaurant-breakfast minscore 1.5 sathit -0.2 }
                { #type score-requirement name score-retail-small minscore 2 sathit -0.2 }
			]
		}
		sprite {
			layouts [ office-level-two-b-dentist ]
		}
		workplace {
			workers 2
			workertemplates [ "npc-office-office.b-office.admin.1" "npc-office-office.b-office.doctor.1" ]
			workhours { from 7.5 to 18 }
		}
		unit {
			locpattern "#pattern-dentist"
			locdesc "office.two.b.dentist.desc"
			loccat  "office.two.b.dentist.cat"
			buildcost { value -300 mods [
				{ #type game-difficulty-modifier harddelta 50 }
				{ #type heatmap-modifier map floorHeatmap value -50 }
				{ #type golden-age-modifier id goldenage-offices-promoted multiplier 0.5 }
				] }
			pays { value 400 mods [ 
				{ #type game-difficulty-modifier hardmultiplier 0.9 easymultiplier 1.19 }
				{ #type heatmap-modifier map floorHeatmap value -75 } 
				{ #type economy-modifier multiplier 70 }
				]
			}
			satisfaction { value 0 mods [
				{ #type rent-deal-modifier }
				{ #type utilities-modifier type utilpower value -1 }
				{ #type utilities-modifier type utilphone value -1 }
				{ #type utilities-modifier type utilwater value -1 }
				{ #type heatmap-modifier map floorHeatmap value -0.2 } 
				{ #type employee-happiness-modifier multiplier 0.75 onlyunhappy #true }
				{ #type golden-age-modifier id goldenage-offices-satisfaction delta 0.2 }
				] }
			tags [ office medical medical-two ]
			favrestaurants [ diner ]
			needservices [
				{ tasktype servicecourier probability 0.5 businesshoursonly #true workhours 0.2 timeouthours 20 timeouteffect -0.3 }
				{ tasktype servicewater probability 0.5 businesshoursonly #true workhours 0.2 timeouthours 20 timeouteffect -0.3 }
				{ tasktype servicejanitor probability 0.5 businesshoursonly #true workhours 0.5 timeouthours 20 timeouteffect -0.3 }
				{ tasktype servicestorage probability 0.25 businesshoursonly #true workhours 0.2 timeouthours 20 timeouteffect -0.3 }
			]
			needutilities [ {type utilpower value 2 } { type utilphone value 2 } { type utilwater value 1 } ]
			visitors [ { template "npc-visitor-three" probability 0.5 time { from 9 to 14 } hourlycount 1 } ]
		}
		tokens {
			tokengrants [ { type favors value 1 hourofday 18 probability 1 } ]
		}
	}
	{
		ident { template "office-level-two-b-doctor" parent "office-level-two-b-dentist" }
		sfx {
			emitter "AMB_Office_Doctor"
		}
		sprite {
			layouts [ office-level-two-b-doctor ]
		}
		unit {
			locpattern "#pattern-doctor"
			locdesc	"office.two.b.doctor.desc"
			loccat  "office.two.b.doctor.cat"
		}
	}
	{
		ident { template "office-level-two-c" parent "office-level-two-base" }
		placement {
			reqs [
				{ #type prestige-requirement value 3 sathit -0.2 sathit -0.2 }
				{ #type score-requirement name score-restaurant-medium minscore 2 sathit -0.2 }
				{ #type score-requirement name score-restaurant-dinner minscore 1.5 sathit -0.2 }
                { #type score-requirement name score-retail-small minscore 2 sathit -0.2 }
			]
		}
		sprite {
			layouts [ office-level-two-c ]
		}
		workplace {
			workers 3
			workertemplates [ "npc-office-office.b-office.admin.1" "npc-office-office.b-office.3" "npc-office-office.a-office.4"  ]
			workhours { from 7.5 to 17 }
		}
		unit {
			locpattern "#pattern-finance"
			locdesc "office.two.c.desc"
			loccat "office.two.c.cat"
			buildcost { value -325 mods [
				{ #type heatmap-modifier map floorHeatmap value -50 }
				{ #type golden-age-modifier id goldenage-offices-promoted multiplier 0.5 }
				] }
			pays { value 425 mods [ 
				{ #type game-difficulty-modifier hardmultiplier 0.88 easymultiplier 1.23 }
				{ #type heatmap-modifier map floorHeatmap value 100 }
				{ #type economy-modifier multiplier 70 }
			] }
			satisfaction { value 0 mods [ 
				{ #type rent-deal-modifier } 
				{ #type utilities-modifier type utilpower value -1 }
				{ #type utilities-modifier type utilphone value -1 }
				{ #type heatmap-modifier map floorHeatmap value 0.2 }
				{ #type heatmap-modifier map noiseHeatmap value -0.3 }
				{ #type employee-happiness-modifier multiplier 0.75 onlyunhappy #true }
				{ #type golden-age-modifier id goldenage-offices-satisfaction delta 0.2 }
				] }
			favrestaurants [ fastfood ]
			tags [ office finance financial-two ]
			needservices [
				{ tasktype servicewater probability 0.5 businesshoursonly #true workhours 0.2 timeouthours 20 timeouteffect -0.3 }
				{ tasktype servicejanitor probability 0.5 businesshoursonly #true workhours 0.5 timeouthours 20 timeouteffect -0.3 }
				{ tasktype servicecopy probability 0.5 businesshoursonly #true workhours 0.2 timeouthours 20 timeouteffect -0.3 }
				{ tasktype servicecomputer probability 0.25 businesshoursonly #true workhours 0.2 timeouthours 20 timeouteffect -0.3 }
				{ tasktype servicecatering probability 0.25 businesshoursonly #true workhours 0.2 timeouthours 20 timeouteffect -0.3 }
			]
			needutilities [ { type utilpower value 2 } { type utilphone value 2 } ]
		}
		tokens {
			tokengrants [ { type favors value 1 hourofday 17 probability 1 } ]
		}
	}
	{
		ident { template "office-level-two-d" parent "office-level-two-base" }
		placement {
			reqs [
				{ #type prestige-requirement value 2 sathit -0.2 }
                { #type score-requirement name score-restaurant-lunch minscore 2 sathit -0.2 }
                { #type score-requirement name score-retail-small minscore 2 sathit -0.2 }
			]
		}
		sprite {
			layouts [ office-level-two-d ]
		}
		workplace {
			workers 3
			workertemplates [ "npc-office-office.a-office.4" "npc-office-office.a-office.6" "npc-office-office.b-office.5" ]
			workhours { from 8 to 19 }
		}
		unit {
			locpattern "#pattern-architect"
			locdesc "office.two.d.desc"
			loccat  "office.two.d.cat"
			buildcost { value -300 mods [
				{ #type heatmap-modifier map floorHeatmap value -50 }
				{ #type golden-age-modifier id goldenage-offices-promoted multiplier 0.5 }
				] }
			pays { value 350 mods [ 
				{ #type game-difficulty-modifier hardmultiplier 0.92 easymultiplier 1.23 }
				{ #type heatmap-modifier map floorHeatmap value 100 } 
				{ #type economy-modifier multiplier 50 }
			] }
			satisfaction { value 0 mods [ 
				{ #type rent-deal-modifier } 
				{ #type utilities-modifier type utilpower value -1 }
				{ #type utilities-modifier type utilphone value -1 }
				{ #type heatmap-modifier map floorHeatmap value 0.3 }
				{ #type heatmap-modifier map noiseHeatmap value -0.3 }
				{ #type heatmap-modifier map smellHeatmap value -0.3 }
				{ #type employee-happiness-modifier multiplier 0.75 onlyunhappy #true }
				{ #type golden-age-modifier id goldenage-offices-satisfaction delta 0.2 }
				] }
			favrestaurants [ fastfood ]
			tags [ office design creative-two tech-two ]
			needservices [
				{ tasktype servicecourier probability 0.5 businesshoursonly #true workhours 0.2 timeouthours 20 timeouteffect -0.3 }
				{ tasktype servicesupplies probability 0.25 businesshoursonly #true workhours 0.2 timeouthours 20 timeouteffect -0.3 }
				{ tasktype servicejanitor probability 0.5 businesshoursonly #true workhours 0.5 timeouthours 20 timeouteffect -0.3 }
				{ tasktype serviceprinter probability 0.25 businesshoursonly #true workhours 0.2 timeouthours 20 timeouteffect -0.3 }
			]
			needutilities [ { type utilpower value 2 } { type utilphone value 2 } ]
		}
	}
	{
		ident { template "office-level-two-e" parent "office-level-two-base" }
		placement {
			reqs [
				{ #type prestige-requirement value 2 sathit -0.2 }
                { #type score-requirement name score-restaurant-dinner minscore 1 sathit -0.2 }
			]
		}
		sprite {
			layouts [ office-level-two-e ]
		}
		workplace {
			workers 3
			workertemplates [ "npc-office-office.a-office.4" "npc-office-office.a-office.6" "npc-office-office.b-office.5" ]
			workhours { from 8 to 19 }
		}
		unit {
			locpattern "#pattern-drafting"
			locdesc "office.two.e.desc"
			loccat  "office.two.e.cat"
			buildcost { value -300 mods [
				{ #type heatmap-modifier map floorHeatmap value -50 }
				{ #type golden-age-modifier id goldenage-offices-promoted multiplier 0.5 }
				] }
			pays { value 350 mods [ 
				{ #type game-difficulty-modifier hardmultiplier 0.95 easymultiplier 1.23 }
				{ #type heatmap-modifier map floorHeatmap value 100 } 
				{ #type economy-modifier multiplier 50 }
			] }
			satisfaction { value 0 mods [ 
				{ #type rent-deal-modifier } 
				{ #type utilities-modifier type utilpower value -1 }
				{ #type utilities-modifier type utilphone value -1 }
				{ #type heatmap-modifier map floorHeatmap value 0.3 }
				{ #type heatmap-modifier map elevatorHeatmap value 0.3 }
				{ #type heatmap-modifier map noiseHeatmap value -0.3 }
				{ #type heatmap-modifier map smellHeatmap value -0.3 }
				{ #type employee-happiness-modifier multiplier 0.75 onlyunhappy #true }
				{ #type golden-age-modifier id goldenage-offices-satisfaction delta 0.2 }
				] }
			favrestaurants [ pizza ]
			tags [ office design tech-two creative-two ]
			needservices [
				{ tasktype servicecourier probability 0.5 businesshoursonly #true workhours 0.2 timeouthours 20 timeouteffect -0.3 }
				{ tasktype servicecopy probability 0.5 businesshoursonly #true workhours 0.2 timeouthours 20 timeouteffect -0.3 }
				{ tasktype servicesupplies probability 0.25 businesshoursonly #true workhours 0.2 timeouthours 20 timeouteffect -0.3 }
				{ tasktype servicejanitor probability 0.5 businesshoursonly #true workhours 0.5 timeouthours 20 timeouteffect -0.3 }
				{ tasktype serviceprinter probability 0.25 businesshoursonly #true workhours 0.2 timeouthours 20 timeouteffect -0.3 }
			]
			needutilities [ { type utilpower value 2 } { type utilphone value 2 } ]
		}
	}
	{
		ident { template "office-level-two-f" parent "office-level-two-base" }
		heatmap {  }
		office {  }
		placement {
			reqs [
				{ #type prestige-requirement value 3 sathit -0.2 }
				{ #type score-requirement name score-restaurant-medium minscore 2 sathit -0.2 }
                { #type score-requirement name score-restaurant-dinner minscore 1.5 sathit -0.2 }
                { #type score-requirement name score-restaurant-cafe minscore 1.5 sathit -0.2 }
			]
		}
		sprite {
			layouts [ office-level-two-f ]
		}
		workplace {
			workers 2
			workertemplates [ "npc-office-office.b-office.admin.1" "npc-office-office.a-office.5" ]
			workhours { from 7.5 to 19 }
		}
		unit {
			locpattern "#pattern-lawyer-specialist"
			locdesc "office.two.f.desc"
			loccat  "office.two.f.cat"
			buildcost { value -325 mods [
				{ #type heatmap-modifier map floorHeatmap value -50 }
				{ #type golden-age-modifier id goldenage-offices-promoted multiplier 0.5 }
				] }
			pays { value 400 mods [
				{ #type game-difficulty-modifier hardmultiplier 0.94 easymultiplier 1.19 }
				{ #type heatmap-modifier map floorHeatmap value 100 }
				{ #type economy-modifier multiplier 50 }
			] }
			satisfaction { value 0 mods [
				{ #type rent-deal-modifier } 
				{ #type utilities-modifier type utilpower value -1 }
				{ #type utilities-modifier type utilphone value -1 }
				{ #type heatmap-modifier map floorHeatmap value 0.05 }
				{ #type heatmap-modifier map noiseHeatmap value -0.3 }
				{ #type employee-happiness-modifier multiplier 0.75 onlyunhappy #true }
				{ #type golden-age-modifier id goldenage-offices-satisfaction delta 0.2 }
			] }
			tags [ office legal legal-two ]
			favrestaurants [ diner ]
			needservices [
				{ tasktype servicecourier probability 0.5 businesshoursonly #true workhours 0.2 timeouthours 20 timeouteffect -0.3 }
				{ tasktype servicewater probability 0.5 businesshoursonly #true workhours 0.2 timeouthours 20 timeouteffect -0.3 }
				{ tasktype servicejanitor probability 0.5 businesshoursonly #true workhours 0.5 timeouthours 20 timeouteffect -0.3 }
				{ tasktype servicecopy probability 0.5 businesshoursonly #true workhours 0.2 timeouthours 20 timeouteffect -0.3 }
				{ tasktype servicestorage probability 0.25 businesshoursonly #true workhours 0.2 timeouthours 20 timeouteffect -0.3 }
				{ tasktype servicecatering probability 0.25 businesshoursonly #true workhours 0.2 timeouthours 20 timeouteffect -0.3 }
			]
			needutilities [ { type utilpower value 2 } { type utilphone value 2 } ]
			visitors [ { template "npc-visitor-three" probability 0.25 time { from 16 to 19 } hourlycount 1 } ]
		}
	}

	{
		ident { template "office-level-three-base" parent "office-base" }
		sfx {
			emitter "AMB_Office_Busy"
		}
		placement {
			buildhours 6
			size { x 15 y 1 }
		}
		prestige {
			penaltyeviction -2
			penaltymoveout -1
		}
		unit {
			grimeenabled #true
			dailyagewear 0.005
			dailytrafficwear 0.05
		}
	}


	{
		ident { template "office-level-three-a" parent "office-level-three-base" }
		sprite {
			layouts [ office-level-three-a ]
		}
		workplace {
			workers 5 
			workertemplates [ "npc-office-office.a-office.admin.1" "npc-office-office.a-office.7" "npc-office-office.a-office.7" "npc-office-office.a-office.7" "npc-office-office.v-office.8" ]
			workhours { from 7.5 to 20 }
		}
		placement {
			reqs [
				{ #type prestige-requirement value 9 sathit -0.2 }
				{ #type score-requirement name score-office-financial minscore 7 sathit -0.2 }
                { #type score-requirement name score-restaurant-large minscore 1.5 sathit -0.2 }
                { #type score-requirement name score-restaurant-lunch minscore 3 sathit -0.2 }
                { #type score-requirement name score-restaurant-bar minscore 1 sathit -0.2 }
                { #type score-requirement name score-restaurant-dinner minscore 2.5 sathit -0.2 }
                { #type score-requirement name score-retail-medium minscore 1.5 sathit -0.2 }
                { #type score-requirement name score-retail-clothing minscore 1 sathit -0.2 }
			]
		}
		heatmap {
			produces [
				{ type noiseHeatmap value 0.5 }
			]
		}
		unit {
			locpattern "#pattern-finance-2"
			loccat  "office.three.a.cat"
			locdesc "office.three.a.desc"
			buildcost { value -650 mods [
				{ #type game-difficulty-modifier harddelta -50 }
				{ #type heatmap-modifier map floorHeatmap value -50 }
				{ #type golden-age-modifier id goldenage-offices-promoted multiplier 0.5 }
				] }
			pays { value 700 mods [
				{ #type game-difficulty-modifier hardmultiplier 1.1 easymultiplier 1.2 }
				{ #type heatmap-modifier map floorHeatmap value 200 }
				{ #type heatmap-modifier map elevatorHeatmap value 200 }
				{ #type economy-modifier multiplier 80 }
			] }
			satisfaction { value 0 mods [
				{ #type rent-deal-modifier } 
				{ #type utilities-modifier type utilpower value -1 }
				{ #type utilities-modifier type utilphone value -1 }
				{ #type heatmap-modifier map floorHeatmap value 0.3 }
				{ #type heatmap-modifier map elevatorHeatmap value 0.3 }
				{ #type employee-happiness-modifier multiplier 0.75 onlyunhappy #true }
				{ #type golden-age-modifier id goldenage-offices-satisfaction delta 0.2 }
			] }
			tags [ office finance financial-three office-three ]
			favrestaurants [ rest-three ]
			needservices [
				{ tasktype servicejanitor probability 1 businesshoursonly #true workhours 0.5 timeouthours 20 timeouteffect -0.35 }
				{ tasktype servicecomputer probability 0.5 businesshoursonly #true workhours 0.2 timeouthours 20 timeouteffect -0.35 }
				{ tasktype servicestorage probability 0.25 businesshoursonly #true workhours 0.2 timeouthours 20 timeouteffect -0.35 }
				{ tasktype serviceauditors probability 0.1 businesshoursonly #true workhours 1 timeouthours 30 timeouteffect -0.35 }
				{ tasktype servicedesign probability 0.1 businesshoursonly #true workhours 0.5 timeouthours 30 timeouteffect -0.35 }
				{ tasktype servicesecurity probability 0.5 businesshoursonly #true workhours 0.2 timeouthours 20 timeouteffect -0.35 }
			]
			needutilities [
				{ type utilpower value 4 } { type utilphone value 4 }
			]
			visitors [ { template "npc-visitor-three" probability 0.75 time { from 9 to 14 } hourlycount 1 } ]
		}
	}
	{
		ident { template "office-level-three-b" parent "office-level-three-base" }
		placement {
			reqs [
				{ #type prestige-requirement value 9 sathit -0.2 }
				{ #type score-requirement name score-office-technical minscore 7 sathit -0.2 }
                { #type score-requirement name score-restaurant-large minscore 2 sathit -0.2 }
                { #type score-requirement name score-restaurant-lunch minscore 3 sathit -0.2 }
                { #type score-requirement name score-restaurant-dinner minscore 3 sathit -0.2 }
                { #type score-requirement name score-retail-medium minscore 2 sathit -0.2 }
                { #type score-requirement name score-retail-electronics minscore 2 sathit -0.2 }
			]
		}
		sprite {
			layouts [ office-level-three-b ]
		}
		workplace {
			workers 5
			workertemplates [ "npc-office-office.a-office.admin.1" "npc-office-office.a-office.5" "npc-office-office.a-office.5" "npc-office-office.a-office.5" "npc-office-office.a-office.6" ]
			workhours { from 7.5 to 19 }
		}
		unit {
			locpattern "#pattern-engineering"
			loccat  "office.three.b.cat"
			locdesc "office.three.b.desc"
			buildcost { value -650 mods [
				{ #type game-difficulty-modifier harddelta -50 }
				{ #type heatmap-modifier map floorHeatmap value -50 }
				{ #type golden-age-modifier id goldenage-offices-promoted multiplier 0.5 }
				] }
			pays { value 700 mods [
				{ #type game-difficulty-modifier hardmultiplier 0.97 easymultiplier 1.2 }
				{ #type heatmap-modifier map floorHeatmap value 200 }
				{ #type heatmap-modifier map elevatorHeatmap value -200 }
				{ #type economy-modifier multiplier 80 }
			] }
			satisfaction { value 0 mods [
				{ #type rent-deal-modifier }
				{ #type utilities-modifier type utilpower value -1 }
				{ #type utilities-modifier type utilphone value -1 }
				{ #type heatmap-modifier map floorHeatmap value 0.3 }
				{ #type heatmap-modifier map trafficHeatmap value -0.3 }
				{ #type heatmap-modifier map elevatorHeatmap value -0.3 }
				{ #type heatmap-modifier map noiseHeatmap value -0.3 }
				{ #type employee-happiness-modifier multiplier 0.75 onlyunhappy #true } 
				{ #type golden-age-modifier id goldenage-offices-satisfaction delta 0.2 }
			] }
			tags [ office engineering tech-three creative-three office-three ]
			favrestaurants [ rest-three ]
			needservices [
				{ tasktype servicejanitor probability 1 businesshoursonly #true workhours 0.5 timeouthours 20 timeouteffect -0.35 }
				{ tasktype serviceprinter probability 0.25 businesshoursonly #true workhours 0.2 timeouthours 20 timeouteffect -0.35 }
				{ tasktype servicecatering probability 0.25 businesshoursonly #true workhours 0.2 timeouthours 20 timeouteffect -0.35 }
				{ tasktype servicetemps probability 0.1 businesshoursonly #true workhours 1 timeouthours 30 timeouteffect -0.35 }
				{ tasktype servicesecurity probability 0.5 businesshoursonly #true workhours 0.2 timeouthours 20 timeouteffect -0.35 }
			]
			needutilities [
				{ type utilpower value 4 } { type utilphone value 4 }
			]
			visitors [ { template "npc-visitor-three" probability 0.5 time { from 9 to 14 } hourlycount 1 } ]
		}
		tokens {
			tokengrants [ { type buzz value 1 hourofday 19 probability 1 } ]
		}
	}
	{
		ident { template "office-level-three-c" parent "office-level-three-base" }
		placement {
			reqs [
				{ #type prestige-requirement value 9 sathit -0.2 }
				{ #type score-requirement name score-office-creative minscore 7 sathit -0.2 }
                { #type score-requirement name score-restaurant-large minscore 2 sathit -0.2 }
                { #type score-requirement name score-restaurant-dinner minscore 3 sathit -0.2 }
                { #type score-requirement name score-restaurant-bar minscore 1.5 sathit -0.2 }
                { #type score-requirement name score-retail-medium minscore 2 sathit -0.2 }
			]
		}
		sprite {
			layouts [ office-level-three-c ]
		}
		workplace {
			workers 4
			workertemplates [ "npc-office-office.a-office.admin.1" "npc-office-office.a-office.5" "npc-office-office.b-office.9" "npc-office-office.b-office.9" ]
			workhours { from 7.5 to 21 }
		}
		unit {
			locpattern "#pattern-pr"
			loccat  "office.three.c.cat"
			locdesc "office.three.c.desc"
			buildcost { value -650 mods [
				{ #type game-difficulty-modifier harddelta -50 }
				{ #type heatmap-modifier map floorHeatmap value -50 }
				{ #type golden-age-modifier id goldenage-offices-promoted multiplier 0.5 }
				] }
			pays { value 700 mods [
				{ #type game-difficulty-modifier hardmultiplier 0.97 easymultiplier 1.27 }
				{ #type heatmap-modifier map floorHeatmap value 400 }
				{ #type heatmap-modifier map aestheticsHeatmap value 200 }
				{ #type economy-modifier multiplier 80 }
			] }
			satisfaction { value 0 mods [
				{ #type rent-deal-modifier } 
				{ #type utilities-modifier type utilpower value -1 }
				{ #type utilities-modifier type utilphone value -1 }
				{ #type heatmap-modifier map aestheticsHeatmap value 0.2 }
				{ #type heatmap-modifier map floorHeatmap value 0.2 }
				{ #type heatmap-modifier map noiseHeatmap value -0.3 }
				{ #type heatmap-modifier map smellHeatmap value -0.3 }
				{ #type employee-happiness-modifier multiplier 0.75 onlyunhappy #true } 
				{ #type golden-age-modifier id goldenage-offices-satisfaction delta 0.2 }
			] }
			tags [ office marketing creative-three office-three ]
			favrestaurants [ rest-three ]
			needservices [
				{ tasktype servicejanitor probability 1 businesshoursonly #true workhours 0.5 timeouthours 20 timeouteffect -0.35 }
				{ tasktype serviceprinter probability 0.5 businesshoursonly #true workhours 0.2 timeouthours 20 timeouteffect -0.35 }
				{ tasktype servicetemps probability 0.1 businesshoursonly #true workhours 1 timeouthours 30 timeouteffect -0.35 }
				{ tasktype servicesecurity probability 0.5 businesshoursonly #true workhours 0.2 timeouthours 20 timeouteffect -0.35 }
			]
			needutilities [ { type utilpower value 4 } { type utilphone value 3 } ]
			visitors [ { template "npc-visitor-three" probability 0.5 time { from 9 to 14 } hourlycount 1 } ]
		}
		tokens {
			tokengrants [ { type buzz value 1 hourofday 21 probability 1 } ]
		}
	}
	{
		ident { template "office-level-three-d" parent "office-level-three-base" }
		placement {
			reqs [
				{ #type prestige-requirement value 10 sathit -0.2 }
				{ #type score-requirement name score-office-technical minscore 7 sathit -0.2 }
                { #type score-requirement name score-restaurant-large minscore 2.5 sathit -0.2 }
                { #type score-requirement name score-restaurant-dinner minscore 3 sathit -0.2 }
                { #type score-requirement name score-restaurant-bar minscore 2 sathit -0.2 }
                { #type score-requirement name score-retail-large minscore 2 sathit -0.2 }
                { #type score-requirement name score-retail-electronics minscore 2 sathit -0.2 }
			]
		}
		heatmap {
			produces [
				{ type noiseHeatmap value 0.7 }
				{ type smellHeatmap value 0.2 }
			]
		}
		sprite {
			layouts [ office-level-three-d-one ]
		}
		workplace {
			workers 4
			workertemplates [ "npc-office-office.b-office.admin.2" "npc-office-office.b-office.9" "npc-office-office.b-office.9" "npc-office-office.b-office.9" ]
			workhours { from 9.5 to 21 }
		}
		unit {
			locpattern "#pattern-tech"
			loccat  "office.three.d.cat"
			locdesc "office.three.d.desc"
			buildcost { value -650 mods [
				{ #type game-difficulty-modifier harddelta -50 }
				{ #type heatmap-modifier map floorHeatmap value -50 }
				{ #type golden-age-modifier id goldenage-offices-promoted multiplier 0.5 }
				] }
			pays { value 725 mods [
				{ #type game-difficulty-modifier hardmultiplier 1.09 easymultiplier 1.2 }
				{ #type heatmap-modifier map elevatorHeatmap value 100 }
				{ #type economy-modifier multiplier 90 }
			] }
			satisfaction { value 0 mods [
				{ #type rent-deal-modifier } 
				{ #type utilities-modifier type utilpower value -1 }
				{ #type utilities-modifier type utilphone value -1 }
				{ #type heatmap-modifier map elevatorHeatmap value 0.2 }
				{ #type employee-happiness-modifier multiplier 0.75 onlyunhappy #true } 
				{ #type golden-age-modifier id goldenage-offices-satisfaction delta 0.2 }
			] }
			tags [ office tech tech-three office-three creative-two ]
			favrestaurants [ rest-three ]
			needservices [
				{ tasktype servicejanitor probability 1 businesshoursonly #true workhours 0.5 timeouthours 20 timeouteffect -0.45 }
				{ tasktype servicecomputer probability 0.25 businesshoursonly #true workhours 0.5 timeouthours 20 timeouteffect -0.45 }
				{ tasktype servicecatering probability 0.25 businesshoursonly #true workhours 0.2 timeouthours 20 timeouteffect -0.45 }
				{ tasktype serviceauditors probability 0.1 businesshoursonly #true workhours 1 timeouthours 30 timeouteffect -0.45 }
				{ tasktype servicedesign probability 0.1 businesshoursonly #true workhours 1 timeouthours 30 timeouteffect -0.45 }
				{ tasktype servicesecurity probability 0.5 businesshoursonly #true workhours 0.2 timeouthours 20 timeouteffect -0.45 }
				{ tasktype servicefitness probability 0.1 businesshoursonly #true workhours 1 timeouthours 20 timeouteffect -0.45 }
			]
			needutilities [
				{ type utilpower value 4 } { type utilphone value 4 }
			]
		}
	}
	{
		ident { template "office-level-three-d-two" parent "office-level-three-d" }
		sprite {
			layouts [ office-level-three-d-two ]
		}
		unit {
			locdesc "office.three.d.two.desc"
			tags [ office tech tech-three office-three financial-two ]
		}
	}
	{
		ident { template "office-level-three-d-three" parent "office-level-three-d" }
		sprite {
			layouts [ office-level-three-d-three ]
		}
		unit {
			locdesc "office.three.d.three.desc"
			tags [ office tech tech-three office-three financial-two ]
		}
	}
	{
		ident { template "office-level-three-e" parent "office-level-three-base" }
		sfx {
			emitter "AMB_Office_Doctor"
		}
		placement {
			reqs [
				{ #type prestige-requirement value 10 sathit -0.2 }
                { #type score-requirement name score-restaurant-large minscore 2 }
                { #type score-requirement name score-restaurant-breakfast minscore 3 }
                { #type score-requirement name score-restaurant-lunch minscore 4 }
                { #type score-requirement name score-retail-large minscore 2 }
			]
		}
		sprite {
			layouts [ office-level-three-e ]
		}
		workplace {
			workers 4
			workertemplates [ "npc-office-office.b-office.admin.1" "npc-office-office.b-office.doctor.2" "npc-office-office.b-office.doctor.2" ]
			workhours { from 7.5 to 18.5 }
		}
		unit {
			locpattern "#pattern-specialist"
			loccat  "office.three.e.cat"
			locdesc "office.three.e.desc"
			buildcost { value -600 mods [
				{ #type game-difficulty-modifier harddelta -50 }
				{ #type heatmap-modifier map floorHeatmap value -50 }
				{ #type golden-age-modifier id goldenage-offices-promoted multiplier 0.5 }
				] }
			pays { value 650 mods [
				{ #type game-difficulty-modifier hardmultiplier 0.97 easymultiplier 1.2 }
				{ #type heatmap-modifier map floorHeatmap value -200 }
				{ #type economy-modifier multiplier 100 }
			] }
			satisfaction { value 0 mods [
				{ #type rent-deal-modifier } 
				{ #type utilities-modifier type utilpower value -1 }
				{ #type utilities-modifier type utilphone value -1 }
				{ #type utilities-modifier type utilwater value -1 }
				{ #type heatmap-modifier map floorHeatmap value -0.2 }
				{ #type employee-happiness-modifier multiplier 0.75 onlyunhappy #true } 
				{ #type golden-age-modifier id goldenage-offices-satisfaction delta 0.2 }
			] }
			tags [ office medical medical-three office-three ]
			favrestaurants [ rest-three ]
			needservices [
				{ tasktype servicejanitor probability 1 businesshoursonly #true workhours 1.5 timeouthours 20 timeouteffect -0.35 }
				{ tasktype servicecomputer probability 0.25 businesshoursonly #true workhours 0.5 timeouthours 20 timeouteffect -0.35 }
				{ tasktype servicestorage probability 0.25 businesshoursonly #true workhours 0.2 timeouthours 20 timeouteffect -0.35 }
				{ tasktype servicesecurity probability 0.5 businesshoursonly #true workhours 0.2 timeouthours 20 timeouteffect -0.35 }
			]
			needutilities [ { type utilwater value 2 } { type utilpower value 3 } { type utilphone value 2 } ]
		}
		tokens {
			tokengrants [ { type favors value 1 hourofday 18.5 probability 1 } ]
		}
	}
	{
		ident { template "office-level-three-f" parent "office-level-three-base" }
		placement {
			reqs [
				{ #type prestige-requirement value 9 sathit -0.2 }
				{ #type score-requirement name score-office-creative minscore 7 sathit -0.2 }
                { #type score-requirement name score-restaurant-large minscore 2 sathit -0.2 }
                { #type score-requirement name score-restaurant-dinner minscore 3 sathit -0.2 }
                { #type score-requirement name score-restaurant-bar minscore 1.5 sathit -0.2 }
                { #type score-requirement name score-retail-medium minscore 2 sathit -0.2 }
			]
		}
		sprite {
			layouts [ office-level-three-f ]
		}
		workplace {
			workers 4
			workertemplates [ "npc-office-office.a-office.admin.1" "npc-office-office.a-office.5" "npc-office-office.b-office.9" "npc-office-office.b-office.9" ]
			workhours { from 7.5 to 21 }
		}
		unit {
			locpattern "#pattern-branding"
			loccat  "office.three.f.cat"
			locdesc "office.three.f.desc"
			buildcost { value -700 mods [
				{ #type heatmap-modifier map floorHeatmap value -50 }
				{ #type golden-age-modifier id goldenage-offices-promoted multiplier 0.5 }
				] }
			pays { value 725 mods [
				{ #type game-difficulty-modifier hardmultiplier 1.01 easymultiplier 1.25 }
				{ #type heatmap-modifier map floorHeatmap value 400 }
				{ #type heatmap-modifier map aestheticsHeatmap value 200 }
				{ #type economy-modifier multiplier 80 }
			] }
			satisfaction { value 0 mods [
				{ #type rent-deal-modifier } 
				{ #type utilities-modifier type utilpower value -1 }
				{ #type utilities-modifier type utilphone value -1 }
				{ #type utilities-modifier type utilcable value -1 }
				{ #type heatmap-modifier map aestheticsHeatmap value 0.2 }
				{ #type heatmap-modifier map floorHeatmap value 0.2 }
				{ #type heatmap-modifier map noiseHeatmap value -0.3 }
				{ #type heatmap-modifier map smellHeatmap value -0.3 }
				{ #type employee-happiness-modifier multiplier 0.75 onlyunhappy #true } 
				{ #type golden-age-modifier id goldenage-offices-satisfaction delta 0.2 }
			] }
			tags [ office marketing creative-three office-three ]
			favrestaurants [ rest-three ]
			needservices [
				{ tasktype servicejanitor probability 1 businesshoursonly #true workhours 1 timeouthours 20 timeouteffect -0.35 }
				{ tasktype servicecomputer probability 0.5 businesshoursonly #true workhours 0.5 timeouthours 20 timeouteffect -0.35 }
				{ tasktype serviceprinter probability 0.5 businesshoursonly #true workhours 0.2 timeouthours 20 timeouteffect -0.35 }
				{ tasktype servicetemps probability 0.1 businesshoursonly #true workhours 1 timeouthours 30 timeouteffect -0.35 }
				{ tasktype servicesecurity probability 0.5 businesshoursonly #true workhours 0.2 timeouthours 20 timeouteffect -0.35 }
			]
			needutilities [ { type utilpower value 4 } { type utilphone value 3 } { type utilcable value 1 } ]
		}
		tokens {
			tokengrants [ { type favors value 1 hourofday 19 probability 1 } ]
		}
	}
	{
		ident { template "office-level-four-base" parent "office-base" }
		placement {
			buildhours 1
			size { x 10 y 2 }
		}
		prestige {
			penaltyeviction -2
			penaltymoveout -2
		}
		unit {
			grimeenabled #true
			dailyagewear 0.005
			dailytrafficwear 0.05
		}
	}
	
	{
		ident { template "office-level-four-a" parent "office-level-four-base" }
		sfx {
			emitter "AMB_Office_Busy"
		}
		placement {
			reqs [
				{ #type prestige-requirement value 14 sathit -0.4 }
				{ #type entity-count-requirement type atleast count 1 template service-level-four-club sathit -0.4 }
				{ #type score-requirement name score-office-technical minscore 10 sathit -0.4 }
				{ #type score-requirement name score-restaurant-gourmet minscore 2 sathit -0.3 }
				{ #type score-requirement name score-restaurant-bar minscore 2 sathit -0.3 }
				{ #type score-requirement name score-retail-luxury minscore 1 sathit -0.3 }
			]
		}
		heatmap {
			produces [
				{ type noiseHeatmap value 0.25 }
			]
		}
		sprite {
			layouts [ office-level-four-a ]
		}
		workplace {
			workers 7
			workertemplates [ 
				"npc-office-office.a-office.admin.2" 
				"npc-office-office.b-office.9" 
				"npc-office-office.b-office.9" 
				"npc-office-office.a-meeting.1" 
				"npc-office-office.a-meeting.1" 
				"npc-office-office.a-meeting.1" 
				"npc-office-office.a-office.7" ]
			workhours { from 9.5 to 21 }
		}
		unit {
			locpattern "#pattern-HQ-tech"
			loccat		"office.four.a.cat"
			locdesc 	"office.four.a.desc"
			buildcost { value -1500 mods [
				{ #type game-difficulty-modifier harddelta -450 }
				{ #type heatmap-modifier map floorHeatmap value -50 }
				{ #type golden-age-modifier id goldenage-offices-promoted multiplier 0.5 }
				] }
			pays { value 1200 mods [
				{ #type game-difficulty-modifier hardmultiplier 1.07 easymultiplier 1.25 }
				{ #type heatmap-modifier map floorHeatmap value 125 }
				{ #type heatmap-modifier map aestheticsHeatmap value 150 }
				{ #type economy-modifier multiplier 100 }
				] }
			satisfaction { value 0 mods [
					{ #type rent-deal-modifier } 
					{ #type utilities-modifier type utilpower value -1 }
					{ #type utilities-modifier type utilphone value -1 }
					{ #type heatmap-modifier map aestheticsHeatmap value 0.2 }
					{ #type heatmap-modifier map floorHeatmap value 0.2 }
					{ #type heatmap-modifier map trafficHeatmap value 0.2 }
					{ #type heatmap-modifier map smellHeatmap value -0.3 }
					{ #type employee-happiness-modifier multiplier 0.75 onlyunhappy #true } 
					{ #type golden-age-modifier id goldenage-offices-satisfaction delta 0.2 }
				] }
			favrestaurants [ rest-four ]
			tags [ office tech-four office-four ]
			needutilities [
				{ type utilphone value 6 }
				{ type utilpower value 8 }
			]
			needservices [
				{ tasktype servicejanitor probability 1 businesshoursonly #true workhours 1.5 timeouthours 20 timeouteffect -0.35 }
				{ tasktype servicecatering probability 0.25 businesshoursonly #true workhours 0.2 timeouthours 20 timeouteffect -0.35 }
				{ tasktype servicesecurity probability 1 businesshoursonly #true workhours 0.2 timeouthours 20 timeouteffect -0.35 }
				{ tasktype servicefitness probability 0.1 businesshoursonly #true workhours 0.5 timeouthours 20 timeouteffect -0.35 }
				{ tasktype servicelimo probability 0.25 businesshoursonly #true workhours 2 timeouthours 20 timeouteffect -0.25 }
			]
			visitors [
				{ template "npc-visitor-four" probability 0.5 time { from 16 to 22 } hourlycount 2 }
			]
		}
		tokens {
			tokengrants [ { type buzz value 5 hourofday 18.5 probability 1 } ]
		}
	}
	{
		ident { template "office-level-four-b" parent "office-level-four-base" }
		placement {
			reqs [
				{ #type prestige-requirement value 14 sathit -0.4 }
				{ #type score-requirement name score-office-creative minscore 10 sathit -0.4 }
				{ #type score-requirement name score-restaurant-gourmet minscore 2 sathit -0.3 }
				{ #type score-requirement name score-retail-luxury minscore 3 sathit -0.3 }
			]
		}
		sprite {
			layouts [ office-level-four-b ]
		}
		workplace {
			workers 7
			workertemplates [
				"npc-office-office.b-meeting.2"
				"npc-office-office.a-meeting.1"
				"npc-office-office.b-office.9"
				"npc-office-office.a-office.10"
				"npc-office-office.a-office.admin.1"
				"npc-office-office.b-office.5"
				"npc-office-office.a-office.6"
				"npc-office-office.a-office.6"
			]
		}
		unit {
			locpattern "#pattern-media"
			loccat		"office.four.b.cat"
			locdesc 	"office.four.b.desc"
			buildcost { value -1500 mods [
				{ #type game-difficulty-modifier harddelta -350 }
				{ #type heatmap-modifier map floorHeatmap value -50 }
				{ #type golden-age-modifier id goldenage-offices-promoted multiplier 0.5 }
				] }
			pays { value 1200 mods [
				{ #type game-difficulty-modifier hardmultiplier 1.16 easymultiplier 1.25 }
				{ #type heatmap-modifier map floorHeatmap value 125 }
				{ #type economy-modifier multiplier 100 }
				{ #type heatmap-modifier map elevatorHeatmap value -150 }
				] }
			satisfaction { value 0 mods [
				{ #type rent-deal-modifier }
				{ #type utilities-modifier type utilpower value -1 }
				{ #type utilities-modifier type utilphone value -1 }
				{ #type utilities-modifier type utilcable value -1 }
				{ #type heatmap-modifier map floorHeatmap value 0.2 }
				{ #type heatmap-modifier map trafficHeatmap value -0.3 }
				{ #type heatmap-modifier map noiseHeatmap value -0.4 }
				{ #type employee-happiness-modifier multiplier 0.75 onlyunhappy #true }  
				{ #type golden-age-modifier id goldenage-offices-satisfaction delta 0.2 }
				] }
			favrestaurants [ rest-four ]
			tags [ office creative-four office-four ]
			needutilities [
				{ type utilphone value 2 }
				{ type utilpower value 8 }
				{ type utilcable value 4 }
			]
			needservices [
				{ tasktype servicewater probability 0.5 businesshoursonly #true workhours 0.2 timeouthours 20 timeouteffect -0.35 }
				{ tasktype servicejanitor probability 1 businesshoursonly #true workhours 1.5 timeouthours 20 timeouteffect -0.35 }
				{ tasktype servicecomputer probability 0.5 businesshoursonly #true workhours 0.5 timeouthours 20 timeouteffect -0.35 }
				{ tasktype servicedesign probability 0.1 businesshoursonly #true workhours 1 timeouthours 20 timeouteffect -0.35 }
				{ tasktype servicesecurity probability 0.25 businesshoursonly #true workhours 0.2 timeouthours 20 timeouteffect -0.35 }
				{ tasktype servicehelicopter probability 0.1 businesshoursonly #true workhours 0.2 timeouthours 20 timeouteffect -0.25 }
			]
			visitors [
				{ template "npc-visitor-four" probability 0.5 time { from 17 to 22 } hourlycount 2 }
			]
		}
		tokens {
			tokengrants [ { type buzz value 8 hourofday 9 probability 1 } ]
		}
	}
	{
		ident { template "office-level-four-c" parent "office-level-four-base" }
		placement {
			reqs [
				{ #type prestige-requirement value 14 sathit -0.4 }
				{ #type entity-count-requirement type atleast count 1 template service-level-four-club sathit -0.4 }
				{ #type score-requirement name score-office-legal minscore 10 sathit -0.4 }
				{ #type score-requirement name score-restaurant-gourmet minscore 2 sathit -0.3 }
				{ #type score-requirement name score-restaurant-dinner minscore 4 sathit -0.3 }
				{ #type score-requirement name score-retail-luxury minscore 1 sathit -0.3 }
			]
		}
		sprite {
			layouts [ office-level-four-c ]
		}
		workplace {
			workers 7
			workertemplates [
				"npc-office-office.a-office.4-standing"
				"npc-office-office.a-office.admin.1"
				"npc-office-office.b-meeting.2"
				"npc-office-office.a-office.admin.1"
				"npc-office-office.a-office.5"
				"npc-office-office.a-office.6"
				"npc-office-office.b-meeting.2"
			]
			workhours { from 7.5 to 19 }
		}
		unit {
			locpattern "#pattern-government"
			loccat 		"office.four.c.cat"
			locdesc		"office.four.c.desc"
			buildcost { value -1500 mods [
				{ #type game-difficulty-modifier harddelta -450 }
				{ #type heatmap-modifier map floorHeatmap value -50 }
				{ #type golden-age-modifier id goldenage-offices-promoted multiplier 0.5 }
				{ #type scenario-modifier tags [ "scenario-3"] when pass multiplier 2 }
				] }
			pays { value 1200 mods [
				{ #type game-difficulty-modifier hardmultiplier 0.9 easymultiplier 1.25 }
				{ #type economy-modifier multiplier 100 }
				{ #type heatmap-modifier map floorHeatmap value -200 }
				] }
			satisfaction { value 0 mods [
				{ #type rent-deal-modifier } 
				{ #type utilities-modifier type utilpower value -1 }
				{ #type utilities-modifier type utilphone value -1 }
				{ #type heatmap-modifier map floorHeatmap value -0.2 }
				{ #type heatmap-modifier map noiseHeatmap value -0.4 }
				{ #type heatmap-modifier map smellHeatmap value -0.4 }
				{ #type employee-happiness-modifier multiplier 0.75 onlyunhappy #true } 
				{ #type golden-age-modifier id goldenage-offices-satisfaction delta 0.2 }
				] }
			favrestaurants [ rest-four ]
			tags [ office government-office office-four ]
			needutilities [
				{ type utilpower value 6 }
				{ type utilphone value 8 }
			]
			needservices [
				{ tasktype servicejanitor probability 1 businesshoursonly #true workhours 1.5 timeouthours 20 timeouteffect -0.35 }
				{ tasktype serviceprinter probability 0.5 businesshoursonly #true workhours 0.2 timeouthours 20 timeouteffect -0.35 }
				{ tasktype serviceauditors probability 0.1 businesshoursonly #true workhours 2 timeouthours 20 timeouteffect -0.25 }
				{ tasktype servicetemps probability 0.1 businesshoursonly #true workhours 2 timeouthours 20 timeouteffect -0.35 }
				{ tasktype servicesecurity probability 1 businesshoursonly #true workhours 0.2 timeouthours 20 timeouteffect -0.35 }
			]
			visitors [
				{ template "npc-visitor-three" probability 0.5 time { from 13 to 16 } hourlycount 2 }
				{ template "npc-visitor-one" probability 0.5 time { from 8 to 13 } hourlycount 2 }
			]
		}
		tokens {
			tokengrants [ { type favors value 4 hourofday 13 probability 1 } ]
		}
	}
	{
		ident { template "office-level-four-d" parent "office-level-four-base" }
		placement {
			reqs [
				{ #type prestige-requirement value 14 sathit -0.4 }
				{ #type entity-count-requirement type atleast count 1 template service-level-four-club sathit -0.4 }
				{ #type score-requirement name score-office-financial minscore 10 sathit -0.4 }
				{ #type score-requirement name score-restaurant-gourmet minscore 2 sathit -0.3 }
				{ #type score-requirement name score-restaurant-lunch minscore 4 sathit -0.3 }
				{ #type score-requirement name score-retail-clothing minscore 2 sathit -0.3 }
			]
		}
		sprite {
			layouts [ office-level-four-d ]
		}
		workplace {
			workers 6
			workertemplates [
				"npc-office-office.a-office.admin.1"
				"npc-office-office.b-meeting.2"
				"npc-office-office.a-meeting.1"
				"npc-office-office.a-office.5"
				"npc-office-office.a-office.6"
				"npc-office-office.v-office.8"
			]
			workhours { from 7.5 to 17 }
		}
		unit {
			locpattern "#pattern-finance-HQ"
			loccat		"office.four.d.cat"
			locdesc 	"office.four.d.desc"
			buildcost { value -1500 mods [
				{ #type game-difficulty-modifier harddelta -450 }
				{ #type heatmap-modifier map floorHeatmap value -50 }
				{ #type golden-age-modifier id goldenage-offices-promoted multiplier 0.5 }
				{ #type scenario-modifier tags [ "scenario-3"] when pass multiplier 2 }
				] }
			pays { value 1200 mods [
				{ #type game-difficulty-modifier hardmultiplier 1.28 easymultiplier 1.25 }
				{ #type economy-modifier multiplier 100 }
				{ #type heatmap-modifier map floorHeatmap value 200 }
				{ #type heatmap-modifier map aestheticsHeatmap value 100 }
				] }
			satisfaction { value 0 mods [
				{ #type rent-deal-modifier } 
				{ #type utilities-modifier type utilpower value -1 }
				{ #type utilities-modifier type utilphone value -1 }
				{ #type heatmap-modifier map aestheticsHeatmap value 0.4 }
				{ #type heatmap-modifier map floorHeatmap value 0.4 }
				{ #type heatmap-modifier map trafficHeatmap value -0.4 }
				{ #type heatmap-modifier map noiseHeatmap value -0.4 }
				{ #type heatmap-modifier map smellHeatmap value -0.4 }
				{ #type employee-happiness-modifier multiplier 0.75 onlyunhappy #true }
				{ #type golden-age-modifier id goldenage-offices-satisfaction delta 0.2 }
				] }
			favrestaurants [ rest-four ]
			tags [ office finacial-four office-four ]
			needutilities [
				{ type utilphone value 7 }
				{ type utilpower value 7 }
			]
			needservices [
				{ tasktype servicejanitor probability 1 businesshoursonly #true workhours 1.5 timeouthours 20 timeouteffect -0.35 }
				{ tasktype serviceauditors probability 0.1 businesshoursonly #true workhours 2 timeouthours 20 timeouteffect -0.25 }
				{ tasktype servicesecurity probability 0.25 businesshoursonly #true workhours 0.2 timeouthours 20 timeouteffect -0.35 }
				{ tasktype servicehelicopter probability 0.25 businesshoursonly #true workhours 0.2 timeouthours 20 timeouteffect -0.35 }
				{ tasktype servicelimo probability 0.25 businesshoursonly #true workhours 0.5 timeouthours 20 timeouteffect -0.35 }
			]
			visitors [
				{ template "npc-visitor-three" probability 0.5 time { from 13 to 16 } hourlycount 1 }
			]
		}
		tokens {
			tokengrants [ { type favors value 6 hourofday 17 probability 1 } ]
		}
	}


	;;;;;;;;;;;;;;;;;;;;; entertainment placeholder stuff

;	{
;		ident { template "entertainment-base" parent "workplace-base" }
;		placement {
;		}
;		selection {
;			mode entertainment
;		}
;		service {
;			servicetype entertainment
;		}
;		unit {
;		}
;	}



    ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; decos

	{
		ident { template "deco-base" }
		placement {
			insertinmap #true
			multiplace #false
			buildsite #false
			onremove delete
			allowswallpaperunder #true
		}
		selection {
			mode deco
		}
		sprite {
			atlas hddecos
			animations {
				default [ { img "missing.png" atlas hddecos layer wallpaper } ]
			}
		}
		unit {
			buildcost { value 0 }
		}
		tokens { }
	}
	{
		ident { template "deco-inside-base" parent "deco-base" }
		placement {
			reqfloor #true
			reqfinishedfloor #true
			reqs [
				{ #type floor-requirement parterre #true aboveground #true belowground #false }
				{ #type solid-wall-requirement }
			]
		}
	}
	{
		ident { template "deco-outside-base" parent "deco-base" }
		placement {
			reqoriginonground #true
			reqfloor #false
			reqfinishedfloor #false
			onremove delete
			reqs [
				{ #type consultant-upgrade-requirement id "cons-a-5" }
				{ #type empty-outside-space-requirement }
			]
		}
	}
	{
		ident { template "deco-plaza-base" parent "deco-base" }
		placement {
			reqoriginonground #true
			reqfloor #false
			reqfinishedfloor #false
			onremove delete
			reqs [
				{ #type consultant-upgrade-requirement id "cons-b-3" }
				{ #type empty-outside-space-requirement }
				{ #type lot-boundaries-requirement }
			]
		}
	}

	{
		ident { template "deco-plaza-tile" parent "deco-plaza-base" }
		placement {
			size { x 1 y 1 }
			multiplace #true
		}
		sprite {
			animations {
				default [ { img "plaza-tile.png" atlas hddecos layer emptyfloor } ]
			}
		}
		unit {
			buildcost { value -10 mods [ { #type golden-age-modifier id goldenage-commercial-landscaping multiplier 0 } ] }
			locname "deco.plaza.tile"
			tags [ plaza ]
		}
	}
	{
		ident { template "deco-plaza-single-hedge" parent "deco-plaza-base" }
		placement {
			size { x 1 y 1 }
		}
		sprite {
			animations {
				default [ { img "plaza-hedge-single.png" atlas hddecos layer wallpaper } ]
			}
		}
		unit {
			buildcost { value -50 mods [ { #type golden-age-modifier id goldenage-commercial-landscaping multiplier 0 } ] }
			locname "deco.plaza.hedge.single"
			tags [ plaza ]
		}
	}
	{
		ident { template "deco-plaza-double-hedge" parent "deco-plaza-base" }
		placement {
			size { x 2 y 1 }
		}
		sprite {
			animations {
				default [ { img "plaza-hedge-double.png" atlas hddecos layer wallpaper } ]
			}
		}
		unit {
			buildcost { value -100 mods [ { #type golden-age-modifier id goldenage-commercial-landscaping multiplier 0 } ] }
			locname "deco.plaza.hedge.double"
			tags [ plaza ]
		}
	}
	{
		ident { template "deco-plaza-triple-hedge" parent "deco-plaza-base" }
		placement {
			size { x 3 y 1 }
		}
		sprite {
			animations {
				default [ { img "plaza-hedge-triple.png" atlas hddecos layer wallpaper } ]
			}
		}
		unit {
			buildcost { value -150 mods [ { #type golden-age-modifier id goldenage-commercial-landscaping multiplier 0 } ] }
			locname "deco.plaza.hedge.triple"
			tags [ plaza ]
		}
	}
	{
		ident { template "deco-plaza-bench-single" parent "deco-plaza-base" }
		placement {
			size { x 1 y 1 }
		}
		sprite {
			animations {
				default [ { img "plaza-bench-single.png" atlas hddecos layer wallpaper } ]
			}
		}
		unit {
			buildcost { value -100 mods [ { #type golden-age-modifier id goldenage-commercial-landscaping multiplier 0 } ] }
			locname "deco.plaza.bench.single"
			tags [ plaza-seating plaza ]
		}
	}
	{
		ident { template "deco-plaza-bench-double" parent "deco-plaza-base" }
		placement {
			size { x 2 y 1 }
		}
		sprite {
			animations {
				default [ { img "plaza-bench-double.png" atlas hddecos layer wallpaper } ]
			}
		}
		unit {
			buildcost { value -200 mods [ { #type golden-age-modifier id goldenage-commercial-landscaping multiplier 0 } ] }
			locname "deco.plaza.bench.double"
			tags [ plaza-seating plaza ]
		}
	}
	{
		ident { template "deco-plaza-bench-triple" parent "deco-plaza-base" }
		placement {
			size { x 3 y 1 }
		}
		sprite {
			animations {
				default [ { img "plaza-bench-triple.png" atlas hddecos layer wallpaper } ]
			}
		}
		unit {
			buildcost { value -300 mods [ { #type golden-age-modifier id goldenage-commercial-landscaping multiplier 0 } ] }
			locname "deco.plaza.bench.triple"
			tags [ plaza-seating plaza ]
		}
	}
	{
		ident { template "deco-plaza-tree-small" parent "deco-plaza-base" }
		placement {
			size { x 1 y 1 }
		}
		sprite {
			animations {
				default [ { img "plaza-tree-small.png" atlas hddecos layer wallpaper } ]
			}
		}
		unit {
			buildcost { value -75 mods [ { #type golden-age-modifier id goldenage-commercial-landscaping multiplier 0 } ] }
			locname "deco.plaza.tree.small"
			tags [ plaza-tree plaza ]
		}
	}
	{
		ident { template "deco-plaza-tree-medium" parent "deco-plaza-base" }
		placement {
			size { x 2 y 1 }
		}
		sprite {
			animations {
				default [ { img "plaza-tree-medium.png" atlas hddecos layer wallpaper } ]
			}
		}
		unit {
			buildcost { value -150 mods [ { #type golden-age-modifier id goldenage-commercial-landscaping multiplier 0 } ] }
			locname "deco.plaza.tree.medium"
			tags [ plaza-tree plaza ]
		}
	}
	{
		ident { template "deco-plaza-tree-large" parent "deco-plaza-base" }
		placement {
			size { x 3 y 2 }
		}
		sprite {
			animations {
				default [ { img "plaza-tree-large.png" atlas hddecos layer wallpaper } ]
			}
		}
		unit {
			buildcost { value -300 mods [ { #type golden-age-modifier id goldenage-commercial-landscaping multiplier 0 } ] }
			locname "deco.plaza.tree.large"
			tags [ plaza-tree plaza ]
		}
	}

	;;; outdoor statues
	{
		ident { template "statue-outdoor-one" parent "deco-plaza-base" }
		placement {
			size { x 2 y 1 }
			reqs [
				{ #type consultant-upgrade-requirement id "cons-b-5" }
				{ #type empty-outside-space-requirement }
				{ #type lot-boundaries-requirement }
				{ #type entity-count-requirement type exactly count 0 template statue-outdoor-one onlyenabled #true }
			]
			blockremove always
			blockremoveloc "statue.blockremove"
		}
		sprite {
			animations {
				default [ { img "plaza-statue-one.png" atlas hddecos layer wallpaper } ]
			}
		}
		prestige {
			start 2
			end 1
			penaltyeviction 8
			days 10
		}
		unit {
			locname "statue.one"
			tags [ artworks ]
			visitors [
				{ template "npc-visitor-artpatron" probability 0.25 time { from 10 to 16 } hourlycount 10 }
			]
		}
		tokens {
			tokengrants [
				{ type buzz value 1 hourofday 19 probability 1 }
			]
		}
	}
	{
		ident { template "statue-outdoor-two" parent "deco-plaza-base" }
		placement {
			size { x 2 y 1 }
			reqs [
				{ #type consultant-upgrade-requirement id "cons-b-5" }
				{ #type empty-outside-space-requirement }
				{ #type lot-boundaries-requirement }
				{ #type entity-count-requirement type exactly count 0 template statue-outdoor-two onlyenabled #true }
			]
			blockremove always
			blockremoveloc "statue.blockremove"
		}
		sprite {
			animations {
				default [ { img "plaza-statue-two.png" atlas hddecos layer wallpaper } ]
			}
		}
		prestige {
			start 2
			end 1
			penaltyeviction 8
			days 10
		}
		unit {
			locname "statue.two"
			tags [ artworks ]
			visitors [
				{ template "npc-visitor-artpatron" probability 0.25 time { from 10 to 16 } hourlycount 10 }
			]
		}
		tokens {
			tokengrants [
				{ type buzz value 1 hourofday 19 probability 1 }
			]
		}
	}
	{
		ident { template "statue-outdoor-three" parent "deco-plaza-base" }
		placement {
			size { x 2 y 2 }
			reqs [
				{ #type consultant-upgrade-requirement id "cons-b-5" }
				{ #type empty-outside-space-requirement }
				{ #type lot-boundaries-requirement }
				{ #type entity-count-requirement type exactly count 0 template statue-outdoor-three onlyenabled #true }
			]
			blockremove always
			blockremoveloc "statue.blockremove"
		}
		sprite {
			animations {
				default [ { img "plaza-statue-three.png" atlas hddecos layer wallpaper } ]
			}
		}
		prestige {
			start 2
			end 1
			penaltyeviction 8
			days 10
		}
		unit {
			locname "statue.three"
			buildcost { value -7500 }
			tags [ artworks ]
			visitors [
				{ template "npc-visitor-artpatron" probability 0.25 time { from 10 to 16 } hourlycount 10 }
			]
		}
		tokens {
			tokengrants [
				{ type buzz value 1 hourofday 19 probability 1 }
			]
		}
	}
	{
		ident { template "statue-outdoor-four" parent "deco-plaza-base" }
		placement {
			size { x 4 y 2 }
			reqs [
				{ #type consultant-upgrade-requirement id "cons-b-5" }
				{ #type empty-outside-space-requirement }
				{ #type lot-boundaries-requirement }
				{ #type entity-count-requirement type exactly count 0 template statue-outdoor-four onlyenabled #true }
			]
			blockremove always
			blockremoveloc "statue.blockremove"
		}
		sprite {
			animations {
				default [ { img "plaza-statue-four.png" atlas hddecos layer wallpaper } ]
			}
		}
		prestige {
			start 3
			end 2
			days 10
			penaltyeviction 8
		}
		unit {
			locname "statue.four"
			buildcost { value -15000 }
			visitors [
				{ template "npc-visitor-artpatron" probability 0.25 time { from 10 to 16 } hourlycount 10 }
			]
			tags [ bigstatue artworks ]
		}
		tokens {
			tokengrants [
				{ type buzz value 1 hourofday 19 probability 1 }
			]
		}
	}

	;;; outdoor fountains
	{
		ident { template "plaza-fountain-one" parent "deco-plaza-base" }
		placement {
			size { x 4 y 1 }
			reqs [
				{ #type consultant-upgrade-requirement id "cons-b-2" }
				{ #type consultant-upgrade-requirement id "cons-a-3" }
				{ #type empty-outside-space-requirement }
				{ #type lot-boundaries-requirement }
				{ #type entity-count-requirement type exactly count 0 template plaza-fountain-one onlyenabled #true }
			]
		}
		sprite {
			animations #null
			layouts [ plaza-fountain-one ]
		}
		prestige {
			start 1
			end 1
			days 10
			penaltyeviction 8
		}
		unit {
			locname "plaza.fountain.one"
			tags [ outdoor-fountain fountains ]
			buildcost { value -7500 }
		}
	}
	{
		ident { template "plaza-fountain-one-NR" parent "deco-plaza-base" }
		placement {
			blockremove always
			blockremoveloc "scenario.8.fountain"
			size { x 4 y 1 }
			reqs [
				{ #type consultant-upgrade-requirement id "cons-b-2" }
				{ #type consultant-upgrade-requirement id "cons-a-3" }
				{ #type empty-outside-space-requirement }
				{ #type lot-boundaries-requirement }
				{ #type entity-count-requirement type exactly count 0 template plaza-fountain-one onlyenabled #true }
			]
		}
		sprite {
			animations #null
			layouts [ plaza-fountain-one ]
		}
		prestige {
			start 0
			end 0
		}
		unit {
			locname "plaza.fountain.one.a"
			buildcost { value -7500 }
		}
	}
	{
		ident { template "plaza-fountain-three" parent "deco-plaza-base" }
		placement {
			size { x 2 y 1 }
			reqs [
				{ #type consultant-upgrade-requirement id "cons-b-2" }
				{ #type consultant-upgrade-requirement id "cons-a-3" }
				{ #type empty-outside-space-requirement }
				{ #type lot-boundaries-requirement }
				{ #type entity-count-requirement type exactly count 0 template plaza-fountain-three onlyenabled #true }
			]
		}
		sprite {
			animations #null
			layouts [ plaza-fountain-three ]
		}
		prestige {
			start 2
			end 1
			days 10
			penaltyeviction 8
		}
		unit {
			locname "plaza.fountain.three"
			buildcost { value -5000 }
			tags [ outdoor-fountain fountains ]
		}
	}
	{
		ident { template "plaza-fountain-two" parent "deco-plaza-base" }
		placement {
			size { x 5 y 2 }
			reqs [
				{ #type consultant-upgrade-requirement id "cons-b-2" }
				{ #type consultant-upgrade-requirement id "cons-a-5" }
				{ #type empty-outside-space-requirement }
				{ #type lot-boundaries-requirement }
				{ #type entity-count-requirement type exactly count 0 template plaza-fountain-two onlyenabled #true }
			]
		}
		sprite {
			animations #null ;; todo: move up to parent?
			layouts [ plaza-fountain-two ]
		}
		prestige {
			start 13
			end 2
			days 10
			penaltyeviction 8
		}
		unit {
			locname "plaza.fountain.two"
			buildcost { value -15000 }
			visitors [
				{ template "npc-visitor-artpatron" probability 0.25 time { from 10 to 16 } hourlycount 10 }
			]
			tags [ outdoor-fountain fountains ]
		}
		tokens {
			tokengrants [
				{ type buzz value 1 hourofday 19 probability 1 }
			]
		}
	}

	;;; artworks

	;;; small paintings

	{
		ident { template "painting-small-base" parent "deco-base" }
		placement {
			size { x 1 y 1 }
			reqfloor #true
			reqfinishedfloor #true
			reqs [
				{ #type consultant-upgrade-requirement id "cons-a-1" }
				{ #type floor-requirement parterre #true aboveground #true belowground #false }
				{ #type solid-wall-requirement }
				{ #type entity-count-requirement type atleast count 1 template consultant-aesthetics }
			]
		}
		heatmap {
			produces [
				{ type prettinessHeatmap value 0.5 }
			]
		}
		prestige {
			start 1
			end 1
			days 10
		}
		unit {
			buildcost { value -5000 mods [ { #type golden-age-modifier id goldenage-commercial-landscaping multiplier 0.9 } ] }
			tags [ painting-small artworks ]
		}
	}

	;;;; small paintings

	{
		ident { template "painting-small-one" parent "painting-small-base" }
		sprite {
			animations {
				default [ { img "art-painting-small-one.png" dx 10 dy 59.5 atlas hddecos layer wallpaper } ]
			}
		}
		unit {
			locname "painting.small.one"
			loccat	"painting.small"
		}
	}
	{
		ident { template "painting-small-two" parent "painting-small-base" }
		sprite {
			animations {
				default [ { img "art-painting-small-two.png" dx 11 dy 67.5 atlas hddecos layer wallpaper } ]
			}
		}
		unit {
			locname "painting.small.two"
			loccat	"painting.small"
		}
	}
	{
		ident { template "painting-small-three" parent "painting-small-base" }
		sprite {
			animations {
				default [ { img "art-painting-small-three.png" dx 7 dy 70.5 atlas hddecos layer wallpaper } ]
			}
		}
		unit {
			locname "painting.small.three"
			loccat	"painting.small"
		}
	}

	;;; small sculptures

	{
		ident { template "sculpture-small-base" parent "deco-base" }
		placement {
			size { x 1 y 1 }
			reqfloor #true
			reqfinishedfloor #true
			reqs [
				{ #type consultant-upgrade-requirement id "cons-a-1" }
				{ #type floor-requirement parterre #true aboveground #true belowground #false }
				{ #type entity-count-requirement type atleast count 1 template consultant-aesthetics }
			]
		}
		heatmap {
			produces [
				{ type prettinessHeatmap value 0.5 }
			]
		}
		prestige {
			start 1
			end 1
			days 10
		}
		unit {
			buildcost { value -6000 mods [ { #type golden-age-modifier id goldenage-commercial-landscaping multiplier 0.9 } ] }
			opx { value -100 }
			tags [ sculpture-small artworks ]
		}
	}
	{
		ident { template "sculpture-small-one" parent "sculpture-small-base" }
		sprite {
			animations {
				default [ { img "art-sculpture-small-one.png" dx 13 atlas hddecos layer wallpaper } ]
			}
		}
		unit {
			locname "sculpture.small.one"
			loccat "sculpture.small"
		}
	}
	{
		ident { template "sculpture-small-two" parent "sculpture-small-base" }
		sprite {
			animations {
				default [ { img "art-sculpture-small-two.png" dx 6 atlas hddecos layer wallpaper } ]
			}
		}
		unit {
			locname "sculpture.small.two"
			loccat "sculpture.small"
		}
	}
	{
		ident { template "sculpture-small-three" parent "sculpture-small-base" }
		sprite {
			animations {
				default [ { img "art-sculpture-small-three.png" dx 14 atlas hddecos layer wallpaper } ]
			}
		}
		unit {
			locname "sculpture.small.three"
			loccat "sculpture.small"
		}
	}

	


	;;; medium paintings

	{
		ident { template "painting-medium-base" parent "deco-base" }
		placement {
			size { x 2 y 1 }
			reqfloor #true
			reqfinishedfloor #true
			reqs [
				{ #type consultant-upgrade-requirement id "cons-a-3" }
				{ #type floor-requirement parterre #true aboveground #true belowground #false }
				{ #type solid-wall-requirement }
				{ #type entity-count-requirement type atleast count 1 template consultant-aesthetics-dealer }
			]
		}
		heatmap {
			produces [
				{ type prettinessHeatmap value 0.75 }
			]
		}
		prestige {
			start 2
			end 1
			days 10
		}
		unit {
			buildcost { value -10000 mods [ { #type golden-age-modifier id goldenage-commercial-landscaping multiplier 0.9 } ] }
			tags [ painting-medium artworks ]
		}
	}

	{
		ident { template "painting-medium-one" parent "painting-medium-base" }
		sprite {
			animations {
				default [ { img "art-painting-medium-one.png" dx 23 dy 62.5 atlas hddecos layer wallpaper } ]
			}
		}
		unit {
			locname "painting.medium.one"
			loccat "painting.medium"
		}
	}
	{
		ident { template "painting-medium-two" parent "painting-medium-base" }
		sprite {
			animations {
				default [ { img "art-painting-medium-two.png" dx 23 dy 62.5 atlas hddecos layer wallpaper } ]
			}
		}
		unit {
			locname "painting.medium.two"
			loccat "painting.medium"
		}
	}
	{
		ident { template "painting-medium-three" parent "painting-medium-base" }
		sprite {
			animations {
				default [ { img "art-painting-medium-three.png" dx 23 dy 62.5 atlas hddecos layer wallpaper } ]
			}
		}
		unit {
			locname "painting.medium.three"
			loccat "painting.medium"
		}
	}

	;;; medium sculpture

	{
		ident { template "sculpture-medium-base" parent "deco-base" }
		placement {
			size { x 2 y 1 }
			reqfloor #true
			reqfinishedfloor #true
			reqs [
				{ #type consultant-upgrade-requirement id "cons-a-3" }
				{ #type floor-requirement parterre #true aboveground #true belowground #false }
				{ #type entity-count-requirement type atleast count 1 template consultant-aesthetics-dealer }
			]
		}
		heatmap {
			produces [
				{ type prettinessHeatmap value 0.75 }
			]
		}
		prestige {
			start 2
			end 1
			days 10
		}
		unit {
			buildcost { value -12000 mods [ { #type golden-age-modifier id goldenage-commercial-landscaping multiplier 0.9 } ] }
			opx { value -100 }
			tags [ sculpture-medium artworks ]
		}
	}
	{
		ident { template "sculpture-medium-one" parent "sculpture-medium-base" }
		sprite {
			animations {
				default [ { img "art-sculpture-medium-one.png" dx 24 atlas hddecos layer wallpaper } ]
			}
		}
		unit {
			locname "sculpture.medium.one"
			loccat "sculpture.medium"
		}
	}
	{
		ident { template "sculpture-medium-two" parent "sculpture-medium-base" }
		sprite {
			animations {
				default [ { img "art-sculpture-medium-two.png" dx 5 atlas hddecos layer wallpaper } ]
			}
		}
		unit {
			locname "sculpture.medium.two"
			loccat "sculpture.medium"
		}
	}


	;;; lobby mural

	{
		ident { template "painting-mural" parent "deco-base" }
		placement {
			size { x 5 y 1 } 
			reqfloor #true
			reqfinishedfloor #true
			reqs [
				{ #type consultant-upgrade-requirement id "cons-a-5" }
				{ #type floor-requirement parterre #true aboveground #false belowground #false }
				{ #type solid-wall-requirement }
				{ #type entity-count-requirement type atleast count 1 template consultant-aesthetics-gallery }
				{ #type entity-count-requirement type exactly count 0 template "painting-mural" onlyenabled #true }
			]
		}
		sprite {
			animations {
				default [ { img "art-large-mural.png" dy -4 atlas hddecos layer wallpaper } ]
			}
		}
		heatmap {
			produces [
				{ type prettinessHeatmap value 1 }
			]
		}
		prestige {
			start 3
			end 2
			days 20
			penaltyeviction -20
		}
		unit {
			buildcost { value -25000 mods [ { #type golden-age-modifier id goldenage-commercial-landscaping multiplier 0.9 } ] }
			visitors [
				{ template "npc-visitor-artpatron" probability 1 time { from 10 to 16 } hourlycount 10 }
			]
			tags [ mural artworks ]
			locname "art.mural"
			loccat "art.mural.cat"
		}
		tokens {
			tokengrants [
				{ type buzz value 1 hourofday 19 probability 1 }
				{ type favors value 1 hourofday 20 probability 1  }
			]
		}
	}
	{
		ident { template "painting-mural-NR" parent "deco-base" }
		placement {
			size { x 5 y 1 } 
			reqfloor #true
			reqfinishedfloor #true
			reqs [
				{ #type solid-wall-requirement }
				{ #type entity-count-requirement type exactly count 0 template "painting-mural" onlyenabled #true }
			]
			blockremove always
			blockremoveloc "mural.scenario.9"
		}
		sprite {
			animations {
				default [ { img "art-large-mural.png" dy -4 atlas hddecos layer wallpaper } ]
			}
		}
		heatmap {
			produces [
				{ type prettinessHeatmap value 1 }
			]
		}
		prestige {
			start 1
			end 1
			days 1
		}
		unit {
			buildcost { value -20000 mods [ { #type golden-age-modifier id goldenage-commercial-landscaping multiplier 0.9 } ] }
			visitors [
				{ template "npc-visitor-artpatron" probability 1 time { from 10 to 16 } hourlycount 2 }
			]
			locname "art.mural.scnario.9"
			loccat "art.mural.cat"
		}
		tokens {
			tokengrants [
				{ type buzz value 1 hourofday 19 probability 1 }
				{ type favors value 1 hourofday 20 probability 1  }
			]
		}
	}

	;;; large indoor sculpture

	{
		ident { template "sculpture-large-inside" parent "deco-base" }
		placement {
			size { x 5 y 1 }
			reqfloor #true
			reqfinishedfloor #true
			reqs [
				{ #type consultant-upgrade-requirement id "cons-a-5" }
				{ #type floor-requirement parterre #true aboveground #false belowground #false }
				{ #type solid-wall-requirement }
				{ #type entity-count-requirement type atleast count 1 template consultant-aesthetics-gallery }
				{ #type entity-count-requirement type exactly count 0 template "sculpture-large-inside" onlyenabled #true } ;; THIS MIGHT INCREASE BASED ON ASSETS
			]
		}
		sprite {
			animations {
				default [ { img "art-sculpture-large.png" dx 9.5 atlas hddecos layer wallpaper } ]
			}
		}
		heatmap {
			produces [
				{ type prettinessHeatmap value 1 }
			]
		}
		prestige {
			start 3
			end 2
			days 10
			penaltyeviction -10
		}
		unit {
			buildcost { value -25000 mods [ { #type golden-age-modifier id goldenage-commercial-landscaping multiplier 0.9 } ] }
			opx { value -500 }
			visitors [
				{ template "npc-visitor-artpatron" probability 1 time { from 10 to 16 } hourlycount 10 }
			]
			tags [ sculpture sculpture-large-inside artworks ]
			locname "sculpture.large.inside"
			loccat "sculpture.large.inside.cat"
		}
		tokens {
			tokengrants [
				{ type buzz value 1 hourofday 19 probability 1 }
				{ type favors value 1 hourofday 20 probability 1  }
			]
		}
	}

	;;; indoor fountains

	{
		ident { template "fountain-indoor-base" parent "deco-base" }
		placement {
			size { x 2 y 1 }
			reqfloor #true
			reqfinishedfloor #true
			reqs [
				{ #type consultant-upgrade-requirement id "cons-a-3" }
				{ #type floor-requirement parterre #true aboveground #true belowground #false }
			]
		}
		heatmap {
			produces [
				{ type prettinessHeatmap value 1 }
			]
		}
		prestige {
			start 1
			end 1
			days 10
		}
		unit {
			buildcost { value -10000 mods [ { #type golden-age-modifier id goldenage-commercial-landscaping multiplier 0.9 } ] }
		}
	}
	{
		ident { template "fountain-indoor-one" parent "fountain-indoor-base" }
		sprite {
			animations #null
			layouts [ fountain-indoor-one ]
		}
		unit {
			locname "fountain.indoor.one"
			tags [ indoor-fountain fountains ]
		}
	}
	{
		ident { template "fountain-indoor-two" parent "fountain-indoor-base" }
		sprite {
			animations #null
			layouts [ fountain-indoor-two ]
		}
		unit {
			locname "fountain.indoor.two"
			tags [ indoor-fountain fountains ]
		}
	}
	{
		ident { template "fountain-indoor-three" parent "fountain-indoor-base" }
		sprite {
			animations #null
			layouts [ fountain-indoor-three ]
		}
		unit {
			locname "fountain.indoor.three"
			tags [ indoor-fountain fountains ]
		}
	}

	;;;;;;; decos

	{
		ident { template "just-decos" parent "deco-base" }
		placement {
			size { x 1 y 1 }
			reqfloor #true
			reqfinishedfloor #true
			multiplace #true
		}
	}
	{
		ident { template "just-decos-solid" parent "deco-base" }
		placement {
			size { x 1 y 1 }
			reqfloor #true
			reqfinishedfloor #true
			reqs [
				{ #type solid-wall-requirement }
			]
			multiplace #true
		}
	}

	;;;; lighting
	 {
	 	ident { template "deco-light-globes" parent "just-decos" }
	 	sprite {
	 		animations {
	 			default [ { img "deco-light-globes.png" atlas hddecos layer worker dy 102 } ]
	 		}
	 	}
	 	unit {
	 		locname "deco.light.globes"
	 	}
	 }
	 {
	 	ident { template "deco-light-sconce" parent "just-decos-solid" }
	 	sprite {
	 		animations {
	 			default [ { img "deco-light-sconce.png" dy 88 dx 2 atlas hddecos layer worker } ]
	 		}
	 	}
	 	unit {
	 		locname "deco.light.sconce"
	 	}
	 }
	 {
	 	ident { template "deco-light-green" parent "just-decos" }
	 	sprite {
	 		animations {
	 			default [ { img "deco-light-green.png" dx 5 dy 111 atlas hddecos layer worker } ]
	 		}
	 	}
	 	unit {
	 		locname "deco.light.green"
	 	}
	 }
	 {
	 	ident { template "deco-light-fluorescent" parent "just-decos" }
	 	sprite {
	 		animations {
	 			default [ { img "deco-light-fluorescent.png" dx 19 dy 121.5 atlas hddecos layer worker } ]
	 		}
	 	}
	 	unit {
	 		locname "deco.light.fluorescent"
	 	}
	 }
	 ;;; furniture

	 {
	 	ident { template "deco-furniture-cabinet-twodrawers" parent "just-decos" }
	 	sprite {
	 		animations {
	 			default [
	 				{ img "deco-cabinet-two-drawers.png" dx 5 atlas hddecos layer worker }
	 			]
	 		}
	 	}
	 	unit {
	 		locname "deco.furniture.cabinet.twodrawers"
	 	}
	 }
	 {
	 	ident { template "deco-furniture-cabinet-lightbrown" parent "just-decos" }
	 	sprite {
	 		animations {
	 			default [
	 				{ img "deco-cabinet-tall-double-door.png" atlas hddecos layer worker }
	 			]
	 		}
	 	}
	 	unit {
	 		locname "deco.furniture.cabinet.lightbrown"
	 	}
	 }
	 {
	 	ident { template "deco-furniture-cabinet-darkbrown" parent "just-decos" }
	 	sprite {
	 		animations {
	 			default [
	 				{ img "deco-cabinet-tall.png" dx 5 atlas hddecos layer worker }
	 			]
	 		}
	 	}
	 	unit {
	 		locname "deco.furniture.cabinet.darkbrown"
	 	}
	 }
	 {
	 	ident { template "deco-seating-blue" parent "just-decos" }
	 	sprite {
	 		animations {
	 			default [ { img "deco-seating-blue.png" atlas hddecos layer worker  } ]
	 		}
	 	}
	 	unit {
	 		locname "deco.furniture.seating.orange"
	 	}
	 }
	 {
	 	ident { template "deco-seating-green" parent "just-decos" }
	 	sprite {
	 		animations {
	 			default [ { img "deco-seating-green.png" atlas hddecos layer worker  } ]
	 		}
	 	}
	 	unit {
	 		locname "deco.furniture.seating.blue"
	 	}
	 }
	 {
	 	ident { template "deco-seating-orange" parent "just-decos" }
	 	sprite {
	 		animations {
	 			default [ { img "deco-seating-orange.png" atlas hddecos layer worker  } ]
	 		}
	 	}
	 	unit {
	 		locname "deco.furniture.seating.green"
	 	}
	 }

	 ;; indoor plants
	 {
	 	ident { template "deco-plant-ficus" parent "just-decos" }
	 	sprite {
	 		animations {
	 			default [ { img "deco-plant-ficus.png" dx 2 atlas hddecos layer worker } ]
	 		}
	 	}
	 	unit {
	 		locname "deco.plant.ficus"
	 	}
	 }
	 {
	 	ident { template "deco-plant-palm" parent "just-decos" }
	 	sprite {
	 		animations {
	 			default [ { img "deco-plant-palm.png" dx 10 atlas hddecos layer worker } ]
	 		}
	 	}
	 	unit {
	 		locname "deco.plant.palm"
	 	}
	 }
	 {
	 	ident { template "deco-plant-one" parent "just-decos" }
	 	sprite {
	 		animations {
	 			default [ 
	 				{ img "deco-plant-one.png" dx 12 atlas hddecos layer worker }
	 			]
	 		}
	 	}
	 	unit {
	 		locname "deco.plant.one"
	 	}
	 }
	 {
	 	ident { template "deco-plant-two" parent "just-decos" }
	 	sprite {
	 		animations {
	 			default [ 
	 				{ img "deco-plant-two.png" dx 10 atlas hddecos layer worker }
	 			]
	 		}
	 	}
	 	unit {
	 		locname "deco.plant.two"
	 	}
	 }
	 {
	 	ident { template "deco-plant-three" parent "just-decos" }
	 	sprite {
	 		animations {
	 			default [ 
	 				{ img "deco-plant-three.png" atlas hddecos layer worker }
	 			]
	 		}
	 	}
	 	unit {
	 		locname "deco.plant.three"
	 	}
	 }

	 ;;; misc decos

	 {
	 	ident { template "deco-misc-clock" parent "just-decos-solid" }
	 	sprite {
	 		animations {
	 			default [ { img "deco-misc-clock.png" dx 13 dy 92.5 atlas hddecos layer worker } ]
	 		}
	 	}
	 	unit {
	 		locname "deco.misc.clock"
	 	}
	 }
	 {
	 	ident { template "deco-misc-sunclock" parent "just-decos-solid" }
	 	sprite {
	 		animations {
	 			default [ { img "deco-misc-sunclock.png" dx 2 dy 82 atlas hddecos layer worker } ]
	 		}
	 	}
	 	unit {
	 		locname "deco.misc.sunclock"
	 	}
	 }
	 {
	 	ident { template "deco-misc-trashcan" parent "just-decos" }
	 	sprite {
	 		animations {
	 			default [ { img "deco-misc-trashcan.png" dx 14 atlas hddecos layer worker } ]
	 		}
	 	}
	 	unit {
	 		locname "deco.misc.trashcan"
	 	}
	 }
	 {
	 	ident { template "deco-misc-water" parent "just-decos" }
	 	sprite {
	 		animations {
	 			default [ { img "deco-misc-water.png" dx 14 atlas hddecos layer worker } ]
	 		}
	 	}
	 	unit {
	 		locname "deco.misc.water"
	 	}
	 }


	;;;;;;;;;;;;;;;;;;;;;;;;;;; consultant offices

	{
		ident { template "consultant-base" }
		notif { }
		placement {
			insertinmap #true
			insertvfx #true
			reqs [ ]
			buildsite #true
			buildhours 0.9
			onremove rubble
		}
		selection {
			mode deco
		}
		sprite {
			borders around
			atlas hdwalls
			layouts [ civic-layout-one ]
		}
		unit { }
		service {
			servicetype retail
		}
	}
	{
		ident { template "consultant-aesthetics" parent "consultant-base" }
		placement {
			size { x 4 y 1 }
			reqs [
				{ #type floor-requirement parterre #true aboveground #true belowground #false }
				{ #type entity-count-requirement type exactly count 0 template "consultant-aesthetics" onlyenabled #true }
				{ #type token-requirement type favors value 10 }
			]
		}
		sprite {
			layouts [ consultant-aesthetics ]
		}
		workplace {
			workers 1
			workertemplates [ "npc-office-office.v-office.8" ]
			workhours { from 11 to 16 }
		}
		unit {
			locname "consultant.a"
			locdesc "consultant.a.desc"
			loccat 	"consultant.a" 

			tags [ consultant decorator ]
			buildcost { value -500 }
		}
	}
	{
		ident { template "art-base" parent "workplace-base" }
		heatmap { }
		placement {
		}
	}
	{
		ident { template "consultant-aesthetics-dealer" parent "consultant-base" }
		placement {
			size { x 10 y 1 }
			reqs [
				{ #type entity-count-requirement type atleast count 1 template "consultant-aesthetics" }
				{ #type entity-count-requirement type exactly count 0 template "consultant-aesthetics-dealer" onlyenabled #true }
                { #type consultant-upgrade-requirement id "cons-a-2" }
                { #type floor-requirement parterre #true aboveground #true belowground #false }
			]
		}
		service {
		}
		workplace {
			workers 2
			workertemplates [ "npc-office-office.b-office.admin.2" "npc-office-office.v-office.8" ]
			workhours { from 11 to 16 }
		}
		sprite {
			layouts [ consultant-aesthetics-dealer ]
		}
		unit {
			locname "consultant.dealer"
			locdesc	"consultant.dealer.desc"
			loccat 	"consultant.dealer.cat"
			tags [ consultant dealer ]
			buildcost { value -2000 }
			satisfaction { value 0 mods[
					
				] }
			needutilities [  ]
			visitors [
				{ template "npc-visitor-artpatron" probability 0.75 time { from 11 to 16 } hourlycount 2 }
			]
		}
		prestige {
			start 1
			end 1
			penaltyeviction 4
			days 10
		}
		tokens {
			happybuzzprob 1
			upsetbuzzprob 1
		}
	}
	{
		ident { template "consultant-aesthetics-gallery" parent "consultant-base" }
		placement {
			size { x 12 y 1 }
			reqs [
				{ #type entity-count-requirement type atleast count 1 template "consultant-aesthetics" }
				{ #type entity-count-requirement type atleast count 1 template "consultant-aesthetics-dealer" }
				{ #type entity-count-requirement type exactly count 0 template "consultant-aesthetics-gallery" onlyenabled #true }
				{ #type floor-requirement parterre #true aboveground #true belowground #false }
				{ #type consultant-upgrade-requirement id "cons-a-4" }
			]
		}
		workplace {
			workers 2
			workertemplates [ "npc-office-office.b-office.admin.2" "npc-office-office.v-office.8" ]
			workhours { from 11 to 16 }
		}
		service {
		}
		sprite {
			layouts [ consultant-aesthetics-gallery ]
		}
		heatmap {
			produces [
				{ type noiseHeatmap value 0.6 }
			]
		}
		unit {
			locname "consultant.gallery"
			locdesc "consultant.gallery.desc"
			loccat "consultant.gallery.cat"
			tags [ consultant gallery ]
			buildcost { value -5000 }
			satisfaction { value 0 mods [
					{ #type utilities-modifier type utilpower value -1 }
					{ #type utilities-modifier type utilphone value -1 }
					{ #type heatmap-modifier map smellHeatmap value -0.2 }
					{ #type heatmap-modifier map trafficHeatmap value 0.2 }
				] }
			needutilities [ { type utilpower value 1 } { type utilphone value 1 } ]
			visitors [
				{ template "npc-visitor-artpatron" probability 1 time { from 11 to 16 } hourlycount 4 }
			]
		}
		tokens {
			happybuzzprob 1
			upsetbuzzprob 1
		}
		prestige {
			start 2
			end 2
			penaltyeviction 5
			days 10
		}
	}
	{
		ident { template "consultant-civics" parent "consultant-base" }
		placement {
			size { x 10 y 1 }
			reqs [
                { #type prestige-requirement value 1 }
                { #type entity-count-requirement type exactly count 0 template "consultant-civics" onlyenabled #true }
                { #type floor-requirement parterre #true aboveground #true belowground #false }
                { #type token-requirement type favors value 10 }
			]
		}
		sprite {
			layouts [ consultant-civics ]
		}
		workplace {
			workers 3
			workertemplates [ "npc-office-office.b-office.admin.2" "npc-office-office.a-office.8" "npc-office-office.a-office.8" ]
			workhours { from 11 to 16 }
		}
		unit {
			locname "consultant.civic"
			locdesc "consultant.civic.desc"
			loccat "consultant.civic"
			tags [ consultant lobbyist ]
			buildcost { value -500 }
			satisfaction { value 0 mods [
				
				] }
			needutilities [ ]
			visitors [
				{ template "npc-visitor-one" probability 0.75 time { from 11 to 16 } hourlycount 1 }
			]
		}
		tokens {
			tokengrants [ { type favors value 2 hourofday 18 probability 0.5 } ]
		}
	}
	{
		ident { template "consultant-building" parent "consultant-base" }
		placement {
			size { x 8 y 1 }
			reqs [
                { #type prestige-requirement value 1 }
                { #type entity-count-requirement type exactly count 0 template "consultant-building" onlyenabled #true }
                { #type floor-requirement parterre #true aboveground #true belowground #false }
                { #type token-requirement type favors value 10 }
			]
		}
		sprite {
			layouts [ consultant-building ]
		}
		workplace {
			workers 2
			workhours { from 9 to 17 }
			workertemplates [ "npc-office-office.b-office.admin.2" "npc-office-office.a-office.8" ]
		}
		unit {
			locname "consultant.building"
			locdesc "consultant.building.desc"
			loccat "consultant.building" ;placeholder
			tags [ consultant building-manager ]
			buildcost { value -500 }
		}
	}


	;; preorder decos

	{
		ident { template "deco-preorder-chair-brno" parent "just-decos" }
		sprite {
			animations {
				default [ { img "chair-brno.png" atlas preorder layer worker } ]
			}
		}
		unit {
			locname "deco.preorder-brno"
		}
	}
	{
		ident { template "deco-preorder-chair-barcelona" parent "just-decos" }
		sprite {
			animations {
				default [ { img "chair-barcelona.png" atlas preorder layer worker } ]
			}
		}
		unit {
			locname "deco.preorder-barcelona"
		}
	}
	{
		ident { template "deco-preorder-light-standing" parent "just-decos" }
		sprite {
			animations {
				default [ { img "light-standing.png" atlas preorder layer worker } ]
			}
		}
		unit {
			locname "deco.preorder-light"
		}
	}
	{
		ident { template "deco-preorder-statue" parent "just-decos" }
		sprite {
			animations {
				default [ { img "statue-barcelona.png" atlas preorder layer worker } ]
			}
		}
		unit {
			locname "deco.preorder-statue"
		}
	}
	{
		ident { template "deco-preorder-table" parent "just-decos" }
		sprite {
			animations {
				default [ { img "table-modern.png" atlas preorder layer worker } ]
			}
		}
		unit {
			locname "deco.preorder-table"
		}
	}
	{
		ident { template "deco-preorder-fountain" parent "deco-base" }
		placement {
			size { x 2 y 1 }
		}
		sprite {
			animations #null
			layouts [ fountain-cubist ]
		}
		unit {
			locname "deco.preorder-fountain"
		}
	}


] }
