_G = GLOBAL

if GetModConfigData("Detect_range") == 1 then
    _G.TUNING.FIRE_DETECTOR_RANGE = 15
elseif GetModConfigData("Detect_range") == 2 then
    _G.TUNING.FIRE_DETECTOR_RANGE = 18
elseif GetModConfigData("Detect_range") == 3 then
    _G.TUNING.FIRE_DETECTOR_RANGE = 20
elseif GetModConfigData("Detect_range") == 4 then
    _G.TUNING.FIRE_DETECTOR_RANGE = 22  
end

local throw_range
if GetModConfigData("Throw_range") == 1 then
    throw_rangeE = 15
elseif GetModConfigData("Throw_range") == 2 then
    throw_range = 18
elseif GetModConfigData("Throw_range") == 3 then
    throw_range = 20
elseif GetModConfigData("Throw_range") == 4 then
    throw_range = 22  
end





local require = _G.require
local easing = require("easing")
local SpawnPrefab = _G.SpawnPrefab
--Called from stategraph
local function LaunchProjectilePlus(inst, targetpos)
    local x, y, z = inst.Transform:GetWorldPosition()

    local projectile = SpawnPrefab("snowball")
    projectile.Transform:SetPosition(x, y, z)

    --V2C: scale the launch speed based on distance
    --     because 15 does not reach our max range.
    local dx = targetpos.x - x
    local dz = targetpos.z - z
    local rangesq = dx * dx + dz * dz
    
    local maxrange = throw_range
    --local function linear(t, b, c, d)
    --	return c * t / d + b
    --end


    local speed = easing.linear(rangesq,throw_range, 3, maxrange * maxrange)
    projectile.components.complexprojectile:SetHorizontalSpeed(speed)
    projectile.components.complexprojectile:SetGravity(-25)
    projectile.components.complexprojectile:Launch(targetpos, inst, inst)
end

local function ReplaceFireDetector(inst)
	inst.LaunchProjectile = LaunchProjectilePlus
end

AddPrefabPostInit("firesuppressor",ReplaceFireDetector)
