﻿/*
Navicat MySQL Data Transfer

Source Server         : localhost_3306
Source Server Version : 50133
Source Host           : localhost:3306
Source Database       : bhskq

Target Server Type    : MYSQL
Target Server Version : 50133
File Encoding         : 65001

Date: 2016-06-06 02:07:56
*/
use bhskq;
SET FOREIGN_KEY_CHECKS=0;
-- ----------------------------
-- Table structure for `bhs_checkexact`
-- ----------------------------
DROP TABLE IF EXISTS `bhs_checkexact`;
CREATE TABLE `bhs_checkexact` (
  `exactid` int(11) NOT NULL AUTO_INCREMENT COMMENT '修改日志ID',
  `user_id` varchar(12) DEFAULT '0' COMMENT '员工ID号',
  `checktime` datetime DEFAULT '0000-00-00 00:00:00' COMMENT '签到/签退时间',
  `checktype` smallint(1) DEFAULT '0' COMMENT '原来的签到/签退标志：0-签到，1-签退',
  `isadd` smallint(1) DEFAULT '0' COMMENT '是否新增的记录-1新增',
  `yuanyin` varchar(200) DEFAULT NULL COMMENT '修改考勤记录的原因',
  `ismodify` smallint(1) DEFAULT '0' COMMENT '是否仅仅是修改原始记录 1.修改原始记录',
  `isdelete` smallint(1) DEFAULT '0' COMMENT '是否是删除的记录 1.删除',
  `modifyby` varchar(20) DEFAULT NULL COMMENT '操作员',
  `optdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '登记/输入记录的时间 ',
  PRIMARY KEY (`exactid`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for `bhs_dept`
-- ----------------------------
DROP TABLE IF EXISTS `bhs_dept`;
CREATE TABLE `bhs_dept` (
  `dept_id` int(11) NOT NULL AUTO_INCREMENT,
  `parent_id` int(11) NOT NULL COMMENT 'tree用的parentId',
  `dept_name` varchar(20) NOT NULL COMMENT '部门名称',
  `dept_desc` varchar(200) DEFAULT '' COMMENT '0┆公司默认班次；1┆部门默认班次；3┆班次；4┆加班;5┆倒班┆开始班次',
  PRIMARY KEY (`dept_id`)
) ENGINE=InnoDB AUTO_INCREMENT=77 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of bhs_dept
-- ----------------------------
INSERT INTO bhs_dept VALUES ('27', '0', '公司名称', '');

-- ----------------------------
-- Table structure for `bhs_user_position`
-- ----------------------------
DROP TABLE IF EXISTS `bhs_user_position`;
CREATE TABLE `bhs_user_position` (
  `user_position_id` int(11) NOT NULL AUTO_INCREMENT COMMENT '岗位标识自动增长',
  `position_name` varchar(50) NOT NULL COMMENT '岗位名称',
  PRIMARY KEY (`user_position_id`)
) ENGINE=InnoDB AUTO_INCREMENT=85 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for `bhs_employee_info`
-- ----------------------------
DROP TABLE IF EXISTS `bhs_employee_info`;
CREATE TABLE `bhs_employee_info` (
  `user_id` varchar(12) NOT NULL DEFAULT '' COMMENT '工号',
  `user_name` varchar(25) NOT NULL DEFAULT '' COMMENT '用户名',
  `user_position_id` int(11) DEFAULT NULL COMMENT '用户岗位',
  `hiredday` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '入职日期',
  `verificationmethod` smallint(6) DEFAULT NULL COMMENT '验证方式：除256的余数表示签到的方式: 0-密码；1-指纹；2-卡。大于256表示该记录已\r\n\r\n经被确认',
  `mverifypass` varchar(10) DEFAULT NULL COMMENT '考勤验证密码',
  `securityflags` smallint(1) DEFAULT NULL COMMENT '管理员标志 3-管理员，0-普通用户',
  `isatt` smallint(1) DEFAULT NULL COMMENT '考勤有效:0-无效，1-有效',
  `optpassword` varchar(20) DEFAULT NULL COMMENT '口令',
  `mobile` varchar(20) DEFAULT NULL COMMENT '移动电话',
  `fphone` varchar(20) DEFAULT NULL COMMENT '家庭电话',
  `email` varchar(25) DEFAULT NULL,
  `ssn` varchar(20) DEFAULT NULL COMMENT '身份证/证件号',
  `user_gender` tinyint(1) DEFAULT NULL COMMENT '性别用户性别 1:男性，0:女性，-1:未选，null 未选',
  `minzu` varchar(8) DEFAULT NULL COMMENT '民族',
  `state` varchar(2) DEFAULT NULL COMMENT '省代码',
  `city` varchar(50) DEFAULT NULL COMMENT '市代码',
  `stree` varchar(50) DEFAULT NULL COMMENT '家庭地址',
  `zip` varchar(12) DEFAULT NULL COMMENT '邮编',
  `classname` varchar(55) DEFAULT NULL COMMENT '班次名(0┆公司默认班次；1┆部门默认班次；3┆班次；4┆加班;5┆轮班┆开始班次)',
  PRIMARY KEY (`user_id`),
  KEY `fk_user_positon` (`user_position_id`),
  CONSTRAINT `fk_user_positon` FOREIGN KEY (`user_position_id`) REFERENCES `bhs_user_position` (`user_position_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for `bhs_checkinout`
-- ----------------------------
DROP TABLE IF EXISTS `bhs_checkinout`;
CREATE TABLE `bhs_checkinout` (
  `user_id` varchar(12) NOT NULL,
  `checktime` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '签到/签退时间 ',
  `checktype` smallint(1) DEFAULT '0' COMMENT '签到/签退标志：0-签到，1-签退',
  `verifycode` int(6) DEFAULT '0' COMMENT '验证方式：除256的余数表示签到的方式: 0-密码；1-指纹；2-卡,3--公出，4--记假。大于256表示该记录已经被确认，在于处理时不进行处理,',
  `sensorid` varchar(5) DEFAULT NULL COMMENT '采集数据的考勤终端/设备ID',
  PRIMARY KEY (`user_id`,`checktime`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for `bhs_illegal_action`
-- ----------------------------
DROP TABLE IF EXISTS `bhs_illegal_action`;
CREATE TABLE `bhs_illegal_action` (
  `opt_id` int(11) NOT NULL AUTO_INCREMENT COMMENT '修改日志ID',
  `user_id` varchar(12) DEFAULT '0' COMMENT '员工ID号',
  `isadd` smallint(1) DEFAULT '0' COMMENT '是否新增的记录-1新增',
  `ismodify` smallint(1) DEFAULT '0' COMMENT '是否仅仅是修改原始记录 1.修改原始记录',
  `isdelete` smallint(1) DEFAULT '0' COMMENT '是否是删除的记录 1.删除',
  `yuanyin` varchar(200) DEFAULT NULL COMMENT '修改考勤记录的原因',
  `modifyby` varchar(20) DEFAULT NULL COMMENT '操作员',
  `optdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '登记/输入记录的时间 ',
  PRIMARY KEY (`opt_id`)
) ENGINE=InnoDB AUTO_INCREMENT=55 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for `bhs_indent`
-- ----------------------------
DROP TABLE IF EXISTS `bhs_indent`;
CREATE TABLE `bhs_indent` (
  `user_id` varchar(12) NOT NULL,
  `indentity` varchar(9) NOT NULL,
  `fendeptid` varchar(50) DEFAULT NULL COMMENT '部门ID',
  `fenmachno` varchar(50) DEFAULT NULL COMMENT '机器号',
  PRIMARY KEY (`user_id`,`indentity`),
  KEY `user_indent` (`user_id`),
  CONSTRAINT `user_indent_0` FOREIGN KEY (`user_id`) REFERENCES `bhs_employee_info` (`user_id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for `bhs_user_dept`
-- ----------------------------
DROP TABLE IF EXISTS `bhs_user_dept`;
CREATE TABLE `bhs_user_dept` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(12) NOT NULL,
  `dept_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_bhs_user_dept_user_id` (`user_id`) USING BTREE,
  KEY `fk_bhs_dept` (`dept_id`),
  CONSTRAINT `fk_bhs_dept` FOREIGN KEY (`dept_id`) REFERENCES `bhs_dept` (`dept_id`),
  CONSTRAINT `fk_bhs_user` FOREIGN KEY (`user_id`) REFERENCES `bhs_employee_info` (`user_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=973 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for `bhs_dev`
-- ----------------------------
DROP TABLE IF EXISTS `bhs_dev`;
CREATE TABLE `bhs_dev` (
  `devno` varchar(10) NOT NULL COMMENT '设备名称',
  `machno` smallint(2) NOT NULL DEFAULT '0' COMMENT '机器号',
  `comtype` varchar(11) NOT NULL DEFAULT 'TCP/IP' COMMENT '通讯方式',
  `devip` varchar(16) DEFAULT NULL COMMENT 'IP地址',
  `port` varchar(5) DEFAULT '4370' COMMENT '端口号',
  `compwd` smallint(6) DEFAULT NULL COMMENT '通讯密码',
  PRIMARY KEY (`devno`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for `bhs_class`
-- ----------------------------
INSERT INTO bhs_dev VALUES ('a', '1', 'TCP/IP', '192.168.0.101', '4370', null);

DROP TABLE IF EXISTS `bhs_class`;
CREATE TABLE `bhs_class` (
  `classname` varchar(25) NOT NULL COMMENT '班次名',
  `starttime` date NOT NULL DEFAULT '2016-06-07' COMMENT '开始时间',
  `unitvalue` smallint(3) NOT NULL DEFAULT '0' COMMENT '间隔单位',
  `unitname` varchar(2) NOT NULL DEFAULT '周' COMMENT '月天周',
  `kqtimes` tinyint(1) NOT NULL DEFAULT '0' COMMENT '考勤次数',
  `kqvalue` varchar(25) DEFAULT NULL COMMENT '考勤',
  `kqperiod` varchar(50) DEFAULT NULL COMMENT '考勤时段',
  `kqrule` smallint(3) NOT NULL DEFAULT '5' COMMENT '考勤规则',
  `kqrule0` smallint(3) NOT NULL DEFAULT '5' COMMENT '考勤规则',
  `holiday` varchar(250) DEFAULT NULL COMMENT '休天',
  `isover` tinyint(1) NOT NULL DEFAULT '0' COMMENT '加班',
  `defaultclass` tinyint(1) NOT NULL DEFAULT '0' COMMENT '默认班次',
  PRIMARY KEY (`classname`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for `bhs_loopclass`
-- ----------------------------
DROP TABLE IF EXISTS `bhs_loopclass`;
CREATE TABLE `bhs_loopclass` (
  `loopclassname` varchar(25) NOT NULL COMMENT '倒班班名',
  `classname` varchar(250) DEFAULT NULL COMMENT '班名',
  `intervalue` varchar(5) DEFAULT NULL COMMENT '间隔',
  `starttime` date NOT NULL DEFAULT '2016-01-01' COMMENT '开始时间',
  `endtime` date NOT NULL DEFAULT '2050-01-01' COMMENT '结束时间',
  PRIMARY KEY (`loopclassname`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for `bhs_speday`
-- ----------------------------
DROP TABLE IF EXISTS `bhs_speday`;
CREATE TABLE `bhs_speday` (
  `user_id` varchar(12) NOT NULL,
  `startspecday` datetime NOT NULL DEFAULT '2016-01-01 00:00:00' COMMENT '开始日期',
  `endspecday` datetime DEFAULT '2050-01-01 00:00:00' COMMENT '结束日期',
  `dateid` smallint(6) NOT NULL DEFAULT '-1' COMMENT '例外类型，0为公出，-1为注释,1病假，2.事假，3.探亲假',
  `yuanying` varchar(200) DEFAULT NULL COMMENT '例外的原因',
  `workday` varchar(6) DEFAULT NULL,
  `isjiaban` smallint(6) DEFAULT '0' COMMENT '0.正常班(一班)1.加班(二班)',
  `optdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '登记/输入记录的时间 ',
  PRIMARY KEY (`user_id`,`startspecday`,`dateid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for `bhs_sysparams`
-- ----------------------------
DROP TABLE IF EXISTS `bhs_sysparams`;
CREATE TABLE `bhs_sysparams` (
  `keyparams` tinyint(1) NOT NULL,
  `valueparams` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`keyparams`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for `bhs_district`
-- ----------------------------
DROP TABLE IF EXISTS `bhs_district`;
CREATE TABLE `bhs_district` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `tmpid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `level` tinyint(4) unsigned NOT NULL DEFAULT '0',
  `usetype` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `upid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `displayorder` smallint(6) NOT NULL DEFAULT '0',
  `tupid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `upid` (`upid`,`displayorder`),
  KEY `tmpid` (`tmpid`)
) ENGINE=InnoDB AUTO_INCREMENT=45058 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of bhs_district
-- ----------------------------
INSERT INTO bhs_district VALUES ('1', '1', '中国', '0', '0', '0', '9999', '0'),
('2', '1', '北京', '1', '3', '1', '1', '0'),
('3', '2', '天津', '1', '3', '1', '2', '0'),
('4', '3', '河北省', '1', '3', '1', '9999', '0'),
('5', '4', '山西省', '1', '3', '1', '9999', '0'),
('6', '5', '内蒙古自治区', '1', '3', '1', '9999', '0'),
('7', '6', '辽宁省', '1', '3', '1', '9999', '0'),
('8', '7', '吉林省', '1', '3', '1', '9999', '0'),
('9', '8', '黑龙江省', '1', '3', '1', '9999', '0'),
('10', '9', '上海', '1', '3', '1', '3', '0'),
('11', '10', '江苏省', '1', '3', '1', '9999', '0'),
('12', '11', '浙江省', '1', '3', '1', '9999', '0'),
('13', '12', '安徽省', '1', '3', '1', '9999', '0'),
('14', '13', '福建省', '1', '3', '1', '9999', '0'),
('15', '14', '江西省', '1', '3', '1', '9999', '0'),
('16', '15', '山东省', '1', '3', '1', '9999', '0'),
('17', '16', '河南省', '1', '3', '1', '9999', '0'),
('18', '17', '湖北省', '1', '3', '1', '9999', '0'),
('19', '18', '湖南省', '1', '3', '1', '9999', '0'),
('20', '19', '广东省', '1', '3', '1', '9999', '0'),
('21', '20', '广西壮族自治区', '1', '3', '1', '9999', '0'),
('22', '21', '海南省', '1', '3', '1', '9999', '0'),
('23', '22', '重庆', '1', '3', '1', '4', '0'),
('24', '23', '四川省', '1', '3', '1', '9999', '0'),
('25', '24', '贵州省', '1', '3', '1', '9999', '0'),
('26', '25', '云南省', '1', '3', '1', '9999', '0'),
('27', '26', '西藏自治区', '1', '3', '1', '9999', '0'),
('28', '27', '陕西省', '1', '3', '1', '9999', '0'),
('29', '28', '甘肃省', '1', '3', '1', '9999', '0'),
('30', '29', '青海省', '1', '3', '1', '9999', '0'),
('31', '30', '宁夏回族自治区', '1', '3', '1', '9999', '0'),
('32', '31', '新疆维吾尔自治区', '1', '3', '1', '9999', '0'),
('33', '32', '台湾省', '1', '3', '1', '9999', '0'),
('34', '33', '香港特别行政区', '1', '3', '1', '5', '0'),
('35', '34', '澳门特别行政区', '1', '3', '1', '6', '0'),
('38', '37', '东城区', '3', '0', '45053', '9999', '1'),
('39', '38', '西城区', '3', '0', '45053', '9999', '1'),
('40', '39', '崇文区', '3', '0', '45053', '9999', '1'),
('41', '40', '宣武区', '3', '0', '45053', '9999', '1'),
('42', '41', '朝阳区', '3', '0', '45053', '9999', '1'),
('43', '42', '丰台区', '3', '0', '45053', '9999', '1'),
('44', '43', '石景山区', '3', '0', '45053', '9999', '1'),
('45', '44', '海淀区', '3', '0', '45053', '9999', '1'),
('46', '45', '门头沟区', '3', '0', '45053', '9999', '1'),
('47', '46', '房山区', '3', '0', '45053', '9999', '1'),
('48', '47', '通州区', '3', '0', '45053', '9999', '1'),
('49', '48', '顺义区', '3', '0', '45053', '9999', '1'),
('50', '49', '昌平区', '3', '0', '45053', '9999', '1'),
('51', '50', '大兴区', '3', '0', '45053', '9999', '1'),
('52', '51', '怀柔区', '3', '0', '45053', '9999', '1'),
('53', '52', '平谷区', '3', '0', '45053', '9999', '1'),
('54', '53', '密云县', '3', '0', '45053', '9999', '1'),
('55', '54', '延庆县', '3', '0', '45053', '9999', '1'),
('56', '55', '和平区', '3', '0', '45054', '9999', '2'),
('57', '56', '河东区', '3', '0', '45054', '9999', '2'),
('58', '57', '河西区', '3', '0', '45054', '9999', '2'),
('59', '58', '南开区', '3', '0', '45054', '9999', '2'),
('60', '59', '河北区', '3', '0', '45054', '9999', '2'),
('61', '60', '红桥区', '3', '0', '45054', '9999', '2'),
('62', '61', '塘沽区', '3', '0', '45054', '9999', '2'),
('63', '62', '汉沽区', '3', '0', '45054', '9999', '2'),
('64', '63', '大港区', '3', '0', '45054', '9999', '2'),
('65', '64', '东丽区', '3', '0', '45054', '9999', '2'),
('66', '65', '西青区', '3', '0', '45054', '9999', '2'),
('67', '66', '津南区', '3', '0', '45054', '9999', '2'),
('68', '67', '北辰区', '3', '0', '45054', '9999', '2'),
('69', '68', '武清区', '3', '0', '45054', '9999', '2'),
('70', '69', '宝坻区', '3', '0', '45054', '9999', '2'),
('71', '70', '宁河县', '3', '0', '45054', '9999', '2'),
('72', '71', '静海县', '3', '0', '45054', '9999', '2'),
('73', '72', '蓟县', '3', '0', '45054', '9999', '2'),
('74', '73', '石家庄市', '2', '0', '4', '9999', '3'),
('75', '74', '唐山市', '2', '0', '4', '9999', '3'),
('76', '75', '秦皇岛市', '2', '0', '4', '9999', '3'),
('77', '76', '邯郸市', '2', '0', '4', '9999', '3'),
('78', '77', '邢台市', '2', '0', '4', '9999', '3'),
('79', '78', '保定市', '2', '0', '4', '9999', '3'),
('80', '79', '张家口市', '2', '0', '4', '9999', '3'),
('81', '80', '承德市', '2', '0', '4', '9999', '3'),
('82', '81', '衡水市', '2', '0', '4', '9999', '3'),
('83', '82', '廊坊市', '2', '0', '4', '9999', '3'),
('84', '83', '沧州市', '2', '0', '4', '9999', '3'),
('85', '84', '太原市', '2', '0', '5', '9999', '4'),
('86', '85', '大同市', '2', '0', '5', '9999', '4'),
('87', '86', '阳泉市', '2', '0', '5', '9999', '4'),
('88', '87', '长治市', '2', '0', '5', '9999', '4'),
('89', '88', '晋城市', '2', '0', '5', '9999', '4'),
('90', '89', '朔州市', '2', '0', '5', '9999', '4'),
('91', '90', '晋中市', '2', '0', '5', '9999', '4'),
('92', '91', '运城市', '2', '0', '5', '9999', '4'),
('93', '92', '忻州市', '2', '0', '5', '9999', '4'),
('94', '93', '临汾市', '2', '0', '5', '9999', '4'),
('95', '94', '吕梁市', '2', '0', '5', '9999', '4'),
('96', '95', '呼和浩特市', '2', '0', '6', '9999', '5'),
('97', '96', '包头市', '2', '0', '6', '9999', '5'),
('98', '97', '乌海市', '2', '0', '6', '9999', '5'),
('99', '98', '赤峰市', '2', '0', '6', '9999', '5'),
('100', '99', '通辽市', '2', '0', '6', '9999', '5'),
('101', '100', '鄂尔多斯市', '2', '0', '6', '9999', '5'),
('102', '101', '呼伦贝尔市', '2', '0', '6', '9999', '5'),
('103', '102', '巴彦淖尔市', '2', '0', '6', '9999', '5'),
('104', '103', '乌兰察布市', '2', '0', '6', '9999', '5'),
('105', '104', '兴安盟', '2', '0', '6', '9999', '5'),
('106', '105', '锡林郭勒盟', '2', '0', '6', '9999', '5'),
('107', '106', '阿拉善盟', '2', '0', '6', '9999', '5'),
('108', '107', '沈阳市', '2', '0', '7', '9999', '6'),
('109', '108', '大连市', '2', '0', '7', '9999', '6'),
('110', '109', '鞍山市', '2', '0', '7', '9999', '6'),
('111', '110', '抚顺市', '2', '0', '7', '9999', '6'),
('112', '111', '本溪市', '2', '0', '7', '9999', '6'),
('113', '112', '丹东市', '2', '0', '7', '9999', '6'),
('114', '113', '锦州市', '2', '0', '7', '9999', '6'),
('115', '114', '营口市', '2', '0', '7', '9999', '6'),
('116', '115', '阜新市', '2', '0', '7', '9999', '6'),
('117', '116', '辽阳市', '2', '0', '7', '9999', '6'),
('118', '117', '盘锦市', '2', '0', '7', '9999', '6'),
('119', '118', '铁岭市', '2', '0', '7', '9999', '6'),
('120', '119', '朝阳市', '2', '0', '7', '9999', '6'),
('121', '120', '葫芦岛市', '2', '0', '7', '9999', '6'),
('122', '121', '长春市', '2', '0', '8', '9999', '7'),
('123', '122', '吉林市', '2', '0', '8', '9999', '7'),
('124', '123', '四平市', '2', '0', '8', '9999', '7'),
('125', '124', '辽源市', '2', '0', '8', '9999', '7'),
('126', '125', '通化市', '2', '0', '8', '9999', '7'),
('127', '126', '白山市', '2', '0', '8', '9999', '7'),
('128', '127', '松原市', '2', '0', '8', '9999', '7'),
('129', '128', '白城市', '2', '0', '8', '9999', '7'),
('130', '129', '延边朝鲜族自治州', '2', '0', '8', '9999', '7'),
('131', '130', '哈尔滨市', '2', '0', '9', '9999', '8'),
('132', '131', '齐齐哈尔市', '2', '0', '9', '9999', '8'),
('133', '132', '鸡西市', '2', '0', '9', '9999', '8'),
('134', '133', '鹤岗市', '2', '0', '9', '9999', '8'),
('135', '134', '双鸭山市', '2', '0', '9', '9999', '8'),
('136', '135', '大庆市', '2', '0', '9', '9999', '8'),
('137', '136', '伊春市', '2', '0', '9', '9999', '8'),
('138', '137', '佳木斯市', '2', '0', '9', '9999', '8'),
('139', '138', '七台河市', '2', '0', '9', '9999', '8'),
('140', '139', '牡丹江市', '2', '0', '9', '9999', '8'),
('141', '140', '黑河市', '2', '0', '9', '9999', '8'),
('142', '141', '绥化市', '2', '0', '9', '9999', '8'),
('143', '142', '大兴安岭地区', '2', '0', '9', '9999', '8'),
('144', '143', '黄浦区', '3', '0', '45055', '9999', '9'),
('145', '144', '卢湾区', '3', '0', '45055', '9999', '9'),
('146', '145', '徐汇区', '3', '0', '45055', '9999', '9'),
('147', '146', '长宁区', '3', '0', '45055', '9999', '9'),
('148', '147', '静安区', '3', '0', '45055', '9999', '9'),
('149', '148', '普陀区', '3', '0', '45055', '9999', '9'),
('150', '149', '闸北区', '3', '0', '45055', '9999', '9'),
('151', '150', '虹口区', '3', '0', '45055', '9999', '9'),
('152', '151', '杨浦区', '3', '0', '45055', '9999', '9'),
('153', '152', '闵行区', '3', '0', '45055', '9999', '9'),
('154', '153', '宝山区', '3', '0', '45055', '9999', '9'),
('155', '154', '嘉定区', '3', '0', '45055', '9999', '9'),
('156', '155', '浦东新区', '3', '0', '45055', '9999', '9'),
('157', '156', '金山区', '3', '0', '45055', '9999', '9'),
('158', '157', '松江区', '3', '0', '45055', '9999', '9'),
('159', '158', '青浦区', '3', '0', '45055', '9999', '9'),
('160', '159', '南汇区', '3', '0', '45055', '9999', '9'),
('161', '160', '奉贤区', '3', '0', '45055', '9999', '9'),
('162', '161', '崇明县', '3', '0', '45055', '9999', '9'),
('163', '162', '南京市', '2', '0', '11', '9999', '10'),
('164', '163', '无锡市', '2', '0', '11', '9999', '10'),
('165', '164', '徐州市', '2', '0', '11', '9999', '10'),
('166', '165', '常州市', '2', '0', '11', '9999', '10'),
('167', '166', '苏州市', '2', '0', '11', '9999', '10'),
('168', '167', '南通市', '2', '0', '11', '9999', '10'),
('169', '168', '连云港市', '2', '0', '11', '9999', '10'),
('170', '169', '淮安市', '2', '0', '11', '9999', '10'),
('171', '170', '盐城市', '2', '0', '11', '9999', '10'),
('172', '171', '扬州市', '2', '0', '11', '9999', '10'),
('173', '172', '镇江市', '2', '0', '11', '9999', '10'),
('174', '173', '泰州市', '2', '0', '11', '9999', '10'),
('175', '174', '宿迁市', '2', '0', '11', '9999', '10'),
('176', '175', '杭州市', '2', '0', '12', '9999', '11'),
('177', '176', '宁波市', '2', '0', '12', '9999', '11'),
('178', '177', '温州市', '2', '0', '12', '9999', '11'),
('179', '178', '嘉兴市', '2', '0', '12', '9999', '11'),
('180', '179', '湖州市', '2', '0', '12', '9999', '11'),
('181', '180', '绍兴市', '2', '0', '12', '9999', '11'),
('182', '181', '舟山市', '2', '0', '12', '9999', '11'),
('183', '182', '衢州市', '2', '0', '12', '9999', '11'),
('184', '183', '金华市', '2', '0', '12', '9999', '11'),
('185', '184', '台州市', '2', '0', '12', '9999', '11'),
('186', '185', '丽水市', '2', '0', '12', '9999', '11'),
('187', '186', '合肥市', '2', '0', '13', '9999', '12'),
('188', '187', '芜湖市', '2', '0', '13', '9999', '12'),
('189', '188', '蚌埠市', '2', '0', '13', '9999', '12'),
('190', '189', '淮南市', '2', '0', '13', '9999', '12'),
('191', '190', '马鞍山市', '2', '0', '13', '9999', '12'),
('192', '191', '淮北市', '2', '0', '13', '9999', '12'),
('193', '192', '铜陵市', '2', '0', '13', '9999', '12'),
('194', '193', '安庆市', '2', '0', '13', '9999', '12'),
('195', '194', '黄山市', '2', '0', '13', '9999', '12'),
('196', '195', '滁州市', '2', '0', '13', '9999', '12'),
('197', '196', '阜阳市', '2', '0', '13', '9999', '12'),
('198', '197', '宿州市', '2', '0', '13', '9999', '12'),
('199', '198', '巢湖市', '2', '0', '13', '9999', '12'),
('200', '199', '六安市', '2', '0', '13', '9999', '12'),
('201', '200', '亳州市', '2', '0', '13', '9999', '12'),
('202', '201', '池州市', '2', '0', '13', '9999', '12'),
('203', '202', '宣城市', '2', '0', '13', '9999', '12'),
('204', '203', '福州市', '2', '0', '14', '9999', '13'),
('205', '204', '厦门市', '2', '0', '14', '9999', '13'),
('206', '205', '莆田市', '2', '0', '14', '9999', '13'),
('207', '206', '三明市', '2', '0', '14', '9999', '13'),
('208', '207', '泉州市', '2', '0', '14', '9999', '13'),
('209', '208', '漳州市', '2', '0', '14', '9999', '13'),
('210', '209', '南平市', '2', '0', '14', '9999', '13'),
('211', '210', '龙岩市', '2', '0', '14', '9999', '13'),
('212', '211', '宁德市', '2', '0', '14', '9999', '13'),
('213', '212', '南昌市', '2', '0', '15', '9999', '14'),
('214', '213', '景德镇市', '2', '0', '15', '9999', '14'),
('215', '214', '萍乡市', '2', '0', '15', '9999', '14'),
('216', '215', '九江市', '2', '0', '15', '9999', '14'),
('217', '216', '新余市', '2', '0', '15', '9999', '14'),
('218', '217', '鹰潭市', '2', '0', '15', '9999', '14'),
('219', '218', '赣州市', '2', '0', '15', '9999', '14'),
('220', '219', '吉安市', '2', '0', '15', '9999', '14'),
('221', '220', '宜春市', '2', '0', '15', '9999', '14'),
('222', '221', '抚州市', '2', '0', '15', '9999', '14'),
('223', '222', '上饶市', '2', '0', '15', '9999', '14'),
('224', '223', '济南市', '2', '0', '16', '9999', '15'),
('225', '224', '青岛市', '2', '0', '16', '9999', '15'),
('226', '225', '淄博市', '2', '0', '16', '9999', '15'),
('227', '226', '枣庄市', '2', '0', '16', '9999', '15'),
('228', '227', '东营市', '2', '0', '16', '9999', '15'),
('229', '228', '烟台市', '2', '0', '16', '9999', '15'),
('230', '229', '潍坊市', '2', '0', '16', '9999', '15'),
('231', '230', '济宁市', '2', '0', '16', '9999', '15'),
('232', '231', '泰安市', '2', '0', '16', '9999', '15'),
('233', '232', '威海市', '2', '0', '16', '9999', '15'),
('234', '233', '日照市', '2', '0', '16', '9999', '15'),
('235', '234', '莱芜市', '2', '0', '16', '9999', '15'),
('236', '235', '临沂市', '2', '0', '16', '9999', '15'),
('237', '236', '德州市', '2', '0', '16', '9999', '15'),
('238', '237', '聊城市', '2', '0', '16', '9999', '15'),
('239', '238', '滨州市', '2', '0', '16', '9999', '15'),
('240', '239', '菏泽市', '2', '0', '16', '9999', '15'),
('241', '240', '郑州市', '2', '0', '17', '9999', '16'),
('242', '241', '开封市', '2', '0', '17', '9999', '16'),
('243', '242', '洛阳市', '2', '0', '17', '9999', '16'),
('244', '243', '平顶山市', '2', '0', '17', '9999', '16'),
('245', '244', '安阳市', '2', '0', '17', '9999', '16'),
('246', '245', '鹤壁市', '2', '0', '17', '9999', '16'),
('247', '246', '新乡市', '2', '0', '17', '9999', '16'),
('248', '247', '焦作市', '2', '0', '17', '9999', '16'),
('249', '248', '濮阳市', '2', '0', '17', '9999', '16'),
('250', '249', '许昌市', '2', '0', '17', '9999', '16'),
('251', '250', '漯河市', '2', '0', '17', '9999', '16'),
('252', '251', '三门峡市', '2', '0', '17', '9999', '16'),
('253', '252', '南阳市', '2', '0', '17', '9999', '16'),
('254', '253', '商丘市', '2', '0', '17', '9999', '16'),
('255', '254', '信阳市', '2', '0', '17', '9999', '16'),
('256', '255', '周口市', '2', '0', '17', '9999', '16'),
('257', '256', '驻马店市', '2', '0', '17', '9999', '16'),
('258', '257', '济源市', '2', '0', '17', '9999', '16'),
('259', '258', '武汉市', '2', '0', '18', '9999', '17'),
('260', '259', '黄石市', '2', '0', '18', '9999', '17'),
('261', '260', '十堰市', '2', '0', '18', '9999', '17'),
('262', '261', '宜昌市', '2', '0', '18', '9999', '17'),
('263', '262', '襄阳市', '2', '0', '18', '9999', '17'),
('264', '263', '鄂州市', '2', '0', '18', '9999', '17'),
('265', '264', '荆门市', '2', '0', '18', '9999', '17'),
('266', '265', '孝感市', '2', '0', '18', '9999', '17'),
('267', '266', '荆州市', '2', '0', '18', '9999', '17'),
('268', '267', '黄冈市', '2', '0', '18', '9999', '17'),
('269', '268', '咸宁市', '2', '0', '18', '9999', '17'),
('270', '269', '随州市', '2', '0', '18', '9999', '17'),
('271', '270', '恩施土家族苗族自治州', '2', '0', '18', '9999', '17'),
('272', '271', '仙桃市', '2', '0', '18', '9999', '17'),
('273', '272', '潜江市', '2', '0', '18', '9999', '17'),
('274', '273', '天门市', '2', '0', '18', '9999', '17'),
('275', '274', '神农架林区', '2', '0', '18', '9999', '17'),
('276', '275', '长沙市', '2', '0', '19', '9999', '18'),
('277', '276', '株洲市', '2', '0', '19', '9999', '18'),
('278', '277', '湘潭市', '2', '0', '19', '9999', '18'),
('279', '278', '衡阳市', '2', '0', '19', '9999', '18'),
('280', '279', '邵阳市', '2', '0', '19', '9999', '18'),
('281', '280', '岳阳市', '2', '0', '19', '9999', '18'),
('282', '281', '常德市', '2', '0', '19', '9999', '18'),
('283', '282', '张家界市', '2', '0', '19', '9999', '18'),
('284', '283', '益阳市', '2', '0', '19', '9999', '18'),
('285', '284', '郴州市', '2', '0', '19', '9999', '18'),
('286', '285', '永州市', '2', '0', '19', '9999', '18'),
('287', '286', '怀化市', '2', '0', '19', '9999', '18'),
('288', '287', '娄底市', '2', '0', '19', '9999', '18'),
('289', '288', '湘西土家族苗族自治州', '2', '0', '19', '9999', '18'),
('290', '289', '广州市', '2', '0', '20', '9999', '19'),
('291', '290', '韶关市', '2', '0', '20', '9999', '19'),
('292', '291', '深圳市', '2', '0', '20', '9999', '19'),
('293', '292', '珠海市', '2', '0', '20', '9999', '19'),
('294', '293', '汕头市', '2', '0', '20', '9999', '19'),
('295', '294', '佛山市', '2', '0', '20', '9999', '19'),
('296', '295', '江门市', '2', '0', '20', '9999', '19'),
('297', '296', '湛江市', '2', '0', '20', '9999', '19'),
('298', '297', '茂名市', '2', '0', '20', '9999', '19'),
('299', '298', '肇庆市', '2', '0', '20', '9999', '19'),
('300', '299', '惠州市', '2', '0', '20', '9999', '19'),
('301', '300', '梅州市', '2', '0', '20', '9999', '19'),
('302', '301', '汕尾市', '2', '0', '20', '9999', '19'),
('303', '302', '河源市', '2', '0', '20', '9999', '19'),
('304', '303', '阳江市', '2', '0', '20', '9999', '19'),
('305', '304', '清远市', '2', '0', '20', '9999', '19'),
('306', '305', '东莞市', '2', '0', '20', '9999', '19'),
('307', '306', '中山市', '2', '0', '20', '9999', '19'),
('308', '307', '潮州市', '2', '0', '20', '9999', '19'),
('309', '308', '揭阳市', '2', '0', '20', '9999', '19'),
('310', '309', '云浮市', '2', '0', '20', '9999', '19'),
('311', '310', '南宁市', '2', '0', '21', '9999', '20'),
('312', '311', '柳州市', '2', '0', '21', '9999', '20'),
('313', '312', '桂林市', '2', '0', '21', '9999', '20'),
('314', '313', '梧州市', '2', '0', '21', '9999', '20'),
('315', '314', '北海市', '2', '0', '21', '9999', '20'),
('316', '315', '防城港市', '2', '0', '21', '9999', '20'),
('317', '316', '钦州市', '2', '0', '21', '9999', '20'),
('318', '317', '贵港市', '2', '0', '21', '9999', '20'),
('319', '318', '玉林市', '2', '0', '21', '9999', '20'),
('320', '319', '百色市', '2', '0', '21', '9999', '20'),
('321', '320', '贺州市', '2', '0', '21', '9999', '20'),
('322', '321', '河池市', '2', '0', '21', '9999', '20'),
('323', '322', '来宾市', '2', '0', '21', '9999', '20'),
('324', '323', '崇左市', '2', '0', '21', '9999', '20'),
('325', '324', '海口市', '2', '0', '22', '9999', '21'),
('326', '325', '三亚市', '2', '0', '22', '9999', '21'),
('327', '326', '五指山市', '2', '0', '22', '9999', '21'),
('328', '327', '琼海市', '2', '0', '22', '9999', '21'),
('329', '328', '儋州市', '2', '0', '22', '9999', '21'),
('330', '329', '文昌市', '2', '0', '22', '9999', '21'),
('331', '330', '万宁市', '2', '0', '22', '9999', '21'),
('332', '331', '东方市', '2', '0', '22', '9999', '21'),
('333', '332', '定安县', '2', '0', '22', '9999', '21'),
('334', '333', '屯昌县', '2', '0', '22', '9999', '21'),
('335', '334', '澄迈县', '2', '0', '22', '9999', '21'),
('336', '335', '临高县', '2', '0', '22', '9999', '21'),
('337', '336', '白沙黎族自治县', '2', '0', '22', '9999', '21'),
('338', '337', '昌江黎族自治县', '2', '0', '22', '9999', '21'),
('339', '338', '乐东黎族自治县', '2', '0', '22', '9999', '21'),
('340', '339', '陵水黎族自治县', '2', '0', '22', '9999', '21'),
('341', '340', '保亭黎族苗族自治县', '2', '0', '22', '9999', '21'),
('342', '341', '琼中黎族苗族自治县', '2', '0', '22', '9999', '21'),
('343', '342', '西沙群岛', '2', '0', '22', '9999', '21'),
('344', '343', '南沙群岛', '2', '0', '22', '9999', '21'),
('345', '344', '中沙群岛的岛礁及其海域', '2', '0', '22', '9999', '21'),
('346', '345', '万州区', '3', '0', '45056', '9999', '22'),
('347', '346', '涪陵区', '3', '0', '45056', '9999', '22'),
('348', '347', '渝中区', '3', '0', '45056', '9999', '22'),
('349', '348', '大渡口区', '3', '0', '45056', '9999', '22'),
('350', '349', '江北区', '3', '0', '45056', '9999', '22'),
('351', '350', '沙坪坝区', '3', '0', '45056', '9999', '22'),
('352', '351', '九龙坡区', '3', '0', '45056', '9999', '22'),
('353', '352', '南岸区', '3', '0', '45056', '9999', '22'),
('354', '353', '北碚区', '3', '0', '45056', '9999', '22'),
('355', '354', '双桥区', '3', '0', '45056', '9999', '22'),
('356', '355', '万盛区', '3', '0', '45056', '9999', '22'),
('357', '356', '渝北区', '3', '0', '45056', '9999', '22'),
('358', '357', '巴南区', '3', '0', '45056', '9999', '22'),
('359', '358', '黔江区', '3', '0', '45056', '9999', '22'),
('360', '359', '长寿区', '3', '0', '45056', '9999', '22'),
('361', '360', '綦江县', '3', '0', '45056', '9999', '22'),
('362', '361', '潼南县', '3', '0', '45056', '9999', '22'),
('363', '362', '铜梁县', '3', '0', '45056', '9999', '22'),
('364', '363', '大足县', '3', '0', '45056', '9999', '22'),
('365', '364', '荣昌县', '3', '0', '45056', '9999', '22'),
('366', '365', '璧山县', '3', '0', '45056', '9999', '22'),
('367', '366', '梁平县', '3', '0', '45056', '9999', '22'),
('368', '367', '城口县', '3', '0', '45056', '9999', '22'),
('369', '368', '丰都县', '3', '0', '45056', '9999', '22'),
('370', '369', '垫江县', '3', '0', '45056', '9999', '22'),
('371', '370', '武隆县', '3', '0', '45056', '9999', '22'),
('372', '371', '忠县', '3', '0', '45056', '9999', '22'),
('373', '372', '开县', '3', '0', '45056', '9999', '22'),
('374', '373', '云阳县', '3', '0', '45056', '9999', '22'),
('375', '374', '奉节县', '3', '0', '45056', '9999', '22'),
('376', '375', '巫山县', '3', '0', '45056', '9999', '22'),
('377', '376', '巫溪县', '3', '0', '45056', '9999', '22'),
('378', '377', '石柱土家族自治县', '3', '0', '45056', '9999', '22'),
('379', '378', '秀山土家族苗族自治县', '3', '0', '45056', '9999', '22'),
('380', '379', '酉阳土家族苗族自治县', '3', '0', '45056', '9999', '22'),
('381', '380', '彭水苗族土家族自治县', '3', '0', '45056', '9999', '22'),
('382', '381', '江津区', '4', '0', '45056', '9999', '22'),
('383', '382', '合川区', '4', '0', '45056', '9999', '22'),
('385', '384', '南川市', '3', '0', '45056', '9999', '22'),
('386', '385', '成都市', '2', '0', '24', '9999', '23'),
('387', '386', '自贡市', '2', '0', '24', '9999', '23'),
('388', '387', '攀枝花市', '2', '0', '24', '9999', '23'),
('389', '388', '泸州市', '2', '0', '24', '9999', '23'),
('390', '389', '德阳市', '2', '0', '24', '9999', '23'),
('391', '390', '绵阳市', '2', '0', '24', '9999', '23'),
('392', '391', '广元市', '2', '0', '24', '9999', '23'),
('393', '392', '遂宁市', '2', '0', '24', '9999', '23'),
('394', '393', '内江市', '2', '0', '24', '9999', '23'),
('395', '394', '乐山市', '2', '0', '24', '9999', '23'),
('396', '395', '南充市', '2', '0', '24', '9999', '23'),
('397', '396', '眉山市', '2', '0', '24', '9999', '23'),
('398', '397', '宜宾市', '2', '0', '24', '9999', '23'),
('399', '398', '广安市', '2', '0', '24', '9999', '23'),
('400', '399', '达州市', '2', '0', '24', '9999', '23'),
('401', '400', '雅安市', '2', '0', '24', '9999', '23'),
('402', '401', '巴中市', '2', '0', '24', '9999', '23'),
('403', '402', '资阳市', '2', '0', '24', '9999', '23'),
('404', '403', '阿坝藏族羌族自治州', '2', '0', '24', '9999', '23'),
('405', '404', '甘孜藏族自治州', '2', '0', '24', '9999', '23'),
('406', '405', '凉山彝族自治州', '2', '0', '24', '9999', '23'),
('407', '406', '贵阳市', '2', '0', '25', '9999', '24'),
('408', '407', '六盘水市', '2', '0', '25', '9999', '24'),
('409', '408', '遵义市', '2', '0', '25', '9999', '24'),
('410', '409', '安顺市', '2', '0', '25', '9999', '24'),
('411', '410', '铜仁地区', '2', '0', '25', '9999', '24'),
('412', '411', '黔西南布依族苗族自治州', '2', '0', '25', '9999', '24'),
('413', '412', '毕节地区', '2', '0', '25', '9999', '24'),
('414', '413', '黔东南苗族侗族自治州', '2', '0', '25', '9999', '24'),
('415', '414', '黔南布依族苗族自治州', '2', '0', '25', '9999', '24'),
('416', '415', '昆明市', '2', '0', '26', '9999', '25'),
('417', '416', '曲靖市', '2', '0', '26', '9999', '25'),
('418', '417', '玉溪市', '2', '0', '26', '9999', '25'),
('419', '418', '保山市', '2', '0', '26', '9999', '25'),
('420', '419', '昭通市', '2', '0', '26', '9999', '25'),
('421', '420', '丽江市', '2', '0', '26', '9999', '25'),
('422', '421', '思茅市', '2', '0', '26', '9999', '25'),
('423', '422', '临沧市', '2', '0', '26', '9999', '25'),
('424', '423', '楚雄彝族自治州', '2', '0', '26', '9999', '25'),
('425', '424', '红河哈尼族彝族自治州', '2', '0', '26', '9999', '25'),
('426', '425', '文山壮族苗族自治州', '2', '0', '26', '9999', '25'),
('427', '426', '西双版纳傣族自治州', '2', '0', '26', '9999', '25'),
('428', '427', '大理白族自治州', '2', '0', '26', '9999', '25'),
('429', '428', '德宏傣族景颇族自治州', '2', '0', '26', '9999', '25'),
('430', '429', '怒江傈僳族自治州', '2', '0', '26', '9999', '25'),
('431', '430', '迪庆藏族自治州', '2', '0', '26', '9999', '25'),
('432', '431', '拉萨市', '2', '0', '27', '9999', '26'),
('433', '432', '昌都地区', '2', '0', '27', '9999', '26'),
('434', '433', '山南地区', '2', '0', '27', '9999', '26'),
('435', '434', '日喀则地区', '2', '0', '27', '9999', '26'),
('436', '435', '那曲地区', '2', '0', '27', '9999', '26'),
('437', '436', '阿里地区', '2', '0', '27', '9999', '26'),
('438', '437', '林芝地区', '2', '0', '27', '9999', '26'),
('439', '438', '西安市', '2', '0', '28', '9999', '27'),
('440', '439', '铜川市', '2', '0', '28', '9999', '27'),
('441', '440', '宝鸡市', '2', '0', '28', '9999', '27'),
('442', '441', '咸阳市', '2', '0', '28', '9999', '27'),
('443', '442', '渭南市', '2', '0', '28', '9999', '27'),
('444', '443', '延安市', '2', '0', '28', '9999', '27'),
('445', '444', '汉中市', '2', '0', '28', '9999', '27'),
('446', '445', '榆林市', '2', '0', '28', '9999', '27'),
('447', '446', '安康市', '2', '0', '28', '9999', '27'),
('448', '447', '商洛市', '2', '0', '28', '9999', '27'),
('449', '448', '兰州市', '2', '0', '29', '9999', '28'),
('450', '449', '嘉峪关市', '2', '0', '29', '9999', '28'),
('451', '450', '金昌市', '2', '0', '29', '9999', '28'),
('452', '451', '白银市', '2', '0', '29', '9999', '28'),
('453', '452', '天水市', '2', '0', '29', '9999', '28'),
('454', '453', '武威市', '2', '0', '29', '9999', '28'),
('455', '454', '张掖市', '2', '0', '29', '9999', '28'),
('456', '455', '平凉市', '2', '0', '29', '9999', '28'),
('457', '456', '酒泉市', '2', '0', '29', '9999', '28'),
('458', '457', '庆阳市', '2', '0', '29', '9999', '28'),
('459', '458', '定西市', '2', '0', '29', '9999', '28'),
('460', '459', '陇南市', '2', '0', '29', '9999', '28'),
('461', '460', '临夏回族自治州', '2', '0', '29', '9999', '28'),
('462', '461', '甘南藏族自治州', '2', '0', '29', '9999', '28'),
('463', '462', '西宁市', '2', '0', '30', '9999', '29'),
('464', '463', '海东地区', '2', '0', '30', '9999', '29'),
('465', '464', '海北藏族自治州', '2', '0', '30', '9999', '29'),
('466', '465', '黄南藏族自治州', '2', '0', '30', '9999', '29'),
('467', '466', '海南藏族自治州', '2', '0', '30', '9999', '29'),
('468', '467', '果洛藏族自治州', '2', '0', '30', '9999', '29'),
('469', '468', '玉树藏族自治州', '2', '0', '30', '9999', '29'),
('470', '469', '海西蒙古族藏族自治州', '2', '0', '30', '9999', '29'),
('471', '470', '银川市', '2', '0', '31', '9999', '30'),
('472', '471', '石嘴山市', '2', '0', '31', '9999', '30'),
('473', '472', '吴忠市', '2', '0', '31', '9999', '30'),
('474', '473', '固原市', '2', '0', '31', '9999', '30'),
('475', '474', '中卫市', '2', '0', '31', '9999', '30'),
('476', '475', '乌鲁木齐市', '2', '0', '32', '9999', '31'),
('477', '476', '克拉玛依市', '2', '0', '32', '9999', '31'),
('478', '477', '吐鲁番地区', '2', '0', '32', '9999', '31'),
('479', '478', '哈密地区', '2', '0', '32', '9999', '31'),
('480', '479', '昌吉回族自治州', '2', '0', '32', '9999', '31'),
('481', '480', '博尔塔拉蒙古自治州', '2', '0', '32', '9999', '31'),
('482', '481', '巴音郭楞蒙古自治州', '2', '0', '32', '9999', '31'),
('483', '482', '阿克苏地区', '2', '0', '32', '9999', '31'),
('484', '483', '克孜勒苏柯尔克孜自治州', '2', '0', '32', '9999', '31'),
('485', '484', '喀什地区', '2', '0', '32', '9999', '31'),
('486', '485', '和田地区', '2', '0', '32', '9999', '31'),
('487', '486', '伊犁哈萨克自治州', '2', '0', '32', '9999', '31'),
('488', '487', '塔城地区', '2', '0', '32', '9999', '31'),
('489', '488', '阿勒泰地区', '2', '0', '32', '9999', '31'),
('490', '489', '石河子市', '2', '0', '32', '9999', '31'),
('491', '490', '阿拉尔市', '2', '0', '32', '9999', '31'),
('492', '491', '图木舒克市', '2', '0', '32', '9999', '31'),
('493', '492', '五家渠市', '2', '0', '32', '9999', '31'),
('494', '493', '台北市', '2', '0', '33', '9999', '32'),
('495', '494', '高雄市', '2', '0', '33', '9999', '32'),
('496', '495', '基隆市', '2', '0', '33', '9999', '32'),
('497', '496', '台中市', '2', '0', '33', '9999', '32'),
('498', '497', '台南市', '2', '0', '33', '9999', '32'),
('499', '498', '新竹市', '2', '0', '33', '9999', '32'),
('500', '499', '嘉义市', '2', '0', '33', '9999', '32'),
('501', '500', '台北县', '2', '0', '33', '9999', '32'),
('502', '501', '宜兰县', '2', '0', '33', '9999', '32'),
('503', '502', '桃园县', '2', '0', '33', '9999', '32'),
('504', '503', '新竹县', '2', '0', '33', '9999', '32'),
('505', '504', '苗栗县', '2', '0', '33', '9999', '32'),
('506', '505', '台中县', '2', '0', '33', '9999', '32'),
('507', '506', '彰化县', '2', '0', '33', '9999', '32'),
('508', '507', '南投县', '2', '0', '33', '9999', '32'),
('509', '508', '云林县', '2', '0', '33', '9999', '32'),
('510', '509', '嘉义县', '2', '0', '33', '9999', '32'),
('511', '510', '台南县', '2', '0', '33', '9999', '32'),
('512', '511', '高雄县', '2', '0', '33', '9999', '32'),
('513', '512', '屏东县', '2', '0', '33', '9999', '32'),
('514', '513', '澎湖县', '2', '0', '33', '9999', '32'),
('515', '514', '台东县', '2', '0', '33', '9999', '32'),
('516', '515', '花莲县', '2', '0', '33', '9999', '32'),
('517', '516', '中西区', '2', '0', '34', '9999', '33'),
('518', '517', '东区', '2', '0', '34', '9999', '33'),
('519', '518', '九龙城区', '2', '0', '34', '9999', '33'),
('520', '519', '观塘区', '2', '0', '34', '9999', '33'),
('521', '520', '南区', '2', '0', '34', '9999', '33'),
('522', '521', '深水埗区', '2', '0', '34', '9999', '33'),
('523', '522', '黄大仙区', '2', '0', '34', '9999', '33'),
('524', '523', '湾仔区', '2', '0', '34', '9999', '33'),
('525', '524', '油尖旺区', '2', '0', '34', '9999', '33'),
('526', '525', '离岛区', '2', '0', '34', '9999', '33'),
('527', '526', '葵青区', '2', '0', '34', '9999', '33'),
('528', '527', '北区', '2', '0', '34', '9999', '33'),
('529', '528', '西贡区', '2', '0', '34', '9999', '33'),
('530', '529', '沙田区', '2', '0', '34', '9999', '33'),
('531', '530', '屯门区', '2', '0', '34', '9999', '33'),
('532', '531', '大埔区', '2', '0', '34', '9999', '33'),
('533', '532', '荃湾区', '2', '0', '34', '9999', '33'),
('534', '533', '元朗区', '2', '0', '34', '9999', '33'),
('535', '534', '澳门特别行政区', '2', '0', '35', '9999', '34'),
('567', '566', '其他', '2', '0', '37', '9999', '36'),
('655', '654', '宛平城地区', '3', '0', '43', '9999', '42'),
('657', '656', '方庄地区', '3', '0', '43', '9999', '42'),
('713', '712', '王平地区', '3', '0', '46', '9999', '45'),
('722', '721', '周口店地区', '3', '0', '47', '9999', '46'),
('731', '730', '琉璃河地区', '3', '0', '47', '9999', '46'),
('734', '733', '良乡地区', '3', '0', '47', '9999', '46'),
('751', '750', '梨园地区', '3', '0', '48', '9999', '47'),
('753', '752', '永顺地区', '3', '0', '48', '9999', '47'),
('759', '758', '仁和地区', '3', '0', '49', '9999', '48'),
('765', '764', '南法信地区', '3', '0', '49', '9999', '48'),
('766', '765', '后沙峪地区', '3', '0', '49', '9999', '48'),
('768', '767', '天竺地区', '3', '0', '49', '9999', '48'),
('773', '772', '杨镇地区', '3', '0', '49', '9999', '48'),
('774', '773', '牛栏山地区', '3', '0', '49', '9999', '48'),
('778', '777', '马坡地区', '3', '0', '49', '9999', '48'),
('781', '780', '东小口地区', '3', '0', '50', '9999', '49'),
('785', '784', '南口地区', '3', '0', '50', '9999', '49'),
('787', '786', '回龙观地区', '3', '0', '50', '9999', '49'),
('792', '791', '沙河地区', '3', '0', '50', '9999', '49'),
('797', '796', '马池口地区', '3', '0', '50', '9999', '49'),
('798', '797', '亦庄地区（亦庄镇）', '3', '0', '51', '9999', '50'),
('803', '802', '旧宫地区（旧宫镇）', '3', '0', '51', '9999', '50'),
('809', '808', '西红门地区（西红门镇）', '3', '0', '51', '9999', '50'),
('814', '813', '黄村地区（黄村镇）', '3', '0', '51', '9999', '50'),
('819', '818', '庙城地区', '3', '0', '52', '9999', '51'),
('821', '820', '怀柔地区', '3', '0', '52', '9999', '51'),
('829', '828', '雁栖地区', '3', '0', '52', '9999', '51'),
('839', '838', '峪口地区', '3', '0', '53', '9999', '52'),
('840', '839', '渔阳地区', '3', '0', '53', '9999', '52'),
('844', '843', '金海湖地区', '3', '0', '53', '9999', '52'),
('846', '845', '马坊地区', '3', '0', '53', '9999', '52'),
('1003', '1002', '长青办事处', '3', '0', '67', '9999', '66'),
('1127', '1126', '井陉县', '3', '0', '74', '9999', '73'),
('1128', '1127', '井陉矿区', '3', '0', '74', '9999', '73'),
('1129', '1128', '元氏县', '3', '0', '74', '9999', '73'),
('1130', '1129', '平山县', '3', '0', '74', '9999', '73'),
('1131', '1130', '新乐市', '3', '0', '74', '9999', '73'),
('1132', '1131', '新华区', '3', '0', '74', '9999', '73'),
('1133', '1132', '无极县', '3', '0', '74', '9999', '73'),
('1134', '1133', '晋州市', '3', '0', '74', '9999', '73'),
('1135', '1134', '栾城县', '3', '0', '74', '9999', '73'),
('1136', '1135', '桥东区', '3', '0', '74', '9999', '73'),
('1137', '1136', '桥西区', '3', '0', '74', '9999', '73'),
('1138', '1137', '正定县', '3', '0', '74', '9999', '73'),
('1139', '1138', '深泽县', '3', '0', '74', '9999', '73'),
('1140', '1139', '灵寿县', '3', '0', '74', '9999', '73'),
('1141', '1140', '藁城市', '3', '0', '74', '9999', '73'),
('1142', '1141', '行唐县', '3', '0', '74', '9999', '73'),
('1143', '1142', '裕华区', '3', '0', '74', '9999', '73'),
('1144', '1143', '赞皇县', '3', '0', '74', '9999', '73'),
('1145', '1144', '赵县', '3', '0', '74', '9999', '73'),
('1146', '1145', '辛集市', '3', '0', '74', '9999', '73'),
('1147', '1146', '长安区', '3', '0', '74', '9999', '73'),
('1148', '1147', '高邑县', '3', '0', '74', '9999', '73'),
('1149', '1148', '鹿泉市', '3', '0', '74', '9999', '73'),
('1150', '1149', '丰南区', '3', '0', '75', '9999', '74'),
('1151', '1150', '丰润区', '3', '0', '75', '9999', '74'),
('1152', '1151', '乐亭县', '3', '0', '75', '9999', '74'),
('1153', '1152', '古冶区', '3', '0', '75', '9999', '74'),
('1154', '1153', '唐海县', '3', '0', '75', '9999', '74'),
('1155', '1154', '开平区', '3', '0', '75', '9999', '74'),
('1156', '1155', '滦南县', '3', '0', '75', '9999', '74'),
('1157', '1156', '滦县', '3', '0', '75', '9999', '74'),
('1158', '1157', '玉田县', '3', '0', '75', '9999', '74'),
('1159', '1158', '路北区', '3', '0', '75', '9999', '74'),
('1160', '1159', '路南区', '3', '0', '75', '9999', '74'),
('1161', '1160', '迁安市', '3', '0', '75', '9999', '74'),
('1162', '1161', '迁西县', '3', '0', '75', '9999', '74'),
('1163', '1162', '遵化市', '3', '0', '75', '9999', '74'),
('1164', '1163', '北戴河区', '3', '0', '76', '9999', '75'),
('1165', '1164', '卢龙县', '3', '0', '76', '9999', '75'),
('1166', '1165', '山海关区', '3', '0', '76', '9999', '75'),
('1167', '1166', '抚宁县', '3', '0', '76', '9999', '75'),
('1168', '1167', '昌黎县', '3', '0', '76', '9999', '75'),
('1169', '1168', '海港区', '3', '0', '76', '9999', '75'),
('1170', '1169', '青龙满族自治县', '3', '0', '76', '9999', '75'),
('1171', '1170', '丛台区', '3', '0', '77', '9999', '76'),
('1172', '1171', '临漳县', '3', '0', '77', '9999', '76'),
('1173', '1172', '复兴区', '3', '0', '77', '9999', '76'),
('1174', '1173', '大名县', '3', '0', '77', '9999', '76'),
('1175', '1174', '峰峰矿区', '3', '0', '77', '9999', '76'),
('1176', '1175', '广平县', '3', '0', '77', '9999', '76'),
('1177', '1176', '成安县', '3', '0', '77', '9999', '76'),
('1178', '1177', '曲周县', '3', '0', '77', '9999', '76'),
('1179', '1178', '武安市', '3', '0', '77', '9999', '76'),
('1180', '1179', '永年县', '3', '0', '77', '9999', '76'),
('1181', '1180', '涉县', '3', '0', '77', '9999', '76'),
('1182', '1181', '磁县', '3', '0', '77', '9999', '76'),
('1183', '1182', '肥乡县', '3', '0', '77', '9999', '76'),
('1184', '1183', '邯山区', '3', '0', '77', '9999', '76'),
('1185', '1184', '邯郸县', '3', '0', '77', '9999', '76'),
('1186', '1185', '邱县', '3', '0', '77', '9999', '76'),
('1187', '1186', '馆陶县', '3', '0', '77', '9999', '76'),
('1188', '1187', '魏县', '3', '0', '77', '9999', '76'),
('1189', '1188', '鸡泽县', '3', '0', '77', '9999', '76'),
('1190', '1189', '临城县', '3', '0', '78', '9999', '77'),
('1191', '1190', '临西县', '3', '0', '78', '9999', '77'),
('1192', '1191', '任县', '3', '0', '78', '9999', '77'),
('1193', '1192', '内丘县', '3', '0', '78', '9999', '77'),
('1194', '1193', '南和县', '3', '0', '78', '9999', '77'),
('1195', '1194', '南宫市', '3', '0', '78', '9999', '77'),
('1196', '1195', '威县', '3', '0', '78', '9999', '77'),
('1197', '1196', '宁晋县', '3', '0', '78', '9999', '77'),
('1198', '1197', '巨鹿县', '3', '0', '78', '9999', '77'),
('1199', '1198', '平乡县', '3', '0', '78', '9999', '77'),
('1200', '1199', '广宗县', '3', '0', '78', '9999', '77'),
('1201', '1200', '新河县', '3', '0', '78', '9999', '77'),
('1202', '1201', '柏乡县', '3', '0', '78', '9999', '77'),
('1203', '1202', '桥东区', '3', '0', '78', '9999', '77'),
('1204', '1203', '桥西区', '3', '0', '78', '9999', '77'),
('1205', '1204', '沙河市', '3', '0', '78', '9999', '77'),
('1206', '1205', '清河县', '3', '0', '78', '9999', '77'),
('1207', '1206', '邢台县', '3', '0', '78', '9999', '77'),
('1208', '1207', '隆尧县', '3', '0', '78', '9999', '77'),
('1209', '1208', '北市区', '3', '0', '79', '9999', '78'),
('1210', '1209', '南市区', '3', '0', '79', '9999', '78'),
('1211', '1210', '博野县', '3', '0', '79', '9999', '78'),
('1212', '1211', '唐县', '3', '0', '79', '9999', '78'),
('1213', '1212', '安国市', '3', '0', '79', '9999', '78'),
('1214', '1213', '安新县', '3', '0', '79', '9999', '78'),
('1215', '1214', '定兴县', '3', '0', '79', '9999', '78'),
('1216', '1215', '定州市', '3', '0', '79', '9999', '78'),
('1217', '1216', '容城县', '3', '0', '79', '9999', '78'),
('1218', '1217', '徐水县', '3', '0', '79', '9999', '78'),
('1219', '1218', '新市区', '3', '0', '79', '9999', '78'),
('1220', '1219', '易县', '3', '0', '79', '9999', '78'),
('1221', '1220', '曲阳县', '3', '0', '79', '9999', '78'),
('1222', '1221', '望都县', '3', '0', '79', '9999', '78'),
('1223', '1222', '涞水县', '3', '0', '79', '9999', '78'),
('1224', '1223', '涞源县', '3', '0', '79', '9999', '78'),
('1225', '1224', '涿州市', '3', '0', '79', '9999', '78'),
('1226', '1225', '清苑县', '3', '0', '79', '9999', '78'),
('1227', '1226', '满城县', '3', '0', '79', '9999', '78'),
('1228', '1227', '蠡县', '3', '0', '79', '9999', '78'),
('1229', '1228', '阜平县', '3', '0', '79', '9999', '78'),
('1230', '1229', '雄县', '3', '0', '79', '9999', '78'),
('1231', '1230', '顺平县', '3', '0', '79', '9999', '78'),
('1232', '1231', '高碑店市', '3', '0', '79', '9999', '78'),
('1233', '1232', '高阳县', '3', '0', '79', '9999', '78'),
('1234', '1233', '万全县', '3', '0', '80', '9999', '79'),
('1235', '1234', '下花园区', '3', '0', '80', '9999', '79'),
('1236', '1235', '宣化区', '3', '0', '80', '9999', '79'),
('1237', '1236', '宣化县', '3', '0', '80', '9999', '79'),
('1238', '1237', '尚义县', '3', '0', '80', '9999', '79'),
('1239', '1238', '崇礼县', '3', '0', '80', '9999', '79'),
('1240', '1239', '康保县', '3', '0', '80', '9999', '79'),
('1241', '1240', '张北县', '3', '0', '80', '9999', '79'),
('1242', '1241', '怀安县', '3', '0', '80', '9999', '79'),
('1243', '1242', '怀来县', '3', '0', '80', '9999', '79'),
('1244', '1243', '桥东区', '3', '0', '80', '9999', '79'),
('1245', '1244', '桥西区', '3', '0', '80', '9999', '79'),
('1246', '1245', '沽源县', '3', '0', '80', '9999', '79'),
('1247', '1246', '涿鹿县', '3', '0', '80', '9999', '79'),
('1248', '1247', '蔚县', '3', '0', '80', '9999', '79'),
('1249', '1248', '赤城县', '3', '0', '80', '9999', '79'),
('1250', '1249', '阳原县', '3', '0', '80', '9999', '79'),
('1251', '1250', '丰宁满族自治县', '3', '0', '81', '9999', '80'),
('1252', '1251', '兴隆县', '3', '0', '81', '9999', '80'),
('1253', '1252', '双桥区', '3', '0', '81', '9999', '80'),
('1254', '1253', '双滦区', '3', '0', '81', '9999', '80'),
('1255', '1254', '围场满族蒙古族自治县', '3', '0', '81', '9999', '80'),
('1256', '1255', '宽城满族自治县', '3', '0', '81', '9999', '80'),
('1257', '1256', '平泉县', '3', '0', '81', '9999', '80'),
('1258', '1257', '承德县', '3', '0', '81', '9999', '80'),
('1259', '1258', '滦平县', '3', '0', '81', '9999', '80'),
('1260', '1259', '隆化县', '3', '0', '81', '9999', '80'),
('1261', '1260', '鹰手营子矿区', '3', '0', '81', '9999', '80'),
('1262', '1261', '冀州市', '3', '0', '82', '9999', '81'),
('1263', '1262', '安平县', '3', '0', '82', '9999', '81'),
('1264', '1263', '故城县', '3', '0', '82', '9999', '81'),
('1265', '1264', '景县', '3', '0', '82', '9999', '81'),
('1266', '1265', '枣强县', '3', '0', '82', '9999', '81'),
('1267', '1266', '桃城区', '3', '0', '82', '9999', '81'),
('1268', '1267', '武强县', '3', '0', '82', '9999', '81'),
('1269', '1268', '武邑县', '3', '0', '82', '9999', '81'),
('1270', '1269', '深州市', '3', '0', '82', '9999', '81'),
('1271', '1270', '阜城县', '3', '0', '82', '9999', '81'),
('1272', '1271', '饶阳县', '3', '0', '82', '9999', '81'),
('1273', '1272', '三河市', '3', '0', '83', '9999', '82'),
('1274', '1273', '固安县', '3', '0', '83', '9999', '82'),
('1275', '1274', '大厂回族自治县', '3', '0', '83', '9999', '82'),
('1276', '1275', '大城县', '3', '0', '83', '9999', '82'),
('1277', '1276', '安次区', '3', '0', '83', '9999', '82'),
('1278', '1277', '广阳区', '3', '0', '83', '9999', '82'),
('1279', '1278', '文安县', '3', '0', '83', '9999', '82'),
('1280', '1279', '永清县', '3', '0', '83', '9999', '82'),
('1281', '1280', '霸州市', '3', '0', '83', '9999', '82'),
('1282', '1281', '香河县', '3', '0', '83', '9999', '82'),
('1283', '1282', '东光县', '3', '0', '84', '9999', '83'),
('1284', '1283', '任丘市', '3', '0', '84', '9999', '83'),
('1285', '1284', '南皮县', '3', '0', '84', '9999', '83'),
('1286', '1285', '吴桥县', '3', '0', '84', '9999', '83'),
('1287', '1286', '孟村回族自治县', '3', '0', '84', '9999', '83'),
('1288', '1287', '新华区', '3', '0', '84', '9999', '83'),
('1289', '1288', '沧县', '3', '0', '84', '9999', '83'),
('1290', '1289', '河间市', '3', '0', '84', '9999', '83'),
('1291', '1290', '泊头市', '3', '0', '84', '9999', '83'),
('1292', '1291', '海兴县', '3', '0', '84', '9999', '83'),
('1293', '1292', '献县', '3', '0', '84', '9999', '83'),
('1294', '1293', '盐山县', '3', '0', '84', '9999', '83'),
('1295', '1294', '肃宁县', '3', '0', '84', '9999', '83'),
('1296', '1295', '运河区', '3', '0', '84', '9999', '83'),
('1297', '1296', '青县', '3', '0', '84', '9999', '83'),
('1298', '1297', '黄骅市', '3', '0', '84', '9999', '83'),
('1299', '1298', '万柏林区', '3', '0', '85', '9999', '84'),
('1300', '1299', '古交市', '3', '0', '85', '9999', '84'),
('1301', '1300', '娄烦县', '3', '0', '85', '9999', '84'),
('1302', '1301', '小店区', '3', '0', '85', '9999', '84'),
('1303', '1302', '尖草坪区', '3', '0', '85', '9999', '84'),
('1304', '1303', '晋源区', '3', '0', '85', '9999', '84'),
('1305', '1304', '杏花岭区', '3', '0', '85', '9999', '84'),
('1306', '1305', '清徐县', '3', '0', '85', '9999', '84'),
('1307', '1306', '迎泽区', '3', '0', '85', '9999', '84'),
('1308', '1307', '阳曲县', '3', '0', '85', '9999', '84'),
('1309', '1308', '南郊区', '3', '0', '86', '9999', '85'),
('1310', '1309', '城区', '3', '0', '86', '9999', '85'),
('1311', '1310', '大同县', '3', '0', '86', '9999', '85'),
('1312', '1311', '天镇县', '3', '0', '86', '9999', '85'),
('1313', '1312', '左云县', '3', '0', '86', '9999', '85'),
('1314', '1313', '广灵县', '3', '0', '86', '9999', '85'),
('1315', '1314', '新荣区', '3', '0', '86', '9999', '85'),
('1316', '1315', '浑源县', '3', '0', '86', '9999', '85'),
('1317', '1316', '灵丘县', '3', '0', '86', '9999', '85'),
('1318', '1317', '矿区', '3', '0', '86', '9999', '85'),
('1319', '1318', '阳高县', '3', '0', '86', '9999', '85'),
('1320', '1319', '城区', '3', '0', '87', '9999', '86'),
('1321', '1320', '平定县', '3', '0', '87', '9999', '86'),
('1322', '1321', '盂县', '3', '0', '87', '9999', '86'),
('1323', '1322', '矿区', '3', '0', '87', '9999', '86'),
('1324', '1323', '郊区', '3', '0', '87', '9999', '86'),
('1325', '1324', '城区', '3', '0', '88', '9999', '87'),
('1326', '1325', '壶关县', '3', '0', '88', '9999', '87'),
('1327', '1326', '屯留县', '3', '0', '88', '9999', '87'),
('1328', '1327', '平顺县', '3', '0', '88', '9999', '87'),
('1329', '1328', '武乡县', '3', '0', '88', '9999', '87'),
('1330', '1329', '沁县', '3', '0', '88', '9999', '87'),
('1331', '1330', '沁源县', '3', '0', '88', '9999', '87'),
('1332', '1331', '潞城市', '3', '0', '88', '9999', '87'),
('1333', '1332', '襄垣县', '3', '0', '88', '9999', '87'),
('1334', '1333', '郊区', '3', '0', '88', '9999', '87'),
('1335', '1334', '长子县', '3', '0', '88', '9999', '87'),
('1336', '1335', '长治县', '3', '0', '88', '9999', '87'),
('1337', '1336', '黎城县', '3', '0', '88', '9999', '87'),
('1338', '1337', '城区', '3', '0', '89', '9999', '88'),
('1339', '1338', '沁水县', '3', '0', '89', '9999', '88'),
('1340', '1339', '泽州县', '3', '0', '89', '9999', '88'),
('1341', '1340', '阳城县', '3', '0', '89', '9999', '88'),
('1342', '1341', '陵川县', '3', '0', '89', '9999', '88'),
('1343', '1342', '高平市', '3', '0', '89', '9999', '88'),
('1344', '1343', '右玉县', '3', '0', '90', '9999', '89'),
('1345', '1344', '山阴县', '3', '0', '90', '9999', '89'),
('1346', '1345', '平鲁区', '3', '0', '90', '9999', '89'),
('1347', '1346', '应县', '3', '0', '90', '9999', '89'),
('1348', '1347', '怀仁县', '3', '0', '90', '9999', '89'),
('1349', '1348', '朔城区', '3', '0', '90', '9999', '89'),
('1350', '1349', '介休市', '3', '0', '91', '9999', '90'),
('1351', '1350', '和顺县', '3', '0', '91', '9999', '90'),
('1352', '1351', '太谷县', '3', '0', '91', '9999', '90'),
('1353', '1352', '寿阳县', '3', '0', '91', '9999', '90'),
('1354', '1353', '左权县', '3', '0', '91', '9999', '90'),
('1355', '1354', '平遥县', '3', '0', '91', '9999', '90'),
('1356', '1355', '昔阳县', '3', '0', '91', '9999', '90'),
('1357', '1356', '榆次区', '3', '0', '91', '9999', '90'),
('1358', '1357', '榆社县', '3', '0', '91', '9999', '90'),
('1359', '1358', '灵石县', '3', '0', '91', '9999', '90'),
('1360', '1359', '祁县', '3', '0', '91', '9999', '90'),
('1361', '1360', '万荣县', '3', '0', '92', '9999', '91'),
('1362', '1361', '临猗县', '3', '0', '92', '9999', '91'),
('1363', '1362', '垣曲县', '3', '0', '92', '9999', '91'),
('1364', '1363', '夏县', '3', '0', '92', '9999', '91'),
('1365', '1364', '平陆县', '3', '0', '92', '9999', '91'),
('1366', '1365', '新绛县', '3', '0', '92', '9999', '91'),
('1367', '1366', '永济市', '3', '0', '92', '9999', '91'),
('1368', '1367', '河津市', '3', '0', '92', '9999', '91'),
('1369', '1368', '盐湖区', '3', '0', '92', '9999', '91'),
('1370', '1369', '稷山县', '3', '0', '92', '9999', '91'),
('1371', '1370', '绛县', '3', '0', '92', '9999', '91'),
('1372', '1371', '芮城县', '3', '0', '92', '9999', '91'),
('1373', '1372', '闻喜县', '3', '0', '92', '9999', '91'),
('1374', '1373', '五台县', '3', '0', '93', '9999', '92'),
('1375', '1374', '五寨县', '3', '0', '93', '9999', '92'),
('1376', '1375', '代县', '3', '0', '93', '9999', '92'),
('1377', '1376', '保德县', '3', '0', '93', '9999', '92'),
('1378', '1377', '偏关县', '3', '0', '93', '9999', '92'),
('1379', '1378', '原平市', '3', '0', '93', '9999', '92'),
('1380', '1379', '宁武县', '3', '0', '93', '9999', '92'),
('1381', '1380', '定襄县', '3', '0', '93', '9999', '92'),
('1382', '1381', '岢岚县', '3', '0', '93', '9999', '92'),
('1383', '1382', '忻府区', '3', '0', '93', '9999', '92'),
('1384', '1383', '河曲县', '3', '0', '93', '9999', '92'),
('1385', '1384', '神池县', '3', '0', '93', '9999', '92'),
('1386', '1385', '繁峙县', '3', '0', '93', '9999', '92'),
('1387', '1386', '静乐县', '3', '0', '93', '9999', '92'),
('1388', '1387', '乡宁县', '3', '0', '94', '9999', '93'),
('1389', '1388', '侯马市', '3', '0', '94', '9999', '93'),
('1390', '1389', '古县', '3', '0', '94', '9999', '93'),
('1391', '1390', '吉县', '3', '0', '94', '9999', '93'),
('1392', '1391', '大宁县', '3', '0', '94', '9999', '93'),
('1393', '1392', '安泽县', '3', '0', '94', '9999', '93'),
('1394', '1393', '尧都区', '3', '0', '94', '9999', '93'),
('1395', '1394', '曲沃县', '3', '0', '94', '9999', '93'),
('1396', '1395', '永和县', '3', '0', '94', '9999', '93'),
('1397', '1396', '汾西县', '3', '0', '94', '9999', '93'),
('1398', '1397', '洪洞县', '3', '0', '94', '9999', '93'),
('1399', '1398', '浮山县', '3', '0', '94', '9999', '93'),
('1400', '1399', '翼城县', '3', '0', '94', '9999', '93'),
('1401', '1400', '蒲县', '3', '0', '94', '9999', '93'),
('1402', '1401', '襄汾县', '3', '0', '94', '9999', '93'),
('1403', '1402', '隰县', '3', '0', '94', '9999', '93'),
('1404', '1403', '霍州市', '3', '0', '94', '9999', '93'),
('1405', '1404', '中阳县', '3', '0', '95', '9999', '94'),
('1406', '1405', '临县', '3', '0', '95', '9999', '94'),
('1407', '1406', '交口县', '3', '0', '95', '9999', '94'),
('1408', '1407', '交城县', '3', '0', '95', '9999', '94'),
('1409', '1408', '兴县', '3', '0', '95', '9999', '94'),
('1410', '1409', '孝义市', '3', '0', '95', '9999', '94'),
('1411', '1410', '岚县', '3', '0', '95', '9999', '94'),
('1412', '1411', '文水县', '3', '0', '95', '9999', '94'),
('1413', '1412', '方山县', '3', '0', '95', '9999', '94'),
('1414', '1413', '柳林县', '3', '0', '95', '9999', '94'),
('1415', '1414', '汾阳市', '3', '0', '95', '9999', '94'),
('1416', '1415', '石楼县', '3', '0', '95', '9999', '94'),
('1417', '1416', '离石区', '3', '0', '95', '9999', '94'),
('1418', '1417', '和林格尔县', '3', '0', '96', '9999', '95'),
('1419', '1418', '回民区', '3', '0', '96', '9999', '95'),
('1420', '1419', '土默特左旗', '3', '0', '96', '9999', '95'),
('1421', '1420', '托克托县', '3', '0', '96', '9999', '95'),
('1422', '1421', '新城区', '3', '0', '96', '9999', '95'),
('1423', '1422', '武川县', '3', '0', '96', '9999', '95'),
('1424', '1423', '清水河县', '3', '0', '96', '9999', '95'),
('1425', '1424', '玉泉区', '3', '0', '96', '9999', '95'),
('1426', '1425', '赛罕区', '3', '0', '96', '9999', '95'),
('1427', '1426', '东河区', '3', '0', '97', '9999', '96'),
('1428', '1427', '九原区', '3', '0', '97', '9999', '96'),
('1429', '1428', '固阳县', '3', '0', '97', '9999', '96'),
('1430', '1429', '土默特右旗', '3', '0', '97', '9999', '96'),
('1431', '1430', '昆都仑区', '3', '0', '97', '9999', '96'),
('1432', '1431', '白云矿区', '3', '0', '97', '9999', '96'),
('1433', '1432', '石拐区', '3', '0', '97', '9999', '96'),
('1434', '1433', '达尔罕茂明安联合旗', '3', '0', '97', '9999', '96'),
('1435', '1434', '青山区', '3', '0', '97', '9999', '96'),
('1436', '1435', '乌达区', '3', '0', '98', '9999', '97'),
('1437', '1436', '海勃湾区', '3', '0', '98', '9999', '97'),
('1438', '1437', '海南区', '3', '0', '98', '9999', '97'),
('1439', '1438', '元宝山区', '3', '0', '99', '9999', '98'),
('1440', '1439', '克什克腾旗', '3', '0', '99', '9999', '98'),
('1441', '1440', '喀喇沁旗', '3', '0', '99', '9999', '98'),
('1442', '1441', '宁城县', '3', '0', '99', '9999', '98'),
('1443', '1442', '巴林右旗', '3', '0', '99', '9999', '98'),
('1444', '1443', '巴林左旗', '3', '0', '99', '9999', '98'),
('1445', '1444', '敖汉旗', '3', '0', '99', '9999', '98'),
('1446', '1445', '松山区', '3', '0', '99', '9999', '98'),
('1447', '1446', '林西县', '3', '0', '99', '9999', '98'),
('1448', '1447', '红山区', '3', '0', '99', '9999', '98'),
('1449', '1448', '翁牛特旗', '3', '0', '99', '9999', '98'),
('1450', '1449', '阿鲁科尔沁旗', '3', '0', '99', '9999', '98'),
('1451', '1450', '奈曼旗', '3', '0', '100', '9999', '99'),
('1452', '1451', '库伦旗', '3', '0', '100', '9999', '99'),
('1453', '1452', '开鲁县', '3', '0', '100', '9999', '99'),
('1454', '1453', '扎鲁特旗', '3', '0', '100', '9999', '99'),
('1455', '1454', '科尔沁区', '3', '0', '100', '9999', '99'),
('1456', '1455', '科尔沁左翼中旗', '3', '0', '100', '9999', '99'),
('1457', '1456', '科尔沁左翼后旗', '3', '0', '100', '9999', '99'),
('1458', '1457', '霍林郭勒市', '3', '0', '100', '9999', '99'),
('1459', '1458', '东胜区', '3', '0', '101', '9999', '100'),
('1460', '1459', '乌审旗', '3', '0', '101', '9999', '100'),
('1461', '1460', '伊金霍洛旗', '3', '0', '101', '9999', '100'),
('1462', '1461', '准格尔旗', '3', '0', '101', '9999', '100'),
('1463', '1462', '杭锦旗', '3', '0', '101', '9999', '100'),
('1464', '1463', '达拉特旗', '3', '0', '101', '9999', '100'),
('1465', '1464', '鄂东胜区', '3', '0', '101', '9999', '100'),
('1466', '1465', '鄂托克前旗', '3', '0', '101', '9999', '100'),
('1467', '1466', '鄂托克旗', '3', '0', '101', '9999', '100'),
('1468', '1467', '扎兰屯市', '3', '0', '102', '9999', '101'),
('1469', '1468', '新巴尔虎右旗', '3', '0', '102', '9999', '101'),
('1470', '1469', '新巴尔虎左旗', '3', '0', '102', '9999', '101'),
('1471', '1470', '根河市', '3', '0', '102', '9999', '101'),
('1472', '1471', '海拉尔区', '3', '0', '102', '9999', '101'),
('1473', '1472', '满洲里市', '3', '0', '102', '9999', '101'),
('1474', '1473', '牙克石市', '3', '0', '102', '9999', '101'),
('1475', '1474', '莫力达瓦达斡尔族自治旗', '3', '0', '102', '9999', '101'),
('1476', '1475', '鄂伦春自治旗', '3', '0', '102', '9999', '101'),
('1477', '1476', '鄂温克族自治旗', '3', '0', '102', '9999', '101'),
('1478', '1477', '阿荣旗', '3', '0', '102', '9999', '101'),
('1479', '1478', '陈巴尔虎旗', '3', '0', '102', '9999', '101'),
('1480', '1479', '额尔古纳市', '3', '0', '102', '9999', '101'),
('1481', '1480', '临河区', '3', '0', '103', '9999', '102'),
('1482', '1481', '乌拉特中旗', '3', '0', '103', '9999', '102'),
('1483', '1482', '乌拉特前旗', '3', '0', '103', '9999', '102'),
('1484', '1483', '乌拉特后旗', '3', '0', '103', '9999', '102'),
('1485', '1484', '五原县', '3', '0', '103', '9999', '102'),
('1486', '1485', '杭锦后旗', '3', '0', '103', '9999', '102'),
('1487', '1486', '磴口县', '3', '0', '103', '9999', '102'),
('1488', '1487', '丰镇市', '3', '0', '104', '9999', '103'),
('1489', '1488', '兴和县', '3', '0', '104', '9999', '103'),
('1490', '1489', '凉城县', '3', '0', '104', '9999', '103'),
('1491', '1490', '化德县', '3', '0', '104', '9999', '103'),
('1492', '1491', '卓资县', '3', '0', '104', '9999', '103'),
('1493', '1492', '商都县', '3', '0', '104', '9999', '103'),
('1494', '1493', '四子王旗', '3', '0', '104', '9999', '103'),
('1495', '1494', '察哈尔右翼中旗', '3', '0', '104', '9999', '103'),
('1496', '1495', '察哈尔右翼前旗', '3', '0', '104', '9999', '103'),
('1497', '1496', '察哈尔右翼后旗', '3', '0', '104', '9999', '103'),
('1498', '1497', '集宁区', '3', '0', '104', '9999', '103'),
('1499', '1498', '乌兰浩特市', '3', '0', '105', '9999', '104'),
('1500', '1499', '扎赉特旗', '3', '0', '105', '9999', '104'),
('1501', '1500', '科尔沁右翼中旗', '3', '0', '105', '9999', '104'),
('1502', '1501', '科尔沁右翼前旗', '3', '0', '105', '9999', '104'),
('1503', '1502', '突泉县', '3', '0', '105', '9999', '104'),
('1504', '1503', '阿尔山市', '3', '0', '105', '9999', '104'),
('1505', '1504', '东乌珠穆沁旗', '3', '0', '106', '9999', '105'),
('1506', '1505', '二连浩特市', '3', '0', '106', '9999', '105'),
('1507', '1506', '多伦县', '3', '0', '106', '9999', '105'),
('1508', '1507', '太仆寺旗', '3', '0', '106', '9999', '105'),
('1509', '1508', '正蓝旗', '3', '0', '106', '9999', '105'),
('1510', '1509', '正镶白旗', '3', '0', '106', '9999', '105'),
('1511', '1510', '苏尼特右旗', '3', '0', '106', '9999', '105'),
('1512', '1511', '苏尼特左旗', '3', '0', '106', '9999', '105'),
('1513', '1512', '西乌珠穆沁旗', '3', '0', '106', '9999', '105'),
('1514', '1513', '锡林浩特市', '3', '0', '106', '9999', '105'),
('1515', '1514', '镶黄旗', '3', '0', '106', '9999', '105'),
('1516', '1515', '阿巴嘎旗', '3', '0', '106', '9999', '105'),
('1517', '1516', '阿拉善右旗', '3', '0', '107', '9999', '106'),
('1518', '1517', '阿拉善左旗', '3', '0', '107', '9999', '106'),
('1519', '1518', '额济纳旗', '3', '0', '107', '9999', '106'),
('1520', '1519', '东陵区', '3', '0', '108', '9999', '107'),
('1521', '1520', '于洪区', '3', '0', '108', '9999', '107'),
('1522', '1521', '和平区', '3', '0', '108', '9999', '107'),
('1523', '1522', '大东区', '3', '0', '108', '9999', '107'),
('1524', '1523', '康平县', '3', '0', '108', '9999', '107'),
('1525', '1524', '新民市', '3', '0', '108', '9999', '107'),
('1526', '1525', '沈北新区', '3', '0', '108', '9999', '107'),
('1527', '1526', '沈河区', '3', '0', '108', '9999', '107'),
('1528', '1527', '法库县', '3', '0', '108', '9999', '107'),
('1529', '1528', '皇姑区', '3', '0', '108', '9999', '107'),
('1530', '1529', '苏家屯区', '3', '0', '108', '9999', '107'),
('1531', '1530', '辽中县', '3', '0', '108', '9999', '107'),
('1532', '1531', '铁西区', '3', '0', '108', '9999', '107'),
('1533', '1532', '中山区', '3', '0', '109', '9999', '108'),
('1534', '1533', '庄河市', '3', '0', '109', '9999', '108'),
('1535', '1534', '旅顺口区', '3', '0', '109', '9999', '108'),
('1536', '1535', '普兰店市', '3', '0', '109', '9999', '108'),
('1537', '1536', '沙河口区', '3', '0', '109', '9999', '108'),
('1538', '1537', '瓦房店市', '3', '0', '109', '9999', '108'),
('1539', '1538', '甘井子区', '3', '0', '109', '9999', '108'),
('1540', '1539', '西岗区', '3', '0', '109', '9999', '108'),
('1541', '1540', '金州区', '3', '0', '109', '9999', '108'),
('1542', '1541', '长海县', '3', '0', '109', '9999', '108'),
('1543', '1542', '千山区', '3', '0', '110', '9999', '109'),
('1544', '1543', '台安县', '3', '0', '110', '9999', '109'),
('1545', '1544', '岫岩满族自治县', '3', '0', '110', '9999', '109'),
('1546', '1545', '海城市', '3', '0', '110', '9999', '109'),
('1547', '1546', '立山区', '3', '0', '110', '9999', '109'),
('1548', '1547', '铁东区', '3', '0', '110', '9999', '109'),
('1549', '1548', '铁西区', '3', '0', '110', '9999', '109'),
('1550', '1549', '东洲区', '3', '0', '111', '9999', '110'),
('1551', '1550', '抚顺县', '3', '0', '111', '9999', '110'),
('1552', '1551', '新宾满族自治县', '3', '0', '111', '9999', '110'),
('1553', '1552', '新抚区', '3', '0', '111', '9999', '110'),
('1554', '1553', '望花区', '3', '0', '111', '9999', '110'),
('1555', '1554', '清原满族自治县', '3', '0', '111', '9999', '110'),
('1556', '1555', '顺城区', '3', '0', '111', '9999', '110'),
('1557', '1556', '南芬区', '3', '0', '112', '9999', '111'),
('1558', '1557', '平山区', '3', '0', '112', '9999', '111'),
('1559', '1558', '明山区', '3', '0', '112', '9999', '111'),
('1560', '1559', '本溪满族自治县', '3', '0', '112', '9999', '111'),
('1561', '1560', '桓仁满族自治县', '3', '0', '112', '9999', '111'),
('1562', '1561', '溪湖区', '3', '0', '112', '9999', '111'),
('1563', '1562', '东港市', '3', '0', '113', '9999', '112'),
('1564', '1563', '元宝区', '3', '0', '113', '9999', '112'),
('1565', '1564', '凤城市', '3', '0', '113', '9999', '112'),
('1566', '1565', '宽甸满族自治县', '3', '0', '113', '9999', '112'),
('1567', '1566', '振兴区', '3', '0', '113', '9999', '112'),
('1568', '1567', '振安区', '3', '0', '113', '9999', '112'),
('1569', '1568', '义县', '3', '0', '114', '9999', '113'),
('1570', '1569', '凌河区', '3', '0', '114', '9999', '113'),
('1571', '1570', '凌海市', '3', '0', '114', '9999', '113'),
('1572', '1571', '北镇市', '3', '0', '114', '9999', '113'),
('1573', '1572', '古塔区', '3', '0', '114', '9999', '113'),
('1574', '1573', '太和区', '3', '0', '114', '9999', '113'),
('1575', '1574', '黑山县', '3', '0', '114', '9999', '113'),
('1576', '1575', '大石桥市', '3', '0', '115', '9999', '114'),
('1577', '1576', '盖州市', '3', '0', '115', '9999', '114'),
('1578', '1577', '站前区', '3', '0', '115', '9999', '114'),
('1579', '1578', '老边区', '3', '0', '115', '9999', '114'),
('1580', '1579', '西市区', '3', '0', '115', '9999', '114'),
('1581', '1580', '鲅鱼圈区', '3', '0', '115', '9999', '114'),
('1582', '1581', '太平区', '3', '0', '116', '9999', '115'),
('1583', '1582', '彰武县', '3', '0', '116', '9999', '115'),
('1584', '1583', '新邱区', '3', '0', '116', '9999', '115'),
('1585', '1584', '海州区', '3', '0', '116', '9999', '115'),
('1586', '1585', '清河门区', '3', '0', '116', '9999', '115'),
('1587', '1586', '细河区', '3', '0', '116', '9999', '115'),
('1588', '1587', '蒙古族自治县', '3', '0', '116', '9999', '115'),
('1589', '1588', '太子河区', '3', '0', '117', '9999', '116'),
('1590', '1589', '宏伟区', '3', '0', '117', '9999', '116'),
('1591', '1590', '弓长岭区', '3', '0', '117', '9999', '116'),
('1592', '1591', '文圣区', '3', '0', '117', '9999', '116'),
('1593', '1592', '灯塔市', '3', '0', '117', '9999', '116'),
('1594', '1593', '白塔区', '3', '0', '117', '9999', '116'),
('1595', '1594', '辽阳县', '3', '0', '117', '9999', '116'),
('1596', '1595', '兴隆台区', '3', '0', '118', '9999', '117'),
('1597', '1596', '双台子区', '3', '0', '118', '9999', '117'),
('1598', '1597', '大洼县', '3', '0', '118', '9999', '117'),
('1599', '1598', '盘山县', '3', '0', '118', '9999', '117'),
('1600', '1599', '开原市', '3', '0', '119', '9999', '118'),
('1601', '1600', '昌图县', '3', '0', '119', '9999', '118'),
('1602', '1601', '清河区', '3', '0', '119', '9999', '118'),
('1603', '1602', '西丰县', '3', '0', '119', '9999', '118'),
('1604', '1603', '调兵山市', '3', '0', '119', '9999', '118'),
('1605', '1604', '铁岭县', '3', '0', '119', '9999', '118'),
('1606', '1605', '银州区', '3', '0', '119', '9999', '118'),
('1607', '1606', '凌源市', '3', '0', '120', '9999', '119'),
('1608', '1607', '北票市', '3', '0', '120', '9999', '119'),
('1609', '1608', '双塔区', '3', '0', '120', '9999', '119'),
('1610', '1609', '喀喇沁左翼蒙古族自治县', '3', '0', '120', '9999', '119'),
('1611', '1610', '建平县', '3', '0', '120', '9999', '119'),
('1612', '1611', '朝阳县', '3', '0', '120', '9999', '119'),
('1613', '1612', '龙城区', '3', '0', '120', '9999', '119'),
('1614', '1613', '兴城市', '3', '0', '121', '9999', '120'),
('1615', '1614', '南票区', '3', '0', '121', '9999', '120'),
('1616', '1615', '建昌县', '3', '0', '121', '9999', '120'),
('1617', '1616', '绥中县', '3', '0', '121', '9999', '120'),
('1618', '1617', '连山区', '3', '0', '121', '9999', '120'),
('1619', '1618', '龙港区', '3', '0', '121', '9999', '120'),
('1620', '1619', '九台市', '3', '0', '122', '9999', '121'),
('1621', '1620', '二道区', '3', '0', '122', '9999', '121'),
('1622', '1621', '农安县', '3', '0', '122', '9999', '121'),
('1623', '1622', '南关区', '3', '0', '122', '9999', '121'),
('1624', '1623', '双阳区', '3', '0', '122', '9999', '121'),
('1625', '1624', '宽城区', '3', '0', '122', '9999', '121'),
('1626', '1625', '德惠市', '3', '0', '122', '9999', '121'),
('1627', '1626', '朝阳区', '3', '0', '122', '9999', '121'),
('1628', '1627', '榆树市', '3', '0', '122', '9999', '121'),
('1629', '1628', '绿园区', '3', '0', '122', '9999', '121'),
('1630', '1629', '丰满区', '3', '0', '123', '9999', '122'),
('1631', '1630', '昌邑区', '3', '0', '123', '9999', '122'),
('1632', '1631', '桦甸市', '3', '0', '123', '9999', '122'),
('1633', '1632', '永吉县', '3', '0', '123', '9999', '122'),
('1634', '1633', '磐石市', '3', '0', '123', '9999', '122'),
('1635', '1634', '舒兰市', '3', '0', '123', '9999', '122'),
('1636', '1635', '船营区', '3', '0', '123', '9999', '122'),
('1637', '1636', '蛟河市', '3', '0', '123', '9999', '122'),
('1638', '1637', '龙潭区', '3', '0', '123', '9999', '122'),
('1639', '1638', '伊通满族自治县', '3', '0', '124', '9999', '123'),
('1640', '1639', '公主岭市', '3', '0', '124', '9999', '123'),
('1641', '1640', '双辽市', '3', '0', '124', '9999', '123'),
('1642', '1641', '梨树县', '3', '0', '124', '9999', '123'),
('1643', '1642', '铁东区', '3', '0', '124', '9999', '123'),
('1644', '1643', '铁西区', '3', '0', '124', '9999', '123'),
('1645', '1644', '东丰县', '3', '0', '125', '9999', '124'),
('1646', '1645', '东辽县', '3', '0', '125', '9999', '124'),
('1647', '1646', '西安区', '3', '0', '125', '9999', '124'),
('1648', '1647', '龙山区', '3', '0', '125', '9999', '124'),
('1649', '1648', '东昌区', '3', '0', '126', '9999', '125'),
('1650', '1649', '二道江区', '3', '0', '126', '9999', '125'),
('1651', '1650', '柳河县', '3', '0', '126', '9999', '125'),
('1652', '1651', '梅河口市', '3', '0', '126', '9999', '125'),
('1653', '1652', '辉南县', '3', '0', '126', '9999', '125'),
('1654', '1653', '通化县', '3', '0', '126', '9999', '125'),
('1655', '1654', '集安市', '3', '0', '126', '9999', '125'),
('1656', '1655', '临江市', '3', '0', '127', '9999', '126'),
('1657', '1656', '八道江区', '3', '0', '127', '9999', '126'),
('1658', '1657', '抚松县', '3', '0', '127', '9999', '126'),
('1659', '1658', '江源区', '3', '0', '127', '9999', '126'),
('1660', '1659', '长白朝鲜族自治县', '3', '0', '127', '9999', '126'),
('1661', '1660', '靖宇县', '3', '0', '127', '9999', '126'),
('1662', '1661', '乾安县', '3', '0', '128', '9999', '127'),
('1663', '1662', '前郭尔罗斯蒙古族自治县', '3', '0', '128', '9999', '127'),
('1664', '1663', '宁江区', '3', '0', '128', '9999', '127'),
('1665', '1664', '扶余市', '3', '0', '128', '9999', '127'),
('1666', '1665', '长岭县', '3', '0', '128', '9999', '127'),
('1667', '1666', '大安市', '3', '0', '129', '9999', '128'),
('1668', '1667', '洮北区', '3', '0', '129', '9999', '128'),
('1669', '1668', '洮南市', '3', '0', '129', '9999', '128'),
('1670', '1669', '通榆县', '3', '0', '129', '9999', '128'),
('1671', '1670', '镇赉县', '3', '0', '129', '9999', '128'),
('1672', '1671', '和龙市', '3', '0', '130', '9999', '129'),
('1673', '1672', '图们市', '3', '0', '130', '9999', '129'),
('1674', '1673', '安图县', '3', '0', '130', '9999', '129'),
('1675', '1674', '延吉市', '3', '0', '130', '9999', '129'),
('1676', '1675', '敦化市', '3', '0', '130', '9999', '129'),
('1677', '1676', '汪清县', '3', '0', '130', '9999', '129'),
('1678', '1677', '珲春市', '3', '0', '130', '9999', '129'),
('1679', '1678', '龙井市', '3', '0', '130', '9999', '129'),
('1680', '1679', '五常市', '3', '0', '131', '9999', '130'),
('1681', '1680', '依兰县', '3', '0', '131', '9999', '130'),
('1682', '1681', '南岗区', '3', '0', '131', '9999', '130'),
('1683', '1682', '双城市', '3', '0', '131', '9999', '130'),
('1684', '1683', '呼兰区', '3', '0', '131', '9999', '130'),
('1685', '1684', '哈尔滨市道里区', '3', '0', '131', '9999', '130'),
('1686', '1685', '宾县', '3', '0', '131', '9999', '130'),
('1687', '1686', '尚志市', '3', '0', '131', '9999', '130'),
('1688', '1687', '巴彦县', '3', '0', '131', '9999', '130'),
('1689', '1688', '平房区', '3', '0', '131', '9999', '130'),
('1690', '1689', '延寿县', '3', '0', '131', '9999', '130'),
('1691', '1690', '方正县', '3', '0', '131', '9999', '130'),
('1692', '1691', '木兰县', '3', '0', '131', '9999', '130'),
('1693', '1692', '松北区', '3', '0', '131', '9999', '130'),
('1694', '1693', '通河县', '3', '0', '131', '9999', '130'),
('1695', '1694', '道外区', '3', '0', '131', '9999', '130'),
('1696', '1695', '阿城区', '3', '0', '131', '9999', '130'),
('1697', '1696', '香坊区', '3', '0', '131', '9999', '130'),
('1698', '1697', '依安县', '3', '0', '132', '9999', '131'),
('1699', '1698', '克东县', '3', '0', '132', '9999', '131'),
('1700', '1699', '克山县', '3', '0', '132', '9999', '131'),
('1701', '1700', '富拉尔基区', '3', '0', '132', '9999', '131'),
('1702', '1701', '富裕县', '3', '0', '132', '9999', '131'),
('1703', '1702', '建华区', '3', '0', '132', '9999', '131'),
('1704', '1703', '拜泉县', '3', '0', '132', '9999', '131'),
('1705', '1704', '昂昂溪区', '3', '0', '132', '9999', '131'),
('1706', '1705', '梅里斯达斡尔族区', '3', '0', '132', '9999', '131'),
('1707', '1706', '泰来县', '3', '0', '132', '9999', '131'),
('1708', '1707', '甘南县', '3', '0', '132', '9999', '131'),
('1709', '1708', '碾子山区', '3', '0', '132', '9999', '131'),
('1710', '1709', '讷河市', '3', '0', '132', '9999', '131'),
('1711', '1710', '铁锋区', '3', '0', '132', '9999', '131'),
('1712', '1711', '龙江县', '3', '0', '132', '9999', '131'),
('1713', '1712', '龙沙区', '3', '0', '132', '9999', '131'),
('1714', '1713', '城子河区', '3', '0', '133', '9999', '132'),
('1715', '1714', '密山市', '3', '0', '133', '9999', '132'),
('1716', '1715', '恒山区', '3', '0', '133', '9999', '132'),
('1717', '1716', '梨树区', '3', '0', '133', '9999', '132'),
('1718', '1717', '滴道区', '3', '0', '133', '9999', '132'),
('1719', '1718', '虎林市', '3', '0', '133', '9999', '132'),
('1720', '1719', '鸡东县', '3', '0', '133', '9999', '132'),
('1721', '1720', '鸡冠区', '3', '0', '133', '9999', '132'),
('1722', '1721', '麻山区', '3', '0', '133', '9999', '132'),
('1723', '1722', '东山区', '3', '0', '134', '9999', '133'),
('1724', '1723', '兴安区', '3', '0', '134', '9999', '133'),
('1725', '1724', '兴山区', '3', '0', '134', '9999', '133'),
('1726', '1725', '南山区', '3', '0', '134', '9999', '133'),
('1727', '1726', '向阳区', '3', '0', '134', '9999', '133'),
('1728', '1727', '工农区', '3', '0', '134', '9999', '133'),
('1729', '1728', '绥滨县', '3', '0', '134', '9999', '133'),
('1730', '1729', '萝北县', '3', '0', '134', '9999', '133'),
('1731', '1730', '友谊县', '3', '0', '135', '9999', '134'),
('1732', '1731', '四方台区', '3', '0', '135', '9999', '134'),
('1733', '1732', '宝山区', '3', '0', '135', '9999', '134'),
('1734', '1733', '宝清县', '3', '0', '135', '9999', '134'),
('1735', '1734', '尖山区', '3', '0', '135', '9999', '134'),
('1736', '1735', '岭东区', '3', '0', '135', '9999', '134'),
('1737', '1736', '集贤县', '3', '0', '135', '9999', '134'),
('1738', '1737', '饶河县', '3', '0', '135', '9999', '134'),
('1739', '1738', '大同区', '3', '0', '136', '9999', '135'),
('1740', '1739', '杜尔伯特蒙古族自治县', '3', '0', '136', '9999', '135'),
('1741', '1740', '林甸县', '3', '0', '136', '9999', '135'),
('1742', '1741', '红岗区', '3', '0', '136', '9999', '135'),
('1743', '1742', '肇州县', '3', '0', '136', '9999', '135'),
('1744', '1743', '肇源县', '3', '0', '136', '9999', '135'),
('1745', '1744', '胡路区', '3', '0', '136', '9999', '135'),
('1746', '1745', '萨尔图区', '3', '0', '136', '9999', '135'),
('1747', '1746', '龙凤区', '3', '0', '136', '9999', '135'),
('1748', '1747', '上甘岭区', '3', '0', '137', '9999', '136'),
('1749', '1748', '乌伊岭区', '3', '0', '137', '9999', '136'),
('1750', '1749', '乌马河区', '3', '0', '137', '9999', '136'),
('1751', '1750', '五营区', '3', '0', '137', '9999', '136'),
('1752', '1751', '伊春区', '3', '0', '137', '9999', '136'),
('1753', '1752', '南岔区', '3', '0', '137', '9999', '136'),
('1754', '1753', '友好区', '3', '0', '137', '9999', '136'),
('1755', '1754', '嘉荫县', '3', '0', '137', '9999', '136'),
('1756', '1755', '带岭区', '3', '0', '137', '9999', '136'),
('1757', '1756', '新青区', '3', '0', '137', '9999', '136'),
('1758', '1757', '汤旺河区', '3', '0', '137', '9999', '136'),
('1759', '1758', '红星区', '3', '0', '137', '9999', '136'),
('1760', '1759', '美溪区', '3', '0', '137', '9999', '136'),
('1761', '1760', '翠峦区', '3', '0', '137', '9999', '136'),
('1762', '1761', '西林区', '3', '0', '137', '9999', '136'),
('1763', '1762', '金山屯区', '3', '0', '137', '9999', '136'),
('1764', '1763', '铁力市', '3', '0', '137', '9999', '136'),
('1765', '1764', '东风区', '3', '0', '138', '9999', '137'),
('1766', '1765', '前进区', '3', '0', '138', '9999', '137'),
('1767', '1766', '同江市', '3', '0', '138', '9999', '137'),
('1768', '1767', '向阳区', '3', '0', '138', '9999', '137'),
('1769', '1768', '富锦市', '3', '0', '138', '9999', '137'),
('1770', '1769', '抚远县', '3', '0', '138', '9999', '137'),
('1771', '1770', '桦南县', '3', '0', '138', '9999', '137'),
('1772', '1771', '桦川县', '3', '0', '138', '9999', '137'),
('1773', '1772', '汤原县', '3', '0', '138', '9999', '137'),
('1774', '1773', '郊区', '3', '0', '138', '9999', '137'),
('1775', '1774', '勃利县', '3', '0', '139', '9999', '138'),
('1776', '1775', '新兴区', '3', '0', '139', '9999', '138'),
('1777', '1776', '桃山区', '3', '0', '139', '9999', '138'),
('1778', '1777', '茄子河区', '3', '0', '139', '9999', '138'),
('1779', '1778', '东宁县', '3', '0', '140', '9999', '139'),
('1780', '1779', '东安区', '3', '0', '140', '9999', '139'),
('1781', '1780', '宁安市', '3', '0', '140', '9999', '139'),
('1782', '1781', '林口县', '3', '0', '140', '9999', '139'),
('1783', '1782', '海林市', '3', '0', '140', '9999', '139'),
('1784', '1783', '爱民区', '3', '0', '140', '9999', '139'),
('1785', '1784', '穆棱市', '3', '0', '140', '9999', '139'),
('1786', '1785', '绥芬河市', '3', '0', '140', '9999', '139'),
('1787', '1786', '西安区', '3', '0', '140', '9999', '139'),
('1788', '1787', '阳明区', '3', '0', '140', '9999', '139'),
('1789', '1788', '五大连池市', '3', '0', '141', '9999', '140'),
('1790', '1789', '北安市', '3', '0', '141', '9999', '140'),
('1791', '1790', '嫩江县', '3', '0', '141', '9999', '140'),
('1792', '1791', '孙吴县', '3', '0', '141', '9999', '140'),
('1793', '1792', '爱辉区', '3', '0', '141', '9999', '140'),
('1794', '1793', '车逊克县', '3', '0', '141', '9999', '140'),
('1795', '1794', '逊克县', '3', '0', '141', '9999', '140'),
('1796', '1795', '兰西县', '3', '0', '142', '9999', '141'),
('1797', '1796', '安达市', '3', '0', '142', '9999', '141'),
('1798', '1797', '庆安县', '3', '0', '142', '9999', '141'),
('1799', '1798', '明水县', '3', '0', '142', '9999', '141'),
('1800', '1799', '望奎县', '3', '0', '142', '9999', '141'),
('1801', '1800', '海伦市', '3', '0', '142', '9999', '141'),
('1802', '1801', '绥化市北林区', '3', '0', '142', '9999', '141'),
('1803', '1802', '绥棱县', '3', '0', '142', '9999', '141'),
('1804', '1803', '肇东市', '3', '0', '142', '9999', '141'),
('1805', '1804', '青冈县', '3', '0', '142', '9999', '141'),
('1806', '1805', '呼玛县', '3', '0', '143', '9999', '142'),
('1807', '1806', '塔河县', '3', '0', '143', '9999', '142'),
('1808', '1807', '大兴安岭地区加格达奇区', '3', '0', '143', '9999', '142'),
('1809', '1808', '大兴安岭地区呼中区', '3', '0', '143', '9999', '142'),
('1810', '1809', '大兴安岭地区新林区', '3', '0', '143', '9999', '142'),
('1811', '1810', '大兴安岭地区松岭区', '3', '0', '143', '9999', '142'),
('1812', '1811', '漠河县', '3', '0', '143', '9999', '142'),
('1917', '1916', '嘉定工业区', '3', '0', '155', '9999', '154'),
('1925', '1924', '菊园新区', '3', '0', '155', '9999', '154'),
('1961', '1960', '上海松江科技园区', '3', '0', '158', '9999', '157'),
('1964', '1963', '五厍农业园区', '3', '0', '158', '9999', '157'),
('1965', '1964', '佘山度假区', '3', '0', '158', '9999', '157'),
('1972', '1971', '松江工业区', '3', '0', '158', '9999', '157'),
('2028', '2027', '下关区', '3', '0', '163', '9999', '162'),
('2029', '2028', '六合区', '3', '0', '163', '9999', '162'),
('2030', '2029', '建邺区', '3', '0', '163', '9999', '162'),
('2031', '2030', '栖霞区', '3', '0', '163', '9999', '162'),
('2032', '2031', '江宁区', '3', '0', '163', '9999', '162'),
('2033', '2032', '浦口区', '3', '0', '163', '9999', '162'),
('2034', '2033', '溧水县', '3', '0', '163', '9999', '162'),
('2035', '2034', '玄武区', '3', '0', '163', '9999', '162'),
('2036', '2035', '白下区', '3', '0', '163', '9999', '162'),
('2037', '2036', '秦淮区', '3', '0', '163', '9999', '162'),
('2038', '2037', '雨花台区', '3', '0', '163', '9999', '162'),
('2039', '2038', '高淳县', '3', '0', '163', '9999', '162'),
('2040', '2039', '鼓楼区', '3', '0', '163', '9999', '162'),
('2041', '2040', '北塘区', '3', '0', '164', '9999', '163'),
('2042', '2041', '南长区', '3', '0', '164', '9999', '163'),
('2043', '2042', '宜兴市', '3', '0', '164', '9999', '163'),
('2044', '2043', '崇安区', '3', '0', '164', '9999', '163'),
('2045', '2044', '惠山区', '3', '0', '164', '9999', '163'),
('2046', '2045', '江阴市', '3', '0', '164', '9999', '163'),
('2047', '2046', '滨湖区', '3', '0', '164', '9999', '163'),
('2048', '2047', '锡山区', '3', '0', '164', '9999', '163'),
('2049', '2048', '丰县', '3', '0', '165', '9999', '164'),
('2050', '2049', '九里区', '3', '0', '165', '9999', '164'),
('2051', '2050', '云龙区', '3', '0', '165', '9999', '164'),
('2052', '2051', '新沂市', '3', '0', '165', '9999', '164'),
('2053', '2052', '沛县', '3', '0', '165', '9999', '164'),
('2054', '2053', '泉山区', '3', '0', '165', '9999', '164'),
('2055', '2054', '睢宁县', '3', '0', '165', '9999', '164'),
('2056', '2055', '贾汪区', '3', '0', '165', '9999', '164'),
('2057', '2056', '邳州市', '3', '0', '165', '9999', '164'),
('2058', '2057', '铜山区', '3', '0', '165', '9999', '164'),
('2059', '2058', '鼓楼区', '3', '0', '165', '9999', '164'),
('2060', '2059', '天宁区', '3', '0', '166', '9999', '165'),
('2061', '2060', '戚墅堰区', '3', '0', '166', '9999', '165'),
('2062', '2061', '新北区', '3', '0', '166', '9999', '165'),
('2063', '2062', '武进区', '3', '0', '166', '9999', '165'),
('2064', '2063', '溧阳市', '3', '0', '166', '9999', '165'),
('2065', '2064', '金坛市', '3', '0', '166', '9999', '165'),
('2066', '2065', '钟楼区', '3', '0', '166', '9999', '165'),
('2067', '2066', '吴中区', '3', '0', '167', '9999', '166'),
('2068', '2067', '吴江区', '3', '0', '167', '9999', '166'),
('2069', '2068', '太仓市', '3', '0', '167', '9999', '166'),
('2070', '2069', '常熟市', '3', '0', '167', '9999', '166'),
('2071', '2070', '平江区', '3', '0', '167', '9999', '166'),
('2072', '2071', '张家港市', '3', '0', '167', '9999', '166'),
('2073', '2072', '昆山市', '3', '0', '167', '9999', '166'),
('2074', '2073', '沧浪区', '3', '0', '167', '9999', '166'),
('2075', '2074', '相城区', '3', '0', '167', '9999', '166'),
('2076', '2075', '苏州工业园区', '3', '0', '167', '9999', '166'),
('2077', '2076', '虎丘区', '3', '0', '167', '9999', '166'),
('2078', '2077', '金阊区', '3', '0', '167', '9999', '166'),
('2079', '2078', '启东市', '3', '0', '168', '9999', '167'),
('2080', '2079', '如东县', '3', '0', '168', '9999', '167'),
('2081', '2080', '如皋市', '3', '0', '168', '9999', '167'),
('2082', '2081', '崇川区', '3', '0', '168', '9999', '167'),
('2083', '2082', '海安县', '3', '0', '168', '9999', '167'),
('2084', '2083', '海门市', '3', '0', '168', '9999', '167'),
('2085', '2084', '港闸区', '3', '0', '168', '9999', '167'),
('2086', '2085', '通州区', '3', '0', '168', '9999', '167'),
('2087', '2086', '东海县', '3', '0', '169', '9999', '168'),
('2088', '2087', '新浦区', '3', '0', '169', '9999', '168'),
('2089', '2088', '海州区', '3', '0', '169', '9999', '168'),
('2090', '2089', '灌云县', '3', '0', '169', '9999', '168'),
('2091', '2090', '灌南县', '3', '0', '169', '9999', '168'),
('2092', '2091', '赣榆县', '3', '0', '169', '9999', '168'),
('2093', '2092', '连云区', '3', '0', '169', '9999', '168'),
('2094', '2093', '楚州区', '3', '0', '170', '9999', '169'),
('2095', '2094', '洪泽县', '3', '0', '170', '9999', '169'),
('2096', '2095', '涟水县', '3', '0', '170', '9999', '169'),
('2097', '2096', '淮阴区', '3', '0', '170', '9999', '169'),
('2098', '2097', '清河区', '3', '0', '170', '9999', '169'),
('2099', '2098', '清浦区', '3', '0', '170', '9999', '169'),
('2100', '2099', '盱眙县', '3', '0', '170', '9999', '169'),
('2101', '2100', '金湖县', '3', '0', '170', '9999', '169'),
('2102', '2101', '东台市', '3', '0', '171', '9999', '170'),
('2103', '2102', '亭湖区', '3', '0', '171', '9999', '170'),
('2104', '2103', '响水县', '3', '0', '171', '9999', '170'),
('2105', '2104', '大丰市', '3', '0', '171', '9999', '170'),
('2106', '2105', '射阳县', '3', '0', '171', '9999', '170'),
('2107', '2106', '建湖县', '3', '0', '171', '9999', '170'),
('2108', '2107', '滨海县', '3', '0', '171', '9999', '170'),
('2109', '2108', '盐都区', '3', '0', '171', '9999', '170'),
('2110', '2109', '阜宁县', '3', '0', '171', '9999', '170'),
('2111', '2110', '仪征市', '3', '0', '172', '9999', '171'),
('2112', '2111', '宝应县', '3', '0', '172', '9999', '171'),
('2113', '2112', '广陵区', '3', '0', '172', '9999', '171'),
('2114', '2113', '江都区', '3', '0', '172', '9999', '171'),
('2115', '2114', '维扬区', '3', '0', '172', '9999', '171'),
('2116', '2115', '邗江区', '3', '0', '172', '9999', '171'),
('2117', '2116', '高邮市', '3', '0', '172', '9999', '171'),
('2118', '2117', '丹徒区', '3', '0', '173', '9999', '172'),
('2119', '2118', '丹阳市', '3', '0', '173', '9999', '172'),
('2120', '2119', '京口区', '3', '0', '173', '9999', '172'),
('2121', '2120', '句容市', '3', '0', '173', '9999', '172'),
('2122', '2121', '扬中市', '3', '0', '173', '9999', '172'),
('2123', '2122', '润州区', '3', '0', '173', '9999', '172'),
('2124', '2123', '兴化市', '3', '0', '174', '9999', '173'),
('2125', '2124', '姜堰区', '3', '0', '174', '9999', '173'),
('2126', '2125', '泰兴市', '3', '0', '174', '9999', '173'),
('2127', '2126', '海陵区', '3', '0', '174', '9999', '173'),
('2128', '2127', '靖江市', '3', '0', '174', '9999', '173'),
('2129', '2128', '高港区', '3', '0', '174', '9999', '173'),
('2130', '2129', '宿城区', '3', '0', '175', '9999', '174'),
('2131', '2130', '宿豫区', '3', '0', '175', '9999', '174'),
('2132', '2131', '沭阳县', '3', '0', '175', '9999', '174'),
('2133', '2132', '泗洪县', '3', '0', '175', '9999', '174'),
('2134', '2133', '泗阳县', '3', '0', '175', '9999', '174'),
('2135', '2134', '上城区', '3', '0', '176', '9999', '175'),
('2136', '2135', '下城区', '3', '0', '176', '9999', '175'),
('2137', '2136', '临安市', '3', '0', '176', '9999', '175'),
('2138', '2137', '余杭区', '3', '0', '176', '9999', '175'),
('2139', '2138', '富阳市', '3', '0', '176', '9999', '175'),
('2140', '2139', '建德市', '3', '0', '176', '9999', '175'),
('2141', '2140', '拱墅区', '3', '0', '176', '9999', '175'),
('2142', '2141', '桐庐县', '3', '0', '176', '9999', '175'),
('2143', '2142', '江干区', '3', '0', '176', '9999', '175'),
('2144', '2143', '淳安县', '3', '0', '176', '9999', '175'),
('2145', '2144', '滨江区', '3', '0', '176', '9999', '175'),
('2146', '2145', '萧山区', '3', '0', '176', '9999', '175'),
('2147', '2146', '西湖区', '3', '0', '176', '9999', '175'),
('2148', '2147', '余姚市', '3', '0', '177', '9999', '176'),
('2149', '2148', '北仑区', '3', '0', '177', '9999', '176'),
('2150', '2149', '奉化市', '3', '0', '177', '9999', '176'),
('2151', '2150', '宁海县', '3', '0', '177', '9999', '176'),
('2152', '2151', '慈溪市', '3', '0', '177', '9999', '176'),
('2153', '2152', '江东区', '3', '0', '177', '9999', '176'),
('2154', '2153', '江北区', '3', '0', '177', '9999', '176'),
('2155', '2154', '海曙区', '3', '0', '177', '9999', '176'),
('2156', '2155', '象山县', '3', '0', '177', '9999', '176'),
('2157', '2156', '鄞州区', '3', '0', '177', '9999', '176'),
('2158', '2157', '镇海区', '3', '0', '177', '9999', '176'),
('2159', '2158', '乐清市', '3', '0', '178', '9999', '177'),
('2160', '2159', '平阳县', '3', '0', '178', '9999', '177'),
('2161', '2160', '文成县', '3', '0', '178', '9999', '177'),
('2162', '2161', '永嘉县', '3', '0', '178', '9999', '177'),
('2163', '2162', '泰顺县', '3', '0', '178', '9999', '177'),
('2164', '2163', '洞头县', '3', '0', '178', '9999', '177'),
('2165', '2164', '瑞安市', '3', '0', '178', '9999', '177'),
('2166', '2165', '瓯海区', '3', '0', '178', '9999', '177'),
('2167', '2166', '苍南县', '3', '0', '178', '9999', '177'),
('2168', '2167', '鹿城区', '3', '0', '178', '9999', '177'),
('2169', '2168', '龙湾区', '3', '0', '178', '9999', '177'),
('2170', '2169', '南湖区', '3', '0', '179', '9999', '178'),
('2171', '2170', '嘉善县', '3', '0', '179', '9999', '178'),
('2172', '2171', '平湖市', '3', '0', '179', '9999', '178'),
('2173', '2172', '桐乡市', '3', '0', '179', '9999', '178'),
('2174', '2173', '海宁市', '3', '0', '179', '9999', '178'),
('2175', '2174', '海盐县', '3', '0', '179', '9999', '178'),
('2176', '2175', '秀洲区', '3', '0', '179', '9999', '178'),
('2177', '2176', '南浔区', '3', '0', '180', '9999', '179'),
('2178', '2177', '吴兴区', '3', '0', '180', '9999', '179'),
('2179', '2178', '安吉县', '3', '0', '180', '9999', '179'),
('2180', '2179', '德清县', '3', '0', '180', '9999', '179'),
('2181', '2180', '长兴县', '3', '0', '180', '9999', '179'),
('2182', '2181', '上虞市', '3', '0', '181', '9999', '180'),
('2183', '2182', '嵊州市', '3', '0', '181', '9999', '180'),
('2184', '2183', '新昌县', '3', '0', '181', '9999', '180'),
('2185', '2184', '绍兴县', '3', '0', '181', '9999', '180'),
('2186', '2185', '诸暨市', '3', '0', '181', '9999', '180'),
('2187', '2186', '越城区', '3', '0', '181', '9999', '180'),
('2188', '2187', '定海区', '3', '0', '182', '9999', '181'),
('2189', '2188', '岱山县', '3', '0', '182', '9999', '181'),
('2190', '2189', '嵊泗县', '3', '0', '182', '9999', '181'),
('2191', '2190', '普陀区', '3', '0', '182', '9999', '181'),
('2192', '2191', '常山县', '3', '0', '183', '9999', '182'),
('2193', '2192', '开化县', '3', '0', '183', '9999', '182'),
('2194', '2193', '柯城区', '3', '0', '183', '9999', '182'),
('2195', '2194', '江山市', '3', '0', '183', '9999', '182'),
('2196', '2195', '衢江区', '3', '0', '183', '9999', '182'),
('2197', '2196', '龙游县', '3', '0', '183', '9999', '182'),
('2198', '2197', '东阳市', '3', '0', '184', '9999', '183'),
('2199', '2198', '义乌市', '3', '0', '184', '9999', '183'),
('2200', '2199', '兰溪市', '3', '0', '184', '9999', '183'),
('2201', '2200', '婺城区', '3', '0', '184', '9999', '183'),
('2202', '2201', '武义县', '3', '0', '184', '9999', '183'),
('2203', '2202', '永康市', '3', '0', '184', '9999', '183'),
('2204', '2203', '浦江县', '3', '0', '184', '9999', '183'),
('2205', '2204', '磐安县', '3', '0', '184', '9999', '183'),
('2206', '2205', '金东区', '3', '0', '184', '9999', '183'),
('2207', '2206', '三门县', '3', '0', '185', '9999', '184'),
('2208', '2207', '临海市', '3', '0', '185', '9999', '184'),
('2209', '2208', '仙居县', '3', '0', '185', '9999', '184'),
('2210', '2209', '天台县', '3', '0', '185', '9999', '184'),
('2211', '2210', '椒江区', '3', '0', '185', '9999', '184'),
('2212', '2211', '温岭市', '3', '0', '185', '9999', '184'),
('2213', '2212', '玉环县', '3', '0', '185', '9999', '184'),
('2214', '2213', '路桥区', '3', '0', '185', '9999', '184'),
('2215', '2214', '黄岩区', '3', '0', '185', '9999', '184'),
('2216', '2215', '云和县', '3', '0', '186', '9999', '185'),
('2217', '2216', '庆元县', '3', '0', '186', '9999', '185'),
('2218', '2217', '景宁畲族自治县', '3', '0', '186', '9999', '185'),
('2219', '2218', '松阳县', '3', '0', '186', '9999', '185'),
('2220', '2219', '缙云县', '3', '0', '186', '9999', '185'),
('2221', '2220', '莲都区', '3', '0', '186', '9999', '185'),
('2222', '2221', '遂昌县', '3', '0', '186', '9999', '185'),
('2223', '2222', '青田县', '3', '0', '186', '9999', '185'),
('2224', '2223', '龙泉市', '3', '0', '186', '9999', '185'),
('2225', '2224', '包河区', '3', '0', '187', '9999', '186'),
('2226', '2225', '庐阳区', '3', '0', '187', '9999', '186'),
('2227', '2226', '瑶海区', '3', '0', '187', '9999', '186'),
('2228', '2227', '肥东县', '3', '0', '187', '9999', '186'),
('2229', '2228', '肥西县', '3', '0', '187', '9999', '186'),
('2230', '2229', '蜀山区', '3', '0', '187', '9999', '186'),
('2231', '2230', '长丰县', '3', '0', '187', '9999', '186'),
('2232', '2231', '三山区', '3', '0', '188', '9999', '187'),
('2233', '2232', '南陵县', '3', '0', '188', '9999', '187'),
('2234', '2233', '弋江区', '3', '0', '188', '9999', '187'),
('2235', '2234', '繁昌县', '3', '0', '188', '9999', '187'),
('2236', '2235', '芜湖县', '3', '0', '188', '9999', '187'),
('2237', '2236', '镜湖区', '3', '0', '188', '9999', '187'),
('2238', '2237', '鸠江区', '3', '0', '188', '9999', '187'),
('2239', '2238', '五河县', '3', '0', '189', '9999', '188'),
('2240', '2239', '固镇县', '3', '0', '189', '9999', '188'),
('2241', '2240', '怀远县', '3', '0', '189', '9999', '188'),
('2242', '2241', '淮上区', '3', '0', '189', '9999', '188'),
('2243', '2242', '禹会区', '3', '0', '189', '9999', '188'),
('2244', '2243', '蚌山区', '3', '0', '189', '9999', '188'),
('2245', '2244', '龙子湖区', '3', '0', '189', '9999', '188'),
('2246', '2245', '八公山区', '3', '0', '190', '9999', '189'),
('2247', '2246', '凤台县', '3', '0', '190', '9999', '189'),
('2248', '2247', '大通区', '3', '0', '190', '9999', '189'),
('2249', '2248', '潘集区', '3', '0', '190', '9999', '189'),
('2250', '2249', '田家庵区', '3', '0', '190', '9999', '189'),
('2251', '2250', '谢家集区', '3', '0', '190', '9999', '189'),
('2252', '2251', '当涂县', '3', '0', '191', '9999', '190'),
('2253', '2252', '花山区', '3', '0', '191', '9999', '190'),
('2254', '2253', '金家庄区', '3', '0', '191', '9999', '190'),
('2255', '2254', '雨山区', '3', '0', '191', '9999', '190'),
('2256', '2255', '杜集区', '3', '0', '192', '9999', '191'),
('2257', '2256', '濉溪县', '3', '0', '192', '9999', '191'),
('2258', '2257', '烈山区', '3', '0', '192', '9999', '191'),
('2259', '2258', '相山区', '3', '0', '192', '9999', '191'),
('2260', '2259', '狮子山区', '3', '0', '193', '9999', '192'),
('2261', '2260', '郊区', '3', '0', '193', '9999', '192'),
('2262', '2261', '铜官山区', '3', '0', '193', '9999', '192'),
('2263', '2262', '铜陵县', '3', '0', '193', '9999', '192'),
('2264', '2263', '大观区', '3', '0', '194', '9999', '193'),
('2265', '2264', '太湖县', '3', '0', '194', '9999', '193'),
('2266', '2265', '宜秀区', '3', '0', '194', '9999', '193'),
('2267', '2266', '宿松县', '3', '0', '194', '9999', '193'),
('2268', '2267', '岳西县', '3', '0', '194', '9999', '193'),
('2269', '2268', '怀宁县', '3', '0', '194', '9999', '193'),
('2270', '2269', '望江县', '3', '0', '194', '9999', '193'),
('2271', '2270', '枞阳县', '3', '0', '194', '9999', '193'),
('2272', '2271', '桐城市', '3', '0', '194', '9999', '193'),
('2273', '2272', '潜山县', '3', '0', '194', '9999', '193'),
('2274', '2273', '迎江区', '3', '0', '194', '9999', '193'),
('2275', '2274', '休宁县', '3', '0', '195', '9999', '194'),
('2276', '2275', '屯溪区', '3', '0', '195', '9999', '194'),
('2277', '2276', '徽州区', '3', '0', '195', '9999', '194'),
('2278', '2277', '歙县', '3', '0', '195', '9999', '194'),
('2279', '2278', '祁门县', '3', '0', '195', '9999', '194'),
('2280', '2279', '黄山区', '3', '0', '195', '9999', '194'),
('2281', '2280', '黟县', '3', '0', '195', '9999', '194'),
('2282', '2281', '全椒县', '3', '0', '196', '9999', '195'),
('2283', '2282', '凤阳县', '3', '0', '196', '9999', '195'),
('2284', '2283', '南谯区', '3', '0', '196', '9999', '195'),
('2285', '2284', '天长市', '3', '0', '196', '9999', '195'),
('2286', '2285', '定远县', '3', '0', '196', '9999', '195'),
('2287', '2286', '明光市', '3', '0', '196', '9999', '195'),
('2288', '2287', '来安县', '3', '0', '196', '9999', '195'),
('2289', '2288', '琅玡区', '3', '0', '196', '9999', '195'),
('2290', '2289', '临泉县', '3', '0', '197', '9999', '196'),
('2291', '2290', '太和县', '3', '0', '197', '9999', '196'),
('2292', '2291', '界首市', '3', '0', '197', '9999', '196'),
('2293', '2292', '阜南县', '3', '0', '197', '9999', '196'),
('2294', '2293', '颍东区', '3', '0', '197', '9999', '196'),
('2295', '2294', '颍州区', '3', '0', '197', '9999', '196'),
('2296', '2295', '颍泉区', '3', '0', '197', '9999', '196'),
('2297', '2296', '颖上县', '3', '0', '197', '9999', '196'),
('2298', '2297', '埇桥区', '3', '0', '198', '9999', '197'),
('2299', '2298', '泗县', '3', '0', '198', '9999', '197'),
('2300', '2299', '灵璧县', '3', '0', '198', '9999', '197'),
('2301', '2300', '砀山县', '3', '0', '198', '9999', '197'),
('2302', '2301', '萧县', '3', '0', '198', '9999', '197'),
('2303', '2302', '含山县', '3', '0', '199', '9999', '198'),
('2304', '2303', '和县', '3', '0', '199', '9999', '198'),
('2305', '2304', '居巢区', '3', '0', '199', '9999', '198'),
('2306', '2305', '庐江县', '3', '0', '199', '9999', '198'),
('2307', '2306', '无为县', '3', '0', '199', '9999', '198'),
('2308', '2307', '寿县', '3', '0', '200', '9999', '199'),
('2309', '2308', '舒城县', '3', '0', '200', '9999', '199'),
('2310', '2309', '裕安区', '3', '0', '200', '9999', '199'),
('2311', '2310', '金安区', '3', '0', '200', '9999', '199'),
('2312', '2311', '金寨县', '3', '0', '200', '9999', '199'),
('2313', '2312', '霍山县', '3', '0', '200', '9999', '199'),
('2314', '2313', '霍邱县', '3', '0', '200', '9999', '199'),
('2315', '2314', '利辛县', '3', '0', '201', '9999', '200'),
('2316', '2315', '涡阳县', '3', '0', '201', '9999', '200'),
('2317', '2316', '蒙城县', '3', '0', '201', '9999', '200'),
('2318', '2317', '谯城区', '3', '0', '201', '9999', '200'),
('2319', '2318', '东至县', '3', '0', '202', '9999', '201'),
('2320', '2319', '石台县', '3', '0', '202', '9999', '201'),
('2321', '2320', '贵池区', '3', '0', '202', '9999', '201'),
('2322', '2321', '青阳县', '3', '0', '202', '9999', '201'),
('2323', '2322', '宁国市', '3', '0', '203', '9999', '202'),
('2324', '2323', '宣州区', '3', '0', '203', '9999', '202'),
('2325', '2324', '广德县', '3', '0', '203', '9999', '202'),
('2326', '2325', '旌德县', '3', '0', '203', '9999', '202'),
('2327', '2326', '泾县', '3', '0', '203', '9999', '202'),
('2328', '2327', '绩溪县', '3', '0', '203', '9999', '202'),
('2329', '2328', '郎溪县', '3', '0', '203', '9999', '202'),
('2330', '2329', '仓山区', '3', '0', '204', '9999', '203'),
('2331', '2330', '台江区', '3', '0', '204', '9999', '203'),
('2332', '2331', '平潭县', '3', '0', '204', '9999', '203'),
('2333', '2332', '晋安区', '3', '0', '204', '9999', '203'),
('2334', '2333', '永泰县', '3', '0', '204', '9999', '203'),
('2335', '2334', '福清市', '3', '0', '204', '9999', '203'),
('2336', '2335', '罗源县', '3', '0', '204', '9999', '203'),
('2337', '2336', '连江县', '3', '0', '204', '9999', '203'),
('2338', '2337', '长乐市', '3', '0', '204', '9999', '203'),
('2339', '2338', '闽侯县', '3', '0', '204', '9999', '203'),
('2340', '2339', '闽清县', '3', '0', '204', '9999', '203'),
('2341', '2340', '马尾区', '3', '0', '204', '9999', '203'),
('2342', '2341', '鼓楼区', '3', '0', '204', '9999', '203'),
('2343', '2342', '同安区', '3', '0', '205', '9999', '204'),
('2344', '2343', '思明区', '3', '0', '205', '9999', '204'),
('2345', '2344', '海沧区', '3', '0', '205', '9999', '204'),
('2346', '2345', '湖里区', '3', '0', '205', '9999', '204'),
('2347', '2346', '翔安区', '3', '0', '205', '9999', '204'),
('2348', '2347', '集美区', '3', '0', '205', '9999', '204'),
('2349', '2348', '仙游县', '3', '0', '206', '9999', '205'),
('2350', '2349', '城厢区', '3', '0', '206', '9999', '205'),
('2351', '2350', '涵江区', '3', '0', '206', '9999', '205'),
('2352', '2351', '秀屿区', '3', '0', '206', '9999', '205'),
('2353', '2352', '荔城区', '3', '0', '206', '9999', '205'),
('2354', '2353', '三元区', '3', '0', '207', '9999', '206'),
('2355', '2354', '大田县', '3', '0', '207', '9999', '206'),
('2356', '2355', '宁化县', '3', '0', '207', '9999', '206'),
('2357', '2356', '将乐县', '3', '0', '207', '9999', '206'),
('2358', '2357', '尤溪县', '3', '0', '207', '9999', '206'),
('2359', '2358', '建宁县', '3', '0', '207', '9999', '206'),
('2360', '2359', '明溪县', '3', '0', '207', '9999', '206'),
('2361', '2360', '梅列区', '3', '0', '207', '9999', '206'),
('2362', '2361', '永安市', '3', '0', '207', '9999', '206'),
('2363', '2362', '沙县', '3', '0', '207', '9999', '206'),
('2364', '2363', '泰宁县', '3', '0', '207', '9999', '206'),
('2365', '2364', '清流县', '3', '0', '207', '9999', '206'),
('2366', '2365', '丰泽区', '3', '0', '208', '9999', '207'),
('2367', '2366', '南安市', '3', '0', '208', '9999', '207'),
('2368', '2367', '安溪县', '3', '0', '208', '9999', '207'),
('2369', '2368', '德化县', '3', '0', '208', '9999', '207'),
('2370', '2369', '惠安县', '3', '0', '208', '9999', '207'),
('2371', '2370', '晋江市', '3', '0', '208', '9999', '207'),
('2372', '2371', '永春县', '3', '0', '208', '9999', '207'),
('2373', '2372', '泉港区', '3', '0', '208', '9999', '207'),
('2374', '2373', '洛江区', '3', '0', '208', '9999', '207'),
('2375', '2374', '石狮市', '3', '0', '208', '9999', '207'),
('2376', '2375', '金门县', '3', '0', '208', '9999', '207'),
('2377', '2376', '鲤城区', '3', '0', '208', '9999', '207'),
('2378', '2377', '东山县', '3', '0', '209', '9999', '208'),
('2379', '2378', '云霄县', '3', '0', '209', '9999', '208'),
('2380', '2379', '华安县', '3', '0', '209', '9999', '208'),
('2381', '2380', '南靖县', '3', '0', '209', '9999', '208'),
('2382', '2381', '平和县', '3', '0', '209', '9999', '208'),
('2383', '2382', '漳浦县', '3', '0', '209', '9999', '208'),
('2384', '2383', '芗城区', '3', '0', '209', '9999', '208'),
('2385', '2384', '诏安县', '3', '0', '209', '9999', '208'),
('2386', '2385', '长泰县', '3', '0', '209', '9999', '208'),
('2387', '2386', '龙文区', '3', '0', '209', '9999', '208'),
('2388', '2387', '龙海市', '3', '0', '209', '9999', '208'),
('2389', '2388', '光泽县', '3', '0', '210', '9999', '209'),
('2390', '2389', '延平区', '3', '0', '210', '9999', '209'),
('2391', '2390', '建瓯市', '3', '0', '210', '9999', '209'),
('2392', '2391', '建阳市', '3', '0', '210', '9999', '209'),
('2393', '2392', '政和县', '3', '0', '210', '9999', '209'),
('2394', '2393', '松溪县', '3', '0', '210', '9999', '209'),
('2395', '2394', '武夷山市', '3', '0', '210', '9999', '209'),
('2396', '2395', '浦城县', '3', '0', '210', '9999', '209'),
('2397', '2396', '邵武市', '3', '0', '210', '9999', '209'),
('2398', '2397', '顺昌县', '3', '0', '210', '9999', '209'),
('2399', '2398', '上杭县', '3', '0', '211', '9999', '210'),
('2400', '2399', '新罗区', '3', '0', '211', '9999', '210'),
('2401', '2400', '武平县', '3', '0', '211', '9999', '210'),
('2402', '2401', '永定县', '3', '0', '211', '9999', '210'),
('2403', '2402', '漳平市', '3', '0', '211', '9999', '210'),
('2404', '2403', '连城县', '3', '0', '211', '9999', '210'),
('2405', '2404', '长汀县', '3', '0', '211', '9999', '210'),
('2406', '2405', '古田县', '3', '0', '212', '9999', '211'),
('2407', '2406', '周宁县', '3', '0', '212', '9999', '211'),
('2408', '2407', '寿宁县', '3', '0', '212', '9999', '211'),
('2409', '2408', '屏南县', '3', '0', '212', '9999', '211'),
('2410', '2409', '柘荣县', '3', '0', '212', '9999', '211'),
('2411', '2410', '福安市', '3', '0', '212', '9999', '211'),
('2412', '2411', '福鼎市', '3', '0', '212', '9999', '211'),
('2413', '2412', '蕉城区', '3', '0', '212', '9999', '211'),
('2414', '2413', '霞浦县', '3', '0', '212', '9999', '211'),
('2415', '2414', '东湖区', '3', '0', '213', '9999', '212'),
('2416', '2415', '南昌县', '3', '0', '213', '9999', '212'),
('2417', '2416', '安义县', '3', '0', '213', '9999', '212'),
('2418', '2417', '新建县', '3', '0', '213', '9999', '212'),
('2419', '2418', '湾里区', '3', '0', '213', '9999', '212'),
('2420', '2419', '西湖区', '3', '0', '213', '9999', '212'),
('2421', '2420', '进贤县', '3', '0', '213', '9999', '212'),
('2422', '2421', '青云谱区', '3', '0', '213', '9999', '212'),
('2423', '2422', '青山湖区', '3', '0', '213', '9999', '212'),
('2424', '2423', '乐平市', '3', '0', '214', '9999', '213'),
('2425', '2424', '昌江区', '3', '0', '214', '9999', '213'),
('2426', '2425', '浮梁县', '3', '0', '214', '9999', '213'),
('2427', '2426', '珠山区', '3', '0', '214', '9999', '213'),
('2428', '2427', '上栗县', '3', '0', '215', '9999', '214'),
('2429', '2428', '安源区', '3', '0', '215', '9999', '214'),
('2430', '2429', '湘东区', '3', '0', '215', '9999', '214'),
('2431', '2430', '芦溪县', '3', '0', '215', '9999', '214'),
('2432', '2431', '莲花县', '3', '0', '215', '9999', '214'),
('2433', '2432', '九江县', '3', '0', '216', '9999', '215'),
('2434', '2433', '修水县', '3', '0', '216', '9999', '215'),
('2435', '2434', '庐山区', '3', '0', '216', '9999', '215'),
('2436', '2435', '彭泽县', '3', '0', '216', '9999', '215'),
('2437', '2436', '德安县', '3', '0', '216', '9999', '215'),
('2438', '2437', '星子县', '3', '0', '216', '9999', '215'),
('2439', '2438', '武宁县', '3', '0', '216', '9999', '215'),
('2440', '2439', '永修县', '3', '0', '216', '9999', '215'),
('2441', '2440', '浔阳区', '3', '0', '216', '9999', '215'),
('2442', '2441', '湖口县', '3', '0', '216', '9999', '215'),
('2443', '2442', '瑞昌市', '3', '0', '216', '9999', '215'),
('2444', '2443', '都昌县', '3', '0', '216', '9999', '215'),
('2445', '2444', '分宜县', '3', '0', '217', '9999', '216'),
('2446', '2445', '渝水区', '3', '0', '217', '9999', '216'),
('2447', '2446', '余江县', '3', '0', '218', '9999', '217'),
('2448', '2447', '月湖区', '3', '0', '218', '9999', '217'),
('2449', '2448', '贵溪市', '3', '0', '218', '9999', '217'),
('2450', '2449', '上犹县', '3', '0', '219', '9999', '218'),
('2451', '2450', '于都县', '3', '0', '219', '9999', '218'),
('2452', '2451', '会昌县', '3', '0', '219', '9999', '218'),
('2453', '2452', '信丰县', '3', '0', '219', '9999', '218'),
('2454', '2453', '全南县', '3', '0', '219', '9999', '218'),
('2455', '2454', '兴国县', '3', '0', '219', '9999', '218'),
('2456', '2455', '南康市', '3', '0', '219', '9999', '218'),
('2457', '2456', '大余县', '3', '0', '219', '9999', '218'),
('2458', '2457', '宁都县', '3', '0', '219', '9999', '218'),
('2459', '2458', '安远县', '3', '0', '219', '9999', '218'),
('2460', '2459', '定南县', '3', '0', '219', '9999', '218'),
('2461', '2460', '寻乌县', '3', '0', '219', '9999', '218'),
('2462', '2461', '崇义县', '3', '0', '219', '9999', '218'),
('2463', '2462', '瑞金市', '3', '0', '219', '9999', '218'),
('2464', '2463', '石城县', '3', '0', '219', '9999', '218'),
('2465', '2464', '章贡区', '3', '0', '219', '9999', '218'),
('2466', '2465', '赣县', '3', '0', '219', '9999', '218'),
('2467', '2466', '龙南县', '3', '0', '219', '9999', '218'),
('2468', '2467', '万安县', '3', '0', '220', '9999', '219'),
('2469', '2468', '井冈山市', '3', '0', '220', '9999', '219'),
('2470', '2469', '吉安县', '3', '0', '220', '9999', '219'),
('2471', '2470', '吉州区', '3', '0', '220', '9999', '219'),
('2472', '2471', '吉水县', '3', '0', '220', '9999', '219'),
('2473', '2472', '安福县', '3', '0', '220', '9999', '219'),
('2474', '2473', '峡江县', '3', '0', '220', '9999', '219'),
('2475', '2474', '新干县', '3', '0', '220', '9999', '219'),
('2476', '2475', '永丰县', '3', '0', '220', '9999', '219'),
('2477', '2476', '永新县', '3', '0', '220', '9999', '219'),
('2478', '2477', '泰和县', '3', '0', '220', '9999', '219'),
('2479', '2478', '遂川县', '3', '0', '220', '9999', '219'),
('2480', '2479', '青原区', '3', '0', '220', '9999', '219'),
('2481', '2480', '万载县', '3', '0', '221', '9999', '220'),
('2482', '2481', '上高县', '3', '0', '221', '9999', '220'),
('2483', '2482', '丰城市', '3', '0', '221', '9999', '220'),
('2484', '2483', '奉新县', '3', '0', '221', '9999', '220'),
('2485', '2484', '宜丰县', '3', '0', '221', '9999', '220'),
('2486', '2485', '樟树市', '3', '0', '221', '9999', '220'),
('2487', '2486', '袁州区', '3', '0', '221', '9999', '220'),
('2488', '2487', '铜鼓县', '3', '0', '221', '9999', '220'),
('2489', '2488', '靖安县', '3', '0', '221', '9999', '220'),
('2490', '2489', '高安市', '3', '0', '221', '9999', '220'),
('2491', '2490', '东乡县', '3', '0', '222', '9999', '221'),
('2492', '2491', '临川区', '3', '0', '222', '9999', '221'),
('2493', '2492', '乐安县', '3', '0', '222', '9999', '221'),
('2494', '2493', '南丰县', '3', '0', '222', '9999', '221'),
('2495', '2494', '南城县', '3', '0', '222', '9999', '221'),
('2496', '2495', '宜黄县', '3', '0', '222', '9999', '221'),
('2497', '2496', '崇仁县', '3', '0', '222', '9999', '221'),
('2498', '2497', '广昌县', '3', '0', '222', '9999', '221'),
('2499', '2498', '资溪县', '3', '0', '222', '9999', '221'),
('2500', '2499', '金溪县', '3', '0', '222', '9999', '221'),
('2501', '2500', '黎川县', '3', '0', '222', '9999', '221'),
('2502', '2501', '万年县', '3', '0', '223', '9999', '222'),
('2503', '2502', '上饶县', '3', '0', '223', '9999', '222'),
('2504', '2503', '余干县', '3', '0', '223', '9999', '222'),
('2505', '2504', '信州区', '3', '0', '223', '9999', '222'),
('2506', '2505', '婺源县', '3', '0', '223', '9999', '222'),
('2507', '2506', '广丰县', '3', '0', '223', '9999', '222'),
('2508', '2507', '弋阳县', '3', '0', '223', '9999', '222'),
('2509', '2508', '德兴市', '3', '0', '223', '9999', '222'),
('2510', '2509', '横峰县', '3', '0', '223', '9999', '222'),
('2511', '2510', '玉山县', '3', '0', '223', '9999', '222'),
('2512', '2511', '鄱阳县', '3', '0', '223', '9999', '222'),
('2513', '2512', '铅山县', '3', '0', '223', '9999', '222'),
('2514', '2513', '历下区', '3', '0', '224', '9999', '223'),
('2515', '2514', '历城区', '3', '0', '224', '9999', '223'),
('2516', '2515', '商河县', '3', '0', '224', '9999', '223'),
('2517', '2516', '天桥区', '3', '0', '224', '9999', '223'),
('2518', '2517', '市中区', '3', '0', '224', '9999', '223'),
('2519', '2518', '平阴县', '3', '0', '224', '9999', '223'),
('2520', '2519', '槐荫区', '3', '0', '224', '9999', '223'),
('2521', '2520', '济阳县', '3', '0', '224', '9999', '223'),
('2522', '2521', '章丘市', '3', '0', '224', '9999', '223'),
('2523', '2522', '长清区', '3', '0', '224', '9999', '223'),
('2524', '2523', '即墨市', '3', '0', '225', '9999', '224'),
('2525', '2524', '四方区', '3', '0', '225', '9999', '224'),
('2526', '2525', '城阳区', '3', '0', '225', '9999', '224'),
('2527', '2526', '崂山区', '3', '0', '225', '9999', '224'),
('2528', '2527', '市北区', '3', '0', '225', '9999', '224'),
('2529', '2528', '市南区', '3', '0', '225', '9999', '224'),
('2530', '2529', '平度市', '3', '0', '225', '9999', '224'),
('2531', '2530', '李沧区', '3', '0', '225', '9999', '224'),
('2532', '2531', '胶南市', '3', '0', '225', '9999', '224'),
('2533', '2532', '胶州市', '3', '0', '225', '9999', '224'),
('2534', '2533', '莱西市', '3', '0', '225', '9999', '224'),
('2535', '2534', '黄岛区', '3', '0', '225', '9999', '224'),
('2536', '2535', '临淄区', '3', '0', '226', '9999', '225'),
('2537', '2536', '博山区', '3', '0', '226', '9999', '225'),
('2538', '2537', '周村区', '3', '0', '226', '9999', '225'),
('2539', '2538', '张店区', '3', '0', '226', '9999', '225'),
('2540', '2539', '桓台县', '3', '0', '226', '9999', '225'),
('2541', '2540', '沂源县', '3', '0', '226', '9999', '225'),
('2542', '2541', '淄川区', '3', '0', '226', '9999', '225'),
('2543', '2542', '高青县', '3', '0', '226', '9999', '225'),
('2544', '2543', '台儿庄区', '3', '0', '227', '9999', '226'),
('2545', '2544', '山亭区', '3', '0', '227', '9999', '226'),
('2546', '2545', '峄城区', '3', '0', '227', '9999', '226'),
('2547', '2546', '市中区', '3', '0', '227', '9999', '226'),
('2548', '2547', '滕州市', '3', '0', '227', '9999', '226'),
('2549', '2548', '薛城区', '3', '0', '227', '9999', '226'),
('2550', '2549', '东营区', '3', '0', '228', '9999', '227'),
('2551', '2550', '利津县', '3', '0', '228', '9999', '227'),
('2552', '2551', '垦利县', '3', '0', '228', '9999', '227'),
('2553', '2552', '广饶县', '3', '0', '228', '9999', '227'),
('2554', '2553', '河口区', '3', '0', '228', '9999', '227'),
('2555', '2554', '招远市', '3', '0', '229', '9999', '228'),
('2556', '2555', '栖霞市', '3', '0', '229', '9999', '228'),
('2557', '2556', '海阳市', '3', '0', '229', '9999', '228'),
('2558', '2557', '牟平区', '3', '0', '229', '9999', '228'),
('2559', '2558', '福山区', '3', '0', '229', '9999', '228'),
('2560', '2559', '芝罘区', '3', '0', '229', '9999', '228'),
('2561', '2560', '莱山区', '3', '0', '229', '9999', '228'),
('2562', '2561', '莱州市', '3', '0', '229', '9999', '228'),
('2563', '2562', '莱阳市', '3', '0', '229', '9999', '228'),
('2564', '2563', '蓬莱市', '3', '0', '229', '9999', '228'),
('2565', '2564', '长岛县', '3', '0', '229', '9999', '228'),
('2566', '2565', '龙口市', '3', '0', '229', '9999', '228'),
('2567', '2566', '临朐县', '3', '0', '230', '9999', '229'),
('2568', '2567', '坊子区', '3', '0', '230', '9999', '229'),
('2569', '2568', '奎文区', '3', '0', '230', '9999', '229'),
('2570', '2569', '安丘市', '3', '0', '230', '9999', '229'),
('2571', '2570', '寒亭区', '3', '0', '230', '9999', '229'),
('2572', '2571', '寿光市', '3', '0', '230', '9999', '229'),
('2573', '2572', '昌乐县', '3', '0', '230', '9999', '229'),
('2574', '2573', '昌邑市', '3', '0', '230', '9999', '229'),
('2575', '2574', '潍城区', '3', '0', '230', '9999', '229'),
('2576', '2575', '诸城市', '3', '0', '230', '9999', '229'),
('2577', '2576', '青州市', '3', '0', '230', '9999', '229'),
('2578', '2577', '高密市', '3', '0', '230', '9999', '229'),
('2579', '2578', '任城区', '3', '0', '231', '9999', '230'),
('2580', '2579', '兖州市', '3', '0', '231', '9999', '230'),
('2581', '2580', '嘉祥县', '3', '0', '231', '9999', '230'),
('2582', '2581', '市中区', '3', '0', '231', '9999', '230'),
('2583', '2582', '微山县', '3', '0', '231', '9999', '230'),
('2584', '2583', '曲阜市', '3', '0', '231', '9999', '230'),
('2585', '2584', '梁山县', '3', '0', '231', '9999', '230'),
('2586', '2585', '汶上县', '3', '0', '231', '9999', '230'),
('2587', '2586', '泗水县', '3', '0', '231', '9999', '230'),
('2588', '2587', '邹城市', '3', '0', '231', '9999', '230'),
('2589', '2588', '金乡县', '3', '0', '231', '9999', '230'),
('2590', '2589', '鱼台县', '3', '0', '231', '9999', '230'),
('2591', '2590', '东平县', '3', '0', '232', '9999', '231'),
('2592', '2591', '宁阳县', '3', '0', '232', '9999', '231'),
('2593', '2592', '岱岳区', '3', '0', '232', '9999', '231'),
('2594', '2593', '新泰市', '3', '0', '232', '9999', '231'),
('2595', '2594', '泰山区', '3', '0', '232', '9999', '231'),
('2596', '2595', '肥城市', '3', '0', '232', '9999', '231'),
('2597', '2596', '乳山市', '3', '0', '233', '9999', '232'),
('2598', '2597', '文登市', '3', '0', '233', '9999', '232'),
('2599', '2598', '环翠区', '3', '0', '233', '9999', '232'),
('2600', '2599', '荣成市', '3', '0', '233', '9999', '232'),
('2601', '2600', '东港区', '3', '0', '234', '9999', '233'),
('2602', '2601', '五莲县', '3', '0', '234', '9999', '233'),
('2603', '2602', '岚山区', '3', '0', '234', '9999', '233'),
('2604', '2603', '莒县', '3', '0', '234', '9999', '233'),
('2605', '2604', '莱城区', '3', '0', '235', '9999', '234'),
('2606', '2605', '钢城区', '3', '0', '235', '9999', '234'),
('2607', '2606', '临沭县', '3', '0', '236', '9999', '235'),
('2608', '2607', '兰山区', '3', '0', '236', '9999', '235'),
('2609', '2608', '平邑县', '3', '0', '236', '9999', '235'),
('2610', '2609', '沂南县', '3', '0', '236', '9999', '235'),
('2611', '2610', '沂水县', '3', '0', '236', '9999', '235'),
('2612', '2611', '河东区', '3', '0', '236', '9999', '235'),
('2613', '2612', '罗庄区', '3', '0', '236', '9999', '235'),
('2614', '2613', '苍山县', '3', '0', '236', '9999', '235'),
('2615', '2614', '莒南县', '3', '0', '236', '9999', '235'),
('2616', '2615', '蒙阴县', '3', '0', '236', '9999', '235'),
('2617', '2616', '费县', '3', '0', '236', '9999', '235'),
('2618', '2617', '郯城县', '3', '0', '236', '9999', '235'),
('2619', '2618', '临邑县', '3', '0', '237', '9999', '236'),
('2620', '2619', '乐陵市', '3', '0', '237', '9999', '236'),
('2621', '2620', '夏津县', '3', '0', '237', '9999', '236'),
('2622', '2621', '宁津县', '3', '0', '237', '9999', '236'),
('2623', '2622', '平原县', '3', '0', '237', '9999', '236'),
('2624', '2623', '庆云县', '3', '0', '237', '9999', '236'),
('2625', '2624', '德城区', '3', '0', '237', '9999', '236'),
('2626', '2625', '武城县', '3', '0', '237', '9999', '236'),
('2627', '2626', '禹城市', '3', '0', '237', '9999', '236'),
('2628', '2627', '陵县', '3', '0', '237', '9999', '236'),
('2629', '2628', '齐河县', '3', '0', '237', '9999', '236'),
('2630', '2629', '东昌府区', '3', '0', '238', '9999', '237'),
('2631', '2630', '东阿县', '3', '0', '238', '9999', '237'),
('2632', '2631', '临清市', '3', '0', '238', '9999', '237'),
('2633', '2632', '冠县', '3', '0', '238', '9999', '237'),
('2634', '2633', '茌平县', '3', '0', '238', '9999', '237'),
('2635', '2634', '莘县', '3', '0', '238', '9999', '237'),
('2636', '2635', '阳谷县', '3', '0', '238', '9999', '237'),
('2637', '2636', '高唐县', '3', '0', '238', '9999', '237'),
('2638', '2637', '博兴县', '3', '0', '239', '9999', '238'),
('2639', '2638', '惠民县', '3', '0', '239', '9999', '238'),
('2640', '2639', '无棣县', '3', '0', '239', '9999', '238'),
('2641', '2640', '沾化县', '3', '0', '239', '9999', '238'),
('2642', '2641', '滨城区', '3', '0', '239', '9999', '238'),
('2643', '2642', '邹平县', '3', '0', '239', '9999', '238'),
('2644', '2643', '阳信县', '3', '0', '239', '9999', '238'),
('2645', '2644', '东明县', '3', '0', '240', '9999', '239'),
('2646', '2645', '单县', '3', '0', '240', '9999', '239'),
('2647', '2646', '定陶县', '3', '0', '240', '9999', '239'),
('2648', '2647', '巨野县', '3', '0', '240', '9999', '239'),
('2649', '2648', '成武县', '3', '0', '240', '9999', '239'),
('2650', '2649', '曹县', '3', '0', '240', '9999', '239'),
('2651', '2650', '牡丹区', '3', '0', '240', '9999', '239'),
('2652', '2651', '郓城县', '3', '0', '240', '9999', '239'),
('2653', '2652', '鄄城县', '3', '0', '240', '9999', '239'),
('2654', '2653', '上街区', '3', '0', '241', '9999', '240'),
('2655', '2654', '中原区', '3', '0', '241', '9999', '240'),
('2656', '2655', '中牟县', '3', '0', '241', '9999', '240'),
('2657', '2656', '二七区', '3', '0', '241', '9999', '240'),
('2658', '2657', '巩义市', '3', '0', '241', '9999', '240'),
('2659', '2658', '惠济区', '3', '0', '241', '9999', '240'),
('2660', '2659', '新密市', '3', '0', '241', '9999', '240'),
('2661', '2660', '新郑市', '3', '0', '241', '9999', '240'),
('2662', '2661', '登封市', '3', '0', '241', '9999', '240'),
('2663', '2662', '管城回族区', '3', '0', '241', '9999', '240'),
('2664', '2663', '荥阳市', '3', '0', '241', '9999', '240'),
('2665', '2664', '金水区', '3', '0', '241', '9999', '240'),
('2666', '2665', '兰考县', '3', '0', '242', '9999', '241'),
('2667', '2666', '尉氏县', '3', '0', '242', '9999', '241'),
('2668', '2667', '开封县', '3', '0', '242', '9999', '241'),
('2669', '2668', '杞县', '3', '0', '242', '9999', '241'),
('2670', '2669', '禹王台区', '3', '0', '242', '9999', '241'),
('2671', '2670', '通许县', '3', '0', '242', '9999', '241'),
('2672', '2671', '金明区', '3', '0', '242', '9999', '241'),
('2673', '2672', '顺河回族区', '3', '0', '242', '9999', '241'),
('2674', '2673', '鼓楼区', '3', '0', '242', '9999', '241'),
('2675', '2674', '龙亭区', '3', '0', '242', '9999', '241'),
('2676', '2675', '伊川县', '3', '0', '243', '9999', '242'),
('2677', '2676', '偃师市', '3', '0', '243', '9999', '242'),
('2678', '2677', '吉利区', '3', '0', '243', '9999', '242'),
('2679', '2678', '孟津县', '3', '0', '243', '9999', '242'),
('2680', '2679', '宜阳县', '3', '0', '243', '9999', '242'),
('2681', '2680', '嵩县', '3', '0', '243', '9999', '242'),
('2682', '2681', '新安县', '3', '0', '243', '9999', '242'),
('2683', '2682', '栾川县', '3', '0', '243', '9999', '242'),
('2684', '2683', '汝阳县', '3', '0', '243', '9999', '242'),
('2685', '2684', '洛宁县', '3', '0', '243', '9999', '242'),
('2686', '2685', '洛龙区', '3', '0', '243', '9999', '242'),
('2687', '2686', '涧西区', '3', '0', '243', '9999', '242'),
('2688', '2687', '瀍河回族区', '3', '0', '243', '9999', '242'),
('2689', '2688', '老城区', '3', '0', '243', '9999', '242'),
('2690', '2689', '西工区', '3', '0', '243', '9999', '242'),
('2691', '2690', '卫东区', '3', '0', '244', '9999', '243'),
('2692', '2691', '叶县', '3', '0', '244', '9999', '243'),
('2693', '2692', '宝丰县', '3', '0', '244', '9999', '243'),
('2694', '2693', '新华区', '3', '0', '244', '9999', '243'),
('2695', '2694', '汝州市', '3', '0', '244', '9999', '243'),
('2696', '2695', '湛河区', '3', '0', '244', '9999', '243'),
('2697', '2696', '石龙区', '3', '0', '244', '9999', '243'),
('2698', '2697', '舞钢市', '3', '0', '244', '9999', '243'),
('2699', '2698', '郏县', '3', '0', '244', '9999', '243'),
('2700', '2699', '鲁山县', '3', '0', '244', '9999', '243'),
('2701', '2700', '内黄县', '3', '0', '245', '9999', '244'),
('2702', '2701', '北关区', '3', '0', '245', '9999', '244'),
('2703', '2702', '安阳县', '3', '0', '245', '9999', '244'),
('2704', '2703', '文峰区', '3', '0', '245', '9999', '244'),
('2705', '2704', '林州市', '3', '0', '245', '9999', '244'),
('2706', '2705', '殷都区', '3', '0', '245', '9999', '244'),
('2707', '2706', '汤阴县', '3', '0', '245', '9999', '244'),
('2708', '2707', '滑县', '3', '0', '245', '9999', '244'),
('2709', '2708', '龙安区', '3', '0', '245', '9999', '244'),
('2710', '2709', '山城区', '3', '0', '246', '9999', '245'),
('2711', '2710', '浚县', '3', '0', '246', '9999', '245'),
('2712', '2711', '淇县', '3', '0', '246', '9999', '245'),
('2713', '2712', '淇滨区', '3', '0', '246', '9999', '245'),
('2714', '2713', '鹤山区', '3', '0', '246', '9999', '245'),
('2715', '2714', '凤泉区', '3', '0', '247', '9999', '246'),
('2716', '2715', '卫滨区', '3', '0', '247', '9999', '246'),
('2717', '2716', '卫辉市', '3', '0', '247', '9999', '246'),
('2718', '2717', '原阳县', '3', '0', '247', '9999', '246'),
('2719', '2718', '封丘县', '3', '0', '247', '9999', '246'),
('2720', '2719', '延津县', '3', '0', '247', '9999', '246'),
('2721', '2720', '新乡县', '3', '0', '247', '9999', '246'),
('2722', '2721', '牧野区', '3', '0', '247', '9999', '246'),
('2723', '2722', '红旗区', '3', '0', '247', '9999', '246'),
('2724', '2723', '获嘉县', '3', '0', '247', '9999', '246'),
('2725', '2724', '辉县市', '3', '0', '247', '9999', '246'),
('2726', '2725', '长垣县', '3', '0', '247', '9999', '246'),
('2727', '2726', '中站区', '3', '0', '248', '9999', '247'),
('2728', '2727', '修武县', '3', '0', '248', '9999', '247'),
('2729', '2728', '博爱县', '3', '0', '248', '9999', '247'),
('2730', '2729', '孟州市', '3', '0', '248', '9999', '247'),
('2731', '2730', '山阳区', '3', '0', '248', '9999', '247'),
('2732', '2731', '武陟县', '3', '0', '248', '9999', '247'),
('2733', '2732', '沁阳市', '3', '0', '248', '9999', '247'),
('2734', '2733', '温县', '3', '0', '248', '9999', '247'),
('2735', '2734', '解放区', '3', '0', '248', '9999', '247'),
('2736', '2735', '马村区', '3', '0', '248', '9999', '247'),
('2737', '2736', '华龙区', '3', '0', '249', '9999', '248'),
('2738', '2737', '南乐县', '3', '0', '249', '9999', '248'),
('2739', '2738', '台前县', '3', '0', '249', '9999', '248'),
('2740', '2739', '清丰县', '3', '0', '249', '9999', '248'),
('2741', '2740', '濮阳县', '3', '0', '249', '9999', '248'),
('2742', '2741', '范县', '3', '0', '249', '9999', '248'),
('2743', '2742', '禹州市', '3', '0', '250', '9999', '249'),
('2744', '2743', '襄城县', '3', '0', '250', '9999', '249'),
('2745', '2744', '许昌县', '3', '0', '250', '9999', '249'),
('2746', '2745', '鄢陵县', '3', '0', '250', '9999', '249'),
('2747', '2746', '长葛市', '3', '0', '250', '9999', '249'),
('2748', '2747', '魏都区', '3', '0', '250', '9999', '249'),
('2749', '2748', '临颍县', '3', '0', '251', '9999', '250'),
('2750', '2749', '召陵区', '3', '0', '251', '9999', '250'),
('2751', '2750', '源汇区', '3', '0', '251', '9999', '250'),
('2752', '2751', '舞阳县', '3', '0', '251', '9999', '250'),
('2753', '2752', '郾城区', '3', '0', '251', '9999', '250'),
('2754', '2753', '义马市', '3', '0', '252', '9999', '251'),
('2755', '2754', '卢氏县', '3', '0', '252', '9999', '251'),
('2756', '2755', '渑池县', '3', '0', '252', '9999', '251'),
('2757', '2756', '湖滨区', '3', '0', '252', '9999', '251'),
('2758', '2757', '灵宝市', '3', '0', '252', '9999', '251'),
('2759', '2758', '陕县', '3', '0', '252', '9999', '251'),
('2760', '2759', '内乡县', '3', '0', '253', '9999', '252'),
('2761', '2760', '南召县', '3', '0', '253', '9999', '252'),
('2762', '2761', '卧龙区', '3', '0', '253', '9999', '252'),
('2763', '2762', '唐河县', '3', '0', '253', '9999', '252'),
('2764', '2763', '宛城区', '3', '0', '253', '9999', '252'),
('2765', '2764', '新野县', '3', '0', '253', '9999', '252'),
('2766', '2765', '方城县', '3', '0', '253', '9999', '252'),
('2767', '2766', '桐柏县', '3', '0', '253', '9999', '252'),
('2768', '2767', '淅川县', '3', '0', '253', '9999', '252'),
('2769', '2768', '社旗县', '3', '0', '253', '9999', '252'),
('2770', '2769', '西峡县', '3', '0', '253', '9999', '252'),
('2771', '2770', '邓州市', '3', '0', '253', '9999', '252'),
('2772', '2771', '镇平县', '3', '0', '253', '9999', '252'),
('2773', '2772', '夏邑县', '3', '0', '254', '9999', '253'),
('2774', '2773', '宁陵县', '3', '0', '254', '9999', '253'),
('2775', '2774', '柘城县', '3', '0', '254', '9999', '253'),
('2776', '2775', '民权县', '3', '0', '254', '9999', '253'),
('2777', '2776', '永城市', '3', '0', '254', '9999', '253'),
('2778', '2777', '睢县', '3', '0', '254', '9999', '253'),
('2779', '2778', '睢阳区', '3', '0', '254', '9999', '253'),
('2780', '2779', '粱园区', '3', '0', '254', '9999', '253'),
('2781', '2780', '虞城县', '3', '0', '254', '9999', '253'),
('2782', '2781', '光山县', '3', '0', '255', '9999', '254'),
('2783', '2782', '商城县', '3', '0', '255', '9999', '254'),
('2784', '2783', '固始县', '3', '0', '255', '9999', '254'),
('2785', '2784', '平桥区', '3', '0', '255', '9999', '254'),
('2786', '2785', '息县', '3', '0', '255', '9999', '254'),
('2787', '2786', '新县', '3', '0', '255', '9999', '254'),
('2788', '2787', '浉河区', '3', '0', '255', '9999', '254'),
('2789', '2788', '淮滨县', '3', '0', '255', '9999', '254'),
('2790', '2789', '潢川县', '3', '0', '255', '9999', '254'),
('2791', '2790', '罗山县', '3', '0', '255', '9999', '254'),
('2792', '2791', '商水县', '3', '0', '256', '9999', '255'),
('2793', '2792', '太康县', '3', '0', '256', '9999', '255'),
('2794', '2793', '川汇区', '3', '0', '256', '9999', '255'),
('2795', '2794', '扶沟县', '3', '0', '256', '9999', '255'),
('2796', '2795', '沈丘县', '3', '0', '256', '9999', '255'),
('2797', '2796', '淮阳县', '3', '0', '256', '9999', '255'),
('2798', '2797', '西华县', '3', '0', '256', '9999', '255'),
('2799', '2798', '郸城县', '3', '0', '256', '9999', '255'),
('2800', '2799', '项城市', '3', '0', '256', '9999', '255'),
('2801', '2800', '鹿邑县', '3', '0', '256', '9999', '255'),
('2802', '2801', '上蔡县', '3', '0', '257', '9999', '256'),
('2803', '2802', '平舆县', '3', '0', '257', '9999', '256'),
('2804', '2803', '新蔡县', '3', '0', '257', '9999', '256'),
('2805', '2804', '正阳县', '3', '0', '257', '9999', '256'),
('2806', '2805', '汝南县', '3', '0', '257', '9999', '256'),
('2807', '2806', '泌阳县', '3', '0', '257', '9999', '256'),
('2808', '2807', '确山县', '3', '0', '257', '9999', '256'),
('2809', '2808', '西平县', '3', '0', '257', '9999', '256'),
('2810', '2809', '遂平县', '3', '0', '257', '9999', '256'),
('2811', '2810', '驿城区', '3', '0', '257', '9999', '256'),
('2812', '2811', '济源市', '3', '0', '258', '9999', '257'),
('2813', '2812', '东西湖区', '3', '0', '259', '9999', '258'),
('2814', '2813', '新洲区', '3', '0', '259', '9999', '258'),
('2815', '2814', '武昌区', '3', '0', '259', '9999', '258'),
('2816', '2815', '汉南区', '3', '0', '259', '9999', '258'),
('2817', '2816', '汉阳区', '3', '0', '259', '9999', '258'),
('2818', '2817', '江夏区', '3', '0', '259', '9999', '258'),
('2819', '2818', '江岸区', '3', '0', '259', '9999', '258'),
('2820', '2819', '江汉区', '3', '0', '259', '9999', '258'),
('2821', '2820', '洪山区', '3', '0', '259', '9999', '258'),
('2822', '2821', '硚口区', '3', '0', '259', '9999', '258'),
('2823', '2822', '蔡甸区', '3', '0', '259', '9999', '258'),
('2824', '2823', '青山区', '3', '0', '259', '9999', '258'),
('2825', '2824', '黄陂区', '3', '0', '259', '9999', '258'),
('2826', '2825', '下陆区', '3', '0', '260', '9999', '259'),
('2827', '2826', '大冶市', '3', '0', '260', '9999', '259'),
('2828', '2827', '西塞山区', '3', '0', '260', '9999', '259'),
('2829', '2828', '铁山区', '3', '0', '260', '9999', '259'),
('2830', '2829', '阳新县', '3', '0', '260', '9999', '259'),
('2831', '2830', '黄石港区', '3', '0', '260', '9999', '259'),
('2832', '2831', '丹江口市', '3', '0', '261', '9999', '260'),
('2833', '2832', '张湾区', '3', '0', '261', '9999', '260'),
('2834', '2833', '房县', '3', '0', '261', '9999', '260'),
('2835', '2834', '竹山县', '3', '0', '261', '9999', '260'),
('2836', '2835', '竹溪县', '3', '0', '261', '9999', '260'),
('2837', '2836', '茅箭区', '3', '0', '261', '9999', '260'),
('2838', '2837', '郧县', '3', '0', '261', '9999', '260'),
('2839', '2838', '郧西县', '3', '0', '261', '9999', '260'),
('2840', '2839', '五峰土家族自治县', '3', '0', '262', '9999', '261'),
('2841', '2840', '伍家岗区', '3', '0', '262', '9999', '261'),
('2842', '2841', '兴山县', '3', '0', '262', '9999', '261'),
('2843', '2842', '夷陵区', '3', '0', '262', '9999', '261'),
('2844', '2843', '宜都市', '3', '0', '262', '9999', '261'),
('2845', '2844', '当阳市', '3', '0', '262', '9999', '261'),
('2846', '2845', '枝江市', '3', '0', '262', '9999', '261'),
('2847', '2846', '点军区', '3', '0', '262', '9999', '261'),
('2848', '2847', '秭归县', '3', '0', '262', '9999', '261'),
('2849', '2848', '虢亭区', '3', '0', '262', '9999', '261'),
('2850', '2849', '西陵区', '3', '0', '262', '9999', '261'),
('2851', '2850', '远安县', '3', '0', '262', '9999', '261'),
('2852', '2851', '长阳土家族自治县', '3', '0', '262', '9999', '261'),
('2853', '2852', '保康县', '3', '0', '263', '9999', '262'),
('2854', '2853', '南漳县', '3', '0', '263', '9999', '262'),
('2855', '2854', '宜城市', '3', '0', '263', '9999', '262'),
('2856', '2855', '枣阳市', '3', '0', '263', '9999', '262'),
('2857', '2856', '樊城区', '3', '0', '263', '9999', '262'),
('2858', '2857', '老河口市', '3', '0', '263', '9999', '262'),
('2859', '2858', '襄城区', '3', '0', '263', '9999', '262'),
('2860', '2859', '襄阳区', '3', '0', '263', '9999', '262'),
('2861', '2860', '谷城县', '3', '0', '263', '9999', '262'),
('2862', '2861', '华容区', '3', '0', '264', '9999', '263'),
('2863', '2862', '粱子湖', '3', '0', '264', '9999', '263'),
('2864', '2863', '鄂城区', '3', '0', '264', '9999', '263'),
('2865', '2864', '东宝区', '3', '0', '265', '9999', '264'),
('2866', '2865', '京山县', '3', '0', '265', '9999', '264'),
('2867', '2866', '掇刀区', '3', '0', '265', '9999', '264'),
('2868', '2867', '沙洋县', '3', '0', '265', '9999', '264'),
('2869', '2868', '钟祥市', '3', '0', '265', '9999', '264'),
('2870', '2869', '云梦县', '3', '0', '266', '9999', '265'),
('2871', '2870', '大悟县', '3', '0', '266', '9999', '265'),
('2872', '2871', '孝南区', '3', '0', '266', '9999', '265'),
('2873', '2872', '孝昌县', '3', '0', '266', '9999', '265'),
('2874', '2873', '安陆市', '3', '0', '266', '9999', '265'),
('2875', '2874', '应城市', '3', '0', '266', '9999', '265'),
('2876', '2875', '汉川市', '3', '0', '266', '9999', '265'),
('2877', '2876', '公安县', '3', '0', '267', '9999', '266'),
('2878', '2877', '松滋市', '3', '0', '267', '9999', '266'),
('2879', '2878', '江陵县', '3', '0', '267', '9999', '266'),
('2880', '2879', '沙市区', '3', '0', '267', '9999', '266'),
('2881', '2880', '洪湖市', '3', '0', '267', '9999', '266'),
('2882', '2881', '监利县', '3', '0', '267', '9999', '266'),
('2883', '2882', '石首市', '3', '0', '267', '9999', '266'),
('2884', '2883', '荆州区', '3', '0', '267', '9999', '266'),
('2885', '2884', '团风县', '3', '0', '268', '9999', '267'),
('2886', '2885', '武穴市', '3', '0', '268', '9999', '267'),
('2887', '2886', '浠水县', '3', '0', '268', '9999', '267'),
('2888', '2887', '红安县', '3', '0', '268', '9999', '267'),
('2889', '2888', '罗田县', '3', '0', '268', '9999', '267'),
('2890', '2889', '英山县', '3', '0', '268', '9999', '267'),
('2891', '2890', '蕲春县', '3', '0', '268', '9999', '267'),
('2892', '2891', '麻城市', '3', '0', '268', '9999', '267'),
('2893', '2892', '黄州区', '3', '0', '268', '9999', '267'),
('2894', '2893', '黄梅县', '3', '0', '268', '9999', '267'),
('2895', '2894', '咸安区', '3', '0', '269', '9999', '268'),
('2896', '2895', '嘉鱼县', '3', '0', '269', '9999', '268'),
('2897', '2896', '崇阳县', '3', '0', '269', '9999', '268'),
('2898', '2897', '赤壁市', '3', '0', '269', '9999', '268'),
('2899', '2898', '通城县', '3', '0', '269', '9999', '268'),
('2900', '2899', '通山县', '3', '0', '269', '9999', '268'),
('2901', '2900', '广水市', '3', '0', '270', '9999', '269'),
('2902', '2901', '曾都区', '3', '0', '270', '9999', '269'),
('2903', '2902', '利川市', '3', '0', '271', '9999', '270'),
('2904', '2903', '咸丰县', '3', '0', '271', '9999', '270'),
('2905', '2904', '宣恩县', '3', '0', '271', '9999', '270'),
('2906', '2905', '巴东县', '3', '0', '271', '9999', '270'),
('2907', '2906', '建始县', '3', '0', '271', '9999', '270'),
('2908', '2907', '恩施市', '3', '0', '271', '9999', '270'),
('2909', '2908', '来凤县', '3', '0', '271', '9999', '270'),
('2910', '2909', '鹤峰县', '3', '0', '271', '9999', '270'),
('2911', '2910', '仙桃市', '3', '0', '272', '9999', '271'),
('2912', '2911', '潜江市', '3', '0', '273', '9999', '272'),
('2913', '2912', '天门市', '3', '0', '274', '9999', '273'),
('2914', '2913', '神农架林区', '3', '0', '275', '9999', '274'),
('2915', '2914', '天心区', '3', '0', '276', '9999', '275'),
('2916', '2915', '宁乡县', '3', '0', '276', '9999', '275'),
('2917', '2916', '岳麓区', '3', '0', '276', '9999', '275'),
('2918', '2917', '开福区', '3', '0', '276', '9999', '275'),
('2919', '2918', '望城县', '3', '0', '276', '9999', '275'),
('2920', '2919', '浏阳市', '3', '0', '276', '9999', '275'),
('2921', '2920', '芙蓉区', '3', '0', '276', '9999', '275'),
('2922', '2921', '长沙县', '3', '0', '276', '9999', '275'),
('2923', '2922', '雨花区', '3', '0', '276', '9999', '275'),
('2924', '2923', '天元区', '3', '0', '277', '9999', '276'),
('2925', '2924', '攸县', '3', '0', '277', '9999', '276'),
('2926', '2925', '株洲县', '3', '0', '277', '9999', '276'),
('2927', '2926', '炎陵县', '3', '0', '277', '9999', '276'),
('2928', '2927', '石峰区', '3', '0', '277', '9999', '276'),
('2929', '2928', '芦淞区', '3', '0', '277', '9999', '276'),
('2930', '2929', '茶陵县', '3', '0', '277', '9999', '276'),
('2931', '2930', '荷塘区', '3', '0', '277', '9999', '276'),
('2932', '2931', '醴陵市', '3', '0', '277', '9999', '276'),
('2933', '2932', '岳塘区', '3', '0', '278', '9999', '277'),
('2934', '2933', '湘乡市', '3', '0', '278', '9999', '277'),
('2935', '2934', '湘潭县', '3', '0', '278', '9999', '277'),
('2936', '2935', '雨湖区', '3', '0', '278', '9999', '277'),
('2937', '2936', '韶山市', '3', '0', '278', '9999', '277'),
('2938', '2937', '南岳区', '3', '0', '279', '9999', '278'),
('2939', '2938', '常宁市', '3', '0', '279', '9999', '278'),
('2940', '2939', '珠晖区', '3', '0', '279', '9999', '278'),
('2941', '2940', '石鼓区', '3', '0', '279', '9999', '278'),
('2942', '2941', '祁东县', '3', '0', '279', '9999', '278'),
('2943', '2942', '耒阳市', '3', '0', '279', '9999', '278'),
('2944', '2943', '蒸湘区', '3', '0', '279', '9999', '278'),
('2945', '2944', '衡东县', '3', '0', '279', '9999', '278'),
('2946', '2945', '衡南县', '3', '0', '279', '9999', '278'),
('2947', '2946', '衡山县', '3', '0', '279', '9999', '278'),
('2948', '2947', '衡阳县', '3', '0', '279', '9999', '278'),
('2949', '2948', '雁峰区', '3', '0', '279', '9999', '278'),
('2950', '2949', '北塔区', '3', '0', '280', '9999', '279'),
('2951', '2950', '双清区', '3', '0', '280', '9999', '279'),
('2952', '2951', '城步苗族自治县', '3', '0', '280', '9999', '279'),
('2953', '2952', '大祥区', '3', '0', '280', '9999', '279'),
('2954', '2953', '新宁县', '3', '0', '280', '9999', '279'),
('2955', '2954', '新邵县', '3', '0', '280', '9999', '279'),
('2956', '2955', '武冈市', '3', '0', '280', '9999', '279'),
('2957', '2956', '洞口县', '3', '0', '280', '9999', '279'),
('2958', '2957', '绥宁县', '3', '0', '280', '9999', '279'),
('2959', '2958', '邵东县', '3', '0', '280', '9999', '279'),
('2960', '2959', '邵阳县', '3', '0', '280', '9999', '279'),
('2961', '2960', '隆回县', '3', '0', '280', '9999', '279'),
('2962', '2961', '临湘市', '3', '0', '281', '9999', '280'),
('2963', '2962', '云溪区', '3', '0', '281', '9999', '280'),
('2964', '2963', '华容县', '3', '0', '281', '9999', '280'),
('2965', '2964', '君山区', '3', '0', '281', '9999', '280'),
('2966', '2965', '岳阳县', '3', '0', '281', '9999', '280'),
('2967', '2966', '岳阳楼区', '3', '0', '281', '9999', '280'),
('2968', '2967', '平江县', '3', '0', '281', '9999', '280'),
('2969', '2968', '汨罗市', '3', '0', '281', '9999', '280'),
('2970', '2969', '湘阴县', '3', '0', '281', '9999', '280'),
('2971', '2970', '临澧县', '3', '0', '282', '9999', '281'),
('2972', '2971', '安乡县', '3', '0', '282', '9999', '281'),
('2973', '2972', '桃源县', '3', '0', '282', '9999', '281'),
('2974', '2973', '武陵区', '3', '0', '282', '9999', '281'),
('2975', '2974', '汉寿县', '3', '0', '282', '9999', '281'),
('2976', '2975', '津市市', '3', '0', '282', '9999', '281'),
('2977', '2976', '澧县', '3', '0', '282', '9999', '281'),
('2978', '2977', '石门县', '3', '0', '282', '9999', '281'),
('2979', '2978', '鼎城区', '3', '0', '282', '9999', '281'),
('2980', '2979', '慈利县', '3', '0', '283', '9999', '282'),
('2981', '2980', '桑植县', '3', '0', '283', '9999', '282'),
('2982', '2981', '武陵源区', '3', '0', '283', '9999', '282'),
('2983', '2982', '永定区', '3', '0', '283', '9999', '282'),
('2984', '2983', '南县', '3', '0', '284', '9999', '283'),
('2985', '2984', '安化县', '3', '0', '284', '9999', '283'),
('2986', '2985', '桃江县', '3', '0', '284', '9999', '283'),
('2987', '2986', '沅江市', '3', '0', '284', '9999', '283'),
('2988', '2987', '资阳区', '3', '0', '284', '9999', '283'),
('2989', '2988', '赫山区', '3', '0', '284', '9999', '283'),
('2990', '2989', '临武县', '3', '0', '285', '9999', '284'),
('2991', '2990', '北湖区', '3', '0', '285', '9999', '284'),
('2992', '2991', '嘉禾县', '3', '0', '285', '9999', '284'),
('2993', '2992', '安仁县', '3', '0', '285', '9999', '284'),
('2994', '2993', '宜章县', '3', '0', '285', '9999', '284'),
('2995', '2994', '桂东县', '3', '0', '285', '9999', '284'),
('2996', '2995', '桂阳县', '3', '0', '285', '9999', '284'),
('2997', '2996', '永兴县', '3', '0', '285', '9999', '284'),
('2998', '2997', '汝城县', '3', '0', '285', '9999', '284'),
('2999', '2998', '苏仙区', '3', '0', '285', '9999', '284'),
('3000', '2999', '资兴市', '3', '0', '285', '9999', '284'),
('3001', '3000', '东安县', '3', '0', '286', '9999', '285'),
('3002', '3001', '冷水滩区', '3', '0', '286', '9999', '285'),
('3003', '3002', '双牌县', '3', '0', '286', '9999', '285'),
('3004', '3003', '宁远县', '3', '0', '286', '9999', '285'),
('3005', '3004', '新田县', '3', '0', '286', '9999', '285'),
('3006', '3005', '江华瑶族自治县', '3', '0', '286', '9999', '285'),
('3007', '3006', '江永县', '3', '0', '286', '9999', '285'),
('3008', '3007', '祁阳县', '3', '0', '286', '9999', '285'),
('3009', '3008', '蓝山县', '3', '0', '286', '9999', '285'),
('3010', '3009', '道县', '3', '0', '286', '9999', '285'),
('3011', '3010', '零陵区', '3', '0', '286', '9999', '285'),
('3012', '3011', '中方县', '3', '0', '287', '9999', '286'),
('3013', '3012', '会同县', '3', '0', '287', '9999', '286'),
('3014', '3013', '新晃侗族自治县', '3', '0', '287', '9999', '286'),
('3015', '3014', '沅陵县', '3', '0', '287', '9999', '286'),
('3016', '3015', '洪江市/洪江区', '3', '0', '287', '9999', '286'),
('3017', '3016', '溆浦县', '3', '0', '287', '9999', '286'),
('3018', '3017', '芷江侗族自治县', '3', '0', '287', '9999', '286'),
('3019', '3018', '辰溪县', '3', '0', '287', '9999', '286'),
('3020', '3019', '通道侗族自治县', '3', '0', '287', '9999', '286'),
('3021', '3020', '靖州苗族侗族自治县', '3', '0', '287', '9999', '286'),
('3022', '3021', '鹤城区', '3', '0', '287', '9999', '286'),
('3023', '3022', '麻阳苗族自治县', '3', '0', '287', '9999', '286'),
('3024', '3023', '冷水江市', '3', '0', '288', '9999', '287'),
('3025', '3024', '双峰县', '3', '0', '288', '9999', '287'),
('3026', '3025', '娄星区', '3', '0', '288', '9999', '287'),
('3027', '3026', '新化县', '3', '0', '288', '9999', '287'),
('3028', '3027', '涟源市', '3', '0', '288', '9999', '287'),
('3029', '3028', '保靖县', '3', '0', '289', '9999', '288'),
('3030', '3029', '凤凰县', '3', '0', '289', '9999', '288'),
('3031', '3030', '古丈县', '3', '0', '289', '9999', '288'),
('3032', '3031', '吉首市', '3', '0', '289', '9999', '288'),
('3033', '3032', '永顺县', '3', '0', '289', '9999', '288'),
('3034', '3033', '泸溪县', '3', '0', '289', '9999', '288'),
('3035', '3034', '花垣县', '3', '0', '289', '9999', '288'),
('3036', '3035', '龙山县', '3', '0', '289', '9999', '288'),
('3037', '3036', '萝岗区', '3', '0', '290', '9999', '289'),
('3038', '3037', '南沙区', '3', '0', '290', '9999', '289'),
('3039', '3038', '从化市', '3', '0', '290', '9999', '289'),
('3040', '3039', '增城市', '3', '0', '290', '9999', '289'),
('3041', '3040', '天河区', '3', '0', '290', '9999', '289'),
('3042', '3041', '海珠区', '3', '0', '290', '9999', '289'),
('3043', '3042', '番禺区', '3', '0', '290', '9999', '289'),
('3044', '3043', '白云区', '3', '0', '290', '9999', '289'),
('3045', '3044', '花都区', '3', '0', '290', '9999', '289'),
('3046', '3045', '荔湾区', '3', '0', '290', '9999', '289'),
('3047', '3046', '越秀区', '3', '0', '290', '9999', '289'),
('3048', '3047', '黄埔区', '3', '0', '290', '9999', '289'),
('3049', '3048', '乐昌市', '3', '0', '291', '9999', '290'),
('3050', '3049', '乳源瑶族自治县', '3', '0', '291', '9999', '290'),
('3051', '3050', '仁化县', '3', '0', '291', '9999', '290'),
('3052', '3051', '南雄市', '3', '0', '291', '9999', '290'),
('3053', '3052', '始兴县', '3', '0', '291', '9999', '290'),
('3054', '3053', '新丰县', '3', '0', '291', '9999', '290'),
('3055', '3054', '曲江区', '3', '0', '291', '9999', '290'),
('3056', '3055', '武江区', '3', '0', '291', '9999', '290'),
('3057', '3056', '浈江区', '3', '0', '291', '9999', '290'),
('3058', '3057', '翁源县', '3', '0', '291', '9999', '290'),
('3059', '3058', '南山区', '3', '0', '292', '9999', '291'),
('3060', '3059', '宝安区', '3', '0', '292', '9999', '291'),
('3061', '3060', '盐田区', '3', '0', '292', '9999', '291'),
('3062', '3061', '福田区', '3', '0', '292', '9999', '291'),
('3063', '3062', '罗湖区', '3', '0', '292', '9999', '291'),
('3064', '3063', '龙岗区', '3', '0', '292', '9999', '291'),
('3065', '3064', '斗门区', '3', '0', '293', '9999', '292'),
('3066', '3065', '金湾区', '3', '0', '293', '9999', '292'),
('3067', '3066', '香洲区', '3', '0', '293', '9999', '292'),
('3068', '3067', '南澳县', '3', '0', '294', '9999', '293'),
('3069', '3068', '潮南区', '3', '0', '294', '9999', '293'),
('3070', '3069', '潮阳区', '3', '0', '294', '9999', '293'),
('3071', '3070', '澄海区', '3', '0', '294', '9999', '293'),
('3072', '3071', '濠江区', '3', '0', '294', '9999', '293'),
('3073', '3072', '金平区', '3', '0', '294', '9999', '293'),
('3074', '3073', '龙湖区', '3', '0', '294', '9999', '293'),
('3075', '3074', '三水区', '3', '0', '295', '9999', '294'),
('3076', '3075', '南海区', '3', '0', '295', '9999', '294'),
('3077', '3076', '禅城区', '3', '0', '295', '9999', '294'),
('3078', '3077', '顺德区', '3', '0', '295', '9999', '294'),
('3079', '3078', '高明区', '3', '0', '295', '9999', '294'),
('3080', '3079', '台山市', '3', '0', '296', '9999', '295'),
('3081', '3080', '开平市', '3', '0', '296', '9999', '295'),
('3082', '3081', '恩平市', '3', '0', '296', '9999', '295'),
('3083', '3082', '新会区', '3', '0', '296', '9999', '295'),
('3084', '3083', '江海区', '3', '0', '296', '9999', '295'),
('3085', '3084', '蓬江区', '3', '0', '296', '9999', '295'),
('3086', '3085', '鹤山市', '3', '0', '296', '9999', '295'),
('3087', '3086', '吴川市', '3', '0', '297', '9999', '296'),
('3088', '3087', '坡头区', '3', '0', '297', '9999', '296'),
('3089', '3088', '廉江市', '3', '0', '297', '9999', '296'),
('3090', '3089', '徐闻县', '3', '0', '297', '9999', '296'),
('3091', '3090', '赤坎区', '3', '0', '297', '9999', '296'),
('3092', '3091', '遂溪县', '3', '0', '297', '9999', '296'),
('3093', '3092', '雷州市', '3', '0', '297', '9999', '296'),
('3094', '3093', '霞山区', '3', '0', '297', '9999', '296'),
('3095', '3094', '麻章区', '3', '0', '297', '9999', '296'),
('3096', '3095', '信宜市', '3', '0', '298', '9999', '297'),
('3097', '3096', '化州市', '3', '0', '298', '9999', '297'),
('3098', '3097', '电白县', '3', '0', '298', '9999', '297'),
('3099', '3098', '茂南区', '3', '0', '298', '9999', '297'),
('3100', '3099', '茂港区', '3', '0', '298', '9999', '297'),
('3101', '3100', '高州市', '3', '0', '298', '9999', '297'),
('3102', '3101', '四会市', '3', '0', '299', '9999', '298'),
('3103', '3102', '封开县', '3', '0', '299', '9999', '298'),
('3104', '3103', '广宁县', '3', '0', '299', '9999', '298'),
('3105', '3104', '德庆县', '3', '0', '299', '9999', '298'),
('3106', '3105', '怀集县', '3', '0', '299', '9999', '298'),
('3107', '3106', '端州区', '3', '0', '299', '9999', '298'),
('3108', '3107', '高要市', '3', '0', '299', '9999', '298'),
('3109', '3108', '鼎湖区', '3', '0', '299', '9999', '298'),
('3110', '3109', '博罗县', '3', '0', '300', '9999', '299'),
('3111', '3110', '惠东县', '3', '0', '300', '9999', '299'),
('3112', '3111', '惠城区', '3', '0', '300', '9999', '299'),
('3113', '3112', '惠阳区', '3', '0', '300', '9999', '299'),
('3114', '3113', '龙门县', '3', '0', '300', '9999', '299'),
('3115', '3114', '丰顺县', '3', '0', '301', '9999', '300'),
('3116', '3115', '五华县', '3', '0', '301', '9999', '300'),
('3117', '3116', '兴宁市', '3', '0', '301', '9999', '300'),
('3118', '3117', '大埔县', '3', '0', '301', '9999', '300'),
('3119', '3118', '平远县', '3', '0', '301', '9999', '300'),
('3120', '3119', '梅县', '3', '0', '301', '9999', '300'),
('3121', '3120', '梅江区', '3', '0', '301', '9999', '300'),
('3122', '3121', '蕉岭县', '3', '0', '301', '9999', '300'),
('3123', '3122', '城区', '3', '0', '302', '9999', '301'),
('3124', '3123', '海丰县', '3', '0', '302', '9999', '301'),
('3125', '3124', '陆丰市', '3', '0', '302', '9999', '301'),
('3126', '3125', '陆河县', '3', '0', '302', '9999', '301'),
('3127', '3126', '东源县', '3', '0', '303', '9999', '302'),
('3128', '3127', '和平县', '3', '0', '303', '9999', '302'),
('3129', '3128', '源城区', '3', '0', '303', '9999', '302'),
('3130', '3129', '紫金县', '3', '0', '303', '9999', '302'),
('3131', '3130', '连平县', '3', '0', '303', '9999', '302'),
('3132', '3131', '龙川县', '3', '0', '303', '9999', '302'),
('3133', '3132', '江城区', '3', '0', '304', '9999', '303'),
('3134', '3133', '阳东县', '3', '0', '304', '9999', '303'),
('3135', '3134', '阳春市', '3', '0', '304', '9999', '303'),
('3136', '3135', '阳西县', '3', '0', '304', '9999', '303'),
('3137', '3136', '佛冈县', '3', '0', '305', '9999', '304'),
('3138', '3137', '清城区', '3', '0', '305', '9999', '304'),
('3139', '3138', '清新县', '3', '0', '305', '9999', '304'),
('3140', '3139', '英德市', '3', '0', '305', '9999', '304'),
('3141', '3140', '连南瑶族自治县', '3', '0', '305', '9999', '304'),
('3142', '3141', '连山壮族瑶族自治县', '3', '0', '305', '9999', '304'),
('3143', '3142', '连州市', '3', '0', '305', '9999', '304'),
('3144', '3143', '阳山县', '3', '0', '305', '9999', '304'),
('3145', '3144', '东莞市', '3', '0', '306', '9999', '305'),
('3146', '3145', '中山市', '3', '0', '307', '9999', '306'),
('3147', '3146', '湘桥区', '3', '0', '308', '9999', '307'),
('3148', '3147', '潮安县', '3', '0', '308', '9999', '307'),
('3149', '3148', '饶平县', '3', '0', '308', '9999', '307'),
('3150', '3149', '惠来县', '3', '0', '309', '9999', '308'),
('3151', '3150', '揭东县', '3', '0', '309', '9999', '308'),
('3152', '3151', '揭西县', '3', '0', '309', '9999', '308'),
('3153', '3152', '普宁市', '3', '0', '309', '9999', '308'),
('3154', '3153', '榕城区', '3', '0', '309', '9999', '308'),
('3155', '3154', '云城区', '3', '0', '310', '9999', '309'),
('3156', '3155', '云安县', '3', '0', '310', '9999', '309'),
('3157', '3156', '新兴县', '3', '0', '310', '9999', '309'),
('3158', '3157', '罗定市', '3', '0', '310', '9999', '309'),
('3159', '3158', '郁南县', '3', '0', '310', '9999', '309'),
('3160', '3159', '上林县', '3', '0', '311', '9999', '310'),
('3161', '3160', '兴宁区', '3', '0', '311', '9999', '310'),
('3162', '3161', '宾阳县', '3', '0', '311', '9999', '310'),
('3163', '3162', '横县', '3', '0', '311', '9999', '310'),
('3164', '3163', '武鸣县', '3', '0', '311', '9999', '310'),
('3165', '3164', '江南区', '3', '0', '311', '9999', '310'),
('3166', '3165', '良庆区', '3', '0', '311', '9999', '310'),
('3167', '3166', '西乡塘区', '3', '0', '311', '9999', '310'),
('3168', '3167', '邕宁区', '3', '0', '311', '9999', '310'),
('3169', '3168', '隆安县', '3', '0', '311', '9999', '310'),
('3170', '3169', '青秀区', '3', '0', '311', '9999', '310'),
('3171', '3170', '马山县', '3', '0', '311', '9999', '310'),
('3172', '3171', '三江侗族自治县', '3', '0', '312', '9999', '311'),
('3173', '3172', '城中区', '3', '0', '312', '9999', '311'),
('3174', '3173', '柳北区', '3', '0', '312', '9999', '311'),
('3175', '3174', '柳南区', '3', '0', '312', '9999', '311'),
('3176', '3175', '柳城县', '3', '0', '312', '9999', '311'),
('3177', '3176', '柳江县', '3', '0', '312', '9999', '311'),
('3178', '3177', '融安县', '3', '0', '312', '9999', '311'),
('3179', '3178', '融水苗族自治县', '3', '0', '312', '9999', '311'),
('3180', '3179', '鱼峰区', '3', '0', '312', '9999', '311'),
('3181', '3180', '鹿寨县', '3', '0', '312', '9999', '311'),
('3182', '3181', '七星区', '3', '0', '313', '9999', '312'),
('3183', '3182', '临桂县', '3', '0', '313', '9999', '312'),
('3184', '3183', '全州县', '3', '0', '313', '9999', '312'),
('3185', '3184', '兴安县', '3', '0', '313', '9999', '312'),
('3186', '3185', '叠彩区', '3', '0', '313', '9999', '312'),
('3187', '3186', '平乐县', '3', '0', '313', '9999', '312'),
('3188', '3187', '恭城瑶族自治县', '3', '0', '313', '9999', '312'),
('3189', '3188', '永福县', '3', '0', '313', '9999', '312'),
('3190', '3189', '灌阳县', '3', '0', '313', '9999', '312'),
('3191', '3190', '灵川县', '3', '0', '313', '9999', '312'),
('3192', '3191', '秀峰区', '3', '0', '313', '9999', '312'),
('3193', '3192', '荔浦县', '3', '0', '313', '9999', '312'),
('3194', '3193', '象山区', '3', '0', '313', '9999', '312'),
('3195', '3194', '资源县', '3', '0', '313', '9999', '312'),
('3196', '3195', '阳朔县', '3', '0', '313', '9999', '312'),
('3197', '3196', '雁山区', '3', '0', '313', '9999', '312'),
('3198', '3197', '龙胜各族自治县', '3', '0', '313', '9999', '312'),
('3199', '3198', '万秀区', '3', '0', '314', '9999', '313'),
('3200', '3199', '岑溪市', '3', '0', '314', '9999', '313'),
('3201', '3200', '苍梧县', '3', '0', '314', '9999', '313'),
('3202', '3201', '蒙山县', '3', '0', '314', '9999', '313'),
('3203', '3202', '藤县', '3', '0', '314', '9999', '313'),
('3204', '3203', '蝶山区', '3', '0', '314', '9999', '313'),
('3205', '3204', '长洲区', '3', '0', '314', '9999', '313'),
('3206', '3205', '合浦县', '3', '0', '315', '9999', '314'),
('3207', '3206', '海城区', '3', '0', '315', '9999', '314'),
('3208', '3207', '铁山港区', '3', '0', '315', '9999', '314'),
('3209', '3208', '银海区', '3', '0', '315', '9999', '314'),
('3210', '3209', '上思县', '3', '0', '316', '9999', '315'),
('3211', '3210', '东兴市', '3', '0', '316', '9999', '315'),
('3212', '3211', '港口区', '3', '0', '316', '9999', '315'),
('3213', '3212', '防城区', '3', '0', '316', '9999', '315'),
('3214', '3213', '浦北县', '3', '0', '317', '9999', '316'),
('3215', '3214', '灵山县', '3', '0', '317', '9999', '316'),
('3216', '3215', '钦北区', '3', '0', '317', '9999', '316'),
('3217', '3216', '钦南区', '3', '0', '317', '9999', '316'),
('3218', '3217', '平南县', '3', '0', '318', '9999', '317'),
('3219', '3218', '桂平市', '3', '0', '318', '9999', '317'),
('3220', '3219', '港北区', '3', '0', '318', '9999', '317'),
('3221', '3220', '港南区', '3', '0', '318', '9999', '317'),
('3222', '3221', '覃塘区', '3', '0', '318', '9999', '317'),
('3223', '3222', '兴业县', '3', '0', '319', '9999', '318'),
('3224', '3223', '北流市', '3', '0', '319', '9999', '318'),
('3225', '3224', '博白县', '3', '0', '319', '9999', '318'),
('3226', '3225', '容县', '3', '0', '319', '9999', '318'),
('3227', '3226', '玉州区', '3', '0', '319', '9999', '318'),
('3228', '3227', '陆川县', '3', '0', '319', '9999', '318'),
('3229', '3228', '乐业县', '3', '0', '320', '9999', '319'),
('3230', '3229', '凌云县', '3', '0', '320', '9999', '319'),
('3231', '3230', '右江区', '3', '0', '320', '9999', '319'),
('3232', '3231', '平果县', '3', '0', '320', '9999', '319'),
('3233', '3232', '德保县', '3', '0', '320', '9999', '319'),
('3234', '3233', '田东县', '3', '0', '320', '9999', '319'),
('3235', '3234', '田林县', '3', '0', '320', '9999', '319'),
('3236', '3235', '田阳县', '3', '0', '320', '9999', '319'),
('3237', '3236', '西林县', '3', '0', '320', '9999', '319'),
('3238', '3237', '那坡县', '3', '0', '320', '9999', '319'),
('3239', '3238', '隆林各族自治县', '3', '0', '320', '9999', '319'),
('3240', '3239', '靖西县', '3', '0', '320', '9999', '319'),
('3241', '3240', '八步区', '3', '0', '321', '9999', '320'),
('3242', '3241', '富川瑶族自治县', '3', '0', '321', '9999', '320'),
('3243', '3242', '昭平县', '3', '0', '321', '9999', '320'),
('3244', '3243', '钟山县', '3', '0', '321', '9999', '320'),
('3245', '3244', '东兰县', '3', '0', '322', '9999', '321'),
('3246', '3245', '凤山县', '3', '0', '322', '9999', '321'),
('3247', '3246', '南丹县', '3', '0', '322', '9999', '321'),
('3248', '3247', '大化瑶族自治县', '3', '0', '322', '9999', '321'),
('3249', '3248', '天峨县', '3', '0', '322', '9999', '321'),
('3250', '3249', '宜州市', '3', '0', '322', '9999', '321'),
('3251', '3250', '巴马瑶族自治县', '3', '0', '322', '9999', '321'),
('3252', '3251', '环江毛南族自治县', '3', '0', '322', '9999', '321'),
('3253', '3252', '罗城仫佬族自治县', '3', '0', '322', '9999', '321'),
('3254', '3253', '都安瑶族自治县', '3', '0', '322', '9999', '321'),
('3255', '3254', '金城江区', '3', '0', '322', '9999', '321'),
('3256', '3255', '兴宾区', '3', '0', '323', '9999', '322'),
('3257', '3256', '合山市', '3', '0', '323', '9999', '322'),
('3258', '3257', '忻城县', '3', '0', '323', '9999', '322'),
('3259', '3258', '武宣县', '3', '0', '323', '9999', '322'),
('3260', '3259', '象州县', '3', '0', '323', '9999', '322'),
('3261', '3260', '金秀瑶族自治县', '3', '0', '323', '9999', '322'),
('3262', '3261', '凭祥市', '3', '0', '324', '9999', '323'),
('3263', '3262', '大新县', '3', '0', '324', '9999', '323'),
('3264', '3263', '天等县', '3', '0', '324', '9999', '323'),
('3265', '3264', '宁明县', '3', '0', '324', '9999', '323'),
('3266', '3265', '扶绥县', '3', '0', '324', '9999', '323'),
('3267', '3266', '江州区', '3', '0', '324', '9999', '323'),
('3268', '3267', '龙州县', '3', '0', '324', '9999', '323'),
('3269', '3268', '琼山区', '3', '0', '325', '9999', '324'),
('3270', '3269', '秀英区', '3', '0', '325', '9999', '324'),
('3271', '3270', '美兰区', '3', '0', '325', '9999', '324'),
('3272', '3271', '龙华区', '3', '0', '325', '9999', '324'),
('3273', '3272', '三亚市', '3', '0', '326', '9999', '325'),
('3274', '3273', '五指山市', '3', '0', '327', '9999', '326'),
('3275', '3274', '琼海市', '3', '0', '328', '9999', '327'),
('3276', '3275', '儋州市', '3', '0', '329', '9999', '328'),
('3277', '3276', '文昌市', '3', '0', '330', '9999', '329'),
('3278', '3277', '万宁市', '3', '0', '331', '9999', '330'),
('3279', '3278', '东方市', '3', '0', '332', '9999', '331'),
('3280', '3279', '定安县', '3', '0', '333', '9999', '332'),
('3281', '3280', '屯昌县', '3', '0', '334', '9999', '333'),
('3282', '3281', '澄迈县', '3', '0', '335', '9999', '334'),
('3283', '3282', '临高县', '3', '0', '336', '9999', '335'),
('3284', '3283', '白沙黎族自治县', '3', '0', '337', '9999', '336'),
('3285', '3284', '昌江黎族自治县', '3', '0', '338', '9999', '337'),
('3286', '3285', '乐东黎族自治县', '3', '0', '339', '9999', '338'),
('3287', '3286', '陵水黎族自治县', '3', '0', '340', '9999', '339'),
('3288', '3287', '保亭黎族苗族自治县', '3', '0', '341', '9999', '340'),
('3289', '3288', '琼中黎族苗族自治县', '3', '0', '342', '9999', '341'),
('3530', '3529', '茨竹', '3', '0', '357', '9999', '356'),
('4210', '4209', '双流县', '3', '0', '386', '9999', '385'),
('4211', '4210', '大邑县', '3', '0', '386', '9999', '385'),
('4212', '4211', '崇州市', '3', '0', '386', '9999', '385'),
('4213', '4212', '彭州市', '3', '0', '386', '9999', '385'),
('4214', '4213', '成华区', '3', '0', '386', '9999', '385'),
('4215', '4214', '新津县', '3', '0', '386', '9999', '385'),
('4216', '4215', '新都区', '3', '0', '386', '9999', '385'),
('4217', '4216', '武侯区', '3', '0', '386', '9999', '385'),
('4218', '4217', '温江区', '3', '0', '386', '9999', '385'),
('4219', '4218', '蒲江县', '3', '0', '386', '9999', '385'),
('4220', '4219', '邛崃市', '3', '0', '386', '9999', '385'),
('4221', '4220', '郫县', '3', '0', '386', '9999', '385'),
('4222', '4221', '都江堰市', '3', '0', '386', '9999', '385'),
('4223', '4222', '金堂县', '3', '0', '386', '9999', '385'),
('4224', '4223', '金牛区', '3', '0', '386', '9999', '385'),
('4225', '4224', '锦江区', '3', '0', '386', '9999', '385'),
('4226', '4225', '青白江区', '3', '0', '386', '9999', '385'),
('4227', '4226', '青羊区', '3', '0', '386', '9999', '385'),
('4228', '4227', '龙泉驿区', '3', '0', '386', '9999', '385'),
('4229', '4228', '大安区', '3', '0', '387', '9999', '386'),
('4230', '4229', '富顺县', '3', '0', '387', '9999', '386'),
('4231', '4230', '沿滩区', '3', '0', '387', '9999', '386'),
('4232', '4231', '自流井区', '3', '0', '387', '9999', '386'),
('4233', '4232', '荣县', '3', '0', '387', '9999', '386'),
('4234', '4233', '贡井区', '3', '0', '387', '9999', '386'),
('4235', '4234', '东区', '3', '0', '388', '9999', '387'),
('4236', '4235', '仁和区', '3', '0', '388', '9999', '387'),
('4237', '4236', '盐边县', '3', '0', '388', '9999', '387'),
('4238', '4237', '米易县', '3', '0', '388', '9999', '387'),
('4239', '4238', '西区', '3', '0', '388', '9999', '387'),
('4240', '4239', '叙永县', '3', '0', '389', '9999', '388'),
('4241', '4240', '古蔺县', '3', '0', '389', '9999', '388'),
('4242', '4241', '合江县', '3', '0', '389', '9999', '388'),
('4243', '4242', '江阳区', '3', '0', '389', '9999', '388'),
('4244', '4243', '泸县', '3', '0', '389', '9999', '388'),
('4245', '4244', '纳溪区', '3', '0', '389', '9999', '388'),
('4246', '4245', '龙马潭区', '3', '0', '389', '9999', '388'),
('4247', '4246', '中江县', '3', '0', '390', '9999', '389'),
('4248', '4247', '什邡市', '3', '0', '390', '9999', '389'),
('4249', '4248', '广汉市', '3', '0', '390', '9999', '389'),
('4250', '4249', '旌阳区', '3', '0', '390', '9999', '389'),
('4251', '4250', '绵竹市', '3', '0', '390', '9999', '389'),
('4252', '4251', '罗江县', '3', '0', '390', '9999', '389'),
('4253', '4252', '三台县', '3', '0', '391', '9999', '390'),
('4254', '4253', '北川羌族自治县', '3', '0', '391', '9999', '390'),
('4255', '4254', '安县', '3', '0', '391', '9999', '390'),
('4256', '4255', '平武县', '3', '0', '391', '9999', '390'),
('4257', '4256', '梓潼县', '3', '0', '391', '9999', '390'),
('4258', '4257', '江油市', '3', '0', '391', '9999', '390'),
('4259', '4258', '涪城区', '3', '0', '391', '9999', '390'),
('4260', '4259', '游仙区', '3', '0', '391', '9999', '390'),
('4261', '4260', '盐亭县', '3', '0', '391', '9999', '390'),
('4262', '4261', '元坝区', '3', '0', '392', '9999', '391'),
('4263', '4262', '利州区', '3', '0', '392', '9999', '391'),
('4264', '4263', '剑阁县', '3', '0', '392', '9999', '391'),
('4265', '4264', '旺苍县', '3', '0', '392', '9999', '391'),
('4266', '4265', '朝天区', '3', '0', '392', '9999', '391'),
('4267', '4266', '苍溪县', '3', '0', '392', '9999', '391'),
('4268', '4267', '青川县', '3', '0', '392', '9999', '391'),
('4269', '4268', '大英县', '3', '0', '393', '9999', '392'),
('4270', '4269', '安居区', '3', '0', '393', '9999', '392'),
('4271', '4270', '射洪县', '3', '0', '393', '9999', '392'),
('4272', '4271', '船山区', '3', '0', '393', '9999', '392'),
('4273', '4272', '蓬溪县', '3', '0', '393', '9999', '392'),
('4274', '4273', '东兴区', '3', '0', '394', '9999', '393'),
('4275', '4274', '威远县', '3', '0', '394', '9999', '393'),
('4276', '4275', '市中区', '3', '0', '394', '9999', '393'),
('4277', '4276', '资中县', '3', '0', '394', '9999', '393'),
('4278', '4277', '隆昌县', '3', '0', '394', '9999', '393'),
('4279', '4278', '五通桥区', '3', '0', '395', '9999', '394'),
('4280', '4279', '井研县', '3', '0', '395', '9999', '394'),
('4281', '4280', '夹江县', '3', '0', '395', '9999', '394'),
('4282', '4281', '峨眉山市', '3', '0', '395', '9999', '394'),
('4283', '4282', '峨边彝族自治县', '3', '0', '395', '9999', '394'),
('4284', '4283', '市中区', '3', '0', '395', '9999', '394'),
('4285', '4284', '沐川县', '3', '0', '395', '9999', '394'),
('4286', '4285', '沙湾区', '3', '0', '395', '9999', '394'),
('4287', '4286', '犍为县', '3', '0', '395', '9999', '394'),
('4288', '4287', '金口河区', '3', '0', '395', '9999', '394'),
('4289', '4288', '马边彝族自治县', '3', '0', '395', '9999', '394'),
('4290', '4289', '仪陇县', '3', '0', '396', '9999', '395'),
('4291', '4290', '南充市嘉陵区', '3', '0', '396', '9999', '395'),
('4292', '4291', '南部县', '3', '0', '396', '9999', '395'),
('4293', '4292', '嘉陵区', '3', '0', '396', '9999', '395'),
('4294', '4293', '营山县', '3', '0', '396', '9999', '395'),
('4295', '4294', '蓬安县', '3', '0', '396', '9999', '395'),
('4296', '4295', '西充县', '3', '0', '396', '9999', '395'),
('4297', '4296', '阆中市', '3', '0', '396', '9999', '395'),
('4298', '4297', '顺庆区', '3', '0', '396', '9999', '395'),
('4299', '4298', '高坪区', '3', '0', '396', '9999', '395'),
('4300', '4299', '东坡区', '3', '0', '397', '9999', '396'),
('4301', '4300', '丹棱县', '3', '0', '397', '9999', '396'),
('4302', '4301', '仁寿县', '3', '0', '397', '9999', '396'),
('4303', '4302', '彭山县', '3', '0', '397', '9999', '396'),
('4304', '4303', '洪雅县', '3', '0', '397', '9999', '396'),
('4305', '4304', '青神县', '3', '0', '397', '9999', '396'),
('4306', '4305', '兴文县', '3', '0', '398', '9999', '397'),
('4307', '4306', '南溪县', '3', '0', '398', '9999', '397'),
('4308', '4307', '宜宾县', '3', '0', '398', '9999', '397'),
('4309', '4308', '屏山县', '3', '0', '398', '9999', '397'),
('4310', '4309', '江安县', '3', '0', '398', '9999', '397'),
('4311', '4310', '珙县', '3', '0', '398', '9999', '397'),
('4312', '4311', '筠连县', '3', '0', '398', '9999', '397'),
('4313', '4312', '翠屏区', '3', '0', '398', '9999', '397'),
('4314', '4313', '长宁县', '3', '0', '398', '9999', '397'),
('4315', '4314', '高县', '3', '0', '398', '9999', '397'),
('4316', '4315', '华蓥市', '3', '0', '399', '9999', '398'),
('4317', '4316', '岳池县', '3', '0', '399', '9999', '398'),
('4318', '4317', '广安区', '3', '0', '399', '9999', '398'),
('4319', '4318', '武胜县', '3', '0', '399', '9999', '398'),
('4320', '4319', '邻水县', '3', '0', '399', '9999', '398'),
('4321', '4320', '万源市', '3', '0', '400', '9999', '399'),
('4322', '4321', '大竹县', '3', '0', '400', '9999', '399'),
('4323', '4322', '宣汉县', '3', '0', '400', '9999', '399'),
('4324', '4323', '开江县', '3', '0', '400', '9999', '399'),
('4325', '4324', '渠县', '3', '0', '400', '9999', '399'),
('4326', '4325', '达县', '3', '0', '400', '9999', '399'),
('4327', '4326', '通川区', '3', '0', '400', '9999', '399'),
('4328', '4327', '名山县', '3', '0', '401', '9999', '400'),
('4329', '4328', '天全县', '3', '0', '401', '9999', '400'),
('4330', '4329', '宝兴县', '3', '0', '401', '9999', '400'),
('4331', '4330', '汉源县', '3', '0', '401', '9999', '400'),
('4332', '4331', '石棉县', '3', '0', '401', '9999', '400'),
('4333', '4332', '芦山县', '3', '0', '401', '9999', '400'),
('4334', '4333', '荥经县', '3', '0', '401', '9999', '400'),
('4335', '4334', '雨城区', '3', '0', '401', '9999', '400'),
('4336', '4335', '南江县', '3', '0', '402', '9999', '401'),
('4337', '4336', '巴州区', '3', '0', '402', '9999', '401'),
('4338', '4337', '平昌县', '3', '0', '402', '9999', '401'),
('4339', '4338', '通江县', '3', '0', '402', '9999', '401'),
('4340', '4339', '乐至县', '3', '0', '403', '9999', '402'),
('4341', '4340', '安岳县', '3', '0', '403', '9999', '402'),
('4342', '4341', '简阳市', '3', '0', '403', '9999', '402'),
('4343', '4342', '雁江区', '3', '0', '403', '9999', '402'),
('4344', '4343', '九寨沟县', '3', '0', '404', '9999', '403'),
('4345', '4344', '壤塘县', '3', '0', '404', '9999', '403'),
('4346', '4345', '小金县', '3', '0', '404', '9999', '403'),
('4347', '4346', '松潘县', '3', '0', '404', '9999', '403'),
('4348', '4347', '汶川县', '3', '0', '404', '9999', '403'),
('4349', '4348', '理县', '3', '0', '404', '9999', '403'),
('4350', '4349', '红原县', '3', '0', '404', '9999', '403'),
('4351', '4350', '若尔盖县', '3', '0', '404', '9999', '403'),
('4352', '4351', '茂县', '3', '0', '404', '9999', '403'),
('4353', '4352', '金川县', '3', '0', '404', '9999', '403'),
('4354', '4353', '阿坝县', '3', '0', '404', '9999', '403'),
('4355', '4354', '马尔康县', '3', '0', '404', '9999', '403'),
('4356', '4355', '黑水县', '3', '0', '404', '9999', '403'),
('4357', '4356', '丹巴县', '3', '0', '405', '9999', '404'),
('4358', '4357', '乡城县', '3', '0', '405', '9999', '404'),
('4359', '4358', '巴塘县', '3', '0', '405', '9999', '404'),
('4360', '4359', '康定县', '3', '0', '405', '9999', '404'),
('4361', '4360', '得荣县', '3', '0', '405', '9999', '404'),
('4362', '4361', '德格县', '3', '0', '405', '9999', '404'),
('4363', '4362', '新龙县', '3', '0', '405', '9999', '404'),
('4364', '4363', '泸定县', '3', '0', '405', '9999', '404'),
('4365', '4364', '炉霍县', '3', '0', '405', '9999', '404'),
('4366', '4365', '理塘县', '3', '0', '405', '9999', '404'),
('4367', '4366', '甘孜县', '3', '0', '405', '9999', '404'),
('4368', '4367', '白玉县', '3', '0', '405', '9999', '404'),
('4369', '4368', '石渠县', '3', '0', '405', '9999', '404'),
('4370', '4369', '稻城县', '3', '0', '405', '9999', '404'),
('4371', '4370', '色达县', '3', '0', '405', '9999', '404'),
('4372', '4371', '道孚县', '3', '0', '405', '9999', '404'),
('4373', '4372', '雅江县', '3', '0', '405', '9999', '404'),
('4374', '4373', '会东县', '3', '0', '406', '9999', '405'),
('4375', '4374', '会理县', '3', '0', '406', '9999', '405'),
('4376', '4375', '冕宁县', '3', '0', '406', '9999', '405'),
('4377', '4376', '喜德县', '3', '0', '406', '9999', '405'),
('4378', '4377', '宁南县', '3', '0', '406', '9999', '405'),
('4379', '4378', '布拖县', '3', '0', '406', '9999', '405'),
('4380', '4379', '德昌县', '3', '0', '406', '9999', '405'),
('4381', '4380', '昭觉县', '3', '0', '406', '9999', '405'),
('4382', '4381', '普格县', '3', '0', '406', '9999', '405'),
('4383', '4382', '木里藏族自治县', '3', '0', '406', '9999', '405'),
('4384', '4383', '甘洛县', '3', '0', '406', '9999', '405'),
('4385', '4384', '盐源县', '3', '0', '406', '9999', '405'),
('4386', '4385', '美姑县', '3', '0', '406', '9999', '405'),
('4387', '4386', '西昌', '3', '0', '406', '9999', '405'),
('4388', '4387', '越西县', '3', '0', '406', '9999', '405'),
('4389', '4388', '金阳县', '3', '0', '406', '9999', '405'),
('4390', '4389', '雷波县', '3', '0', '406', '9999', '405'),
('4391', '4390', '乌当区', '3', '0', '407', '9999', '406'),
('4392', '4391', '云岩区', '3', '0', '407', '9999', '406'),
('4393', '4392', '修文县', '3', '0', '407', '9999', '406'),
('4394', '4393', '南明区', '3', '0', '407', '9999', '406'),
('4395', '4394', '小河区', '3', '0', '407', '9999', '406'),
('4396', '4395', '开阳县', '3', '0', '407', '9999', '406'),
('4397', '4396', '息烽县', '3', '0', '407', '9999', '406'),
('4398', '4397', '清镇市', '3', '0', '407', '9999', '406'),
('4399', '4398', '白云区', '3', '0', '407', '9999', '406'),
('4400', '4399', '花溪区', '3', '0', '407', '9999', '406'),
('4401', '4400', '六枝特区', '3', '0', '408', '9999', '407'),
('4402', '4401', '水城县', '3', '0', '408', '9999', '407'),
('4403', '4402', '盘县', '3', '0', '408', '9999', '407'),
('4404', '4403', '钟山区', '3', '0', '408', '9999', '407'),
('4405', '4404', '习水县', '3', '0', '409', '9999', '408'),
('4406', '4405', '仁怀市', '3', '0', '409', '9999', '408'),
('4407', '4406', '余庆县', '3', '0', '409', '9999', '408'),
('4408', '4407', '凤冈县', '3', '0', '409', '9999', '408'),
('4409', '4408', '务川仡佬族苗族自治县', '3', '0', '409', '9999', '408'),
('4410', '4409', '桐梓县', '3', '0', '409', '9999', '408'),
('4411', '4410', '正安县', '3', '0', '409', '9999', '408'),
('4412', '4411', '汇川区', '3', '0', '409', '9999', '408'),
('4413', '4412', '湄潭县', '3', '0', '409', '9999', '408'),
('4414', '4413', '红花岗区', '3', '0', '409', '9999', '408'),
('4415', '4414', '绥阳县', '3', '0', '409', '9999', '408'),
('4416', '4415', '赤水市', '3', '0', '409', '9999', '408'),
('4417', '4416', '道真仡佬族苗族自治县', '3', '0', '409', '9999', '408'),
('4418', '4417', '遵义县', '3', '0', '409', '9999', '408'),
('4419', '4418', '关岭布依族苗族自治县', '3', '0', '410', '9999', '409'),
('4420', '4419', '平坝县', '3', '0', '410', '9999', '409'),
('4421', '4420', '普定县', '3', '0', '410', '9999', '409'),
('4422', '4421', '紫云苗族布依族自治县', '3', '0', '410', '9999', '409'),
('4423', '4422', '西秀区', '3', '0', '410', '9999', '409'),
('4424', '4423', '镇宁布依族苗族自治县', '3', '0', '410', '9999', '409'),
('4425', '4424', '万山特区', '3', '0', '411', '9999', '410'),
('4426', '4425', '印江土家族苗族自治县', '3', '0', '411', '9999', '410'),
('4427', '4426', '德江县', '3', '0', '411', '9999', '410'),
('4428', '4427', '思南县', '3', '0', '411', '9999', '410'),
('4429', '4428', '松桃苗族自治县', '3', '0', '411', '9999', '410'),
('4430', '4429', '江口县', '3', '0', '411', '9999', '410'),
('4431', '4430', '沿河土家族自治县', '3', '0', '411', '9999', '410'),
('4432', '4431', '玉屏侗族自治县', '3', '0', '411', '9999', '410'),
('4433', '4432', '石阡县', '3', '0', '411', '9999', '410'),
('4434', '4433', '铜仁市', '3', '0', '411', '9999', '410'),
('4435', '4434', '兴义市', '3', '0', '412', '9999', '411'),
('4436', '4435', '兴仁县', '3', '0', '412', '9999', '411'),
('4437', '4436', '册亨县', '3', '0', '412', '9999', '411'),
('4438', '4437', '安龙县', '3', '0', '412', '9999', '411'),
('4439', '4438', '普安县', '3', '0', '412', '9999', '411'),
('4440', '4439', '晴隆县', '3', '0', '412', '9999', '411'),
('4441', '4440', '望谟县', '3', '0', '412', '9999', '411'),
('4442', '4441', '贞丰县', '3', '0', '412', '9999', '411'),
('4443', '4442', '大方县', '3', '0', '413', '9999', '412'),
('4444', '4443', '威宁彝族回族苗族自治县', '3', '0', '413', '9999', '412'),
('4445', '4444', '毕节市', '3', '0', '413', '9999', '412'),
('4446', '4445', '纳雍县', '3', '0', '413', '9999', '412'),
('4447', '4446', '织金县', '3', '0', '413', '9999', '412'),
('4448', '4447', '赫章县', '3', '0', '413', '9999', '412'),
('4449', '4448', '金沙县', '3', '0', '413', '9999', '412'),
('4450', '4449', '黔西县', '3', '0', '413', '9999', '412'),
('4451', '4450', '三穗县', '3', '0', '414', '9999', '413'),
('4452', '4451', '丹寨县', '3', '0', '414', '9999', '413'),
('4453', '4452', '从江县', '3', '0', '414', '9999', '413'),
('4454', '4453', '凯里市', '3', '0', '414', '9999', '413'),
('4455', '4454', '剑河县', '3', '0', '414', '9999', '413'),
('4456', '4455', '台江县', '3', '0', '414', '9999', '413'),
('4457', '4456', '天柱县', '3', '0', '414', '9999', '413'),
('4458', '4457', '岑巩县', '3', '0', '414', '9999', '413'),
('4459', '4458', '施秉县', '3', '0', '414', '9999', '413'),
('4460', '4459', '榕江县', '3', '0', '414', '9999', '413'),
('4461', '4460', '锦屏县', '3', '0', '414', '9999', '413'),
('4462', '4461', '镇远县', '3', '0', '414', '9999', '413'),
('4463', '4462', '雷山县', '3', '0', '414', '9999', '413'),
('4464', '4463', '麻江县', '3', '0', '414', '9999', '413'),
('4465', '4464', '黄平县', '3', '0', '414', '9999', '413'),
('4466', '4465', '黎平县', '3', '0', '414', '9999', '413'),
('4467', '4466', '三都水族自治县', '3', '0', '415', '9999', '414'),
('4468', '4467', '平塘县', '3', '0', '415', '9999', '414'),
('4469', '4468', '惠水县', '3', '0', '415', '9999', '414'),
('4470', '4469', '独山县', '3', '0', '415', '9999', '414'),
('4471', '4470', '瓮安县', '3', '0', '415', '9999', '414'),
('4472', '4471', '福泉市', '3', '0', '415', '9999', '414'),
('4473', '4472', '罗甸县', '3', '0', '415', '9999', '414'),
('4474', '4473', '荔波县', '3', '0', '415', '9999', '414'),
('4475', '4474', '贵定县', '3', '0', '415', '9999', '414'),
('4476', '4475', '都匀市', '3', '0', '415', '9999', '414'),
('4477', '4476', '长顺县', '3', '0', '415', '9999', '414'),
('4478', '4477', '龙里县', '3', '0', '415', '9999', '414'),
('4479', '4478', '东川区', '3', '0', '416', '9999', '415'),
('4480', '4479', '五华区', '3', '0', '416', '9999', '415'),
('4481', '4480', '呈贡县', '3', '0', '416', '9999', '415'),
('4482', '4481', '安宁市', '3', '0', '416', '9999', '415'),
('4483', '4482', '官渡区', '3', '0', '416', '9999', '415'),
('4484', '4483', '宜良县', '3', '0', '416', '9999', '415'),
('4485', '4484', '富民县', '3', '0', '416', '9999', '415'),
('4486', '4485', '寻甸回族彝族自治县', '3', '0', '416', '9999', '415'),
('4487', '4486', '嵩明县', '3', '0', '416', '9999', '415'),
('4488', '4487', '晋宁县', '3', '0', '416', '9999', '415'),
('4489', '4488', '盘龙区', '3', '0', '416', '9999', '415'),
('4490', '4489', '石林彝族自治县', '3', '0', '416', '9999', '415'),
('4491', '4490', '禄劝彝族苗族自治县', '3', '0', '416', '9999', '415'),
('4492', '4491', '西山区', '3', '0', '416', '9999', '415'),
('4493', '4492', '会泽县', '3', '0', '417', '9999', '416'),
('4494', '4493', '宣威市', '3', '0', '417', '9999', '416'),
('4495', '4494', '富源县', '3', '0', '417', '9999', '416'),
('4496', '4495', '师宗县', '3', '0', '417', '9999', '416'),
('4497', '4496', '沾益县', '3', '0', '417', '9999', '416'),
('4498', '4497', '罗平县', '3', '0', '417', '9999', '416'),
('4499', '4498', '陆良县', '3', '0', '417', '9999', '416'),
('4500', '4499', '马龙县', '3', '0', '417', '9999', '416'),
('4501', '4500', '麒麟区', '3', '0', '417', '9999', '416'),
('4502', '4501', '元江哈尼族彝族傣族自治县', '3', '0', '418', '9999', '417'),
('4503', '4502', '华宁县', '3', '0', '418', '9999', '417'),
('4504', '4503', '峨山彝族自治县', '3', '0', '418', '9999', '417'),
('4505', '4504', '新平彝族傣族自治县', '3', '0', '418', '9999', '417'),
('4506', '4505', '易门县', '3', '0', '418', '9999', '417'),
('4507', '4506', '江川县', '3', '0', '418', '9999', '417'),
('4508', '4507', '澄江县', '3', '0', '418', '9999', '417'),
('4509', '4508', '红塔区', '3', '0', '418', '9999', '417'),
('4510', '4509', '通海县', '3', '0', '418', '9999', '417'),
('4511', '4510', '施甸县', '3', '0', '419', '9999', '418'),
('4512', '4511', '昌宁县', '3', '0', '419', '9999', '418'),
('4513', '4512', '腾冲县', '3', '0', '419', '9999', '418'),
('4514', '4513', '隆阳区', '3', '0', '419', '9999', '418'),
('4515', '4514', '龙陵县', '3', '0', '419', '9999', '418'),
('4516', '4515', '大关县', '3', '0', '420', '9999', '419'),
('4517', '4516', '威信县', '3', '0', '420', '9999', '419'),
('4518', '4517', '巧家县', '3', '0', '420', '9999', '419'),
('4519', '4518', '彝良县', '3', '0', '420', '9999', '419'),
('4520', '4519', '昭阳区', '3', '0', '420', '9999', '419'),
('4521', '4520', '水富县', '3', '0', '420', '9999', '419'),
('4522', '4521', '永善县', '3', '0', '420', '9999', '419'),
('4523', '4522', '盐津县', '3', '0', '420', '9999', '419'),
('4524', '4523', '绥江县', '3', '0', '420', '9999', '419'),
('4525', '4524', '镇雄县', '3', '0', '420', '9999', '419'),
('4526', '4525', '鲁甸县', '3', '0', '420', '9999', '419'),
('4527', '4526', '华坪县', '3', '0', '421', '9999', '420'),
('4528', '4527', '古城区', '3', '0', '421', '9999', '420'),
('4529', '4528', '宁蒗彝族自治县', '3', '0', '421', '9999', '420'),
('4530', '4529', '永胜县', '3', '0', '421', '9999', '420'),
('4531', '4530', '玉龙纳西族自治县', '3', '0', '421', '9999', '420'),
('4532', '4531', '临翔区', '3', '0', '423', '9999', '422'),
('4533', '4532', '云县', '3', '0', '423', '9999', '422'),
('4534', '4533', '凤庆县', '3', '0', '423', '9999', '422'),
('4535', '4534', '双江拉祜族佤族布朗族傣族自治县', '3', '0', '423', '9999', '422'),
('4536', '4535', '永德县', '3', '0', '423', '9999', '422'),
('4537', '4536', '沧源佤族自治县', '3', '0', '423', '9999', '422'),
('4538', '4537', '耿马傣族佤族自治县', '3', '0', '423', '9999', '422'),
('4539', '4538', '镇康县', '3', '0', '423', '9999', '422'),
('4540', '4539', '元谋县', '3', '0', '424', '9999', '423'),
('4541', '4540', '南华县', '3', '0', '424', '9999', '423'),
('4542', '4541', '双柏县', '3', '0', '424', '9999', '423'),
('4543', '4542', '大姚县', '3', '0', '424', '9999', '423'),
('4544', '4543', '姚安县', '3', '0', '424', '9999', '423'),
('4545', '4544', '楚雄市', '3', '0', '424', '9999', '423'),
('4546', '4545', '武定县', '3', '0', '424', '9999', '423'),
('4547', '4546', '永仁县', '3', '0', '424', '9999', '423'),
('4548', '4547', '牟定县', '3', '0', '424', '9999', '423'),
('4549', '4548', '禄丰县', '3', '0', '424', '9999', '423'),
('4550', '4549', '个旧市', '3', '0', '425', '9999', '424'),
('4551', '4550', '元阳县', '3', '0', '425', '9999', '424'),
('4552', '4551', '屏边苗族自治县', '3', '0', '425', '9999', '424'),
('4553', '4552', '建水县', '3', '0', '425', '9999', '424'),
('4554', '4553', '开远市', '3', '0', '425', '9999', '424'),
('4555', '4554', '弥勒市', '3', '0', '425', '9999', '424'),
('4556', '4555', '河口瑶族自治县', '3', '0', '425', '9999', '424'),
('4557', '4556', '泸西县', '3', '0', '425', '9999', '424'),
('4558', '4557', '石屏县', '3', '0', '425', '9999', '424'),
('4559', '4558', '红河县', '3', '0', '425', '9999', '424'),
('4560', '4559', '绿春县', '3', '0', '425', '9999', '424'),
('4561', '4560', '蒙自县', '3', '0', '425', '9999', '424'),
('4562', '4561', '金平苗族瑶族傣族自治县', '3', '0', '425', '9999', '424'),
('4563', '4562', '丘北县', '3', '0', '426', '9999', '425'),
('4564', '4563', '富宁县', '3', '0', '426', '9999', '425'),
('4565', '4564', '广南县', '3', '0', '426', '9999', '425'),
('4566', '4565', '文山县', '3', '0', '426', '9999', '425'),
('4567', '4566', '砚山县', '3', '0', '426', '9999', '425'),
('4568', '4567', '西畴县', '3', '0', '426', '9999', '425'),
('4569', '4568', '马关县', '3', '0', '426', '9999', '425'),
('4570', '4569', '麻栗坡县', '3', '0', '426', '9999', '425'),
('4571', '4570', '勐海县', '3', '0', '427', '9999', '426'),
('4572', '4571', '勐腊县', '3', '0', '427', '9999', '426'),
('4573', '4572', '景洪市', '3', '0', '427', '9999', '426'),
('4574', '4573', '云龙县', '3', '0', '428', '9999', '427'),
('4575', '4574', '剑川县', '3', '0', '428', '9999', '427'),
('4576', '4575', '南涧彝族自治县', '3', '0', '428', '9999', '427'),
('4577', '4576', '大理市', '3', '0', '428', '9999', '427'),
('4578', '4577', '宾川县', '3', '0', '428', '9999', '427'),
('4579', '4578', '巍山彝族回族自治县', '3', '0', '428', '9999', '427'),
('4580', '4579', '弥渡县', '3', '0', '428', '9999', '427'),
('4581', '4580', '永平县', '3', '0', '428', '9999', '427'),
('4582', '4581', '洱源县', '3', '0', '428', '9999', '427'),
('4583', '4582', '漾濞彝族自治县', '3', '0', '428', '9999', '427'),
('4584', '4583', '祥云县', '3', '0', '428', '9999', '427'),
('4585', '4584', '鹤庆县', '3', '0', '428', '9999', '427'),
('4586', '4585', '梁河县', '3', '0', '429', '9999', '428'),
('4587', '4586', '潞西市', '3', '0', '429', '9999', '428'),
('4588', '4587', '瑞丽市', '3', '0', '429', '9999', '428'),
('4589', '4588', '盈江县', '3', '0', '429', '9999', '428'),
('4590', '4589', '陇川县', '3', '0', '429', '9999', '428'),
('4591', '4590', '德钦县', '3', '0', '431', '9999', '430'),
('4592', '4591', '维西傈僳族自治县', '3', '0', '431', '9999', '430'),
('4593', '4592', '香格里拉县', '3', '0', '431', '9999', '430'),
('4594', '4593', '城关区', '3', '0', '432', '9999', '431'),
('4595', '4594', '堆龙德庆县', '3', '0', '432', '9999', '431'),
('4596', '4595', '墨竹工卡县', '3', '0', '432', '9999', '431'),
('4597', '4596', '尼木县', '3', '0', '432', '9999', '431'),
('4598', '4597', '当雄县', '3', '0', '432', '9999', '431'),
('4599', '4598', '曲水县', '3', '0', '432', '9999', '431'),
('4600', '4599', '林周县', '3', '0', '432', '9999', '431'),
('4601', '4600', '达孜县', '3', '0', '432', '9999', '431'),
('4602', '4601', '丁青县', '3', '0', '433', '9999', '432'),
('4603', '4602', '八宿县', '3', '0', '433', '9999', '432'),
('4604', '4603', '察雅县', '3', '0', '433', '9999', '432'),
('4605', '4604', '左贡县', '3', '0', '433', '9999', '432'),
('4606', '4605', '昌都县', '3', '0', '433', '9999', '432'),
('4607', '4606', '江达县', '3', '0', '433', '9999', '432'),
('4608', '4607', '洛隆县', '3', '0', '433', '9999', '432'),
('4609', '4608', '类乌齐县', '3', '0', '433', '9999', '432'),
('4610', '4609', '芒康县', '3', '0', '433', '9999', '432'),
('4611', '4610', '贡觉县', '3', '0', '433', '9999', '432'),
('4612', '4611', '边坝县', '3', '0', '433', '9999', '432'),
('4613', '4612', '乃东县', '3', '0', '434', '9999', '433'),
('4614', '4613', '加查县', '3', '0', '434', '9999', '433'),
('4615', '4614', '扎囊县', '3', '0', '434', '9999', '433'),
('4616', '4615', '措美县', '3', '0', '434', '9999', '433'),
('4617', '4616', '曲松县', '3', '0', '434', '9999', '433'),
('4618', '4617', '桑日县', '3', '0', '434', '9999', '433'),
('4619', '4618', '洛扎县', '3', '0', '434', '9999', '433'),
('4620', '4619', '浪卡子县', '3', '0', '434', '9999', '433'),
('4621', '4620', '琼结县', '3', '0', '434', '9999', '433'),
('4622', '4621', '贡嘎县', '3', '0', '434', '9999', '433'),
('4623', '4622', '错那县', '3', '0', '434', '9999', '433'),
('4624', '4623', '隆子县', '3', '0', '434', '9999', '433'),
('4625', '4624', '亚东县', '3', '0', '435', '9999', '434'),
('4626', '4625', '仁布县', '3', '0', '435', '9999', '434'),
('4627', '4626', '仲巴县', '3', '0', '435', '9999', '434'),
('4628', '4627', '南木林县', '3', '0', '435', '9999', '434'),
('4629', '4628', '吉隆县', '3', '0', '435', '9999', '434'),
('4630', '4629', '定日县', '3', '0', '435', '9999', '434'),
('4631', '4630', '定结县', '3', '0', '435', '9999', '434'),
('4632', '4631', '岗巴县', '3', '0', '435', '9999', '434'),
('4633', '4632', '康马县', '3', '0', '435', '9999', '434'),
('4634', '4633', '拉孜县', '3', '0', '435', '9999', '434'),
('4635', '4634', '日喀则市', '3', '0', '435', '9999', '434'),
('4636', '4635', '昂仁县', '3', '0', '435', '9999', '434'),
('4637', '4636', '江孜县', '3', '0', '435', '9999', '434'),
('4638', '4637', '白朗县', '3', '0', '435', '9999', '434'),
('4639', '4638', '聂拉木县', '3', '0', '435', '9999', '434'),
('4640', '4639', '萨嘎县', '3', '0', '435', '9999', '434'),
('4641', '4640', '萨迦县', '3', '0', '435', '9999', '434'),
('4642', '4641', '谢通门县', '3', '0', '435', '9999', '434'),
('4643', '4642', '嘉黎县', '3', '0', '436', '9999', '435'),
('4644', '4643', '安多县', '3', '0', '436', '9999', '435'),
('4645', '4644', '尼玛县', '3', '0', '436', '9999', '435'),
('4646', '4645', '巴青县', '3', '0', '436', '9999', '435'),
('4647', '4646', '比如县', '3', '0', '436', '9999', '435'),
('4648', '4647', '班戈县', '3', '0', '436', '9999', '435'),
('4649', '4648', '申扎县', '3', '0', '436', '9999', '435'),
('4650', '4649', '索县', '3', '0', '436', '9999', '435'),
('4651', '4650', '聂荣县', '3', '0', '436', '9999', '435'),
('4652', '4651', '那曲县', '3', '0', '436', '9999', '435'),
('4653', '4652', '噶尔县', '3', '0', '437', '9999', '436'),
('4654', '4653', '措勤县', '3', '0', '437', '9999', '436'),
('4655', '4654', '改则县', '3', '0', '437', '9999', '436'),
('4656', '4655', '日土县', '3', '0', '437', '9999', '436'),
('4657', '4656', '普兰县', '3', '0', '437', '9999', '436'),
('4658', '4657', '札达县', '3', '0', '437', '9999', '436'),
('4659', '4658', '革吉县', '3', '0', '437', '9999', '436'),
('4660', '4659', '墨脱县', '3', '0', '438', '9999', '437'),
('4661', '4660', '察隅县', '3', '0', '438', '9999', '437'),
('4662', '4661', '工布江达县', '3', '0', '438', '9999', '437'),
('4663', '4662', '朗县', '3', '0', '438', '9999', '437'),
('4664', '4663', '林芝县', '3', '0', '438', '9999', '437'),
('4665', '4664', '波密县', '3', '0', '438', '9999', '437'),
('4666', '4665', '米林县', '3', '0', '438', '9999', '437'),
('4667', '4666', '临潼区', '3', '0', '439', '9999', '438'),
('4668', '4667', '周至县', '3', '0', '439', '9999', '438'),
('4669', '4668', '户县', '3', '0', '439', '9999', '438'),
('4670', '4669', '新城区', '3', '0', '439', '9999', '438'),
('4671', '4670', '未央区', '3', '0', '439', '9999', '438'),
('4672', '4671', '灞桥区', '3', '0', '439', '9999', '438'),
('4673', '4672', '碑林区', '3', '0', '439', '9999', '438'),
('4674', '4673', '莲湖区', '3', '0', '439', '9999', '438'),
('4675', '4674', '蓝田县', '3', '0', '439', '9999', '438'),
('4676', '4675', '长安区', '3', '0', '439', '9999', '438'),
('4677', '4676', '阎良区', '3', '0', '439', '9999', '438'),
('4678', '4677', '雁塔区', '3', '0', '439', '9999', '438'),
('4679', '4678', '高陵县', '3', '0', '439', '9999', '438'),
('4680', '4679', '印台区', '3', '0', '440', '9999', '439'),
('4681', '4680', '宜君县', '3', '0', '440', '9999', '439'),
('4682', '4681', '王益区', '3', '0', '440', '9999', '439'),
('4683', '4682', '耀州区', '3', '0', '440', '9999', '439'),
('4684', '4683', '凤县', '3', '0', '441', '9999', '440'),
('4685', '4684', '凤翔县', '3', '0', '441', '9999', '440'),
('4686', '4685', '千阳县', '3', '0', '441', '9999', '440'),
('4687', '4686', '太白县', '3', '0', '441', '9999', '440'),
('4688', '4687', '岐山县', '3', '0', '441', '9999', '440'),
('4689', '4688', '扶风县', '3', '0', '441', '9999', '440'),
('4690', '4689', '渭滨区', '3', '0', '441', '9999', '440'),
('4691', '4690', '眉县', '3', '0', '441', '9999', '440'),
('4692', '4691', '金台区', '3', '0', '441', '9999', '440'),
('4693', '4692', '陇县', '3', '0', '441', '9999', '440'),
('4694', '4693', '陈仓区', '3', '0', '441', '9999', '440'),
('4695', '4694', '麟游县', '3', '0', '441', '9999', '440'),
('4696', '4695', '三原县', '3', '0', '442', '9999', '441'),
('4697', '4696', '干县', '3', '0', '442', '9999', '441'),
('4698', '4697', '兴平市', '3', '0', '442', '9999', '441'),
('4699', '4698', '彬县', '3', '0', '442', '9999', '441'),
('4700', '4699', '旬邑县', '3', '0', '442', '9999', '441'),
('4701', '4700', '杨陵区', '3', '0', '442', '9999', '441'),
('4702', '4701', '武功县', '3', '0', '442', '9999', '441'),
('4703', '4702', '永寿县', '3', '0', '442', '9999', '441'),
('4704', '4703', '泾阳县', '3', '0', '442', '9999', '441'),
('4705', '4704', '淳化县', '3', '0', '442', '9999', '441'),
('4706', '4705', '渭城区', '3', '0', '442', '9999', '441'),
('4707', '4706', '礼泉县', '3', '0', '442', '9999', '441'),
('4708', '4707', '秦都区', '3', '0', '442', '9999', '441'),
('4709', '4708', '长武县', '3', '0', '442', '9999', '441'),
('4710', '4709', '临渭区', '3', '0', '443', '9999', '442'),
('4711', '4710', '华县', '3', '0', '443', '9999', '442'),
('4712', '4711', '华阴市', '3', '0', '443', '9999', '442'),
('4713', '4712', '合阳县', '3', '0', '443', '9999', '442'),
('4714', '4713', '大荔县', '3', '0', '443', '9999', '442'),
('4715', '4714', '富平县', '3', '0', '443', '9999', '442'),
('4716', '4715', '潼关县', '3', '0', '443', '9999', '442'),
('4717', '4716', '澄城县', '3', '0', '443', '9999', '442'),
('4718', '4717', '白水县', '3', '0', '443', '9999', '442'),
('4719', '4718', '蒲城县', '3', '0', '443', '9999', '442'),
('4720', '4719', '韩城市', '3', '0', '443', '9999', '442'),
('4721', '4720', '吴起县', '3', '0', '444', '9999', '443'),
('4722', '4721', '子长县', '3', '0', '444', '9999', '443'),
('4723', '4722', '安塞县', '3', '0', '444', '9999', '443'),
('4724', '4723', '宜川县', '3', '0', '444', '9999', '443'),
('4725', '4724', '宝塔区', '3', '0', '444', '9999', '443'),
('4726', '4725', '富县', '3', '0', '444', '9999', '443'),
('4727', '4726', '延川县', '3', '0', '444', '9999', '443'),
('4728', '4727', '延长县', '3', '0', '444', '9999', '443'),
('4729', '4728', '志丹县', '3', '0', '444', '9999', '443'),
('4730', '4729', '洛川县', '3', '0', '444', '9999', '443'),
('4731', '4730', '甘泉县', '3', '0', '444', '9999', '443'),
('4732', '4731', '黄陵县', '3', '0', '444', '9999', '443'),
('4733', '4732', '黄龙县', '3', '0', '444', '9999', '443'),
('4734', '4733', '佛坪县', '3', '0', '445', '9999', '444'),
('4735', '4734', '勉县', '3', '0', '445', '9999', '444'),
('4736', '4735', '南郑县', '3', '0', '445', '9999', '444'),
('4737', '4736', '城固县', '3', '0', '445', '9999', '444'),
('4738', '4737', '宁强县', '3', '0', '445', '9999', '444'),
('4739', '4738', '汉台区', '3', '0', '445', '9999', '444'),
('4740', '4739', '洋县', '3', '0', '445', '9999', '444'),
('4741', '4740', '留坝县', '3', '0', '445', '9999', '444'),
('4742', '4741', '略阳县', '3', '0', '445', '9999', '444'),
('4743', '4742', '西乡县', '3', '0', '445', '9999', '444'),
('4744', '4743', '镇巴县', '3', '0', '445', '9999', '444'),
('4745', '4744', '佳县', '3', '0', '446', '9999', '445'),
('4746', '4745', '吴堡县', '3', '0', '446', '9999', '445'),
('4747', '4746', '子洲县', '3', '0', '446', '9999', '445'),
('4748', '4747', '定边县', '3', '0', '446', '9999', '445'),
('4749', '4748', '府谷县', '3', '0', '446', '9999', '445'),
('4750', '4749', '榆林市榆阳区', '3', '0', '446', '9999', '445'),
('4751', '4750', '横山县', '3', '0', '446', '9999', '445'),
('4752', '4751', '清涧县', '3', '0', '446', '9999', '445'),
('4753', '4752', '神木县', '3', '0', '446', '9999', '445'),
('4754', '4753', '米脂县', '3', '0', '446', '9999', '445'),
('4755', '4754', '绥德县', '3', '0', '446', '9999', '445'),
('4756', '4755', '靖边县', '3', '0', '446', '9999', '445'),
('4757', '4756', '宁陕县', '3', '0', '447', '9999', '446'),
('4758', '4757', '岚皋县', '3', '0', '447', '9999', '446'),
('4759', '4758', '平利县', '3', '0', '447', '9999', '446'),
('4760', '4759', '旬阳县', '3', '0', '447', '9999', '446'),
('4761', '4760', '汉滨区', '3', '0', '447', '9999', '446'),
('4762', '4761', '汉阴县', '3', '0', '447', '9999', '446'),
('4763', '4762', '白河县', '3', '0', '447', '9999', '446'),
('4764', '4763', '石泉县', '3', '0', '447', '9999', '446'),
('4765', '4764', '紫阳县', '3', '0', '447', '9999', '446'),
('4766', '4765', '镇坪县', '3', '0', '447', '9999', '446'),
('4767', '4766', '丹凤县', '3', '0', '448', '9999', '447'),
('4768', '4767', '商南县', '3', '0', '448', '9999', '447'),
('4769', '4768', '商州区', '3', '0', '448', '9999', '447'),
('4770', '4769', '山阳县', '3', '0', '448', '9999', '447'),
('4771', '4770', '柞水县', '3', '0', '448', '9999', '447'),
('4772', '4771', '洛南县', '3', '0', '448', '9999', '447'),
('4773', '4772', '镇安县', '3', '0', '448', '9999', '447'),
('4774', '4773', '七里河区', '3', '0', '449', '9999', '448'),
('4775', '4774', '城关区', '3', '0', '449', '9999', '448'),
('4776', '4775', '安宁区', '3', '0', '449', '9999', '448'),
('4777', '4776', '榆中县', '3', '0', '449', '9999', '448'),
('4778', '4777', '永登县', '3', '0', '449', '9999', '448'),
('4779', '4778', '皋兰县', '3', '0', '449', '9999', '448'),
('4780', '4779', '红古区', '3', '0', '449', '9999', '448'),
('4781', '4780', '西固区', '3', '0', '449', '9999', '448'),
('4782', '4781', '嘉峪关市', '3', '0', '450', '9999', '449'),
('4783', '4782', '永昌县', '3', '0', '451', '9999', '450'),
('4784', '4783', '金川区', '3', '0', '451', '9999', '450'),
('4785', '4784', '会宁县', '3', '0', '452', '9999', '451'),
('4786', '4785', '平川区', '3', '0', '452', '9999', '451'),
('4787', '4786', '景泰县', '3', '0', '452', '9999', '451'),
('4788', '4787', '白银区', '3', '0', '452', '9999', '451'),
('4789', '4788', '靖远县', '3', '0', '452', '9999', '451'),
('4790', '4789', '张家川回族自治县', '3', '0', '453', '9999', '452'),
('4791', '4790', '武山县', '3', '0', '453', '9999', '452'),
('4792', '4791', '清水县', '3', '0', '453', '9999', '452'),
('4793', '4792', '甘谷县', '3', '0', '453', '9999', '452'),
('4794', '4793', '秦安县', '3', '0', '453', '9999', '452'),
('4795', '4794', '秦州区', '3', '0', '453', '9999', '452'),
('4796', '4795', '麦积区', '3', '0', '453', '9999', '452'),
('4797', '4796', '凉州区', '3', '0', '454', '9999', '453'),
('4798', '4797', '古浪县', '3', '0', '454', '9999', '453'),
('4799', '4798', '天祝藏族自治县', '3', '0', '454', '9999', '453'),
('4800', '4799', '民勤县', '3', '0', '454', '9999', '453'),
('4801', '4800', '临泽县', '3', '0', '455', '9999', '454'),
('4802', '4801', '山丹县', '3', '0', '455', '9999', '454'),
('4803', '4802', '民乐县', '3', '0', '455', '9999', '454'),
('4804', '4803', '甘州区', '3', '0', '455', '9999', '454'),
('4805', '4804', '肃南裕固族自治县', '3', '0', '455', '9999', '454'),
('4806', '4805', '高台县', '3', '0', '455', '9999', '454'),
('4807', '4806', '华亭县', '3', '0', '456', '9999', '455'),
('4808', '4807', '崆峒区', '3', '0', '456', '9999', '455'),
('4809', '4808', '崇信县', '3', '0', '456', '9999', '455'),
('4810', '4809', '庄浪县', '3', '0', '456', '9999', '455'),
('4811', '4810', '泾川县', '3', '0', '456', '9999', '455'),
('4812', '4811', '灵台县', '3', '0', '456', '9999', '455'),
('4813', '4812', '静宁县', '3', '0', '456', '9999', '455'),
('4814', '4813', '敦煌市', '3', '0', '457', '9999', '456'),
('4815', '4814', '玉门市', '3', '0', '457', '9999', '456'),
('4816', '4815', '瓜州县（原安西县）', '3', '0', '457', '9999', '456'),
('4817', '4816', '肃北蒙古族自治县', '3', '0', '457', '9999', '456'),
('4818', '4817', '肃州区', '3', '0', '457', '9999', '456'),
('4819', '4818', '金塔县', '3', '0', '457', '9999', '456'),
('4820', '4819', '阿克塞哈萨克族自治县', '3', '0', '457', '9999', '456'),
('4821', '4820', '华池县', '3', '0', '458', '9999', '457'),
('4822', '4821', '合水县', '3', '0', '458', '9999', '457'),
('4823', '4822', '宁县', '3', '0', '458', '9999', '457'),
('4824', '4823', '庆城县', '3', '0', '458', '9999', '457'),
('4825', '4824', '正宁县', '3', '0', '458', '9999', '457'),
('4826', '4825', '环县', '3', '0', '458', '9999', '457'),
('4827', '4826', '西峰区', '3', '0', '458', '9999', '457'),
('4828', '4827', '镇原县', '3', '0', '458', '9999', '457'),
('4829', '4828', '临洮县', '3', '0', '459', '9999', '458'),
('4830', '4829', '安定区', '3', '0', '459', '9999', '458'),
('4831', '4830', '岷县', '3', '0', '459', '9999', '458'),
('4832', '4831', '渭源县', '3', '0', '459', '9999', '458'),
('4833', '4832', '漳县', '3', '0', '459', '9999', '458'),
('4834', '4833', '通渭县', '3', '0', '459', '9999', '458'),
('4835', '4834', '陇西县', '3', '0', '459', '9999', '458'),
('4836', '4835', '两当县', '3', '0', '460', '9999', '459'),
('4837', '4836', '宕昌县', '3', '0', '460', '9999', '459'),
('4838', '4837', '康县', '3', '0', '460', '9999', '459'),
('4839', '4838', '徽县', '3', '0', '460', '9999', '459'),
('4840', '4839', '成县', '3', '0', '460', '9999', '459'),
('4841', '4840', '文县', '3', '0', '460', '9999', '459'),
('4842', '4841', '武都区', '3', '0', '460', '9999', '459'),
('4843', '4842', '礼县', '3', '0', '460', '9999', '459'),
('4844', '4843', '西和县', '3', '0', '460', '9999', '459'),
('4845', '4844', '东乡族自治县', '3', '0', '461', '9999', '460'),
('4846', '4845', '临夏县', '3', '0', '461', '9999', '460'),
('4847', '4846', '临夏市', '3', '0', '461', '9999', '460'),
('4848', '4847', '和政县', '3', '0', '461', '9999', '460'),
('4849', '4848', '广河县', '3', '0', '461', '9999', '460'),
('4850', '4849', '康乐县', '3', '0', '461', '9999', '460'),
('4851', '4850', '永靖县', '3', '0', '461', '9999', '460'),
('4852', '4851', '积石山保安族东乡族撒拉族自治县', '3', '0', '461', '9999', '460'),
('4853', '4852', '临潭县', '3', '0', '462', '9999', '461'),
('4854', '4853', '卓尼县', '3', '0', '462', '9999', '461'),
('4855', '4854', '合作市', '3', '0', '462', '9999', '461'),
('4856', '4855', '夏河县', '3', '0', '462', '9999', '461'),
('4857', '4856', '玛曲县', '3', '0', '462', '9999', '461'),
('4858', '4857', '碌曲县', '3', '0', '462', '9999', '461'),
('4859', '4858', '舟曲县', '3', '0', '462', '9999', '461'),
('4860', '4859', '迭部县', '3', '0', '462', '9999', '461'),
('4861', '4860', '城东区', '3', '0', '463', '9999', '462'),
('4862', '4861', '城中区', '3', '0', '463', '9999', '462'),
('4863', '4862', '城北区', '3', '0', '463', '9999', '462'),
('4864', '4863', '城西区', '3', '0', '463', '9999', '462'),
('4865', '4864', '大通回族土族自治县', '3', '0', '463', '9999', '462'),
('4866', '4865', '湟中县', '3', '0', '463', '9999', '462'),
('4867', '4866', '湟源县', '3', '0', '463', '9999', '462'),
('4868', '4867', '乐都县', '3', '0', '464', '9999', '463'),
('4869', '4868', '互助土族自治县', '3', '0', '464', '9999', '463'),
('4870', '4869', '化隆回族自治县', '3', '0', '464', '9999', '463'),
('4871', '4870', '平安县', '3', '0', '464', '9999', '463'),
('4872', '4871', '循化撒拉族自治县', '3', '0', '464', '9999', '463'),
('4873', '4872', '民和回族土族自治县', '3', '0', '464', '9999', '463'),
('4874', '4873', '刚察县', '3', '0', '465', '9999', '464'),
('4875', '4874', '海晏县', '3', '0', '465', '9999', '464'),
('4876', '4875', '祁连县', '3', '0', '465', '9999', '464'),
('4877', '4876', '门源回族自治县', '3', '0', '465', '9999', '464'),
('4878', '4877', '同仁县', '3', '0', '466', '9999', '465'),
('4879', '4878', '尖扎县', '3', '0', '466', '9999', '465'),
('4880', '4879', '河南蒙古族自治县', '3', '0', '466', '9999', '465'),
('4881', '4880', '泽库县', '3', '0', '466', '9999', '465'),
('4882', '4881', '共和县', '3', '0', '467', '9999', '466'),
('4883', '4882', '兴海县', '3', '0', '467', '9999', '466'),
('4884', '4883', '同德县', '3', '0', '467', '9999', '466'),
('4885', '4884', '贵南县', '3', '0', '467', '9999', '466'),
('4886', '4885', '贵德县', '3', '0', '467', '9999', '466'),
('4887', '4886', '久治县', '3', '0', '468', '9999', '467'),
('4888', '4887', '玛多县', '3', '0', '468', '9999', '467'),
('4889', '4888', '玛沁县', '3', '0', '468', '9999', '467'),
('4890', '4889', '班玛县', '3', '0', '468', '9999', '467'),
('4891', '4890', '甘德县', '3', '0', '468', '9999', '467'),
('4892', '4891', '达日县', '3', '0', '468', '9999', '467'),
('4893', '4892', '囊谦县', '3', '0', '469', '9999', '468'),
('4894', '4893', '曲麻莱县', '3', '0', '469', '9999', '468'),
('4895', '4894', '杂多县', '3', '0', '469', '9999', '468'),
('4896', '4895', '治多县', '3', '0', '469', '9999', '468'),
('4897', '4896', '玉树县', '3', '0', '469', '9999', '468'),
('4898', '4897', '称多县', '3', '0', '469', '9999', '468'),
('4899', '4898', '乌兰县', '3', '0', '470', '9999', '469'),
('4900', '4899', '冷湖行委', '3', '0', '470', '9999', '469'),
('4901', '4900', '大柴旦行委', '3', '0', '470', '9999', '469'),
('4902', '4901', '天峻县', '3', '0', '470', '9999', '469'),
('4903', '4902', '德令哈市', '3', '0', '470', '9999', '469'),
('4904', '4903', '格尔木市', '3', '0', '470', '9999', '469'),
('4905', '4904', '茫崖行委', '3', '0', '470', '9999', '469'),
('4906', '4905', '都兰县', '3', '0', '470', '9999', '469'),
('4907', '4906', '兴庆区', '3', '0', '471', '9999', '470'),
('4908', '4907', '永宁县', '3', '0', '471', '9999', '470'),
('4909', '4908', '灵武市', '3', '0', '471', '9999', '470'),
('4910', '4909', '西夏区', '3', '0', '471', '9999', '470'),
('4911', '4910', '贺兰县', '3', '0', '471', '9999', '470'),
('4912', '4911', '金凤区', '3', '0', '471', '9999', '470'),
('4913', '4912', '大武口区', '3', '0', '472', '9999', '471'),
('4914', '4913', '平罗县', '3', '0', '472', '9999', '471'),
('4915', '4914', '惠农区', '3', '0', '472', '9999', '471'),
('4916', '4915', '利通区', '3', '0', '473', '9999', '472'),
('4917', '4916', '同心县', '3', '0', '473', '9999', '472'),
('4918', '4917', '盐池县', '3', '0', '473', '9999', '472'),
('4919', '4918', '青铜峡市', '3', '0', '473', '9999', '472'),
('4920', '4919', '原州区', '3', '0', '474', '9999', '473'),
('4921', '4920', '彭阳县', '3', '0', '474', '9999', '473'),
('4922', '4921', '泾源县', '3', '0', '474', '9999', '473'),
('4923', '4922', '西吉县', '3', '0', '474', '9999', '473'),
('4924', '4923', '隆德县', '3', '0', '474', '9999', '473'),
('4925', '4924', '中宁县', '3', '0', '475', '9999', '474'),
('4926', '4925', '沙坡头区', '3', '0', '475', '9999', '474'),
('4927', '4926', '海原县', '3', '0', '475', '9999', '474'),
('4928', '4927', '东山区', '3', '0', '476', '9999', '475'),
('4929', '4928', '乌鲁木齐县', '3', '0', '476', '9999', '475'),
('4930', '4929', '天山区', '3', '0', '476', '9999', '475'),
('4931', '4930', '头屯河区', '3', '0', '476', '9999', '475'),
('4932', '4931', '新市区', '3', '0', '476', '9999', '475'),
('4933', '4932', '水磨沟区', '3', '0', '476', '9999', '475'),
('4934', '4933', '沙依巴克区', '3', '0', '476', '9999', '475'),
('4935', '4934', '达坂城区', '3', '0', '476', '9999', '475'),
('4936', '4935', '乌尔禾区', '3', '0', '477', '9999', '476'),
('4937', '4936', '克拉玛依区', '3', '0', '477', '9999', '476'),
('4938', '4937', '独山子区', '3', '0', '477', '9999', '476'),
('4939', '4938', '白碱滩区', '3', '0', '477', '9999', '476'),
('4940', '4939', '吐鲁番市', '3', '0', '478', '9999', '477'),
('4941', '4940', '托克逊县', '3', '0', '478', '9999', '477'),
('4942', '4941', '鄯善县', '3', '0', '478', '9999', '477'),
('4943', '4942', '伊吾县', '3', '0', '479', '9999', '478'),
('4944', '4943', '哈密市', '3', '0', '479', '9999', '478'),
('4945', '4944', '巴里坤哈萨克自治县', '3', '0', '479', '9999', '478'),
('4946', '4945', '吉木萨尔县', '3', '0', '480', '9999', '479'),
('4947', '4946', '呼图壁县', '3', '0', '480', '9999', '479'),
('4948', '4947', '奇台县', '3', '0', '480', '9999', '479'),
('4949', '4948', '昌吉市', '3', '0', '480', '9999', '479'),
('4950', '4949', '木垒哈萨克自治县', '3', '0', '480', '9999', '479'),
('4951', '4950', '玛纳斯县', '3', '0', '480', '9999', '479'),
('4952', '4951', '米泉市', '3', '0', '480', '9999', '479'),
('4953', '4952', '阜康市', '3', '0', '480', '9999', '479'),
('4954', '4953', '博乐市', '3', '0', '481', '9999', '480'),
('4955', '4954', '温泉县', '3', '0', '481', '9999', '480'),
('4956', '4955', '精河县', '3', '0', '481', '9999', '480'),
('4957', '4956', '博湖县', '3', '0', '482', '9999', '481'),
('4958', '4957', '和硕县', '3', '0', '482', '9999', '481'),
('4959', '4958', '和静县', '3', '0', '482', '9999', '481'),
('4960', '4959', '尉犁县', '3', '0', '482', '9999', '481'),
('4961', '4960', '库尔勒市', '3', '0', '482', '9999', '481'),
('4962', '4961', '焉耆回族自治县', '3', '0', '482', '9999', '481'),
('4963', '4962', '若羌县', '3', '0', '482', '9999', '481'),
('4964', '4963', '轮台县', '3', '0', '482', '9999', '481'),
('4965', '4964', '乌什县', '3', '0', '483', '9999', '482'),
('4966', '4965', '库车县', '3', '0', '483', '9999', '482'),
('4967', '4966', '拜城县', '3', '0', '483', '9999', '482'),
('4968', '4967', '新和县', '3', '0', '483', '9999', '482'),
('4969', '4968', '柯坪县', '3', '0', '483', '9999', '482'),
('4970', '4969', '沙雅县', '3', '0', '483', '9999', '482'),
('4971', '4970', '温宿县', '3', '0', '483', '9999', '482'),
('4972', '4971', '阿克苏市', '3', '0', '483', '9999', '482'),
('4973', '4972', '阿瓦提县', '3', '0', '483', '9999', '482'),
('4974', '4973', '乌恰县', '3', '0', '484', '9999', '483'),
('4975', '4974', '阿克陶县', '3', '0', '484', '9999', '483'),
('4976', '4975', '阿合奇县', '3', '0', '484', '9999', '483'),
('4977', '4976', '阿图什市', '3', '0', '484', '9999', '483'),
('4978', '4977', '伽师县', '3', '0', '485', '9999', '484'),
('4979', '4978', '叶城县', '3', '0', '485', '9999', '484'),
('4980', '4979', '喀什市', '3', '0', '485', '9999', '484'),
('4981', '4980', '塔什库尔干塔吉克自治县', '3', '0', '485', '9999', '484'),
('4982', '4981', '岳普湖县', '3', '0', '485', '9999', '484'),
('4983', '4982', '巴楚县', '3', '0', '485', '9999', '484'),
('4984', '4983', '泽普县', '3', '0', '485', '9999', '484'),
('4985', '4984', '疏勒县', '3', '0', '485', '9999', '484'),
('4986', '4985', '疏附县', '3', '0', '485', '9999', '484'),
('4987', '4986', '英吉沙县', '3', '0', '485', '9999', '484'),
('4988', '4987', '莎车县', '3', '0', '485', '9999', '484'),
('4989', '4988', '麦盖提县', '3', '0', '485', '9999', '484'),
('4990', '4989', '于田县', '3', '0', '486', '9999', '485'),
('4991', '4990', '和田县', '3', '0', '486', '9999', '485'),
('4992', '4991', '和田市', '3', '0', '486', '9999', '485'),
('4993', '4992', '墨玉县', '3', '0', '486', '9999', '485'),
('4994', '4993', '民丰县', '3', '0', '486', '9999', '485'),
('4995', '4994', '洛浦县', '3', '0', '486', '9999', '485'),
('4996', '4995', '皮山县', '3', '0', '486', '9999', '485'),
('4997', '4996', '策勒县', '3', '0', '486', '9999', '485'),
('4998', '4997', '伊宁县', '3', '0', '487', '9999', '486'),
('4999', '4998', '伊宁市', '3', '0', '487', '9999', '486'),
('5000', '4999', '奎屯市', '3', '0', '487', '9999', '486'),
('5001', '5000', '察布查尔锡伯自治县', '3', '0', '487', '9999', '486'),
('5002', '5001', '尼勒克县', '3', '0', '487', '9999', '486'),
('5003', '5002', '巩留县', '3', '0', '487', '9999', '486'),
('5004', '5003', '新源县', '3', '0', '487', '9999', '486'),
('5005', '5004', '昭苏县', '3', '0', '487', '9999', '486'),
('5006', '5005', '特克斯县', '3', '0', '487', '9999', '486'),
('5007', '5006', '霍城县', '3', '0', '487', '9999', '486'),
('5008', '5007', '乌苏市', '3', '0', '488', '9999', '487'),
('5009', '5008', '和布克赛尔蒙古自治县', '3', '0', '488', '9999', '487'),
('5010', '5009', '塔城市', '3', '0', '488', '9999', '487'),
('5011', '5010', '托里县', '3', '0', '488', '9999', '487'),
('5012', '5011', '沙湾县', '3', '0', '488', '9999', '487'),
('5013', '5012', '裕民县', '3', '0', '488', '9999', '487'),
('5014', '5013', '额敏县', '3', '0', '488', '9999', '487'),
('5015', '5014', '吉木乃县', '3', '0', '489', '9999', '488'),
('5016', '5015', '哈巴河县', '3', '0', '489', '9999', '488'),
('5017', '5016', '富蕴县', '3', '0', '489', '9999', '488'),
('5018', '5017', '布尔津县', '3', '0', '489', '9999', '488'),
('5019', '5018', '福海县', '3', '0', '489', '9999', '488'),
('5020', '5019', '阿勒泰市', '3', '0', '489', '9999', '488'),
('5021', '5020', '青河县', '3', '0', '489', '9999', '488'),
('5022', '5021', '石河子市', '3', '0', '490', '9999', '489'),
('5023', '5022', '阿拉尔市', '3', '0', '491', '9999', '490'),
('5024', '5023', '图木舒克市', '3', '0', '492', '9999', '491'),
('5025', '5024', '五家渠市', '3', '0', '493', '9999', '492'),
('5301', '5300', '南堡开发区', '4', '0', '1150', '9999', '1149'),
('5369', '5368', '一农场', '4', '0', '1154', '9999', '1153'),
('5370', '5369', '七农场', '4', '0', '1154', '9999', '1153'),
('5371', '5370', '三农场', '4', '0', '1154', '9999', '1153'),
('5372', '5371', '九农场', '4', '0', '1154', '9999', '1153'),
('5373', '5372', '二农场', '4', '0', '1154', '9999', '1153'),
('5374', '5373', '五农场', '4', '0', '1154', '9999', '1153'),
('5375', '5374', '八农场', '4', '0', '1154', '9999', '1153'),
('5376', '5375', '六农场', '4', '0', '1154', '9999', '1153'),
('5377', '5376', '十一农场', '4', '0', '1154', '9999', '1153'),
('5378', '5377', '十农场', '4', '0', '1154', '9999', '1153'),
('5380', '5379', '四农场', '4', '0', '1154', '9999', '1153'),
('5939', '5938', '大曹庄农场', '4', '0', '1197', '9999', '1196'),
('6383', '6382', '小王果庄', '4', '0', '1233', '9999', '1232'),
('6566', '6565', '赵家蓬区', '4', '0', '1247', '9999', '1246'),
('7981', '7980', '卓里工贸区', '4', '0', '1362', '9999', '1361'),
('7986', '7985', '牛杜工贸区', '4', '0', '1362', '9999', '1361'),
('7990', '7989', '闫家庄工贸区', '4', '0', '1362', '9999', '1361'),
('8023', '8022', '1个开发区', '4', '0', '1366', '9999', '1365'),
('8068', '8067', '禹都经济技术开发区', '4', '0', '1369', '9999', '1368'),
('8116', '8115', '五台山风景名胜区', '4', '0', '1374', '9999', '1373'),
('8367', '8366', '滨河办事处', '4', '0', '1394', '9999', '1393'),
('8765', '8764', '阿嘎如泰苏木', '4', '0', '1428', '9999', '1427'),
('8781', '8780', '九峰山生态管理委员会', '4', '0', '1430', '9999', '1429'),
('8824', '8823', '巴音敖包苏木', '4', '0', '1434', '9999', '1433'),
('8825', '8824', '巴音珠日和苏木', '4', '0', '1434', '9999', '1433'),
('8827', '8826', '新宝力格苏木', '4', '0', '1434', '9999', '1433'),
('8828', '8827', '查干哈达苏木', '4', '0', '1434', '9999', '1433'),
('8829', '8828', '查干敖包苏木', '4', '0', '1434', '9999', '1433'),
('8830', '8829', '查干淖尔苏木', '4', '0', '1434', '9999', '1433'),
('8835', '8834', '都荣敖包苏木', '4', '0', '1434', '9999', '1433'),
('8836', '8835', '额尔登敖包苏木', '4', '0', '1434', '9999', '1433'),
('8887', '8886', '巴彦查干苏木', '4', '0', '1440', '9999', '1439'),
('8888', '8887', '巴彦高勒苏木', '4', '0', '1440', '9999', '1439'),
('8897', '8896', '达日罕乌拉苏木', '4', '0', '1440', '9999', '1439'),
('8899', '8898', '乃林果树农场', '4', '0', '1441', '9999', '1440'),
('8916', '8915', '马鞍山羊场', '4', '0', '1441', '9999', '1440'),
('8933', '8932', '岗根苏木', '4', '0', '1443', '9999', '1442'),
('8934', '8933', '巴彦塔拉苏木', '4', '0', '1443', '9999', '1442'),
('8937', '8936', '幸福之路苏木', '4', '0', '1443', '9999', '1442'),
('8939', '8938', '查干沐沦苏木', '4', '0', '1443', '9999', '1442'),
('8940', '8939', '查干诺尔苏木', '4', '0', '1443', '9999', '1442'),
('8941', '8940', '沙巴尔台苏木', '4', '0', '1443', '9999', '1442'),
('8942', '8941', '益和诺尔苏木', '4', '0', '1443', '9999', '1442'),
('8943', '8942', '索博日嘎苏木', '4', '0', '1443', '9999', '1442'),
('8945', '8944', '胡日哈苏木', '4', '0', '1443', '9999', '1442'),
('8946', '8945', '西拉沐沦苏木', '4', '0', '1443', '9999', '1442'),
('8949', '8948', '乌兰达坝苏木', '4', '0', '1444', '9999', '1443'),
('8955', '8954', '查干哈达苏木', '4', '0', '1444', '9999', '1443'),
('8958', '8957', '白音勿拉苏木', '4', '0', '1444', '9999', '1443'),
('8980', '8979', '敖润苏莫苏木', '4', '0', '1445', '9999', '1444'),
('9064', '9063', '巴嘎塔拉苏木', '4', '0', '1449', '9999', '1448'),
('9065', '9064', '布力彦苏木', '4', '0', '1449', '9999', '1448'),
('9068', '9067', '新苏莫苏木', '4', '0', '1449', '9999', '1448'),
('9069', '9068', '朝格温都苏木', '4', '0', '1449', '9999', '1448'),
('9072', '9071', '格日僧苏木', '4', '0', '1449', '9999', '1448'),
('9078', '9077', '白音套海苏木', '4', '0', '1449', '9999', '1448'),
('9080', '9079', '阿什罕苏木', '4', '0', '1449', '9999', '1448'),
('9082', '9081', '高日罕苏木', '4', '0', '1449', '9999', '1448'),
('9083', '9082', '东沙布台乡委会', '4', '0', '1450', '9999', '1449'),
('9091', '9090', '巴彦包勒格苏木', '4', '0', '1450', '9999', '1449'),
('9093', '9092', '巴彦温都尔苏木', '4', '0', '1450', '9999', '1449'),
('9095', '9094', '巴彦诺尔苏木', '4', '0', '1450', '9999', '1449'),
('9096', '9095', '巴拉奇如德苏木', '4', '0', '1450', '9999', '1449'),
('9099', '9098', '柴达木苏木', '4', '0', '1450', '9999', '1449'),
('9102', '9101', '罕苏木苏木', '4', '0', '1450', '9999', '1449'),
('9104', '9103', '赛汉塔拉苏木', '4', '0', '1450', '9999', '1449'),
('9109', '9108', '固日班花苏木', '4', '0', '1451', '9999', '1450'),
('9110', '9109', '国有六号农场', '4', '0', '1451', '9999', '1450'),
('9113', '9112', '奈林苏木', '4', '0', '1451', '9999', '1450'),
('9114', '9113', '巴嘎波日和苏木', '4', '0', '1451', '9999', '1450'),
('9118', '9117', '明仁苏木', '4', '0', '1451', '9999', '1450'),
('9121', '9120', '清河苏木', '4', '0', '1451', '9999', '1450'),
('9124', '9123', '章古台苏木', '4', '0', '1451', '9999', '1450'),
('9129', '9128', '先进苏木', '4', '0', '1452', '9999', '1451'),
('9131', '9130', '哈尔稿苏木', '4', '0', '1452', '9999', '1451'),
('9135', '9134', '白音花苏木', '4', '0', '1452', '9999', '1451'),
('9136', '9135', '茫汗苏木', '4', '0', '1452', '9999', '1451'),
('9141', '9140', '义和塔拉苏木', '4', '0', '1453', '9999', '1452'),
('9155', '9154', '清河牧场', '4', '0', '1453', '9999', '1452'),
('9159', '9158', '乌兰哈达苏木', '4', '0', '1454', '9999', '1453'),
('9160', '9159', '乌力吉木仁苏木', '4', '0', '1454', '9999', '1453'),
('9161', '9160', '乌额格其苏木', '4', '0', '1454', '9999', '1453'),
('9162', '9161', '前德门苏木', '4', '0', '1454', '9999', '1453'),
('9164', '9163', '嘎达苏种畜场', '4', '0', '1454', '9999', '1453'),
('9167', '9166', '巴彦塔拉苏木', '4', '0', '1454', '9999', '1453'),
('9168', '9167', '巴彦芒哈苏木', '4', '0', '1454', '9999', '1453'),
('9170', '9169', '查布嘎图苏木', '4', '0', '1454', '9999', '1453'),
('9171', '9170', '格日朝鲁苏木', '4', '0', '1454', '9999', '1453'),
('9172', '9171', '毛都苏木', '4', '0', '1454', '9999', '1453'),
('9175', '9174', '道老杜苏木', '4', '0', '1454', '9999', '1453'),
('9176', '9175', '阿日昆都冷苏木', '4', '0', '1454', '9999', '1453'),
('9180', '9179', '三义堂农场', '4', '0', '1455', '9999', '1454'),
('9184', '9183', '哲南农场', '4', '0', '1455', '9999', '1454'),
('9204', '9203', '莫力庙苏木', '4', '0', '1455', '9999', '1454'),
('9212', '9211', '高林屯种畜场', '4', '0', '1455', '9999', '1454'),
('9214', '9213', '东苏林场', '4', '0', '1456', '9999', '1455'),
('9215', '9214', '乌斯吐苏木', '4', '0', '1456', '9999', '1455'),
('9219', '9218', '协代苏木', '4', '0', '1456', '9999', '1455'),
('9220', '9219', '哈日干吐苏木', '4', '0', '1456', '9999', '1455'),
('9222', '9221', '图布信苏木', '4', '0', '1456', '9999', '1455'),
('9224', '9223', '巴彦召苏木', '4', '0', '1456', '9999', '1455'),
('9226', '9225', '巴彦苏木', '4', '0', '1456', '9999', '1455'),
('9228', '9227', '敖包苏木', '4', '0', '1456', '9999', '1455'),
('9229', '9228', '敖本台苏木', '4', '0', '1456', '9999', '1455'),
('9232', '9231', '海力锦苏木', '4', '0', '1456', '9999', '1455'),
('9234', '9233', '白兴吐苏木', '4', '0', '1456', '9999', '1455'),
('9239', '9238', '花胡硕苏木', '4', '0', '1456', '9999', '1455'),
('9241', '9240', '额伦索克苏木', '4', '0', '1456', '9999', '1455'),
('9242', '9241', '乌兰敖道苏木', '4', '0', '1457', '9999', '1456'),
('9244', '9243', '公河来苏木', '4', '0', '1457', '9999', '1456'),
('9249', '9248', '巴嘎塔拉苏木', '4', '0', '1457', '9999', '1456'),
('9250', '9249', '巴彦毛都苏木', '4', '0', '1457', '9999', '1456'),
('9251', '9250', '巴雅斯古楞苏木', '4', '0', '1457', '9999', '1456'),
('9256', '9255', '浩坦苏木', '4', '0', '1457', '9999', '1456'),
('9257', '9256', '海斯改苏木', '4', '0', '1457', '9999', '1456'),
('9261', '9260', '茂道吐苏木', '4', '0', '1457', '9999', '1456'),
('9264', '9263', '阿都沁苏木', '4', '0', '1457', '9999', '1456'),
('9265', '9264', '额莫勒苏木', '4', '0', '1457', '9999', '1456'),
('9270', '9269', '达莱胡硕苏木', '4', '0', '1458', '9999', '1457'),
('9287', '9286', '嘎鲁图苏木', '4', '0', '1460', '9999', '1459'),
('9305', '9304', '布尔陶亥苏木', '4', '0', '1462', '9999', '1461'),
('9320', '9319', '浩绕柴达木苏木', '4', '0', '1463', '9999', '1462'),
('9328', '9327', '展旦召苏木', '4', '0', '1464', '9999', '1463'),
('9346', '9345', '上海庙牧场', '4', '0', '1466', '9999', '1465'),
('9350', '9349', '布拉格苏木', '4', '0', '1466', '9999', '1465'),
('9353', '9352', '毛盖图苏木', '4', '0', '1466', '9999', '1465'),
('9354', '9353', '珠和苏木', '4', '0', '1466', '9999', '1465'),
('9359', '9358', '新召苏木', '4', '0', '1467', '9999', '1466'),
('9361', '9360', '查布苏木', '4', '0', '1467', '9999', '1466'),
('9365', '9364', '苏米图苏木', '4', '0', '1467', '9999', '1466'),
('9366', '9365', '阿尔巴斯苏木', '4', '0', '1467', '9999', '1466'),
('9383', '9382', '克尔伦苏木', '4', '0', '1469', '9999', '1468'),
('9384', '9383', '呼伦苏木', '4', '0', '1469', '9999', '1468'),
('9385', '9384', '宝格德乌拉苏木', '4', '0', '1469', '9999', '1468'),
('9386', '9385', '杭乌拉苏木', '4', '0', '1469', '9999', '1468'),
('9387', '9386', '贝尔苏木', '4', '0', '1469', '9999', '1468'),
('9388', '9387', '赛汉塔拉苏木', '4', '0', '1469', '9999', '1468'),
('9389', '9388', '达来东苏木', '4', '0', '1469', '9999', '1468'),
('9390', '9389', '达来苏木', '4', '0', '1469', '9999', '1468'),
('9392', '9391', '阿敦础鲁苏木', '4', '0', '1469', '9999', '1468'),
('9393', '9392', '乌布尔宝力格苏木', '4', '0', '1470', '9999', '1469'),
('9394', '9393', '吉布胡郎图苏木', '4', '0', '1470', '9999', '1469'),
('9396', '9395', '巴音诺尔苏木', '4', '0', '1470', '9999', '1469'),
('9397', '9396', '甘珠尔苏木', '4', '0', '1470', '9999', '1469'),
('9398', '9397', '罕达盖苏木', '4', '0', '1470', '9999', '1469'),
('9399', '9398', '莫达木吉苏木', '4', '0', '1470', '9999', '1469'),
('9463', '9462', '伊敏苏木', '4', '0', '1477', '9999', '1476'),
('9464', '9463', '大雁矿区', '4', '0', '1477', '9999', '1476'),
('9466', '9465', '巴彦嵯岗苏木', '4', '0', '1477', '9999', '1476'),
('9469', '9468', '辉苏木', '4', '0', '1477', '9999', '1476'),
('9470', '9469', '锡尼河准苏木', '4', '0', '1477', '9999', '1476'),
('9471', '9470', '锡尼河巴润苏木', '4', '0', '1477', '9999', '1476'),
('9481', '9480', '东乌珠尔苏木', '4', '0', '1479', '9999', '1478'),
('9484', '9483', '巴彦哈达苏木', '4', '0', '1479', '9999', '1478'),
('9486', '9485', '特泥河苏木', '4', '0', '1479', '9999', '1478'),
('9487', '9486', '西乌珠尔苏木', '4', '0', '1479', '9999', '1478'),
('9488', '9487', '鄂温克民族苏木', '4', '0', '1479', '9999', '1478'),
('9524', '9523', '乌兰苏木', '4', '0', '1482', '9999', '1481'),
('9527', '9526', '同和太种畜场', '4', '0', '1482', '9999', '1481'),
('9528', '9527', '呼鲁斯太苏木', '4', '0', '1482', '9999', '1481'),
('9530', '9529', '川井苏木', '4', '0', '1482', '9999', '1481'),
('9531', '9530', '巴盟乌北林场', '4', '0', '1482', '9999', '1481'),
('9532', '9531', '巴音哈太苏木', '4', '0', '1482', '9999', '1481'),
('9533', '9532', '巴音杭盖苏木', '4', '0', '1482', '9999', '1481'),
('9534', '9533', '巴音苏木', '4', '0', '1482', '9999', '1481'),
('9536', '9535', '新忽热苏木', '4', '0', '1482', '9999', '1481'),
('9537', '9536', '桑根达来苏木', '4', '0', '1482', '9999', '1481'),
('9540', '9539', '牧羊海牧场', '4', '0', '1482', '9999', '1481'),
('9549', '9548', '巴彦淖尔市国营中滩农场', '4', '0', '1483', '9999', '1482'),
('9550', '9549', '巴彦淖尔市国营乌梁素海渔场', '4', '0', '1483', '9999', '1482'),
('9551', '9550', '巴彦淖尔市国营新安农场', '4', '0', '1483', '9999', '1482'),
('9552', '9551', '巴彦淖尔市国营苏独仑农场', '4', '0', '1483', '9999', '1482'),
('9553', '9552', '巴彦淖尔市国营西山咀农场', '4', '0', '1483', '9999', '1482'),
('9559', '9558', '沙德格苏木', '4', '0', '1483', '9999', '1482'),
('9564', '9563', '额尔登布拉格苏木', '4', '0', '1483', '9999', '1482'),
('9566', '9565', '乌力吉苏木', '4', '0', '1484', '9999', '1483'),
('9567', '9566', '乌根高勒苏木', '4', '0', '1484', '9999', '1483'),
('9569', '9568', '宝音图苏木', '4', '0', '1484', '9999', '1483'),
('9570', '9569', '巴音前达门苏木', '4', '0', '1484', '9999', '1483'),
('9572', '9571', '巴音戈壁苏木', '4', '0', '1484', '9999', '1483'),
('9573', '9572', '巴音温都尔苏木', '4', '0', '1484', '9999', '1483'),
('9575', '9574', '那仁宝力格苏木', '4', '0', '1484', '9999', '1483'),
('9579', '9578', '国营建丰农场', '4', '0', '1485', '9999', '1484'),
('9600', '9599', '巴市太阳庙农场', '4', '0', '1486', '9999', '1485'),
('9608', '9607', '乌兰布和农场', '4', '0', '1487', '9999', '1486'),
('9611', '9610', '哈腾套海农场', '4', '0', '1487', '9999', '1486'),
('9612', '9611', '哈腾套海苏木', '4', '0', '1487', '9999', '1486'),
('9613', '9612', '巴彦套海农场', '4', '0', '1487', '9999', '1486'),
('9615', '9614', '沙漠林业实验中心', '4', '0', '1487', '9999', '1486'),
('9616', '9615', '沙金套海苏木', '4', '0', '1487', '9999', '1486'),
('9618', '9617', '纳林套海农场', '4', '0', '1487', '9999', '1486'),
('9705', '9704', '乌兰哈达苏木', '4', '0', '1494', '9999', '1493'),
('9709', '9708', '卫井苏木', '4', '0', '1494', '9999', '1493'),
('9710', '9709', '吉尔嘎郎图苏木', '4', '0', '1494', '9999', '1493'),
('9717', '9716', '查干敖包苏木', '4', '0', '1494', '9999', '1493'),
('9718', '9717', '查干补力格苏木', '4', '0', '1494', '9999', '1493'),
('9719', '9718', '江岸苏木', '4', '0', '1494', '9999', '1493'),
('9721', '9720', '白音敖包苏木', '4', '0', '1494', '9999', '1493'),
('9722', '9721', '白音朝克图苏木', '4', '0', '1494', '9999', '1493'),
('9723', '9722', '白音花苏木', '4', '0', '1494', '9999', '1493'),
('9724', '9723', '红格尔苏木', '4', '0', '1494', '9999', '1493'),
('9725', '9724', '脑木更苏木', '4', '0', '1494', '9999', '1493'),
('9729', '9728', '乌兰苏木', '4', '0', '1495', '9999', '1494'),
('9740', '9739', '库联苏木', '4', '0', '1495', '9999', '1494'),
('9758', '9757', '乌兰哈达苏木', '4', '0', '1497', '9999', '1496'),
('9760', '9759', '哈彦忽洞苏木', '4', '0', '1497', '9999', '1496'),
('9763', '9762', '当郎忽洞苏木', '4', '0', '1497', '9999', '1496'),
('9769', '9768', '锡勒苏木', '4', '0', '1497', '9999', '1496'),
('9771', '9770', '韩勿拉苏木', '4', '0', '1497', '9999', '1496'),
('9798', '9797', '宝力根花苏木', '4', '0', '1500', '9999', '1499'),
('9801', '9800', '巴彦乌兰苏木', '4', '0', '1500', '9999', '1499'),
('9810', '9809', '阿拉达尔吐苏木', '4', '0', '1500', '9999', '1499'),
('9812', '9811', '代钦塔拉苏木', '4', '0', '1501', '9999', '1500'),
('9814', '9813', '哈日诺尔苏木', '4', '0', '1501', '9999', '1500'),
('9815', '9814', '坤都冷苏木', '4', '0', '1501', '9999', '1500'),
('9819', '9818', '巴彦淖尔苏木', '4', '0', '1501', '9999', '1500'),
('9820', '9819', '巴彦茫哈苏木', '4', '0', '1501', '9999', '1500'),
('9821', '9820', '巴扎拉嘎苏木', '4', '0', '1501', '9999', '1500'),
('9822', '9821', '新佳木苏木', '4', '0', '1501', '9999', '1500'),
('9824', '9823', '西日嘎苏木', '4', '0', '1501', '9999', '1500'),
('9825', '9824', '额木庭高勒苏木', '4', '0', '1501', '9999', '1500'),
('9827', '9826', '乌兰毛都苏木', '4', '0', '1502', '9999', '1501'),
('9829', '9828', '勿布林苏木', '4', '0', '1502', '9999', '1501'),
('9836', '9835', '好仁苏木', '4', '0', '1502', '9999', '1501'),
('9841', '9840', '桃合木苏木', '4', '0', '1502', '9999', '1501'),
('9845', '9844', '阿力得尔苏木', '4', '0', '1502', '9999', '1501'),
('9850', '9849', '国营农场', '4', '0', '1503', '9999', '1502'),
('9869', '9868', '呼热图淖尔苏木', '4', '0', '1505', '9999', '1504'),
('9870', '9869', '嘎达布其镇和萨麦苏木', '4', '0', '1505', '9999', '1504'),
('9876', '9875', '格日勒敖都苏木', '4', '0', '1506', '9999', '1505'),
('9885', '9884', '贡宝拉格苏木', '4', '0', '1508', '9999', '1507'),
('9888', '9887', '哈毕日嘎镇和宝绍代苏木', '4', '0', '1509', '9999', '1508'),
('9890', '9889', '赛音呼都嘎苏木', '4', '0', '1509', '9999', '1508'),
('9891', '9890', '那日图苏木', '4', '0', '1509', '9999', '1508'),
('9892', '9891', '乌兰查布苏木', '4', '0', '1510', '9999', '1509'),
('9893', '9892', '伊和淖尔苏木', '4', '0', '1510', '9999', '1509'),
('9896', '9895', '乌日根塔拉镇和额仁淖尔苏木', '4', '0', '1511', '9999', '1510'),
('9898', '9897', '桑宝拉格苏木', '4', '0', '1511', '9999', '1510'),
('9900', '9899', '赛罕乌力吉苏木', '4', '0', '1511', '9999', '1510'),
('9901', '9900', '巴彦乌拉苏木', '4', '0', '1512', '9999', '1511'),
('9905', '9904', '赛罕高毕苏木', '4', '0', '1512', '9999', '1511'),
('9909', '9908', '浩勒图高勒镇和巴彦胡舒苏木', '4', '0', '1513', '9999', '1512'),
('9912', '9911', '宝力根苏木', '4', '0', '1514', '9999', '1513'),
('9916', '9915', '朝克乌拉苏木', '4', '0', '1514', '9999', '1513'),
('9921', '9920', '巴彦塔拉镇和翁贡乌拉苏木', '4', '0', '1515', '9999', '1514'),
('9923', '9922', '伊和高勒苏木', '4', '0', '1516', '9999', '1515'),
('9925', '9924', '吉尔嘎朗图苏木', '4', '0', '1516', '9999', '1515'),
('9928', '9927', '那仁宝拉格苏木', '4', '0', '1516', '9999', '1515'),
('9929', '9928', '阿拉腾敖包镇和孟根布拉格苏木', '4', '0', '1517', '9999', '1516'),
('9930', '9929', '阿拉腾朝克苏木', '4', '0', '1517', '9999', '1516'),
('9933', '9932', '乌力吉苏木', '4', '0', '1518', '9999', '1517'),
('9938', '9937', '巴彦木仁苏木', '4', '0', '1518', '9999', '1517'),
('9940', '9939', '巴彦诺日公苏木', '4', '0', '1518', '9999', '1517'),
('9944', '9943', '腾格里额里斯苏木', '4', '0', '1518', '9999', '1517'),
('9945', '9944', '额尔克哈什哈苏木', '4', '0', '1518', '9999', '1517'),
('9947', '9946', '苏泊淖尔苏木', '4', '0', '1519', '9999', '1518'),
('9948', '9947', '赛汉桃来苏木', '4', '0', '1519', '9999', '1518'),
('9950', '9949', '马鬃山苏木', '4', '0', '1519', '9999', '1518'),
('11265', '11264', '万寿', '4', '0', '1611', '9999', '1610'),
('11266', '11265', '三家蒙古族', '4', '0', '1611', '9999', '1610'),
('11267', '11266', '义成功', '4', '0', '1611', '9999', '1610'),
('11268', '11267', '八家', '4', '0', '1611', '9999', '1610'),
('11269', '11268', '叶柏寿', '4', '0', '1611', '9999', '1610'),
('11270', '11269', '哈拉道', '4', '0', '1611', '9999', '1610'),
('11271', '11270', '喀喇沁', '4', '0', '1611', '9999', '1610'),
('11272', '11271', '太平庄', '4', '0', '1611', '9999', '1610'),
('11273', '11272', '奎德素', '4', '0', '1611', '9999', '1610'),
('11274', '11273', '富山', '4', '0', '1611', '9999', '1610'),
('11275', '11274', '小塘', '4', '0', '1611', '9999', '1610'),
('11276', '11275', '建平', '4', '0', '1611', '9999', '1610'),
('11277', '11276', '张家营子', '4', '0', '1611', '9999', '1610'),
('11278', '11277', '昌隆永', '4', '0', '1611', '9999', '1610'),
('11279', '11278', '朱力科', '4', '0', '1611', '9999', '1610'),
('11280', '11279', '杨树岭', '4', '0', '1611', '9999', '1610'),
('11281', '11280', '榆树林子', '4', '0', '1611', '9999', '1610'),
('11282', '11281', '沙海', '4', '0', '1611', '9999', '1610'),
('11283', '11282', '深井', '4', '0', '1611', '9999', '1610'),
('11284', '11283', '烧锅营子', '4', '0', '1611', '9999', '1610'),
('11285', '11284', '热水', '4', '0', '1611', '9999', '1610'),
('11286', '11285', '白山', '4', '0', '1611', '9999', '1610'),
('11287', '11286', '罗福沟', '4', '0', '1611', '9999', '1610'),
('11288', '11287', '老官地', '4', '0', '1611', '9999', '1610'),
('11289', '11288', '青峰', '4', '0', '1611', '9999', '1610'),
('11290', '11289', '青松岭', '4', '0', '1611', '9999', '1610'),
('11291', '11290', '马场', '4', '0', '1611', '9999', '1610'),
('11292', '11291', '黑水', '4', '0', '1611', '9999', '1610'),
('11622', '11621', '朱雀山管委会', '4', '0', '1630', '9999', '1629'),
('11635', '11634', '哈达湾工业开发区', '4', '0', '1631', '9999', '1630'),
('11640', '11639', '幸福经济管理区', '4', '0', '1631', '9999', '1630'),
('11700', '11699', '磐石经济开发区', '4', '0', '1634', '9999', '1633'),
('11724', '11723', '吉林市高新技术产业开发区', '4', '0', '1636', '9999', '1635'),
('45053', '0', '北京市', '3', '0', '2', '9999', '0'),
('45054', '0', '天津市', '3', '0', '3', '9999', '0'),
('45055', '0', '上海市', '3', '0', '10', '9999', '0'),
('45056', '0', '重庆市', '3', '0', '23', '9999', '0'),
('45057', '0', '永川区', '4', '0', '45056', '9999', '0')
