CREATE TABLE [BackgroundPicture] (
[Id] INTEGER  PRIMARY KEY NOT NULL,
[SizeX] INTEGER  NULL,
[SizeY] INTEGER  NULL,
[Picture] TEXT  NULL,
[Timestamp] TIMESTAMP  NULL
);

CREATE TABLE [CarNote] (
[Objectid] INTEGER  NOT NULL PRIMARY KEY,
[Type] INTEGER  NULL,
[Color] INTEGER  NULL
);

CREATE TABLE [HumanNote] (
[ObjectId] INTEGER  NOT NULL PRIMARY KEY,
[M_F] INTEGER  NULL,
[ColorR] INTEGER  NULL,
[ColorG] INTEGER  NULL,
[ColorB] INTEGER  NULL,
[TopColorR] INTEGER  NULL,
[TopColorG] INTEGER  NULL,
[TopColorB] INTEGER  NULL,
[BottomColorR] INTEGER  NULL,
[BottomColorG] INTEGER  NULL,
[BottomColorB] INTEGER  NULL
);

CREATE TABLE [ObjectColor] (
[Id] INTEGER  PRIMARY KEY NOT NULL,
[ObjectId] BIGINT  NULL,
[Timestamp] BIGINT  NULL,
[ObjectPart] FLOAT  NULL,
[ColorH] SMALLINT  NULL,
[ColorS] SMALLINT  NULL,
[ColorV] SMALLINT  NULL
);

CREATE TABLE [ObjectKind] (
[Id] INTEGER  NOT NULL PRIMARY KEY,
[ObjectId] BIGINT  NULL,
[Kind] INTEGER  NULL,
[Count] INTEGER  NULL
);

CREATE TABLE [ObjectNote] (
[Id] BIGINT  NOT NULL PRIMARY KEY,
[ObjectId] BIGINT  NULL,
[PictureId] BIGINT  NULL,
[Text] VARCHAR(128)  NULL
);

CREATE TABLE [ObjectPath] (
[Id] INTEGER DEFAULT '0' NOT NULL PRIMARY KEY,
[ObjectId] BIGINT  NOT NULL,
[Pos0X] INTEGER  NULL,
[Pos0Y] INTEGER  NULL,
[Pos1X] INTEGER  NULL,
[Pos1Y] INTEGER  NULL,
[Timestamp] BIGINT  NULL,
[Direction] FLOAT  NULL,
[PathLen] INTEGER  NULL,
[Snapshot] TEXT DEFAULT 'NULL' NULL,
[SnapshotLen] INTEGER DEFAULT '0' NULL,
[ObjectX] INTEGER DEFAULT '0' NULL,
[ObjectY] INTEGER DEFAULT '0' NULL,
[ObjectW] INTEGER DEFAULT '0' NULL,
[ObjectH] INTEGER DEFAULT '0' NULL,
[SnapshotId] BIGINT  NULL
);

CREATE TABLE [ObjectSnapshot] (
[Id] BIGINT  NULL PRIMARY KEY,
[PosX] INTEGER  NULL,
[PosY] INTEGER  NULL,
[SizeX] INTEGER  NULL,
[SizeY] INTEGER  NULL,
[ObjectPosX] INTEGER  NULL,
[ObjectPosY] INTEGER  NULL,
[ObjectSizeX] INTEGER  NULL,
[ObjectSizeY] INTEGER  NULL,
[ObjectId] BIGINT  NULL,
[Timestamp] BIGINT  NULL,
[PictureLen] INTEGER  NULL,
[Picture] TEXT  NULL
);

CREATE TABLE [Param] (
[Id] INTEGER  NOT NULL PRIMARY KEY,
[Name] VARCHAR(128)  NOT NULL,
[Value] VARCHAR(128)  NULL
);

CREATE TABLE [SummaryObject] (
[Id] bigint  PRIMARY KEY NOT NULL,
[SnapshotId] BIGINT  NULL,
[BeginTime] BIGINT DEFAULT '0' NULL,
[EndTime] BIGINT DEFAULT '0' NULL,
[BackgroundId] BIGINT  NULL,
[PictureCount] INTEGER  NULL,
[MaxSizeX] INTEGER DEFAULT '0' NOT NULL,
[MaxSizeY] INTEGER DEFAULT '0' NULL,
[MaxSize] INTEGER DEFAULT '0' NULL,
[MaxSizeLen] INTEGER DEFAULT '0' NULL
);

CREATE TABLE [SummaryPicture] (
[Id] BIGINT  PRIMARY KEY NOT NULL,
[ObjectId] BIGINT DEFAULT '0' NULL,
[Timestamp] BIGINT  NULL,
[PosX] INTEGER DEFAULT '0' NULL,
[PosY] INTEGER DEFAULT '0' NULL,
[SizeX] INTEGER DEFAULT '0' NULL,
[SizeY] INTEGER DEFAULT '0' NULL,
[Picture] TEXT  NULL,
[BackgroundId] BIGINT  NULL,
[IdInObject] INTEGER  NULL,
[PicMask] TEXT  NULL
);

CREATE INDEX [IDX_BACKGROUNDPICTURE_ID] ON [BackgroundPicture](
[Id]  ASC
);

CREATE INDEX [IDX_OBJECTCOLOR_COLORV] ON [ObjectColor](
[ColorV]  ASC
);

CREATE INDEX [IDX_OBJECTCOLOR_COLORS] ON [ObjectColor](
[ColorS]  ASC
);

CREATE INDEX [IDX_OBJECTCOLOR_COLORH] ON [ObjectColor](
[ColorH]  ASC
);

CREATE INDEX [IDX_OBJECTCOLOR_OBJECTID] ON [ObjectColor](
[ObjectId]  ASC
);

CREATE INDEX [IDX_OBJECTKIND_KIND] ON [ObjectKind](
[Kind]  ASC
);

CREATE INDEX [IDX_OBJECTKIND_OBJECTID] ON [ObjectKind](
[ObjectId]  ASC
);

CREATE INDEX [IDX_OBJECTNOTE_PICTUREID] ON [ObjectNote](
[PictureId]  ASC
);

CREATE INDEX [IDX_OBJECTNOTE_OBJECTID] ON [ObjectNote](
[ObjectId]  ASC
);

CREATE INDEX [IDX_OBJECTPATH_OBJECTW] ON [ObjectPath](
[ObjectW]  DESC
);

CREATE INDEX [IDX_OBJECTPATH_POS1Y] ON [ObjectPath](
[Pos1Y]  ASC
);

CREATE INDEX [IDX_OBJECTPATH_POS1X] ON [ObjectPath](
[Pos1X]  ASC
);

CREATE INDEX [IDX_OBJECTPATH_POS0Y] ON [ObjectPath](
[Pos0Y]  ASC
);

CREATE INDEX [IDX_OBJECTPATH_POS0X] ON [ObjectPath](
[Pos0X]  ASC
);

CREATE INDEX [IDX_OBJECTPATH_OBJECTID] ON [ObjectPath](
[ObjectId]  ASC
);

CREATE INDEX [IDX_OBJECTSNAPSHOT_TIMESTAMP] ON [ObjectSnapshot](
[Timestamp]  ASC
);

CREATE INDEX [IDX_OBJECTSNAPSHOT_OBJECTID] ON [ObjectSnapshot](
[ObjectId]  ASC
);

CREATE INDEX [IDX_OBJECTSNAPSHOT_OBJECTSIZEY] ON [ObjectSnapshot](
[ObjectSizeY]  ASC
);

CREATE INDEX [IDX_OBJECTSNAPSHOT_OBJECTSIZEX] ON [ObjectSnapshot](
[ObjectSizeX]  ASC
);

CREATE INDEX [IDX_OBJECTSNAPSHOT_OBJECTPOSY] ON [ObjectSnapshot](
[ObjectPosY]  ASC
);

CREATE INDEX [IDX_OBJECTSNAPSHOT_OBJECTPOSX] ON [ObjectSnapshot](
[ObjectPosX]  ASC
);

CREATE INDEX [IDX_SUMMARYOBJECT_ENDTIME] ON [SummaryObject](
[EndTime]  ASC
);

CREATE INDEX [IDX_SUMMARYOBJECT_BEGINTIME] ON [SummaryObject](
[BeginTime]  ASC
);

CREATE INDEX [IDX_SUMMARYOBJECT_BACKGROUNDID] ON [SummaryObject](
[BackgroundId]  ASC
);

CREATE INDEX [IDX_SUMMARYOBJECT_MaxSizeLen] ON [SummaryObject](
[MaxSizeLen]  DESC
);

CREATE INDEX [IDX_SUMMARYOBJECT_ID] ON [SummaryObject](
[Id]  ASC
);

CREATE INDEX [IDX_SUMMARYPICTURE_IdInObject] ON [SummaryPicture](
[IdInObject]  ASC
);

CREATE INDEX [IDX_SUMMARYPICTURE_SizeY] ON [SummaryPicture](
[SizeY]  ASC
);

CREATE INDEX [IDX_SUMMARYPICTURE_SizeX] ON [SummaryPicture](
[SizeX]  ASC
);

CREATE INDEX [IDX_SUMMARYPICTURE_ObjectId] ON [SummaryPicture](
[ObjectId]  ASC
);

