#ifndef _I2C_SOFT_
 #define _I2C_SOFT_

#ifdef __cplusplus
  extern "C" {
#endif

#include "stm32f0xx_hal.h"

typedef struct
{
	   unsigned long sda_port;
	   unsigned long scl_port;
	   unsigned char sda_pin;
	   unsigned char scl_pin;
}Soft_I2C_Typedef;

char Soft_I2C_BspInit(	unsigned long sda_port,unsigned char sda_pin,//SDA
                        unsigned long scl_port,unsigned char scl_pin,//SCL
												Soft_I2C_Typedef *iic);

void Soft_I2C_Delay(void);											
void GPIO_Setting_Set(GPIO_TypeDef* GPIOx, uint16_t GPIO_Pin);
void GPIO_Setting_Cls(GPIO_TypeDef* GPIOx, uint16_t GPIO_Pin);
void Soft_I2C_Delayxd(void);
void Soft_I2C_Start(Soft_I2C_Typedef *iic);
void Wireless_Soft_I2C_Start(Soft_I2C_Typedef *iic);
void Soft_I2C_Stop(Soft_I2C_Typedef *iic);
unsigned char Soft_I2C_Write(Soft_I2C_Typedef *iic,unsigned char wb);
unsigned char Soft_I2C_Read(Soft_I2C_Typedef *iic,unsigned char bEnd);
unsigned char Soft_I2C_ReadSlaver(Soft_I2C_Typedef *iic,unsigned char sbEnd);

#ifdef __cplusplus
}
#endif

#endif
