﻿#include "jmdos.h"
#include "jmkernel.h"

//---------------------------------------------
#ifdef _RELEASEBUTTON_
 #ifndef  _RELEASEBUTTON_EXISTS_
  #define _RELEASEBUTTON_EXISTS_
//释放按键；在线调试用
void Releasebutton(uint8_t data)
{	
}
 #endif
#endif
//---------------------------------------------
#ifndef _VARIATE_
#define _VARIATE_
#include <jmkernel.h>
//循迹函数用的变量
uint32_t S1 = 0;
uint32_t S2 = 0;
uint32_t S3 = 0;
uint32_t S4 = 0;
uint32_t S5 = 0;//记录四个光电
uint32_t G1 = 0;
uint32_t G2 = 0;
uint32_t G3 = 0;
uint32_t G4 = 0;
uint32_t G5 = 0;
uint32_t temp = 0;
uint32_t TT = 0;
uint32_t TT1 = 0;
uint32_t ZZ = 0;
uint32_t T15 = 0;
uint32_t v00 = 0;
#endif
//---------------------------------------------
//Cabin手柄键值
#ifdef _GETBLUETOOTHCONTROLDATA_
 #ifndef  _GETBLUETOOTHCONTROLDATA_EXISTS_
 #define _GETBLUETOOTHCONTROLDATA_EXISTS_
 #include <jmkernel.h>

uint8_t GetBluetoothControlData(void)
{
  USART1_init();
  uint8_t key;
  uint32_t PhoneKey;  
  PhoneKey = BluetoothPhoneControl();
  switch(PhoneKey)
  {
    case 0x02:  key=1;
    break;
    case 0x04:  key=2;
    break;
    case 0x08:  key=3;
    break;
    case 0x10:  key=4;
    break;
    case 0x20:  key=5;
    break;
    case 0x40:  key=6;
    break;
    case 0x80:  key=7;
    break;
    case 0x100: key=8;
    break;
    default :   key=0;
    break;
  }
  return key;
}
 #endif
#endif
//---------------------------------------------
//Cabin手柄键码
#ifdef _GETBLUETOOTHCONTROL_
 #ifndef  _GETBLUETOOTHCONTROL_EXISTS_
 #define _GETBLUETOOTHCONTROL_EXISTS_
 #include <jmkernel.h>

uint32_t GetBluetoothControl(void)
{
	USART1_init();
	return BluetoothPhoneControl();	
}
 #endif
#endif

//---------------------------------------------
//接收RCU蓝牙数据
#ifdef _GETBLUETOOTHDATA_
 #ifndef  _GETBLUETOOTHDATA_EXISTS_
  #define _GETBLUETOOTHDATA_EXISTS_
 #include <jmkernel.h>

uint8_t GetBluetoothData(void)
{
	USART1_init();
	return BluetoothReceiveData();	
}
 #endif
#endif

//---------------------------------------------
//发送蓝牙数据
#ifdef _SETBLUETOOTHDATA_
 #ifndef  _SETBLUETOOTHDATA_EXISTS_
  #define _SETBLUETOOTHDATA_EXISTS_
 #include <jmkernel.h>

void SetBluetoothData(uint8_t data)
{
	USART1_init();
	BluetoothSendData(data);	
}
 #endif
#endif
//---------------------------------------------

#ifdef _SETWAITFORTIME_
 #ifndef  _SETWAITFORTIME_EXISTS_
  #define _SETWAITFORTIME_EXISTS_
 #include <jmkernel.h>

void SetWaitForTime(float a)
{
	osDelay(a*800);
	functionsfinish();
}

 #endif
#endif
//---------------------------------------------

#ifdef   _GETLEFTBUTTON_
#ifndef  _GETLEFTBUTTON_EXISTS_
#define _GETLEFTBUTTON_EXISTS_
 #include <jmkernel.h>

//Scratch2-JMD 左键
uint8_t GetLeftButton(void)
{
	return key2;
	functionsfinish();
}
#endif
#endif
//---------------------------------------------

#ifdef   _GETRIGHTBUTTON_
#ifndef  _GETRIGHTBUTTON_EXISTS_
#define _GETRIGHTBUTTON_EXISTS_
 #include <jmkernel.h>

//Scratch2-JMD 右键
uint8_t GetRightButton(void)
{
	return key1;
	functionsfinish();
}
 #endif
#endif
//---------------------------------------------

#ifdef _SET3CLED_
 #ifndef  _SET3CLED_EXISTS_
  #define _SET3CLED_EXISTS_
 #include <jmkernel.h>

uint32_t LED_RED=0x00FF0001;//红色
uint32_t LED_GREEN=0xFF000002;//绿色
uint32_t LED_BLUE=0x0000FF03;//蓝色
uint32_t LED_YELLOW=0xFFFF0004;//黄色
uint32_t LED_VIOLET=0x00FFFF05;//紫色
uint32_t LED_BLUENESS=0xFF00FF06;//青色
uint32_t LED_WHITE=0xFFFFFF07;//白色
uint32_t L=0x000000FF;//亮度
uint32_t COLOR[5];//存储5个RGB灯目前的颜色
uint8_t COLORflag=0;//颜色改变启动标志位
uint8_t NOWwhich=0;//需要改变的RGB位号
uint16_t NOWColor=0;//改变后的颜色
//改变5个RGB灯中其中一位的颜色
void Set3CLed(uint8_t which,uint16_t Color)
{
	uint8_t i;
	if(NOWwhich!=which||NOWColor!=Color)
	{//颜色发生改变
	NOWwhich=which;
	NOWColor=Color;
	if(COLORflag==0){
		for(i=0;i<5;i++)COLOR[i]=0;
		COLORflag=1;//RGB颜色清零，
	}
	if(Color==1){COLOR[which-1]=LED_RED;}
	else if(Color==2){COLOR[which-1]=LED_GREEN;}
	else if(Color==3){COLOR[which-1]=LED_BLUE;}
	else if(Color==4){COLOR[which-1]=LED_YELLOW;}
	else if(Color==5){COLOR[which-1]=LED_VIOLET;}
	else if(Color==6){COLOR[which-1]=LED_BLUENESS;}
	else if(Color==7){COLOR[which-1]=LED_WHITE;}
	else if(Color==0){COLOR[which-1]=0;}
	Send_IC_Code_Reset();//关中断
	__disable_irq();
	Send_LEDData_32Bits(COLOR[0]);
	Send_LEDData_32Bits(COLOR[1]);
	Send_LEDData_32Bits(COLOR[2]);
	Send_LEDData_32Bits(COLOR[3]);
	Send_LEDData_32Bits(COLOR[4]);
	__enable_irq();
	}
	functionsfinish();
}
 #endif
#endif
//---------------------------------------------

#ifdef _SETRGB_
#ifndef  _SETRGB_EXISTS_
#define _SETRGB_EXISTS_
#include <jmkernel.h>
//设置5个RGB灯的颜色；输入RGB值
void SetRGB(uint32_t RGB1,uint32_t RGB2,uint32_t RGB3,uint32_t RGB4,uint32_t RGB5)
{
	uint32_t R,G,B;
	uint32_t COLOR1,COLOR2,COLOR3,COLOR4,COLOR5;
	B=RGB1&0xFF;G=RGB1&0xFF00;R=RGB1&0xFF0000;
	COLOR1=(G*0x10000)+R+(B*0x100);
	B=RGB2&0xFF;G=RGB2&0xFF00;R=RGB2&0xFF0000;
	COLOR2=(G*0x10000)+R+(B*0x100);
	B=RGB3&0xFF;G=RGB3&0xFF00;R=RGB3&0xFF0000;
	COLOR3=(G*0x10000)+R+(B*0x100);
	B=RGB4&0xFF;G=RGB4&0xFF00;R=RGB4&0xFF0000;
	COLOR4=(G*0x10000)+R+(B*0x100);
	B=RGB5&0xFF;G=RGB5&0xFF00;R=RGB5&0xFF0000;
	COLOR5=(G*0x10000)+R+(B*0x100);
	Send_IC_Code_Reset();
	__disable_irq();
	Send_LEDData_32Bits(COLOR1);
	Send_LEDData_32Bits(COLOR2);
	Send_LEDData_32Bits(COLOR3);
	Send_LEDData_32Bits(COLOR4);
	Send_LEDData_32Bits(COLOR5);
	__enable_irq();
	functionsfinish();
}
 #endif
#endif
//---------------------------------------------
//调节输出马达功率
#ifdef _SETMOTORPOWER_
 #ifndef  _SETMOTORPOWER_EXISTS_
 #define _SETMOTORPOWER_EXISTS_
 #include <jmkernel.h>
extern int g_MotorPowerFlag;
extern int g_M1SpeedPer;
extern int g_M2SpeedPer;

void SetMotorPower(int m_Per1,int m_Per2)
{
	g_MotorPowerFlag=1;
	g_M1SpeedPer=m_Per1;//M1
	g_M2SpeedPer=m_Per2;//M2
}
 #endif
#endif
//---------------------------------------------
//Scratch2-JMD 设置马达速度
#ifdef _SETMOTOR_
 #ifndef  _SETMOTOR_EXISTS_
 #define _SETMOTOR_EXISTS_
 #include <jmkernel.h>
extern int g_MotorPowerFlag;
extern int g_M1SpeedPer;
extern int g_M2SpeedPer;

void SetMotor(uint8_t which,int speed)
{
	uint8_t m_speedper;
	if(g_MotorPowerFlag)//读取马达功率
	{
		switch(which)
		{
			case 1:m_speedper=g_M1SpeedPer;break;
			case 2:m_speedper=g_M2SpeedPer;break;
		}
	}
	if(g_MotorPowerFlag)speed=m_speedper*speed/100;
	PWM_init();//开启马达PWN
	Setmotorspeed(which,speed);
	functionsfinish();
}
 #endif
#endif
//---------------------------------------------------

#ifdef _SETLIGHTSENSORLED_
 #ifndef  _SETLIGHTSENSORLED_EXISTS_
  #define _SETLIGHTSENSORLED_EXISTS_
 #include <jmkernel.h>

//Scratch2-JMD 开关顶部8个led灯
void SetLightSensorLed(uint8_t which,uint8_t ONOFF)
{
	onoff8LED(which,ONOFF);
	functionsfinish();
}
 #endif
#endif

//--------------------------------------------------
//红外遥控
#ifdef _GETIRCODE_
 #ifndef  _GETIRCODE_EXISTS_
  #define _GETIRCODE_EXISTS_
 #include <jmkernel.h>

extern uint32_t IRcode;
extern uint32_t IRcodelast;
extern uint32_t ICcont;
extern uint32_t infraredtime;
uint32_t q=0;

uint8_t GetIRCode(uint8_t which)
{
	IR_init();
	uint32_t n;
	uint32_t i=0,rn=0,tmp=0;
	for(q=0;q<8;q++)
	{
	if(ICcont>=32)
	{
	n=IRcode;
	for(i=0;i<32;i++)
	{
		rn<<=1;
		rn+=(n&0x01);
		n>>=1;	
	}
	}
	}
	infraredtime++;
	if(infraredtime>10)
	{
		IRcode=0;
		IRcodelast=0;		
	}
	HAL_Delay(20);
	return (rn/0x10000)%0x100;
}
 #endif
#endif
//--------------------------------------------------

#ifdef _SETINBEEP_
 #ifndef  _SETINBEEP_EXISTS_
  #define _SETINBEEP_EXISTS_
 #include <jmkernel.h>

//Scratch2-JMD 蜂鸣器鸣叫
void SetInBeep(uint8_t state)
{
	USART1_init();
	Beep(state);
	functionsfinish();
}
 #endif
#endif
//--------------------------------------------------

#ifdef _SETINSOUND_
 #ifndef  _SETINSOUND_EXISTS_
  #define _SETINSOUND_EXISTS_
 #include <jmkernel.h>

//Scratch2-JMD 蜂鸣器音乐
void SetInSound(uint16_t BeepHz,uint16_t time)
{
	USART1_init();
	BeepMusic(BeepHz);	
	osDelay(time*10/14);
	Beep(OFF);
	functionsfinish();
}
 #endif
#endif
//--------------------------------------------------

#ifdef _SETMUSIC_
 #ifndef  _SETMUSIC_EXISTS_
  #define _SETMUSIC_EXISTS_
 #include <jmkernel.h>

//播放音乐葫芦娃
int tune[] =		
{
	TONE_DH1,TONE_D6,TONE_D5,TONE_D6,TONE_0,  TONE_DH1,TONE_D6, TONE_D5, TONE_DH1,TONE_D6, TONE_0, TONE_D6,
	TONE_D6, TONE_D6,TONE_D5,TONE_D6,TONE_0,  TONE_D6, TONE_DH1,TONE_D6, TONE_D5, TONE_DH1,TONE_D6,TONE_0, 
	TONE_D1, TONE_D1,TONE_D3,TONE_D1,TONE_D1, TONE_D3, TONE_0,  TONE_D6, TONE_D6, TONE_D6, TONE_D5,TONE_D6,
	TONE_D5, TONE_D1,TONE_D3,TONE_0, TONE_DH1,TONE_D6, TONE_D6, TONE_D5, TONE_D6, TONE_D5, TONE_D1,TONE_D2,
	TONE_0,  TONE_D7,TONE_D7,TONE_D5,TONE_D3, TONE_D5, TONE_DH1,TONE_0,  TONE_D6, TONE_D6, TONE_D5,TONE_D5,
	TONE_D6, TONE_D6,TONE_0, TONE_D5,TONE_D1, TONE_D3, TONE_0,  TONE_DH1,TONE_0,  TONE_D6, TONE_D6,TONE_D5,
	TONE_D5, TONE_D6,TONE_D6,TONE_0, TONE_D5, TONE_D1, TONE_D2, TONE_0,  TONE_D3, TONE_D3, TONE_D1,TONE_DL6,
	TONE_D1, TONE_D3,TONE_D5,TONE_D6,TONE_D6, TONE_D3, TONE_D5, TONE_D6, TONE_D6, TONE_DH1,TONE_0, TONE_D7, 
	TONE_D5, TONE_D6
};//这部分就是整首曲子的音符部分
float duration[] =
{
	1,1,0.5,0.5,1,0.5,0.5,0.5,0.5,1,0.5,0.5,
	0.5,1,0.5,1,0.5,0.5,0.5,0.5,0.5,0.5,1,1,  
	1,1,1+1,0.5,1,1+0.5,1,1,1,0.5,0.5,1,
	0.5,1,1+0.5,1,0.5,0.5,0.5,0.5,1+1,
	0.5,1,1+0.5,1,1+1,0.5,0.5,1,1+1+1+1,
	0.5,0.5,0.5+0.25,0.25,0.5+0.25,0.25,0.5+0.25,0.25,
	0.5,1,0.5,1,1,
	0.5,0.5,0.5+0.25,0.25,0.5+0.25,0.25,0.5+0.25,0.25,
	0.5,1,0.5,1,1,1+1,0.5,0.5,1,1+1+1+1,
	0.5,1,0.5,1+1,0.5,1,0.5,1+1,1+1,0.5,0.5,1,
	1+1+1+1
};//这部分是整首曲子的节拍部分
int length,x;//这里定义一个变量，后面用来表示共有多少个音符

void setMusic(void)
{
	length = sizeof(tune)/sizeof(tune[0]);//这里用sizeof，可以查出tone序列里有多少个音符
	for(x=0; x<length; x++)//循环音符的次数
	{
		BeepMusic(tune[x]);//此函数依次播放tune序列里的数组，即每个音符
		osDelay(400*duration[x]);//每个音符持续的时间，即节拍duration，400是调整时间的越大，曲子速度越慢，越小曲子速度越快，自己掌握吧
	}
	Beep(OFF);
	functionsfinish();
}
 #endif
#endif
//--------------------------------------------------
#ifdef _GETBLUETOOTHCONTROLDATA_
 #ifndef  _GETBLUETOOTHCONTROLDATA_EXISTS_
  #define _GETBLUETOOTHCONTROLDATA_EXISTS_
 #include <jmkernel.h>

//Scratch2-JMD Cabin手柄
uint8_t GetBluetoothControlData(void)
{
  uint8_t key;
  uint32_t PhoneKey;  
  PhoneKey = BluetoothPhoneControl();
  switch(PhoneKey)
  {
    case 0x02:  key=1;
    break;
    case 0x04:  key=2;
    break;
    case 0x08:  key=3;
    break;
    case 0x10:  key=4;
    break;
    case 0x20:  key=5;
    break;
    case 0x40:  key=6;
    break;
    case 0x80:  key=7;
    break;
    case 0x100: key=8;
    break;
    default :   key=0;
    break;
  }
  return key;
}
 #endif
#endif

//-------------------------------------------------------

#ifdef _SETMOTORSERVO_
 #ifndef  _SETMOTORSERVO_EXISTS_
  #define _SETMOTORSERVO_EXISTS_
 #include <jmkernel.h>

void SetMotorServo(uint8_t which,uint8_t angle)
{
	USART1_init();
	Servo(which,angle);
	functionsfinish();
}
 #endif
#endif
//----------------------------------------------------------

#ifdef _GETLIGHTSENSOR_
#ifndef  _GETLIGHTSENSOR_EXISTS_
#define _GETLIGHTSENSOR_EXISTS_
#include <jmkernel.h>

//Scratch2-JMD 读传感器数据，返回ADC值
uint16_t GetLightSensor(uint8_t which)
{
	functionsfinish();
	return readADC(which);//返回ADC值
}
 #endif
#endif
//----------------------------------------------------------

#ifdef _GETLIGHTSENSORDATA_
#ifndef  _GETLIGHTSENSORDATA_EXISTS_
#define _GETLIGHTSENSORDATA_EXISTS_
#include <jmkernel.h>
 
uint16_t GetLightSensorData(uint8_t which)
{	//读传感器数据，返回判断值
    functionsfinish();	
	if(readADC(which)>ReadEEP(100+which)) return 0;
	else return 1;
}
 #endif
#endif
//----------------------------------------------------------

#ifdef   _GETINMIC_
#ifndef  _GETINMIC_EXISTS_
#define _GETINMIC_EXISTS_
#include <jmkernel.h>

//Scratch2-JMD 麦
uint16_t GetInMic(void)
{
	return ReadMIC();
	functionsfinish();
}
#endif
#endif
//----------------------------------------------------------

#ifdef _GETTOUCH_
 #ifndef  _GETTOUCH_EXISTS_
  #define _GETTOUCH_EXISTS_
 #include <jmkernel.h>

uint16_t GetTouch(uint8_t which)
{
	functionsfinish();
	if(readADC(which)==0){return 1;}
	else return 0;
}
 #endif
#endif
//----------------------------------------------------------

#ifdef _SETSYSTIME_
 #ifndef  _SETSYSTIME_EXISTS_
  #define _SETSYSTIME_EXISTS_
 #include <jmkernel.h>

//Scratch2-JMD 置零系统时间
void SetSysTime(void)
{
	SetSystemTime();
	functionsfinish();
}
 #endif
#endif

//----------------------------------------------------------

#ifdef _GETSYSTIME_
 #ifndef  _GETSYSTIME_EXISTS_
  #define _GETSYSTIME_EXISTS_
 #include <jmkernel.h>

//Scratch2-JMD 获取系统时间
uint32_t GetSysTime(void)
{
	functionsfinish();
	return GetSystemTime();
}
 #endif
#endif

//----------------------------------------------------------

#ifdef _GETIRDIST_
 #ifndef  _GETIRDIST_EXISTS_
  #define _GETIRDIST_EXISTS_
 #include <jmkernel.h>
#define _IRULTRASOUND_ADDR_		0X06

//Scratch2-JMD 红外测距模块
#define _IRULTRASOUND_ADDR_		0X06
uint16_t GetIRDist(uint8_t which)
{
	uint32_t port1=0,port2=0;
	uint8_t bit1=0,bit2=0;
	uint8_t	datah=0,datal=0,cmd=0,s=0,SUM=0,i,j,t;	
	uint16_t data,irdata[30]={0};
	
	if(which==1){
		port1=GPIOB;port2=GPIOB;
		bit1=14;bit2=13;
	}
	else if(which==2){
		port1=GPIOB;port2=GPIOB;
		bit1=7;bit2=6;	
	}
	Soft_I2C_Typedef iic_typedef;
	Soft_I2C_BspInit(port2,bit2,//SDA
				   port1,bit1,//SCL
				&iic_typedef);//设置引脚
	for(i=0;i<20;i++){//为防止数据跳动，循环20次得到一次结果
	Soft_I2C_Start(&iic_typedef);//启动i2c
	Soft_I2C_Write(&iic_typedef,_IRULTRASOUND_ADDR_);//写入一个字节数据	
	Soft_I2C_Write(&iic_typedef,0xaa);//写入一个字节数据
	Soft_I2C_Stop(&iic_typedef);//停止i2c
	Soft_I2C_Start(&iic_typedef);//启动i2c
	Soft_I2C_Write(&iic_typedef,_IRULTRASOUND_ADDR_+1);//写入编号＋1
	cmd=Soft_I2C_Read(&iic_typedef,0);	//数据开头
	datah=Soft_I2C_Read(&iic_typedef,0);	//数据高八位
	datal=Soft_I2C_Read(&iic_typedef,0);	//第八位
	s=Soft_I2C_Read(&iic_typedef,1);		//检验和，停止收数据
	Soft_I2C_Stop(&iic_typedef);//关闭i2c
	
	SUM=(uint8_t)(cmd+datah+datal);//校验
	irdata[i]=(uint16_t)(((uint16_t)datah<<8)|datal);
	}
	for(j=0;j<19;j++){//排序
		for(i=0;i<19-j;i++){
			if(irdata[i]>irdata[i+1]){
				t=irdata[i];
				irdata[i]=irdata[i+1];
				irdata[i+1]=t;
			}
		}
	}
	if(SUM!=s){//错误数据
		data=999;
	}
	else{
		functionsfinish();
		return	irdata[10];//取中位数	
	}
}
 #endif
#endif
//----------------------------------------------------------

#ifdef _SETDATA_
 #ifndef  _SETDATA_EXISTS_
  #define _SETDATA_EXISTS_
 #include <jmkernel.h>

//Scratch2-JMD 写eeprom
void SetData(int dataadr,int datacode)
{
	WriteEEP(dataadr,datacode);
	functionsfinish();
}
 #endif
#endif
//----------------------------------------------------------

#ifdef _GETDATA_
 #ifndef  _GETDATA_EXISTS_
  #define _GETDATA_EXISTS_
 #include <jmkernel.h>

//Scratch2-JMD 读eeprom
uint16_t GetData(int dataadr)
{
	ReadEEP(dataadr); 
	functionsfinish();
}
 #endif
#endif
//----------------------------------------------------------
#ifdef _GETULTRASOUND_
 #ifndef  _GETULTRASOUND_EXISTS_
  #define _GETULTRASOUND_EXISTS_
 #include <jmkernel.h>
#define _ULTRASOUND_ADDR_		0X04
uint16_t GetUltrasound(uint8_t which)
{//超声波
	uint32_t port1;
	uint32_t port2;
	uint8_t bit1;
	uint8_t bit2;

	uint16_t data;
	uint8_t	datah=0,datal=0,cmd=0,s=0,SUM=0;

	if(which==1)
	{
		port1=GPIOB;
		port2=GPIOB;
		bit1=14;
		bit2=13;
	}
	else if(which==2)
	{
		port1=GPIOB;
		port2=GPIOB;
		bit1=7;
		bit2=6;	
	}
	Soft_I2C_Typedef iic_typedef;
	Soft_I2C_BspInit(port2,bit2,//SDA
				   port1,bit1,//SCL
									   &iic_typedef);//设置引脚

	Soft_I2C_Start(&iic_typedef);//启动i2c
	Soft_I2C_Write(&iic_typedef,_ULTRASOUND_ADDR_);//写入一个字节数据
	
	Soft_I2C_Write(&iic_typedef,0xaa);//写入一个字节数据
	Soft_I2C_Stop(&iic_typedef);//停止i2c
	
	Soft_I2C_Start(&iic_typedef);//启动i2c
	Soft_I2C_Write(&iic_typedef,_ULTRASOUND_ADDR_+1);//写入编号＋1
	cmd=Soft_I2C_Read(&iic_typedef,0);	//数据开头
	datah=Soft_I2C_Read(&iic_typedef,0);	//数据高八位
	datal=Soft_I2C_Read(&iic_typedef,0);	//第八位
	s=Soft_I2C_Read(&iic_typedef,1);		//检验和，停止收数据
	Soft_I2C_Stop(&iic_typedef);//关闭i2c
	
	//OS_EXIT_CRITICAL();
	SUM=(uint8_t)(cmd+datah+datal);//校验
	if(SUM!=s)//错误数据
	{
		data=999;
	}
	else
	{
		return data=(uint16_t)(((uint16_t)datah<<8)|datal);	
	}
	functionsfinish();
}

 #endif
#endif