//***************************(C) COPYRIGHT 2015 CZQ******************************
//*******************************************************************************
// File Name   	: jmdmp3lib.h
// Version		  : V0.0
// Compiler		  : GCCARM
// Target		    : E3RCU (STM32F103VET6)
// Author		    : CZQ
// Date			    : 2015/12/11
// Description  : MP3
//*******************************************************************************
//
//*******************************************************************************
/*****************************************************************************
MP3:ϵʼʱ<=500ms,ʵԼ300ms
ĿӦٶԼ50ms
оƬڲԴڵĴ 10MS һΣָʱҪ 20MS ʱ
ǰָᱻǶòִ
******************************************************************************/
#ifndef _JMDMP3LIB_H_
#define _JMDMP3LIB_H_

#define _MP3LIB_EXT_H_
//#include "hw_config.h"

#define _MP3_PWR_ON_TIME_	500	//ms

typedef enum
{
	USB_DISK_ON=0,
	USB_MP3_OFF=0,
	USB_MP3_ON=1,
	
	MP3_SW_OFF=0,
	MP3_SW_ON=1,
	
	MP3_STOP=0,//ֹͣ
	MP3_PLAY=1,//
	MP3_SUSPEND=2,//ͣ
	MP3_NXT=3,//һ
	MP3_FWD=4,//һ
	MP3_PLAYSONG=5//ָƵ
}USB_SW_STATE;
#define EEP_MP3_SOUND 		192//MP3 :0-30
#define EEP_MP3_PWR   		191//MP3Դ
#define USB_SW_GPIO  			GPIOE
#define USB_SW_PIN   			GPIO_Pin_15
#define MP3_PWR_GPIO 			GPIOA
#define MP3_PWR_PIN  			GPIO_Pin_13
#define MP3_STATE_GPIO 		GPIOE
#define MP3_STATE_PIN  		GPIO_Pin_14
#define GET_MP3_STATE() 	GPIO_ReadInputDataBit(MP3_STATE_GPIO,MP3_STATE_PIN)
typedef enum
{//MP3ݰʽ:0X7E+0XFF(ֽ)+0x06()+CMD+FB+D0+D1+2ByteУ+0XEF
 //:ͷβУ
 //=0-(0XFF(ֽ)+0x06()+CMD+FB+D0+D1)
 //CMD:ָ
 //FB:Ϣ,1,0
	MP3_FIRST_BYTE=0X7E,//ݰͷ
	MP3_END_BYTE=0XEF,//ݰδ
	//ָ
	MP3_PNXT_SCMD=0X01,//һ
	MP3_PFWD_SCMD=0X02,//һ
	MP3_PSONG_SCMD=0X03,//ָĿ(NUM)
	MP3_SOUNDP_SCMD=0X04,//+
	MP3_SOUNDN_SCMD=0X05,//-
	MP3_SOUND_SCMD=0X06,//ָ0-30
	MP3_SCSTP_SCMD=0X08,//ѭָĿ
	MP3_SPD_SCMD=0X09,//ָ豸
	MP3_SLEEP_SCMD=0X0A,//˯ -- ͹
	MP3_WAKE_SCMD=0X0B,//˯
	MP3_RST_SCMD=0X0C,//оƬλ
	MP3_PLAY_SCMD=0X0D,//
	MP3_SUSPEND_SCMD=0X0E,//ͣ
	MP3_PFNSF_SCMD=0X0F,//ָļļ
	MP3_PADVERT_SCMD=0X13,//岥
	MP3_SADVERT_SCMD=0X15,//ֹͣ岥ű
	MP3_STOP_SCMD=0X16,//ֹͣ岥ű
	MP3_PFLOOP_SCMD=0X17,//ָļѭ
	MP3_PRRAND_SCMD=0X18,//ָĿ¼
	MP3_PSSLOOP_SCMD=0X19,//ԵǰŵĿΪѭ
	MP3_DACOUT_SCMD=0X1A,//͹رоƬ DAC 
	MP3_COMBP_SCMD=0X21,//ϲ
	MP3_SSSF_SCMD=0X22,//ָͬʱָļ
	MP3_PMF_SCMD=0X25,//ļв岥
	//ѯָ
	MP3_ONLINE_CCMD=0X3F,//ѯ豸
	MP3_CURSTATE_CCMD=0X42,//ѯǰ״̬
	MP3_CURSOUND_CCMD=0X43,//ѯǰ
	MP3_CTFILENUM_CCMD=0X49,//ѯ FLASH ļ,5ļеļ
	MP3_CFSPOINT_CCMD=0X4D,//FLASHǰļĿָ
	MP3_FTNUM_CCMD=0X4E,//ѯָļеĿ
	MP3_FOLDERNUM_CCMD=0X4F,//ѯǰ豸ļ
	MP3_CFILEPOINT_CCMD=0X61,//ѯǰļָ
}MP3_ENUM_DEFINED;

#define MP3RX_MAX		    64
#define MP3SOUND_MAX	  28//30

#ifndef _MP3LIB_EXT_H_
extern u8 Mp3RXBuffer[MP3RX_MAX],Mp3RxNew,Mp3PowerState,Mp3Sound,Mp3Online,MP3DiskState;
extern u16 Mp3RxLen,Mp3NumSize,Mp3NumCnt;
extern u32 MP3SetCmdTime;
extern u8 MP3Version;
#else
//#ifdef _MP3LIB_EXT_H_
//#define _MP3LIB_EXT_H_
u8 Mp3RXBuffer[MP3RX_MAX],Mp3RxNew=0,Mp3PowerState=0,Mp3Sound=MP3SOUND_MAX,Mp3Online=0XFF;
u16 Mp3RxLen=0,Mp3NumSize=0,Mp3NumCnt=0;
u32 MP3SetCmdTime=0;//MP3ʱ
u8 MP3Version=0;//MP3汾
u8 MP3DiskState=0;//MP3Ṵ汾
void ClearMP3Buffer(void)
{
	u16 i;
	Mp3RxLen=0;
	Mp3RxNew=0;
	for(i=0;i<MP3RX_MAX;i++)Mp3RXBuffer[i]=0;
}
void MP3_DELAY(u32 time){Delay1ms(time);}
u8 MP3_SetSetCmdTime(void){MP3SetCmdTime=GetSystemTime()+30;}//2ηָֻ20msʱ
u8 MP3_GetSetCmdTime(void)
{
	while(MP3SetCmdTime>GetSystemTime());//ʱȴ
	MP3_SetSetCmdTime();
	return 0;
}
u8 Usb_SwitchInit(void)
{
  GPIO_InitTypeDef GPIO_InitStructure;
  RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOE, ENABLE);
	//USBл
	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP;
  GPIO_InitStructure.GPIO_Pin = USB_SW_PIN;   
  GPIO_Init(USB_SW_GPIO, &GPIO_InitStructure);
	SetUsbSwitch(USB_MP3_ON);
}
u8 MP3_BspPinInitFlag=0;
u8 MP3_BspPinInit(void)
{
	if(MP3_BspPinInitFlag)return;MP3_BspPinInitFlag=1;
  GPIO_InitTypeDef GPIO_InitStructure;
	RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOE|RCC_APB2Periph_GPIOA|RCC_APB2Periph_AFIO, ENABLE);
	//ڸJTAGTDIҪرTDI
  //RCC_APB2PeriphClockCmd(RCC_APB2Periph_AFIO,ENABLE);//뿪ʱ
  GPIO_PinRemapConfig(GPIO_Remap_SWJ_Disable, ENABLE);//ȫʧܣJTAG+SW-DP
	//GPIO_PinRemapConfig(GPIO_Remap_SWJ_JTAGDisable, ENABLE);//ʹSWD JTAG 
	//Դ
	//GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
  //GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP;
	//GPIO_InitStructure.GPIO_Pin = MP3_PWR_PIN;
  //GPIO_Init(MP3_PWR_GPIO, &GPIO_InitStructure);
	//SetMP3PwrState(Mp3PowerState);
	//״̬ͬʱMP3汾
	GPIO_InitStructure.GPIO_Pin = MP3_STATE_PIN;  
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_IPD;//GPIO_Mode_IN_FLOATING;
  GPIO_Init(MP3_STATE_GPIO, &GPIO_InitStructure);
}
void SetUsbSwitch(u8 state)//USBл
{
	if(state){GPIO_SetBits(USB_SW_GPIO,USB_SW_PIN);}	
	else	    {GPIO_ResetBits(USB_SW_GPIO,USB_SW_PIN);}
}
void SetMP3PwrState(u8 state)//MP3Դ
{	
	if(state){GPIO_SetBits(MP3_PWR_GPIO,MP3_PWR_PIN);}
	else	{GPIO_ResetBits(MP3_PWR_GPIO,MP3_PWR_PIN);}	
}
u8 GetMP3State(void)
{
	return (GPIO_ReadInputDataBit(MP3_STATE_GPIO,MP3_STATE_PIN)>0?0:1);
}
//MP3Դ
/*u16 ReadMP3PowerEEP(void)
{
	return ReadEEP(EEP_MP3_PWR);
}
u16 SetMP3PowerEEP(u16 state)
{
	WriteEEP(EEP_MP3_PWR,state);
}//*/
//MP3
u16 ReadMP3SoundEEP(void)
{
	u16 sound;
	sound=ReadEEP(EEP_MP3_SOUND);
	if(sound>MP3SOUND_MAX)sound=MP3SOUND_MAX;
	return sound;
}
u16 SetMP3SoundEEP(u16 state)
{
	if(state>MP3SOUND_MAX)state=MP3SOUND_MAX;
	WriteEEP(EEP_MP3_SOUND,state);
}

u8 MP3_BspInitFlag=0;
u8 MP3_BspInit(void)
{
  GPIO_InitTypeDef GPIO_InitStructure;
  SysMP3ISRFunInit();//ȳʼжϺ
	if(MP3_BspInitFlag)return 0;MP3_BspInitFlag=1;
  RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOB|RCC_APB2Periph_GPIOE|RCC_APB2Periph_GPIOA|RCC_APB2Periph_AFIO, ENABLE);
  RCC_APB1PeriphClockCmd(RCC_APB1Periph_USART3, ENABLE);
	
  Mp3Sound=ReadMP3SoundEEP();//ȡMP3
	//ڸJTAGTDIҪرTDI
  //RCC_APB2PeriphClockCmd(RCC_APB2Periph_AFIO,ENABLE);//뿪ʱ
  GPIO_PinRemapConfig(GPIO_Remap_SWJ_Disable, ENABLE);//ȫʧܣJTAG+SW-DP
	//GPIO_PinRemapConfig(GPIO_Remap_SWJ_JTAGDisable, ENABLE);//ʹSWD JTAG 
	
	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP;

  //Usb_SwitchInit();
	//SetUsbSwitch(USB_MP3_OFF);
	//MP3_BspPinInit();
	//SetMP3PwrState(Mp3PowerState);
	
  //Configure USART3 Tx (PB.10) as alternate function push-pull //
  GPIO_InitStructure.GPIO_Pin = GPIO_Pin_10;
  //GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_AF_PP;
  GPIO_Init(GPIOB, &GPIO_InitStructure);

  // Configure USART3 Rx (PB.11) as input floating //
  GPIO_InitStructure.GPIO_Pin = GPIO_Pin_11;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_IN_FLOATING;
  GPIO_Init(GPIOB, &GPIO_InitStructure);

//ʼ
  USART_InitTypeDef USART_InitStructure;
  USART_InitStructure.USART_BaudRate = 9600;
  USART_InitStructure.USART_WordLength = USART_WordLength_8b;
  USART_InitStructure.USART_StopBits = USART_StopBits_1;
  USART_InitStructure.USART_Parity = USART_Parity_No ;
  USART_InitStructure.USART_HardwareFlowControl = USART_HardwareFlowControl_None;
  USART_InitStructure.USART_Mode = USART_Mode_Rx | USART_Mode_Tx;
  USART_Init(USART3, &USART_InitStructure);

  //NVIC_PriorityGroupConfig(NVIC_PriorityGroup_1);
	NVIC_InitTypeDef NVIC_InitStructure;
  NVIC_InitStructure.NVIC_IRQChannel = USART3_IRQn;
  NVIC_InitStructure.NVIC_IRQChannelPreemptionPriority =9;   //ռȼ0
  NVIC_InitStructure.NVIC_IRQChannelSubPriority = 0;
  NVIC_InitStructure.NVIC_IRQChannelCmd = ENABLE;
  NVIC_Init(&NVIC_InitStructure);
//ж
  USART_ITConfig(USART3, USART_IT_RXNE, ENABLE);
//ʹܴ
  USART_Cmd(USART3, ENABLE);

  MP3_SetSound(Mp3Sound);
  MP3_DELAY(20);
	return 1;
}
u8 MP3_BspDeInit(void)
{
	RCC_APB1PeriphClockCmd(RCC_APB1Periph_USART3, DISABLE);
	USART_ITConfig(USART3, USART_IT_RXNE, DISABLE);
	USART_Cmd(USART3, DISABLE);
}
void MP3_SendByte(u8 byte)
{
  USART_SendData(USART3, byte);
  while(USART_GetFlagStatus(USART3, USART_FLAG_TXE) == RESET);
}
void MP3_SendPacket(u8 *Data,u16 len)
{
  u16 i;
  for(i=0;i<len;i++)
  {
		MP3_SendByte(*Data++);
  }
}
//MP3ݰʽ:0X7E+0XFF(ֽ)+0x06()+CMD+FB+D0+D1+2ByteУ+0XEF
void MP3_SendCmd( u8 *Data,//ָ
                   u16 len,//,ȥͷβͼ
									 u8 check)//0У,1У
{
	u16 sum=0,i;
	MP3_GetSetCmdTime();//ȴϴδ
	MP3_SendByte(MP3_FIRST_BYTE);
	MP3_SendPacket(Data,len);
	if(check)//У
	{
		for(i=0;i<len;i++){sum+=*(Data+i);}
		sum=0-sum;
		MP3_SendByte((sum>>8)&0xFF);
		MP3_SendByte((sum)&0xFF);
	}
	MP3_SendByte(MP3_END_BYTE);
}
//MP3ָ
void MP3_Send(u8 cmd,//ָ
               u8 feedback,//1з,0޷
							 u8 *Data,//ָĲ
							 u16 len)//*Data
{
	u8 mData[100];
	u16 i=0;
	mData[i++]=0xFF;    //0 λ
	mData[i++]=len+4;   //1 
	mData[i++]=cmd;     //2 ָ
	mData[i++]=feedback;//3 
	for(i;i<mData[1];i++)mData[i]=*Data++;
	MP3_SendCmd(mData,mData[1],1);
}
//MP3ָ
void MP3_SendString(u8 cmd,//ָ
											u8 feedback,//1з,0޷
											u8 *Data)//ָĲ
{
	u8 mData[100];
	u16 i=0,len=0;
	mData[i++]=0xFF;    //0 λ
	i++;//mData[i++]=len+4;   //1 
	mData[i++]=cmd;     //2 ָ
	mData[i++]=feedback;//3 
	for(i;*Data;i++)mData[i]=*Data++;
	mData[1]=i;//len+4;
	MP3_SendCmd(mData,mData[1],1);
}
//MP3ָ
void MP3_Cmd(u8 cmd,//ָ
               u8 feedback,//1з,0޷
							 u16 Data)//ָĲ

{
	u8 mData[2];
	mData[0]=(Data>>8)&0xff;
	mData[1]=Data&0xff;
  MP3_Send(cmd,//ָ
            feedback,//1з,0޷
						mData,//ָĲ
						0x02);//*Data	
}
void MP3_GetSound(u8 *sound)//ȡ
{
	u16 msound;
	msound=ReadMP3SoundEEP();
	if(msound>MP3SOUND_MAX)msound=MP3SOUND_MAX;
	*sound=msound;
}
void MP3_SetSound(u8 sound)//
{
	if(sound>30)sound=30;
	MP3_Cmd(MP3_SOUND_SCMD,//ָ
          0x00,//1з,0޷
					sound);//ָĲ	
	//if(Mp3Sound!=sound)	// 浽eeprom ReadMP3SoundEEP()
	//{
		//SetMP3SoundEEP(sound);
		//Mp3Sound=sound;
	//}
}
u16 Mp3SoundOut=0xffff;
void MP3_SetSoundOut(void)//
{
	if(Mp3SoundOut==Mp3Sound)return;
	MP3_Cmd(MP3_SOUND_SCMD,//ָ
          0x00,//1з,0޷
          Mp3Sound);//ָĲ
	Mp3SoundOut=Mp3Sound;
	//MP3_DELAY(25);//Ҫʱ
}
void MP3_SetDACOut(u8 mode)//,10
{
	u8 state=0;
	if(mode==0)state=1;//رDAC
	MP3_Cmd(MP3_DACOUT_SCMD,//ָ
          0x01,//1з,0޷
					state);//ָĲ	
}
void MP3_PlaySong(u8 mode,u16 data)
{
	MP3_BspInit();
	MP3_SetSoundOut();//MP3ʱ
	switch(mode)
	{
		case MP3_STOP://ֹͣ
		{
			MP3_Cmd(MP3_STOP_SCMD,//ָ
              0x01,//1з,0޷
							0x00);//ָĲ
		}break;
		case MP3_PLAY://
		{
			MP3_Cmd(MP3_PLAY_SCMD,//ָ
              0x01,//1з,0޷
							0x00);//ָĲ
		}break;
		case MP3_SUSPEND://ͣ
		{
			MP3_Cmd(MP3_SUSPEND_SCMD,//ָ
              0x01,//1з,0޷
							0x00);//ָĲ
		}break;
		case MP3_NXT://һ
		{
			MP3_Cmd(MP3_PNXT_SCMD,//ָ
              0x01,//1з,0޷
							0x00);//ָĲ
		}break;
		case MP3_FWD://һ
		{
			MP3_Cmd(MP3_PFWD_SCMD,//ָ
              0x01,//1з,0޷
							0x00);//ָĲ
		}break;
		case MP3_PLAYSONG:
		{//7E FF 06 0F 00 01 01 FE EA EF//ָΪ"01"ļУĿΪ"001"
			MP3_Cmd(MP3_PFNSF_SCMD,//MP3_PSONG_SCMD,//ָ
              0x01,//1з,0޷
							data);//ָĲ
		}break;
	}
}
//u8 iiii=0;
u8 CheckMP3OnlineState(void)
{
	ClearMP3Buffer();
	MP3_Cmd(MP3_ONLINE_CCMD,//ָ
          0x00,//1з,0޷
					0x00);//ָĲ
	MP3_DELAY(50);
	if(Mp3RxNew)
	{
		if(Mp3RXBuffer[3]==0X3F&&Mp3RXBuffer[6]==0x0C)
		{
			ClearMP3Buffer();
			return 1;//
		}
		ClearMP3Buffer();
	}
	return 0;
}
u8 CheckCurronOnlineState(void)
{
	if(MP3DiskState==1){MP3DiskState=0;return 1;}
	else if(MP3DiskState==2){MP3DiskState=0;return 0;}
	if(Mp3RxNew)
	{
	#if _MP3_DEBUG_EN_>0
		MP3_Debug();
	#endif	
		if(Mp3RXBuffer[3]==0X3A||(Mp3RXBuffer[3]==0X3F&&Mp3RXBuffer[6]==0x0C))//
		{
			ClearMP3Buffer();
			return 1;//
		}
		ClearMP3Buffer();
	}
	return 0;
}
u16 ReadMP3SongNum(u16 *SongSize)//Ŀ
{
	u16 t=3;//,i;
	ClearMP3Buffer();//建
	do
	{
		MP3_Cmd(MP3_CTFILENUM_CCMD,//ָ
						0x00,//1з,0޷
						0x00);//ָĲ			
		MP3_DELAY(20);//ʱ20msȴ
		if(Mp3RxNew&&Mp3RXBuffer[3]==MP3_CTFILENUM_CCMD)
		{
			t=0;
			*SongSize=(Mp3RXBuffer[5]<<8)|Mp3RXBuffer[6];//Ƶ
			return 1;
		}
		else if(Mp3RxNew)ClearMP3Buffer();
	}while(t--);
	*SongSize=0;
//	for(i=0;i<Mp3RxLen;i++)print("%X ",Mp3RXBuffer[i]);
	return 0;
}

void MP3_RX_ISR(void)
{
	if(USART_GetITStatus(USART3, USART_IT_RXNE) != RESET)
	{ 
		USART_ClearFlag(USART3, USART_FLAG_RXNE);
		Mp3RXBuffer[Mp3RxLen++]=USART_ReceiveData(USART3);//Զжϱ־
		if(Mp3RxLen>=MP3RX_MAX){	Mp3RxLen=0;}
		switch(Mp3RxNew)
		{
			case 0:
			{
				if(Mp3RxLen>4&&Mp3RxLen>=(Mp3RXBuffer[2]+4))//1ݰ
				{
					if(Mp3RXBuffer[0]==MP3_FIRST_BYTE&&Mp3RXBuffer[Mp3RxLen-1]==MP3_END_BYTE)
					{
						Mp3RxNew=1;//1ݰ
					}
					else 
					{
						Mp3RxNew=0;
						Mp3RxLen=0;
					}
				}
			}break;
			default:
			{
			}break;
		}
		//ڼǷPC
		if(Mp3RxLen>=10)
		{
			if(Mp3RXBuffer[Mp3RxLen-10]==MP3_FIRST_BYTE&&
			    Mp3RXBuffer[Mp3RxLen-1]==MP3_END_BYTE&&
					Mp3RXBuffer[Mp3RxLen-8]==0X06&&
					Mp3RXBuffer[Mp3RxLen-4]==0X04)//PC
			{
				if(Mp3RXBuffer[Mp3RxLen-7]==0X3A)
				{//7E FF 06 3A 00 00 04 FE BD EF
					MP3DiskState=1;//PC
				}
				else if(Mp3RXBuffer[Mp3RxLen-7]==0X3B)
				{//7E FF 06 3B 00 00 04 FE BD EF
					MP3DiskState=2;//γPC
				}
			}
		}//if(Mp3RxLen>=10)
	}
}
#endif//_MP3LIB_EXT_H_
#endif//_MP3_H_
