﻿package flash023
{
	import flash.display.BitmapData;
	import flash.display.Bitmap;
	import flash.display.Sprite;
	import flash.display.BlendMode;
	import flash.display.StageScaleMode;
	import flash.events.Event;
	import flash.events.TimerEvent;
	import flash.filters.ConvolutionFilter;
	import flash.filters.DisplacementMapFilter;
	import flash.geom.ColorTransform;
	import flash.geom.Matrix;
	import flash.geom.Rectangle;
	import flash.utils.getDefinitionByName;
	import flash.geom.Point;
	import flash.events.MouseEvent;
	import com.greensock.TweenLite;
	import flash.events.ProgressEvent;
	import flash.utils.Timer;
	import flash023.ui.FishClip;
	import flash023.ui.Rippler;
	
	/**
	 * @author FLASH023
	 * @date 2013-1-14 19:37
	 **/
	public class Main extends Sprite
	{
		private var fishContainer:Sprite;
		private var total:int;	
		private var rippler:Rippler;
		public function Main():void
		{
			stage ? init(null) : addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event):void
		{
			stage.align = "TL";
			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.addEventListener(Event.RESIZE, onResize);				
			//
			fishContainer = new Sprite;
			addChild (fishContainer);
			var _array:Array = [0, 1, 2, 3, 3, 3, 4, 4, 4, 5, 5, 5];
			total = _array.length;
			for (var _i:int = 0; _i < total; _i++) {
				var _fish:FishClip = createFish(_array[_i]);
				_fish.speed = _array [_i];
				fishContainer .addChild (_fish );
			}
			/*var _p:Pao = new Pao;
			_p.x = 440;
			_p.y = 600;
			addChild (_p);*/
			//下面这行的第二、三参数，分别设置水波的辐度和扩散的速度
			rippler = new Rippler(this,50,5);
			//stage.addEventListener (MouseEvent.MOUSE_OVER, mouseDown);
			stage.addEventListener (MouseEvent.MOUSE_MOVE, mouseMove);			
			onResize(null);
			removeEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function mouseDown(e:MouseEvent):void 
		{
			rippler.drawRipple(mouseX,mouseY,30,1);			
		}
		private function mouseMove(e:MouseEvent):void 
		{
			var _t:int = fishContainer.numChildren;
			while (_t--) {
				var _fish:FishClip = fishContainer.getChildAt(_t) as FishClip;
				var _xd:int = mouseX - _fish.x;
				var _yd:int = mouseY -_fish.y;
				var _d:int = Math.sqrt(_xd * _xd + _yd * _yd);
				if (_d < 120) {
					var _r:int = Math.atan2(_yd,_xd)+(30-Math.random () * 60) / 180 * Math.PI;
					var _x:int = mouseX + Math.cos (_r) * (150 - _d) * 5;
					var _y:int = mouseY + Math.sin (_r) * (150 - _d) * 5;
					if (!_fish.moveIng ) {
						_fish.setPos (new Point (_x, _y));
						_fish.moveIng = true;
					}					
					//_fish.setPos(Point.interpolate(new Point(_fish.x,_fish.y),new Point(mouseX,mouseY),10+Math.random ()*10));
				}else {
					_fish.moveIng = false;
				}
			}
			//
			rippler.drawRipple(mouseX, mouseY, 30, 1);
			
		}
		
		private function onResize(e:Event):void
		{
			
		}
		private function createFish(_n:int):FishClip {
			var _class:Class=Class(getDefinitionByName("Fish" + _n));
			return new _class as FishClip;
		}
	}

}