﻿package flash023
{
	import flash.display.BitmapData;
	import flash.display.Bitmap;
	import flash.display.Sprite;
	import flash.display.BlendMode;
	import flash.display.StageScaleMode;
	import flash.events.Event;
	import flash.events.TimerEvent;
	import flash.filters.ConvolutionFilter;
	import flash.filters.DisplacementMapFilter;
	import flash.geom.ColorTransform;
	import flash.geom.Matrix;
	import flash.geom.Rectangle;
	import flash.utils.getDefinitionByName;
	import flash.geom.Point;
	import flash.events.MouseEvent;
	import com.greensock.TweenLite;
	import flash.events.ProgressEvent;
	import flash.utils.Timer;
	import flash023.ui.FishClip;
	
	/**
	 * @author FLASH023
	 * @date 2013-1-14 19:37
	 **/
	public class Main extends Sprite
	{
		private var fishContainer:Sprite;
		private var total:int;		
		private var damper:BitmapData;
		private var result:BitmapData;
		private var result2:BitmapData;
		private var source:BitmapData;
		private var buffer:BitmapData;
		private var output:BitmapData;
		private var surface:BitmapData;
		private var bounds:Rectangle;
		private var origin:Point;
		private var matrix:Matrix;
		private var matrix2:Matrix;
		private var wave:ConvolutionFilter;
		private var damp:ColorTransform;
		private var water:DisplacementMapFilter;
		private var drawWidth:Number = 1024;
		private var drawHeight:Number = 768;
		private var timer:Timer;
		private var isDown:Boolean;
		public function Main():void
		{
			stage ? init(null) : addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event):void
		{
			stage.align = "TL";
			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.addEventListener(Event.RESIZE, onResize);				
			//
			damper = new BitmapData(drawWidth, drawHeight, false, 128);
			result = new BitmapData(drawWidth, drawHeight, false, 128);
			result2 = new BitmapData(drawWidth*2, drawHeight*2, false, 128);
			source = new BitmapData(drawWidth, drawHeight, false, 128);
			buffer = new BitmapData(drawWidth, drawHeight, false, 128);
			output = new BitmapData(drawWidth*2, drawHeight*2, true, 128);
			bounds = new Rectangle(0, 0, drawWidth, drawHeight);
			origin = new Point();
			matrix = new Matrix();
			matrix2 = new Matrix();
			matrix2.a = matrix2.d=2;
			wave = new ConvolutionFilter(3, 3, [1, 1, 1, 1, 1, 1, 1, 1, 1], 9, 0);
			damp = new ColorTransform(0, 0, 9.960937E-001, 1, 0, 0, 2, 0);
			water = new DisplacementMapFilter(result2, origin, 4, 4, 48, 48, "ignore");
			var _bg:Sprite = new Sprite();
			addChildAt(_bg,0);
			_bg.graphics.beginFill(0xFFFFFF,0);
			_bg.graphics.drawRect(0,0,drawWidth,drawHeight);
			_bg.graphics.endFill();
			addChild(new Bitmap(output));
			surface = new BitmapData(drawWidth,drawHeight,true);
            surface.draw(this, null, null, null, null, true);
			addEventListener(Event.ENTER_FRAME, fishMove);
			/*timer = new Timer(100);
			timer.addEventListener (TimerEvent.TIMER, fishMove );
			timer.start ();*/
			//
			fishContainer = new Sprite;
			addChild (fishContainer);
			var _array:Array = [0, 1, 2, 3, 3, 3, 4, 4, 4, 5, 5, 5];
			total = _array.length;
			for (var _i:int = 0; _i < total; _i++) {
				var _fish:FishClip = createFish(_array[_i]);
				_fish.speed = _array [_i];
				//_fish.addEventListener (FishClip.FISH_MOVE, fishMove);
				fishContainer .addChild (_fish );
			}
			var _p:Pao = new Pao;
			_p.x = 440;
			_p.y = 600;
			addChild (_p);
			//
			stage.addEventListener (MouseEvent.MOUSE_DOWN, mouseDown);
			stage.addEventListener (MouseEvent.MOUSE_MOVE, mouseMove);			
			onResize(null);
			removeEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function mouseDown(e:MouseEvent):void 
		{
			isDown = true;
			stage.addEventListener (MouseEvent.MOUSE_UP, mouseUp);
		}
		
		private function mouseUp(e:MouseEvent):void 
		{
			isDown = false;
			stage.removeEventListener (MouseEvent.MOUSE_UP, mouseUp);
		}
		private function fishMove(e:Event):void {			
			if (isDown) {
				var _x:Number = mouseX * .5;
				var _y:Number = mouseY * .5;
				source.setPixel(_x+1, _y, 16777215);
				source.setPixel(_x-1, _y, 16777215);
				source.setPixel(_x, _y+1, 16777215);
				source.setPixel(_x, _y-1, 16777215);
				source.setPixel(_x, _y, 16777215);
			}        
			result.applyFilter(source, bounds, origin, wave);
			result.draw(result, matrix, null, BlendMode.ADD);
			result.draw(buffer, matrix, null, BlendMode.DIFFERENCE);
			result.draw(result, matrix, damp);
			result2.draw(result, matrix2, null, null, null, true);
			output.applyFilter(surface, new Rectangle(0, 0, drawWidth*2, drawHeight*2), origin, water);
			buffer = source;
			source = result.clone();
		}		
		private function mouseMove(e:MouseEvent):void 
		{
			var _t:int = fishContainer.numChildren;
			while (_t--) {
				var _fish:FishClip = fishContainer.getChildAt(_t) as FishClip;
				var _xd:int = mouseX - _fish.x;
				var _yd:int = mouseY -_fish.y;
				var _d:int = Math.sqrt(_xd * _xd + _yd * _yd);
				if (_d < 120) {
					var _r:int = Math.atan2(_yd,_xd)+(30-Math.random () * 60) / 180 * Math.PI;
					var _x:int = mouseX + Math.cos (_r) * (150 - _d) * 5;
					var _y:int = mouseY + Math.sin (_r) * (150 - _d) * 5;
					if (!_fish.moveIng ) {
						_fish.setPos (new Point (_x, _y));
						_fish.moveIng = true;
					}					
					//_fish.setPos(Point.interpolate(new Point(_fish.x,_fish.y),new Point(mouseX,mouseY),10+Math.random ()*10));
				}else {
					_fish.moveIng = false;
				}
			}
		}
		
		private function onResize(e:Event):void
		{
			
		}
		private function createFish(_n:int):FishClip {
			var _class:Class=Class(getDefinitionByName("Fish" + _n));
			return new _class as FishClip;
		}
	}

}