﻿package flash023.ui
{
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.events.Event;
	import com.greensock.TweenLite;
	import com.greensock.easing.Quint;
	import com.greensock.easing.Linear;
	import com.greensock.plugins.TweenPlugin;
	import com.greensock.plugins.ShortRotationPlugin;
	import com.greensock.plugins.BezierThroughPlugin;
	import flash.events.MouseEvent;
	import flash.geom.Point;
	import flash.utils.setTimeout;
	import flash.utils.clearTimeout;
	
	/**
	 * @author FLASH023
	 * @date 2012-3-26 18:49
	**/
	public class FishClip extends Sprite  
	{
		
		private var T:int;
		private var posPoint:Point;
		private var setMove:Boolean;
		private var _speed:int;
		private var _barSpeed:int
		public static const FISH_MOVE:String = "fishMove";
		public var moveIng:Boolean;		
		public var moveI:int = 0;
		public function FishClip():void
		{
			TweenPlugin.activate([ShortRotationPlugin,BezierThroughPlugin]);
			stage?init(null):addEventListener (Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event):void
		{
			x = Math.random ()*stage.stageWidth;
			y = Math.random () * stage.stageHeight;	
			posPoint = new Point (x, y);
			setPos ();
			//
			removeEventListener (Event.ADDED_TO_STAGE, init);			
		}	
		public function setFishMove():void{
			moveI--
			if(moveI<0){
				moveIng = false;
			}
		}
		private function tweenUpdate():void 
		{
			var _d:int = Point.distance (new Point(x, y), posPoint);
			if (_d > 10) {
				dispatchEvent (new Event(FISH_MOVE));
			}
			posPoint = new Point (x, y);
			if (x < 0||x>stage.stageWidth) {
				setPos();
			}
			if (y < 0 || y > stage.stageHeight ) {
				setPos();
			}
		}
		
		private function clearMove():void {
			setMove = false;
		}
		private function getPoint(_obj:Object ):Object {
			/*_obj.r += (Math.random () * 15 - 30) / 180 * Math.PI;
			var _d:int = 50 + Math.random () * 100;			
			_obj.x += Math.cos (_obj.r) * _d;
			_obj.y += Math.sin (_obj.r) * _d;*/
			return { x:Math.random () * stage.stageWidth, y:Math.random () * stage.stageHeight };
		}
		private function getPathArray():Array {
			var _d:int = 0;
			var _xd:int;
			var _yd:int;
			var _array:Array = [];
			var _temp:Object;
			var _point:Object;
			var _t:int=2+Math.random ()*5;
			while (_t--) {					
				if (!_temp) {
					_point = getPoint( { x:x, y:y, r:rotation / 180 * Math.PI } );
					_xd = _point.x - x;
					_yd = _point.y - y;					
				}else {
					_point = getPoint(_temp);
					_xd = _point.x - _temp.x;
					_yd = _point.y - _temp.y;					
				}
				_temp = _point;
				_d += Math.sqrt(_xd * _xd + _yd * _yd);
				_array.push (_point  );
			}
			_array.push (_d);
			return _array;
		}
		public function setPos(_p:Point = null):void {			
			if (_p) {
				moveIng = true;
				_speed += this.width/2
			}else {
				moveIng = false;
				_speed = _barSpeed
			}
			var _t:Number;
			if (_p) {
				var _xd:int = x - _p.x;
				var _yd:int = y - _p.y;
				rotation = Math.atan2(_yd, _xd) / Math.PI * 180+180;
				_t = Math.sqrt (_xd * _xd + _yd * _yd) / (_speed + Math.random () * 2);	
				TweenLite.to(this, _t, { x:_p.x, y:_p.y, ease:Quint.power ,onUpdate:tweenUpdate,onComplete:setPos} );
				return;
			}
			var _pathArray:Array = getPathArray();
			_t = _pathArray.pop() / (_speed + Math.random () * 2);			
			TweenLite.to(this, _t, { bezierThrough:_pathArray, orientToBezier:true,onUpdate:tweenUpdate,onComplete:setPos, ease:Linear.easeNone } );
		}
		
		public function set speed(value:int):void 
		{
			_barSpeed = 20 + Math.random () * 30;		
			if (value > 2) {
				_barSpeed = 40 + Math.random () * 40;
			}
			_speed = _barSpeed
		}
		
		
	}
	
}