﻿package flash023.ui
{
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.events.Event;
	import com.greensock.TweenLite;
	import com.greensock.easing.Quint;
	import com.greensock.easing.Linear;
	import com.greensock.plugins.TweenPlugin;
	import com.greensock.plugins.ShortRotationPlugin;
	import com.greensock.plugins.BezierThroughPlugin;
	import flash.events.MouseEvent;
	import flash.geom.Point;
	import flash.utils.setTimeout;
	import flash.utils.clearTimeout;
	
	/**
	 * @author FLASH023
	 * @date 2012-3-26 18:49
	**/
	public class FishClip extends Sprite  
	{
		
		private var T:int;
		private var posPoint:Point;
		private var setMove:Boolean;
		public function FishClip():void
		{
			TweenPlugin.activate([ShortRotationPlugin,BezierThroughPlugin]);
			stage?init(null):addEventListener (Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event):void
		{
			x = Math.random ()*stage.stageWidth;
			y = Math.random () * stage.stageHeight;
			posPoint = new Point (x, y);
			setPos ();
			//
			removeEventListener (Event.ADDED_TO_STAGE, init);			
		}	
		private function tweenUpdate():void 
		{
			//var _d:int = Point.distance (new Point(mouseX, mouseY), new Point());
			if (x < 0||x>stage.stageWidth) {
				setPos();
			}
			if (y < 0 || y > stage.stageHeight ) {
				setPos();
			}
		}
		private function clearMove():void {
			setMove = false;
		}
		private function getPathArray():Array {
			var _d:int = 0;
			var _xd:int;
			var _yd:int;
			var _array:Array = [];
			var _temp:Object;
			var _t:int = Math.random () * 6 + 2;
			while (_t--) {
				var _obj:Object = { x:Math.random () * stage.stageWidth, y : Math.random () * stage.stageHeight };
				if (!_temp) {
					_xd = _obj.x - x;
					_yd = _obj.y - y;
				}else {
					_xd = _obj.x - _temp.x;
					_yd = _obj.y - _temp.y;
				}
				_temp = _obj;
				_d += Math.sqrt(_xd * _xd + _yd * _yd);
				_array.push (_obj  );
			}
			_array.push (_p);
			return _array;
		}
		public function setPos(_p:Point = null):void {
			if (_p && setMove) {
				return;
			}
			if (_p) {
				//setMove = true;				
			}
			//clearTimeout (T);		
			T = setTimeout (clearMove, 1000);
			var _x:int;
			var _y:int;
			if (_p) {
				_x = _p.x;
				_y = _p.y;
			}else {
				var _r:Number = (rotation + Math.random () * 15 - 30);
				var _d:int = 250 + Math.random () * 500;
				var _ar:Number = _r / 180 * Math.PI;
				_x = posPoint.x - Math.cos (_ar) * _d;
				_y = posPoint.y - Math.sin (_ar) * _d;
				if (_x < 0||_x>stage.stageWidth) {
					_x = Math.random () * stage.stageWidth;
				}
				if (_y < 0 || _y > stage.stageHeight ) {
					_y = Math.random () * stage.stageHeight;
				}
			}
			
			var _t:Number = Point.distance (new Point (_x, _y), posPoint ) / (10 + Math.random () * 30);
			posPoint.x = _x;
			posPoint.y = _y;
			rotation = Math.atan2(y - _y, x - _x) / Math.PI * 180;
			//TweenLite.to(this, .5 + Math.random () * .5, {shortRotation:{ rotation:Math.atan2(y - _y, x - _x) / Math.PI * 180} } );
			//TweenLite.to(this, _t, { x:_x, y:_y, ease:Quint.power ,onUpdate:tweenUpdate,onComplete:setPos} );
			TweenLite.to(this, 5, { bezierThrough:getPathArray(), orientToBezier:true,onComplete:setPos, ease:Linear.easeNone } );
		}
		
	}
	
}