﻿package flash023.ui
{
    import flash.display.BitmapData;
    import flash.display.BitmapDataChannel;
    import flash.display.BlendMode;
    import flash.display.DisplayObject;
    import flash.events.Event;
    import flash.filters.ConvolutionFilter;
    import flash.filters.DisplacementMapFilter;
    import flash.geom.ColorTransform;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    /**
	 * @author FLASH023
	 * @date 2013-4-18 17:03
	 **/
    public class Rippler
    {
       
        private var _source : DisplayObject;        
        private var _buffer1 : BitmapData;
        private var _buffer2 : BitmapData;
        
        
        private var _defData : BitmapData;
        
       
        private var _fullRect : Rectangle; 			
        private var _drawRect : Rectangle;			
        private var _origin : Point = new Point();	
        private var _filter : DisplacementMapFilter;       
        private var _expandFilter : ConvolutionFilter;       
      
        private var _colourTransform : ColorTransform;
        
        private var _matrix : Matrix;
        
        private var _scaleInv : Number;        
        
        public function Rippler(source : DisplayObject, strength : Number, scale : Number = 2)
        {
            var correctedScaleX : Number;
            var correctedScaleY : Number;
            
            _source = source;
            _scaleInv = 1/scale;
            
            _buffer1 = new BitmapData(source.width*_scaleInv, source.height*_scaleInv, false, 0x000000);
            _buffer2 = new BitmapData(_buffer1.width, _buffer1.height, false, 0x000000);
            _defData = new BitmapData(source.width, source.height);
            
             correctedScaleX = _defData.width/_buffer1.width;
            correctedScaleY = _defData.height/_buffer1.height;
            
           _fullRect = new Rectangle(0, 0, _buffer1.width, _buffer1.height);
            _drawRect = new Rectangle();
            
            _filter = new DisplacementMapFilter(_buffer1, _origin, BitmapDataChannel.BLUE, BitmapDataChannel.BLUE, strength, strength, "wrap");
            _source.filters = [_filter];
            
            _source.addEventListener(Event.ENTER_FRAME, handleEnterFrame);
            
             _expandFilter = new ConvolutionFilter(3, 3, [0.5, 1, 0.5, 1, 0, 1, 0.5, 1, 0.5], 3);
            
           _colourTransform = new ColorTransform(1, 1, 1, 1, 127, 127, 127);
            
           _matrix = new Matrix(correctedScaleX, 0, 0, correctedScaleY);
            
        }
        public function drawRipple(x : int, y : int, size : int, alpha : Number) : void
        {
        	var half : int = size >> 1;		
            var intensity : int = (alpha*0xff & 0xff)*alpha;	
            
          _drawRect.x = (-half+x)*_scaleInv;	
            _drawRect.y = (-half+y)*_scaleInv;
            _drawRect.width = _drawRect.height = size*_scaleInv;
            _buffer1.fillRect(_drawRect, intensity);
        }
        
       	
        public function getRippleImage() : BitmapData
        {
        	return _defData;
        }
        
       
        public function destroy() : void
        {
            _source.removeEventListener(Event.ENTER_FRAME, handleEnterFrame);
            _buffer1.dispose();
            _buffer2.dispose();
            _defData.dispose();
        }
        
       private function handleEnterFrame(event : Event) : void
        {
        	 var temp : BitmapData = _buffer2.clone();
            _buffer2.applyFilter(_buffer1, _fullRect, _origin, _expandFilter);
           _buffer2.draw(temp, null, null, BlendMode.SUBTRACT, null, false);
            _defData.draw(_buffer2, _matrix, _colourTransform, null, null, true);
            _filter.mapBitmap = _defData;
            _source.filters = [_filter];
            temp.dispose();
           switchBuffers();
        }
        
       private function switchBuffers() : void
        {
            var temp : BitmapData;
            temp = _buffer1;
            _buffer1 = _buffer2;
            _buffer2 = temp;
        }
    }
}