﻿using desktopEnglish.entity;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Runtime.InteropServices;
using System.Text;
using System.Windows.Forms;

namespace desktopEnglish
{
    public partial class BackForm : Form
    {
        //为实现关闭设置窗口后，foreForm能响应设置的改变
        public delegate void flush();
        public event flush flushForm;
        public Form foreForm;
        Color bgColor;
        double opacity;
        public BackForm(Form foreForm,Color bgColor,double opacity)
        {
            InitializeComponent();
            this.foreForm = foreForm;
            this.bgColor = bgColor;
            this.opacity = opacity;
        }

        #region 关闭应用的颜色变动
        //private void label1_MouseHover(object sender, EventArgs e)
        //{
        //    this.label1.BackColor = Color.Red;
        //}
        //private void label1_Click(object sender, EventArgs e)
        //{
        //    Application.Exit();
        //}
        //private void label1_MouseLeave(object sender, EventArgs e)
        //{
        //    this.label1.BackColor = this.BackColor;
        //}
        #endregion

        #region 窗体拖动
        //拖动的形式
        [DllImport("user32.DLL", EntryPoint = "ReleaseCapture")]
        private extern static void ReleaseCapture();

        [DllImport("user32.DLL", EntryPoint = "SendMessage")]
        private extern static void SendMessage(System.IntPtr hWnd, int wMsg, int wParam, int lParam);

        private void panelContainer_MouseDown(object sender, MouseEventArgs e)
        {
            ReleaseCapture();
            SendMessage(this.Handle, 0x112, 0xf012, 0);
            this.foreForm.Location = this.Location;
            this.Size = this.foreForm.Size;
            this.TopMost = true;
            this.foreForm.TopMost = true;
        }
        #endregion

        /// <summary>
        /// 让程序不显示在alt+Tab视图窗体中
        /// </summary>
        protected override CreateParams CreateParams
        {
            get
            {
                const int WS_EX_APPWINDOW = 0x40000;
                const int WS_EX_TOOLWINDOW = 0x80;
                CreateParams cp = base.CreateParams;
                cp.ExStyle &= (~WS_EX_APPWINDOW);    // 不显示在TaskBar
                cp.ExStyle |= WS_EX_TOOLWINDOW;      // 不显示在Alt+Tab
                return cp;
            }
        }
        private void BackForm_Load(object sender, EventArgs e)
        {
            this.StartPosition = foreForm.StartPosition;
            this.Location = foreForm.Location;
            this.Size = foreForm.Size;
            this.BackColor = bgColor;
            this.panelContainer.BackColor = bgColor;
            this.Opacity = opacity;
            this.TopMost = true;
            this.foreForm.TopMost = true;

            this.setting.Click += new System.EventHandler(this.setting_Click);
            this.stopAndStart.Click += StopAndStart_Click;
            this.ukVoice.Click += UkVoice_Click;
            this.usVoice.Click += UsVoice_Click;
        }

        /// <summary>
        /// 播放单词读音
        /// </summary>
        /// <param name="voiceUrl"></param>
        private void playVoice(string voiceUrl)
        {
            //读音播放
            xqMedia.Audio aq = new xqMedia.Audio();
            //播放读音
            aq.RenderMedia(voiceUrl, true);
        }
        private void UsVoice_Click(object sender, EventArgs e)
        {
            playVoice(Form1.word.UsPron);
        }

        private void UkVoice_Click(object sender, EventArgs e)
        {
            playVoice(Form1.word.UkPron);
        }

        //控制计时器的开始与停止
        private void StopAndStart_Click(object sender, EventArgs e)
        {
            var menu = sender as ToolStripMenuItem;
            if(menu.Text == "停止")
            {
                menu.Text = "开始";
                Form1.timerStaRandom.Stop();
                return;
            }
            if(menu.Text == "开始")
            {
                menu.Text = "停止";
                Form1.timerStaRandom.Start();
                return;
            }
        }

        /// <summary>
        /// 打开设置窗口
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void setting_Click(object sender, EventArgs e)
        {
            FormSetting formSetting = new FormSetting(this, this.foreForm);
            formSetting.FormFlush += FormSetting_FormFlush;
            formSetting.Show();
        }

        private void FormSetting_FormFlush()
        {
            flushForm();
        }

        private void label1_Click(object sender, EventArgs e)
        {
            this.foreForm.Close();
            this.Close();
            Application.Exit();
        }

        private void label1_MouseHover(object sender, EventArgs e)
        {
            this.label1.BackColor = Color.Red;
        }

        private void label1_MouseLeave(object sender, EventArgs e)
        {
            this.label1.BackColor = this.BackColor;
        }
    }
}
