﻿using System;
using System.Collections.Generic;
using System.Drawing;
using System.Text;

namespace desktopEnglish.entity
{
    [Serializable]
   public class RoutineSetting
    {
        private Font font;
        private Color fontColor;
        private Color backColor;
        private int speed;
        private double opacity;


        public RoutineSetting()
        {
        }

        public RoutineSetting(Font font, Color fontColor, Color backColor, int speed, double opacity)
        {
            this.font = font;
            this.fontColor = fontColor;
            this.backColor = backColor;
            this.speed = speed;
            this.Opacity = opacity;
        }

        public Font Font { get => font; set => font = value; }
        public Color FontColor { get => fontColor; set => fontColor = value; }
        public Color BackColor { get => backColor; set => backColor = value; }
        public int Speed { get => speed; set => speed = value; }
        public double Opacity { get => opacity; set => opacity = value; }

        public static RoutineSetting initRoutineSetting()
        {
            RoutineSetting routine = new RoutineSetting();
            routine.Speed = 5;
            routine.BackColor = Color.FromArgb(30, 30, 30);
            routine.FontColor = Color.FromArgb(55, 152, 212);
            routine.Font = new Font(new FontFamily("微软雅黑"), 18);
            routine.Opacity = 0.5;
            return routine;
        }
    }
}
