﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.IO;
using System.Text;
using System.Windows.Forms;

namespace desktopEnglish.settingForm
{
    public partial class FormRenameFile : Form
    {
        private string rootPath;
        private string sourceName;
        public delegate void renameFile(string fileName);
        public event renameFile getRenameFileName;
        public FormRenameFile(string rootPath,string sourceName)
        {
            InitializeComponent();
            this.rootPath = rootPath;
            this.sourceName = sourceName;
            this.TopMost = true;
        }

        private void buttonNo_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void buttonYes_Click(object sender, EventArgs e)
        {
            string filePath = this.textBoxFilename.Text;
            if (filePath != "")
            {
                string subStr = "";
                if (filePath.Length > 4)
                {
                    subStr = filePath.Substring(filePath.Length - 4, 4);
                }

                if (subStr == ".txt")
                {
                    File.Move(rootPath + "\\" + sourceName, rootPath + "\\" + filePath);
                    getRenameFileName(filePath);
                }
                else
                {
                    File.Move(rootPath + "\\" + sourceName, rootPath + "\\" + filePath+".txt");
                    getRenameFileName(filePath + ".txt");
                }
                this.Close();
            }
        }
    }
}
