﻿using desktopEnglish.entity;
using desktopEnglish.utils;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace desktopEnglish.settingForm
{
    public partial class FormRoutine : Form
    {
        private RoutineSetting routineSetting;
        public FormRoutine()
        {
            InitializeComponent();
        }
        /// <summary>
        /// 设置单词的字体
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void buttonFont_Click(object sender, EventArgs e)
        {
            FontDialog fd = new FontDialog();
            if(routineSetting.Font != null)
            {
                fd.Font = routineSetting.Font;
            }
            //默认等于 存储文件中的 字体
            if (fd.ShowDialog() == DialogResult.OK)
            {
                routineSetting.Font = fd.Font;
                this.textBoxFont.Text = fd.Font.Name + "，" + fd.Font.Size;
            }
        }

        private void buttonFontColor_Click(object sender, EventArgs e)
        {
            ColorDialog cd = new ColorDialog();
            if (cd.ShowDialog() == DialogResult.OK)
            {
                routineSetting.FontColor = cd.Color;
                this.btuFontColor.BackColor = cd.Color;
            }
        }

        private void buttonBackColor_Click(object sender, EventArgs e)
        {
            ColorDialog cd = new ColorDialog();
            if (cd.ShowDialog() == DialogResult.OK)
            {
                routineSetting.BackColor = cd.Color;
                this.btuBackColor.BackColor = cd.Color;
            }
        }

        private void FormRoutine_Load(object sender, EventArgs e)
        {
            for(int i = 5; i <= 60; i++)
            {
                this.comboBoxSpeed.Items.Add(i);
            }
            for (float i = 0; i < 10; i++)
            {
                this.comboBoxOpacity.Items.Add("0."+i);
            }
            this.comboBoxOpacity.Items.Add(1);
            routineSetting = UtilSerialize.DeserializeFromFile(FinalStrPath.RoutineConfigPath) as RoutineSetting;
            if(routineSetting == null)
            {
                routineSetting = RoutineSetting.initRoutineSetting();
                return;
            }
            this.textBoxFont.Text = routineSetting.Font.Name + "，" + routineSetting.Font.Size;
            this.btuFontColor.BackColor = routineSetting.FontColor;
            this.btuBackColor.BackColor = routineSetting.BackColor;
            this.comboBoxSpeed.SelectedItem = Convert.ToInt32(routineSetting.Speed);
            this.comboBoxOpacity.SelectedItem = routineSetting.Opacity.ToString();
        }

        private void FormRoutine_FormClosing(object sender, FormClosingEventArgs e)
        {
            if(this.routineSetting.Font == null)
            {
                this.routineSetting.Font = new Font(new FontFamily("微软雅黑"), 18);
            }
            if(this.routineSetting.FontColor == null)
            {
                this.routineSetting.FontColor = Color.FromArgb(100, 195, 251);
            }
            if (this.routineSetting.BackColor == null)
            {
                this.routineSetting.BackColor = Color.FromArgb(30,30,30);
            }
            if (this.routineSetting.Speed < 5)
            {
                this.routineSetting.Speed = 5;
            }
            UtilSerialize.SerializeToFile(this.routineSetting, FinalStrPath.RoutineConfigPath);
        }

        private void comboBoxSpeed_SelectedIndexChanged(object sender, EventArgs e)
        {
            this.routineSetting.Speed = Convert.ToInt32(comboBoxSpeed.SelectedItem);
        }

        private void comboBoxOpacity_SelectedIndexChanged(object sender, EventArgs e)
        {
            this.routineSetting.Opacity = Convert.ToDouble(comboBoxOpacity.SelectedItem);
        }
    }
}
