﻿using desktopEnglish.entity;
using desktopEnglish.utils;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.IO;
using System.Text;
using System.Windows.Forms;

namespace desktopEnglish.settingForm
{
    public partial class FormWord : Form
    {
        public FormWord()
        {
            InitializeComponent();
        }
        //单词配置
        WordSetting wordSetting;
        //文件列表
        List<string> fileNameList = new List<string>();
        //选择单词文件夹
        private void btuSelectFlie_Click(object sender, EventArgs e)
        {
            FolderBrowserDialog fbd = new FolderBrowserDialog();
            if (fbd.ShowDialog() == DialogResult.OK)
            {
                this.textBoxFilePath.Text = fbd.SelectedPath;
                //checklistbox显示文件列表
                this.GetFileNameList(fbd.SelectedPath);
            }
        }

        //获取txt文件列表，并在checklistbox中显示
        private void GetFileNameList(string directoryPath)
        {
            fileNameList = FileUtil.getFileName(directoryPath);
            if (this.checkListWordFile.Items.Count > 0)
            {
                this.checkListWordFile.Items.Clear();
            }
            foreach (string s in fileNameList)
            {
                this.checkListWordFile.Items.Add(s);
            }
        }

        //选中单词文件加载其中的单词
        private void checkListWordFile_ItemCheck(object sender, ItemCheckEventArgs e)
        {
            for (int i = 0; i < checkListWordFile.Items.Count; i++)
            {
                if (i != e.Index)//除去触发SelectedIndexChanged事件以外的选中项都处于未选中状态
                {
                    checkListWordFile.SetItemCheckState(i, System.Windows.Forms.CheckState.Unchecked);
                }
            }
            //每次变动check保存一下文件
            this.saveFile();
            List<string> wordList = new List<string>();
            wordList = ReadWord.getAllWord(this.textBoxFilePath.Text + "\\" + this.checkListWordFile.Items[e.Index]);
            this.richTBWord.Lines = wordList.ToArray();
        }

        private void FormWord_Load(object sender, EventArgs e)
        {
            //注册checklistbox的右键菜单点击事件
            this.newFile.Click += NewFile_Click;
            this.renameFile.Click += RenameFile_Click;
            this.deleteFile.Click += DeleteFile_Click;
            this.openDic.Click += OpenDic_Click;
            //读取配置
            wordSetting = UtilSerialize.DeserializeFromFile(FinalStrPath.WordConfigPath) as WordSetting;
            if (wordSetting != null)
            {
                this.textBoxFilePath.Text = wordSetting.WordDirectoryPath;
                this.GetFileNameList(wordSetting.WordDirectoryPath);
                if (checkListWordFile.Items.Count > 0)
                {
                    checkListWordFile.SetItemCheckState(0, System.Windows.Forms.CheckState.Checked);
                }
                //遍历，设置选中项
                for (int i = 0; i < checkListWordFile.Items.Count; i++)
                {
                    if (checkListWordFile.Items[i].ToString().Equals(wordSetting.WordFileName))
                    {
                        checkListWordFile.SetItemCheckState(i, System.Windows.Forms.CheckState.Checked);
                    }
                }
            }
        }

        private void RenameFile_Click(object sender, EventArgs e)
        {
            if (this.textBoxFilePath.Text != ""
    && this.checkListWordFile.CheckedItems.Count > 0)
            {
                FormRenameFile formRenameFile = new FormRenameFile(this.textBoxFilePath.Text,this.checkListWordFile.CheckedItems[0].ToString());
                formRenameFile.getRenameFileName += FormRenameFile_getRenameFileName;
                formRenameFile.ShowDialog();
            }
        }

        private void FormRenameFile_getRenameFileName(string fileName)
        {
            this.checkListWordFile.Items.Remove(this.checkListWordFile.CheckedItems[0]);
            this.checkListWordFile.Items.Add(fileName);
            //遍历，设置选中项
            for (int i = 0; i < checkListWordFile.Items.Count; i++)
            {
                if (checkListWordFile.Items[i].ToString().Equals(fileName))
                {
                    checkListWordFile.SetItemCheckState(i, System.Windows.Forms.CheckState.Checked);
                }
            }
        }

        //打开文件夹
        private void OpenDic_Click(object sender, EventArgs e)
        {
            if (this.textBoxFilePath.Text != "" && Directory.Exists(this.textBoxFilePath.Text))
            {
                System.Diagnostics.Process.Start("explorer.exe", this.textBoxFilePath.Text);
            }
        }
        //删除文件
        private void DeleteFile_Click(object sender, EventArgs e)
        {
            if (this.textBoxFilePath.Text != ""
                && this.checkListWordFile.CheckedItems.Count > 0)
            {
                File.Delete(this.textBoxFilePath.Text + "\\" + this.checkListWordFile.CheckedItems[0]);
                this.checkListWordFile.Items.Remove(this.checkListWordFile.CheckedItems[0]);
            }
        }

        //新建文件
        private void NewFile_Click(object sender, EventArgs e)
        {
            if (this.textBoxFilePath.Text != "")
            {
                FormNewFile formNewFile = new FormNewFile(this.textBoxFilePath.Text);
                formNewFile.getFileName += FormNewFile_getFileName;
                formNewFile.ShowDialog();
            }
        }

        //将新建的文件加入checklistbox中
        private void FormNewFile_getFileName(string fileName)
        {
            this.checkListWordFile.Items.Add(fileName);
        }

        //讲 richtxtbox中的内容保存
        private void saveFile()
        {
            if (this.checkListWordFile.CheckedItems.Count > 0)
            {
                this.richTBWord.SaveFile(this.textBoxFilePath.Text + "\\" + this.checkListWordFile.CheckedItems[0].ToString(), RichTextBoxStreamType.PlainText);
            }
        }

        private void FormWord_FormClosing(object sender, FormClosingEventArgs e)
        {
            this.saveFile();
            if (wordSetting == null)
            {
                wordSetting = new WordSetting();
            }
            wordSetting.WordDirectoryPath = this.textBoxFilePath.Text;
            if (this.checkListWordFile.CheckedItems.Count > 0)
            {
                wordSetting.WordFileName = this.checkListWordFile.CheckedItems[0].ToString();
            }
            else
            {
                wordSetting.WordFileName = this.checkListWordFile.Items.Count > 0 ? this.checkListWordFile.Items[0].ToString() : "";
            }
            UtilSerialize.SerializeToFile(wordSetting, FinalStrPath.WordConfigPath);
        }
    }
}
