Assets = 
{
	--always SW
	Asset( "IMAGE", "icon/crabhole.tex" ),
	Asset( "ATLAS", "icon/crabhole.xml" ),
	Asset( "IMAGE", "icon/whale_bubbles.tex" ),
	Asset( "ATLAS", "icon/whale_bubbles.xml" ),
	Asset( "IMAGE", "icon/blue_mushroom.tex" ),
	Asset( "ATLAS", "icon/blue_mushroom.xml" ),
	Asset( "IMAGE", "icon/red_mushroom.tex" ),
	Asset( "ATLAS", "icon/red_mushroom.xml" ),	
	Asset( "IMAGE", "icon/green_mushroom.tex" ),
	Asset( "ATLAS", "icon/green_mushroom.xml" ),
	Asset( "IMAGE", "icon/sharx.tex" ),
	Asset( "ATLAS", "icon/sharx.xml" ),
	Asset( "IMAGE", "icon/mandrake.tex" ),
	Asset( "ATLAS", "icon/mandrake.xml" ),
	Asset( "IMAGE", "icon/swordfish.tex" ),
	Asset( "ATLAS", "icon/swordfish.xml" ),
	Asset( "IMAGE", "icon/ox.tex" ),
	Asset( "ATLAS", "icon/ox.xml" ),
	Asset( "IMAGE", "icon/ballphin.tex" ),
	Asset( "ATLAS", "icon/ballphin.xml" ),
	Asset( "IMAGE", "icon/bioluminescence.tex" ),
	Asset( "ATLAS", "icon/bioluminescence.xml" ),	
	Asset( "IMAGE", "icon/hound.tex" ),
	Asset( "ATLAS", "icon/hound.xml" ),
	Asset( "IMAGE", "icon/knightboat.tex" ),
	Asset( "ATLAS", "icon/knightboat.xml" ),	
	Asset( "IMAGE", "icon/livingjungletree.tex" ),
	Asset( "ATLAS", "icon/livingjungletree.xml" ),
	Asset( "IMAGE", "icon/obsidian.tex" ),
	Asset( "ATLAS", "icon/obsidian.xml" ),
	Asset( "IMAGE", "icon/seashell_beached.tex" ),
	Asset( "ATLAS", "icon/seashell_beached.xml" ),
	Asset( "IMAGE", "icon/skeleton.tex" ),
	Asset( "ATLAS", "icon/skeleton.xml" ),
	Asset( "IMAGE", "icon/volcanostaff.tex" ),
	Asset( "ATLAS", "icon/volcanostaff.xml" ),
	Asset( "IMAGE", "icon/fishinhole.tex" ),
	Asset( "ATLAS", "icon/fishinhole.xml" ),
	Asset( "IMAGE", "icon/magmarock_gold.tex" ),
	Asset( "ATLAS", "icon/magmarock_gold.xml" ),
	Asset( "IMAGE", "icon/rock2.tex" ),
	Asset( "ATLAS", "icon/rock2.xml" ),
	Asset( "IMAGE", "icon/sandhill.tex" ),
	Asset( "ATLAS", "icon/sandhill.xml" ),
	Asset( "IMAGE", "icon/whale_blue.tex" ),
	Asset( "ATLAS", "icon/whale_blue.xml" ),
	Asset( "IMAGE", "icon/whale_white.tex" ),
	Asset( "ATLAS", "icon/whale_white.xml" ),
	--thing
	Asset( "IMAGE", "icon/teleportato_sw_box.tex" ),
	Asset( "ATLAS", "icon/teleportato_sw_box.xml" ),
	Asset( "IMAGE", "icon/teleportato_sw_crank.tex" ),
	Asset( "ATLAS", "icon/teleportato_sw_crank.xml" ),
	Asset( "IMAGE", "icon/teleportato_sw_potato.tex" ),
	Asset( "ATLAS", "icon/teleportato_sw_potato.xml" ),
	Asset( "IMAGE", "icon/teleportato_sw_ring.tex" ),
	Asset( "ATLAS", "icon/teleportato_sw_ring.xml" ),
	--option chester only
	Asset( "IMAGE", "icon/packim_fishbone.tex" ),
	Asset( "ATLAS", "icon/packim_fishbone.xml" ),
	Asset( "IMAGE", "icon/chester_eyebone.tex" ),
	Asset( "ATLAS", "icon/chester_eyebone.xml" ),
	--option wall
	Asset( "IMAGE", "icon/sandbagsmall.tex" ),
	Asset( "ATLAS", "icon/sandbagsmall.xml" ),
	Asset( "IMAGE", "icon/wall_hay.tex" ),
	Asset( "ATLAS", "icon/wall_hay.xml" ),
	Asset( "IMAGE", "icon/wall_wood.tex" ),
	Asset( "ATLAS", "icon/wall_wood.xml" ),
	Asset( "IMAGE", "icon/wall_stone.tex" ),
	Asset( "ATLAS", "icon/wall_stone.xml" ),
	Asset( "IMAGE", "icon/wall_limestone.tex" ),
	Asset( "ATLAS", "icon/wall_limestone.xml" ),
	Asset( "IMAGE", "icon/wall_ruins.tex" ),
	Asset( "ATLAS", "icon/wall_ruins.xml" ),
	--option others
	Asset( "IMAGE", "icon/flup.tex" ),
	Asset( "ATLAS", "icon/flup.xml" ),
	Asset( "IMAGE", "icon/solofish.tex" ),
	Asset( "ATLAS", "icon/solofish.xml" ),
	Asset( "IMAGE", "icon/jellyfish_planted.tex" ),
	Asset( "ATLAS", "icon/jellyfish_planted.xml" ),
	--[[Asset( "IMAGE", "icon/mussel_farm.tex" ),
	Asset( "ATLAS", "icon/mussel_farm.xml" ),]]
}

local MinimapOn = (GetModConfigData("Minimap")=="default")
local MinimapOff = (GetModConfigData("Minimap")=="off")

local RevealerOff = (GetModConfigData("Revealer")=="default")
local RevealerOn = (GetModConfigData("Revealer")=="on")

local WallOff = (GetModConfigData("Wall")=="default")
local WallOn = (GetModConfigData("Wall")=="on")

local OthersOff = (GetModConfigData("Others")=="default")
local OthersOn = (GetModConfigData("Others")=="on")

local ChesterOff = (GetModConfigData("Chester")=="default")
local ChesterOn = (GetModConfigData("Chester")=="on")

local mapscale = GetModConfigData("Minimap Size")
local position_str = GetModConfigData("Position")
local margin_size_x = GetModConfigData("Horizontal Margin")
local margin_size_y = GetModConfigData("Vertical Margin")

local dir_vert = 0
local dir_horiz = 0
local anchor_vert = 0
local anchor_horiz = 0
local margin_dir_vert = 0
local margin_dir_horiz = 0
local y_align, x_align = position_str:match("(%a+)_(%a+)")

if MinimapOn then
	if x_align == "left" then
		dir_horiz = -1
		anchor_horiz = 1
		margin_dir_horiz = 1
	elseif x_align == "center" then
		dir_horiz = 0
		anchor_horiz = 0
		margin_dir_horiz = 0
	elseif x_align == "right" then
		dir_horiz = 1
		anchor_horiz = -1
		margin_dir_horiz = -1
	end
end

if MinimapOn then
	if y_align == "top" then
		dir_vert = 0
		anchor_vert = -1
		margin_dir_vert = -1
	elseif y_align == "middle" then
		dir_vert = -1
		anchor_vert = 0
		margin_dir_vert = 0
	elseif y_align == "bottom" then
		dir_vert = -2
		anchor_vert = 1
		margin_dir_vert = 1
	end
end

function icon(inst)
	local minimap = inst.entity:AddMiniMapEntity()
	minimap:SetIcon( inst.prefab .. ".tex" )
end

function icon2(inst)
	local minimap = inst.entity:AddMiniMapEntity()
	minimap:SetIcon( inst.prefab .. ".tex" )
end

function Reaveltarget(player)
	if not GLOBAL.TheSim:FindFirstEntityWithTag("chester") then
		if GLOBAL.TheSim:FindFirstEntityWithTag("chester_eyebone") then			
			local doer = player
			local target = GLOBAL.TheSim:FindFirstEntityWithTag("chester_eyebone")			
			local x, y, z = target.Transform:GetWorldPosition()			
				player:DoTaskInTime(0, function()
				GLOBAL.GetWorld().minimap.MiniMap:ShowArea(x, y, z, 19)
			end)
		end
	end
	if not GLOBAL.TheSim:FindFirstEntityWithTag("chester") then
		if GLOBAL.TheSim:FindFirstEntityWithTag("king") then			
			local doer = player
			local target = GLOBAL.TheSim:FindFirstEntityWithTag("king")			
			local x, y, z = target.Transform:GetWorldPosition()			
				player:DoTaskInTime(0, function()
				GLOBAL.GetWorld().minimap.MiniMap:ShowArea(x, y, z, 19)
			end)
		end
	end
if GLOBAL.IsDLCEnabled(GLOBAL.CAPY_DLC) then
	if not GLOBAL.TheSim:FindFirstEntityWithTag("packim") then
		if GLOBAL.TheSim:FindFirstEntityWithTag("packim_fishbone") then			
			local doer = player
			local target = GLOBAL.TheSim:FindFirstEntityWithTag("packim_fishbone")			
			local x, y, z = target.Transform:GetWorldPosition()			
				player:DoTaskInTime(0, function()
				GLOBAL.GetWorld().minimap.MiniMap:ShowArea(x, y, z, 19)
			end)
		end
	end
		if not GLOBAL.TheSim:FindFirstEntityWithTag("packim") then
			if GLOBAL.TheSim:FindFirstEntityWithTag("king") then			
				local doer = player
				local target = GLOBAL.TheSim:FindFirstEntityWithTag("king")			
				local x, y, z = target.Transform:GetWorldPosition()			
					player:DoTaskInTime(0, function()
					GLOBAL.GetWorld().minimap.MiniMap:ShowArea(x, y, z, 19)
				end)
			end
		end
	end
end

AddSimPostInit(Reaveltarget)

--[[function King(player)
	if not GLOBAL.TheSim:FindFirstEntityWithTag("player") then
		if GLOBAL.TheSim:FindFirstEntityWithTag("king") then			
			local doer = player
			local target = GLOBAL.TheSim:FindFirstEntityWithTag("king")			
			local x, y, z = target.Transform:GetWorldPosition()			
				player:DoTaskInTime(0, function()
				GLOBAL.GetWorld().minimap.MiniMap:ShowArea(x, y, z, 25)
			end)
		end
	end
end

AddSimPostInit(King)

function Packim(player)
	if not GLOBAL.TheSim:FindFirstEntityWithTag("packim") then
		if GLOBAL.TheSim:FindFirstEntityWithTag("packim_fishbone") then			
			local doer = player
			local target = GLOBAL.TheSim:FindFirstEntityWithTag("packim_fishbone")			
			local x, y, z = target.Transform:GetWorldPosition()			
				player:DoTaskInTime(0, function()
				GLOBAL.GetWorld().minimap.MiniMap:ShowArea(x, y, z, 25)
			end)
		end
	end
end

AddSimPostInit(Packim)]]

local function revealer( inst )
	GLOBAL.RunScript("consolecommands")	
	inst:DoTaskInTime( 0.001, function() 	
		minimap = TheSim:FindFirstEntityWithTag("minimap")
		minimap.MiniMap:ShowArea(0,0,0,40000)	
	end)
end

local require = GLOBAL.require
local GetWorld = GLOBAL.GetWorld

local function PositionMiniMap(controls, screensize)
	local hudscale = controls.top_root:GetScale()
	local screenw_full, screenh_full = GLOBAL.unpack(screensize)
	local screenw = screenw_full/hudscale.x
	local screenh = screenh_full/hudscale.y
	if MinimapOn then
		controls.minimap_small:SetPosition(
			(anchor_horiz*controls.minimap_small.mapsize.w/2)+(dir_horiz*screenw/2)+(margin_dir_horiz*margin_size_x), 
			(anchor_vert*controls.minimap_small.mapsize.h/2)+(dir_vert*screenh/2)+(margin_dir_vert*margin_size_y), 
			0
		)
	end
end

local function AddMiniMap( inst )

	-- for some reason, without this the game would crash without an error when calling controls.topright_root:AddChild
	-- too lazy to track down the cause, so just using this workaround
	inst:DoTaskInTime( 0, function() 

		-- add the minimap widget and set its position
		local MiniMapWidget = require "widgets/minimapwidget"

		local controls = inst.HUD.controls
		controls.minimap_small = controls.top_root:AddChild( MiniMapWidget( mapscale ) )
		local screensize = {TheSim:GetScreenSize()}
		PositionMiniMap(controls, screensize)

		local OnUpdate_base = controls.OnUpdate
		controls.OnUpdate = function(self, dt)
			OnUpdate_base(self, dt)
			local curscreensize = {TheSim:GetScreenSize()}
			if curscreensize[1] ~= screensize[1] or curscreensize[2] ~= screensize[2] then
				PositionMiniMap(controls, curscreensize)
				screensize = curscreensize
			end
		end

		-- show and hide the minimap whenever the map gets toggled
		local ToggleMap_base = controls.ToggleMap
		controls.ToggleMap = function( self )
			local wasvisible = controls.minimap_small:IsVisible()

			if wasvisible then
				controls.minimap_small:Hide()
			end

			ToggleMap_base( self )

			if not wasvisible then
				controls.minimap_small:Show()
			end
		end

		-- special case: ToggleMap gets bypassed when the map gets hidden while on the map screen
		local MapScreen = require "screens/mapscreen"

		MapScreen_OnControl_base = MapScreen.OnControl
		MapScreen.OnControl = function( self, control, down )
			local ret = MapScreen_OnControl_base(self, control, down)

			if ret and control == GLOBAL.CONTROL_MAP then
				controls.minimap_small:Show()
			end

			return ret
		end

		-- keep track of zooming while on the map screen
		local MapWidget = require "widgets/mapwidget"

		MapWidget_OnZoomIn_base = MapWidget.OnZoomIn
		MapWidget.OnZoomIn = function(self)
			MapWidget_OnZoomIn_base( self )
			if self.shown then
				controls.minimap_small.mapscreenzoom = math.max(0,controls.minimap_small.mapscreenzoom-1)
			end
		end

		MapWidget_OnZoomOut_base = MapWidget.OnZoomOut
		MapWidget.OnZoomOut = function(self)
			MapWidget_OnZoomOut_base( self )
			if self.shown then
				controls.minimap_small.mapscreenzoom = controls.minimap_small.mapscreenzoom+1
			end
		end

	end)

end

if MinimapOn then
	AddSimPostInit( AddMiniMap )
end

if RevealerOn then
	AddSimPostInit( revealer )
end

if ChesterOff then
	AddPrefabPostInit("crabhole", icon)
	AddPrefabPostInit("whale_bubbles", icon)
	AddPrefabPostInit("blue_mushroom", icon)
	AddPrefabPostInit("red_mushroom", icon)
	AddPrefabPostInit("green_mushroom", icon)
	AddPrefabPostInit("sharx", icon)
	AddPrefabPostInit("mandrake", icon)
	AddPrefabPostInit("swordfish", icon)
	AddPrefabPostInit("ox", icon)
	AddPrefabPostInit("ballphin", icon)
	AddPrefabPostInit("bioluminescence", icon)
	AddPrefabPostInit("hound", icon)
	AddPrefabPostInit("knightboat", icon)
	AddPrefabPostInit("livingjungletree", icon)
	AddPrefabPostInit("obsidian", icon)
	AddPrefabPostInit("seashell_beached", icon)
	AddPrefabPostInit("skeleton", icon)
	AddPrefabPostInit("volcanostaff", icon)
	AddPrefabPostInit("fishinhole", icon)
	AddPrefabPostInit("magmarock_gold", icon)
	AddPrefabPostInit("rock2", icon)
	AddPrefabPostInit("sandhill", icon)
	AddPrefabPostInit("whale_blue", icon)
	AddPrefabPostInit("whale_white", icon)
	AddPrefabPostInit("teleportato_sw_box", icon)
	AddPrefabPostInit("teleportato_sw_crank", icon)
	AddPrefabPostInit("teleportato_sw_potato", icon)
	AddPrefabPostInit("teleportato_sw_ring", icon)
	AddPrefabPostInit("chester_eyebone", icon)
	AddPrefabPostInit("packim_fishbone", icon)
end
--option chester
if ChesterOn then
	AddPrefabPostInit("chester_eyebone", icon2)
	AddPrefabPostInit("packim_fishbone", icon2)
end
--option wall
if WallOn then
	AddPrefabPostInit("sandbagsmall", icon)
	AddPrefabPostInit("wall_hay", icon)
	AddPrefabPostInit("wall_wood", icon)
	AddPrefabPostInit("wall_stone", icon)
	AddPrefabPostInit("wall_limestone", icon)
	AddPrefabPostInit("wall_ruins", icon)
		if ChesterOn then
		AddPrefabPostInit("sandbagsmall", icon2)
		AddPrefabPostInit("wall_hay", icon2)
		AddPrefabPostInit("wall_wood", icon2)
		AddPrefabPostInit("wall_stone", icon2)
		AddPrefabPostInit("wall_limestone", icon2)
		AddPrefabPostInit("wall_ruins", icon2)
	end
end
--option others
if OthersOn then
	AddPrefabPostInit("flup", icon)
	AddPrefabPostInit("solofish", icon)
	AddPrefabPostInit("jellyfish_planted", icon)
	--AddPrefabPostInit("mussel_farm", icon)
		if ChesterOn then
		AddPrefabPostInit("flup", icon2)
		AddPrefabPostInit("solofish", icon2)
		AddPrefabPostInit("jellyfish_planted", icon2)
		--AddPrefabPostInit("mussel_farm", icon2)
	end
end

AddMinimapAtlas("icon/crabhole.xml")
AddMinimapAtlas("icon/whale_bubbles.xml")
AddMinimapAtlas("icon/blue_mushroom.xml")
AddMinimapAtlas("icon/red_mushroom.xml")
AddMinimapAtlas("icon/green_mushroom.xml")
AddMinimapAtlas("icon/sharx.xml")
AddMinimapAtlas("icon/mandrake.xml")
AddMinimapAtlas("icon/swordfish.xml")
AddMinimapAtlas("icon/ox.xml")
AddMinimapAtlas("icon/ballphin.xml")
AddMinimapAtlas("icon/bioluminescence.xml")
AddMinimapAtlas("icon/hound.xml")
AddMinimapAtlas("icon/knightboat.xml")
AddMinimapAtlas("icon/livingjungletree.xml")
AddMinimapAtlas("icon/obsidian.xml")
AddMinimapAtlas("icon/seashell_beached.xml")
AddMinimapAtlas("icon/skeleton.xml")
AddMinimapAtlas("icon/volcanostaff.xml")
AddMinimapAtlas("icon/fishinhole.xml")
AddMinimapAtlas("icon/magmarock_gold.xml")
AddMinimapAtlas("icon/rock2.xml")
AddMinimapAtlas("icon/sandhill.xml")
AddMinimapAtlas("icon/whale_blue.xml")
AddMinimapAtlas("icon/whale_white.xml")
AddMinimapAtlas("icon/teleportato_sw_box.xml")
AddMinimapAtlas("icon/teleportato_sw_crank.xml")
AddMinimapAtlas("icon/teleportato_sw_potato.xml")
AddMinimapAtlas("icon/teleportato_sw_ring.xml")
--option chester
AddMinimapAtlas("icon/chester_eyebone.xml")
AddMinimapAtlas("icon/packim_fishbone.xml")
--option wall
AddMinimapAtlas("icon/sandbagsmall.xml")
AddMinimapAtlas("icon/wall_hay.xml")
AddMinimapAtlas("icon/wall_wood.xml")
AddMinimapAtlas("icon/wall_stone.xml")
AddMinimapAtlas("icon/wall_limestone.xml")
AddMinimapAtlas("icon/wall_ruins.xml")
--option others
AddMinimapAtlas("icon/flup.xml")
AddMinimapAtlas("icon/solofish.xml")
AddMinimapAtlas("icon/jellyfish_planted.xml")
--AddMinimapAtlas("icon/mussel_farm.xml")