/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.client.filter;

import java.io.IOException;
import java.nio.charset.Charset;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import org.glassfish.jersey.internal.util.Base64;

public final class HttpBasicAuthFilter
implements ClientRequestFilter {
    private final String authentication;
    private static final Charset CHARACTER_SET = Charset.forName("iso-8859-1");

    public HttpBasicAuthFilter(String username, String password) {
        this(username, password != null ? password.getBytes(CHARACTER_SET) : new byte[]{});
    }

    public HttpBasicAuthFilter(String username, byte[] password) {
        if (username == null) {
            username = "";
        }
        if (password == null) {
            password = new byte[]{};
        }
        byte[] prefix = (username + ":").getBytes(CHARACTER_SET);
        byte[] usernamePassword = new byte[prefix.length + password.length];
        System.arraycopy(prefix, 0, usernamePassword, 0, prefix.length);
        System.arraycopy(password, 0, usernamePassword, prefix.length, password.length);
        this.authentication = "Basic " + Base64.encodeAsString(usernamePassword);
    }

    @Override
    public void filter(ClientRequestContext rc) throws IOException {
        if (!rc.getHeaders().containsKey("Authorization")) {
            rc.getHeaders().add("Authorization", this.authentication);
        }
    }
}

