/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.grizzly2.httpserver;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.Principal;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriBuilder;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Response;
import org.glassfish.grizzly.http.server.TimeoutHandler;
import org.glassfish.grizzly.utils.Charsets;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.TypeLiteral;
import org.glassfish.hk2.utilities.Binder;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyRequestPropertiesDelegate;
import org.glassfish.jersey.grizzly2.httpserver.internal.LocalizationMessages;
import org.glassfish.jersey.internal.inject.ReferencingFactory;
import org.glassfish.jersey.internal.util.ExtendedLogger;
import org.glassfish.jersey.internal.util.PropertiesHelper;
import org.glassfish.jersey.internal.util.collection.Ref;
import org.glassfish.jersey.process.internal.RequestScoped;
import org.glassfish.jersey.server.ApplicationHandler;
import org.glassfish.jersey.server.ContainerException;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ContainerResponse;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.internal.ConfigHelper;
import org.glassfish.jersey.server.spi.Container;
import org.glassfish.jersey.server.spi.ContainerLifecycleListener;
import org.glassfish.jersey.server.spi.ContainerResponseWriter;
import org.glassfish.jersey.server.spi.RequestScopedInitializer;

public final class GrizzlyHttpContainer
extends HttpHandler
implements Container {
    private static final ExtendedLogger logger = new ExtendedLogger(Logger.getLogger(GrizzlyHttpContainer.class.getName()), Level.FINEST);
    private static final Type RequestTYPE = new TypeLiteral<Ref<Request>>(){}.getType();
    private static final Type ResponseTYPE = new TypeLiteral<Ref<Response>>(){}.getType();
    private boolean configSetStatusOverSendError;
    private static final CompletionHandler<Response> EMPTY_COMPLETION_HANDLER = new CompletionHandler<Response>(){

        @Override
        public void cancelled() {
        }

        @Override
        public void failed(Throwable throwable) {
        }

        @Override
        public void completed(Response result) {
        }

        @Override
        public void updated(Response result) {
        }
    };
    private volatile ApplicationHandler appHandler;
    private volatile ContainerLifecycleListener containerListener;

    GrizzlyHttpContainer(ApplicationHandler application) {
        this.appHandler = application;
        this.containerListener = ConfigHelper.getContainerLifecycleListener(application);
        this.appHandler.registerAdditionalBinders((Iterable<Binder>)new HashSet<Binder>(){
            {
                this.add(new GrizzlyBinder());
            }
        });
        this.cacheConfigSetStatusOverSendError();
    }

    @Override
    public void start() {
        super.start();
        this.containerListener.onStartup(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void service(final Request request, final Response response) {
        ResponseWriter responseWriter = new ResponseWriter(response, this.configSetStatusOverSendError);
        try {
            logger.debugLog("GrizzlyHttpContainer.service(...) started");
            URI baseUri = this.getBaseUri(request);
            ContainerRequest requestContext = new ContainerRequest(baseUri, this.getRequestUri(baseUri, request), request.getMethod().getMethodString(), this.getSecurityContext(request), new GrizzlyRequestPropertiesDelegate(request));
            requestContext.setEntityStream(request.getInputStream());
            for (String headerName : request.getHeaderNames()) {
                requestContext.headers(headerName, request.getHeaders(headerName));
            }
            requestContext.setWriter(responseWriter);
            requestContext.setRequestScopedInitializer(new RequestScopedInitializer(){

                @Override
                public void initialize(ServiceLocator locator) {
                    ((Ref)locator.getService(RequestTYPE, new Annotation[0])).set(request);
                    ((Ref)locator.getService(ResponseTYPE, new Annotation[0])).set(response);
                }
            });
            this.appHandler.handle(requestContext);
        }
        finally {
            logger.debugLog("GrizzlyHttpContainer.service(...) finished");
        }
    }

    @Override
    public ResourceConfig getConfiguration() {
        return this.appHandler.getConfiguration();
    }

    @Override
    public void reload() {
        this.reload(this.appHandler.getConfiguration());
    }

    @Override
    public void reload(ResourceConfig configuration) {
        this.containerListener.onShutdown(this);
        this.appHandler = new ApplicationHandler(configuration);
        this.appHandler.registerAdditionalBinders((Iterable<Binder>)new HashSet<Binder>(){
            {
                this.add(new GrizzlyBinder());
            }
        });
        this.containerListener = ConfigHelper.getContainerLifecycleListener(this.appHandler);
        this.containerListener.onReload(this);
        this.containerListener.onStartup(this);
        this.cacheConfigSetStatusOverSendError();
    }

    @Override
    public void destroy() {
        super.destroy();
        this.containerListener.onShutdown(this);
        this.appHandler = null;
    }

    private SecurityContext getSecurityContext(final Request request) {
        return new SecurityContext(){

            @Override
            public boolean isUserInRole(String role) {
                return false;
            }

            @Override
            public boolean isSecure() {
                return request.isSecure();
            }

            @Override
            public Principal getUserPrincipal() {
                return request.getUserPrincipal();
            }

            @Override
            public String getAuthenticationScheme() {
                return request.getAuthType();
            }
        };
    }

    private URI getBaseUri(Request request) {
        try {
            return new URI(request.getScheme(), null, request.getServerName(), request.getServerPort(), this.getBasePath(request), null, null);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    private String getBasePath(Request request) {
        String contextPath = request.getContextPath();
        if (contextPath == null || contextPath.length() == 0) {
            return "/";
        }
        if (contextPath.charAt(contextPath.length() - 1) != '/') {
            return contextPath + "/";
        }
        return contextPath;
    }

    private URI getRequestUri(URI baseUri, Request grizzlyRequest) {
        String originalUri = UriBuilder.fromPath(grizzlyRequest.getRequest().getRequestURIRef().getOriginalRequestURIBC().toString(Charsets.DEFAULT_CHARSET)).build(new Object[0]).toString();
        String queryString = grizzlyRequest.getQueryString();
        if (queryString != null) {
            originalUri = originalUri + "?" + queryString;
        }
        return baseUri.resolve(originalUri);
    }

    private void cacheConfigSetStatusOverSendError() {
        this.configSetStatusOverSendError = PropertiesHelper.getValue(this.getConfiguration().getProperties(), null, "jersey.config.server.response.setStatusOverSendError", false, Boolean.class);
    }

    private static final class ResponseWriter
    implements ContainerResponseWriter {
        private final String name;
        private final Response grizzlyResponse;
        private final boolean configSetStatusOverSendError;

        ResponseWriter(Response response, boolean configSetStatusOverSendError) {
            this.grizzlyResponse = response;
            this.configSetStatusOverSendError = configSetStatusOverSendError;
            if (logger.isDebugLoggable()) {
                this.name = "ResponseWriter {id=" + UUID.randomUUID().toString() + ", grizzlyResponse=" + this.grizzlyResponse.hashCode() + '}';
                logger.debugLog("{0} - init", this.name);
            } else {
                this.name = "ResponseWriter";
            }
        }

        public String toString() {
            return this.name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void commit() {
            try {
                if (this.grizzlyResponse.isSuspended()) {
                    this.grizzlyResponse.resume();
                }
            }
            catch (Throwable throwable) {
                logger.debugLog("{0} - commit() called", this.name);
                throw throwable;
            }
            logger.debugLog("{0} - commit() called", this.name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean suspend(long timeOut, TimeUnit timeUnit, final ContainerResponseWriter.TimeoutHandler timeoutHandler) {
            boolean bl;
            try {
                this.grizzlyResponse.suspend(timeOut, timeUnit, EMPTY_COMPLETION_HANDLER, new TimeoutHandler(){

                    @Override
                    public boolean onTimeout(Response response) {
                        if (timeoutHandler != null) {
                            timeoutHandler.onTimeout(ResponseWriter.this);
                        }
                        return false;
                    }
                });
                bl = true;
            }
            catch (IllegalStateException ex) {
                boolean bl2;
                try {
                    bl2 = false;
                }
                catch (Throwable throwable) {
                    logger.debugLog("{0} - suspend(...) called", this.name);
                    throw throwable;
                }
                logger.debugLog("{0} - suspend(...) called", this.name);
                return bl2;
            }
            logger.debugLog("{0} - suspend(...) called", this.name);
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setSuspendTimeout(long timeOut, TimeUnit timeUnit) throws IllegalStateException {
            try {
                this.grizzlyResponse.getSuspendContext().setTimeout(timeOut, timeUnit);
            }
            catch (Throwable throwable) {
                logger.debugLog("{0} - setTimeout(...) called", this.name);
                throw throwable;
            }
            logger.debugLog("{0} - setTimeout(...) called", this.name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public OutputStream writeResponseStatusAndHeaders(long contentLength, ContainerResponse context) throws ContainerException {
            OutputStream outputStream;
            try {
                Response.StatusType statusInfo = context.getStatusInfo();
                if (statusInfo.getReasonPhrase() == null) {
                    this.grizzlyResponse.setStatus(statusInfo.getStatusCode());
                } else {
                    this.grizzlyResponse.setStatus(statusInfo.getStatusCode(), statusInfo.getReasonPhrase());
                }
                this.grizzlyResponse.setContentLengthLong(contentLength);
                for (Map.Entry e : context.getStringHeaders().entrySet()) {
                    for (String value : (List)e.getValue()) {
                        this.grizzlyResponse.addHeader((String)e.getKey(), value);
                    }
                }
                outputStream = this.grizzlyResponse.getOutputStream();
            }
            catch (Throwable throwable) {
                logger.debugLog("{0} - writeResponseStatusAndHeaders() called", this.name);
                throw throwable;
            }
            logger.debugLog("{0} - writeResponseStatusAndHeaders() called", this.name);
            return outputStream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void failure(Throwable error) {
            block7: {
                try {
                    if (this.grizzlyResponse.isCommitted()) break block7;
                    try {
                        if (this.configSetStatusOverSendError) {
                            this.grizzlyResponse.reset();
                            this.grizzlyResponse.setStatus(500, "Request failed.");
                        } else {
                            this.grizzlyResponse.sendError(500, "Request failed.");
                        }
                    }
                    catch (IllegalStateException ex) {
                        logger.log(Level.FINER, "Unable to reset failed response.", ex);
                    }
                    catch (IOException ex) {
                        throw new ContainerException(LocalizationMessages.EXCEPTION_SENDING_ERROR_RESPONSE(500, "Request failed."), ex);
                    }
                }
                catch (Throwable throwable) {
                    logger.debugLog("{0} - failure(...) called", this.name);
                    this.rethrow(error);
                    throw throwable;
                }
            }
            logger.debugLog("{0} - failure(...) called", this.name);
            this.rethrow(error);
        }

        @Override
        public boolean enableResponseBuffering() {
            return true;
        }

        private void rethrow(Throwable error) {
            if (error instanceof RuntimeException) {
                throw (RuntimeException)error;
            }
            throw new ContainerException(error);
        }
    }

    private static class GrizzlyBinder
    extends AbstractBinder {
        private GrizzlyBinder() {
        }

        @Override
        protected void configure() {
            this.bindFactory(GrizzlyRequestReferencingFactory.class).to(Request.class).in(PerLookup.class);
            this.bindFactory(ReferencingFactory.referenceFactory()).to(new TypeLiteral<Ref<Request>>(){}).in(RequestScoped.class);
            this.bindFactory(GrizzlyResponseReferencingFactory.class).to(Response.class).in(PerLookup.class);
            this.bindFactory(ReferencingFactory.referenceFactory()).to(new TypeLiteral<Ref<Response>>(){}).in(RequestScoped.class);
        }
    }

    private static class GrizzlyResponseReferencingFactory
    extends ReferencingFactory<Response> {
        @Inject
        public GrizzlyResponseReferencingFactory(Provider<Ref<Response>> referenceFactory) {
            super(referenceFactory);
        }
    }

    private static class GrizzlyRequestReferencingFactory
    extends ReferencingFactory<Request> {
        @Inject
        public GrizzlyRequestReferencingFactory(Provider<Ref<Request>> referenceFactory) {
            super(referenceFactory);
        }
    }
}

