/*
 * Decompiled with CFR 0.152.
 */
package com.weishang.tool;

import java.util.Properties;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class JavaMail {
    private MimeMessage mimeMsg;
    private Session session;
    private Properties props;
    private boolean needAuth = false;
    private String username;
    private String password;
    private Multipart mp;

    public JavaMail(String smtp) {
        this.setSmtpHost(smtp);
        this.createMimeMessage();
    }

    public void setSmtpHost(String hostName) {
        System.out.println("\u8bbe\u7f6e\u7cfb\u7edf\u5c5e\u6027\uff1amail.smtp.host = " + hostName);
        if (this.props == null) {
            this.props = System.getProperties();
        }
        this.props.put("mail.smtp.host", hostName);
    }

    public boolean createMimeMessage() {
        try {
            System.out.println("\u51c6\u5907\u83b7\u53d6\u90ae\u4ef6\u4f1a\u8bdd\u5bf9\u8c61\uff01");
            this.session = Session.getDefaultInstance((Properties)this.props, null);
        }
        catch (Exception e) {
            System.err.println("\u83b7\u53d6\u90ae\u4ef6\u4f1a\u8bdd\u5bf9\u8c61\u65f6\u53d1\u751f\u9519\u8bef\uff01" + e);
            return false;
        }
        System.out.println("\u51c6\u5907\u521b\u5efaMIME\u90ae\u4ef6\u5bf9\u8c61\uff01");
        try {
            this.mimeMsg = new MimeMessage(this.session);
            this.mp = new MimeMultipart();
            return true;
        }
        catch (Exception e) {
            System.err.println("\u521b\u5efaMIME\u90ae\u4ef6\u5bf9\u8c61\u5931\u8d25\uff01" + e);
            return false;
        }
    }

    public void setNeedAuth(boolean need) {
        System.out.println("\u8bbe\u7f6esmtp\u8eab\u4efd\u8ba4\u8bc1\uff1amail.smtp.auth = " + need);
        if (this.props == null) {
            this.props = System.getProperties();
        }
        if (need) {
            this.props.put("mail.smtp.auth", "true");
        } else {
            this.props.put("mail.smtp.auth", "false");
        }
    }

    public void setNamePass(String name, String pass) {
        this.username = name;
        this.password = pass;
    }

    public boolean setSubject(String mailSubject) {
        System.out.println("\u8bbe\u7f6e\u90ae\u4ef6\u4e3b\u9898\uff01");
        try {
            this.mimeMsg.setSubject(mailSubject);
            return true;
        }
        catch (Exception e) {
            System.err.println("\u8bbe\u7f6e\u90ae\u4ef6\u4e3b\u9898\u53d1\u751f\u9519\u8bef\uff01");
            return false;
        }
    }

    public boolean setBody(String mailBody) {
        try {
            MimeBodyPart bp = new MimeBodyPart();
            bp.setContent((Object)mailBody, "text/html;charset=GBK");
            this.mp.addBodyPart((BodyPart)bp);
            return true;
        }
        catch (Exception e) {
            System.err.println("\u8bbe\u7f6e\u90ae\u4ef6\u6b63\u6587\u65f6\u53d1\u751f\u9519\u8bef\uff01" + e);
            return false;
        }
    }

    public boolean setFrom(String from) {
        System.out.println("\u8bbe\u7f6e\u53d1\u4fe1\u4eba\uff01");
        try {
            this.mimeMsg.setFrom((Address)new InternetAddress(from));
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean setTo(String to) {
        if (to == null) {
            return false;
        }
        try {
            this.mimeMsg.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)to));
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean setCopyTo(String copyto) {
        if (copyto == null) {
            return false;
        }
        try {
            this.mimeMsg.setRecipients(Message.RecipientType.CC, (Address[])InternetAddress.parse((String)copyto));
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean sendOut() {
        try {
            this.mimeMsg.setContent(this.mp);
            this.mimeMsg.saveChanges();
            System.out.println("\u6b63\u5728\u53d1\u9001\u90ae\u4ef6....");
            Session mailSession = Session.getInstance((Properties)this.props, null);
            Transport transport = mailSession.getTransport("smtp");
            transport.connect((String)this.props.get("mail.smtp.host"), this.username, this.password);
            transport.sendMessage((Message)this.mimeMsg, this.mimeMsg.getRecipients(Message.RecipientType.TO));
            transport.sendMessage((Message)this.mimeMsg, this.mimeMsg.getRecipients(Message.RecipientType.CC));
            System.out.println("\u53d1\u9001\u90ae\u4ef6\u6210\u529f\uff01");
            transport.close();
            return true;
        }
        catch (Exception e) {
            System.err.println("\u90ae\u4ef6\u53d1\u9001\u5931\u8d25\uff01" + e);
            return false;
        }
    }

    public static boolean send(String smtp, String from, String to, String subject, String content, String username, String password) {
        JavaMail theMail = new JavaMail(smtp);
        theMail.setNeedAuth(true);
        if (!theMail.setSubject(subject)) {
            return false;
        }
        if (!theMail.setBody(content)) {
            return false;
        }
        if (!theMail.setTo(to)) {
            return false;
        }
        if (!theMail.setFrom(from)) {
            return false;
        }
        theMail.setNamePass(username, password);
        return theMail.sendOut();
    }

    public static boolean sendAndCc(String smtp, String from, String to, String copyto, String subject, String content, String username, String password) {
        JavaMail theMail = new JavaMail(smtp);
        theMail.setNeedAuth(true);
        if (!theMail.setSubject(subject)) {
            return false;
        }
        if (!theMail.setBody(content)) {
            return false;
        }
        if (!theMail.setTo(to)) {
            return false;
        }
        if (!theMail.setCopyTo(copyto)) {
            return false;
        }
        if (!theMail.setFrom(from)) {
            return false;
        }
        theMail.setNamePass(username, password);
        return theMail.sendOut();
    }
}

