/*
 * Decompiled with CFR 0.152.
 */
package com.weishang.tool;

import com.weishang.tool.DbUrl;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class JdbcConnection {
    String DBDriver = DbUrl.getValue("driver");
    String ConnStr = DbUrl.getValue("url");
    Connection conn = null;
    ResultSet rs = null;
    String user = DbUrl.getValue("username");
    String password = DbUrl.getValue("pass");

    public JdbcConnection() {
        try {
            Class.forName(this.DBDriver);
        }
        catch (ClassNotFoundException e) {
            System.err.println("DBconn():" + e.getMessage());
        }
    }

    public Connection getConnection() {
        try {
            this.conn = DriverManager.getConnection(this.ConnStr, this.user, this.password);
            return this.conn;
        }
        catch (Exception e) {
            return null;
        }
    }

    public ResultSet executeQuery(String sql) {
        this.rs = null;
        try {
            this.conn = DriverManager.getConnection(this.ConnStr, this.user, this.password);
            PreparedStatement stmt = this.conn.prepareStatement(sql);
            this.rs = stmt.executeQuery();
        }
        catch (SQLException ex) {
            System.err.println("aq.executeQuery:" + ex.getMessage());
        }
        return this.rs;
    }

    public ResultSet executeQuery(String sql, Object[] args) {
        this.rs = null;
        try {
            this.conn = DriverManager.getConnection(this.ConnStr, this.user, this.password);
            PreparedStatement stmt = this.conn.prepareStatement(sql);
            int i = 0;
            while (i < args.length) {
                if (args[i] != null) {
                    stmt.setString(i + 1, args[i].toString());
                } else {
                    stmt.setString(i + 1, null);
                }
                ++i;
            }
            this.rs = stmt.executeQuery();
        }
        catch (SQLException ex) {
            System.err.println("aq.executeQuery:" + ex.getMessage());
        }
        return this.rs;
    }

    public ResultSet executeQuery(String sql, Object args) {
        this.rs = null;
        try {
            this.conn = DriverManager.getConnection(this.ConnStr, this.user, this.password);
            PreparedStatement pstmt = this.conn.prepareStatement(sql);
            pstmt.setString(1, args.toString());
            this.rs = pstmt.executeQuery();
        }
        catch (SQLException ex) {
            System.err.println("aq.executeQuery:" + ex.getMessage());
        }
        return this.rs;
    }

    public ResultSet executeQueryForLike(String sql, Object args) {
        this.rs = null;
        try {
            this.conn = DriverManager.getConnection(this.ConnStr, this.user, this.password);
            PreparedStatement pstmt = this.conn.prepareStatement(sql);
            pstmt.setString(1, "%" + args.toString() + "%");
            this.rs = pstmt.executeQuery();
        }
        catch (SQLException ex) {
            System.err.println("aq.executeQuery:" + ex.getMessage());
        }
        return this.rs;
    }

    public int executeUpdate(String sql, Object[] args) {
        int result = 0;
        try {
            this.conn = DriverManager.getConnection(this.ConnStr, this.user, this.password);
            PreparedStatement stmt = this.conn.prepareStatement(sql);
            int i = 0;
            while (i < args.length) {
                if (args[i] != null) {
                    stmt.setString(i + 1, args[i].toString());
                } else {
                    stmt.setString(i + 1, null);
                }
                ++i;
            }
            result = stmt.executeUpdate();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public int executeUpdate(String sql, Object args) {
        int result = 0;
        try {
            this.conn = DriverManager.getConnection(this.ConnStr, this.user, this.password);
            PreparedStatement stmt = this.conn.prepareStatement(sql);
            stmt.setString(1, args.toString());
            result = stmt.executeUpdate();
        }
        catch (SQLException ex) {
            System.err.println(ex.getMessage());
        }
        return result;
    }

    public int executeUpdate(String sql) {
        int result = 0;
        try {
            this.conn = DriverManager.getConnection(this.ConnStr, this.user, this.password);
            PreparedStatement stmt = this.conn.prepareStatement(sql);
            result = stmt.executeUpdate();
        }
        catch (SQLException ex) {
            System.err.println(ex.getMessage());
        }
        return result;
    }

    public Serializable insertBackId(String sql, Object[] args) {
        Serializable ret = null;
        try {
            this.conn = DriverManager.getConnection(this.ConnStr, this.user, this.password);
            PreparedStatement stmt = this.conn.prepareStatement(sql, 1);
            int i = 0;
            while (i < args.length) {
                if (args[i] != null) {
                    stmt.setString(i + 1, args[i].toString());
                } else {
                    stmt.setString(i + 1, null);
                }
                ++i;
            }
            stmt.executeUpdate();
            this.rs = stmt.getGeneratedKeys();
            if (this.rs.next()) {
                ret = (Serializable)this.rs.getObject(1);
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public void close() {
        try {
            if (this.conn != null) {
                this.conn.close();
            }
        }
        catch (Exception e) {
            System.out.print(e);
        }
        try {
            if (this.rs != null) {
                this.rs.close();
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }
}

