/*
 * Decompiled with CFR 0.152.
 */
package com.weishang.my.tool;

import com.sun.org.apache.xerces.internal.impl.xpath.regex.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.List;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtil {
    public List<String> returnStr(String str) {
        String[] tem = str.split(",");
        ArrayList<String> temList = new ArrayList<String>(Arrays.asList(tem));
        return temList;
    }

    public static boolean getOrNumber(String str) {
        Pattern pattern = Pattern.compile("[0-9]*");
        Matcher isNum = pattern.matcher(str);
        return isNum.matches();
    }

    public static String getStrByDate() {
        SimpleDateFormat format2 = new SimpleDateFormat("yyyyMMddHHmmssms");
        Date dDate = new Date();
        String time = format2.format(dDate);
        return time;
    }

    public static long hours(String firstString, String scondString) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        long days = 0L;
        try {
            Date d1 = df.parse(firstString);
            Date d2 = df.parse(scondString);
            long diff = d1.getTime() - d2.getTime();
            days = diff / 3600000L;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return days;
    }

    public static String getTimeStr() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        return df.format(new Date());
    }

    public static String getRandomString(int length) {
        String base = "0123456789";
        Random random = new Random();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < length) {
            int number = random.nextInt(base.length());
            sb.append(base.charAt(number));
            ++i;
        }
        return sb.toString();
    }

    public static String IDCardValidate(String IDStr) throws ParseException {
        String errorInfo = "";
        String[] ValCodeArr = new String[]{"1", "0", "x", "9", "8", "7", "6", "5", "4", "3", "2"};
        String[] Wi = new String[]{"7", "9", "10", "5", "8", "4", "2", "1", "6", "3", "7", "9", "10", "5", "8", "4", "2"};
        String Ai = "";
        if (IDStr.length() != 15 && IDStr.length() != 18) {
            errorInfo = "\u8eab\u4efd\u8bc1\u53f7\u7801\u957f\u5ea6\u5e94\u8be5\u4e3a15\u4f4d\u621618\u4f4d\u3002";
            return errorInfo;
        }
        if (IDStr.length() == 18) {
            Ai = IDStr.substring(0, 17);
        } else if (IDStr.length() == 15) {
            Ai = String.valueOf(IDStr.substring(0, 6)) + "19" + IDStr.substring(6, 15);
        }
        if (!StringUtil.isNumeric(Ai)) {
            errorInfo = "\u8eab\u4efd\u8bc115\u4f4d\u53f7\u7801\u90fd\u5e94\u4e3a\u6570\u5b57 ; 18\u4f4d\u53f7\u7801\u9664\u6700\u540e\u4e00\u4f4d\u5916\uff0c\u90fd\u5e94\u4e3a\u6570\u5b57\u3002";
            return errorInfo;
        }
        String strYear = Ai.substring(6, 10);
        String strMonth = Ai.substring(10, 12);
        String strDay = Ai.substring(12, 14);
        if (!StringUtil.isDate(String.valueOf(strYear) + "-" + strMonth + "-" + strDay)) {
            errorInfo = "\u8eab\u4efd\u8bc1\u751f\u65e5\u65e0\u6548\u3002";
            return errorInfo;
        }
        GregorianCalendar gc = new GregorianCalendar();
        SimpleDateFormat s = new SimpleDateFormat("yyyy-MM-dd");
        try {
            if (gc.get(1) - Integer.parseInt(strYear) > 150 || gc.getTime().getTime() - s.parse(String.valueOf(strYear) + "-" + strMonth + "-" + strDay).getTime() < 0L) {
                errorInfo = "\u8eab\u4efd\u8bc1\u751f\u65e5\u4e0d\u5728\u6709\u6548\u8303\u56f4\u3002";
                return errorInfo;
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (java.text.ParseException e) {
            e.printStackTrace();
        }
        if (Integer.parseInt(strMonth) > 12 || Integer.parseInt(strMonth) == 0) {
            errorInfo = "\u8eab\u4efd\u8bc1\u6708\u4efd\u65e0\u6548";
            return errorInfo;
        }
        if (Integer.parseInt(strDay) > 31 || Integer.parseInt(strDay) == 0) {
            errorInfo = "\u8eab\u4efd\u8bc1\u65e5\u671f\u65e0\u6548";
            return errorInfo;
        }
        Hashtable h = StringUtil.GetAreaCode();
        if (h.get(Ai.substring(0, 2)) == null) {
            errorInfo = "\u8eab\u4efd\u8bc1\u5730\u533a\u7f16\u7801\u9519\u8bef\u3002";
            return errorInfo;
        }
        int TotalmulAiWi = 0;
        int i = 0;
        while (i < 17) {
            TotalmulAiWi += Integer.parseInt(String.valueOf(Ai.charAt(i))) * Integer.parseInt(Wi[i]);
            ++i;
        }
        int modValue = TotalmulAiWi % 11;
        String strVerifyCode = ValCodeArr[modValue];
        Ai = String.valueOf(Ai) + strVerifyCode;
        if (IDStr.length() == 18) {
            if (!Ai.equals(IDStr)) {
                errorInfo = "\u8eab\u4efd\u8bc1\u65e0\u6548\uff0c\u4e0d\u662f\u5408\u6cd5\u7684\u8eab\u4efd\u8bc1\u53f7\u7801";
                return errorInfo;
            }
        } else {
            return "";
        }
        return "";
    }

    private static Hashtable GetAreaCode() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("11", "\u5317\u4eac");
        hashtable.put("12", "\u5929\u6d25");
        hashtable.put("13", "\u6cb3\u5317");
        hashtable.put("14", "\u5c71\u897f");
        hashtable.put("15", "\u5185\u8499\u53e4");
        hashtable.put("21", "\u8fbd\u5b81");
        hashtable.put("22", "\u5409\u6797");
        hashtable.put("23", "\u9ed1\u9f99\u6c5f");
        hashtable.put("31", "\u4e0a\u6d77");
        hashtable.put("32", "\u6c5f\u82cf");
        hashtable.put("33", "\u6d59\u6c5f");
        hashtable.put("34", "\u5b89\u5fbd");
        hashtable.put("35", "\u798f\u5efa");
        hashtable.put("36", "\u6c5f\u897f");
        hashtable.put("37", "\u5c71\u4e1c");
        hashtable.put("41", "\u6cb3\u5357");
        hashtable.put("42", "\u6e56\u5317");
        hashtable.put("43", "\u6e56\u5357");
        hashtable.put("44", "\u5e7f\u4e1c");
        hashtable.put("45", "\u5e7f\u897f");
        hashtable.put("46", "\u6d77\u5357");
        hashtable.put("50", "\u91cd\u5e86");
        hashtable.put("51", "\u56db\u5ddd");
        hashtable.put("52", "\u8d35\u5dde");
        hashtable.put("53", "\u4e91\u5357");
        hashtable.put("54", "\u897f\u85cf");
        hashtable.put("61", "\u9655\u897f");
        hashtable.put("62", "\u7518\u8083");
        hashtable.put("63", "\u9752\u6d77");
        hashtable.put("64", "\u5b81\u590f");
        hashtable.put("65", "\u65b0\u7586");
        hashtable.put("71", "\u53f0\u6e7e");
        hashtable.put("81", "\u9999\u6e2f");
        hashtable.put("82", "\u6fb3\u95e8");
        hashtable.put("91", "\u56fd\u5916");
        return hashtable;
    }

    private static boolean isNumeric(String str) {
        Pattern pattern = Pattern.compile("[0-9]*");
        Matcher isNum = pattern.matcher(str);
        return isNum.matches();
    }

    public static boolean isDate(String strDate) {
        Pattern pattern = Pattern.compile("^((\\d{2}(([02468][048])|([13579][26]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])))))|(\\d{2}(([02468][1235679])|([13579][01345789]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|(1[0-9])|(2[0-8]))))))(\\s(((0?[0-9])|([1-2][0-3]))\\:([0-5]?[0-9])((\\s)|(\\:([0-5]?[0-9])))))?$");
        Matcher m = pattern.matcher(strDate);
        return m.matches();
    }

    public String arrayToString(Object[] arr) {
        boolean isDuplicated = false;
        String reStr = "";
        int i = 0;
        while (i < arr.length) {
            isDuplicated = false;
            int j = i + 1;
            while (j < arr.length) {
                if (arr[j] != null && arr[i] != null && arr[j].equals(arr[i])) {
                    isDuplicated = true;
                    arr[j] = null;
                }
                ++j;
            }
            if (isDuplicated) {
                arr[i] = null;
            }
            ++i;
        }
        i = 0;
        while (i < arr.length) {
            if (arr[i] != null) {
                reStr = String.valueOf(reStr) + arr[i].toString() + ",";
            }
            ++i;
        }
        if (reStr.length() > 0) {
            reStr = reStr.substring(0, reStr.length() - 1);
        }
        return reStr;
    }
}

