/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONAware;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONStreamAware;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.DefaultExtJSONParser;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.JavaBeanMapping;
import com.alibaba.fastjson.parser.SymbolTable;
import com.alibaba.fastjson.parser.TypeUtils;
import com.alibaba.fastjson.parser.UTF8Decoder;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.JSONSerializerMap;
import com.alibaba.fastjson.serializer.SerializeWriter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.visitor.DefaultJSONOutputVisitor;
import com.alibaba.fastjson.visitor.DefaultJavaBeanHandler;
import com.alibaba.fastjson.visitor.JSONPrettyFormatOutputVisitor;
import com.alibaba.fastjson.visitor.JavaBeanHandler;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JSON
implements JSONStreamAware,
JSONAware {
    public static final int DEFAULT_PARSER_FEATURE;
    public static final int DEFAULT_GENERATE_FEATURE;
    private static final SymbolTable symbolTable;
    public static CharsetDecoder UTF8_CharsetEncoder;
    private static final ThreadLocal<char[]> charsBufLocal;
    private static final int CHARS_CACH_SIZE = 4096;

    public static final SymbolTable getGlobalSymbolTable() {
        return symbolTable;
    }

    public static final Object parse(String text) {
        return JSON.parse(text, DEFAULT_PARSER_FEATURE);
    }

    public static final Object parse(String text, int features) {
        if (text == null) {
            return null;
        }
        DefaultJSONParser parser = new DefaultJSONParser(text, JSON.getGlobalSymbolTable(), features);
        Object value = parser.parse();
        parser.close();
        return value;
    }

    public static final Object parse(byte[] input, Feature ... features) {
        return JSON.parse(input, 0, input.length, UTF8_CharsetEncoder, features);
    }

    public static final Object parse(byte[] input, int off, int len, CharsetDecoder charsetDecoder, Feature ... features) {
        int featureValues = DEFAULT_PARSER_FEATURE;
        for (Feature featrue : features) {
            featureValues = Feature.config(featureValues, featrue, true);
        }
        return JSON.parse(input, off, len, charsetDecoder, featureValues);
    }

    public static final Object parse(byte[] input, int off, int len, CharsetDecoder charsetDecoder, int features) {
        char[] chars;
        charsetDecoder.reset();
        int scaleLength = (int)((double)len * (double)charsetDecoder.maxCharsPerByte());
        if (scaleLength > 4096) {
            chars = new char[scaleLength];
        } else {
            char[] localCharsBuf = charsBufLocal.get();
            if (localCharsBuf == null) {
                chars = new char[4096];
                charsBufLocal.set(chars);
            } else {
                chars = localCharsBuf;
            }
        }
        ByteBuffer byteBuf = ByteBuffer.wrap(input, off, len);
        CharBuffer charByte = CharBuffer.wrap(chars);
        try {
            CoderResult cr = charsetDecoder.decode(byteBuf, charByte, true);
            if (!cr.isUnderflow()) {
                cr.throwException();
            }
            if (!(cr = charsetDecoder.flush(charByte)).isUnderflow()) {
                cr.throwException();
            }
        }
        catch (CharacterCodingException x) {
            throw new Error(x);
        }
        int position = charByte.position();
        DefaultJSONParser parser = new DefaultJSONParser(chars, position, JSON.getGlobalSymbolTable(), features);
        Object value = parser.parse();
        parser.close();
        return value;
    }

    public static final Object parse(String text, Feature ... features) {
        int featureValues = DEFAULT_PARSER_FEATURE;
        for (Feature featrue : features) {
            featureValues = Feature.config(featureValues, featrue, true);
        }
        return JSON.parse(text, featureValues);
    }

    public static final JSONObject parseObject(String text, Feature ... features) {
        return (JSONObject)JSON.parse(text, features);
    }

    public static final JSONObject parseObject(String text) {
        return (JSONObject)JSON.parse(text);
    }

    public static final <T> T parseObject(String text, TypeReference<T> type, Feature ... features) {
        return JSON.parseObject(text, type.getType(), features);
    }

    public static final <T> T parseObject(String text, Class<T> clazz, Feature ... features) {
        return JSON.parseObject(text, clazz, features);
    }

    public static final <T> T parseObject(String input, Type clazz, Feature ... features) {
        if (input == null) {
            return null;
        }
        int featureValues = DEFAULT_PARSER_FEATURE;
        for (Feature featrue : features) {
            featureValues = Feature.config(featureValues, featrue, true);
        }
        DefaultExtJSONParser parser = new DefaultExtJSONParser(input, JSON.getGlobalSymbolTable(), featureValues);
        Object value = parser.parseObject(clazz);
        if (clazz != JSONArray.class) {
            parser.close();
        }
        return value;
    }

    public static final <T> T parseObject(byte[] input, Type clazz, Feature ... features) {
        return JSON.parseObject(input, 0, input.length, UTF8_CharsetEncoder, clazz, features);
    }

    public static final <T> T parseObject(byte[] input, int off, int len, CharsetDecoder charsetDecoder, Type clazz, Feature ... features) {
        char[] chars;
        charsetDecoder.reset();
        int scaleLength = (int)((double)len * (double)charsetDecoder.maxCharsPerByte());
        if (scaleLength > 4096) {
            chars = new char[scaleLength];
        } else {
            char[] localCharsBuf = charsBufLocal.get();
            if (localCharsBuf == null) {
                chars = new char[4096];
                charsBufLocal.set(chars);
            } else {
                chars = localCharsBuf;
            }
        }
        ByteBuffer byteBuf = ByteBuffer.wrap(input, off, len);
        CharBuffer charByte = CharBuffer.wrap(chars);
        try {
            CoderResult cr = charsetDecoder.decode(byteBuf, charByte, true);
            if (!cr.isUnderflow()) {
                cr.throwException();
            }
            if (!(cr = charsetDecoder.flush(charByte)).isUnderflow()) {
                cr.throwException();
            }
        }
        catch (CharacterCodingException x) {
            throw new Error(x);
        }
        int position = charByte.position();
        return JSON.parseObject(chars, position, clazz, features);
    }

    public static final <T> T parseObject(char[] input, int length, Type clazz, Feature ... features) {
        if (input == null || input.length == 0) {
            return null;
        }
        int featureValues = DEFAULT_PARSER_FEATURE;
        for (Feature featrue : features) {
            featureValues = Feature.config(featureValues, featrue, true);
        }
        DefaultExtJSONParser parser = new DefaultExtJSONParser(input, length, JSON.getGlobalSymbolTable(), featureValues);
        Object value = parser.parseObject(clazz);
        if (clazz != JSONArray.class) {
            parser.close();
        }
        return value;
    }

    public static final <T> T parseObject(String text, Class<T> clazz) {
        return JSON.parseObject(text, clazz, new Feature[0]);
    }

    public static final JSONArray parseArray(String text) {
        return (JSONArray)JSON.parse(text);
    }

    public static final <T> List<T> parseArray(String text, Class<T> clazz) {
        if (text == null) {
            return null;
        }
        ArrayList list = new ArrayList();
        DefaultExtJSONParser parser = new DefaultExtJSONParser(text, JSON.getGlobalSymbolTable());
        parser.parseArray(clazz, list);
        parser.close();
        return list;
    }

    public static final String toJSONString(Object object) {
        SerializeWriter out = new SerializeWriter();
        try {
            JSONSerializer serializer = new JSONSerializer(out);
            serializer.write(object);
            String string = out.toString();
            return string;
        }
        catch (StackOverflowError e) {
            throw new JSONException("maybe circular references", e);
        }
        finally {
            out.close();
        }
    }

    public static final String toJSONString(Object object, SerializerFeature ... features) {
        SerializeWriter out = new SerializeWriter();
        try {
            JSONSerializer serializer = new JSONSerializer(out);
            for (SerializerFeature feature : features) {
                serializer.config(feature, true);
            }
            serializer.write(object);
            String string = out.toString();
            return string;
        }
        catch (StackOverflowError e) {
            throw new JSONException("maybe circular references", e);
        }
        finally {
            out.close();
        }
    }

    public static final String toJSONString(Object object, JSONSerializerMap mapping, SerializerFeature ... features) {
        SerializeWriter out = new SerializeWriter();
        try {
            JSONSerializer serializer = new JSONSerializer(out, mapping);
            for (SerializerFeature feature : features) {
                serializer.config(feature, true);
            }
            serializer.write(object);
            String string = out.toString();
            return string;
        }
        catch (StackOverflowError e) {
            throw new JSONException("maybe circular references", e);
        }
        finally {
            out.close();
        }
    }

    public static final String toJSONString(Object object, boolean prettyFormat) {
        if (!prettyFormat) {
            return JSON.toJSONString(object);
        }
        return JSON.toJSONString(object, DefaultJavaBeanHandler.getInstance(), prettyFormat);
    }

    public static final String toJSONString(Object object, JavaBeanHandler javaBeanHandler) {
        return JSON.toJSONString(object, javaBeanHandler, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String toJSONString(Object object, JavaBeanHandler javaBeanHandler, boolean prettyFormat) {
        SerializeWriter out = new SerializeWriter();
        try {
            DefaultJSONOutputVisitor visitor = prettyFormat ? new JSONPrettyFormatOutputVisitor(out) : new DefaultJSONOutputVisitor(out);
            visitor.setJavaBeanHandler(javaBeanHandler);
            visitor.accept(object);
            String string = out.toString();
            return string;
        }
        finally {
            out.close();
        }
    }

    public String toString() {
        return this.toJSONString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toJSONString() {
        SerializeWriter out = new SerializeWriter();
        try {
            new JSONSerializer(out).write(this);
            String string = out.toString();
            return string;
        }
        finally {
            out.close();
        }
    }

    @Override
    public void writeJSONString(Appendable out) {
        if (out instanceof SerializeWriter) {
            DefaultJSONOutputVisitor visitor = new DefaultJSONOutputVisitor((SerializeWriter)out);
            visitor.accept(this);
        } else {
            SerializeWriter writer = new SerializeWriter();
            try {
                DefaultJSONOutputVisitor visitor = new DefaultJSONOutputVisitor(writer);
                visitor.accept(this);
                if (out instanceof Writer) {
                    writer.writeTo((Writer)out);
                } else {
                    out.append(writer.toString());
                }
            }
            catch (IOException ex) {
                throw new JSONException(ex.getMessage(), ex);
            }
            finally {
                writer.close();
            }
        }
    }

    public static final Object toJSON(Object javaObject) {
        return JSON.toJSON(javaObject, JavaBeanMapping.getGlobalInstance());
    }

    public static final Object toJSON(Object javaObject, JavaBeanMapping mapping) {
        if (javaObject == null) {
            return null;
        }
        if (javaObject instanceof JSON) {
            return (JSON)javaObject;
        }
        if (javaObject instanceof Map) {
            Map map = (Map)javaObject;
            JSONObject json = new JSONObject(map.size());
            for (Map.Entry entry : map.entrySet()) {
                Object jsonValue = JSON.toJSON(entry.getValue());
                json.put((String)entry.getKey(), jsonValue);
            }
            return json;
        }
        if (javaObject instanceof Collection) {
            Collection collection = (Collection)javaObject;
            JSONArray array = new JSONArray(collection.size());
            for (Object item : collection) {
                Object jsonValue = JSON.toJSON(item);
                array.add(jsonValue);
            }
            return array;
        }
        Class<?> clazz = javaObject.getClass();
        if (clazz.isArray()) {
            int len = Array.getLength(javaObject);
            JSONArray array = new JSONArray(len);
            for (int i = 0; i < len; ++i) {
                Object item = Array.get(javaObject, i);
                Object jsonValue = JSON.toJSON(item);
                array.add(jsonValue);
            }
            return array;
        }
        if (mapping.isPrimitive(clazz)) {
            return javaObject;
        }
        try {
            Map<String, Method> getters = mapping.getGetters(clazz);
            JSONObject json = new JSONObject(getters.size());
            for (Map.Entry<String, Method> getter : getters.entrySet()) {
                String key = getter.getKey();
                Method method = getter.getValue();
                Object value = method.invoke(javaObject, new Object[0]);
                Object jsonValue = JSON.toJSON(value);
                json.put(key, jsonValue);
            }
            return json;
        }
        catch (Exception e) {
            throw new JSONException("toJSON error", e);
        }
    }

    public static final <T> T toJavaObject(JSON json, Class<T> clazz) {
        return TypeUtils.cast((Object)json, clazz, JavaBeanMapping.getGlobalInstance());
    }

    static {
        int features = 0;
        features |= Feature.AutoCloseSource.getMask();
        features |= Feature.InternFieldNames.getMask();
        features |= Feature.UseBigDecimal.getMask();
        features |= Feature.AllowUnQuotedFieldNames.getMask();
        features |= Feature.AllowSingleQuotes.getMask();
        features |= Feature.AllowArbitraryCommas.getMask();
        DEFAULT_PARSER_FEATURE = features |= Feature.SortFeidFastMatch.getMask();
        features = 0;
        features |= SerializerFeature.QuoteFieldNames.getMask();
        features |= SerializerFeature.SkipTransientField.getMask();
        DEFAULT_GENERATE_FEATURE = features |= SerializerFeature.SortField.getMask();
        symbolTable = new SymbolTable();
        UTF8_CharsetEncoder = new UTF8Decoder();
        charsBufLocal = new ThreadLocal();
    }
}

