/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.parser;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.parser.deserializer.ASMDeserializerFactory;
import com.alibaba.fastjson.parser.deserializer.ASMJavaBeanDeserializer;
import com.alibaba.fastjson.parser.deserializer.AppendableDeserializer;
import com.alibaba.fastjson.parser.deserializer.ArrayDeserializer;
import com.alibaba.fastjson.parser.deserializer.ArrayListDeserializer;
import com.alibaba.fastjson.parser.deserializer.ArrayListStringDeserializer;
import com.alibaba.fastjson.parser.deserializer.ArrayListStringFieldDeserializer;
import com.alibaba.fastjson.parser.deserializer.ArrayListTypeDeserializer;
import com.alibaba.fastjson.parser.deserializer.ArrayListTypeFieldDeserializer;
import com.alibaba.fastjson.parser.deserializer.BigDecimalDeserializer;
import com.alibaba.fastjson.parser.deserializer.BigIntegerDeserializer;
import com.alibaba.fastjson.parser.deserializer.BooleanDeserializer;
import com.alibaba.fastjson.parser.deserializer.BooleanFieldDeserializer;
import com.alibaba.fastjson.parser.deserializer.ByteDeserializer;
import com.alibaba.fastjson.parser.deserializer.CharacterDeserializer;
import com.alibaba.fastjson.parser.deserializer.CharsetDeserializer;
import com.alibaba.fastjson.parser.deserializer.ConcurrentHashMapDeserializer;
import com.alibaba.fastjson.parser.deserializer.DateDeserializer;
import com.alibaba.fastjson.parser.deserializer.DefaultFieldDeserializer;
import com.alibaba.fastjson.parser.deserializer.DefaultObjectDeserializer;
import com.alibaba.fastjson.parser.deserializer.DoubleDeserializer;
import com.alibaba.fastjson.parser.deserializer.EnumDeserializer;
import com.alibaba.fastjson.parser.deserializer.FieldDeserializer;
import com.alibaba.fastjson.parser.deserializer.FileDeserializer;
import com.alibaba.fastjson.parser.deserializer.FloatDeserializer;
import com.alibaba.fastjson.parser.deserializer.HashMapDeserializer;
import com.alibaba.fastjson.parser.deserializer.InetAddressDeserializer;
import com.alibaba.fastjson.parser.deserializer.InetSocketAddressDeserializer;
import com.alibaba.fastjson.parser.deserializer.IntegerDeserializer;
import com.alibaba.fastjson.parser.deserializer.IntegerFieldDeserializer;
import com.alibaba.fastjson.parser.deserializer.JSONArrayDeserializer;
import com.alibaba.fastjson.parser.deserializer.JSONObjectDeserializer;
import com.alibaba.fastjson.parser.deserializer.JavaBeanDeserializer;
import com.alibaba.fastjson.parser.deserializer.JavaObjectDeserializer;
import com.alibaba.fastjson.parser.deserializer.LinkedHashMapDeserializer;
import com.alibaba.fastjson.parser.deserializer.LocaleDeserializer;
import com.alibaba.fastjson.parser.deserializer.LongDeserializer;
import com.alibaba.fastjson.parser.deserializer.LongFieldDeserializer;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.parser.deserializer.PatternDeserializer;
import com.alibaba.fastjson.parser.deserializer.ShortDeserializer;
import com.alibaba.fastjson.parser.deserializer.SqlDateDeserializer;
import com.alibaba.fastjson.parser.deserializer.StringDeserializer;
import com.alibaba.fastjson.parser.deserializer.StringFieldDeserializer;
import com.alibaba.fastjson.parser.deserializer.ThrowableDeserializer;
import com.alibaba.fastjson.parser.deserializer.TimeZoneDeserializer;
import com.alibaba.fastjson.parser.deserializer.TimestampDeserializer;
import com.alibaba.fastjson.parser.deserializer.TreeMapDeserializer;
import com.alibaba.fastjson.parser.deserializer.URIDeserializer;
import com.alibaba.fastjson.parser.deserializer.URLDeserializer;
import com.alibaba.fastjson.parser.deserializer.UUIDDeserializer;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaBeanMapping {
    private final Set<Class<?>> primitiveClasses = new HashSet();
    private final ConcurrentMap<Class<?>, Map<String, Method>> gettersMap = new ConcurrentHashMap();
    private final ConcurrentMap<Class<?>, Map<Integer, Enum>> enumValues = new ConcurrentHashMap();
    private static JavaBeanMapping global = new JavaBeanMapping();
    private final Map<Type, ObjectDeserializer> derializers = new IdentityHashMap<Type, ObjectDeserializer>();
    private DefaultObjectDeserializer defaultSerializer = new DefaultObjectDeserializer();
    private boolean asmEnable = true;

    public static JavaBeanMapping getGlobalInstance() {
        return global;
    }

    public JavaBeanMapping() {
        this.primitiveClasses.add(Boolean.TYPE);
        this.primitiveClasses.add(Boolean.class);
        this.primitiveClasses.add(Character.TYPE);
        this.primitiveClasses.add(Character.class);
        this.primitiveClasses.add(Byte.TYPE);
        this.primitiveClasses.add(Byte.class);
        this.primitiveClasses.add(Short.TYPE);
        this.primitiveClasses.add(Short.class);
        this.primitiveClasses.add(Integer.TYPE);
        this.primitiveClasses.add(Integer.class);
        this.primitiveClasses.add(Long.TYPE);
        this.primitiveClasses.add(Long.class);
        this.primitiveClasses.add(Float.TYPE);
        this.primitiveClasses.add(Float.class);
        this.primitiveClasses.add(Double.TYPE);
        this.primitiveClasses.add(Double.class);
        this.primitiveClasses.add(BigInteger.class);
        this.primitiveClasses.add(BigDecimal.class);
        this.primitiveClasses.add(String.class);
        this.primitiveClasses.add(Date.class);
        this.primitiveClasses.add(java.sql.Date.class);
        this.primitiveClasses.add(Time.class);
        this.primitiveClasses.add(Timestamp.class);
        this.derializers.put((Type)((Object)Timestamp.class), TimestampDeserializer.instance);
        this.derializers.put((Type)((Object)java.sql.Date.class), SqlDateDeserializer.instance);
        this.derializers.put((Type)((Object)Date.class), DateDeserializer.instance);
        this.derializers.put((Type)((Object)JSONObject.class), JSONObjectDeserializer.instance);
        this.derializers.put((Type)((Object)JSONArray.class), JSONArrayDeserializer.instance);
        this.derializers.put((Type)((Object)Map.class), HashMapDeserializer.instance);
        this.derializers.put((Type)((Object)HashMap.class), HashMapDeserializer.instance);
        this.derializers.put((Type)((Object)LinkedHashMap.class), LinkedHashMapDeserializer.instance);
        this.derializers.put((Type)((Object)TreeMap.class), TreeMapDeserializer.instance);
        this.derializers.put((Type)((Object)ConcurrentMap.class), ConcurrentHashMapDeserializer.instance);
        this.derializers.put((Type)((Object)ConcurrentHashMap.class), ConcurrentHashMapDeserializer.instance);
        this.derializers.put((Type)((Object)Collection.class), ArrayListDeserializer.instance);
        this.derializers.put((Type)((Object)List.class), ArrayListDeserializer.instance);
        this.derializers.put((Type)((Object)ArrayList.class), ArrayListDeserializer.instance);
        this.derializers.put((Type)((Object)Object.class), JavaObjectDeserializer.instance);
        this.derializers.put((Type)((Object)String.class), StringDeserializer.instance);
        this.derializers.put(Character.TYPE, CharacterDeserializer.instance);
        this.derializers.put((Type)((Object)Character.class), CharacterDeserializer.instance);
        this.derializers.put(Byte.TYPE, ByteDeserializer.instance);
        this.derializers.put((Type)((Object)Byte.class), ByteDeserializer.instance);
        this.derializers.put(Short.TYPE, ShortDeserializer.instance);
        this.derializers.put((Type)((Object)Short.class), ShortDeserializer.instance);
        this.derializers.put(Integer.TYPE, IntegerDeserializer.instance);
        this.derializers.put((Type)((Object)Integer.class), IntegerDeserializer.instance);
        this.derializers.put(Long.TYPE, LongDeserializer.instance);
        this.derializers.put((Type)((Object)Long.class), LongDeserializer.instance);
        this.derializers.put((Type)((Object)BigInteger.class), BigIntegerDeserializer.instance);
        this.derializers.put((Type)((Object)BigDecimal.class), BigDecimalDeserializer.instance);
        this.derializers.put(Float.TYPE, FloatDeserializer.instance);
        this.derializers.put((Type)((Object)Float.class), FloatDeserializer.instance);
        this.derializers.put(Double.TYPE, DoubleDeserializer.instance);
        this.derializers.put((Type)((Object)Double.class), DoubleDeserializer.instance);
        this.derializers.put(Boolean.TYPE, BooleanDeserializer.instance);
        this.derializers.put((Type)((Object)Boolean.class), BooleanDeserializer.instance);
        this.derializers.put((Type)((Object)UUID.class), UUIDDeserializer.instance);
        this.derializers.put((Type)((Object)TimeZone.class), TimeZoneDeserializer.instance);
        this.derializers.put((Type)((Object)Locale.class), LocaleDeserializer.instance);
        this.derializers.put((Type)((Object)InetAddress.class), InetAddressDeserializer.instance);
        this.derializers.put((Type)((Object)Inet4Address.class), InetAddressDeserializer.instance);
        this.derializers.put((Type)((Object)Inet6Address.class), InetAddressDeserializer.instance);
        this.derializers.put((Type)((Object)InetSocketAddress.class), InetSocketAddressDeserializer.instance);
        this.derializers.put((Type)((Object)File.class), FileDeserializer.instance);
        this.derializers.put((Type)((Object)URI.class), URIDeserializer.instance);
        this.derializers.put((Type)((Object)URL.class), URLDeserializer.instance);
        this.derializers.put((Type)((Object)Appendable.class), AppendableDeserializer.instance);
        this.derializers.put((Type)((Object)StringBuilder.class), AppendableDeserializer.instance);
        this.derializers.put((Type)((Object)StringBuffer.class), AppendableDeserializer.instance);
        this.derializers.put((Type)((Object)Pattern.class), PatternDeserializer.instance);
        this.derializers.put((Type)((Object)Charset.class), CharsetDeserializer.instance);
    }

    public boolean isAsmEnable() {
        return this.asmEnable;
    }

    public void setAsmEnable(boolean asmEnable) {
        this.asmEnable = asmEnable;
    }

    public Map<Type, ObjectDeserializer> getDerializers() {
        return this.derializers;
    }

    public ObjectDeserializer getDeserializer(Type type) {
        ObjectDeserializer derializer = this.derializers.get(type);
        if (derializer != null) {
            return derializer;
        }
        try {
            Type rawType;
            if (type instanceof Class) {
                Class clazz = (Class)type;
                if (clazz.isEnum()) {
                    derializer = new EnumDeserializer(clazz);
                } else {
                    if (clazz.isArray()) {
                        return ArrayDeserializer.instance;
                    }
                    if (Throwable.class.isAssignableFrom(clazz)) {
                        derializer = new ThrowableDeserializer(this, clazz);
                    } else {
                        if (Appendable.class.isAssignableFrom(clazz)) {
                            return AppendableDeserializer.instance;
                        }
                        derializer = this.createJavaBeanDeserializer(clazz);
                    }
                }
                this.putDeserializer(type, derializer);
                return derializer;
            }
            if (type instanceof ParameterizedType && ((rawType = ((ParameterizedType)type).getRawType()) == Collection.class || rawType == List.class || rawType == ArrayList.class)) {
                Type itemType = ((ParameterizedType)type).getActualTypeArguments()[0];
                derializer = itemType == String.class ? ArrayListStringDeserializer.instance : new ArrayListTypeDeserializer(itemType);
                this.putDeserializer(type, derializer);
                return derializer;
            }
            return this.defaultSerializer;
        }
        catch (JSONException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new JSONException(e.getMessage(), e);
        }
    }

    private ObjectDeserializer createJavaBeanDeserializer(Class<?> clazz) {
        if (clazz == Class.class) {
            return this.defaultSerializer;
        }
        if (!this.asmEnable) {
            return new JavaBeanDeserializer(this, clazz);
        }
        try {
            return ASMDeserializerFactory.getInstance().createJavaBeanDeserializer(this, clazz);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return new JavaBeanDeserializer(this, clazz);
        }
    }

    public FieldDeserializer createFieldDeserializer(JavaBeanMapping mapping, Class<?> clazz, Method method) {
        if (!this.asmEnable) {
            return this.createFieldDeserializerWithoutASM(mapping, clazz, method);
        }
        try {
            return ASMDeserializerFactory.getInstance().createFieldDeserializer(mapping, clazz, method);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return this.createFieldDeserializerWithoutASM(mapping, clazz, method);
        }
    }

    public FieldDeserializer createFieldDeserializerWithoutASM(JavaBeanMapping mapping, Class<?> clazz, Method method) {
        Type fieldType;
        Class<?> fieldClass = method.getParameterTypes()[0];
        if (fieldClass == Boolean.TYPE || fieldClass == Boolean.class) {
            return new BooleanFieldDeserializer(mapping, clazz, method);
        }
        if (fieldClass == Integer.TYPE || fieldClass == Integer.class) {
            return new IntegerFieldDeserializer(mapping, clazz, method);
        }
        if (fieldClass == Long.TYPE || fieldClass == Long.class) {
            return new LongFieldDeserializer(mapping, clazz, method);
        }
        if (fieldClass == String.class) {
            return new StringFieldDeserializer(mapping, clazz, method);
        }
        if ((fieldClass == List.class || fieldClass == ArrayList.class) && (fieldType = method.getGenericParameterTypes()[0]) instanceof ParameterizedType) {
            Type itemType = ((ParameterizedType)fieldType).getActualTypeArguments()[0];
            if (itemType == String.class) {
                return new ArrayListStringFieldDeserializer(mapping, clazz, method);
            }
            return new ArrayListTypeFieldDeserializer(mapping, clazz, method);
        }
        return new DefaultFieldDeserializer(mapping, clazz, method);
    }

    public void putDeserializer(Type type, ObjectDeserializer deserializer) {
        this.derializers.put(type, deserializer);
    }

    public ObjectDeserializer getDeserializer(Class<?> clazz, Type type) {
        ObjectDeserializer derializer = this.derializers.get(type);
        if (derializer != null) {
            return derializer;
        }
        try {
            if (clazz.isEnum()) {
                derializer = new EnumDeserializer(clazz);
            } else if (clazz == Collection.class || clazz == List.class || clazz == ArrayList.class) {
                Type itemType;
                derializer = type instanceof ParameterizedType ? ((itemType = ((ParameterizedType)type).getActualTypeArguments()[0]) == String.class ? ArrayListStringDeserializer.instance : new ArrayListTypeDeserializer(itemType)) : ArrayListDeserializer.instance;
            } else {
                if (clazz.isArray()) {
                    return ArrayDeserializer.instance;
                }
                if (Throwable.class.isAssignableFrom(clazz)) {
                    derializer = new ThrowableDeserializer(this, clazz);
                } else {
                    if (Appendable.class.isAssignableFrom(clazz)) {
                        return AppendableDeserializer.instance;
                    }
                    derializer = this.createJavaBeanDeserializer(clazz);
                }
            }
            if (derializer == null) {
                derializer = this.defaultSerializer;
            }
            this.putDeserializer(type, derializer);
            return derializer;
        }
        catch (JSONException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new JSONException(e.getMessage(), e);
        }
    }

    public boolean isPrimitive(Class<?> clazz) {
        return this.primitiveClasses.contains(clazz);
    }

    public void clear() {
        this.enumValues.clear();
    }

    public ConcurrentMap<Class<?>, Map<Integer, Enum>> getEnumValues() {
        return this.enumValues;
    }

    public Map<String, Method> getGetters(Class<?> clazz) {
        return this.getGetters(clazz, null);
    }

    public Map<String, Method> getGetters(Class<?> clazz, Map<String, String> aliasMap) {
        HashMap<String, Method> getters = (HashMap<String, Method>)this.gettersMap.get(clazz);
        if (getters != null) {
            return getters;
        }
        getters = new HashMap<String, Method>();
        for (Method method : clazz.getMethods()) {
            JSONField fieldAnnotation;
            Field field;
            String propertyName;
            String methodName = method.getName();
            if (Modifier.isStatic(method.getModifiers()) || method.getReturnType().equals(Void.TYPE) || method.getParameterTypes().length != 0) continue;
            JSONField annotation = method.getAnnotation(JSONField.class);
            if (annotation != null) {
                if (!annotation.serialize()) continue;
                if (annotation.name().length() != 0) {
                    propertyName = annotation.name();
                    if (aliasMap != null && (propertyName = aliasMap.get(propertyName)) == null) continue;
                    getters.put(propertyName, method);
                    continue;
                }
            }
            if (methodName.startsWith("get")) {
                if (methodName.length() < 4 || methodName.equals("getClass") || !Character.isUpperCase(methodName.charAt(3))) continue;
                propertyName = Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4);
                field = JavaBeanMapping.getField(clazz, propertyName);
                if (field != null) {
                    if (Modifier.isTransient(field.getModifiers())) continue;
                    fieldAnnotation = field.getAnnotation(JSONField.class);
                    if (fieldAnnotation != null && fieldAnnotation.name().length() != 0) {
                        propertyName = fieldAnnotation.name();
                        if (aliasMap != null && (propertyName = aliasMap.get(propertyName)) == null) continue;
                        getters.put(propertyName, method);
                        continue;
                    }
                }
                if (aliasMap != null && (propertyName = aliasMap.get(propertyName)) == null) continue;
                getters.put(propertyName, method);
            }
            if (!methodName.startsWith("is") || methodName.length() < 3 || !Character.isUpperCase(methodName.charAt(2))) continue;
            propertyName = Character.toLowerCase(methodName.charAt(2)) + methodName.substring(3);
            field = JavaBeanMapping.getField(clazz, propertyName);
            if (field != null && (fieldAnnotation = field.getAnnotation(JSONField.class)) != null && fieldAnnotation.name().length() != 0) {
                propertyName = fieldAnnotation.name();
                if (aliasMap != null && (propertyName = aliasMap.get(propertyName)) == null) continue;
                getters.put(propertyName, method);
                continue;
            }
            if (aliasMap != null && (propertyName = aliasMap.get(propertyName)) == null) continue;
            getters.put(propertyName, method);
        }
        this.gettersMap.putIfAbsent(clazz, getters);
        return (Map)this.gettersMap.get(clazz);
    }

    public static Field getField(Class<?> clazz, String fieldName) {
        try {
            return clazz.getDeclaredField(fieldName);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Map<String, Method> getSetters(Class<?> clazz) {
        return this.getSetters(clazz, null);
    }

    public Map<String, Method> getSetters(Class<?> clazz, Map<String, String> aliasMap) {
        ObjectDeserializer deserizer = this.getDeserializer(clazz);
        if (deserizer instanceof JavaBeanDeserializer) {
            return ((JavaBeanDeserializer)deserizer).getSetters();
        }
        if (deserizer instanceof ASMJavaBeanDeserializer) {
            return ((ASMJavaBeanDeserializer)deserizer).getInnterSerializer().getSetters();
        }
        return Collections.emptyMap();
    }
}

