/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.parser.deserializer;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.parser.DefaultExtJSONParser;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.JSONLexer;
import com.alibaba.fastjson.parser.JavaBeanMapping;
import com.alibaba.fastjson.parser.deserializer.FieldDeserializer;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayListTypeFieldDeserializer
extends FieldDeserializer {
    private final Type itemType;
    private final int itemFastMatchToken;
    private final ObjectDeserializer deserializer;

    public ArrayListTypeFieldDeserializer(JavaBeanMapping mapping, Class<?> clazz, Method method) {
        super(clazz, method);
        this.itemType = ((ParameterizedType)this.fieldType).getActualTypeArguments()[0];
        this.deserializer = mapping.getDeserializer(this.itemType);
        this.itemFastMatchToken = this.deserializer.getFastMatchToken();
    }

    @Override
    public int getFastMatchToken() {
        return 14;
    }

    @Override
    public void parseField(DefaultExtJSONParser parser, Object object) {
        ArrayList list = new ArrayList();
        this.parseArray(parser, list);
        this.setValue(object, list);
    }

    public final void parseArray(DefaultExtJSONParser parser, Collection array) {
        JSONLexer lexer = parser.getLexer();
        if (lexer.token() != 14) {
            throw new JSONException("exepct '[', but " + lexer.token());
        }
        lexer.nextToken(this.itemFastMatchToken);
        while (true) {
            if (lexer.isEnabled(Feature.AllowArbitraryCommas)) {
                while (lexer.token() == 16) {
                    lexer.nextToken();
                }
            }
            if (lexer.token() == 15) break;
            Object val = this.deserializer.deserialze(parser, this.itemType);
            array.add(val);
            if (lexer.token() != 16) continue;
            lexer.nextToken(this.itemFastMatchToken);
        }
        if (lexer.token() != 15) {
            throw new JSONException("exepct ']', but " + lexer.token());
        }
        lexer.nextToken(16);
    }
}

