/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.parser.deserializer;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.DefaultExtJSONParser;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.JSONScanner;
import com.alibaba.fastjson.parser.deserializer.ArrayListDeserializer;
import com.alibaba.fastjson.parser.deserializer.IntegerDeserializer;
import com.alibaba.fastjson.parser.deserializer.LongDeserializer;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.parser.deserializer.StringDeserializer;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultObjectDeserializer
implements ObjectDeserializer {
    public void parseMap(DefaultExtJSONParser parser, Map<String, Object> map, Type valueType) {
        JSONScanner lexer = (JSONScanner)parser.getLexer();
        if (lexer.token() != 12) {
            throw new JSONException("syntax error, expect {, actual " + lexer.token());
        }
        do {
            Object value;
            String key;
            lexer.skipWhitespace();
            char ch = lexer.getCurrent();
            if (parser.isEnabled(Feature.AllowArbitraryCommas)) {
                while (ch == ',') {
                    lexer.incrementBufferPosition();
                    lexer.skipWhitespace();
                    ch = lexer.getCurrent();
                }
            }
            if (ch == '\"') {
                key = lexer.scanSymbol(parser.getSymbolTable(), '\"');
                lexer.skipWhitespace();
                ch = lexer.getCurrent();
                if (ch != ':') {
                    throw new JSONException("expect ':' at " + lexer.pos());
                }
            } else {
                if (ch == '}') {
                    lexer.incrementBufferPosition();
                    lexer.resetStringPosition();
                    return;
                }
                if (ch == '\'') {
                    if (!parser.isEnabled(Feature.AllowSingleQuotes)) {
                        throw new JSONException("syntax error");
                    }
                    key = lexer.scanSymbol(parser.getSymbolTable(), '\'');
                    lexer.skipWhitespace();
                    ch = lexer.getCurrent();
                    if (ch != ':') {
                        throw new JSONException("expect ':' at " + lexer.pos());
                    }
                } else {
                    if (!parser.isEnabled(Feature.AllowUnQuotedFieldNames)) {
                        throw new JSONException("syntax error");
                    }
                    key = lexer.scanSymbolUnQuoted(parser.getSymbolTable());
                    lexer.skipWhitespace();
                    ch = lexer.getCurrent();
                    if (ch != ':') {
                        throw new JSONException("expect ':' at " + lexer.pos() + ", actual " + ch);
                    }
                }
            }
            lexer.incrementBufferPosition();
            lexer.skipWhitespace();
            ch = lexer.getCurrent();
            lexer.resetStringPosition();
            lexer.nextToken();
            if (lexer.token() == 8) {
                value = null;
                lexer.nextToken();
            } else {
                value = parser.parseObject(valueType);
            }
            map.put(key, value);
        } while (lexer.token() != 13);
        lexer.nextToken();
    }

    public void parseObject(DefaultExtJSONParser parser, Object object) {
        JSONScanner lexer;
        block19: {
            Class<?> clazz = object.getClass();
            Map<String, Method> setters = parser.getMapping().getSetters(clazz);
            lexer = (JSONScanner)parser.getLexer();
            if (lexer.token() != 12) {
                throw new JSONException("syntax error, expect {, actual " + lexer.token());
            }
            Object[] args = new Object[1];
            while (true) {
                Method method;
                String key;
                if ((key = lexer.scanSymbol(parser.getSymbolTable())) == null) {
                    if (lexer.token() != 13) {
                        if (lexer.token() == 16 && parser.isEnabled(Feature.AllowArbitraryCommas)) continue;
                    }
                    break block19;
                }
                if ((method = setters.get(key)) == null) {
                    if (!parser.isIgnoreNotMatch()) {
                        throw new JSONException("setter not found, class " + clazz.getName() + ", property " + key);
                    }
                    lexer.nextTokenWithColon();
                    parser.parse();
                    if (lexer.token() != 13) continue;
                    lexer.nextToken();
                    return;
                }
                Class<?> fieldClass = method.getParameterTypes()[0];
                Type fieldType = method.getGenericParameterTypes()[0];
                if (fieldClass == Integer.TYPE) {
                    lexer.nextTokenWithColon(2);
                    args[0] = IntegerDeserializer.deserialze(parser);
                } else if (fieldClass == String.class) {
                    lexer.nextTokenWithColon(4);
                    args[0] = StringDeserializer.deserialze(parser);
                } else if (fieldClass == Long.TYPE) {
                    lexer.nextTokenWithColon(2);
                    args[0] = LongDeserializer.deserialze(parser);
                } else if (fieldClass == List.class) {
                    lexer.nextTokenWithColon(12);
                    args[0] = ArrayListDeserializer.instance.deserialze(parser, fieldType);
                } else {
                    ObjectDeserializer fieldValueDeserializer = parser.getMapping().getDeserializer(fieldClass, fieldType);
                    if (fieldValueDeserializer != null) {
                        lexer.nextTokenWithColon(fieldValueDeserializer.getFastMatchToken());
                        args[0] = fieldValueDeserializer.deserialze(parser, fieldType);
                    } else {
                        lexer.nextTokenWithColon(12);
                        args[0] = parser.parseObject(fieldType);
                        if (lexer.token() == 16) continue;
                        if (lexer.token() == 13) {
                            lexer.nextToken(20);
                            return;
                        }
                    }
                }
                try {
                    method.invoke(object, args);
                }
                catch (Exception e) {
                    throw new JSONException("set proprety error, " + method.getName(), e);
                }
                if (lexer.token() != 16 && lexer.token() == 13) break;
            }
            lexer.nextToken(16);
            return;
        }
        lexer.nextToken(16);
    }

    @Override
    public <T> T deserialze(DefaultExtJSONParser parser, Type type) {
        if (type instanceof Class) {
            return this.deserialze(parser, (Class)type);
        }
        if (type instanceof ParameterizedType) {
            return this.deserialze(parser, (ParameterizedType)type);
        }
        if (type instanceof TypeVariable) {
            return (T)parser.parse();
        }
        throw new JSONException("not support type : " + type);
    }

    public <T> T deserialze(DefaultExtJSONParser parser, ParameterizedType type) {
        try {
            Type rawType = type.getRawType();
            if (rawType instanceof Class) {
                Class rawClass = (Class)rawType;
                if (Map.class.isAssignableFrom(rawClass)) {
                    Map<Object, Object> map = rawClass == Map.class ? new HashMap() : (rawClass == SortedMap.class ? new TreeMap() : (rawClass == HashMap.class ? new HashMap() : (rawClass == LinkedHashMap.class ? new LinkedHashMap() : (rawClass == ConcurrentMap.class ? new ConcurrentHashMap() : (rawClass == ConcurrentHashMap.class ? new ConcurrentHashMap() : (rawClass == JSONObject.class ? new JSONObject() : (Map)rawClass.newInstance()))))));
                    Type valueType = type.getActualTypeArguments()[1];
                    this.parseMap(parser, map, valueType);
                    return (T)map;
                }
                if (Collection.class.isAssignableFrom(rawClass)) {
                    Collection<Object> collection = rawClass == Collection.class ? new ArrayList() : (rawClass == List.class ? new ArrayList() : (rawClass == AbstractCollection.class ? new ArrayList() : (rawClass == ArrayList.class ? new ArrayList() : (rawClass == CopyOnWriteArrayList.class ? new ArrayList() : (rawClass == JSONArray.class ? new JSONArray() : (Collection)rawClass.newInstance())))));
                    Type valueType = null;
                    if (type.getActualTypeArguments().length > 0) {
                        valueType = type.getActualTypeArguments()[0];
                    }
                    parser.parseArray(valueType, collection);
                    return (T)collection;
                }
            }
            throw new JSONException("not support type : " + type);
        }
        catch (JSONException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new JSONException(e.getMessage(), e);
        }
    }

    public <T> T deserialze(DefaultExtJSONParser parser, Class<T> clazz) {
        try {
            T value = clazz.newInstance();
            this.parseObject(parser, value);
            return value;
        }
        catch (JSONException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new JSONException(e.getMessage(), e);
        }
    }

    @Override
    public int getFastMatchToken() {
        return 12;
    }
}

