/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.parser.deserializer;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.parser.DefaultExtJSONParser;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.JSONScanner;
import com.alibaba.fastjson.parser.JSONToken;
import com.alibaba.fastjson.parser.JavaBeanMapping;
import com.alibaba.fastjson.parser.deserializer.FieldDeserializer;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaBeanDeserializer
implements ObjectDeserializer {
    private final JavaBeanMapping mapping;
    private final Map<String, FieldDeserializer> setters = new IdentityHashMap<String, FieldDeserializer>();
    private final List<FieldDeserializer> fieldDeserializers = new ArrayList<FieldDeserializer>();
    private final SetterMap settersMap;
    private final Class<?> clazz;

    public JavaBeanDeserializer(JavaBeanMapping mapping, Class<?> clazz) {
        this(mapping, clazz, null);
    }

    public JavaBeanMapping getMapping() {
        return this.mapping;
    }

    public Map<String, Method> getSetters() {
        return this.settersMap;
    }

    public Map<String, FieldDeserializer> getFieldDeserializerMap() {
        return this.setters;
    }

    public List<FieldDeserializer> getFieldDeserializers() {
        return this.fieldDeserializers;
    }

    public JavaBeanDeserializer(JavaBeanMapping mapping, Class<?> clazz, Map<String, String> aliasMap) {
        this.mapping = mapping;
        this.clazz = clazz;
        for (Method method : clazz.getMethods()) {
            String propertyName;
            String methodName = method.getName();
            if (methodName.length() < 4 || Modifier.isStatic(method.getModifiers()) || !method.getReturnType().equals(Void.TYPE) || method.getParameterTypes().length != 1) continue;
            JSONField annotation = method.getAnnotation(JSONField.class);
            if (annotation != null) {
                if (!annotation.deserialize()) continue;
                if (annotation.name().length() != 0) {
                    propertyName = annotation.name();
                    this.addFieldDeserializer(mapping, clazz, method, propertyName);
                    method.setAccessible(true);
                    continue;
                }
            }
            if (!methodName.startsWith("set") || !Character.isUpperCase(methodName.charAt(3))) continue;
            propertyName = Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4);
            Field field = JavaBeanDeserializer.getField(clazz, propertyName);
            if (field != null) {
                if (Modifier.isTransient(field.getModifiers())) continue;
                JSONField fieldAnnotation = field.getAnnotation(JSONField.class);
                if (fieldAnnotation != null && fieldAnnotation.name().length() != 0) {
                    propertyName = fieldAnnotation.name();
                    if (aliasMap != null && (propertyName = aliasMap.get(propertyName)) == null) continue;
                    this.addFieldDeserializer(mapping, clazz, method, propertyName);
                    continue;
                }
            }
            this.addFieldDeserializer(mapping, clazz, method, propertyName);
            method.setAccessible(true);
        }
        this.settersMap = new SetterMap();
    }

    private void addFieldDeserializer(JavaBeanMapping mapping, Class<?> clazz, Method method, String propertyName) {
        FieldDeserializer fieldDeserializer = this.createFieldDeserializer(mapping, clazz, method);
        fieldDeserializer.setFieldName(propertyName);
        this.setters.put(propertyName.intern(), this.createFieldDeserializer(mapping, clazz, method));
        this.fieldDeserializers.add(fieldDeserializer);
    }

    public FieldDeserializer createFieldDeserializer(JavaBeanMapping mapping, Class<?> clazz, Method method) {
        return mapping.createFieldDeserializer(mapping, clazz, method);
    }

    public static Field getField(Class<?> clazz, String fieldName) {
        try {
            return clazz.getDeclaredField(fieldName);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Object createInstance(DefaultExtJSONParser parser, Type type) {
        Object object;
        try {
            object = this.clazz.newInstance();
        }
        catch (Exception e) {
            throw new JSONException("create instance error, class " + this.clazz.getName(), e);
        }
        return object;
    }

    @Override
    public <T> T deserialze(DefaultExtJSONParser parser, Type type) {
        JSONScanner lexer;
        Object object;
        block6: {
            object = this.createInstance(parser, type);
            lexer = (JSONScanner)parser.getLexer();
            if (lexer.token() != 12) {
                throw new JSONException("syntax error, expect {, actual " + JSONToken.name(lexer.token()));
            }
            while (true) {
                boolean match;
                String key;
                if ((key = lexer.scanSymbol(parser.getSymbolTable())) == null) {
                    if (lexer.token() != 13) {
                        if (lexer.token() == 16 && parser.isEnabled(Feature.AllowArbitraryCommas)) continue;
                    }
                    break block6;
                }
                if (!(match = this.parseField(parser, key, object))) {
                    if (lexer.token() != 13) continue;
                    lexer.nextToken();
                    return (T)object;
                }
                if (lexer.token() == 16) continue;
                if (lexer.token() == 13) {
                    lexer.nextToken(16);
                    return (T)object;
                }
                if (lexer.token() == 18 || lexer.token() == 1) break;
            }
            throw new JSONException("syntax error, unexpect token " + JSONToken.name(lexer.token()));
        }
        lexer.nextToken(16);
        return (T)object;
    }

    public boolean parseField(DefaultExtJSONParser parser, String key, Object object) {
        JSONScanner lexer = (JSONScanner)parser.getLexer();
        FieldDeserializer fieldDeserializer = this.setters.get(key);
        if (fieldDeserializer == null) {
            if (!parser.isIgnoreNotMatch()) {
                throw new JSONException("setter not found, class " + this.clazz.getName() + ", property " + key);
            }
            lexer.nextTokenWithColon();
            parser.parse();
            return false;
        }
        lexer.nextTokenWithColon(fieldDeserializer.getFastMatchToken());
        fieldDeserializer.parseField(parser, object);
        return true;
    }

    @Override
    public int getFastMatchToken() {
        return 12;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SetterMap
    implements Map<String, Method> {
        private SetterMap() {
        }

        @Override
        public int size() {
            return JavaBeanDeserializer.this.setters.size();
        }

        @Override
        public boolean isEmpty() {
            return JavaBeanDeserializer.this.setters.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return JavaBeanDeserializer.this.setters.containsKey(((String)key).intern());
        }

        @Override
        public boolean containsValue(Object value) {
            for (FieldDeserializer item : JavaBeanDeserializer.this.setters.values()) {
                if (!item.getMethod().equals(value)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Method get(Object key) {
            FieldDeserializer deserializer = (FieldDeserializer)JavaBeanDeserializer.this.setters.get(((String)key).intern());
            if (deserializer == null) {
                return null;
            }
            return deserializer.getMethod();
        }

        @Override
        public Method put(String key, Method method) {
            FieldDeserializer deserializer = JavaBeanDeserializer.this.setters.put(key.intern(), JavaBeanDeserializer.this.createFieldDeserializer(JavaBeanDeserializer.this.mapping, JavaBeanDeserializer.this.clazz, method));
            if (deserializer == null) {
                return null;
            }
            return deserializer.getMethod();
        }

        @Override
        public Method remove(Object key) {
            FieldDeserializer deserializer = (FieldDeserializer)JavaBeanDeserializer.this.setters.remove(((String)key).intern());
            if (deserializer == null) {
                return null;
            }
            return deserializer.getMethod();
        }

        @Override
        public void putAll(Map<? extends String, ? extends Method> m) {
            for (Map.Entry<? extends String, ? extends Method> item : m.entrySet()) {
                this.put(item.getKey(), item.getValue());
            }
        }

        @Override
        public void clear() {
            JavaBeanDeserializer.this.setters.clear();
        }

        @Override
        public Set<String> keySet() {
            return JavaBeanDeserializer.this.setters.keySet();
        }

        @Override
        public Collection<Method> values() {
            ArrayList<Method> methods = new ArrayList<Method>();
            for (FieldDeserializer deserializer : JavaBeanDeserializer.this.setters.values()) {
                methods.add(deserializer.getMethod());
            }
            return methods;
        }

        @Override
        public Set<Map.Entry<String, Method>> entrySet() {
            HashMap map = new HashMap();
            for (Map.Entry entry : JavaBeanDeserializer.this.setters.entrySet()) {
                map.put(entry.getKey(), ((FieldDeserializer)entry.getValue()).getMethod());
            }
            return Collections.unmodifiableMap(map).entrySet();
        }
    }
}

