/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.serializer;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.parser.JavaBeanMapping;
import com.alibaba.fastjson.serializer.BooleanFieldSerializer;
import com.alibaba.fastjson.serializer.ByteArrayFieldSerializer;
import com.alibaba.fastjson.serializer.ByteFieldSerializer;
import com.alibaba.fastjson.serializer.CharacterFieldSerializer;
import com.alibaba.fastjson.serializer.CollectionFieldSerializer;
import com.alibaba.fastjson.serializer.DateFieldSerializer;
import com.alibaba.fastjson.serializer.DoubleFieldSerializer;
import com.alibaba.fastjson.serializer.FieldSerializer;
import com.alibaba.fastjson.serializer.FilterUtils;
import com.alibaba.fastjson.serializer.FloatFieldSerializer;
import com.alibaba.fastjson.serializer.IntegerFieldSerializer;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.ListFieldSerializer;
import com.alibaba.fastjson.serializer.LongFieldSerializer;
import com.alibaba.fastjson.serializer.NumberFieldSerializer;
import com.alibaba.fastjson.serializer.ObjectFieldSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeWriter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.serializer.ShortFieldSerializer;
import com.alibaba.fastjson.serializer.StringFieldSerializer;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaBeanSerializer
implements ObjectSerializer {
    private final FieldSerializer[] getters;
    protected boolean writeClass = false;

    public FieldSerializer[] getGetters() {
        return this.getters;
    }

    public JavaBeanSerializer(Class<?> clazz) {
        this(clazz, (Map<String, String>)null);
    }

    public JavaBeanSerializer(Class<?> clazz, String ... aliasList) {
        this(clazz, JavaBeanSerializer.createAliasMap(aliasList));
    }

    static Map<String, String> createAliasMap(String ... aliasList) {
        HashMap<String, String> aliasMap = new HashMap<String, String>();
        for (String alias : aliasList) {
            aliasMap.put(alias, alias);
        }
        return aliasMap;
    }

    public JavaBeanSerializer(Class<?> clazz, Map<String, String> aliasMap) {
        ArrayList<FieldSerializer> getterList = new ArrayList<FieldSerializer>();
        for (Method method : clazz.getMethods()) {
            JSONField fieldAnnotation;
            Field field;
            String propertyName;
            String methodName = method.getName();
            if (Modifier.isStatic(method.getModifiers()) || method.getReturnType().equals(Void.TYPE) || method.getParameterTypes().length != 0) continue;
            JSONField annotation = method.getAnnotation(JSONField.class);
            if (annotation != null) {
                if (!annotation.serialize()) continue;
                if (annotation.name().length() != 0) {
                    propertyName = annotation.name();
                    if (aliasMap != null && (propertyName = aliasMap.get(propertyName)) == null) continue;
                    getterList.add(JavaBeanSerializer.createFieldSerializer(propertyName, method, null));
                    continue;
                }
            }
            if (methodName.startsWith("get")) {
                if (methodName.length() < 4 || methodName.equals("getClass") || !Character.isUpperCase(methodName.charAt(3))) continue;
                propertyName = Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4);
                field = JavaBeanMapping.getField(clazz, propertyName);
                if (field != null && (fieldAnnotation = field.getAnnotation(JSONField.class)) != null && fieldAnnotation.name().length() != 0) {
                    propertyName = fieldAnnotation.name();
                    if (aliasMap != null && (propertyName = aliasMap.get(propertyName)) == null) continue;
                }
                if (aliasMap != null && (propertyName = aliasMap.get(propertyName)) == null) continue;
                getterList.add(JavaBeanSerializer.createFieldSerializer(propertyName, method, field));
            }
            if (!methodName.startsWith("is") || methodName.length() < 3 || !Character.isUpperCase(methodName.charAt(2))) continue;
            propertyName = Character.toLowerCase(methodName.charAt(2)) + methodName.substring(3);
            field = JavaBeanMapping.getField(clazz, propertyName);
            if (field != null && (fieldAnnotation = field.getAnnotation(JSONField.class)) != null && fieldAnnotation.name().length() != 0) {
                propertyName = fieldAnnotation.name();
                if (aliasMap != null && (propertyName = aliasMap.get(propertyName)) == null) continue;
            }
            if (aliasMap != null && (propertyName = aliasMap.get(propertyName)) == null) continue;
            getterList.add(JavaBeanSerializer.createFieldSerializer(propertyName, method, field));
        }
        this.getters = getterList.toArray(new FieldSerializer[getterList.size()]);
    }

    @Override
    public void write(JSONSerializer serializer, Object object) throws IOException {
        SerializeWriter out = serializer.getWriter();
        Object[] getters = this.getters;
        if (out.isEnabled(SerializerFeature.SortField)) {
            Arrays.sort(getters);
        }
        try {
            if (getters.length == 0) {
                out.append("{}");
                return;
            }
            out.append('{');
            boolean commaFlag = false;
            if (this.writeClass) {
                out.writeFieldName("class");
                serializer.write(object.getClass());
                commaFlag = true;
            }
            for (int i = 0; i < getters.length; ++i) {
                Field field;
                Object fieldSerializer = getters[i];
                if (serializer.isEnabled(SerializerFeature.SkipTransientField) && (field = ((FieldSerializer)fieldSerializer).getField()) != null && Modifier.isTransient(field.getModifiers())) continue;
                Object propertyValue = ((FieldSerializer)fieldSerializer).getPropertyValue(object);
                if (!FilterUtils.apply(serializer, object, ((FieldSerializer)fieldSerializer).getName(), propertyValue)) continue;
                String key = FilterUtils.processKey(serializer, object, ((FieldSerializer)fieldSerializer).getName(), propertyValue);
                Object originalValue = propertyValue;
                propertyValue = FilterUtils.processValue(serializer, object, ((FieldSerializer)fieldSerializer).getName(), propertyValue);
                if (propertyValue == null && !serializer.isEnabled(SerializerFeature.WriteMapNullValue)) continue;
                if (commaFlag) {
                    out.append(',');
                }
                if (key != ((FieldSerializer)fieldSerializer).getName()) {
                    out.writeFieldName(key);
                    serializer.write(propertyValue);
                } else if (originalValue != propertyValue) {
                    ((FieldSerializer)fieldSerializer).writePrefix(serializer);
                    serializer.write(propertyValue);
                } else {
                    ((FieldSerializer)fieldSerializer).writeProperty(serializer, propertyValue);
                }
                commaFlag = true;
            }
            out.append('}');
        }
        catch (Exception e) {
            throw new JSONException("write javaBean error", e);
        }
    }

    public static FieldSerializer createFieldSerializer(String name, Method method, Field field) {
        Class<?> clazz = method.getReturnType();
        if (Boolean.TYPE == clazz || Boolean.class == clazz) {
            return new BooleanFieldSerializer(name, method, field);
        }
        if (Character.TYPE == clazz || Character.class == clazz) {
            return new CharacterFieldSerializer(name, method, field);
        }
        if (Byte.TYPE == clazz || Byte.class == clazz) {
            return new ByteFieldSerializer(name, method, field);
        }
        if (Short.TYPE == clazz || Short.class == clazz) {
            return new ShortFieldSerializer(name, method, field);
        }
        if (Integer.TYPE == clazz || Integer.class == clazz) {
            return new IntegerFieldSerializer(name, method, field);
        }
        if (Long.TYPE == clazz || Long.class == clazz) {
            return new LongFieldSerializer(name, method, field);
        }
        if (Float.TYPE == clazz || Float.class == clazz) {
            return new FloatFieldSerializer(name, method, field);
        }
        if (Double.TYPE == clazz || Double.class == clazz) {
            return new DoubleFieldSerializer(name, method, field);
        }
        if (String.class == clazz) {
            return new StringFieldSerializer(name, method, field);
        }
        if (byte[].class == clazz) {
            return new ByteArrayFieldSerializer(name, method, field);
        }
        if (BigInteger.class == clazz | BigDecimal.class == clazz) {
            return new NumberFieldSerializer(name, method, field);
        }
        if (Date.class.isAssignableFrom(clazz)) {
            return new DateFieldSerializer(name, method, field);
        }
        if (List.class.isAssignableFrom(clazz)) {
            return new ListFieldSerializer(name, method, field);
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            return new CollectionFieldSerializer(name, method, field);
        }
        return new ObjectFieldSerializer(name, method, field);
    }
}

