/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.serializer;

import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class SimpleDataFormatSerializer
implements ObjectSerializer {
    private final String pattern;
    private final ThreadLocal<SimpleDateFormat> formatLocal = new ThreadLocal();

    public SimpleDataFormatSerializer(String pattern) {
        this.pattern = pattern;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void write(JSONSerializer serializer, Object object) throws IOException {
        Date date = (Date)object;
        SimpleDateFormat format = this.formatLocal.get();
        if (format == null) {
            format = new SimpleDateFormat(this.pattern);
            this.formatLocal.set(format);
        }
        String text = format.format(date);
        serializer.write(text);
    }
}

