/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.visitor;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.visitor.JSONOutputVisitor;
import com.alibaba.fastjson.visitor.JSONVisitor;
import com.alibaba.fastjson.visitor.JavaBeanHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultJavaBeanHandler
implements JavaBeanHandler {
    private ConcurrentMap<Class<?>, Map<String, Method>> gettersMap = new ConcurrentHashMap();
    private static final DefaultJavaBeanHandler instance = new DefaultJavaBeanHandler();

    public static final DefaultJavaBeanHandler getInstance() {
        return instance;
    }

    @Override
    public void handle(Object javaBean, JSONVisitor visitor) {
        Class<?> clazz = javaBean.getClass();
        this.init(clazz);
        JSONOutputVisitor outputVisitor = (JSONOutputVisitor)visitor;
        outputVisitor.print('{');
        outputVisitor.incrementIndent();
        boolean first = true;
        Map<String, Method> getters = this.getGetters(clazz);
        for (Map.Entry<String, Method> getter : getters.entrySet()) {
            try {
                String name = getter.getKey();
                Object value = getter.getValue().invoke(javaBean, new Object[0]);
                if (value instanceof Date) {
                    value = ((Date)value).getTime();
                }
                if (value == null && outputVisitor.isIgnoreNull()) continue;
                if (!first) {
                    outputVisitor.print(',');
                    outputVisitor.println();
                } else {
                    outputVisitor.println();
                }
                visitor.acceptEntry(new SimpleEntry(name, value));
            }
            catch (Throwable e) {
                throw new JSONException("output error, class : " + clazz.getName());
            }
            first = false;
        }
        outputVisitor.decementIndent();
        outputVisitor.println();
        outputVisitor.print('}');
    }

    public Map<String, Method> getGetters(Class<?> clazz) {
        return (Map)this.gettersMap.get(clazz);
    }

    public void init(Class<?> clazz) {
        HashMap<String, Method> getters = (HashMap<String, Method>)this.gettersMap.get(clazz);
        if (getters == null) {
            getters = new HashMap<String, Method>();
            for (Method method : clazz.getMethods()) {
                String propertyName;
                String methodName = method.getName();
                if (Modifier.isStatic(method.getModifiers()) || method.getReturnType().equals(Void.TYPE) || method.getParameterTypes().length != 0) continue;
                JSONField annotation = method.getAnnotation(JSONField.class);
                if (annotation != null) {
                    if (!annotation.serialize()) continue;
                    if (annotation.name().length() != 0) {
                        propertyName = annotation.name();
                        getters.put(propertyName, method);
                        continue;
                    }
                }
                if (methodName.startsWith("get")) {
                    if (methodName.length() < 4 || methodName.equals("getClass") || !Character.isUpperCase(methodName.charAt(3))) continue;
                    propertyName = Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4);
                    getters.put(propertyName, method);
                }
                if (!methodName.startsWith("is") || methodName.length() < 3 || !Character.isUpperCase(methodName.charAt(2))) continue;
                propertyName = Character.toLowerCase(methodName.charAt(2)) + methodName.substring(3);
                getters.put(propertyName, method);
            }
            this.gettersMap.putIfAbsent(clazz, getters);
        }
    }

    public static class SimpleEntry
    implements Map.Entry {
        private Object key;
        private Object value;

        public SimpleEntry(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            throw new UnsupportedOperationException();
        }
    }
}

