/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.visitor;

import com.alibaba.fastjson.serializer.SerializeWriter;
import com.alibaba.fastjson.visitor.DefaultJSONOutputVisitor;
import java.util.Collection;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONPrettyFormatOutputVisitor
extends DefaultJSONOutputVisitor {
    private String indent = "\t";
    private int indentCount = 0;

    public JSONPrettyFormatOutputVisitor(SerializeWriter out) {
        super(out);
    }

    @Override
    public void incrementIndent() {
        ++this.indentCount;
    }

    @Override
    public void decementIndent() {
        --this.indentCount;
    }

    @Override
    public boolean visitArray(Collection<?> array) {
        if (array.size() == 0) {
            this.print0("[]");
            return false;
        }
        this.print('[');
        this.incrementIndent();
        this.println();
        boolean first = true;
        for (Object item : array) {
            if (!first) {
                this.print(',');
                this.println();
            }
            this.accept(item);
            first = false;
        }
        this.decementIndent();
        this.println();
        this.print(']');
        return false;
    }

    @Override
    public boolean visitArray(Object[] array) {
        if (array.length == 0) {
            this.print0("[]");
            return false;
        }
        this.print('[');
        this.incrementIndent();
        this.println();
        boolean first = true;
        for (Object item : array) {
            if (!first) {
                this.print(',');
                this.println();
            }
            this.accept(item);
            first = false;
        }
        this.decementIndent();
        this.println();
        this.print(']');
        return false;
    }

    @Override
    public boolean visitEntry(Map.Entry<?, ?> entry) {
        this.acceptKey(entry.getKey().toString());
        this.print(':');
        Object value = entry.getValue();
        if (value instanceof Collection) {
            Collection array = (Collection)value;
            if (array.size() != 0) {
                this.incrementIndent();
                this.println();
                this.accept(entry.getValue());
                this.decementIndent();
            } else {
                this.accept(entry.getValue());
            }
        } else {
            this.accept(entry.getValue());
        }
        return false;
    }

    @Override
    public boolean visitObject(Map<?, ?> map) {
        if (map.size() == 0) {
            this.print0("{}");
            return false;
        }
        this.print('{');
        boolean first = true;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (this.ignoreNull && entry.getValue() == null) continue;
            if (!first) {
                this.print(',');
                this.println();
            } else {
                this.incrementIndent();
                this.println();
            }
            this.accept(entry);
            first = false;
        }
        if (!first) {
            this.decementIndent();
            this.println();
        }
        this.print('}');
        return false;
    }

    @Override
    public void println() {
        this.print('\n');
        for (int i = 0; i < this.indentCount; ++i) {
            this.print0(this.indent);
        }
    }
}

