/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.parser.deserializer;

import com.alibaba.fastjson.parser.DefaultExtJSONParser;
import com.alibaba.fastjson.parser.JSONLexer;
import com.alibaba.fastjson.parser.JavaBeanMapping;
import com.alibaba.fastjson.parser.TypeUtils;
import com.alibaba.fastjson.parser.deserializer.FieldDeserializer;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BooleanFieldDeserializer
extends FieldDeserializer {
    public BooleanFieldDeserializer(JavaBeanMapping mapping, Class<?> clazz, Method method) {
        super(clazz, method);
    }

    @Override
    public void parseField(DefaultExtJSONParser parser, Object object) {
        JSONLexer lexer = parser.getLexer();
        if (lexer.token() == 6) {
            lexer.nextToken(16);
            this.setValue(object, true);
            return;
        }
        if (lexer.token() == 2) {
            int val = lexer.intValue();
            lexer.nextToken(16);
            if (val == 1) {
                this.setValue(object, true);
            } else {
                this.setValue(object, false);
            }
            return;
        }
        if (lexer.token() == 8) {
            Object value = null;
            lexer.nextToken(16);
            if (value == null && this.fieldClass == Boolean.TYPE) {
                return;
            }
            this.setValue(object, null);
            return;
        }
        if (lexer.token() == 7) {
            lexer.nextToken(16);
            this.setValue(object, false);
            return;
        }
        Object obj = parser.parse();
        Boolean value = TypeUtils.castToBoolean(obj);
        if (value == null && this.fieldClass == Boolean.TYPE) {
            return;
        }
        this.setValue(object, value);
    }

    @Override
    public int getFastMatchToken() {
        return 6;
    }
}

