/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.serializer;

import com.alibaba.fastjson.serializer.ASMSerializerFactory;
import com.alibaba.fastjson.serializer.AppendableSerializer;
import com.alibaba.fastjson.serializer.AtomicBooleanSerializer;
import com.alibaba.fastjson.serializer.AtomicIntegerArraySerializer;
import com.alibaba.fastjson.serializer.AtomicIntegerSerializer;
import com.alibaba.fastjson.serializer.AtomicLongArraySerializer;
import com.alibaba.fastjson.serializer.AtomicLongSerializer;
import com.alibaba.fastjson.serializer.AtomicReferenceSerializer;
import com.alibaba.fastjson.serializer.BigDecimalSerializer;
import com.alibaba.fastjson.serializer.BigIntegerSerializer;
import com.alibaba.fastjson.serializer.BooleanArraySerializer;
import com.alibaba.fastjson.serializer.BooleanSerializer;
import com.alibaba.fastjson.serializer.ByteArraySerializer;
import com.alibaba.fastjson.serializer.ByteSerializer;
import com.alibaba.fastjson.serializer.CharacterSerializer;
import com.alibaba.fastjson.serializer.CharsetSerializer;
import com.alibaba.fastjson.serializer.ClassSerializer;
import com.alibaba.fastjson.serializer.CompositeDataSerializer;
import com.alibaba.fastjson.serializer.DoubleArraySerializer;
import com.alibaba.fastjson.serializer.DoubleSerializer;
import com.alibaba.fastjson.serializer.FileSerializer;
import com.alibaba.fastjson.serializer.FloatArraySerializer;
import com.alibaba.fastjson.serializer.FloatSerializer;
import com.alibaba.fastjson.serializer.InetAddressSerializer;
import com.alibaba.fastjson.serializer.InetSocketAddressSerializer;
import com.alibaba.fastjson.serializer.IntArraySerializer;
import com.alibaba.fastjson.serializer.IntegerArraySerializer;
import com.alibaba.fastjson.serializer.IntegerSerializer;
import com.alibaba.fastjson.serializer.JavaBeanSerializer;
import com.alibaba.fastjson.serializer.LocaleSerializer;
import com.alibaba.fastjson.serializer.LongArraySerializer;
import com.alibaba.fastjson.serializer.LongSerializer;
import com.alibaba.fastjson.serializer.ObjectArraySerializer;
import com.alibaba.fastjson.serializer.ObjectNameSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.PatternSerializer;
import com.alibaba.fastjson.serializer.ShortArraySerializer;
import com.alibaba.fastjson.serializer.ShortSerializer;
import com.alibaba.fastjson.serializer.SimpleTypeSerializer;
import com.alibaba.fastjson.serializer.StringArraySerializer;
import com.alibaba.fastjson.serializer.StringSerializer;
import com.alibaba.fastjson.serializer.TabularDataSerializer;
import com.alibaba.fastjson.serializer.TimeZoneSerializer;
import com.alibaba.fastjson.serializer.URISerializer;
import com.alibaba.fastjson.serializer.URLSerializer;
import com.alibaba.fastjson.serializer.UUIDSerializer;
import java.io.File;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JSONSerializerMap {
    public static final int DEFAULT_TABLE_SIZE = 1024;
    private final Entry[] buckets;
    private final int indexMask;
    private static final JSONSerializerMap globalInstance = new JSONSerializerMap();
    private boolean asm = true;
    private final ASMSerializerFactory asmFactory = new ASMSerializerFactory();

    public final ObjectSerializer createASMSerializer(Class<?> clazz) throws Exception {
        return this.asmFactory.createJavaBeanSerializer(clazz);
    }

    public ObjectSerializer createJavaBeanSerializer(Class<?> clazz) {
        if (!Modifier.isPublic(clazz.getModifiers())) {
            return new JavaBeanSerializer(clazz);
        }
        if (this.asm) {
            try {
                return this.createASMSerializer(clazz);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return new JavaBeanSerializer(clazz);
    }

    public boolean isAsmEnable() {
        return this.asm;
    }

    public void setAsmEnable(boolean asmEnable) {
        this.asm = asmEnable;
    }

    public static final JSONSerializerMap getGlobalInstance() {
        return globalInstance;
    }

    public JSONSerializerMap() {
        this(1024);
    }

    public JSONSerializerMap(int tableSize) {
        this.indexMask = tableSize - 1;
        this.buckets = new Entry[tableSize];
        this.put(Boolean.class, BooleanSerializer.instance);
        this.put(Character.class, CharacterSerializer.instance);
        this.put(Byte.class, ByteSerializer.instance);
        this.put(Short.class, ShortSerializer.instance);
        this.put(Integer.class, IntegerSerializer.instance);
        this.put(Long.class, LongSerializer.instance);
        this.put(Float.class, FloatSerializer.instance);
        this.put(Double.class, DoubleSerializer.instance);
        this.put(BigDecimal.class, BigDecimalSerializer.instance);
        this.put(BigInteger.class, BigIntegerSerializer.instance);
        this.put(String.class, StringSerializer.instance);
        this.put(byte[].class, ByteArraySerializer.instance);
        this.put(short[].class, ShortArraySerializer.instance);
        this.put(int[].class, IntArraySerializer.instance);
        this.put(long[].class, LongArraySerializer.instance);
        this.put(float[].class, FloatArraySerializer.instance);
        this.put(double[].class, DoubleArraySerializer.instance);
        this.put(boolean[].class, BooleanArraySerializer.instance);
        this.put(Integer[].class, IntegerArraySerializer.instance);
        this.put(String[].class, StringArraySerializer.instance);
        this.put(Object[].class, ObjectArraySerializer.instance);
        this.put(Class.class, ClassSerializer.instance);
        this.put(Locale.class, LocaleSerializer.instance);
        this.put(TimeZone.class, TimeZoneSerializer.instance);
        this.put(UUID.class, UUIDSerializer.instance);
        this.put(InetAddress.class, InetAddressSerializer.instance);
        this.put(Inet4Address.class, InetAddressSerializer.instance);
        this.put(Inet6Address.class, InetAddressSerializer.instance);
        this.put(InetSocketAddress.class, InetSocketAddressSerializer.instance);
        this.put(File.class, FileSerializer.instance);
        this.put(URI.class, URISerializer.instance);
        this.put(URL.class, URLSerializer.instance);
        this.put(Appendable.class, AppendableSerializer.instance);
        this.put(StringBuffer.class, AppendableSerializer.instance);
        this.put(StringBuilder.class, AppendableSerializer.instance);
        this.put(Pattern.class, PatternSerializer.instance);
        this.put(Charset.class, CharsetSerializer.instance);
        this.put(AtomicBoolean.class, AtomicBooleanSerializer.instance);
        this.put(AtomicInteger.class, AtomicIntegerSerializer.instance);
        this.put(AtomicLong.class, AtomicLongSerializer.instance);
        this.put(AtomicReference.class, AtomicReferenceSerializer.instance);
        this.put(AtomicIntegerArray.class, AtomicIntegerArraySerializer.instance);
        this.put(AtomicLongArray.class, AtomicLongArraySerializer.instance);
        this.put(CompositeData.class, CompositeDataSerializer.instance);
        this.put(CompositeDataSupport.class, CompositeDataSerializer.instance);
        this.put(TabularData.class, TabularDataSerializer.instance);
        this.put(TabularDataSupport.class, TabularDataSerializer.instance);
        this.put(ObjectName.class, ObjectNameSerializer.instance);
        this.put(SimpleType.class, SimpleTypeSerializer.instance);
    }

    public final ObjectSerializer get(Class<?> clazz) {
        int hash = System.identityHashCode(clazz);
        int bucket = hash & this.indexMask;
        Entry entry = this.buckets[bucket];
        while (entry != null) {
            if (clazz == entry.clazz) {
                return entry.serializer;
            }
            entry = entry.next;
        }
        return null;
    }

    public final boolean put(Class<?> clazz, ObjectSerializer serializer) {
        int hash = System.identityHashCode(clazz);
        int bucket = hash & this.indexMask;
        Entry entry = this.buckets[bucket];
        while (entry != null) {
            if (clazz == entry.clazz) {
                return true;
            }
            entry = entry.next;
        }
        this.buckets[bucket] = entry = new Entry(clazz, serializer, hash, this.buckets[bucket]);
        return false;
    }

    public int size() {
        int size = 0;
        for (int i = 0; i < this.buckets.length; ++i) {
            Entry entry = this.buckets[i];
            while (entry != null) {
                ++size;
                entry = entry.next;
            }
        }
        return size;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class Entry {
        public final int hashCode;
        public final Class<?> clazz;
        public final ObjectSerializer serializer;
        public final Entry next;

        public Entry(Class<?> clazz, ObjectSerializer serializer, int hash, Entry next) {
            this.clazz = clazz;
            this.serializer = serializer;
            this.next = next;
            this.hashCode = hash;
        }
    }
}

