/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http;

import org.glassfish.grizzly.Closeable;
import org.glassfish.grizzly.OutputSink;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.attributes.AttributeBuilder;
import org.glassfish.grizzly.attributes.AttributeHolder;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.filterchain.FilterChainContext;

public class HttpContext
implements AttributeStorage {
    private static final Attribute<HttpContext> HTTP_CONTEXT_ATTR = AttributeBuilder.DEFAULT_ATTRIBUTE_BUILDER.createAttribute(HttpContext.class.getName());
    private final AttributeStorage contextStorage;
    private final OutputSink outputSink;
    private final Closeable closeable;

    protected HttpContext(AttributeStorage attributeStorage, OutputSink outputSink, Closeable closeable) {
        this.contextStorage = attributeStorage;
        this.closeable = closeable;
        this.outputSink = outputSink;
    }

    @Override
    public final AttributeHolder getAttributes() {
        return this.contextStorage.getAttributes();
    }

    public AttributeStorage getContextStorage() {
        return this.contextStorage;
    }

    public OutputSink getOutputSink() {
        return this.outputSink;
    }

    public Closeable getCloseable() {
        return this.closeable;
    }

    public void close() {
        this.closeable.close(null);
    }

    public static HttpContext newInstance(FilterChainContext ctx, AttributeStorage attributeStorage, OutputSink outputSink, Closeable closeable) {
        HttpContext context = new HttpContext(attributeStorage, outputSink, closeable);
        HTTP_CONTEXT_ATTR.set(ctx, context);
        return context;
    }

    public static HttpContext get(FilterChainContext ctx) {
        return HTTP_CONTEXT_ATTR.get(ctx);
    }
}

