/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.client;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.WriterInterceptor;
import org.glassfish.jersey.client.ClientRequest;
import org.glassfish.jersey.internal.util.collection.Value;
import org.glassfish.jersey.message.internal.InboundMessageContext;
import org.glassfish.jersey.message.internal.OutboundJaxrsResponse;
import org.glassfish.jersey.message.internal.Statuses;

public class ClientResponse
extends InboundMessageContext
implements ClientResponseContext {
    private Response.StatusType status;
    private final ClientRequest requestContext;

    public ClientResponse(final ClientRequest requestContext, final Response response) {
        this(response.getStatusInfo(), requestContext);
        this.headers(OutboundJaxrsResponse.from(response).getContext().getStringHeaders());
        final Object entity = response.getEntity();
        if (entity != null) {
            InputStream entityStream = new InputStream(){
                private ByteArrayInputStream byteArrayInputStream = null;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public int read() throws IOException {
                    if (this.byteArrayInputStream == null) {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        OutputStream stream = null;
                        try {
                            try {
                                stream = requestContext.getWorkers().writeTo(entity, entity.getClass(), null, null, response.getMediaType(), response.getMetadata(), requestContext.getPropertiesDelegate(), baos, Collections.<WriterInterceptor>emptyList());
                            }
                            finally {
                                if (stream != null) {
                                    stream.close();
                                }
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        this.byteArrayInputStream = new ByteArrayInputStream(baos.toByteArray());
                    }
                    return this.byteArrayInputStream.read();
                }
            };
            this.setEntityStream(entityStream);
        }
    }

    public ClientResponse(Response.StatusType status, ClientRequest requestContext) {
        this.status = status;
        this.requestContext = requestContext;
        final Iterable<ReaderInterceptor> readerInterceptors = requestContext.getReaderInterceptors();
        this.setWorkers(requestContext.getWorkers());
        this.setReaderInterceptors(new Value<Iterable<ReaderInterceptor>>(){

            @Override
            public Iterable<ReaderInterceptor> get() {
                return readerInterceptors;
            }
        });
    }

    @Override
    public int getStatus() {
        return this.status.getStatusCode();
    }

    @Override
    public void setStatus(int code) {
        this.status = Statuses.from(code);
    }

    @Override
    public void setStatusInfo(Response.StatusType status) {
        if (status == null) {
            throw new NullPointerException("Response status must not be 'null'");
        }
        this.status = status;
    }

    @Override
    public Response.StatusType getStatusInfo() {
        return this.status;
    }

    public ClientRequest getRequestContext() {
        return this.requestContext;
    }

    @Override
    public Map<String, NewCookie> getCookies() {
        return super.getResponseCookies();
    }

    @Override
    public Set<Link> getLinks() {
        return Sets.newHashSet(Collections2.transform(super.getLinks(), new Function<Link, Link>(){

            @Override
            public Link apply(Link link) {
                if (link.getUri().isAbsolute()) {
                    return link;
                }
                return Link.fromLink(link).baseUri(ClientResponse.this.requestContext.getUri()).build(new Object[0]);
            }
        }));
    }

    public String toString() {
        return Objects.toStringHelper(this).add("method", this.requestContext.getMethod()).add("uri", this.requestContext.getUri()).add("status", this.status.getStatusCode()).add("reason", this.status.getReasonPhrase()).toString();
    }

    public Object getEntity() throws IllegalStateException {
        return this.getEntityStream();
    }

    public <T> T readEntity(Class<T> entityType) throws ProcessingException, IllegalStateException {
        return this.readEntity(entityType, this.requestContext.getPropertiesDelegate());
    }

    public <T> T readEntity(GenericType<T> entityType) throws ProcessingException, IllegalStateException {
        return (T)this.readEntity(entityType.getRawType(), entityType.getType(), this.requestContext.getPropertiesDelegate());
    }

    public <T> T readEntity(Class<T> entityType, Annotation[] annotations) throws ProcessingException, IllegalStateException {
        return this.readEntity(entityType, annotations, this.requestContext.getPropertiesDelegate());
    }

    public <T> T readEntity(GenericType<T> entityType, Annotation[] annotations) throws ProcessingException, IllegalStateException {
        return (T)this.readEntity(entityType.getRawType(), entityType.getType(), annotations, this.requestContext.getPropertiesDelegate());
    }
}

