/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.process.internal.RequestExecutorFactory;
import org.glassfish.jersey.server.spi.Container;
import org.glassfish.jersey.server.spi.ContainerLifecycleListener;
import org.glassfish.jersey.spi.RequestExecutorProvider;

class ServerManagedAsyncExecutorFactory
extends RequestExecutorFactory
implements ContainerLifecycleListener {
    @Inject
    public ServerManagedAsyncExecutorFactory(ServiceLocator locator) {
        super(locator, new Object[0]);
    }

    @Override
    protected RequestExecutorProvider getDefaultProvider(Object ... initArgs) {
        return new RequestExecutorProvider(){

            @Override
            public ExecutorService getRequestingExecutor() {
                return Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("jersey-server-managed-async-executor-%d").build());
            }

            @Override
            public void releaseRequestingExecutor(ExecutorService executor) {
                executor.shutdownNow();
            }
        };
    }

    @Override
    public void onStartup(Container container) {
    }

    @Override
    public void onReload(Container container) {
    }

    @Override
    public void onShutdown(Container container) {
        this.close();
    }

    static class Binder
    extends AbstractBinder {
        Binder() {
        }

        @Override
        protected void configure() {
            this.bind(ServerManagedAsyncExecutorFactory.class).to(RequestExecutorFactory.class).to(ContainerLifecycleListener.class).in(Singleton.class);
        }
    }
}

