/*
 * Decompiled with CFR 0.152.
 */
package com.weishang.my.service;

import com.weishang.my.pojo.GoodsOrder;
import com.weishang.my.pojo.GoodsType;
import com.weishang.my.pojo.Store;
import com.weishang.my.service.ShopService;
import com.weishang.my.service.StatisticsService;
import com.weishang.pojo.CommonPojo;
import java.sql.SQLException;
import java.util.List;

public class ComplexService {
    ShopService shop = new ShopService();
    StatisticsService statis = new StatisticsService();

    public List<GoodsType> getGoodsTypeList(Integer pageNo, Integer pageSize) throws SQLException {
        List<GoodsType> typeList = this.shop.getGoodsType(pageNo, pageSize);
        int i = 0;
        while (i < typeList.size()) {
            Integer num = this.shop.getCountByGoodsTypeForAttribute(typeList.get(i).getId());
            typeList.get(i).setNum(num);
            ++i;
        }
        return typeList;
    }

    public List<Store> getStoreByPage(Integer pageNo, Integer pageSize) throws SQLException {
        List<Store> storeList = this.shop.getStoreByPage(pageNo, pageSize);
        int i = 0;
        while (i < storeList.size()) {
            CommonPojo cp = this.statis.getStoreUserAndMoneyByUser(storeList.get(i).getId());
            Integer usernum = cp.getId();
            String moneynum = cp.getName();
            storeList.get(i).setUserNum(usernum);
            if (moneynum != null && !moneynum.equals("null")) {
                storeList.get(i).setMoneyNum(Double.parseDouble(moneynum));
            } else {
                storeList.get(i).setMoneyNum(0.0);
            }
            ++i;
        }
        return storeList;
    }

    public List<GoodsOrder> getGoodsOrderForStore(String ids, Integer flag, Integer pageNo, Integer pageSize) throws SQLException {
        List<GoodsOrder> orderList = this.shop.getGoodsOrderForStore(ids, flag, pageNo, pageSize);
        Double sum = 0.0;
        int i = 0;
        while (i < orderList.size()) {
            GoodsOrder order = orderList.get(i);
            sum = this.statis.getOrderMoney(order.getId());
            order.setMoney(sum.toString());
            ++i;
        }
        return orderList;
    }

    public List<GoodsOrder> getGoodsOrderList(Integer pageNo, Integer pageSize, String type, String flag) throws SQLException {
        List<GoodsOrder> orderList = this.shop.getGoodsOrderList(pageNo, pageSize, type, flag);
        Double sum = 0.0;
        int i = 0;
        while (i < orderList.size()) {
            GoodsOrder order = orderList.get(i);
            sum = this.statis.getOrderMoney(order.getId());
            order.setMoney(sum.toString());
            ++i;
        }
        return orderList;
    }

    public List<GoodsOrder> getGoodsOrderListByUserForPc(Integer userId, Integer flag, Integer pageNo, Integer pageSize) throws SQLException {
        List<GoodsOrder> orderList = this.shop.getGoodsOrderListByUserForPc(userId, flag, pageNo, pageSize);
        Double sum = 0.0;
        int i = 0;
        while (i < orderList.size()) {
            GoodsOrder order = orderList.get(i);
            sum = this.statis.getOrderMoney(order.getId());
            order.setMoney(sum.toString());
            ++i;
        }
        return orderList;
    }
}

