/*
 * Decompiled with CFR 0.152.
 */
package com.weishang.my.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.weishang.my.pojo.Address;
import com.weishang.my.pojo.Aunt;
import com.weishang.my.pojo.AuntImg;
import com.weishang.my.pojo.CombineMarket;
import com.weishang.my.pojo.Comment;
import com.weishang.my.pojo.Connect;
import com.weishang.my.pojo.Coupon;
import com.weishang.my.pojo.Employee;
import com.weishang.my.pojo.EmployeeAndStore;
import com.weishang.my.pojo.GoodsAttr;
import com.weishang.my.pojo.GoodsBrand;
import com.weishang.my.pojo.GoodsCategory;
import com.weishang.my.pojo.GoodsGallery;
import com.weishang.my.pojo.GoodsOrder;
import com.weishang.my.pojo.GoodsPojo;
import com.weishang.my.pojo.GoodsType;
import com.weishang.my.pojo.GoodsTypeAttribute;
import com.weishang.my.pojo.GroupGoods;
import com.weishang.my.pojo.OrderMoneyRecord;
import com.weishang.my.pojo.Store;
import com.weishang.my.pojo.ThematicActivity;
import com.weishang.my.pojo.User;
import com.weishang.my.pojo.UserCardUser;
import com.weishang.my.tool.StringUtil;
import com.weishang.pojo.Cms;
import com.weishang.pojo.CommonPojo;
import com.weishang.tool.JdbcConnection;
import com.weishang.tool.Md5Util;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ShopService {
    JdbcConnection jdbc = new JdbcConnection();

    public String addGoodsType(String name, Integer enabled, String attr_group) {
        Object[] args = new Object[]{name, enabled, attr_group};
        String sql = "insert into goods_type (goods_type_name,goods_type_enabled,goods_type_attr_group) values(?,?,?)";
        int flag = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public String addGoodsTypeAttribute(Integer cat, String name, Integer input_type, Integer type, String values, Integer indexs, Integer order, Integer linked, String group) {
        Object[] args = new Object[]{cat, name, input_type, type, values, indexs, order, linked, group};
        String sql = "insert into goods_type_attribute (goods_type_attribute_cat,goods_type_attribute_name,goods_type_attribute_input_type,goods_type_attribute_type,goods_type_attribute_values,goods_type_attribute_index,goods_type_attribute_order,goods_type_attribute_linked,goods_type_attribute_group) values(?,?,?,?,?,?,?,?,?)";
        int flag = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public String updateAttribute(Integer attribute_id, String name, Integer input_type, Integer type, String values, Integer indexs, Integer order, Integer linked, String group) {
        Object[] args = new Object[]{name, input_type, type, values, indexs, order, linked, group, attribute_id};
        String sql = "UPDATE goods_type_attribute SET goods_type_attribute_name = ?,goods_type_attribute_input_type=?,goods_type_attribute_type=?,goods_type_attribute_values=?,goods_type_attribute_index=?,goods_type_attribute_order=?,goods_type_attribute_linked=?,goods_type_attribute_group=? where goods_type_attribute_id=?";
        int flag = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public String deleteAttribute(String ids) {
        String sql = "delete from goods_type_attribute where goods_type_attribute_id in (" + ids + ")";
        int flag = this.jdbc.executeUpdate(sql);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public List<GoodsTypeAttribute> getGoodsTypeAttribute(Integer type_id, Integer pageNo, Integer pageSize) throws SQLException {
        if (pageNo < 1) {
            pageNo = 1;
        }
        int offset = (pageNo - 1) * pageSize;
        ResultSet rs = null;
        String sql = "select g.* from goods_type_attribute g where g.goods_type_attribute_cat=? limit " + offset + "," + pageSize;
        rs = this.jdbc.executeQuery(sql, (Object)type_id);
        ArrayList<GoodsTypeAttribute> attributeList = new ArrayList<GoodsTypeAttribute>();
        GoodsTypeAttribute attribute = null;
        while (rs.next()) {
            attribute = new GoodsTypeAttribute();
            attribute.setId(rs.getInt("goods_type_attribute_id"));
            attribute.setCat(rs.getInt("goods_type_attribute_cat"));
            attribute.setName(rs.getString("goods_type_attribute_name"));
            attribute.setInput_type(rs.getInt("goods_type_attribute_input_type"));
            attribute.setType(rs.getInt("goods_type_attribute_type"));
            attribute.setValues(rs.getString("goods_type_attribute_values"));
            attribute.setIndexs(rs.getInt("goods_type_attribute_index"));
            attribute.setOrder(rs.getInt("goods_type_attribute_order"));
            attribute.setLinked(rs.getInt("goods_type_attribute_linked"));
            attribute.setGroup(rs.getString("goods_type_attribute_group"));
            attributeList.add(attribute);
        }
        this.jdbc.close();
        return attributeList;
    }

    public List<GoodsTypeAttribute> getGoodsTypeAttribute(Integer type_id) throws SQLException {
        String sql = "select g.* from goods_type_attribute g where g.goods_type_attribute_cat=? and g.goods_type_attribute_index=1";
        ResultSet rs = null;
        rs = this.jdbc.executeQuery(sql, (Object)type_id);
        ArrayList<GoodsTypeAttribute> attributeList = new ArrayList<GoodsTypeAttribute>();
        GoodsTypeAttribute attribute = null;
        while (rs.next()) {
            attribute = new GoodsTypeAttribute();
            attribute.setId(rs.getInt("goods_type_attribute_id"));
            attribute.setCat(rs.getInt("goods_type_attribute_cat"));
            attribute.setName(rs.getString("goods_type_attribute_name"));
            attribute.setInput_type(rs.getInt("goods_type_attribute_input_type"));
            attribute.setType(rs.getInt("goods_type_attribute_type"));
            attribute.setValues(rs.getString("goods_type_attribute_values"));
            attribute.setIndexs(rs.getInt("goods_type_attribute_index"));
            attribute.setOrder(rs.getInt("goods_type_attribute_order"));
            attribute.setLinked(rs.getInt("goods_type_attribute_linked"));
            attribute.setGroup(rs.getString("goods_type_attribute_group"));
            attributeList.add(attribute);
        }
        this.jdbc.close();
        return attributeList;
    }

    public Integer getCountByGoodsTypeForAttribute(Integer type_id) throws SQLException {
        int resultCount = 0;
        ResultSet rs = null;
        String sql = "select COUNT(*) AS rowcount from goods_type_attribute g where g.goods_type_attribute_cat=? ";
        rs = this.jdbc.executeQuery(sql, (Object)type_id);
        if (rs.next()) {
            resultCount = rs.getInt("rowcount");
        }
        this.jdbc.close();
        return resultCount;
    }

    public GoodsTypeAttribute getGoodsTypeAttributeById(Integer attribute_id) throws SQLException {
        ResultSet rs = null;
        String sql = "select g.* from goods_type_attribute g where g.goods_type_attribute_id=? ";
        rs = this.jdbc.executeQuery(sql, (Object)attribute_id);
        GoodsTypeAttribute attribute = null;
        while (rs.next()) {
            attribute = new GoodsTypeAttribute();
            attribute.setId(rs.getInt("goods_type_attribute_id"));
            attribute.setCat(rs.getInt("goods_type_attribute_cat"));
            attribute.setName(rs.getString("goods_type_attribute_name"));
            attribute.setInput_type(rs.getInt("goods_type_attribute_input_type"));
            attribute.setType(rs.getInt("goods_type_attribute_type"));
            attribute.setValues(rs.getString("goods_type_attribute_values"));
            attribute.setIndexs(rs.getInt("goods_type_attribute_index"));
            attribute.setOrder(rs.getInt("goods_type_attribute_order"));
            attribute.setLinked(rs.getInt("goods_type_attribute_linked"));
            attribute.setGroup(rs.getString("goods_type_attribute_group"));
        }
        this.jdbc.close();
        return attribute;
    }

    public List<GoodsType> getGoodsType(Integer pageNo, Integer pageSize) throws SQLException {
        if (pageNo < 1) {
            pageNo = 1;
        }
        int offset = (pageNo - 1) * pageSize;
        String sql = "select gt.* from goods_type gt order by gt.goods_type_id asc limit " + offset + "," + pageSize;
        ResultSet rs = this.jdbc.executeQuery(sql);
        GoodsType type = null;
        ArrayList<GoodsType> typeList = new ArrayList<GoodsType>();
        while (rs.next()) {
            type = new GoodsType();
            type.setId(rs.getInt("goods_type_id"));
            type.setName(rs.getString("goods_type_name"));
            type.setAttr_group(rs.getString("goods_type_attr_group"));
            type.setEnabled(rs.getInt("goods_type_enabled"));
            typeList.add(type);
        }
        this.jdbc.close();
        return typeList;
    }

    public Integer getGoodsTypeCount() throws SQLException {
        int resultCount = 0;
        ResultSet rs = null;
        String sql = "select COUNT(*) AS rowcount from goods_type g ";
        rs = this.jdbc.executeQuery(sql);
        if (rs.next()) {
            resultCount = rs.getInt("rowcount");
        }
        this.jdbc.close();
        return resultCount;
    }

    public GoodsType getGoodsTypeById(Integer type_id) throws SQLException {
        String sql = "select gt.* from goods_type gt where gt.goods_type_id=?";
        ResultSet rs = this.jdbc.executeQuery(sql, (Object)type_id);
        GoodsType type = null;
        if (rs.next()) {
            type = new GoodsType();
            type.setId(rs.getInt("goods_type_id"));
            type.setName(rs.getString("goods_type_name"));
            type.setAttr_group(rs.getString("goods_type_attr_group"));
            type.setEnabled(rs.getInt("goods_type_enabled"));
        }
        return type;
    }

    public String updateGoodsType(Integer type_id, String name, String grade) {
        Object[] args = new Object[]{name, grade, type_id};
        String sql = "UPDATE goods_type SET goods_type_name = ?,goods_type_attr_group=? where goods_type_id=?";
        int flag = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public String deleteGoodsType(String ids) {
        String sql = "delete from goods_type where goods_type_id in (?)";
        int flag = this.jdbc.executeUpdate(sql, (Object)ids);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public Integer getCountForDoodsByCategory(Integer category_id) throws SQLException {
        int resultCount = 0;
        ResultSet rs = null;
        String sql = "select COUNT(*) AS rowcount from goods g where g.category_id=?";
        rs = this.jdbc.executeQuery(sql, (Object)category_id);
        if (rs.next()) {
            resultCount = rs.getInt("rowcount");
        }
        this.jdbc.close();
        return resultCount;
    }

    public String addGoodsBrand(String name, String logo, String url, String desc, Integer order, Integer show) {
        Object[] args = new Object[]{name, logo, url, desc, order, show};
        String sql = "insert into goods_brand (goods_brand_name,goods_brand_logo,goods_brand_url,goods_brand_desc,goods_brand_order,goods_brand_is_show) values(?,?,?,?,?,?)";
        int flag = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public String updateGoodsBrand(String name, String logo, String url, String desc, Integer order, Integer show, Integer brand_id) {
        Object[] args = new Object[]{name, logo, url, desc, order, show, brand_id};
        String sql = "UPDATE goods_brand SET goods_brand_name = ?,goods_brand_logo=?,goods_brand_url=?,goods_brand_desc=?,goods_brand_order=?,goods_brand_is_show=? where goods_brand_id=?";
        int flag = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public List<GoodsBrand> getGoodsBrand(Integer pageNo, Integer pageSize) throws SQLException {
        if (pageNo < 1) {
            pageNo = 1;
        }
        int offset = (pageNo - 1) * pageSize;
        String sql = "select gd.* from goods_brand gd order by gd.goods_brand_order desc limit " + offset + "," + pageSize;
        ResultSet rs = this.jdbc.executeQuery(sql);
        GoodsBrand brand = null;
        ArrayList<GoodsBrand> brandList = new ArrayList<GoodsBrand>();
        while (rs.next()) {
            brand = new GoodsBrand();
            brand.setId(rs.getInt("goods_brand_id"));
            brand.setName(rs.getString("goods_brand_name"));
            brand.setLogo(rs.getString("goods_brand_logo"));
            brand.setDesc(rs.getString("goods_brand_desc"));
            brand.setUrl(rs.getString("goods_brand_url"));
            brand.setOrder(rs.getInt("goods_brand_order"));
            brand.setIs_show(rs.getInt("goods_brand_is_show"));
            brandList.add(brand);
        }
        this.jdbc.close();
        return brandList;
    }

    public Integer getGoodsBrandCount() throws SQLException {
        int resultCount = 0;
        ResultSet rs = null;
        String sql = "select COUNT(*) AS rowcount from goods_brand gb ";
        rs = this.jdbc.executeQuery(sql);
        if (rs.next()) {
            resultCount = rs.getInt("rowcount");
        }
        this.jdbc.close();
        return resultCount;
    }

    public GoodsBrand getGoodsBrandById(Integer brand_id) throws SQLException {
        String sql = "select gd.* from goods_brand gd where gd.goods_brand_id=?";
        ResultSet rs = this.jdbc.executeQuery(sql, (Object)brand_id);
        GoodsBrand brand = null;
        if (rs.next()) {
            brand = new GoodsBrand();
            brand.setId(rs.getInt("goods_brand_id"));
            brand.setName(rs.getString("goods_brand_name"));
            brand.setLogo(rs.getString("goods_brand_logo"));
            brand.setDesc(rs.getString("goods_brand_desc"));
            brand.setUrl(rs.getString("goods_brand_url"));
            brand.setOrder(rs.getInt("goods_brand_order"));
            brand.setIs_show(rs.getInt("goods_brand_is_show"));
        }
        this.jdbc.close();
        return brand;
    }

    public String deleteGoodsBrand(String ids) {
        String sql = "delete from goods_brand where goods_brand_id in (" + ids + ")";
        int flag = this.jdbc.executeUpdate(sql);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public String addGoodsCategory(String name, String title, String keywords, String desc, Integer parent, Integer order, String unit, String style, Integer filter_attr, Integer is_show, Integer template_file) {
        Object[] args = new Object[]{name, title, keywords, desc, parent, order, unit, style, filter_attr, is_show, template_file};
        String sql = "insert into goods_category (goods_category_name,goods_category_title,goods_category_keywords,goods_category_desc,goods_category_parent,goods_category_order,goods_category_measure_unit,goods_category_style,goods_category_filter_attr,goods_category_is_show,goods_category_template_file) values(?,?,?,?,?,?,?,?,?,?,?)";
        int flag = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public String updateGoodsCategory(String name, String title, String keywords, String desc, Integer order, String unit, String style, Integer filter_attr, Integer is_show, Integer type_id, Integer template_file) {
        Object[] args = new Object[]{name, title, keywords, desc, order, unit, style, filter_attr, is_show, template_file, type_id};
        String sql = "UPDATE goods_category SET goods_category_name=?,goods_category_title=?,goods_category_keywords=?,goods_category_desc=?,goods_category_order=?,goods_category_measure_unit=?,goods_category_style=?,goods_category_filter_attr=?,goods_category_is_show=?,goods_category_template_file=? where goods_category_id=?";
        int flag = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public String deleteGoodsCategory(String type_id) {
        String sql = "delete from goods_category where goods_category_id in (?)";
        int flag = this.jdbc.executeUpdate(sql, (Object)type_id);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public GoodsCategory getCategoryById(Integer cat_id) throws SQLException {
        String sql = "select gc.* from goods_category gc where gc.goods_category_id=?";
        ResultSet rs = this.jdbc.executeQuery(sql, (Object)cat_id);
        GoodsCategory category = null;
        if (rs.next()) {
            category = new GoodsCategory();
            Integer id = rs.getInt("goods_category_id");
            String name = rs.getString("goods_category_name");
            String title = rs.getString("goods_category_title");
            String keywords = rs.getString("goods_category_keywords");
            String desc = rs.getString("goods_category_desc");
            String unit = rs.getString("goods_category_measure_unit");
            String template_file = rs.getString("goods_category_template_file");
            Integer nav = rs.getInt("goods_category_show_in_nav");
            Integer show = rs.getInt("goods_category_is_show");
            String grade = rs.getString("goods_category_grade");
            Integer order = rs.getInt("goods_category_order");
            category.setId(id);
            category.setName(name);
            category.setTitle(title);
            category.setKeywords(keywords);
            category.setDesc(desc);
            category.setMeasure_unit(unit);
            category.setShow_in_nav(nav);
            category.setGrade(grade);
            category.setOrder(order);
            category.setIs_show(show);
            category.setFilter_attr(rs.getString("goods_category_filter_attr"));
            category.setTemplate_file(template_file);
        }
        this.jdbc.close();
        return category;
    }

    public boolean getOrChidren(String parent) throws SQLException {
        String sql = "select gc.goods_category_id from goods_category gc where gc.goods_category_parent=? limit 0,1";
        ResultSet rs = this.jdbc.executeQuery(sql, (Object)parent);
        if (rs.next()) {
            this.jdbc.close();
            return true;
        }
        this.jdbc.close();
        return false;
    }

    public GoodsPojo getGoodsPojoById(Integer id) throws SQLException {
        String sql = "select gd.*,gc.*,gt.*,gb.* from goods gd left join goods_brand gb on gd.brand_id=gb.goods_brand_id LEFT JOIN goods_category gc on gd.category_id=gc.goods_category_id LEFT JOIN goods_type gt on gd.goods_type=gt.goods_type_id  where gd.goods_id=?";
        ResultSet rs = this.jdbc.executeQuery(sql, (Object)id);
        GoodsPojo goods = null;
        if (rs.next()) {
            goods = new GoodsPojo();
            GoodsGallery img = null;
            GroupGoods parts = null;
            Cms article = null;
            ArrayList<GoodsGallery> imgList = new ArrayList<GoodsGallery>();
            ArrayList<GroupGoods> partsList = new ArrayList<GroupGoods>();
            ArrayList<Cms> articleList = new ArrayList<Cms>();
            GoodsCategory cat = new GoodsCategory();
            GoodsType goodsType = new GoodsType();
            goods.setGoodsId(rs.getInt("goods_id"));
            goods.setGoodsSn(rs.getString("goods_sn"));
            goods.setGoodsName(rs.getString("goods_name"));
            goods.setGoodsNameStyle(rs.getString("goods_name_style"));
            cat.setMeasure_unit(rs.getString("goods_category_measure_unit"));
            cat.setName(rs.getString("goods_category_name"));
            cat.setId(rs.getInt("goods_category_id"));
            goods.setCategory(cat);
            goods.setClickCount(rs.getInt("click_count"));
            goods.setGoodsWeight(rs.getString("goods_weight"));
            goods.setMarketPrice(rs.getString("market_price"));
            goods.setShopPrice(rs.getString("shop_price"));
            goods.setPromotePrice(rs.getString("promote_price"));
            goods.setPromoteStartDate(rs.getString("promote_start_date"));
            goods.setPromoteEndDate(rs.getString("promote_end_date"));
            goods.setGoodsNumber(rs.getInt("goods_number"));
            goods.setWarnNumber(rs.getInt("warn_number"));
            goods.setKeywords(rs.getString("keywords"));
            goods.setGoodsBrief(rs.getString("goods_brief"));
            goods.setGoodsDesc(rs.getString("goods_desc"));
            goods.setGoodsThumb(rs.getString("goods_thumb"));
            goods.setGoodsImg(rs.getString("goods_img"));
            goods.setOriginalImg(rs.getString("original_img"));
            goods.setIsReal(rs.getInt("is_real"));
            goods.setExtensionCode(rs.getString("extension_code"));
            goods.setIsOnSale(rs.getInt("is_on_sale"));
            goods.setIsShipping(rs.getInt("Is_shipping"));
            goods.setIntegral(rs.getInt("integral"));
            goods.setAddTime(rs.getString("add_time"));
            goods.setIsDelete(rs.getInt("is_delete"));
            goods.setSortOrder(rs.getInt("sort_order"));
            goods.setIsBest(rs.getInt("is_best"));
            goods.setIsNew(rs.getInt("is_new"));
            goods.setIsHot(rs.getInt("is_hot"));
            goods.setIsPromote(rs.getInt("is_promote"));
            goods.setBonusTypeId(rs.getInt("bonus_type_id"));
            goods.setLastUpdate(rs.getString("last_update"));
            goodsType.setName(rs.getString("goods_type_name"));
            goodsType.setId(rs.getInt("goods_type_id"));
            goods.setGoodsType(goodsType);
            goods.setSellerNote(rs.getString("seller_note"));
            goods.setGiveIntegral(rs.getInt("give_integral"));
            goods.setIsShelves(rs.getInt("is_shelves"));
            GoodsBrand brand = new GoodsBrand();
            brand.setId(rs.getInt("goods_brand_id"));
            brand.setName(rs.getString("goods_brand_name"));
            brand.setLogo(rs.getString("goods_brand_logo"));
            brand.setDesc(rs.getString("goods_brand_desc"));
            brand.setUrl(rs.getString("goods_brand_url"));
            brand.setOrder(rs.getInt("goods_brand_order"));
            brand.setIs_show(rs.getInt("goods_brand_is_show"));
            goods.setVipPrice(rs.getString("vip_price"));
            goods.setUserPrice(rs.getString("user_price"));
            goods.setConsPrice(rs.getString("cons_price"));
            goods.setIsFreight(rs.getInt("is_freight"));
            goods.setBrand(brand);
            GoodsAttr attr = null;
            ArrayList<GoodsAttr> attrList = new ArrayList<GoodsAttr>();
            String sqlAttr = "select a.*,gt.goods_type_attribute_name from goods_attr a,goods_type_attribute gt where a.attr_id=gt.goods_type_attribute_id and a.goods_id=?";
            ResultSet rsAttr = this.jdbc.executeQuery(sqlAttr, (Object)goods.getGoodsId());
            while (rsAttr.next()) {
                attr = new GoodsAttr();
                attr.setId(rsAttr.getInt("goods_attr_id"));
                attr.setAttr_id(rsAttr.getInt("attr_id"));
                attr.setGoods_id(rsAttr.getInt("goods_id"));
                attr.setValue(rsAttr.getString("goods_attr_value"));
                attr.setPrice(rsAttr.getString("goods_attr_price"));
                attr.setName(rsAttr.getString("goods_type_attribute_name"));
                attrList.add(attr);
            }
            goods.setAttrList(attrList);
            String sqlImg = "select img.* from goods_gallery img where img.goods_id=?";
            ResultSet rsImg = this.jdbc.executeQuery(sqlImg, (Object)goods.getGoodsId());
            while (rsImg.next()) {
                img = new GoodsGallery();
                img.setGoodsGalleryId(rsImg.getInt("goods_gallery_id"));
                img.setGoodsId(rsImg.getInt("goods_id"));
                img.setImgDesc(rsImg.getString("img_desc"));
                img.setImgOriginal(rsImg.getString("img_original"));
                img.setThumbUrl(rsImg.getString("thumb_url"));
                img.setImgUrl(rsImg.getString("img_original"));
                imgList.add(img);
            }
            goods.setImgsList(imgList);
            String sqlParts = "select gg.*,g.goods_name from group_goods gg,goods g where gg.goods_id=g.goods_id and gg.parent_id=?";
            ResultSet rsParts = this.jdbc.executeQuery(sqlParts, (Object)goods.getGoodsId());
            while (rsParts.next()) {
                parts = new GroupGoods();
                parts.setAdminId(rsParts.getInt("admin_id"));
                parts.setGoodsId(rsParts.getInt("goods_id"));
                parts.setGoodsName(rs.getString("goods_name"));
                parts.setGoodsPrice(rsParts.getString("goods_price"));
                partsList.add(parts);
            }
            goods.setPartsList(partsList);
            String sqlCms = "select c.cms_id,c.cms_name from cms c,goods_article ga where ga.article_id=c.cms_id and ga.goods_id=?";
            ResultSet rsCms = this.jdbc.executeQuery(sqlCms, (Object)goods.getGoodsId());
            while (rsCms.next()) {
                article = new Cms();
                article.setId(Integer.valueOf(rsCms.getInt("cms_id")));
                article.setName(rsCms.getString("cms_name"));
                articleList.add(article);
            }
            goods.setArticleList(articleList);
            String sqlGoodsCat = "select gc.* from goods_cat gc where gc.goods_id=?";
            ResultSet rsGoodsCat = this.jdbc.executeQuery(sqlGoodsCat, (Object)goods.getGoodsId());
            ArrayList<GoodsCategory> catList = new ArrayList<GoodsCategory>();
            GoodsCategory cat1 = null;
            while (rsGoodsCat.next()) {
                cat1 = new GoodsCategory();
                cat1.setId(rsGoodsCat.getInt("cat_id"));
                catList.add(cat1);
            }
            goods.setCatList(catList);
            String goodsSql = "select g.goods_id,g.goods_name from goods g,link_goods l where l.link_goods_id=g.goods_id and l.goods_id=?";
            ResultSet rsGoods = this.jdbc.executeQuery(goodsSql, (Object)goods.getGoodsId());
            ArrayList<GoodsPojo> goodsList = new ArrayList<GoodsPojo>();
            GoodsPojo goodsTem = null;
            while (rsGoods.next()) {
                goodsTem = new GoodsPojo();
                goodsTem.setGoodsId(rs.getInt("goods_id"));
                goodsTem.setGoodsName(rs.getString("goods_name"));
                goodsList.add(goodsTem);
            }
            goods.setGoodsList(goodsList);
        }
        this.jdbc.close();
        return goods;
    }

    public List<GoodsPojo> getGoodsList(Integer pageNo, Integer pageSize, Integer is_delete) throws SQLException {
        if (pageNo < 1) {
            pageNo = 1;
        }
        int offset = (pageNo - 1) * pageSize;
        String sql = "select gd.*,gc.*,gt.* from goods gd LEFT JOIN goods_category gc on gd.category_id=gc.goods_category_id LEFT JOIN goods_type gt on gd.goods_type=gt.goods_type_id where gd.is_delete=?  order by gd.goods_id desc limit " + offset + "," + pageSize;
        ResultSet rs = this.jdbc.executeQuery(sql, (Object)is_delete);
        GoodsPojo goods = null;
        ArrayList<GoodsPojo> goodsList = new ArrayList<GoodsPojo>();
        while (rs.next()) {
            goods = new GoodsPojo();
            GoodsCategory cat = new GoodsCategory();
            GoodsType goodsType = new GoodsType();
            goods.setGoodsId(rs.getInt("goods_id"));
            goods.setGoodsSn(rs.getString("goods_sn"));
            goods.setGoodsName(rs.getString("goods_name"));
            goods.setGoodsNameStyle(rs.getString("goods_name_style"));
            cat.setMeasure_unit(rs.getString("goods_category_measure_unit"));
            cat.setName(rs.getString("goods_category_name"));
            cat.setId(rs.getInt("goods_category_id"));
            goods.setCategory(cat);
            goods.setClickCount(rs.getInt("click_count"));
            goods.setGoodsWeight(rs.getString("goods_weight"));
            goods.setMarketPrice(rs.getString("market_price"));
            goods.setShopPrice(rs.getString("shop_price"));
            goods.setPromotePrice(rs.getString("promote_price"));
            goods.setPromoteStartDate(rs.getString("promote_start_date"));
            goods.setPromoteEndDate(rs.getString("promote_end_date"));
            goods.setGoodsNumber(rs.getInt("goods_number"));
            goods.setWarnNumber(rs.getInt("warn_number"));
            goods.setKeywords(rs.getString("keywords"));
            goods.setGoodsBrief(rs.getString("goods_brief"));
            goods.setGoodsDesc(rs.getString("goods_desc"));
            goods.setGoodsThumb(rs.getString("goods_thumb"));
            goods.setGoodsImg(rs.getString("goods_img"));
            goods.setOriginalImg(rs.getString("original_img"));
            goods.setIsReal(rs.getInt("is_real"));
            goods.setExtensionCode(rs.getString("extension_code"));
            goods.setIsOnSale(rs.getInt("is_on_sale"));
            goods.setIsShipping(rs.getInt("Is_shipping"));
            goods.setIntegral(rs.getInt("integral"));
            goods.setAddTime(rs.getString("add_time"));
            goods.setIsDelete(rs.getInt("is_delete"));
            goods.setSortOrder(rs.getInt("sort_order"));
            goods.setIsBest(rs.getInt("is_best"));
            goods.setIsNew(rs.getInt("is_new"));
            goods.setIsHot(rs.getInt("is_hot"));
            goods.setIsPromote(rs.getInt("is_promote"));
            goods.setBonusTypeId(rs.getInt("bonus_type_id"));
            goods.setLastUpdate(rs.getString("last_update"));
            goodsType.setName(rs.getString("goods_type_name"));
            goodsType.setId(rs.getInt("goods_type_id"));
            goods.setGoodsType(goodsType);
            goods.setSellerNote(rs.getString("seller_note"));
            goods.setGiveIntegral(rs.getInt("give_integral"));
            goods.setIsShelves(rs.getInt("is_shelves"));
            goodsList.add(goods);
        }
        this.jdbc.close();
        return goodsList;
    }

    public Integer getGoodsListCount(Integer is_delete) throws SQLException {
        int resultCount = 0;
        ResultSet rs = null;
        String sql = "select COUNT(*) AS rowcount from goods gd LEFT JOIN goods_category gc on gd.category_id=gc.goods_category_id LEFT JOIN goods_type gt on gd.goods_type=gt.goods_type_id where gd.is_delete=?";
        rs = this.jdbc.executeQuery(sql, (Object)is_delete);
        if (rs.next()) {
            resultCount = rs.getInt("rowcount");
        }
        this.jdbc.close();
        return resultCount;
    }

    public List<GoodsPojo> getGoodsListByCat(Integer pageNo, Integer pageSize, String cat_id) throws SQLException {
        if (pageNo < 1) {
            pageNo = 1;
        }
        int offset = (pageNo - 1) * pageSize;
        String sql = "select gd.*,gc.*,gt.* from goods gd LEFT JOIN goods_category gc on gd.category_id=gc.goods_category_id LEFT JOIN goods_type gt on gd.goods_type=gt.goods_type_id where gd.category_id=? and gd.is_shelves=1 order by gd.goods_id desc limit " + offset + "," + pageSize;
        ResultSet rs = this.jdbc.executeQuery(sql, (Object)cat_id);
        GoodsPojo goods = null;
        ArrayList<GoodsPojo> goodsList = new ArrayList<GoodsPojo>();
        while (rs.next()) {
            goods = new GoodsPojo();
            GoodsCategory cat = new GoodsCategory();
            GoodsType goodsType = new GoodsType();
            goods.setGoodsId(rs.getInt("goods_id"));
            goods.setGoodsSn(rs.getString("goods_sn"));
            goods.setGoodsName(rs.getString("goods_name"));
            goods.setGoodsNameStyle(rs.getString("goods_name_style"));
            cat.setMeasure_unit(rs.getString("goods_category_measure_unit"));
            cat.setName(rs.getString("goods_category_name"));
            cat.setId(rs.getInt("goods_category_id"));
            goods.setCategory(cat);
            goods.setClickCount(rs.getInt("click_count"));
            goods.setGoodsWeight(rs.getString("goods_weight"));
            goods.setMarketPrice(rs.getString("market_price"));
            goods.setShopPrice(rs.getString("shop_price"));
            goods.setPromotePrice(rs.getString("promote_price"));
            goods.setPromoteStartDate(rs.getString("promote_start_date"));
            goods.setPromoteEndDate(rs.getString("promote_end_date"));
            goods.setGoodsNumber(rs.getInt("goods_number"));
            goods.setWarnNumber(rs.getInt("warn_number"));
            goods.setKeywords(rs.getString("keywords"));
            goods.setGoodsBrief(rs.getString("goods_brief"));
            goods.setGoodsDesc(rs.getString("goods_desc"));
            goods.setGoodsThumb(rs.getString("goods_thumb"));
            goods.setGoodsImg(rs.getString("goods_img"));
            goods.setOriginalImg(rs.getString("original_img"));
            goods.setIsReal(rs.getInt("is_real"));
            goods.setExtensionCode(rs.getString("extension_code"));
            goods.setIsOnSale(rs.getInt("is_on_sale"));
            goods.setIsShipping(rs.getInt("Is_shipping"));
            goods.setIntegral(rs.getInt("integral"));
            goods.setAddTime(rs.getString("add_time"));
            goods.setIsDelete(rs.getInt("is_delete"));
            goods.setSortOrder(rs.getInt("sort_order"));
            goods.setIsBest(rs.getInt("is_best"));
            goods.setIsNew(rs.getInt("is_new"));
            goods.setIsHot(rs.getInt("is_hot"));
            goods.setIsPromote(rs.getInt("is_promote"));
            goods.setBonusTypeId(rs.getInt("bonus_type_id"));
            goods.setLastUpdate(rs.getString("last_update"));
            goodsType.setName(rs.getString("goods_type_name"));
            goodsType.setId(rs.getInt("goods_type_id"));
            goods.setGoodsType(goodsType);
            goods.setSellerNote(rs.getString("seller_note"));
            goods.setGiveIntegral(rs.getInt("give_integral"));
            goods.setIsShelves(rs.getInt("is_shelves"));
            goodsList.add(goods);
        }
        this.jdbc.close();
        return goodsList;
    }

    public Integer getGoodsListByCatCount(String cat_id) throws SQLException {
        int resultCount = 0;
        ResultSet rs = null;
        String sql = "select COUNT(*) AS rowcount from goods gd LEFT JOIN goods_category gc on gd.category_id=gc.goods_category_id LEFT JOIN goods_type gt on gd.goods_type=gt.goods_type_id where gd.category_id=? and gd.is_shelves=1";
        rs = this.jdbc.executeQuery(sql, (Object)cat_id);
        if (rs.next()) {
            resultCount = rs.getInt("rowcount");
        }
        this.jdbc.close();
        return resultCount;
    }

    public List<GoodsPojo> getGoodsListByExtendCat(Integer pageNo, Integer pageSize, String cat_ids, String type_ids, String brand_ids, String price) throws SQLException {
        if (pageNo < 1) {
            pageNo = 1;
        }
        int offset = (pageNo - 1) * pageSize;
        String sql = "select gd.*,gc.*,gt.* from goods gd,goods_cat gcat,goods_category gc,goods_type gt where gd.is_shelves=1 ";
        if (cat_ids != null && !cat_ids.equals("")) {
            sql = String.valueOf(sql) + " and gcat.cat_id in (" + cat_ids + ") and gcat.cat_id=gc.goods_category_id and gcat.goods_id=gd.goods_id";
        }
        if (type_ids != null && !type_ids.equals("")) {
            sql = String.valueOf(sql) + " and gd.goods_type in (" + type_ids + ") ";
        }
        if (brand_ids != null && !brand_ids.equals("")) {
            sql = String.valueOf(sql) + " and gd.brand_id in (" + brand_ids + ") ";
        }
        if (price != null && !price.equals("x")) {
            String[] price_arr = price.split("-");
            sql = !price_arr[1].equals("x") ? String.valueOf(sql) + " and gd.shop_price>=" + price_arr[0] + " and gd.shop_price<=" + price_arr[1] + " " : String.valueOf(sql) + " and gd.shop_price>=" + price_arr[0] + " ";
        }
        sql = String.valueOf(sql) + " and gd.goods_type=gt.goods_type_id order by gd.goods_id desc limit " + offset + "," + pageSize;
        ResultSet rs = this.jdbc.executeQuery(sql);
        GoodsPojo goods = null;
        ArrayList<GoodsPojo> goodsList = new ArrayList<GoodsPojo>();
        while (rs.next()) {
            goods = new GoodsPojo();
            GoodsCategory cat = new GoodsCategory();
            GoodsType goodsType = new GoodsType();
            goods.setGoodsId(rs.getInt("goods_id"));
            goods.setGoodsSn(rs.getString("goods_sn"));
            goods.setGoodsName(rs.getString("goods_name"));
            goods.setGoodsNameStyle(rs.getString("goods_name_style"));
            cat.setMeasure_unit(rs.getString("goods_category_measure_unit"));
            cat.setName(rs.getString("goods_category_name"));
            cat.setId(rs.getInt("goods_category_id"));
            goods.setCategory(cat);
            goods.setClickCount(rs.getInt("click_count"));
            goods.setGoodsWeight(rs.getString("goods_weight"));
            goods.setMarketPrice(rs.getString("market_price"));
            goods.setShopPrice(rs.getString("shop_price"));
            goods.setPromotePrice(rs.getString("promote_price"));
            goods.setPromoteStartDate(rs.getString("promote_start_date"));
            goods.setPromoteEndDate(rs.getString("promote_end_date"));
            goods.setGoodsNumber(rs.getInt("goods_number"));
            goods.setWarnNumber(rs.getInt("warn_number"));
            goods.setKeywords(rs.getString("keywords"));
            goods.setGoodsBrief(rs.getString("goods_brief"));
            goods.setGoodsDesc(rs.getString("goods_desc"));
            goods.setGoodsThumb(rs.getString("goods_thumb"));
            goods.setGoodsImg(rs.getString("goods_img"));
            goods.setOriginalImg(rs.getString("original_img"));
            goods.setIsReal(rs.getInt("is_real"));
            goods.setExtensionCode(rs.getString("extension_code"));
            goods.setIsOnSale(rs.getInt("is_on_sale"));
            goods.setIsShipping(rs.getInt("Is_shipping"));
            goods.setIntegral(rs.getInt("integral"));
            goods.setAddTime(rs.getString("add_time"));
            goods.setIsDelete(rs.getInt("is_delete"));
            goods.setSortOrder(rs.getInt("sort_order"));
            goods.setIsBest(rs.getInt("is_best"));
            goods.setIsNew(rs.getInt("is_new"));
            goods.setIsHot(rs.getInt("is_hot"));
            goods.setIsPromote(rs.getInt("is_promote"));
            goods.setBonusTypeId(rs.getInt("bonus_type_id"));
            goods.setLastUpdate(rs.getString("last_update"));
            goodsType.setName(rs.getString("goods_type_name"));
            goodsType.setId(rs.getInt("goods_type_id"));
            goods.setGoodsType(goodsType);
            goods.setSellerNote(rs.getString("seller_note"));
            goods.setGiveIntegral(rs.getInt("give_integral"));
            goods.setIsShelves(rs.getInt("is_shelves"));
            goods.setUserPrice(rs.getString("user_price"));
            goods.setConsPrice(rs.getString("cons_price"));
            goods.setVipPrice(rs.getString("vip_price"));
            GoodsAttr attr = null;
            ArrayList<GoodsAttr> attrList = new ArrayList<GoodsAttr>();
            String sqlAttr = "select a.*,gt.goods_type_attribute_name from goods_attr a,goods_type_attribute gt where a.attr_id=gt.goods_type_attribute_id and a.goods_id=?";
            ResultSet rsAttr = this.jdbc.executeQuery(sqlAttr, (Object)goods.getGoodsId());
            while (rsAttr.next()) {
                attr = new GoodsAttr();
                attr.setId(rsAttr.getInt("goods_attr_id"));
                attr.setAttr_id(rsAttr.getInt("attr_id"));
                attr.setGoods_id(rsAttr.getInt("goods_id"));
                attr.setValue(rsAttr.getString("goods_attr_value"));
                attr.setPrice(rsAttr.getString("goods_attr_price"));
                attr.setName(rsAttr.getString("goods_type_attribute_name"));
                attrList.add(attr);
                goods.setAttrList(attrList);
            }
            goodsList.add(goods);
        }
        this.jdbc.close();
        return goodsList;
    }

    public List<GoodsPojo> getGoodsListByAllFlag(Integer pageNo, Integer pageSize, Integer new_falg, Integer promt_flag, Integer best_flag, Integer hot_flag) throws SQLException {
        if (pageNo < 1) {
            pageNo = 1;
        }
        int offset = (pageNo - 1) * pageSize;
        String sql = "select gd.*,gc.*,gt.* from goods gd LEFT JOIN goods_category gc on gd.category_id=gc.goods_category_id LEFT JOIN goods_type gt on gd.goods_type=gt.goods_type_id where gd.is_shelves=1 ";
        if (new_falg != null) {
            sql = String.valueOf(sql) + " and gd.is_new=" + new_falg + " ";
        }
        if (promt_flag != null) {
            sql = String.valueOf(sql) + " and gd.is_promote=" + promt_flag + " ";
        }
        if (best_flag != null) {
            sql = String.valueOf(sql) + " and gd.is_best=" + best_flag + " ";
        }
        if (hot_flag != null) {
            sql = String.valueOf(sql) + " and gd.is_hot=" + hot_flag + " ";
        }
        sql = String.valueOf(sql) + " order by gd.goods_id desc limit " + offset + "," + pageSize;
        ResultSet rs = this.jdbc.executeQuery(sql);
        GoodsPojo goods = null;
        ArrayList<GoodsPojo> goodsList = new ArrayList<GoodsPojo>();
        while (rs.next()) {
            goods = new GoodsPojo();
            GoodsCategory cat = new GoodsCategory();
            GoodsType goodsType = new GoodsType();
            goods.setGoodsId(rs.getInt("goods_id"));
            goods.setGoodsSn(rs.getString("goods_sn"));
            goods.setGoodsName(rs.getString("goods_name"));
            goods.setGoodsNameStyle(rs.getString("goods_name_style"));
            cat.setMeasure_unit(rs.getString("goods_category_measure_unit"));
            cat.setName(rs.getString("goods_category_name"));
            cat.setId(rs.getInt("goods_category_id"));
            goods.setCategory(cat);
            goods.setClickCount(rs.getInt("click_count"));
            goods.setGoodsWeight(rs.getString("goods_weight"));
            goods.setMarketPrice(rs.getString("market_price"));
            goods.setShopPrice(rs.getString("shop_price"));
            goods.setPromotePrice(rs.getString("promote_price"));
            goods.setPromoteStartDate(rs.getString("promote_start_date"));
            goods.setPromoteEndDate(rs.getString("promote_end_date"));
            goods.setGoodsNumber(rs.getInt("goods_number"));
            goods.setWarnNumber(rs.getInt("warn_number"));
            goods.setKeywords(rs.getString("keywords"));
            goods.setGoodsBrief(rs.getString("goods_brief"));
            goods.setGoodsDesc(rs.getString("goods_desc"));
            goods.setGoodsThumb(rs.getString("goods_thumb"));
            goods.setGoodsImg(rs.getString("goods_img"));
            goods.setOriginalImg(rs.getString("original_img"));
            goods.setIsReal(rs.getInt("is_real"));
            goods.setExtensionCode(rs.getString("extension_code"));
            goods.setIsOnSale(rs.getInt("is_on_sale"));
            goods.setIsShipping(rs.getInt("Is_shipping"));
            goods.setIntegral(rs.getInt("integral"));
            goods.setAddTime(rs.getString("add_time"));
            goods.setIsDelete(rs.getInt("is_delete"));
            goods.setSortOrder(rs.getInt("sort_order"));
            goods.setIsBest(rs.getInt("is_best"));
            goods.setIsNew(rs.getInt("is_new"));
            goods.setIsHot(rs.getInt("is_hot"));
            goods.setIsPromote(rs.getInt("is_promote"));
            goods.setBonusTypeId(rs.getInt("bonus_type_id"));
            goods.setLastUpdate(rs.getString("last_update"));
            goodsType.setName(rs.getString("goods_type_name"));
            goodsType.setId(rs.getInt("goods_type_id"));
            goods.setGoodsType(goodsType);
            goods.setSellerNote(rs.getString("seller_note"));
            goods.setGiveIntegral(rs.getInt("give_integral"));
            goods.setIsShelves(rs.getInt("is_shelves"));
            GoodsAttr attr = null;
            ArrayList<GoodsAttr> attrList = new ArrayList<GoodsAttr>();
            String sqlAttr = "select a.*,gt.goods_type_attribute_name from goods_attr a,goods_type_attribute gt where a.attr_id=gt.goods_type_attribute_id and a.goods_id=?";
            ResultSet rsAttr = this.jdbc.executeQuery(sqlAttr, (Object)goods.getGoodsId());
            while (rsAttr.next()) {
                attr = new GoodsAttr();
                attr.setId(rsAttr.getInt("goods_attr_id"));
                attr.setAttr_id(rsAttr.getInt("attr_id"));
                attr.setGoods_id(rsAttr.getInt("goods_id"));
                attr.setValue(rsAttr.getString("goods_attr_value"));
                attr.setPrice(rsAttr.getString("goods_attr_price"));
                attr.setName(rsAttr.getString("goods_type_attribute_name"));
                attrList.add(attr);
                goods.setAttrList(attrList);
            }
            goodsList.add(goods);
        }
        this.jdbc.close();
        return goodsList;
    }

    public Integer getGoodsListByAllFlagCount(Integer pageNo, Integer pageSize, Integer new_falg, Integer promt_flag, Integer best_flag, Integer hot_flag) throws SQLException {
        int resultCount = 0;
        ResultSet rs = null;
        String sql = "select COUNT(*) AS rowcount from goods gd LEFT JOIN goods_category gc on gd.category_id=gc.goods_category_id LEFT JOIN goods_type gt on gd.goods_type=gt.goods_type_id where gd.is_shelves=1 ";
        if (new_falg != null) {
            sql = String.valueOf(sql) + " and gd.is_new=" + new_falg + " ";
        }
        if (promt_flag != null) {
            sql = String.valueOf(sql) + " and gd.is_promote=" + promt_flag + " ";
        }
        if (best_flag != null) {
            sql = String.valueOf(sql) + " and gd.is_best=" + best_flag + " ";
        }
        if (hot_flag != null) {
            sql = String.valueOf(sql) + " and gd.is_hot=" + hot_flag + " ";
        }
        if ((rs = this.jdbc.executeQuery(sql)).next()) {
            resultCount = rs.getInt("rowcount");
        }
        this.jdbc.close();
        return resultCount;
    }

    public Integer addGoods(Integer category_id, String goods_sn, String goods_name, String goods_name_style, Integer brand_id, Integer click_count, String goods_weight, String market_price, String shop_price, String vip_price, String cons_price, String user_price, String promote_price, String promote_start_date, String promote_end_date, Integer goods_number, Integer warn_number, String keywords, String goods_brief, String goods_desc, String goods_thumb, String goods_img, String original_img, Integer is_real, String extension_code, Integer is_on_sale, Integer is_alone_sale, Integer Is_shipping, Integer integral, String add_time, Integer is_delete, Integer sort_order, Integer is_best, Integer is_new, Integer is_hot, Integer is_shelves, Integer is_promote, Integer bonus_type_id, String last_update, Integer goods_type, String seller_note, Integer give_integral) {
        Object[] args = new Object[]{category_id, goods_sn, goods_name, goods_name_style, brand_id, click_count, goods_weight, market_price, shop_price, vip_price, cons_price, user_price, promote_price, promote_start_date, promote_end_date, goods_number, warn_number, keywords, goods_brief, goods_desc, goods_thumb, goods_img, original_img, is_real, extension_code, is_on_sale, is_alone_sale, Is_shipping, integral, add_time, is_delete, sort_order, is_best, is_new, is_hot, is_shelves, is_promote, bonus_type_id, last_update, goods_type, seller_note, give_integral};
        String sql = "insert into goods(category_id,goods_sn,goods_name,goods_name_style,brand_id,click_count,goods_weight,market_price,shop_price,vip_price,cons_price,user_price,promote_price,promote_start_date,promote_end_date,goods_number,warn_number,keywords,goods_brief,goods_desc,goods_thumb,goods_img,original_img,is_real,extension_code,is_on_sale,is_alone_sale,Is_shipping,integral,add_time,is_delete,sort_order,is_best,is_new,is_hot,is_shelves,is_promote,bonus_type_id,last_update,goods_type,seller_note,give_integral) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        Serializable sable = this.jdbc.insertBackId(sql, args);
        this.jdbc.close();
        if (sable.hashCode() > 0) {
            return sable.hashCode();
        }
        return 0;
    }

    public String addGoodsExtendCategory(Integer goodsId, Integer catId) {
        Object[] args = new Object[]{goodsId, catId};
        String sql = "insert into goods_cat (goods_id,cat_id) values(?,?)";
        int flag = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public String deleteGoodsExtendCategory(String ids) {
        String sql = "delete from goods_cat where goods_id in (" + ids + ")";
        int flag = this.jdbc.executeUpdate(sql);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public String updateGoodsDesc(String goods_id, String goods_desc) {
        Object[] args = new Object[]{goods_desc, goods_id};
        String sql = "UPDATE goods SET goods_desc = ? where goods_id=?";
        int flag = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public String updateGoodsBaseInfo(String goods_id, String name, String sn, Integer cat, Integer brand, String shopPrice, String vipPrice, String userPrice, String consPrice, String marketPrice, Integer giveIntegral, Integer integral, Integer cuxiao, String promotePrice, String promoteStartDate, String promoteEndDate, String img) {
        Object[] args = new Object[]{name, sn, cat, brand, shopPrice, vipPrice, userPrice, consPrice, marketPrice, giveIntegral, integral, cuxiao, promotePrice, promoteStartDate, promoteEndDate, img, img, img, goods_id};
        String sql = "UPDATE goods SET goods_name=?,goods_sn=?,category_id=?,brand_id=?,shop_price=?,vip_price=?,user_price=?,cons_price=?,market_price=?,give_integral=?,integral=?,is_promote=?,promote_price=?,promote_start_date=?,promote_end_date=?,goods_img=?,goods_thumb=?,original_img=? where goods_id=?";
        int flag = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public String updateGoodsOtherInfo(String goods_id, String goods_weight, Integer goods_number, Integer warn_number, Integer is_best, Integer is_new, Integer is_hot, Integer is_shelves, Integer is_alone_sale, Integer is_freight, String keywords, String goods_brief, String seller_note) {
        Object[] args = new Object[]{goods_weight, goods_number, warn_number, is_best, is_new, is_hot, is_shelves, is_alone_sale, is_freight, keywords, goods_brief, seller_note, goods_id};
        String sql = "UPDATE goods SET goods_weight = ?,goods_number=?,warn_number=?,is_best=?,is_new=?,is_hot=?,is_shelves=?,is_alone_sale=?,is_freight=?,keywords=?,goods_brief=?,seller_note=? where goods_id=?";
        int flag = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public String addGoodsAttr(Integer goods_id, Integer attr_id, String goods_attr_value, String goods_attr_price) {
        Object[] args = new Object[]{goods_id, attr_id, goods_attr_value, goods_attr_price};
        String sql = "insert into goods_attr (goods_id,attr_id,goods_attr_value,goods_attr_price) values(?,?,?,?)";
        int flag = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public Integer addGoodsImg(Integer goods_id, String img_desc, String thumb_ur, String img_original) {
        Object[] args = new Object[]{goods_id, img_desc, thumb_ur, img_original};
        String sql = "insert into goods_gallery (goods_id,img_desc,thumb_url,img_original) values(?,?,?,?)";
        Serializable flag = this.jdbc.insertBackId(sql, args);
        this.jdbc.close();
        return flag.hashCode();
    }

    public List<GoodsPojo> searchGoodsByCatAndBrandAndKeyword(Integer cat_id, Integer brand_id, String keyword) throws SQLException {
        String sql = "select gd.goods_id,gd.shop_price,gd.goods_name from goods gd where gd.goods_id!=0";
        if (cat_id != null) {
            sql = String.valueOf(sql) + " and gd.category_id=" + cat_id + " or gd.goods_id in (select gc.goods_id from goods_cat gc where gc.cat_id=" + cat_id + ")";
        }
        if (brand_id != null) {
            sql = String.valueOf(sql) + " and gd.brand_id=" + brand_id;
        }
        if (keyword != null && !keyword.trim().equals("")) {
            sql = String.valueOf(sql) + " and gd.goods_name like '%" + keyword + "%'";
        }
        sql = String.valueOf(sql) + " order by gd.goods_id desc";
        ResultSet rs = this.jdbc.executeQuery(sql);
        GoodsPojo goods = null;
        ArrayList<GoodsPojo> goodsList = new ArrayList<GoodsPojo>();
        while (rs.next()) {
            goods = new GoodsPojo();
            goods.setGoodsId(rs.getInt("goods_id"));
            goods.setGoodsName(rs.getString("goods_name"));
            goods.setShopPrice(rs.getString("shop_price"));
            goodsList.add(goods);
        }
        this.jdbc.close();
        return goodsList;
    }

    public String addLinkGoods(Integer goods_id, Integer link_goods_id, Integer is_double, Integer admin_id) {
        Object[] args = new Object[]{goods_id, link_goods_id, is_double, admin_id};
        String sql = "insert into link_goods (goods_id,link_goods_id,is_double,admin_id) values(?,?,?,?)";
        int flag = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public String deleteLinkGoods(String ids) {
        String sql = "delete from link_goods where goods_id in (" + ids + ")";
        int flag = this.jdbc.executeUpdate(sql);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public String addGroupGoods(String parent, String goods_id, String goods_price, Integer admin_id) {
        Object[] args = new Object[]{parent, goods_id, goods_price, admin_id};
        String sql = "insert into group_goods (parent_id,goods_id,goods_price,admin_id) values(?,?,?,?)";
        int flag = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public String deleteGroupGoods(String ids) {
        String sql = "delete from group_goods where goods_id in (" + ids + ")";
        int flag = this.jdbc.executeUpdate(sql);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public List<Cms> getCmsByModForShop(String modId, String keywords) throws SQLException {
        ResultSet rs = null;
        Integer pageNo = 1;
        Integer pageSize = 100;
        if (pageNo < 1) {
            pageNo = 1;
        }
        int offset = (pageNo - 1) * pageSize;
        ArrayList<Cms> cmsList = new ArrayList<Cms>();
        String sql = "select c.*,am.* from cms c,adminmod am where c.cms_admin_mod=am.adminmod_id and c.cms_admin_mod=?";
        if (keywords != null && !keywords.trim().equals("")) {
            sql = String.valueOf(sql) + " and c.cms_name like '%" + keywords + "%'";
        }
        sql = String.valueOf(sql) + " order by c.cms_flag desc,c.cms_order desc limit " + offset + "," + pageSize;
        rs = this.jdbc.executeQuery(sql, (Object)modId);
        Cms cms = null;
        while (rs.next()) {
            cms = new Cms();
            cms.setId(Integer.valueOf(rs.getInt("cms_id")));
            cms.setName(rs.getString("cms_name"));
            cms.setStyle(rs.getString("cms_style"));
            cms.setSuroce(rs.getString("cms_suroce"));
            cms.setPerson(rs.getString("cms_peron"));
            cms.setContent(rs.getString("cms_content"));
            cms.setTime(rs.getString("cms_time"));
            cms.setMod(Integer.valueOf(rs.getInt("adminmod_id")));
            String code = rs.getString("adminmod_code");
            JSONObject obj = (JSONObject)JSON.parse((String)code);
            String title = obj.get((Object)"text").toString();
            cms.setModName(title);
            cms.setFlag(rs.getString("cms_flag"));
            cms.setOrder(Integer.valueOf(rs.getInt("cms_order")));
            cms.setImg(rs.getString("cms_img"));
            cms.setDescription(rs.getString("cms_description"));
            cms.setKeyword(rs.getString("cms_keyword"));
            cmsList.add(cms);
        }
        this.jdbc.close();
        return cmsList;
    }

    public String addGoodsArticle(String goods_id, String article_id, Integer admin_id) {
        Object[] args = new Object[]{goods_id, article_id, admin_id};
        String sql = "insert into goods_article (goods_id,article_id,admin_id) values(?,?,?)";
        int flag = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public String deleteGoodsArticle(String ids) {
        String sql = "delete from goods_article where goods_id =?";
        int flag = this.jdbc.executeUpdate(sql, (Object)ids);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public String deleteGoodsImg(Integer id) {
        String sql = "delete from goods_gallery where goods_gallery_id =?";
        int flag = this.jdbc.executeUpdate(sql, (Object)id);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public String deleteGoodsImg(String ids) {
        String sql = "delete from goods_gallery where goods_id (" + ids + ")";
        int flag = this.jdbc.executeUpdate(sql);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public String deleteGoods(String ids) {
        String sql = "delete from goods where goods_id in (" + ids + ")";
        int flag = this.jdbc.executeUpdate(sql);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public String updateShelves(Integer id, Integer upFlag) {
        Object[] args = new Object[]{upFlag, id};
        String sql = "UPDATE goods SET is_shelves = ? where goods_id=?";
        int flag = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public String updateBest(Integer id, Integer bestFlag) {
        Object[] args = new Object[]{bestFlag, id};
        String sql = "UPDATE goods SET is_best = ? where goods_id=?";
        int flag = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public String updateNew(Integer id, Integer newFlag) {
        Object[] args = new Object[]{newFlag, id};
        String sql = "UPDATE goods SET is_new = ? where goods_id=?";
        int flag = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public String updateHot(Integer id, Integer hotFlag) {
        Object[] args = new Object[]{hotFlag, id};
        String sql = "UPDATE goods SET is_hot = ? where goods_id=?";
        int flag = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public String updateGoodsAttr(Integer goods_id, Integer attr_id) {
        Object[] args = new Object[]{attr_id, goods_id};
        String sql = "UPDATE goods SET goods_type = ? where goods_id=?";
        int flag = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public String deleteGoodsAttr(String ids) {
        String sql = "delete from goods_attr where goods_id in (" + ids + ")";
        int flag = this.jdbc.executeUpdate(sql);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public Integer addGoodsOrder(String no, Integer type, Integer flag, Integer num, Integer orNum, String serviceDate, String dayLongs, String content, Integer user_id, Integer admin_id, Integer store_id, Integer employee_id, String price, Integer payFlag, Integer contractFlag, Integer address_id, Integer goods_order_save, String direction, String directionPerson, Integer directionId, Integer goodsId, Integer pay_way, String desc) {
        SimpleDateFormat format2 = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        Date dDate = new Date();
        String time = format2.format(dDate);
        Object[] args = new Object[]{no, time, type, flag, num, orNum, serviceDate, dayLongs, content, user_id, admin_id, store_id, employee_id, price, payFlag, contractFlag, address_id, goods_order_save, direction, directionPerson, directionId, goodsId, pay_way, desc};
        String sql = "insert into goods_order (goods_order_no,goods_order_date,goods_order_type,goods_order_flag,goods_order_num,goods_order_orNum,goods_order_serviceDate,goods_order_dayLongs,goods_order_content,goods_order_user_id,goods_order_admin_id,goods_order_store_id,goods_order_employee_id,goods_order_price,goods_order_playFlag,goods_order_contractFlag,goods_order_address,goods_order_save,goods_order_direction,goods_order_direction_person,goods_order_direction_id,goods_order_goods_id,goods_order_pay_way,goods_order_desc) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        Serializable teflag = this.jdbc.insertBackId(sql, args);
        this.jdbc.close();
        return teflag.hashCode();
    }

    public String updateplayFlag(Integer goods_id, Integer playFlag) {
        Object[] args = new Object[]{playFlag, goods_id};
        String sql = "UPDATE goods_order SET goods_order_playFlag=? where goods_order_id=?";
        int flag = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public String updateGoodsOrder(Integer order_id, Integer store_id, Integer employee_id) {
        Object[] args = new Object[]{store_id, employee_id, order_id};
        String sql = "UPDATE goods_order SET goods_order_store_id=?,goods_order_employee_id=?,goods_order_flag=2 where goods_order_id=?";
        int flag = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public List<GoodsOrder> getGoodsOrderListByUser(Integer userId) throws SQLException {
        String sql = "select g.*,u.user_username,u.user_id,ua.*,se.store_employee_id,se.store_employee_name,a.admin_id,a.admin_username,s.store_id,s.store_name,gt.goods_type_id,gt.goods_type_name from goods_order g left join user u on g.goods_order_user_id=u.user_id LEFT JOIN user_address ua on g.goods_order_address=ua.user_address_id LEFT JOIN store s on g.goods_order_store_id=s.store_id LEFT JOIN store_employee se on g.goods_order_employee_id=se.store_employee_id LEFT JOIN admin a on g.goods_order_admin_id=a.admin_id LEFT JOIN goods_type gt on g.goods_order_serviceId=gt.goods_type_id where g.goods_order_id!=0 and g.goods_order_user_id=? order by g.goods_order_id desc";
        ResultSet rs = this.jdbc.executeQuery(sql, (Object)userId);
        GoodsOrder order = null;
        ArrayList<GoodsOrder> orderList = new ArrayList<GoodsOrder>();
        while (rs.next()) {
            order = new GoodsOrder();
            order.setId(rs.getInt("goods_order_id"));
            order.setNo(rs.getString("goods_order_no"));
            order.setType(rs.getInt("goods_order_type"));
            order.setFlag(rs.getInt("goods_order_flag"));
            order.setNum(rs.getInt("goods_order_num"));
            order.setOrNum(rs.getInt("goods_order_orNum"));
            order.setServiceDate(rs.getString("goods_order_serviceDate"));
            order.setDayLongs(rs.getString("goods_order_dayLongs"));
            order.setContent(rs.getString("goods_order_content"));
            order.setUser_id(rs.getInt("user_id"));
            order.setUsername(rs.getString("user_username"));
            order.setAdmin_id(rs.getInt("admin_id"));
            order.setAdmin_username(rs.getString("admin_username"));
            order.setStore_id(rs.getInt("store_id"));
            order.setStore_name(rs.getString("store_name"));
            order.setEmployee_id(rs.getString("store_employee_id"));
            order.setEmployee_name(rs.getString("store_employee_name"));
            order.setPrice(rs.getString("goods_order_price"));
            order.setActual_price(rs.getString("goods_order_actual_price"));
            order.setPayFlag(rs.getInt("goods_order_playFlag"));
            order.setContractFlag(rs.getInt("goods_order_contractFlag"));
            order.setAddress_id(rs.getInt("goods_order_address"));
            order.setAddress_content(rs.getString("user_address_content"));
            order.setAddress_person(rs.getString("user_address_name"));
            order.setAddress_tel(rs.getString("user_address_tel"));
            order.setSaveFlag(rs.getInt("goods_order_save"));
            order.setDirection(rs.getInt("goods_order_direction"));
            order.setDirection_person(rs.getString("goods_order_direction_person"));
            order.setDirection_id(rs.getInt("goods_order_direction_id"));
            order.setServiceId(rs.getInt("goods_order_serviceId"));
            order.setGoodsType(rs.getInt("goods_type_id"));
            order.setGoodsTypeName(rs.getString("goods_type_name"));
            order.setPay_way(rs.getInt("goods_order_pay_way"));
            order.setDesc(rs.getString("goods_order_desc"));
            orderList.add(order);
        }
        this.jdbc.close();
        return orderList;
    }

    public Integer getGoodsOrderByUserCount(Integer userId, Integer flag) throws SQLException {
        int resultCount = 0;
        ResultSet rs = null;
        String sql = "select COUNT(*) AS rowcount from goods_order g left join user u on g.goods_order_user_id=u.user_id LEFT JOIN user_address ua on g.goods_order_address=ua.user_address_id LEFT JOIN store s on g.goods_order_store_id=s.store_id left join goods gd on g.goods_order_goods_id=gd.goods_id LEFT JOIN store_employee se on g.goods_order_employee_id=se.store_employee_id LEFT JOIN admin a on g.goods_order_admin_id=a.admin_id where g.goods_order_user_id=? and goods_order_type=?";
        Object[] args = new Object[]{userId, flag};
        rs = this.jdbc.executeQuery(sql, args);
        if (rs.next()) {
            resultCount = rs.getInt("rowcount");
        }
        this.jdbc.close();
        return resultCount;
    }

    public List<GoodsOrder> getGoodsOrderListByUserForPc(Integer userId, Integer flag, Integer pageNo, Integer pageSize) throws SQLException {
        if (pageNo < 1) {
            pageNo = 1;
        }
        int offset = (pageNo - 1) * pageSize;
        Object[] args = new Integer[]{userId, flag};
        String sql = "select g.*,u.user_username,u.user_id,ua.*,se.store_employee_id,se.store_employee_name,a.admin_id,a.admin_username,s.store_id,s.store_name,gd.goods_id,gd.goods_name from goods_order g left join user u on g.goods_order_user_id=u.user_id LEFT JOIN user_address ua on g.goods_order_address=ua.user_address_id LEFT JOIN store s on g.goods_order_store_id=s.store_id left join goods gd on g.goods_order_goods_id=gd.goods_id LEFT JOIN store_employee se on g.goods_order_employee_id=se.store_employee_id LEFT JOIN admin a on g.goods_order_admin_id=a.admin_id where g.goods_order_id!=0 and g.goods_order_user_id=? and goods_order_type=? order by g.goods_order_id desc limit " + offset + "," + pageSize;
        ResultSet rs = this.jdbc.executeQuery(sql, args);
        GoodsOrder order = null;
        ArrayList<GoodsOrder> orderList = new ArrayList<GoodsOrder>();
        while (rs.next()) {
            order = new GoodsOrder();
            order.setId(rs.getInt("goods_order_id"));
            order.setNo(rs.getString("goods_order_no"));
            order.setType(rs.getInt("goods_order_type"));
            order.setFlag(rs.getInt("goods_order_flag"));
            order.setNum(rs.getInt("goods_order_num"));
            order.setOrNum(rs.getInt("goods_order_orNum"));
            order.setServiceDate(rs.getString("goods_order_serviceDate"));
            order.setDayLongs(rs.getString("goods_order_dayLongs"));
            order.setContent(rs.getString("goods_order_content"));
            order.setUser_id(rs.getInt("user_id"));
            order.setUsername(rs.getString("user_username"));
            order.setAdmin_id(rs.getInt("admin_id"));
            order.setAdmin_username(rs.getString("admin_username"));
            order.setStore_id(rs.getInt("store_id"));
            order.setStore_name(rs.getString("store_name"));
            order.setEmployee_id(rs.getString("store_employee_id"));
            order.setEmployee_name(rs.getString("store_employee_name"));
            order.setPrice(rs.getString("goods_order_price"));
            order.setActual_price(rs.getString("goods_order_actual_price"));
            order.setPayFlag(rs.getInt("goods_order_playFlag"));
            order.setContractFlag(rs.getInt("goods_order_contractFlag"));
            order.setAddress_id(rs.getInt("goods_order_address"));
            order.setAddress_content(rs.getString("user_address_content"));
            order.setAddress_person(rs.getString("user_address_name"));
            order.setAddress_tel(rs.getString("user_address_tel"));
            order.setSaveFlag(rs.getInt("goods_order_save"));
            order.setDirection(rs.getInt("goods_order_direction"));
            order.setDirection_person(rs.getString("goods_order_direction_person"));
            order.setDirection_id(rs.getInt("goods_order_direction_id"));
            order.setPay_way(rs.getInt("goods_order_pay_way"));
            order.setDesc(rs.getString("goods_order_desc"));
            order.setGoodsId(rs.getInt("goods_id"));
            order.setGoodsName(rs.getString("goods_name"));
            orderList.add(order);
        }
        this.jdbc.close();
        return orderList;
    }

    public List<GoodsOrder> getGoodsOrderList(String tel) throws SQLException {
        String sql = "select g.*,u.user_username,u.user_id,ua.*,se.store_employee_id,se.store_employee_name,a.admin_id,a.admin_username,s.store_id,s.store_name,gd.goods_id,gd.goods_name from goods_order g left join user u on g.goods_order_user_id=u.user_id left join goods gd on g.goods_order_goods_id=gd.goods_id LEFT JOIN user_address ua on g.goods_order_address=ua.user_address_id LEFT JOIN store s on g.goods_order_store_id=s.store_id LEFT JOIN store_employee se on g.goods_order_employee_id=se.store_employee_id LEFT JOIN admin a on g.goods_order_admin_id=a.admin_id where g.goods_order_id!=0 and ua.user_address_tel=? order by g.goods_order_id desc";
        ResultSet rs = this.jdbc.executeQuery(sql, (Object)tel);
        GoodsOrder order = null;
        ArrayList<GoodsOrder> orderList = new ArrayList<GoodsOrder>();
        while (rs.next()) {
            order = new GoodsOrder();
            order.setId(rs.getInt("goods_order_id"));
            order.setNo(rs.getString("goods_order_no"));
            order.setType(rs.getInt("goods_order_type"));
            order.setFlag(rs.getInt("goods_order_flag"));
            order.setNum(rs.getInt("goods_order_num"));
            order.setOrNum(rs.getInt("goods_order_orNum"));
            order.setServiceDate(rs.getString("goods_order_serviceDate"));
            order.setDayLongs(rs.getString("goods_order_dayLongs"));
            order.setContent(rs.getString("goods_order_content"));
            order.setUser_id(rs.getInt("user_id"));
            order.setUsername(rs.getString("user_username"));
            order.setAdmin_id(rs.getInt("admin_id"));
            order.setAdmin_username(rs.getString("admin_username"));
            order.setStore_id(rs.getInt("store_id"));
            order.setStore_name(rs.getString("store_name"));
            order.setEmployee_id(rs.getString("store_employee_id"));
            order.setEmployee_name(rs.getString("store_employee_name"));
            order.setPrice(rs.getString("goods_order_price"));
            order.setActual_price(rs.getString("goods_order_actual_price"));
            order.setPayFlag(rs.getInt("goods_order_playFlag"));
            order.setContractFlag(rs.getInt("goods_order_contractFlag"));
            order.setAddress_id(rs.getInt("goods_order_address"));
            order.setAddress_content(rs.getString("user_address_content"));
            order.setAddress_person(rs.getString("user_address_name"));
            order.setAddress_tel(rs.getString("user_address_tel"));
            order.setSaveFlag(rs.getInt("goods_order_save"));
            order.setDirection(rs.getInt("goods_order_direction"));
            order.setDirection_person(rs.getString("goods_order_direction_person"));
            order.setDirection_id(rs.getInt("goods_order_direction_id"));
            order.setPay_way(rs.getInt("goods_order_pay_way"));
            order.setGoodsId(rs.getInt("goods_id"));
            order.setGoodsName(rs.getString("goods_name"));
            order.setDesc(rs.getString("goods_order_desc"));
            orderList.add(order);
        }
        this.jdbc.close();
        return orderList;
    }

    public List<GoodsOrder> getGoodsOrderList(Integer pageNo, Integer pageSize, String type, String flag) throws SQLException {
        if (pageNo < 1) {
            pageNo = 1;
        }
        int offset = (pageNo - 1) * pageSize;
        String sql = "select g.*,gd.goods_id,gd.goods_name,u.user_username,u.user_id,ua.*,se.store_employee_id,se.store_employee_name,a.admin_id,a.admin_username,s.store_id,s.store_name from goods_order g left join user u on g.goods_order_user_id=u.user_id left join goods gd on g.goods_order_goods_id=gd.goods_id LEFT JOIN user_address ua on g.goods_order_address=ua.user_address_id LEFT JOIN store s on g.goods_order_store_id=s.store_id LEFT JOIN store_employee se on g.goods_order_employee_id=se.store_employee_id LEFT JOIN admin a on g.goods_order_admin_id=a.admin_id where g.goods_order_id!=0";
        if (type != null && !type.equals("")) {
            sql = String.valueOf(sql) + " and g.goods_order_type=" + type + " ";
        }
        if (flag != null && !flag.equals("")) {
            sql = String.valueOf(sql) + " and g.goods_order_flag=" + flag + " ";
        }
        sql = String.valueOf(sql) + " order by g.goods_order_id desc limit " + offset + "," + pageSize;
        ResultSet rs = this.jdbc.executeQuery(sql);
        GoodsOrder order = null;
        ArrayList<GoodsOrder> orderList = new ArrayList<GoodsOrder>();
        while (rs.next()) {
            order = new GoodsOrder();
            order.setId(rs.getInt("goods_order_id"));
            order.setNo(rs.getString("goods_order_no"));
            order.setType(rs.getInt("goods_order_type"));
            order.setFlag(rs.getInt("goods_order_flag"));
            order.setNum(rs.getInt("goods_order_num"));
            order.setOrNum(rs.getInt("goods_order_orNum"));
            order.setServiceDate(rs.getString("goods_order_serviceDate"));
            order.setDayLongs(rs.getString("goods_order_dayLongs"));
            order.setContent(rs.getString("goods_order_content"));
            order.setUser_id(rs.getInt("user_id"));
            order.setUsername(rs.getString("user_username"));
            order.setAdmin_id(rs.getInt("admin_id"));
            order.setAdmin_username(rs.getString("admin_username"));
            order.setStore_id(rs.getInt("store_id"));
            order.setStore_name(rs.getString("store_name"));
            order.setEmployee_id(rs.getString("store_employee_id"));
            order.setEmployee_name(rs.getString("store_employee_name"));
            order.setPrice(rs.getString("goods_order_price"));
            order.setActual_price(rs.getString("goods_order_actual_price"));
            order.setPayFlag(rs.getInt("goods_order_playFlag"));
            order.setContractFlag(rs.getInt("goods_order_contractFlag"));
            order.setAddress_id(rs.getInt("goods_order_address"));
            order.setAddress_content(rs.getString("user_address_content"));
            order.setAddress_person(rs.getString("user_address_name"));
            order.setAddress_tel(rs.getString("user_address_tel"));
            order.setSaveFlag(rs.getInt("goods_order_save"));
            order.setDirection(rs.getInt("goods_order_direction"));
            order.setDirection_person(rs.getString("goods_order_direction_person"));
            order.setDirection_id(rs.getInt("goods_order_direction_id"));
            order.setPay_way(rs.getInt("goods_order_pay_way"));
            order.setGoodsId(rs.getInt("goods_id"));
            order.setGoodsName(rs.getString("goods_name"));
            order.setDesc(rs.getString("goods_order_desc"));
            orderList.add(order);
        }
        this.jdbc.close();
        return orderList;
    }

    public Integer getGoodsOrderCount(String type, String flag) throws SQLException {
        int resultCount = 0;
        ResultSet rs = null;
        String sql = "select COUNT(*) AS rowcount from goods_order g left join user u on g.goods_order_user_id=u.user_id left join goods gd on g.goods_order_goods_id=gd.goods_id LEFT JOIN user_address ua on g.goods_order_address=ua.user_address_id LEFT JOIN store s on g.goods_order_store_id=s.store_id LEFT JOIN store_employee se on g.goods_order_employee_id=se.store_employee_id LEFT JOIN admin a on g.goods_order_admin_id=a.admin_id where g.goods_order_id!=0";
        if (type != null && !type.equals("")) {
            sql = String.valueOf(sql) + " and g.goods_order_type=" + type + " ";
        }
        if (flag != null && !flag.equals("")) {
            sql = String.valueOf(sql) + " and g.goods_order_flag=" + flag + " ";
        }
        if ((rs = this.jdbc.executeQuery(sql)).next()) {
            resultCount = rs.getInt("rowcount");
        }
        this.jdbc.close();
        return resultCount;
    }

    public GoodsOrder getGoodsOrderById(Integer id) throws SQLException {
        String sql = "select g.*,gd.goods_id,gd.goods_name,u.user_username,u.user_id,ua.*,se.store_employee_id,se.store_employee_name,a.admin_id,a.admin_username,s.store_id,s.store_name from goods_order g left join user u on g.goods_order_user_id=u.user_id left join goods gd on g.goods_order_goods_id=gd.goods_id LEFT JOIN user_address ua on g.goods_order_address=ua.user_address_id LEFT JOIN store s on g.goods_order_store_id=s.store_id LEFT JOIN store_employee se on g.goods_order_employee_id=se.store_employee_id LEFT JOIN admin a on g.goods_order_admin_id=a.admin_id where g.goods_order_id=?";
        ResultSet rs = this.jdbc.executeQuery(sql, (Object)id);
        GoodsOrder order = null;
        if (rs.next()) {
            order = new GoodsOrder();
            order.setId(rs.getInt("goods_order_id"));
            order.setNo(rs.getString("goods_order_no"));
            order.setType(rs.getInt("goods_order_type"));
            order.setFlag(rs.getInt("goods_order_flag"));
            order.setNum(rs.getInt("goods_order_num"));
            order.setOrNum(rs.getInt("goods_order_orNum"));
            order.setServiceDate(rs.getString("goods_order_serviceDate"));
            order.setDayLongs(rs.getString("goods_order_dayLongs"));
            order.setContent(rs.getString("goods_order_content"));
            order.setUser_id(rs.getInt("user_id"));
            order.setUsername(rs.getString("user_username"));
            order.setAdmin_id(rs.getInt("admin_id"));
            order.setAdmin_username(rs.getString("admin_username"));
            order.setStore_id(rs.getInt("store_id"));
            order.setStore_name(rs.getString("store_name"));
            order.setEmployee_id(rs.getString("store_employee_id"));
            order.setEmployee_name(rs.getString("store_employee_name"));
            order.setPrice(rs.getString("goods_order_price"));
            order.setActual_price(rs.getString("goods_order_actual_price"));
            order.setPayFlag(rs.getInt("goods_order_playFlag"));
            order.setContractFlag(rs.getInt("goods_order_contractFlag"));
            order.setAddress_id(rs.getInt("goods_order_address"));
            order.setAddress_content(rs.getString("user_address_content"));
            order.setAddress_person(rs.getString("user_address_name"));
            order.setAddress_tel(rs.getString("user_address_tel"));
            order.setSaveFlag(rs.getInt("goods_order_save"));
            order.setDirection(rs.getInt("goods_order_direction"));
            order.setDirection_person(rs.getString("goods_order_direction_person"));
            order.setDirection_id(rs.getInt("goods_order_direction_id"));
            order.setPay_way(rs.getInt("goods_order_pay_way"));
            order.setGoodsId(rs.getInt("goods_id"));
            order.setGoodsName(rs.getString("goods_name"));
            order.setDesc(rs.getString("goods_order_desc"));
        }
        return order;
    }

    public GoodsOrder getGoodsOrderByNo(String order_no) throws SQLException {
        String sql = "select g.*,gd.goods_id,gd.goods_name,u.user_username,u.user_id,ua.*,se.store_employee_id,se.store_employee_name,a.admin_id,a.admin_username,s.store_id,s.store_name from goods_order g left join user u on g.goods_order_user_id=u.user_id left join goods gd on g.goods_order_goods_id=gd.goods_id LEFT JOIN user_address ua on g.goods_order_address=ua.user_address_id LEFT JOIN store s on g.goods_order_store_id=s.store_id LEFT JOIN store_employee se on g.goods_order_employee_id=se.store_employee_id LEFT JOIN admin a on g.goods_order_admin_id=a.admin_id where g.goods_order_no=?";
        ResultSet rs = this.jdbc.executeQuery(sql, (Object)order_no);
        GoodsOrder order = null;
        if (rs.next()) {
            order = new GoodsOrder();
            order.setId(rs.getInt("goods_order_id"));
            order.setNo(rs.getString("goods_order_no"));
            order.setType(rs.getInt("goods_order_type"));
            order.setFlag(rs.getInt("goods_order_flag"));
            order.setNum(rs.getInt("goods_order_num"));
            order.setOrNum(rs.getInt("goods_order_orNum"));
            order.setServiceDate(rs.getString("goods_order_serviceDate"));
            order.setDayLongs(rs.getString("goods_order_dayLongs"));
            order.setContent(rs.getString("goods_order_content"));
            order.setUser_id(rs.getInt("user_id"));
            order.setUsername(rs.getString("user_username"));
            order.setAdmin_id(rs.getInt("admin_id"));
            order.setAdmin_username(rs.getString("admin_username"));
            order.setStore_id(rs.getInt("store_id"));
            order.setStore_name(rs.getString("store_name"));
            order.setEmployee_id(rs.getString("store_employee_id"));
            order.setEmployee_name(rs.getString("store_employee_name"));
            order.setPrice(rs.getString("goods_order_price"));
            order.setActual_price(rs.getString("goods_order_actual_price"));
            order.setPayFlag(rs.getInt("goods_order_playFlag"));
            order.setContractFlag(rs.getInt("goods_order_contractFlag"));
            order.setAddress_id(rs.getInt("goods_order_address"));
            order.setAddress_content(rs.getString("user_address_content"));
            order.setAddress_person(rs.getString("user_address_name"));
            order.setAddress_tel(rs.getString("user_address_tel"));
            order.setSaveFlag(rs.getInt("goods_order_save"));
            order.setDirection(rs.getInt("goods_order_direction"));
            order.setDirection_person(rs.getString("goods_order_direction_person"));
            order.setDirection_id(rs.getInt("goods_order_direction_id"));
            order.setPay_way(rs.getInt("goods_order_pay_way"));
            order.setGoodsId(rs.getInt("goods_id"));
            order.setDesc(rs.getString("goods_order_desc"));
            order.setGoodsName(rs.getString("goods_name"));
        }
        return order;
    }

    public String updateOrderEnd(Integer order_id, Integer flag) {
        Object[] args = new Object[]{flag, order_id};
        String sql = "UPDATE goods_order SET goods_order_flag = ? where goods_order_id=?";
        int teflag = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (teflag > 0) {
            return "ok";
        }
        return "bad";
    }

    public String updateOrderFlag(Integer id, Integer flag) {
        Object[] args = new Object[]{flag, id};
        String sql = "UPDATE goods_order SET goods_order_flag = ? where goods_order_id=?";
        int teflag = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (teflag > 0) {
            return "ok";
        }
        return "bad";
    }

    public Integer addAddress(Integer userId, String name, String tel, String address) {
        Object[] args = new Object[]{name, tel, address, userId};
        String sql = "insert into user_address (user_address_name,user_address_tel,user_address_content,user_address_user) values(?,?,?,?)";
        Serializable flag = this.jdbc.insertBackId(sql, args);
        this.jdbc.close();
        return flag.hashCode();
    }

    public List<Address> getAddressByUser(Integer userId) throws SQLException {
        String sql = "select a.* from user_address a where a.user_address_user=?";
        ResultSet rs = this.jdbc.executeQuery(sql, (Object)userId);
        Address address = null;
        ArrayList<Address> addressList = new ArrayList<Address>();
        while (rs.next()) {
            address = new Address();
            address.setId(rs.getInt("user_address_id"));
            address.setName(rs.getString("user_address_name"));
            address.setAddress(rs.getString("user_address_content"));
            address.setTel(rs.getString("user_address_tel"));
            addressList.add(address);
        }
        return addressList;
    }

    public Address getAddressById(Integer aadress_id) throws SQLException {
        String sql = "select a.* from user_address a where a.user_address_id=?";
        ResultSet rs = this.jdbc.executeQuery(sql, (Object)aadress_id);
        Address address = null;
        while (rs.next()) {
            address = new Address();
            address.setId(rs.getInt("user_address_id"));
            address.setName(rs.getString("user_address_name"));
            address.setAddress(rs.getString("user_address_content"));
            address.setTel(rs.getString("user_address_tel"));
        }
        return address;
    }

    public String deleteAddress(Integer address_id) {
        String sql = "delete from user_address where user_address_id=?";
        int flag = this.jdbc.executeUpdate(sql, (Object)address_id);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public List<Store> getStoreByPage(Integer pageNo, Integer pageSize) throws SQLException {
        if (pageNo < 1) {
            pageNo = 1;
        }
        int offset = (pageNo - 1) * pageSize;
        ResultSet rs = null;
        String sql = "select g.* from store g limit " + offset + "," + pageSize;
        rs = this.jdbc.executeQuery(sql);
        ArrayList<Store> storeList = new ArrayList<Store>();
        Store store = null;
        while (rs.next()) {
            store = new Store();
            store.setId(rs.getInt("store_id"));
            store.setName(rs.getString("store_name"));
            store.setAddress(rs.getString("store_address"));
            store.setTel(rs.getString("store_tel"));
            store.setFlag(rs.getInt("store_flag"));
            storeList.add(store);
        }
        this.jdbc.close();
        return storeList;
    }

    public List<Store> getAllStore(String employee_ids) throws SQLException {
        ResultSet rs = null;
        String sql = "select s.* from store s where s.store_flag=1 ";
        if (employee_ids != null && !employee_ids.equals("")) {
            sql = String.valueOf(sql) + "and s.store_id not in (" + employee_ids + ")";
        }
        rs = this.jdbc.executeQuery(sql);
        ArrayList<Store> storeList = new ArrayList<Store>();
        Store store = null;
        while (rs.next()) {
            store = new Store();
            store.setId(rs.getInt("store_id"));
            store.setName(rs.getString("store_name"));
            store.setAddress(rs.getString("store_address"));
            store.setTel(rs.getString("store_tel"));
            store.setFlag(rs.getInt("store_flag"));
            storeList.add(store);
        }
        this.jdbc.close();
        return storeList;
    }

    public Integer getStoreCount() throws SQLException {
        int resultCount = 0;
        ResultSet rs = null;
        String sql = "select COUNT(*) AS rowcount from store ";
        rs = this.jdbc.executeQuery(sql);
        if (rs.next()) {
            resultCount = rs.getInt("rowcount");
        }
        this.jdbc.close();
        return resultCount;
    }

    public String addStore(String name, String address, String tel) {
        Object[] args = new Object[]{name, address, tel};
        String sql = "insert into store (store_name,store_address,store_tel) values(?,?,?)";
        int flag = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public String updateStore(Integer id, String name, String address, String tel, Integer state) {
        Object[] args = new Object[]{name, address, tel, state, id};
        String sql = "UPDATE store SET store_name = ?,store_address=?,store_tel=?,store_flag=? where store_id=?";
        int flag = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public String deleteStore(String ids) {
        String sql = "delete from store where store_id in (?)";
        int flag = this.jdbc.executeUpdate(sql, (Object)ids);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public Store getStoreById(Integer store_id) throws SQLException {
        ResultSet rs = null;
        String sql = "select g.* from store g where g.store_id=? ";
        rs = this.jdbc.executeQuery(sql, (Object)store_id);
        Store store = null;
        if (rs.next()) {
            store = new Store();
            store.setId(rs.getInt("store_id"));
            store.setName(rs.getString("store_name"));
            store.setAddress(rs.getString("store_address"));
            store.setTel(rs.getString("store_tel"));
            store.setFlag(rs.getInt("store_flag"));
        }
        this.jdbc.close();
        return store;
    }

    public List<Employee> getEmployeeByStore(Integer store_id) throws SQLException {
        ResultSet rs = null;
        String sql = "select se.* from store_employee se where  se.store_employee_store_id=? ";
        rs = this.jdbc.executeQuery(sql, (Object)store_id);
        ArrayList<Employee> employeeList = new ArrayList<Employee>();
        Employee employee = null;
        while (rs.next()) {
            employee = new Employee();
            employee.setId(rs.getInt("store_employee_id"));
            employee.setName(rs.getString("store_employee_name"));
            employee.setStore_id(rs.getInt("store_employee_store_id"));
            employee.setPass(rs.getString("store_employee_pass"));
            employee.setFlag(rs.getInt("store_employee_flag"));
            employee.setTel(rs.getString("store_employee_tel"));
            employee.setEmail(rs.getString("store_employee_email"));
            employee.setNo(rs.getString("store_employee_no"));
            employee.setShenfen(rs.getString("store_employee_shenfen"));
            employee.setState(rs.getInt("store_employee_sate"));
            employeeList.add(employee);
        }
        this.jdbc.close();
        return employeeList;
    }

    public List<Employee> getEmployeeByPage(Integer pageNo, Integer pageSize) throws SQLException {
        if (pageNo < 1) {
            pageNo = 1;
        }
        int offset = (pageNo - 1) * pageSize;
        ResultSet rs = null;
        String sql = "select se.*,s.store_name from store_employee se,store s where se.store_employee_store_id=s.store_id limit " + offset + "," + pageSize;
        rs = this.jdbc.executeQuery(sql);
        ArrayList<Employee> employeeList = new ArrayList<Employee>();
        Employee employee = null;
        while (rs.next()) {
            employee = new Employee();
            employee.setId(rs.getInt("store_employee_id"));
            employee.setName(rs.getString("store_employee_name"));
            employee.setStore_id(rs.getInt("store_employee_store_id"));
            employee.setStore_name(rs.getString("store_name"));
            employee.setPass(rs.getString("store_employee_pass"));
            employee.setFlag(rs.getInt("store_employee_flag"));
            employee.setTel(rs.getString("store_employee_tel"));
            employee.setEmail(rs.getString("store_employee_email"));
            employee.setNo(rs.getString("store_employee_no"));
            employee.setShenfen(rs.getString("store_employee_shenfen"));
            employee.setState(rs.getInt("store_employee_sate"));
            employeeList.add(employee);
        }
        this.jdbc.close();
        return employeeList;
    }

    public Integer getEmployeeCount() throws SQLException {
        int resultCount = 0;
        ResultSet rs = null;
        String sql = "select COUNT(*) AS rowcount from store_employee se,store s where se.store_employee_store_id=s.store_id";
        rs = this.jdbc.executeQuery(sql);
        if (rs.next()) {
            resultCount = rs.getInt("rowcount");
        }
        this.jdbc.close();
        return resultCount;
    }

    public Integer addEmployee(String name, String store_id, String pass, String md5, String flag, String state, String tel, String email, String no, String shenfen) {
        Object[] args = new Object[]{name, store_id, pass, md5, flag, state, tel, email, no, shenfen};
        String sql = "insert into store_employee (store_employee_name,store_employee_store_id,store_employee_pass,store_employee_md5,store_employee_flag,store_employee_sate,store_employee_tel,store_employee_email,store_employee_no,store_employee_shenfen) values(?,?,?,?,?,?,?,?,?,?)";
        Serializable teflag = this.jdbc.insertBackId(sql, args);
        this.jdbc.close();
        return teflag.hashCode();
    }

    public String updateEmployee(String name, String store_id, String flag, String state, String tel, String email, String id, String shenfen) {
        Object[] args = new Object[]{name, store_id, flag, state, tel, email, shenfen, id};
        String sql = "UPDATE store_employee SET store_employee_name = ?,store_employee_store_id=?,store_employee_flag=?,store_employee_sate=?,store_employee_tel=?,store_employee_email=?,store_employee_shenfen=? where store_employee_id=?";
        int teflag = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (teflag > 0) {
            return "ok";
        }
        return "bad";
    }

    public String deleteEmployee(String ids) {
        String sql = "delete from store_employee where store_employee_id in (?)";
        int flag = this.jdbc.executeUpdate(sql, (Object)ids);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public String updateEmployeePass(Integer id, String pass, String md5) {
        Object[] args = new Object[]{pass, md5, id};
        String sql = "UPDATE store_employee SET store_employee_pass = ?,store_employee_md5=? where store_employee_id=?";
        int teflag = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (teflag > 0) {
            return "ok";
        }
        return "bad";
    }

    public Employee getEmployeeByNoAndMd5(String no, String md5) throws SQLException {
        Object[] args = new Object[]{no, md5};
        ResultSet rs = null;
        String sql = "select s.* from store_employee s where s.store_employee_no=? and store_employee_md5=?";
        rs = this.jdbc.executeQuery(sql, args);
        Employee employee = null;
        if (rs.next()) {
            employee = new Employee();
            employee.setId(rs.getInt("store_employee_id"));
            employee.setName(rs.getString("store_employee_name"));
            employee.setStore_id(rs.getInt("store_employee_store_id"));
            employee.setPass(rs.getString("store_employee_pass"));
            employee.setFlag(rs.getInt("store_employee_flag"));
            employee.setTel(rs.getString("store_employee_tel"));
            employee.setEmail(rs.getString("store_employee_email"));
            employee.setNo(rs.getString("store_employee_no"));
            employee.setShenfen(rs.getString("store_employee_shenfen"));
            employee.setState(rs.getInt("store_employee_sate"));
        }
        this.jdbc.close();
        return employee;
    }

    public Employee getEmployeeByid(String id) throws SQLException {
        ResultSet rs = null;
        String sql = "select s.* from store_employee s where s.store_employee_id=?";
        rs = this.jdbc.executeQuery(sql, (Object)id);
        Employee employee = null;
        if (rs.next()) {
            employee = new Employee();
            employee.setId(rs.getInt("store_employee_id"));
            employee.setName(rs.getString("store_employee_name"));
            employee.setStore_id(rs.getInt("store_employee_store_id"));
            employee.setPass(rs.getString("store_employee_pass"));
            employee.setFlag(rs.getInt("store_employee_flag"));
            employee.setTel(rs.getString("store_employee_tel"));
            employee.setEmail(rs.getString("store_employee_email"));
            employee.setNo(rs.getString("store_employee_no"));
            employee.setShenfen(rs.getString("store_employee_shenfen"));
            employee.setState(rs.getInt("store_employee_sate"));
        }
        this.jdbc.close();
        return employee;
    }

    public boolean getEmployeeByTelAndShenfen(String tel, String shenfen) throws SQLException {
        ResultSet rs = null;
        String sql = "select s.store_employee_id from store_employee s where s.store_employee_tel=? and s.store_employee_shenfen=?";
        Object[] args = new String[]{tel, shenfen};
        rs = this.jdbc.executeQuery(sql, args);
        if (rs.next()) {
            return true;
        }
        this.jdbc.close();
        return false;
    }

    public boolean getEmployeeByNo(String no) throws SQLException {
        ResultSet rs = null;
        String sql = "select s.store_employee_id from store_employee s where s.store_employee_no=?";
        Object[] args = new String[]{no};
        rs = this.jdbc.executeQuery(sql, args);
        if (rs.next()) {
            return true;
        }
        this.jdbc.close();
        return false;
    }

    public String addEmployeeManagerStore(String employee_id, String store_id) {
        Object[] args = new Object[]{employee_id, store_id};
        String sql = "insert into store_data (store_data_employee,store_data_store) values(?,?)";
        int flag = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public List<EmployeeAndStore> getEmployeeAndStoreData(Integer employee_id) throws SQLException {
        ResultSet rs = null;
        String sql = "select s.store_name,s.store_id,se.store_employee_id,se.store_employee_name from store_data sd,store_employee se,store s where s.store_id=sd.store_data_store and se.store_employee_id=sd.store_data_employee and sd.store_data_employee=?";
        rs = this.jdbc.executeQuery(sql, (Object)employee_id);
        EmployeeAndStore employee = null;
        ArrayList<EmployeeAndStore> employeeList = new ArrayList<EmployeeAndStore>();
        while (rs.next()) {
            employee = new EmployeeAndStore();
            employee.setEmployee_id(rs.getInt("store_employee_id"));
            employee.setEmployee_name(rs.getString("store_employee_name"));
            employee.setStore_id(rs.getInt("store_id"));
            employee.setStore_name(rs.getString("store_name"));
            employeeList.add(employee);
        }
        this.jdbc.close();
        return employeeList;
    }

    public String deleteEmployeeManageData(String ids) {
        String sql = "delete from store_data where store_data_employee =?";
        int flag = this.jdbc.executeUpdate(sql, (Object)ids);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public String addContent(Integer id, String content, Integer flag, Integer derection, Integer derection_id, String derection_name) {
        SimpleDateFormat format2 = new SimpleDateFormat("yyyy-MM-dd HH");
        Date dDate = new Date();
        String time = format2.format(dDate);
        Object[] args = new Object[]{id, content, flag, derection, derection_id, derection_name, time};
        String sql = "insert into connect_detail (connect_detail_infoid,connect_detail_content,connect_detail_flag,connect_detail_derection,connect_detail_derection_id,connect_detail_derection_name,connect_detail_date) values(?,?,?,?,?,?,?)";
        int teflag = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (teflag > 0) {
            return "ok";
        }
        return "bad";
    }

    public List<Connect> getConnectList(Integer id, Integer flag, Integer pageNo, Integer pageSize) throws SQLException {
        if (pageNo < 1) {
            pageNo = 1;
        }
        int offset = (pageNo - 1) * pageSize;
        ResultSet rs = null;
        Object[] args = new Integer[]{id, flag};
        String sql = "select cd.* from connect_detail cd where cd.connect_detail_infoid=? and cd.connect_detail_flag=? order by cd.connect_detail_id desc limit " + offset + "," + pageSize;
        rs = this.jdbc.executeQuery(sql, args);
        ArrayList<Connect> connectList = new ArrayList<Connect>();
        Connect connect = null;
        while (rs.next()) {
            connect = new Connect();
            connect.setId(rs.getInt("connect_detail_id"));
            connect.setInfoid(rs.getInt("connect_detail_infoid"));
            connect.setFlag(rs.getInt("connect_detail_flag"));
            connect.setDirection(rs.getInt("connect_detail_derection"));
            connect.setDirection_id(rs.getInt("connect_detail_derection_id"));
            connect.setDirection_person(rs.getString("connect_detail_derection_name"));
            connect.setDate(rs.getString("connect_detail_date"));
            connect.setContent(rs.getString("connect_detail_content"));
            connectList.add(connect);
        }
        this.jdbc.close();
        return connectList;
    }

    public Integer getConnectCount(Integer id, Integer flag) throws SQLException {
        int resultCount = 0;
        ResultSet rs = null;
        String sql = "select COUNT(*) AS rowcount from connect_detail where connect_detail_infoid=? and connect_detail_flag=?";
        Object[] args = new Integer[]{id, flag};
        rs = this.jdbc.executeQuery(sql, args);
        if (rs.next()) {
            resultCount = rs.getInt("rowcount");
        }
        this.jdbc.close();
        return resultCount;
    }

    public Integer addAunt(String name, String head, Integer type, String birthday, Integer decretion, Integer decretion_id, String decretion_name, String no, String tel, Integer flag, String con_stardate, String con_enddate, String desc) {
        Object[] args = new Object[]{name, head, type, birthday, decretion, decretion_id, decretion_name, no, tel, flag, con_stardate, con_enddate, desc};
        String sql = "insert into aunt (aunt_name,aunt_head,aunt_type,aunt_birthday,aunt_decretion,aunt_decretion_id,aunt_decretion_name,aunt_no,aunt_tel,aunt_flag,aunt_con_startdate,aunt_con_enddate,aunt_con_desc) values(?,?,?,?,?,?,?,?,?,?,?,?,?)";
        Serializable teflag = this.jdbc.insertBackId(sql, args);
        return teflag.hashCode();
    }

    public Aunt getAuntById(Integer id) throws SQLException {
        ResultSet rs = null;
        String sql = "select a.* from aunt a where a.aunt_id=?";
        rs = this.jdbc.executeQuery(sql, (Object)id);
        Aunt aunt = null;
        if (rs.next()) {
            aunt = new Aunt();
            aunt.setId(id);
            aunt.setName(rs.getString("aunt_name"));
            aunt.setTel(rs.getString("aunt_tel"));
            aunt.setNo(rs.getString("aunt_no"));
            aunt.setFlag(rs.getInt("aunt_flag"));
            aunt.setHead(rs.getString("aunt_head"));
            aunt.setType(rs.getInt("aunt_type"));
            aunt.setBirthday(rs.getString("aunt_birthday"));
            aunt.setDecretion(rs.getInt("aunt_decretion"));
            aunt.setDecretion_id(rs.getInt("aunt_decretion_id"));
            aunt.setDecretion_name(rs.getString("aunt_decretion_name"));
            aunt.setCon_enddate(rs.getString("aunt_con_enddate"));
            aunt.setCon_stardate(rs.getString("aunt_con_startdate"));
            aunt.setDesc(rs.getString("aunt_con_desc"));
        }
        this.jdbc.close();
        return aunt;
    }

    public List<Aunt> getAuntList(Integer pageNo, Integer pageSize, Integer flag) throws SQLException {
        if (pageNo < 1) {
            pageNo = 1;
        }
        int offset = (pageNo - 1) * pageSize;
        String sql = "select a.* from aunt a where a.aunt_id!=0";
        if (flag != null) {
            sql = String.valueOf(sql) + " and a.aunt_flag=" + flag;
        }
        sql = String.valueOf(sql) + " order by a.aunt_id desc limit " + offset + "," + pageSize;
        ResultSet rs = this.jdbc.executeQuery(sql);
        Aunt aunt = null;
        ArrayList<Aunt> auntList = new ArrayList<Aunt>();
        while (rs.next()) {
            aunt = new Aunt();
            aunt.setId(rs.getInt("aunt_id"));
            aunt.setName(rs.getString("aunt_name"));
            aunt.setTel(rs.getString("aunt_tel"));
            aunt.setNo(rs.getString("aunt_no"));
            aunt.setFlag(rs.getInt("aunt_flag"));
            aunt.setHead(rs.getString("aunt_head"));
            aunt.setType(rs.getInt("aunt_type"));
            aunt.setBirthday(rs.getString("aunt_birthday"));
            aunt.setDecretion(rs.getInt("aunt_decretion"));
            aunt.setDecretion_id(rs.getInt("aunt_decretion_id"));
            aunt.setDecretion_name(rs.getString("aunt_decretion_name"));
            aunt.setCon_enddate(rs.getString("aunt_con_enddate"));
            aunt.setCon_stardate(rs.getString("aunt_con_startdate"));
            aunt.setDesc(rs.getString("aunt_con_desc"));
            auntList.add(aunt);
        }
        this.jdbc.close();
        return auntList;
    }

    public Integer getAuntCount(Integer flag) throws SQLException {
        int resultCount = 0;
        ResultSet rs = null;
        String sql = "select COUNT(*) AS rowcount from aunt a where a.aunt_id!=0 ";
        if (flag != null) {
            sql = String.valueOf(sql) + "and a.aunt_flag=" + flag;
        }
        if ((rs = this.jdbc.executeQuery(sql)).next()) {
            resultCount = rs.getInt("rowcount");
        }
        this.jdbc.close();
        return resultCount;
    }

    public boolean getAuntByNo(String no) throws SQLException {
        ResultSet rs = null;
        String sql = "select a.* from aunt a where a.aunt_no=? ";
        rs = this.jdbc.executeQuery(sql, (Object)no);
        if (rs.next()) {
            this.jdbc.close();
            return true;
        }
        this.jdbc.close();
        return false;
    }

    public String updateAunt(Integer aunt_id, Integer flag, String con_stardate, String con_enddate) {
        Object[] args = new Object[]{flag, con_enddate, con_enddate, aunt_id};
        String sql = "UPDATE aunt SET aunt_flag = ?,aunt_con_startdate=?,aunt_con_enddate=? where aunt_id=?";
        int teflag = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (teflag > 0) {
            return "ok";
        }
        return "bad";
    }

    public String deleteAunt(String ids) {
        String sql = "delete from aunt where aunt_id in (" + ids + ")";
        int flag = this.jdbc.executeUpdate(sql);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public Integer addAuntImg(Integer aunt_id, String img_path, String small_img, String flag) {
        Object[] args = new Object[]{aunt_id, img_path, small_img, flag};
        String sql = "insert into aunt_img (aunt_img_aunt,aunt_img_path,aunt_img_small_path,aunt_img_flag) values(?,?,?,?)";
        Serializable teflag = this.jdbc.insertBackId(sql, args);
        this.jdbc.close();
        return teflag.hashCode();
    }

    public String deleteAuntImg(Integer img_id) {
        String sql = "delete from aunt_img where aunt_img_id=?";
        int flag = this.jdbc.executeUpdate(sql, (Object)img_id);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public List<AuntImg> getAuntImgByAunt(Integer aunt_id, String flag) throws SQLException {
        ResultSet rs = null;
        Object[] args = new Object[]{aunt_id, flag};
        String sql = "select ai.* from aunt_img ai where ai.aunt_img_aunt=? and ai.aunt_img_flag=? order by ai.aunt_img_id asc";
        rs = this.jdbc.executeQuery(sql, args);
        AuntImg img = null;
        ArrayList<AuntImg> imgList = new ArrayList<AuntImg>();
        while (rs.next()) {
            img = new AuntImg();
            img.setId(rs.getInt("aunt_img_id"));
            img.setAunt_id(rs.getInt("aunt_img_aunt"));
            img.setImg_path(rs.getString("aunt_img_path"));
            img.setSmall_path(rs.getString("aunt_img_small_path"));
            imgList.add(img);
        }
        this.jdbc.close();
        return imgList;
    }

    public List<Comment> getCommentByCmsId(Integer pageNo, Integer pageSize, Integer flag, String id, String mid) throws SQLException {
        Object[] args = new Object[]{id, mid, flag};
        ResultSet rs = null;
        if (pageNo < 1) {
            pageNo = 1;
        }
        int offset = (pageNo - 1) * pageSize;
        ArrayList<Comment> commentList = new ArrayList<Comment>();
        if (flag == null) {
            Object[] args1 = new Object[]{id, mid};
            String sql = "select c.*,u.* from comment c,userbase u where c.comment_cms=? and c.comment_mode=? and c.comment_user=u.userbase_username order by c.comment_id desc limit " + offset + "," + pageSize;
            rs = this.jdbc.executeQuery(sql, args1);
        } else {
            String sql = "select c.*,u.* from comment c,userbase u where c.comment_cms=? and c.comment_mode=? and c.comment_flag=? and c.comment_user=u.userbase_username order by c.comment_id desc limit " + offset + "," + pageSize;
            rs = this.jdbc.executeQuery(sql, args);
        }
        Comment comment = null;
        while (rs.next()) {
            comment = new Comment();
            comment.setId(rs.getString("comment_id"));
            comment.setDate(rs.getString("comment_date"));
            comment.setTitle(rs.getString("comment_tile"));
            comment.setContent(rs.getString("comment_content"));
            comment.setUser(rs.getString("comment_user"));
            comment.setUserImg(rs.getString("userbase_headimg"));
            comment.setNick(rs.getString("comment_user"));
            comment.setCms(rs.getString("comment_cms"));
            comment.setMode(rs.getString("comment_mode"));
            comment.setGrade(rs.getString("comment_grade"));
            comment.setGrade_img(rs.getString("comment_grade_img"));
            comment.setFlag(rs.getString("comment_flag"));
            commentList.add(comment);
        }
        this.jdbc.close();
        return commentList;
    }

    public Integer getCommentCount(String id, String mid, Integer flag) throws SQLException {
        int resultCount = 0;
        Object[] args = new Object[]{id, mid, flag};
        Object[] args1 = new Object[]{id, mid};
        ResultSet rs = null;
        if (flag == null) {
            String sql = "select COUNT(*) AS rowcount from comment c,userbase u where c.comment_cms=? and c.comment_mode=? and c.comment_user=u.userbase_username";
            rs = this.jdbc.executeQuery(sql, args1);
        } else {
            String sql = "select COUNT(*) AS rowcount from comment c,userbase u where c.comment_cms=? and c.comment_mode=? and c.comment_flag=? and c.comment_user=u.userbase_username";
            rs = this.jdbc.executeQuery(sql, args);
        }
        if (rs.next()) {
            resultCount = rs.getInt("rowcount");
        }
        this.jdbc.close();
        return resultCount;
    }

    public String updateBatchComment(String ids, String flag) {
        System.out.println(ids);
        Object[] args = new Object[]{flag};
        String sql = "update comment set comment_flag = ? where comment_id in (" + ids + ")";
        int teflag = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (teflag > 0) {
            return "ok";
        }
        return "bad";
    }

    public String updateComment(String id, String flag) {
        Object[] args = new Object[]{flag, id};
        String sql = "update comment set comment_flag = ? where comment_id =?";
        int teflag = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (teflag > 0) {
            return "ok";
        }
        return "bad";
    }

    public String deleteComment(String ids) {
        String sql = "delete from comment where comment_id in (" + ids + ")";
        int flag = this.jdbc.executeUpdate(sql, (Object)ids);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public List<Aunt> getAuntOrderScore(Integer pageNo, Integer pageSize) throws SQLException {
        if (pageNo < 1) {
            pageNo = 1;
        }
        int offset = (pageNo - 1) * pageSize;
        String sql = "select a.*,(select avg(c.comment_grade) as oar from comment c where c.comment_mode='aunt' and c.comment_cms=a.aunt_id) as aav from aunt a where a.aunt_id!=0 order by aav limit " + offset + "," + pageSize;
        ResultSet rs = this.jdbc.executeQuery(sql);
        Aunt aunt = null;
        ArrayList<Aunt> auntList = new ArrayList<Aunt>();
        while (rs.next()) {
            aunt = new Aunt();
            aunt.setId(rs.getInt("aunt_id"));
            aunt.setName(rs.getString("aunt_name"));
            aunt.setTel(rs.getString("aunt_tel"));
            aunt.setNo(rs.getString("aunt_no"));
            aunt.setFlag(rs.getInt("aunt_flag"));
            aunt.setHead(rs.getString("aunt_head"));
            aunt.setType(rs.getInt("aunt_type"));
            aunt.setBirthday(rs.getString("aunt_birthday"));
            aunt.setDecretion(rs.getInt("aunt_decretion"));
            aunt.setDecretion_id(rs.getInt("aunt_decretion_id"));
            aunt.setDecretion_name(rs.getString("aunt_decretion_name"));
            aunt.setCon_enddate(rs.getString("aunt_con_enddate"));
            aunt.setCon_stardate(rs.getString("aunt_con_startdate"));
            aunt.setDesc(rs.getString("aunt_con_desc"));
            int score = 0;
            Double score_dou = rs.getDouble("aav");
            if (score_dou != null) {
                score = score_dou.intValue();
                aunt.setScore(score);
            } else {
                aunt.setScore(0);
            }
            auntList.add(aunt);
        }
        this.jdbc.close();
        return auntList;
    }

    public List<CombineMarket> getCombineMarketList(Integer pageNo, Integer pageSize, Integer flag, String cerrentDate) throws SQLException {
        if (pageNo < 1) {
            pageNo = 1;
        }
        int offset = (pageNo - 1) * pageSize;
        String sql = "";
        sql = String.valueOf(sql) + "select cm.* from combine_market cm where cm.combine_market_id!=0 ";
        if (flag != null) {
            sql = String.valueOf(sql) + "and cm.combine_market_flag=" + flag + " ";
        }
        if (cerrentDate != null && !cerrentDate.equals("")) {
            sql = String.valueOf(sql) + "and cm.combine_market_starttime<='" + cerrentDate + "' and cm.combine_market_enddate>='" + cerrentDate + "' ";
        }
        sql = String.valueOf(sql) + "order by cm.combine_market_id desc limit " + offset + "," + pageSize;
        ResultSet rs = this.jdbc.executeQuery(sql);
        CombineMarket market = null;
        ArrayList<CombineMarket> marketList = new ArrayList<CombineMarket>();
        while (rs.next()) {
            market = new CombineMarket();
            market.setId(rs.getInt("combine_market_id"));
            market.setTitle(rs.getString("combine_market_title"));
            market.setKeywords(rs.getString("combine_market_keywords"));
            market.setDesc(rs.getString("combine_market_desc"));
            market.setPrice(rs.getString("combine_market_price"));
            market.setStartDate(rs.getString("combine_market_starttime"));
            market.setEndDate(rs.getString("combine_market_enddate"));
            market.setFlag(rs.getInt("combine_market_flag"));
            market.setImg(rs.getString("combine_market_img"));
            market.setLongText(rs.getString("combine_market_long_desc"));
            String goodsSql = "select g.goods_id,g.goods_name,g.goods_thumb,g.shop_price from combine_market cm,goods g,combine_market_goods cmg where cmg.combine_market_goods_id=g.goods_id and cmg.combine_market_active_id=cm.combine_market_id and cm.combine_market_id=?";
            ResultSet rsGoods = this.jdbc.executeQuery(goodsSql, (Object)market.getId());
            ArrayList<GoodsPojo> goodsList = new ArrayList<GoodsPojo>();
            GoodsPojo goodsTem = null;
            while (rsGoods.next()) {
                goodsTem = new GoodsPojo();
                goodsTem.setGoodsId(rsGoods.getInt("goods_id"));
                goodsTem.setGoodsName(rsGoods.getString("goods_name"));
                goodsTem.setGoodsThumb(rsGoods.getString("goods_thumb"));
                goodsTem.setShopPrice(rsGoods.getString("shop_price"));
                goodsList.add(goodsTem);
            }
            market.setGoodsList(goodsList);
            List<AuntImg> imgList = this.getAuntImgByAunt(market.getId(), "cm");
            market.setImgList(imgList);
            marketList.add(market);
        }
        this.jdbc.close();
        return marketList;
    }

    public Integer getCombineMarketCount(Integer flag, String cerrentDate) throws SQLException {
        int resultCount = 0;
        ResultSet rs = null;
        String sql = "select COUNT(*) AS rowcount from combine_market cm where cm.combine_market_id!=0 ";
        if (flag != null) {
            sql = String.valueOf(sql) + "and cm.combine_market_flag=" + flag + " ";
        }
        if (cerrentDate != null && !cerrentDate.equals("")) {
            sql = String.valueOf(sql) + "and cm.combine_market_starttime<='" + cerrentDate + "' and cm.combine_market_enddate>='" + cerrentDate + "' ";
        }
        if ((rs = this.jdbc.executeQuery(sql)).next()) {
            resultCount = rs.getInt("rowcount");
        }
        this.jdbc.close();
        return resultCount;
    }

    public String updateCombineMarketFlag(Integer market_id, Integer flag) {
        Object[] args = new Object[]{flag, market_id};
        String sql = "update combine_market set combine_market_flag = ? where combine_market_id =?";
        int teflag = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (teflag > 0) {
            return "ok";
        }
        return "bad";
    }

    public String updateCombineMarket(Integer market_id, String title, String keywords, String desc, String price, String startDate, String endDate, String img) throws Exception {
        Object[] args = new Object[]{title, keywords, desc, price, startDate, endDate, img, market_id};
        String sql = "UPDATE combine_market SET combine_market_title =?,combine_market_keywords=?,combine_market_desc=?,combine_market_price=?,combine_market_starttime=?,combine_market_enddate=?,combine_market_img=? WHERE combine_market_id=?";
        int teflag = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (teflag > 0) {
            return "ok";
        }
        return "bad";
    }

    public String updateCombineMarket(Integer market_id, String longText) {
        Object[] args = new Object[]{longText, market_id};
        String sql = "UPDATE combine_market SET combine_market_long_desc =? WHERE combine_market_id=?";
        int teflag = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (teflag > 0) {
            return "ok";
        }
        return "bad";
    }

    public String deleteCombineMarket(String ids) {
        this.deleteCombineMarketGoods(ids);
        String sql = "delete from combine_market where combine_market_id in (" + ids + ")";
        int flag = this.jdbc.executeUpdate(sql);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public CombineMarket getCombineMarketById(Integer market_id) throws SQLException {
        String sql = "select cm.* from combine_market cm where cm.combine_market_id=?";
        ResultSet rs = this.jdbc.executeQuery(sql, (Object)market_id);
        CombineMarket market = null;
        if (rs.next()) {
            market = new CombineMarket();
            market.setId(rs.getInt("combine_market_id"));
            market.setTitle(rs.getString("combine_market_title"));
            market.setKeywords(rs.getString("combine_market_keywords"));
            market.setDesc(rs.getString("combine_market_desc"));
            market.setPrice(rs.getString("combine_market_price"));
            market.setStartDate(rs.getString("combine_market_starttime"));
            market.setEndDate(rs.getString("combine_market_enddate"));
            market.setFlag(rs.getInt("combine_market_flag"));
            market.setImg(rs.getString("combine_market_img"));
            market.setLongText(rs.getString("combine_market_long_desc"));
            String goodsSql = "select g.goods_id,g.goods_name,g.goods_thumb,g.shop_price,cmg.combine_market_price from combine_market cm,goods g,combine_market_goods cmg where cmg.combine_market_goods_id=g.goods_id and cmg.combine_market_active_id=cm.combine_market_id and cm.combine_market_id=?";
            ResultSet rsGoods = this.jdbc.executeQuery(goodsSql, (Object)market.getId());
            ArrayList<GoodsPojo> goodsList = new ArrayList<GoodsPojo>();
            GoodsPojo goodsTem = null;
            while (rsGoods.next()) {
                goodsTem = new GoodsPojo();
                goodsTem.setGoodsId(rsGoods.getInt("goods_id"));
                goodsTem.setGoodsName(rsGoods.getString("goods_name"));
                goodsTem.setGoodsThumb(rsGoods.getString("goods_thumb"));
                goodsTem.setShopPrice(rsGoods.getString("combine_market_price"));
                goodsList.add(goodsTem);
            }
            market.setGoodsList(goodsList);
            List<AuntImg> imgList = this.getAuntImgByAunt(market.getId(), "cm");
            market.setImgList(imgList);
        }
        this.jdbc.close();
        return market;
    }

    public Integer addCombineMarket(String title, String keywords, String desc, String price, String startDate, String endDate, String img) {
        Object[] args = new Object[]{title, keywords, desc, price, startDate, endDate, img};
        String sql = "insert into combine_market (combine_market_title,combine_market_keywords,combine_market_desc,combine_market_price,combine_market_starttime,combine_market_enddate,combine_market_img) values(?,?,?,?,?,?,?)";
        Serializable teflag = this.jdbc.insertBackId(sql, args);
        this.jdbc.close();
        return teflag.hashCode();
    }

    public String addCombineMarketGoods(Integer market_id, Integer goods_id, String price) {
        Object[] args = new Object[]{goods_id, market_id, price};
        String sql = "insert into combine_market_goods (combine_market_goods_id,combine_market_active_id,combine_market_price) values(?,?,?)";
        int flag = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public String deleteCombineMarketGoods(String ids) {
        String sql = "delete from combine_market_goods where combine_market_active_id in (" + ids + ")";
        int flag = this.jdbc.executeUpdate(sql);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public List<GoodsCategory> getCategoryList(Integer parent_id) throws SQLException {
        String sqlGoodsCat = "select gc.* from goods_category gc where gc.goods_category_parent=?";
        ResultSet rs = this.jdbc.executeQuery(sqlGoodsCat, (Object)parent_id);
        ArrayList<GoodsCategory> catList = new ArrayList<GoodsCategory>();
        GoodsCategory cat = null;
        while (rs.next()) {
            cat = new GoodsCategory();
            cat.setId(rs.getInt("goods_category_id"));
            cat.setName(rs.getString("goods_category_name"));
            cat.setTitle(rs.getString("goods_category_title"));
            cat.setKeywords(rs.getString("goods_category_keywords"));
            catList.add(cat);
        }
        return catList;
    }

    public List<GoodsPojo> getGoodsPojoListByTypeAndcatAndBranAndPrice(Integer pageNo, Integer pageSize, String cat_ids, String type_ids, String brand_ids, String price, String order) throws SQLException {
        if (pageNo < 1) {
            pageNo = 1;
        }
        int offset = (pageNo - 1) * pageSize;
        String sql = "select gd.*,gt.goods_type_name,gt.goods_type_id from goods gd,goods_type gt where gd.is_shelves=1";
        if (cat_ids != null && !cat_ids.equals("")) {
            sql = String.valueOf(sql) + " and gd.category_id in (" + cat_ids + ") and gd.goods_type=gt.goods_type_id";
        }
        if (type_ids != null && !type_ids.equals("")) {
            sql = String.valueOf(sql) + " and gd.goods_type in (" + type_ids + ")";
        }
        if (brand_ids != null && !brand_ids.equals("")) {
            sql = String.valueOf(sql) + " and gd.brand_id in (" + brand_ids + ")";
        }
        if (price != null && !price.equals("x")) {
            String[] price_arr = price.split("-");
            sql = !price_arr[1].equals("x") ? String.valueOf(sql) + " and gd.shop_price>=" + price_arr[0] + " and gd.shop_price<=" + price_arr[1] : String.valueOf(sql) + " and gd.shop_price>=" + price_arr[0] + " ";
        }
        if (order != null && !order.equals("extension")) {
            sql = String.valueOf(sql) + " order by gd.extension_code desc";
        } else if (order != null && !order.equals("extension")) {
            sql = String.valueOf(sql) + " order by gd.shop_price desc";
        } else if (order == null || order.equals("")) {
            sql = String.valueOf(sql) + " order by gd.goods_id desc";
        }
        sql = String.valueOf(sql) + " limit " + offset + "," + pageSize;
        ResultSet rs = this.jdbc.executeQuery(sql);
        GoodsPojo goods = null;
        ArrayList<GoodsPojo> goodsList = new ArrayList<GoodsPojo>();
        while (rs.next()) {
            goods = new GoodsPojo();
            GoodsType goodsType = new GoodsType();
            goods.setGoodsId(rs.getInt("goods_id"));
            goods.setGoodsSn(rs.getString("goods_sn"));
            goods.setGoodsName(rs.getString("goods_name"));
            goods.setGoodsNameStyle(rs.getString("goods_name_style"));
            goods.setClickCount(rs.getInt("click_count"));
            goods.setGoodsWeight(rs.getString("goods_weight"));
            goods.setMarketPrice(rs.getString("market_price"));
            goods.setShopPrice(rs.getString("shop_price"));
            goods.setPromotePrice(rs.getString("promote_price"));
            goods.setPromoteStartDate(rs.getString("promote_start_date"));
            goods.setPromoteEndDate(rs.getString("promote_end_date"));
            goods.setGoodsNumber(rs.getInt("goods_number"));
            goods.setWarnNumber(rs.getInt("warn_number"));
            goods.setKeywords(rs.getString("keywords"));
            goods.setGoodsBrief(rs.getString("goods_brief"));
            goods.setGoodsDesc(rs.getString("goods_desc"));
            goods.setGoodsThumb(rs.getString("goods_thumb"));
            goods.setGoodsImg(rs.getString("goods_img"));
            goods.setOriginalImg(rs.getString("original_img"));
            goods.setIsReal(rs.getInt("is_real"));
            goods.setExtensionCode(rs.getString("extension_code"));
            goods.setIsOnSale(rs.getInt("is_on_sale"));
            goods.setIsShipping(rs.getInt("Is_shipping"));
            goods.setIntegral(rs.getInt("integral"));
            goods.setAddTime(rs.getString("add_time"));
            goods.setIsDelete(rs.getInt("is_delete"));
            goods.setSortOrder(rs.getInt("sort_order"));
            goods.setIsBest(rs.getInt("is_best"));
            goods.setIsNew(rs.getInt("is_new"));
            goods.setIsHot(rs.getInt("is_hot"));
            goods.setIsPromote(rs.getInt("is_promote"));
            goods.setBonusTypeId(rs.getInt("bonus_type_id"));
            goods.setLastUpdate(rs.getString("last_update"));
            goods.setSellerNote(rs.getString("seller_note"));
            goods.setGiveIntegral(rs.getInt("give_integral"));
            goods.setIsShelves(rs.getInt("is_shelves"));
            goodsType.setName(rs.getString("goods_type_name"));
            goodsType.setId(rs.getInt("goods_type_id"));
            goods.setGoodsType(goodsType);
            goods.setUserPrice(rs.getString("user_price"));
            goods.setConsPrice(rs.getString("cons_price"));
            goods.setVipPrice(rs.getString("vip_price"));
            GoodsAttr attr = null;
            ArrayList<GoodsAttr> attrList = new ArrayList<GoodsAttr>();
            String sqlAttr = "select a.*,gt.goods_type_attribute_name from goods_attr a,goods_type_attribute gt where a.attr_id=gt.goods_type_attribute_id and a.goods_id=?";
            ResultSet rsAttr = this.jdbc.executeQuery(sqlAttr, (Object)goods.getGoodsId());
            while (rsAttr.next()) {
                attr = new GoodsAttr();
                attr.setId(rsAttr.getInt("goods_attr_id"));
                attr.setAttr_id(rsAttr.getInt("attr_id"));
                attr.setGoods_id(rsAttr.getInt("goods_id"));
                attr.setValue(rsAttr.getString("goods_attr_value"));
                attr.setPrice(rsAttr.getString("goods_attr_price"));
                attr.setName(rsAttr.getString("goods_type_attribute_name"));
                attrList.add(attr);
                goods.setAttrList(attrList);
            }
            goodsList.add(goods);
        }
        this.jdbc.close();
        return goodsList;
    }

    public Integer getGoodsPojoListByTypeAndcatAndBranAndPriceCount(String cat_ids, String type_ids, String brand_ids, String price) throws SQLException {
        int resultCount = 0;
        ResultSet rs = null;
        String sql = "select COUNT(*) AS rowcount from goods gd,goods_type gt  where gd.is_shelves=1";
        if (cat_ids != null && !cat_ids.equals("")) {
            sql = String.valueOf(sql) + " and gd.category_id in (" + cat_ids + ") and gd.goods_type=gt.goods_type_id";
        }
        if (type_ids != null && !type_ids.equals("")) {
            sql = String.valueOf(sql) + " and gd.goods_type in (" + type_ids + ")";
        }
        if (brand_ids != null && !brand_ids.equals("")) {
            sql = String.valueOf(sql) + " and gd.brand_id in (" + brand_ids + ")";
        }
        if (price != null && !price.equals("x")) {
            String[] price_arr = price.split("-");
            sql = !price_arr[1].equals("x") ? String.valueOf(sql) + " and gd.shop_price>=" + price_arr[0] + " and gd.shop_price<=" + price_arr[1] : String.valueOf(sql) + " and gd.shop_price>=" + price_arr[0] + " ";
        }
        if ((rs = this.jdbc.executeQuery(sql)).next()) {
            resultCount = rs.getInt("rowcount");
        }
        this.jdbc.close();
        return resultCount;
    }

    public User getUserByTelAndPass(String tel, String pass) throws SQLException {
        Md5Util md5 = new Md5Util();
        Object[] args = new String[]{tel, Md5Util.getMD5Str((String)pass)};
        ResultSet rs = null;
        String sql = "select u.*,ut.* from user u,user_type ut where user_tel=? and user_pass_md5=?";
        rs = this.jdbc.executeQuery(sql, args);
        ArrayList<User> userList = new ArrayList<User>();
        User user = null;
        while (rs.next()) {
            user = new User();
            user.setId(rs.getInt("user_id"));
            user.setUsername(rs.getString("user_username"));
            user.setPass(rs.getString("user_pass"));
            user.setMd5(rs.getString("user_pass_md5"));
            user.setTel(rs.getString("user_tel"));
            user.setEmail(rs.getString("user_email"));
            user.setType(rs.getString("user_type"));
            user.setTypeName(rs.getString("user_type_name"));
            user.setName(rs.getString("user_name"));
            user.setFlag(rs.getString("user_flag"));
            user.setFlagName(rs.getString("user_flag"));
            user.setMoney(rs.getDouble("user_money"));
            user.setIntegel(rs.getInt("user_integel"));
            userList.add(user);
        }
        this.jdbc.close();
        return user;
    }

    public boolean getUserOrByTel(String tel) throws SQLException {
        Object[] args = new String[]{tel};
        ResultSet rs = null;
        String sql = "select u.user_id from user u where user_tel=?";
        rs = this.jdbc.executeQuery(sql, args);
        if (rs.next()) {
            this.jdbc.close();
            return true;
        }
        this.jdbc.close();
        return false;
    }

    public Integer addCoupon(String title, String price, Integer service, Integer end, String endDate, Integer saveFlag) {
        String no = "YOUHUI" + StringUtil.getStrByDate();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String now_time = format.format(new Date());
        Object[] args = new Object[]{no, title, price, service, end, endDate, saveFlag, now_time};
        String sql = "insert into coupon (coupon_no,coupon_title,coupon_price,coupon_service,coupon_end,coupon_enddate,coupon_saveFlag,coupon_date) values(?,?,?,?,?,?,?,?)";
        Serializable teflag = this.jdbc.insertBackId(sql, args);
        this.jdbc.close();
        return teflag.hashCode();
    }

    public String updateCoupon(String title, String price, Integer service, Integer end, String endDate, Integer saveFlag, Integer coupon_id) {
        Object[] args = new Object[]{title, price, service, end, endDate, saveFlag, coupon_id};
        String sql = "UPDATE coupon SET coupon_title = ?,coupon_price=?,coupon_service=?,coupon_end=?,coupon_enddate=?,coupon_saveFlag=? where coupon_id=?";
        int teflag = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (teflag > 0) {
            return "ok";
        }
        return "bad";
    }

    public Coupon getCouponById(Integer coupon_id) throws SQLException {
        ResultSet rs = null;
        String sql = "select c.* from coupon c where c.coupon_id=? ";
        rs = this.jdbc.executeQuery(sql, (Object)coupon_id);
        Coupon coupon = null;
        if (rs.next()) {
            coupon = new Coupon();
            coupon.setId(rs.getInt("coupon_id"));
            coupon.setTitle(rs.getString("coupon_title"));
            coupon.setPrice(rs.getString("coupon_price"));
            coupon.setEnddate(rs.getString("coupon_enddate"));
            coupon.setService_id(rs.getInt("coupon_service"));
            coupon.setEnd(rs.getInt("coupon_end"));
            coupon.setDate(rs.getString("coupon_date"));
            coupon.setNo(rs.getString("coupon_no"));
            coupon.setSaveFlag(rs.getInt("coupon_saveFlag"));
        }
        this.jdbc.close();
        return coupon;
    }

    public String deleteCouPon(String ids) {
        String sql = "delete from coupon where coupon_id in (" + ids + ")";
        int flag = this.jdbc.executeUpdate(sql);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public String addUserCoupon(String username, Integer couponId, String price, String enddate, String receive, String title) {
        Object[] args = new Object[]{username, couponId, price, enddate, receive, title};
        String sql = "insert into coupon_user (coupon_user_user,coupon_user_coupon,coupon_user_price,coupon_user_enddate,coupon_user_receive,coupon_user_title) values(?,?,?,?,?,?)";
        int flag = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public String updateUserCoupon(Integer coupon_user_id, Integer flag) {
        Object[] args = new Object[]{flag, coupon_user_id};
        String sql = "UPDATE coupon_user SET coupon_user_flag =? where coupon_user_id=?";
        int teflag = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (teflag > 0) {
            return "ok";
        }
        return "bad";
    }

    public Coupon getUserCouponById(Integer id) throws SQLException {
        String sql = "select cu.*,c.coupon_no from coupon_user cu,coupon c where cu.coupon_user_id=? and cu.coupon_user_coupon=c.coupon_id order by cu.coupon_user_id desc";
        ResultSet rs = this.jdbc.executeQuery(sql, (Object)id);
        Coupon coupon = null;
        if (rs.next()) {
            coupon = new Coupon();
            coupon.setNo(rs.getString("coupon_no"));
            coupon.setId(rs.getInt("coupon_user_id"));
            coupon.setTitle(rs.getString("coupon_user_title"));
            coupon.setPrice(rs.getString("coupon_user_price"));
            coupon.setEnddate(rs.getString("coupon_user_enddate"));
            coupon.setDate(rs.getString("coupon_user_receive"));
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            String now_time = format.format(new Date());
            if (rs.getString("coupon_user_enddate") != null && !rs.getString("coupon_user_enddate").equals("")) {
                if (now_time.compareTo(rs.getString("coupon_user_receive")) > 0) {
                    coupon.setFlag(3);
                } else {
                    coupon.setFlag(rs.getInt("coupon_user_flag"));
                }
            } else {
                coupon.setFlag(rs.getInt("coupon_user_flag"));
            }
        }
        this.jdbc.close();
        return coupon;
    }

    public List<Coupon> getUserCouponByUsername(String username, Integer flag) throws SQLException {
        String sql = "select cu.*,c.coupon_no from coupon_user cu,coupon c where cu.coupon_user_user=? and cu.coupon_user_coupon=c.coupon_id ";
        if (flag != null) {
            sql = String.valueOf(sql) + " and cu.coupon_user_flag=" + flag + " ";
        }
        sql = String.valueOf(sql) + " order by cu.coupon_user_id desc";
        ResultSet rs = this.jdbc.executeQuery(sql, (Object)username);
        Coupon coupon = null;
        ArrayList<Coupon> couponList = new ArrayList<Coupon>();
        while (rs.next()) {
            coupon = new Coupon();
            coupon.setNo(rs.getString("coupon_no"));
            coupon.setId(rs.getInt("coupon_user_id"));
            coupon.setTitle(rs.getString("coupon_user_title"));
            coupon.setPrice(rs.getString("coupon_user_price"));
            coupon.setEnddate(rs.getString("coupon_user_enddate"));
            coupon.setDate(rs.getString("coupon_user_receive"));
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            String now_time = format.format(new Date());
            if (rs.getString("coupon_user_enddate") != null && !rs.getString("coupon_user_enddate").equals("")) {
                if (now_time.compareTo(rs.getString("coupon_user_receive")) > 0) {
                    coupon.setFlag(3);
                } else {
                    coupon.setFlag(rs.getInt("coupon_user_flag"));
                }
            } else {
                coupon.setFlag(rs.getInt("coupon_user_flag"));
            }
            couponList.add(coupon);
        }
        this.jdbc.close();
        return couponList;
    }

    public List<Coupon> getCouponList(Integer pageNo, Integer pageSize) throws SQLException {
        if (pageNo < 1) {
            pageNo = 1;
        }
        int offset = (pageNo - 1) * pageSize;
        String sql = "select c.*,gt.goods_type_id,gt.goods_type_name from coupon c left join goods_type gt on c.coupon_service=gt.goods_type_id order by c.coupon_id desc limit " + offset + "," + pageSize;
        ResultSet rs = this.jdbc.executeQuery(sql);
        Coupon coupon = null;
        ArrayList<Coupon> couponList = new ArrayList<Coupon>();
        while (rs.next()) {
            coupon = new Coupon();
            coupon.setId(rs.getInt("coupon_id"));
            coupon.setTitle(rs.getString("coupon_title"));
            coupon.setPrice(rs.getString("coupon_price"));
            coupon.setEnddate(rs.getString("coupon_enddate"));
            coupon.setEnd(rs.getInt("coupon_end"));
            coupon.setDate(rs.getString("coupon_date"));
            coupon.setNo(rs.getString("coupon_no"));
            coupon.setSaveFlag(rs.getInt("coupon_saveFlag"));
            coupon.setService_id(rs.getInt("goods_type_id"));
            coupon.setService_name(rs.getString("goods_type_name"));
            couponList.add(coupon);
        }
        this.jdbc.close();
        return couponList;
    }

    public Integer getCouponCount() throws SQLException {
        int resultCount = 0;
        ResultSet rs = null;
        String sql = "select COUNT(*) AS rowcount from coupon left join goods_type on coupon_service=goods_type_id";
        rs = this.jdbc.executeQuery(sql);
        if (rs.next()) {
            resultCount = rs.getInt("rowcount");
        }
        this.jdbc.close();
        return resultCount;
    }

    public boolean getUserOrHaveCoupon(String username, Integer coupon) throws SQLException {
        ResultSet rs = null;
        String sql = "select c.coupon_user_flag from coupon_user c where c.coupon_user_user=? and c.coupon_user_id=?";
        Object[] args = new Object[]{username, coupon};
        rs = this.jdbc.executeQuery(sql, args);
        if (rs.next()) {
            String flag = rs.getString("coupon_user_flag");
            if (flag.equals("1")) {
                this.jdbc.close();
                return true;
            }
            this.jdbc.close();
            return false;
        }
        this.jdbc.close();
        return false;
    }

    public List<OrderMoneyRecord> getMoneyRecordByUserId(Integer user_id, Integer pageNo, Integer pageSize) throws SQLException {
        if (pageNo < 1) {
            pageNo = 1;
        }
        int offset = (pageNo - 1) * pageSize;
        String sql = "select u.* from user_card_user u where u.user_recharge_record_user=? order by u.user_recharge_record_id desc limit " + offset + "," + pageSize;
        ResultSet rs = this.jdbc.executeQuery(sql, (Object)user_id);
        OrderMoneyRecord record = null;
        ArrayList<OrderMoneyRecord> recordList = new ArrayList<OrderMoneyRecord>();
        while (rs.next()) {
            record = new OrderMoneyRecord();
            record.setDirection(rs.getInt("user_recharge_record_direction"));
            record.setSource(rs.getInt("user_recharge_record_source"));
            record.setAccount(rs.getString("user_recharge_record_account"));
            record.setMoney(rs.getString("user_recharge_record_money"));
            record.setYear(rs.getInt("user_recharge_record_year"));
            record.setMonth(rs.getInt("user_recharge_record_month"));
            record.setDay(rs.getInt("user_recharge_record_day"));
            record.setDeriction(rs.getInt("user_recharge_record_deriction"));
            record.setStore(rs.getInt("user_recharge_record_store"));
            record.setAdmin(rs.getString("user_recharge_record_admin"));
            record.setOrder(rs.getInt("user_recharge_record_order"));
            record.setTradeNo(rs.getString("user_recharge_record_tradeno"));
            recordList.add(record);
        }
        this.jdbc.close();
        return recordList;
    }

    public Integer getMoneyRecordCountByUserId(Integer user_id) throws SQLException {
        int resultCount = 0;
        ResultSet rs = null;
        String sql = "select COUNT(*) AS rowcount from user_card_user u where u.user_recharge_record_user=?";
        rs = this.jdbc.executeQuery(sql, (Object)user_id);
        if (rs.next()) {
            resultCount = rs.getInt("rowcount");
        }
        this.jdbc.close();
        return resultCount;
    }

    public List<OrderMoneyRecord> getOrderMoneyRecordByOrderId(Integer order_id) throws SQLException {
        String sql = "select u.* from user_card_user u where u.user_recharge_record_order=?";
        ResultSet rs = this.jdbc.executeQuery(sql, (Object)order_id);
        OrderMoneyRecord record = null;
        ArrayList<OrderMoneyRecord> recordList = new ArrayList<OrderMoneyRecord>();
        while (rs.next()) {
            record = new OrderMoneyRecord();
            record.setId(rs.getInt("user_recharge_record_id"));
            record.setDirection(rs.getInt("user_recharge_record_direction"));
            record.setSource(rs.getInt("user_recharge_record_source"));
            record.setAccount(rs.getString("user_recharge_record_account"));
            record.setMoney(rs.getString("user_recharge_record_money"));
            record.setYear(rs.getInt("user_recharge_record_year"));
            record.setMonth(rs.getInt("user_recharge_record_month"));
            record.setDay(rs.getInt("user_recharge_record_day"));
            record.setDeriction(rs.getInt("user_recharge_record_deriction"));
            record.setStore(rs.getInt("user_recharge_record_store"));
            record.setAdmin(rs.getString("user_recharge_record_admin"));
            record.setOrder(rs.getInt("user_recharge_record_order"));
            record.setTradeNo(rs.getString("user_recharge_record_tradeno"));
            record.setFlag(rs.getInt("user_recharge_record_falg"));
            recordList.add(record);
        }
        this.jdbc.close();
        return recordList;
    }

    public List<OrderMoneyRecord> getOrderMoneyRecordByStoreId(String store_id, Integer direction, Integer source, String stratDate, String endDate, Integer pageNo, Integer pageSize) throws SQLException {
        ResultSet rs = null;
        if (pageNo < 1) {
            pageNo = 1;
        }
        int offset = (pageNo - 1) * pageSize;
        String sql = "";
        sql = "select u.* from user_card_user u where u.user_recharge_record_store=" + store_id + " ";
        if (direction != null) {
            sql = String.valueOf(sql) + " and u.user_recharge_record_direction=" + direction + " ";
        }
        if (source != null) {
            sql = String.valueOf(sql) + " and u.user_recharge_record_source=" + source + " ";
        }
        if (stratDate != null && !stratDate.equals("") && endDate != null && !endDate.equals("")) {
            String str = stratDate.substring(0, 10);
            String str1 = endDate.substring(0, 10);
            String[] str_arr = str.split("-");
            String[] str1_arr = str1.split("-");
            str = String.valueOf(str_arr[0]) + Integer.parseInt(str_arr[1]) + Integer.parseInt(str_arr[2]);
            str1 = String.valueOf(str1_arr[0]) + Integer.parseInt(str1_arr[1]) + Integer.parseInt(str1_arr[2]);
            sql = String.valueOf(sql) + " and CONCAT(user_recharge_record_year,user_recharge_record_month,user_recharge_record_day)>=" + str + " and CONCAT(user_recharge_record_year,user_recharge_record_month,user_recharge_record_day)<=" + str1 + " ";
        }
        sql = String.valueOf(sql) + " order by u.user_recharge_record_id desc limit " + offset + "," + pageSize;
        rs = this.jdbc.executeQuery(sql);
        OrderMoneyRecord record = null;
        ArrayList<OrderMoneyRecord> recordList = new ArrayList<OrderMoneyRecord>();
        while (rs.next()) {
            record = new OrderMoneyRecord();
            record.setDirection(rs.getInt("user_recharge_record_direction"));
            record.setSource(rs.getInt("user_recharge_record_source"));
            record.setAccount(rs.getString("user_recharge_record_account"));
            record.setMoney(rs.getString("user_recharge_record_money"));
            record.setYear(rs.getInt("user_recharge_record_year"));
            record.setMonth(rs.getInt("user_recharge_record_month"));
            record.setDay(rs.getInt("user_recharge_record_day"));
            record.setDeriction(rs.getInt("user_recharge_record_deriction"));
            record.setStore(rs.getInt("user_recharge_record_store"));
            record.setAdmin(rs.getString("user_recharge_record_admin"));
            record.setOrder(rs.getInt("user_recharge_record_order"));
            record.setTradeNo(rs.getString("user_recharge_record_tradeno"));
            recordList.add(record);
        }
        this.jdbc.close();
        return recordList;
    }

    public Integer getOrderMoneyRecordByStoreIdCount(String store_id, Integer direction, Integer source, String stratDate, String endDate) throws SQLException {
        ResultSet rs = null;
        int resultCount = 0;
        String sql = "";
        sql = "select COUNT(*) AS rowcount from user_card_user u where u.user_recharge_record_store=" + store_id + " ";
        if (direction != null) {
            sql = String.valueOf(sql) + " and u.user_recharge_record_direction=" + direction + " ";
        }
        if (source != null) {
            sql = String.valueOf(sql) + " and u.user_recharge_record_source=" + source + " ";
        }
        if (stratDate != null && !stratDate.equals("") && endDate != null && !endDate.equals("")) {
            String str = stratDate.substring(0, 10);
            String str1 = endDate.substring(0, 10);
            String[] str_arr = str.split("-");
            String[] str1_arr = str1.split("-");
            str = String.valueOf(str_arr[0]) + Integer.parseInt(str_arr[1]) + Integer.parseInt(str_arr[2]);
            str1 = String.valueOf(str1_arr[0]) + Integer.parseInt(str1_arr[1]) + Integer.parseInt(str1_arr[2]);
            sql = String.valueOf(sql) + " and CONCAT(user_recharge_record_year,user_recharge_record_month,user_recharge_record_day)>=" + str + " and CONCAT(user_recharge_record_year,user_recharge_record_month,user_recharge_record_day)<=" + str1 + " ";
        }
        if ((rs = this.jdbc.executeQuery(sql)).next()) {
            resultCount = rs.getInt("rowcount");
        }
        this.jdbc.close();
        return resultCount;
    }

    public Double getOrderMoneyRecordByStoreIdSum(String store_id, Integer direction, Integer source, String stratDate, String endDate) throws SQLException {
        ResultSet rs = null;
        double resultCount = 0.0;
        String sql = "";
        sql = "select SUM(u.user_recharge_record_money) AS rowcount from user_card_user u where u.user_recharge_record_store=" + store_id + " ";
        if (direction != null) {
            sql = String.valueOf(sql) + " and u.user_recharge_record_direction=" + direction + " ";
        }
        if (source != null) {
            sql = String.valueOf(sql) + " and u.user_recharge_record_source=" + source + " ";
        }
        if (stratDate != null && !stratDate.equals("") && endDate != null && !endDate.equals("")) {
            String str = stratDate.substring(0, 10);
            String str1 = endDate.substring(0, 10);
            String[] str_arr = str.split("-");
            String[] str1_arr = str1.split("-");
            str = String.valueOf(str_arr[0]) + Integer.parseInt(str_arr[1]) + Integer.parseInt(str_arr[2]);
            str1 = String.valueOf(str1_arr[0]) + Integer.parseInt(str1_arr[1]) + Integer.parseInt(str1_arr[2]);
            sql = String.valueOf(sql) + " and CONCAT(user_recharge_record_year,user_recharge_record_month,user_recharge_record_day)>=" + str + " and CONCAT(user_recharge_record_year,user_recharge_record_month,user_recharge_record_day)<=" + str1 + " ";
        }
        if ((rs = this.jdbc.executeQuery(sql)).next()) {
            resultCount = rs.getDouble("rowcount");
        }
        this.jdbc.close();
        return resultCount;
    }

    public List<OrderMoneyRecord> getOrderMoneyRecordByUserId(String user_id, Integer direction, Integer source, String stratDate, String endDate, Integer pageNo, Integer pageSize) throws SQLException {
        ResultSet rs = null;
        if (pageNo < 1) {
            pageNo = 1;
        }
        int offset = (pageNo - 1) * pageSize;
        String sql = "";
        sql = "select u.* from user_card_user u where u.user_recharge_record_user=" + user_id + " ";
        if (direction != null) {
            sql = String.valueOf(sql) + " and u.user_recharge_record_direction=" + direction + " ";
        }
        if (source != null) {
            sql = String.valueOf(sql) + " and u.user_recharge_record_source=" + source + " ";
        }
        if (stratDate != null && !stratDate.equals("") && endDate != null && !endDate.equals("")) {
            String str = stratDate.substring(0, 10);
            String str1 = endDate.substring(0, 10);
            String[] str_arr = str.split("-");
            String[] str1_arr = str1.split("-");
            str = String.valueOf(str_arr[0]) + Integer.parseInt(str_arr[1]) + Integer.parseInt(str_arr[2]);
            str1 = String.valueOf(str1_arr[0]) + Integer.parseInt(str1_arr[1]) + Integer.parseInt(str1_arr[2]);
            sql = String.valueOf(sql) + " and CONCAT(user_recharge_record_year,user_recharge_record_month,user_recharge_record_day)>=" + str + " and CONCAT(user_recharge_record_year,user_recharge_record_month,user_recharge_record_day)<=" + str1 + " ";
        }
        sql = String.valueOf(sql) + " order by u.user_recharge_record_id desc limit " + offset + "," + pageSize;
        rs = this.jdbc.executeQuery(sql);
        OrderMoneyRecord record = null;
        ArrayList<OrderMoneyRecord> recordList = new ArrayList<OrderMoneyRecord>();
        while (rs.next()) {
            record = new OrderMoneyRecord();
            record.setDirection(rs.getInt("user_recharge_record_direction"));
            record.setSource(rs.getInt("user_recharge_record_source"));
            record.setAccount(rs.getString("user_recharge_record_account"));
            record.setMoney(rs.getString("user_recharge_record_money"));
            record.setYear(rs.getInt("user_recharge_record_year"));
            record.setMonth(rs.getInt("user_recharge_record_month"));
            record.setDay(rs.getInt("user_recharge_record_day"));
            record.setDeriction(rs.getInt("user_recharge_record_deriction"));
            record.setStore(rs.getInt("user_recharge_record_store"));
            record.setAdmin(rs.getString("user_recharge_record_admin"));
            record.setOrder(rs.getInt("user_recharge_record_order"));
            record.setTradeNo(rs.getString("user_recharge_record_tradeno"));
            recordList.add(record);
        }
        this.jdbc.close();
        return recordList;
    }

    public Integer getOrderMoneyRecordByUserIdCount(String store_id, Integer direction, Integer source, String stratDate, String endDate) throws SQLException {
        ResultSet rs = null;
        int resultCount = 0;
        String sql = "";
        sql = "select COUNT(*) AS rowcount from user_card_user u where u.user_recharge_record_user=" + store_id + " ";
        if (direction != null) {
            sql = String.valueOf(sql) + " and u.user_recharge_record_direction=" + direction + " ";
        }
        if (source != null) {
            sql = String.valueOf(sql) + " and u.user_recharge_record_source=" + source + " ";
        }
        if (stratDate != null && !stratDate.equals("") && endDate != null && !endDate.equals("")) {
            String str = stratDate.substring(0, 10);
            String str1 = endDate.substring(0, 10);
            String[] str_arr = str.split("-");
            String[] str1_arr = str1.split("-");
            str = String.valueOf(str_arr[0]) + Integer.parseInt(str_arr[1]) + Integer.parseInt(str_arr[2]);
            str1 = String.valueOf(str1_arr[0]) + Integer.parseInt(str1_arr[1]) + Integer.parseInt(str1_arr[2]);
            sql = String.valueOf(sql) + " and CONCAT(user_recharge_record_year,user_recharge_record_month,user_recharge_record_day)>=" + str + " and CONCAT(user_recharge_record_year,user_recharge_record_month,user_recharge_record_day)<=" + str1 + " ";
        }
        if ((rs = this.jdbc.executeQuery(sql)).next()) {
            resultCount = rs.getInt("rowcount");
        }
        this.jdbc.close();
        return resultCount;
    }

    public Double getOrderMoneyRecordByUserIdSum(String user_id, Integer direction, Integer source, String stratDate, String endDate) throws SQLException {
        ResultSet rs = null;
        double resultCount = 0.0;
        String sql = "";
        sql = "select SUM(u.user_recharge_record_money) AS rowcount from user_card_user u where u.user_recharge_record_user=" + user_id + " ";
        if (direction != null) {
            sql = String.valueOf(sql) + " and u.user_recharge_record_direction=" + direction + " ";
        }
        if (source != null) {
            sql = String.valueOf(sql) + " and u.user_recharge_record_source=" + source + " ";
        }
        if (stratDate != null && !stratDate.equals("") && endDate != null && !endDate.equals("")) {
            String str = stratDate.substring(0, 10);
            String str1 = endDate.substring(0, 10);
            String[] str_arr = str.split("-");
            String[] str1_arr = str1.split("-");
            str = String.valueOf(str_arr[0]) + Integer.parseInt(str_arr[1]) + Integer.parseInt(str_arr[2]);
            str1 = String.valueOf(str1_arr[0]) + Integer.parseInt(str1_arr[1]) + Integer.parseInt(str1_arr[2]);
            sql = String.valueOf(sql) + " and CONCAT(user_recharge_record_year,user_recharge_record_month,user_recharge_record_day)>=" + str + " and CONCAT(user_recharge_record_year,user_recharge_record_month,user_recharge_record_day)<=" + str1 + " ";
        }
        if ((rs = this.jdbc.executeQuery(sql)).next()) {
            resultCount = rs.getDouble("rowcount");
        }
        this.jdbc.close();
        return resultCount;
    }

    public String deleteOrderAunt(Integer order_aunt_id) {
        String sql = "delete from order_aunt where order_aunt_order=?";
        int flag = this.jdbc.executeUpdate(sql, (Object)order_aunt_id);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public String updateUserIntgel(Integer userId, Integer integel) {
        Object[] args = new Object[]{integel, userId};
        String sql = "UPDATE user SET user_integel = user_integel+? where user_id=?";
        int teflag = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (teflag > 0) {
            return "ok";
        }
        return "bad";
    }

    public String innertUserIntgel(Integer count, Integer user, Integer dericte, Integer order, String desc) {
        SimpleDateFormat format2 = new SimpleDateFormat("yyyy-MM-dd");
        Date dDate = new Date();
        String time = format2.format(dDate);
        Object[] args = new Object[]{count, user, time, desc, dericte, order};
        String sql = "insert into user_intgel(user_intgel_count,user_intgel_user,user_intgel_date,user_intgel_desc,user_intgel_dericte,user_intgel_order) values(?,?,?,?,?,?)";
        int flag = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public List<UserCardUser> getUserCardUserByOrder(Integer order_id) throws SQLException {
        ResultSet rs = null;
        String sql = "select u.* from user_card_user u where u.user_recharge_record_order=? order by u.user_recharge_record_id";
        rs = this.jdbc.executeQuery(sql, (Object)order_id);
        ArrayList<UserCardUser> recordList = new ArrayList<UserCardUser>();
        UserCardUser record = null;
        while (rs.next()) {
            record = new UserCardUser();
            record.setId(rs.getInt("user_recharge_record_id"));
            record.setAccount(rs.getString("user_recharge_record_account"));
            record.setMoney(rs.getString("user_recharge_record_money"));
            recordList.add(record);
        }
        this.jdbc.close();
        return recordList;
    }

    public Integer addRechargeRecord(Integer user, Integer direction, Integer source, String account, String money, Integer year, Integer month, Integer day, Integer deriction, Integer store, String admin, Integer order, Integer flag) {
        Object[] args = new Object[]{user, direction, source, account, money, year, month, day, deriction, store, admin, order, flag};
        String sql = "insert into user_card_user(user_recharge_record_user,user_recharge_record_direction,user_recharge_record_source,user_recharge_record_account,user_recharge_record_money,user_recharge_record_year,user_recharge_record_month,user_recharge_record_day,user_recharge_record_deriction,user_recharge_record_store,user_recharge_record_admin,user_recharge_record_order,user_recharge_record_falg) values(?,?,?,?,?,?,?,?,?,?,?,?,?)";
        Serializable teflag = this.jdbc.insertBackId(sql, args);
        this.jdbc.close();
        return teflag.hashCode();
    }

    public String updateuserCardFlag(Integer id, Integer flag) {
        Object[] args = new Object[]{flag, id};
        String sql = "UPDATE user_card_user SET user_recharge_record_falg =? where user_recharge_record_id=?";
        int teflag = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (teflag > 0) {
            return "ok";
        }
        return "bad";
    }

    public String updateUserMoney(Integer userId, Double money) {
        Object[] args = new Object[]{money, userId};
        String sql = "UPDATE user SET user_money = user_money+? where user_id=?";
        int teflag = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (teflag > 0) {
            return "ok";
        }
        return "bad";
    }

    public String updateUserMoney(String tel, String money, String action) {
        Object[] args = new Object[]{money, tel};
        if (action.equals("add")) {
            String sql = "update user SET user_money=user_money+? where user_tel=?";
            int flag = this.jdbc.executeUpdate(sql, args);
            this.jdbc.close();
            if (flag > 0) {
                return "ok";
            }
            return "bad";
        }
        if (action.equals("reduce")) {
            String sql = "update user SET user_money=user_money-? where user_tel=?";
            int flag = this.jdbc.executeUpdate(sql, args);
            this.jdbc.close();
            if (flag > 0) {
                return "ok";
            }
            return "bad";
        }
        this.jdbc.close();
        return "bad";
    }

    public User getUserById(Integer id) throws SQLException {
        ResultSet rs = null;
        String sql = "select u.*,ut.* from user u,user_type ut where u.user_id=?";
        rs = this.jdbc.executeQuery(sql, (Object)id);
        ArrayList<User> userList = new ArrayList<User>();
        User user = null;
        while (rs.next()) {
            user = new User();
            user.setId(rs.getInt("user_id"));
            user.setUsername(rs.getString("user_username"));
            user.setPass(rs.getString("user_pass"));
            user.setMd5(rs.getString("user_pass_md5"));
            user.setTel(rs.getString("user_tel"));
            user.setEmail(rs.getString("user_email"));
            user.setType(rs.getString("user_type"));
            user.setTypeName(rs.getString("user_type_name"));
            user.setName(rs.getString("user_name"));
            user.setFlag(rs.getString("user_flag"));
            user.setFlagName(rs.getString("user_flag"));
            user.setMoney(rs.getDouble("user_money"));
            user.setIntegel(rs.getInt("user_integel"));
            user.setCard(rs.getString("user_card"));
            userList.add(user);
        }
        this.jdbc.close();
        return user;
    }

    public String addGoodsAndOrder(Integer goods_id, Integer order_id) {
        Object[] args = new Object[]{goods_id, order_id};
        String sql = "insert into goods_and_order(goods_and_goods_id,goods_and_order_id) values(?,?)";
        int flag = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public List<GoodsPojo> getGoodsPojoByOrder(Integer order_id) throws SQLException {
        String sql = "select gd.* from goods_and_order gao,goods gd,goods_order go where gao.goods_and_order_id=go.goods_order_id and gao.goods_and_goods_id=gd.goods_id and gao.goods_and_order_id=?";
        ResultSet rs = this.jdbc.executeQuery(sql, (Object)order_id);
        GoodsPojo goods = null;
        ArrayList<GoodsPojo> goodsList = new ArrayList<GoodsPojo>();
        while (rs.next()) {
            goods = new GoodsPojo();
            goods.setGoodsId(rs.getInt("goods_id"));
            goods.setGoodsSn(rs.getString("goods_sn"));
            goods.setGoodsName(rs.getString("goods_name"));
            goods.setGoodsNameStyle(rs.getString("goods_name_style"));
            goods.setClickCount(rs.getInt("click_count"));
            goods.setGoodsWeight(rs.getString("goods_weight"));
            goods.setMarketPrice(rs.getString("market_price"));
            goods.setShopPrice(rs.getString("shop_price"));
            goods.setPromotePrice(rs.getString("promote_price"));
            goods.setPromoteStartDate(rs.getString("promote_start_date"));
            goods.setPromoteEndDate(rs.getString("promote_end_date"));
            goods.setGoodsNumber(rs.getInt("goods_number"));
            goods.setWarnNumber(rs.getInt("warn_number"));
            goods.setKeywords(rs.getString("keywords"));
            goods.setGoodsBrief(rs.getString("goods_brief"));
            goods.setGoodsDesc(rs.getString("goods_desc"));
            goods.setGoodsThumb(rs.getString("goods_thumb"));
            goods.setGoodsImg(rs.getString("goods_img"));
            goods.setOriginalImg(rs.getString("original_img"));
            goods.setIsReal(rs.getInt("is_real"));
            goods.setExtensionCode(rs.getString("extension_code"));
            goods.setIsOnSale(rs.getInt("is_on_sale"));
            goods.setIsShipping(rs.getInt("Is_shipping"));
            goods.setIntegral(rs.getInt("integral"));
            goods.setAddTime(rs.getString("add_time"));
            goods.setIsDelete(rs.getInt("is_delete"));
            goods.setSortOrder(rs.getInt("sort_order"));
            goods.setIsBest(rs.getInt("is_best"));
            goods.setIsNew(rs.getInt("is_new"));
            goods.setIsHot(rs.getInt("is_hot"));
            goods.setIsPromote(rs.getInt("is_promote"));
            goods.setBonusTypeId(rs.getInt("bonus_type_id"));
            goods.setLastUpdate(rs.getString("last_update"));
            goods.setSellerNote(rs.getString("seller_note"));
            goods.setGiveIntegral(rs.getInt("give_integral"));
            goods.setIsShelves(rs.getInt("is_shelves"));
            GoodsAttr attr = null;
            ArrayList<GoodsAttr> attrList = new ArrayList<GoodsAttr>();
            String sqlAttr = "select a.*,gt.goods_type_attribute_name from goods_attr a,goods_type_attribute gt where a.attr_id=gt.goods_type_attribute_id and a.goods_id=?";
            ResultSet rsAttr = this.jdbc.executeQuery(sqlAttr, (Object)goods.getGoodsId());
            while (rsAttr.next()) {
                attr = new GoodsAttr();
                attr.setId(rsAttr.getInt("goods_attr_id"));
                attr.setAttr_id(rsAttr.getInt("attr_id"));
                attr.setGoods_id(rsAttr.getInt("goods_id"));
                attr.setValue(rsAttr.getString("goods_attr_value"));
                attr.setPrice(rsAttr.getString("goods_attr_price"));
                attr.setName(rsAttr.getString("goods_type_attribute_name"));
                attrList.add(attr);
                goods.setAttrList(attrList);
            }
            goodsList.add(goods);
        }
        this.jdbc.close();
        return goodsList;
    }

    public String updateUserPass(Integer userId, String pass) {
        Md5Util md5 = new Md5Util();
        Object[] args = new Object[]{pass, Md5Util.getMD5Str((String)pass), userId};
        String sql = "update user SET user_pass=?,user_pass_md5=? where user_id=?";
        int flag = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public List<Coupon> getCouponListByUser(String username) throws SQLException {
        SimpleDateFormat format2 = new SimpleDateFormat("yyyy-MM-dd");
        Date dDate = new Date();
        String time = format2.format(dDate);
        Object[] args = new String[]{username, time};
        String sql = "select c.*,gt.goods_type_name,gt.goods_type_id from coupon c,goods_type gt where gt.goods_type_id=c.coupon_service and c.coupon_id not in (select cu.coupon_user_coupon from coupon_user cu where cu.coupon_user_user=?) and c.coupon_enddate>=? order by c.coupon_id desc";
        ResultSet rs = this.jdbc.executeQuery(sql, args);
        Coupon coupon = null;
        ArrayList<Coupon> couponList = new ArrayList<Coupon>();
        while (rs.next()) {
            coupon = new Coupon();
            coupon.setId(rs.getInt("coupon_id"));
            coupon.setTitle(rs.getString("coupon_title"));
            coupon.setPrice(rs.getString("coupon_price"));
            coupon.setEnddate(rs.getString("coupon_enddate"));
            coupon.setFlag(rs.getInt("coupon_service"));
            coupon.setEnd(rs.getInt("coupon_end"));
            coupon.setDate(rs.getString("coupon_date"));
            coupon.setNo(rs.getString("coupon_no"));
            coupon.setSaveFlag(rs.getInt("coupon_saveFlag"));
            coupon.setService_id(rs.getInt("goods_type_id"));
            coupon.setService_name(rs.getString("goods_type_name"));
            couponList.add(coupon);
        }
        this.jdbc.close();
        return couponList;
    }

    public String updateUserInfo(Integer userId, String name, String email, String tel) {
        Object[] args = new Object[]{name, email, tel, userId};
        String sql = "UPDATE user SET user_name=?,user_email =?,user_tel=? where user_id=?";
        int teflag = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (teflag > 0) {
            return "ok";
        }
        return "bad";
    }

    public Integer addAunt(String name, String head, Integer type, String birthday, Integer decretion, Integer decretion_id, String decretion_name, String no, String tel, Integer flag, String con_stardate, String con_enddate) {
        Object[] args = new Object[]{name, head, type, birthday, decretion, decretion_id, decretion_name, no, tel, flag, con_stardate, con_enddate};
        String sql = "insert into aunt (aunt_name,aunt_head,aunt_type,aunt_birthday,aunt_decretion,aunt_decretion_id,aunt_decretion_name,aunt_no,aunt_tel,aunt_flag,aunt_con_startdate,aunt_con_enddate) values(?,?,?,?,?,?,?,?,?,?,?,?)";
        Serializable teflag = this.jdbc.insertBackId(sql, args);
        return teflag.hashCode();
    }

    public Integer getGoodsOrderForStoreCount(String ids, Integer flag) throws SQLException {
        int resultCount = 0;
        ResultSet rs = null;
        String sql = "select COUNT(*) AS rowcount from goods_order g left join user u on g.goods_order_user_id=u.user_id LEFT JOIN user_address ua on g.goods_order_address=ua.user_address_id LEFT JOIN store s on g.goods_order_store_id=s.store_id LEFT JOIN store_employee se on g.goods_order_employee_id=se.store_employee_id LEFT JOIN admin a on g.goods_order_admin_id=a.admin_id left join goods gd on g.goods_order_goods_id=gd.goods_id where g.goods_order_id!=0 and g.goods_order_store_id in (" + ids + ") ";
        if (flag != null) {
            sql = String.valueOf(sql) + " and g.goods_order_flag=" + flag;
        }
        if ((rs = this.jdbc.executeQuery(sql)).next()) {
            resultCount = rs.getInt("rowcount");
        }
        this.jdbc.close();
        return resultCount;
    }

    public List<GoodsOrder> getGoodsOrderForStore(String ids, Integer flag, Integer pageNo, Integer pageSize) throws SQLException {
        if (pageNo < 1) {
            pageNo = 1;
        }
        int offset = (pageNo - 1) * pageSize;
        String sql = "select g.*,u.user_username,u.user_id,ua.*,se.store_employee_id,se.store_employee_name,a.admin_id,a.admin_username,s.store_id,s.store_name,gd.goods_id,gd.goods_name from goods_order g left join user u on g.goods_order_user_id=u.user_id LEFT JOIN user_address ua on g.goods_order_address=ua.user_address_id LEFT JOIN store s on g.goods_order_store_id=s.store_id LEFT JOIN store_employee se on g.goods_order_employee_id=se.store_employee_id LEFT JOIN admin a on g.goods_order_admin_id=a.admin_id left join goods gd on g.goods_order_goods_id=gd.goods_id where g.goods_order_id!=0 and g.goods_order_store_id in (" + ids + ") ";
        if (flag != null) {
            sql = String.valueOf(sql) + " and g.goods_order_flag=" + flag;
        }
        sql = String.valueOf(sql) + " order by g.goods_order_id desc limit " + offset + "," + pageSize;
        ResultSet rs = this.jdbc.executeQuery(sql);
        GoodsOrder order = null;
        ArrayList<GoodsOrder> orderList = new ArrayList<GoodsOrder>();
        while (rs.next()) {
            order = new GoodsOrder();
            order.setId(rs.getInt("goods_order_id"));
            order.setNo(rs.getString("goods_order_no"));
            order.setType(rs.getInt("goods_order_type"));
            order.setFlag(rs.getInt("goods_order_flag"));
            order.setNum(rs.getInt("goods_order_num"));
            order.setOrNum(rs.getInt("goods_order_orNum"));
            order.setServiceDate(rs.getString("goods_order_serviceDate"));
            order.setDayLongs(rs.getString("goods_order_dayLongs"));
            order.setContent(rs.getString("goods_order_content"));
            order.setUser_id(rs.getInt("user_id"));
            order.setUsername(rs.getString("user_username"));
            order.setAdmin_id(rs.getInt("admin_id"));
            order.setAdmin_username(rs.getString("admin_username"));
            order.setStore_id(rs.getInt("store_id"));
            order.setStore_name(rs.getString("store_name"));
            order.setEmployee_id(rs.getString("store_employee_id"));
            order.setEmployee_name(rs.getString("store_employee_name"));
            order.setPrice(rs.getString("goods_order_price"));
            order.setActual_price(rs.getString("goods_order_actual_price"));
            order.setPayFlag(rs.getInt("goods_order_playFlag"));
            order.setContractFlag(rs.getInt("goods_order_contractFlag"));
            order.setAddress_id(rs.getInt("goods_order_address"));
            order.setAddress_content(rs.getString("user_address_content"));
            order.setAddress_person(rs.getString("user_address_name"));
            order.setAddress_tel(rs.getString("user_address_tel"));
            order.setSaveFlag(rs.getInt("goods_order_save"));
            order.setDirection(rs.getInt("goods_order_direction"));
            order.setDirection_person(rs.getString("goods_order_direction_person"));
            order.setDirection_id(rs.getInt("goods_order_direction_id"));
            order.setGoodsId(rs.getInt("goods_id"));
            order.setGoodsName(rs.getString("goods_name"));
            order.setPay_way(rs.getInt("goods_order_pay_way"));
            order.setDesc(rs.getString("goods_order_desc"));
            orderList.add(order);
        }
        this.jdbc.close();
        return orderList;
    }

    public List<CommonPojo> getSotreDataForEmployee(Integer emmployee_id) throws SQLException {
        ArrayList<CommonPojo> dataList = new ArrayList<CommonPojo>();
        ResultSet rs = null;
        String sql = "select d.* from store_data d where d.store_data_employee=?";
        rs = this.jdbc.executeQuery(sql, (Object)emmployee_id);
        CommonPojo data = null;
        while (rs.next()) {
            data = new CommonPojo();
            data.setId(Integer.valueOf(rs.getInt("store_data_store")));
            dataList.add(data);
        }
        this.jdbc.close();
        return dataList;
    }

    public List<Aunt> getOrderAunt(Integer pageNo, Integer pageSize) throws SQLException {
        if (pageNo < 1) {
            pageNo = 1;
        }
        int offset = (pageNo - 1) * pageSize;
        SimpleDateFormat format2 = new SimpleDateFormat("yyyy-MM-dd");
        Date dDate = new Date();
        String time = format2.format(dDate);
        time = String.valueOf(time) + " 00:00:00";
        String sql = "select aa.* from aunt aa where aa.aunt_id not in (select order_aunt.order_aunt_aunt from order_aunt,goods_order,order_aunt oa where '" + time + "'<oa.order_aunt_endate and order_aunt.order_aunt_aunt = aa.aunt_id and order_aunt.order_aunt_order = goods_order.goods_order_id or (oa.order_aunt_flag=0 AND oa.order_aunt_flag=2)) ";
        sql = String.valueOf(sql) + " limit " + offset + "," + pageSize;
        ResultSet rs = this.jdbc.executeQuery(sql);
        Aunt aunt = null;
        ArrayList<Aunt> auntList = new ArrayList<Aunt>();
        while (rs.next()) {
            aunt = new Aunt();
            aunt.setId(rs.getInt("aunt_id"));
            aunt.setName(rs.getString("aunt_name"));
            aunt.setTel(rs.getString("aunt_tel"));
            aunt.setNo(rs.getString("aunt_no"));
            aunt.setFlag(rs.getInt("aunt_flag"));
            aunt.setHead(rs.getString("aunt_head"));
            aunt.setType(rs.getInt("aunt_type"));
            aunt.setBirthday(rs.getString("aunt_birthday"));
            aunt.setDecretion(rs.getInt("aunt_decretion"));
            aunt.setDecretion_id(rs.getInt("aunt_decretion_id"));
            aunt.setDecretion_name(rs.getString("aunt_decretion_name"));
            aunt.setCon_enddate(rs.getString("aunt_con_enddate"));
            aunt.setCon_stardate(rs.getString("aunt_con_startdate"));
            auntList.add(aunt);
        }
        this.jdbc.close();
        return auntList;
    }

    public Integer getOrderAuntCount() throws SQLException {
        int resultCount = 0;
        ResultSet rs = null;
        SimpleDateFormat format2 = new SimpleDateFormat("yyyy-MM-dd");
        Date dDate = new Date();
        String time = format2.format(dDate);
        String sql = "select COUNT(*) AS rowcount from aunt aa where aa.aunt_id not in (select order_aunt.order_aunt_aunt from order_aunt,goods_order,order_aunt oa where '" + (time = String.valueOf(time) + " 00:00:00") + "'<oa.order_aunt_endate and order_aunt.order_aunt_aunt = aa.aunt_id and order_aunt.order_aunt_order = goods_order.goods_order_id or (oa.order_aunt_flag=0 AND oa.order_aunt_flag=2))";
        rs = this.jdbc.executeQuery(sql);
        if (rs.next()) {
            resultCount = rs.getInt("rowcount");
        }
        this.jdbc.close();
        return resultCount;
    }

    public String distributeAunt(Integer order_id, Integer aunt_id, String endDate, Integer flag) {
        Object[] args = new Object[]{order_id, aunt_id, endDate, flag};
        String sql = "insert into order_aunt (order_aunt_order,order_aunt_aunt,order_aunt_endate,order_aunt_flag) values(?,?,?,?)";
        int teflag = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (teflag > 0) {
            return "ok";
        }
        return "bad";
    }

    public List<Aunt> getAuntListForOrder(Integer order_id) throws SQLException {
        String sql = "select aa.* from aunt aa,goods_order go,order_aunt oa where oa.order_aunt_order=go.goods_order_id and oa.order_aunt_aunt=aa.aunt_id and go.goods_order_id=? order by oa.order_aunt_id desc";
        ResultSet rs = this.jdbc.executeQuery(sql, (Object)order_id);
        Aunt aunt = null;
        ArrayList<Aunt> auntList = new ArrayList<Aunt>();
        while (rs.next()) {
            aunt = new Aunt();
            aunt.setId(rs.getInt("aunt_id"));
            aunt.setName(rs.getString("aunt_name"));
            aunt.setTel(rs.getString("aunt_tel"));
            aunt.setNo(rs.getString("aunt_no"));
            aunt.setFlag(rs.getInt("aunt_flag"));
            aunt.setHead(rs.getString("aunt_head"));
            aunt.setType(rs.getInt("aunt_type"));
            aunt.setBirthday(rs.getString("aunt_birthday"));
            aunt.setDecretion(rs.getInt("aunt_decretion"));
            aunt.setDecretion_id(rs.getInt("aunt_decretion_id"));
            aunt.setDecretion_name(rs.getString("aunt_decretion_name"));
            aunt.setCon_enddate(rs.getString("aunt_con_enddate"));
            aunt.setCon_stardate(rs.getString("aunt_con_startdate"));
            auntList.add(aunt);
        }
        this.jdbc.close();
        return auntList;
    }

    public List<User> getUserListForStore(Integer pageNo, Integer pageSize, String ids) throws SQLException {
        ResultSet rs = null;
        if (pageNo < 1) {
            pageNo = 1;
        }
        int offset = (pageNo - 1) * pageSize;
        String sql = "select u.* from user u where u.user_store in (" + ids + ") order by u.user_id desc limit " + offset + "," + pageSize;
        rs = this.jdbc.executeQuery(sql);
        ArrayList<User> userList = new ArrayList<User>();
        User user = null;
        while (rs.next()) {
            user = new User();
            user.setId(rs.getInt("user_id"));
            user.setUsername(rs.getString("user_username"));
            user.setPass(rs.getString("user_pass"));
            user.setMd5(rs.getString("user_pass_md5"));
            user.setTel(rs.getString("user_tel"));
            user.setEmail(rs.getString("user_email"));
            user.setType(rs.getString("user_type"));
            user.setName(rs.getString("user_name"));
            user.setFlag(rs.getString("user_flag"));
            user.setFlagName(rs.getString("user_flag"));
            user.setMoney(rs.getDouble("user_money"));
            user.setIntegel(rs.getInt("user_integel"));
            user.setCard(rs.getString("user_card"));
            userList.add(user);
        }
        this.jdbc.close();
        return userList;
    }

    public Integer getUserForStoreCount(String ids) throws SQLException {
        int resultCount = 0;
        ResultSet rs = null;
        String sql = "select COUNT(*) AS rowcount from user u where u.user_store in (" + ids + ")";
        rs = this.jdbc.executeQuery(sql);
        if (rs.next()) {
            resultCount = rs.getInt("rowcount");
        }
        this.jdbc.close();
        return resultCount;
    }

    public String addUser(String username, String pass, String md5, String name, String tel, String email, String userflag, String userType, String money, String integal, String card, Integer store_id) {
        Object[] args = new Object[]{username, pass, md5, name, tel, email, userflag, userType, money, integal, card, store_id};
        String sql = "insert into user (user_username,user_pass,user_pass_md5,user_name,user_tel,user_email,user_flag,user_type,user_money,user_integel,user_card,user_store) values(?,?,?,?,?,?,?,?,?,?,?,?)";
        int flag = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public String updateUser(String userflag, String userType, String email, String name, String id) {
        Object[] args = new Object[]{userflag, userType, email, name, id};
        String sql = "update user SET user_flag=?,user_type=?,user_email=?,user_name=? where user_id=?";
        int flag = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public List<ThematicActivity> goThematicActivity(Integer pageNo, Integer pageSize, Integer flag, String cerrentDate) throws SQLException {
        ResultSet rs = null;
        if (pageNo < 1) {
            pageNo = 1;
        }
        int offset = (pageNo - 1) * pageSize;
        String sql = "select t.* from thematic_activity t where t.thematic_activity_id!=0 ";
        if (flag != null) {
            sql = String.valueOf(sql) + " and t.thematic_activity_flag=" + flag + " ";
        }
        if (cerrentDate != null && !cerrentDate.equals("")) {
            sql = String.valueOf(sql) + " and t.thematic_activity_startdate<='" + cerrentDate + "' and t.thematic_activity_enddate>='" + cerrentDate + "' ";
        }
        sql = String.valueOf(sql) + " order by t.thematic_activity_id desc limit " + offset + "," + pageSize;
        rs = this.jdbc.executeQuery(sql);
        ArrayList<ThematicActivity> activityList = new ArrayList<ThematicActivity>();
        ThematicActivity activity = null;
        while (rs.next()) {
            activity = new ThematicActivity();
            activity.setId(rs.getInt("thematic_activity_id"));
            activity.setName(rs.getString("thematic_activity_name"));
            activity.setTitle(rs.getString("thematic_activity_title"));
            activity.setKeywords(rs.getString("thematic_activity_keywords"));
            activity.setDesc(rs.getString("thematic_activity_desc"));
            activity.setFlag(rs.getInt("thematic_activity_flag"));
            activity.setImg(rs.getString("thematic_activity_img"));
            activity.setLongdesc(rs.getString("thematic_activity_longdesc"));
            activity.setStartDate(rs.getString("thematic_activity_startdate"));
            activity.setEndDate(rs.getString("thematic_activity_enddate"));
            activity.setTemplate(rs.getString("thematic_activity_template"));
            activity.setStyle(rs.getString("thematic_activity_style"));
            activityList.add(activity);
        }
        this.jdbc.close();
        return activityList;
    }

    public Integer goThematicActivityCount(Integer flag, String cerrentDate) throws SQLException {
        int resultCount = 0;
        ResultSet rs = null;
        String sql = "select COUNT(*) AS rowcount from thematic_activity t where t.thematic_activity_id!=0 ";
        if (flag != null) {
            sql = String.valueOf(sql) + " and t.thematic_activity_flag=" + flag + " ";
        }
        if (cerrentDate != null && !cerrentDate.equals("")) {
            sql = String.valueOf(sql) + " and t.thematic_activity_startdate<='" + cerrentDate + "' and t.thematic_activity_enddate>='" + cerrentDate + "' ";
        }
        if ((rs = this.jdbc.executeQuery(sql)).next()) {
            resultCount = rs.getInt("rowcount");
        }
        this.jdbc.close();
        return resultCount;
    }

    public Integer addThematicActivity(String name, String title, String keywords, String desc, String style, String template, String startDate, String endDate, String img) {
        Object[] args = new Object[]{name, title, keywords, desc, style, template, startDate, endDate, img};
        String sql = "insert into thematic_activity (thematic_activity_name,thematic_activity_title,thematic_activity_keywords,thematic_activity_desc,thematic_activity_style,thematic_activity_template,thematic_activity_startdate,thematic_activity_enddate,thematic_activity_img) values(?,?,?,?,?,?,?,?,?)";
        Serializable teflag = this.jdbc.insertBackId(sql, args);
        this.jdbc.close();
        return teflag.hashCode();
    }

    public String updateThematicLongtext(Integer thematic_id, String longtext) {
        Object[] args = new Object[]{longtext, thematic_id};
        String sql = "update thematic_activity SET thematic_activity_longdesc=? where thematic_activity_id=?";
        int flag = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public String updateThematicFlag(Integer thematic_id, Integer flag) {
        Object[] args = new Object[]{flag, thematic_id};
        String sql = "update thematic_activity SET thematic_activity_flag=? where thematic_activity_id=?";
        int teflag = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (teflag > 0) {
            return "ok";
        }
        return "bad";
    }

    public String deleteThematic(String ids) {
        String sql = "delete from thematic_activity where thematic_activity_id in (" + ids + ")";
        int flag = this.jdbc.executeUpdate(sql);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public String addThematicGoods(Integer thematic_id, Integer goods_id, String price) {
        Object[] args = new Object[]{goods_id, thematic_id, price};
        String sql = "insert into thematic_activity_goods (thematic_activity_goods_goodsid,thematic_activity_goods_activityid,thematic_activity_goods_price) values(?,?,?)";
        int flag = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public ThematicActivity getThematicById(Integer thematic_id) throws SQLException {
        String sql = "select ta.* from thematic_activity ta where ta.thematic_activity_id=?";
        ResultSet rs = this.jdbc.executeQuery(sql, (Object)thematic_id);
        ThematicActivity activity = null;
        if (rs.next()) {
            activity = new ThematicActivity();
            activity.setId(rs.getInt("thematic_activity_id"));
            activity.setName(rs.getString("thematic_activity_name"));
            activity.setTitle(rs.getString("thematic_activity_title"));
            activity.setKeywords(rs.getString("thematic_activity_keywords"));
            activity.setDesc(rs.getString("thematic_activity_desc"));
            activity.setFlag(rs.getInt("thematic_activity_flag"));
            activity.setImg(rs.getString("thematic_activity_img"));
            activity.setLongdesc(rs.getString("thematic_activity_longdesc"));
            activity.setStartDate(rs.getString("thematic_activity_startdate"));
            activity.setEndDate(rs.getString("thematic_activity_enddate"));
            activity.setTemplate(rs.getString("thematic_activity_template"));
            activity.setStyle(rs.getString("thematic_activity_style"));
            String goodsSql = "select g.goods_id,g.goods_name,g.goods_thumb,g.shop_price,cmg.thematic_activity_goods_price from thematic_activity ta,goods g,thematic_activity_goods cmg where cmg.thematic_activity_goods_goodsid=g.goods_id and cmg.thematic_activity_goods_activityid=ta.thematic_activity_id and ta.thematic_activity_id=?";
            ResultSet rsGoods = this.jdbc.executeQuery(goodsSql, (Object)activity.getId());
            ArrayList<GoodsPojo> goodsList = new ArrayList<GoodsPojo>();
            GoodsPojo goodsTem = null;
            while (rsGoods.next()) {
                goodsTem = new GoodsPojo();
                goodsTem.setGoodsId(rsGoods.getInt("goods_id"));
                goodsTem.setGoodsName(rsGoods.getString("goods_name"));
                goodsTem.setGoodsThumb(rsGoods.getString("goods_thumb"));
                goodsTem.setShopPrice(rsGoods.getString("thematic_activity_goods_price"));
                goodsList.add(goodsTem);
            }
            String cmssql = "select c.cms_id,c.cms_name,c.cms_time,c.cms_suroce,c.cms_peron,c.cms_img,c.cms_keyword,c.cms_description from cms c,thematic_activity_cms tac,thematic_activity ta where tac.thematic_activity_cms_cmsid=c.cms_id and ta.thematic_activity_id=tac.thematic_activity_cms_thematicid and tac.thematic_activity_cms_thematicid=?";
            ResultSet rsCms = this.jdbc.executeQuery(cmssql, (Object)activity.getId());
            ArrayList<Cms> cmsList = new ArrayList<Cms>();
            Cms cms = null;
            while (rsCms.next()) {
                cms = new Cms();
                cms.setId(Integer.valueOf(rsCms.getInt("cms_id")));
                cms.setName(rsCms.getString("cms_name"));
                cms.setTime(rsCms.getString("cms_time"));
                cms.setSuroce(rsCms.getString("cms_suroce"));
                cms.setPerson(rsCms.getString("cms_peron"));
                cms.setImg(rsCms.getString("cms_img"));
                cms.setKeyword(rsCms.getString("cms_keyword"));
                cms.setDescription(rsCms.getString("cms_description"));
                cmsList.add(cms);
            }
            activity.setCmsList(cmsList);
            activity.setGoodsList(goodsList);
            List<AuntImg> imgList = this.getAuntImgByAunt(activity.getId(), "ta");
            activity.setImgList(imgList);
        }
        this.jdbc.close();
        return activity;
    }

    public String deleteThematicGoods(String ids) {
        String sql = "delete from thematic_activity_goods where thematic_activity_goods_activityid in (" + ids + ")";
        int flag = this.jdbc.executeUpdate(sql);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public String deleteThematicActivity(String ids) {
        this.deleteCombineMarketGoods(ids);
        String sql = "delete from thematic_activity where thematic_activity_id in (" + ids + ")";
        int flag = this.jdbc.executeUpdate(sql);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public String addThematicCms(Integer thematic_id, Integer cms_id) {
        Object[] args = new Object[]{cms_id, thematic_id};
        String sql = "insert into thematic_activity_cms (thematic_activity_cms_cmsid,thematic_activity_cms_thematicid) values(?,?)";
        int flag = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public String deleteThematicCms(String ids) {
        this.deleteCombineMarketGoods(ids);
        String sql = "delete from thematic_activity_cms where thematic_activity_cms_thematicid in (" + ids + ")";
        int flag = this.jdbc.executeUpdate(sql);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }
}

